require 'cgi-lib'
require 'drb'
require 'uri'

module Borges; end
require 'Borges/RequestHandler/RequestHandler'
require 'Borges/RequestHandler/Registry'
require 'Borges/Utilities/Request'
require 'Borges/Utilities/Response'
require 'Borges/DRb'

DRb.start_service

##
# Borges::CGIDRbClient allows Borges to be run via CGI.
# To use Borges via CGI, copy:
# 
# /usr/local/share/examples/ruby/Borges/borges-cgi
# 
# to:
# cgi-bin/borges 
# 
# Then run:
# 
# /usr/local/lib/ruby/site_ruby-1.8/Borges/DRbServer.rb
# 
# A Borges server will start listening on the local machine.
# The CGI client will send a request to the Borges server, which
# will process it and hand a response back to the CGI client,
# which will return the page to the user.

module Borges::CGIDRbClient

  ##
  # HTTP1.1 Status lines (not in cgi-lib.rb)
  HTTP_STATUS = {
    100 => "100 Continue",
    101 => "101 Switching Protocols",
    200 => "200 OK",
    201 => "201 Created",
    202 => "202 Accepted",
    203 => "203 Non-Authoritative Information",
    204 => "204 No Content",
    205 => "205 Reset Content",
    206 => "206 Partial Content",
    300 => "300 Multiple Choices",
    301 => "301 Moved Permanently",
    302 => "302 Moved Temporarily",
    303 => "303 See Other",
    304 => "304 Not Modified",
    305 => "305 Use Proxy",
    400 => "400 Bad Request",
    401 => "401 Unauthorized",
    402 => "402 Payment Required",
    403 => "403 Forbidden",
    404 => "404 Not Found",
    405 => "405 Method Not Allowed",
    406 => "406 Not Acceptable",
    407 => "407 Proxy Authentication Required",
    408 => "408 Request Timeout",
    409 => "409 Conflict",
    410 => "410 Gone",
    411 => "411 Length Required",
    412 => "412 Precondition Failed",
    413 => "413 Request Entity Too Large",
    414 => "414 Request-URI Too Long",
    415 => "415 Unsupported Media Type",
    500 => "500 Internal Server Error",
    501 => "501 Not Implemented",
    502 => "502 Bad Gateway",
    503 => "503 Service Unavailable",
    504 => "504 Gateway Timeout",
    505 => "505 HTTP Version Not Supported",
  } 

  ##
  # Take a request from the server and pass it to the Borges
  # server for processing, then create the appropriate HTTP
  # response.

  def self.handle_request
    res = nil
    err = nil

    begin
      cgi = CGI.new
      path = URI.parse("http://f" + ENV["REQUEST_URI"]).path
      req = Borges::Request.new(path, ENV.to_hash, cgi.inputs, cgi.cookie)

      res = Borges::DRb.handle_request(req)
    rescue Exception => err
    ensure
      unless res.nil? then
        puts "Status: #{HTTP_STATUS[res.status]}"
        headers = []
        res.headers.each do |header, val|
          headers << "#{header}: #{val}"
        end

        puts CGI.header(headers)
        puts res.contents # Publish generated contents
      else
        puts "Status: #{HTTP_STATUS[500]}"
        puts "Content-Type: text/plain\r\n\r\n"
        puts err
        puts err.backtrace
      end
    end
  end

end # class Borges::CGIDRbClient

