#include <stdlib.h>
#include "internal.h"

/*
 * This list of stop words is taken from
 *
 *     http://snowball.tartarus.org/
 *
 * Many thanks to Martin Porter
 */

const char *ENGLISH_STOP_WORDS[] = {
    "a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in",
    "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the",
    "their", "then", "there", "these", "they", "this", "to", "was", "with",
    NULL
};

const char *FULL_ENGLISH_STOP_WORDS[] = {
    "a", "about", "above", "after", "again", "against", "all", "am", "an",
    "and", "any", "are", "aren't", "as", "at", "be", "because", "been",
    "before", "being", "below", "between", "both", "but", "by", "cannot",
    "can't", "could", "couldn't", "did", "didn't", "do", "does", "doesn't",
    "doing", "don't", "down", "during", "each", "few", "for", "from",
    "further", "had", "hadn't", "has", "hasn't", "have", "haven't", "having",
    "he", "he'd", "he'll", "her", "here", "here's", "hers", "herself", "he's",
    "him", "himself", "his", "how", "how's", "i", "i'd", "if", "i'll", "i'm",
    "in", "into", "is", "isn't", "it", "its", "it's", "itself", "i've",
    "let's", "me", "more", "most", "mustn't", "my", "myself", "no", "nor",
    "not", "of", "off", "on", "once", "only", "or", "other", "ought", "our",
    "ours", "ourselves", "out", "over", "own", "same", "shan't", "she",
    "she'd", "she'll", "she's", "should", "shouldn't", "so", "some", "such",
    "than", "that", "that's", "the", "their", "theirs", "them", "themselves",
    "then", "there", "there's", "these", "they", "they'd", "they'll",
    "they're", "they've", "this", "those", "through", "to", "too", "under",
    "until", "up", "very", "was", "wasn't", "we", "we'd", "we'll", "were",
    "we're", "weren't", "we've", "what", "what's", "when", "when's", "where",
    "where's", "which", "while", "who", "whom", "who's", "why", "why's",
    "with", "won't", "would", "wouldn't", "you", "you'd", "you'll", "your",
    "you're", "yours", "yourself", "yourselves", "you've",
    NULL
};

const char *EXTENDED_ENGLISH_STOP_WORDS[] = {
    "a", "about", "above", "after", "again", "against", "all", "am", "an",
    "and", "any", "are", "aren't", "as", "at", "be", "because", "been",
    "before", "being", "below", "between", "both", "but", "by", "cannot",
    "can't", "could", "couldn't", "did", "didn't", "do", "does", "doesn't",
    "doing", "don't", "down", "during", "each", "few", "for", "from",
    "further", "had", "hadn't", "has", "hasn't", "have", "haven't", "having",
    "he", "he'd", "he'll", "her", "here", "here's", "hers", "herself", "he's",
    "him", "himself", "his", "how", "how's", "i", "i'd", "if", "i'll", "i'm",
    "in", "into", "is", "isn't", "it", "its", "it's", "itself", "i've",
    "let's", "me", "more", "most", "mustn't", "my", "myself", "no", "nor",
    "not", "of", "off", "on", "once", "only", "or", "other", "ought", "our",
    "ours", "ourselves", "out", "over", "own", "same", "shan't", "she",
    "she'd", "she'll", "she's", "should", "shouldn't", "so", "some", "such",
    "than", "that", "that's", "the", "their", "theirs", "them", "themselves",
    "then", "there", "there's", "these", "they", "they'd", "they'll",
    "they're", "they've", "this", "those", "through", "to", "too", "under",
    "until", "up", "very", "was", "wasn't", "we", "we'd", "we'll", "were",
    "we're", "weren't", "we've", "what", "what's", "when", "when's", "where",
    "where's", "which", "while", "who", "whom", "who's", "why", "why's",
    "with", "won't", "would", "wouldn't", "you", "you'd", "you'll", "your",
    "you're", "yours", "yourself", "yourselves", "you've",

    /* Most common words in the English Language */
    "one", "every", "least", "less", "many", "now", "ever", "never", "say",
    "says", "said", "also", "get", "go", "goes", "just", "made", "make",
    "put", "see", "seen", "whether", "like", "well", "back", "even", "still",
    "way", "take", "since", "another", "however", "two", "three", "four",
    "five", "first", "second", "new", "old", "high", "long",
    NULL
};

const char *FULL_FRENCH_STOP_WORDS[] = {
    "au", "aux", "avec", "ce", "ces", "dans", "de", "des", "du", "elle", "en",
    "et", "eux", "il", "je", "la", "le", "leur", "lui", "ma", "mais", "me",
    "même", "mes", "moi", "mon", "ne", "nos", "notre", "nous", "on", "ou",
    "par", "pas", "pour", "qu", "que", "qui", "sa", "se", "ses", "son", "sur",
    "ta", "te", "tes", "toi", "ton", "tu", "un", "une", "vos", "votre",
    "vous", "c", "d", "j", "l", "à", "m", "n", "s", "t", "y", "été", "étée",
    "étées", "étés", "étant", "étante", "étants", "étantes", "suis", "es",
    "est", "sommes", "êtes", "sont", "serai", "seras", "sera", "serons",
    "serez", "seront", "serais", "serait", "serions", "seriez", "seraient",
    "étais", "était", "étions", "étiez", "étaient", "fus", "fut", "fûmes",
    "fûtes", "furent", "sois", "soit", "soyons", "soyez", "soient", "fusse",
    "fusses", "fût", "fussions", "fussiez", "fussent", "ayant", "ayante",
    "ayantes", "ayants", "eu", "eue", "eues", "eus", "ai", "as", "avons",
    "avez", "ont", "aurai", "auras", "aura", "aurons", "aurez", "auront",
    "aurais", "aurait", "aurions", "auriez", "auraient", "avais", "avait",
    "avions", "aviez", "avaient", "eut", "eûmes", "eûtes", "eurent", "aie",
    "aies", "ait", "ayons", "ayez", "aient", "eusse", "eusses", "eût",
    "eussions", "eussiez", "eussent",
    NULL
};

const char *FULL_SPANISH_STOP_WORDS[] = {
    "de", "la", "que", "el", "en", "y", "a", "los", "del", "se", "las", "por",
    "un", "para", "con", "no", "una", "su", "al", "lo", "como", "más", "pero",
    "sus", "le", "ya", "o", "este", "sí", "porque", "esta", "entre", "cuando",
    "muy", "sin", "sobre", "también", "me", "hasta", "hay", "donde", "quien",
    "desde", "todo", "nos", "durante", "todos", "uno", "les", "ni", "contra",
    "otros", "ese", "eso", "ante", "ellos", "e", "esto", "mí", "antes",
    "algunos", "qué", "unos", "yo", "otro", "otras", "otra", "él", "tanto",
    "esa", "estos", "mucho", "quienes", "nada", "muchos", "cual", "poco",
    "ella", "estar", "estas", "algunas", "algo", "nosotros", "mi", "mis",
    "tú", "te", "ti", "tu", "tus", "ellas", "nosotras", "vosostros",
    "vosostras", "os", "mío", "mía", "míos", "mías", "tuyo", "tuya", "tuyos",
    "tuyas", "suyo", "suya", "suyos", "suyas", "nuestro", "nuestra",
    "nuestros", "nuestras", "vuestro", "vuestra", "vuestros", "vuestras",
    "esos", "esas", "estoy", "estás", "está", "estamos", "estáis", "están",
    "esté", "estés", "estemos", "estéis", "estén", "estaré", "estarás",
    "estará", "estaremos", "estaréis", "estarán", "estaría", "estarías",
    "estaríamos", "estaríais", "estarían", "estaba", "estabas", "estábamos",
    "estabais", "estaban", "estuve", "estuviste", "estuvo", "estuvimos",
    "estuvisteis", "estuvieron", "estuviera", "estuvieras", "estuviéramos",
    "estuvierais", "estuvieran", "estuviese", "estuvieses", "estuviésemos",
    "estuvieseis", "estuviesen", "estando", "estado", "estada", "estados",
    "estadas", "estad", "he", "has", "ha", "hemos", "habéis", "han", "haya",
    "hayas", "hayamos", "hayáis", "hayan", "habré", "habrás", "habrá",
    "habremos", "habréis", "habrán", "habría", "habrías", "habríamos",
    "habríais", "habrían", "había", "habías", "habíamos", "habíais", "habían",
    "hube", "hubiste", "hubo", "hubimos", "hubisteis", "hubieron", "hubiera",
    "hubieras", "hubiéramos", "hubierais", "hubieran", "hubiese", "hubieses",
    "hubiésemos", "hubieseis", "hubiesen", "habiendo", "habido", "habida",
    "habidos", "habidas", "soy", "eres", "es", "somos", "sois", "son", "sea",
    "seas", "seamos", "seáis", "sean", "seré", "serás", "será", "seremos",
    "seréis", "serán", "sería", "serías", "seríamos", "seríais", "serían",
    "era", "eras", "éramos", "erais", "eran", "fui", "fuiste", "fue",
    "fuimos", "fuisteis", "fueron", "fuera", "fueras", "fuéramos", "fuerais",
    "fueran", "fuese", "fueses", "fuésemos", "fueseis", "fuesen", "sintiendo",
    "sentido", "sentida", "sentidos", "sentidas", "siente", "sentid", "tengo",
    "tienes", "tiene", "tenemos", "tenéis", "tienen", "tenga", "tengas",
    "tengamos", "tengáis", "tengan", "tendré", "tendrás", "tendrá",
    "tendremos", "tendréis", "tendrán", "tendría", "tendrías", "tendríamos",
    "tendríais", "tendrían", "tenía", "tenías", "teníamos", "teníais",
    "tenían", "tuve", "tuviste", "tuvo", "tuvimos", "tuvisteis", "tuvieron",
    "tuviera", "tuvieras", "tuviéramos", "tuvierais", "tuvieran", "tuviese",
    "tuvieses", "tuviésemos", "tuvieseis", "tuviesen", "teniendo", "tenido",
    "tenida", "tenidos", "tenidas", "tened",
    NULL
};

const char *FULL_PORTUGUESE_STOP_WORDS[] = {
    "de", "a", "o", "que", "e", "do", "da", "em", "um", "para", "com", "não",
    "uma", "os", "no", "se", "na", "por", "mais", "as", "dos", "como", "mas",
    "ao", "ele", "das", "à", "seu", "sua", "ou", "quando", "muito", "nos",
    "já", "eu", "também", "só", "pelo", "pela", "até", "isso", "ela", "entre",
    "depois", "sem", "mesmo", "aos", "seus", "quem", "nas", "me", "esse",
    "eles", "você", "essa", "num", "nem", "suas", "meu", "às", "minha",
    "numa", "pelos", "elas", "qual", "nós", "lhe", "deles", "essas", "esses",
    "pelas", "este", "dele", "tu", "te", "vocês", "vos", "lhes", "meus",
    "minhas", "teu", "tua", "teus", "tuas", "nosso", "nossa", "nossos",
    "nossas", "dela", "delas", "esta", "estes", "estas", "aquele", "aquela",
    "aqueles", "aquelas", "isto", "aquilo", "estou", "está", "estamos",
    "estão", "estive", "esteve", "estivemos", "estiveram", "estava",
    "estávamos", "estavam", "estivera", "estivéramos", "esteja", "estejamos",
    "estejam", "estivesse", "estivéssemos", "estivessem", "estiver",
    "estivermos", "estiverem", "hei", "há", "havemos", "hão", "houve",
    "houvemos", "houveram", "houvera", "houvéramos", "haja", "hajamos",
    "hajam", "houvesse", "houvéssemos", "houvessem", "houver", "houvermos",
    "houverem", "houverei", "houverá", "houveremos", "houverão", "houveria",
    "houveríamos", "houveriam", "sou", "somos", "são", "era", "éramos",
    "eram", "fui", "foi", "fomos", "foram", "fora", "fôramos", "seja",
    "sejamos", "sejam", "fosse", "fôssemos", "fossem", "for", "formos",
    "forem", "serei", "será", "seremos", "serão", "seria", "seríamos",
    "seriam", "tenho", "tem", "temos", "tém", "tinha", "tínhamos", "tinham",
    "tive", "teve", "tivemos", "tiveram", "tivera", "tivéramos", "tenha",
    "tenhamos", "tenham", "tivesse", "tivéssemos", "tivessem", "tiver",
    "tivermos", "tiverem", "terei", "terá", "teremos", "terão", "teria",
    "teríamos", "teriam",
    NULL
};

const char *FULL_ITALIAN_STOP_WORDS[] = {
    "ad", "al", "allo", "ai", "agli", "all", "agl", "alla", "alle", "con",
    "col", "coi", "da", "dal", "dallo", "dai", "dagli", "dall", "dagl",
    "dalla", "dalle", "di", "del", "dello", "dei", "degli", "dell", "degl",
    "della", "delle", "in", "nel", "nello", "nei", "negli", "nell", "negl",
    "nella", "nelle", "su", "sul", "sullo", "sui", "sugli", "sull", "sugl",
    "sulla", "sulle", "per", "tra", "contro", "io", "tu", "lui", "lei", "noi",
    "voi", "loro", "mio", "mia", "miei", "mie", "tuo", "tua", "tuoi", "tue",
    "suo", "sua", "suoi", "sue", "nostro", "nostra", "nostri", "nostre",
    "vostro", "vostra", "vostri", "vostre", "mi", "ti", "ci", "vi", "lo",
    "la", "li", "le", "gli", "ne", "il", "un", "uno", "una", "ma", "ed", "se",
    "perché", "anche", "come", "dov", "dove", "che", "chi", "cui", "non",
    "più", "quale", "quanto", "quanti", "quanta", "quante", "quello",
    "quelli", "quella", "quelle", "questo", "questi", "questa", "queste",
    "si", "tutto", "tutti", "a", "c", "e", "i", "l", "o", "ho", "hai", "ha",
    "abbiamo", "avete", "hanno", "abbia", "abbiate", "abbiano", "avrò",
    "avrai", "avrà", "avremo", "avrete", "avranno", "avrei", "avresti",
    "avrebbe", "avremmo", "avreste", "avrebbero", "avevo", "avevi", "aveva",
    "avevamo", "avevate", "avevano", "ebbi", "avesti", "ebbe", "avemmo",
    "aveste", "ebbero", "avessi", "avesse", "avessimo", "avessero", "avendo",
    "avuto", "avuta", "avuti", "avute", "sono", "sei", "è", "siamo", "siete",
    "sia", "siate", "siano", "sarò", "sarai", "sarà", "saremo", "sarete",
    "saranno", "sarei", "saresti", "sarebbe", "saremmo", "sareste",
    "sarebbero", "ero", "eri", "era", "eravamo", "eravate", "erano", "fui",
    "fosti", "fu", "fummo", "foste", "furono", "fossi", "fosse", "fossimo",
    "fossero", "essendo", "faccio", "fai", "facciamo", "fanno", "faccia",
    "facciate", "facciano", "farò", "farai", "farà", "faremo", "farete",
    "faranno", "farei", "faresti", "farebbe", "faremmo", "fareste",
    "farebbero", "facevo", "facevi", "faceva", "facevamo", "facevate",
    "facevano", "feci", "facesti", "fece", "facemmo", "faceste", "fecero",
    "facessi", "facesse", "facessimo", "facessero", "facendo", "sto", "stai",
    "sta", "stiamo", "stanno", "stia", "stiate", "stiano", "starò", "starai",
    "starà", "staremo", "starete", "staranno", "starei", "staresti",
    "starebbe", "staremmo", "stareste", "starebbero", "stavo", "stavi",
    "stava", "stavamo", "stavate", "stavano", "stetti", "stesti", "stette",
    "stemmo", "steste", "stettero", "stessi", "stesse", "stessimo",
    "stessero", "stando",
    NULL
};

const char *FULL_GERMAN_STOP_WORDS[] = {
    "aber", "alle", "allem", "allen", "aller", "alles", "als", "also", "am",
    "an", "ander", "andere", "anderem", "anderen", "anderer", "anderes",
    "anderm", "andern", "anderr", "anders", "auch", "auf", "aus", "bei",
    "bin", "bis", "bist", "da", "damit", "dann", "der", "den", "des", "dem",
    "die", "das", "daß", "derselbe", "derselben", "denselben", "desselben",
    "demselben", "dieselbe", "dieselben", "dasselbe", "dazu", "dein", "deine",
    "deinem", "deinen", "deiner", "deines", "denn", "derer", "dessen", "dich",
    "dir", "du", "dies", "diese", "diesem", "diesen", "dieser", "dieses",
    "doch", "dort", "durch", "ein", "eine", "einem", "einen", "einer",
    "eines", "einig", "einige", "einigem", "einigen", "einiger", "einiges",
    "einmal", "er", "ihn", "ihm", "es", "etwas", "euer", "eure", "eurem",
    "euren", "eurer", "eures", "für", "gegen", "gewesen", "hab", "habe",
    "haben", "hat", "hatte", "hatten", "hier", "hin", "hinter", "ich", "mich",
    "mir", "ihr", "ihre", "ihrem", "ihren", "ihrer", "ihres", "euch", "im",
    "in", "indem", "ins", "ist", "jede", "jedem", "jeden", "jeder", "jedes",
    "jene", "jenem", "jenen", "jener", "jenes", "jetzt", "kann", "kein",
    "keine", "keinem", "keinen", "keiner", "keines", "können", "könnte",
    "machen", "man", "manche", "manchem", "manchen", "mancher", "manches",
    "mein", "meine", "meinem", "meinen", "meiner", "meines", "mit", "muss",
    "musste", "nach", "nicht", "nichts", "noch", "nun", "nur", "ob", "oder",
    "ohne", "sehr", "sein", "seine", "seinem", "seinen", "seiner", "seines",
    "selbst", "sich", "sie", "ihnen", "sind", "so", "solche", "solchem",
    "solchen", "solcher", "solches", "soll", "sollte", "sondern", "sonst",
    "über", "um", "und", "uns", "unse", "unsem", "unsen", "unser", "unses",
    "unter", "viel", "vom", "von", "vor", "während", "war", "waren", "warst",
    "was", "weg", "weil", "weiter", "welche", "welchem", "welchen", "welcher",
    "welches", "wenn", "werde", "werden", "wie", "wieder", "will", "wir",
    "wird", "wirst", "wo", "wollen", "wollte", "würde", "würden", "zu", "zum",
    "zur", "zwar", "zwischen",
    NULL
};

const char *FULL_DUTCH_STOP_WORDS[] = {
    "de", "en", "van", "ik", "te", "dat", "die", "in", "een", "hij", "het",
    "niet", "zijn", "is", "was", "op", "aan", "met", "als", "voor", "had",
    "er", "maar", "om", "hem", "dan", "zou", "of", "wat", "mijn", "men",
    "dit", "zo", "door", "over", "ze", "zich", "bij", "ook", "tot", "je",
    "mij", "uit", "der", "daar", "haar", "naar", "heb", "hoe", "heeft",
    "hebben", "deze", "u", "want", "nog", "zal", "me", "zij", "nu", "ge",
    "geen", "omdat", "iets", "worden", "toch", "al", "waren", "veel", "meer",
    "doen", "toen", "moet", "ben", "zonder", "kan", "hun", "dus", "alles",
    "onder", "ja", "eens", "hier", "wie", "werd", "altijd", "doch", "wordt",
    "wezen", "kunnen", "ons", "zelf", "tegen", "na", "reeds", "wil", "kon",
    "niets", "uw", "iemand", "geweest", "andere",
    NULL
};

const char *FULL_SWEDISH_STOP_WORDS[] = {
    "och", "det", "att", "i", "en", "jag", "hon", "som", "han", "på", "den",
    "med", "var", "sig", "för", "så", "till", "är", "men", "ett", "om",
    "hade", "de", "av", "icke", "mig", "du", "henne", "då", "sin", "nu",
    "har", "inte", "hans", "honom", "skulle", "hennes", "där", "min", "man",
    "ej", "vid", "kunde", "något", "från", "ut", "när", "efter", "upp", "vi",
    "dem", "vara", "vad", "över", "än", "dig", "kan", "sina", "här", "ha",
    "mot", "alla", "under", "någon", "eller", "allt", "mycket", "sedan", "ju",
    "denna", "själv", "detta", "åt", "utan", "varit", "hur", "ingen", "mitt",
    "ni", "bli", "blev", "oss", "din", "dessa", "några", "deras", "blir",
    "mina", "samma", "vilken", "er", "sådan", "vår", "blivit", "dess", "inom",
    "mellan", "sådant", "varför", "varje", "vilka", "ditt", "vem", "vilket",
    "sitta", "sådana", "vart", "dina", "vars", "vårt", "våra", "ert", "era",
    "vilkas",
    NULL
};


const char *FULL_NORWEGIAN_STOP_WORDS[] = {
    "og", "i", "jeg", "det", "at", "en", "et", "den", "til", "er", "som",
    "på", "de", "med", "han", "av", "ikke", "ikkje", "der", "så", "var",
    "meg", "seg", "men", "ett", "har", "om", "vi", "min", "mitt", "ha",
    "hadde", "hun", "nå", "over", "da", "ved", "fra", "du", "ut", "sin",
    "dem", "oss", "opp", "man", "kan", "hans", "hvor", "eller", "hva", "skal",
    "selv", "sjøl", "her", "alle", "vil", "bli", "ble", "blei", "blitt",
    "kunne", "inn", "når", "være", "kom", "noen", "noe", "ville", "dere",
    "som", "deres", "kun", "ja", "etter", "ned", "skulle", "denne", "for",
    "deg", "si", "sine", "sitt", "mot", "å", "meget", "hvorfor", "dette",
    "disse", "uten", "hvordan", "ingen", "din", "ditt", "blir", "samme",
    "hvilken", "hvilke", "sånn", "inni", "mellom", "vår", "hver", "hvem",
    "vors", "hvis", "både", "bare", "enn", "fordi", "før", "mange", "også",
    "slik", "vært", "være", "båe", "begge", "siden", "dykk", "dykkar", "dei",
    "deira", "deires", "deim", "di", "då", "eg", "ein", "eit", "eitt",
    "elles", "honom", "hjå", "ho", "hoe", "henne", "hennar", "hennes", "hoss",
    "hossen", "ikkje", "ingi", "inkje", "korleis", "korso", "kva", "kvar",
    "kvarhelst", "kven", "kvi", "kvifor", "me", "medan", "mi", "mine",
    "mykje", "no", "nokon", "noka", "nokor", "noko", "nokre", "si", "sia",
    "sidan", "so", "somt", "somme", "um", "upp", "vere", "vore", "verte",
    "vort", "varte", "vart",
    NULL
};

const char *FULL_DANISH_STOP_WORDS[] = {
    "og", "i", "jeg", "det", "at", "en", "den", "til", "er", "som", "på",
    "de", "med", "han", "af", "for", "ikke", "der", "var", "mig", "sig",
    "men", "et", "har", "om", "vi", "min", "havde", "ham", "hun", "nu",
    "over", "da", "fra", "du", "ud", "sin", "dem", "os", "op", "man", "hans",
    "hvor", "eller", "hvad", "skal", "selv", "her", "alle", "vil", "blev",
    "kunne", "ind", "når", "være", "dog", "noget", "ville", "jo", "deres",
    "efter", "ned", "skulle", "denne", "end", "dette", "mit", "også", "under",
    "have", "dig", "anden", "hende", "mine", "alt", "meget", "sit", "sine",
    "vor", "mod", "disse", "hvis", "din", "nogle", "hos", "blive", "mange",
    "ad", "bliver", "hendes", "været", "thi", "jer", "sådan",
    NULL
};

const char *FULL_RUSSIAN_STOP_WORDS[] = {
    "а", "без", "более", "бы", "был", "была", "были", "было", "быть", "в",
    "вам", "вас", "весь", "во", "вот", "все", "всего", "всех", "вы", "где",
    "да", "даже", "для", "до", "его", "ее", "ей", "ею", "если", "есть", "еще",
    "же", "за", "здесь", "и", "из", "или", "им", "их", "к", "как", "ко",
    "когда", "кто", "ли", "либо", "мне", "может", "мы", "на", "надо", "наш",
    "не", "него", "нее", "нет", "ни", "них", "но", "ну", "о", "об", "однако",
    "он", "она", "они", "оно", "от", "очень", "по", "под", "при", "с", "со",
    "так", "также", "такой", "там", "те", "тем", "то", "того", "тоже", "той",
    "только", "том", "ты", "у", "уже", "хотя", "чего", "чей", "чем", "что",
    "чтобы", "чье", "чья", "эта", "эти", "это", "я",
    NULL
};

const char *FULL_RUSSIAN_STOP_WORDS_KOI8_R[] = {
    "Á", "ÂÅÚ", "ÂÏÌÅÅ", "ÂÙ", "ÂÙÌ", "ÂÙÌÁ", "ÂÙÌÉ", "ÂÙÌÏ", "ÂÙÔØ", "×",
    "×ÁÍ", "×ÁÓ", "×ÅÓØ", "×Ï", "×ÏÔ", "×ÓÅ", "×ÓÅÇÏ", "×ÓÅÈ", "×Ù", "ÇÄÅ",
    "ÄÁ", "ÄÁÖÅ", "ÄÌÑ", "ÄÏ", "ÅÇÏ", "ÅÅ", "ÅÊ", "ÅÀ", "ÅÓÌÉ", "ÅÓÔØ", "ÅÝÅ",
    "ÖÅ", "ÚÁ", "ÚÄÅÓØ", "É", "ÉÚ", "ÉÌÉ", "ÉÍ", "ÉÈ", "Ë", "ËÁË", "ËÏ",
    "ËÏÇÄÁ", "ËÔÏ", "ÌÉ", "ÌÉÂÏ", "ÍÎÅ", "ÍÏÖÅÔ", "ÍÙ", "ÎÁ", "ÎÁÄÏ", "ÎÁÛ",
    "ÎÅ", "ÎÅÇÏ", "ÎÅÅ", "ÎÅÔ", "ÎÉ", "ÎÉÈ", "ÎÏ", "ÎÕ", "Ï", "ÏÂ", "ÏÄÎÁËÏ",
    "ÏÎ", "ÏÎÁ", "ÏÎÉ", "ÏÎÏ", "ÏÔ", "ÏÞÅÎØ", "ÐÏ", "ÐÏÄ", "ÐÒÉ", "Ó", "ÓÏ",
    "ÔÁË", "ÔÁËÖÅ", "ÔÁËÏÊ", "ÔÁÍ", "ÔÅ", "ÔÅÍ", "ÔÏ", "ÔÏÇÏ", "ÔÏÖÅ", "ÔÏÊ",
    "ÔÏÌØËÏ", "ÔÏÍ", "ÔÙ", "Õ", "ÕÖÅ", "ÈÏÔÑ", "ÞÅÇÏ", "ÞÅÊ", "ÞÅÍ", "ÞÔÏ",
    "ÞÔÏÂÙ", "ÞØÅ", "ÞØÑ", "ÜÔÁ", "ÜÔÉ", "ÜÔÏ", "Ñ",
    NULL
};

const char *FULL_FINNISH_STOP_WORDS[] = {
    "olla", "olen", "olet", "on", "olemme", "olette", "ovat", "ole", "oli",
    "olisi", "olisit", "olisin", "olisimme", "olisitte", "olisivat", "olit",
    "olin", "olimme", "olitte", "olivat", "ollut", "olleet", "en", "et", "ei",
    "emme", "ette", "eivät", "minä", "minun", "minut", "minua", "minussa",
    "minusta", "minuun", "minulla", "minulta", "minulle", "sinä", "sinun",
    "sinut", "sinua", "sinussa", "sinusta", "sinuun", "sinulla", "sinulta",
    "sinulle", "hän", "hänen", "hänet", "häntä", "hänessä", "hänestä",
    "häneen", "hänellä", "häneltä", "hänelle", "me", "meidän", "meidät",
    "meitä", "meissä", "meistä", "meihin", "meillä", "meiltä", "meille", "te",
    "teidän", "teidät", "teitä", "teissä", "teistä", "teihin", "teillä",
    "teiltä", "teille", "he", "heidän", "heidät", "heitä", "heissä", "heistä",
    "heihin", "heillä", "heiltä", "heille", "tämä", "tämän", "tätä", "tässä",
    "tästä", "tähän", "tallä", "tältä", "tälle", "tänä", "täksi", "tuo",
    "tuon", "tuotä", "tuossa", "tuosta", "tuohon", "tuolla", "tuolta",
    "tuolle", "tuona", "tuoksi", "se", "sen", "sitä", "siinä", "siitä",
    "siihen", "sillä", "siltä", "sille", "sinä", "siksi", "nämä", "näiden",
    "näitä", "näissä", "näistä", "näihin", "näillä", "näiltä", "näille",
    "näinä", "näiksi", "nuo", "noiden", "noita", "noissa", "noista", "noihin",
    "noilla", "noilta", "noille", "noina", "noiksi", "ne", "niiden", "niitä",
    "niissä", "niistä", "niihin", "niillä", "niiltä", "niille", "niinä",
    "niiksi", "kuka", "kenen", "kenet", "ketä", "kenessä", "kenestä",
    "keneen", "kenellä", "keneltä", "kenelle", "kenenä", "keneksi", "ketkä",
    "keiden", "ketkä", "keitä", "keissä", "keistä", "keihin", "keillä",
    "keiltä", "keille", "keinä", "keiksi", "mikä", "minkä", "minkä", "mitä",
    "missä", "mistä", "mihin", "millä", "miltä", "mille", "minä", "miksi",
    "mitkä", "joka", "jonka", "jota", "jossa", "josta", "johon", "jolla",
    "jolta", "jolle", "jona", "joksi", "jotka", "joiden", "joita", "joissa",
    "joista", "joihin", "joilla", "joilta", "joille", "joina", "joiksi",
    "että", "ja", "jos", "koska", "kuin", "mutta", "niin", "sekä", "sillä",
    "tai", "vaan", "vai", "vaikka", "kanssa", "mukaan", "noin", "poikki",
    "yli", "kun", "niin", "nyt", "itse",
    NULL
};

const char *FULL_HUNGARIAN_STOP_WORDS[] = {
    "a", "ahogy", "ahol", "aki", "akik", "akkor", "alatt", "által",
    "általában", "amely", "amelyek", "amelyekben", "amelyeket", "amelyet",
    "amelynek", "ami", "amit", "amolyan", "amíg", "amikor", "át", "abban",
    "ahhoz", "annak", "arra", "arról", "az", "azok", "azon", "azt", "azzal",
    "azért", "aztán", "azután", "azonban", "bár", "be", "belül", "benne",
    "cikk", "cikkek", "cikkeket", "csak", "de", "e", "eddig", "egész", "egy",
    "egyes", "egyetlen", "egyéb", "egyik", "egyre", "ekkor", "el", "elég",
    "ellen", "elõ", "elõször", "elõtt", "elsõ", "én", "éppen", "ebben",
    "ehhez", "emilyen", "ennek", "erre", "ez", "ezt", "ezek", "ezen", "ezzel",
    "ezért", "és", "fel", "felé", "hanem", "hiszen", "hogy", "hogyan", "igen",
    "így", "illetve", "ill.", "ill", "ilyen", "ilyenkor", "ison", "ismét",
    "itt", "jó", "jól", "jobban", "kell", "kellett", "keresztül", "keressünk",
    "ki", "kívül", "között", "közül", "legalább", "lehet", "lehetett",
    "legyen", "lenne", "lenni", "lesz", "lett", "maga", "magát", "majd",
    "majd", "már", "más", "másik", "meg", "még", "mellett", "mert", "mely",
    "melyek", "mi", "mit", "míg", "miért", "milyen", "mikor", "minden",
    "mindent", "mindenki", "mindig", "mint", "mintha", "mivel", "most",
    "nagy", "nagyobb", "nagyon", "ne", "néha", "nekem", "neki", "nem",
    "néhány", "nélkül", "nincs", "olyan", "ott", "össze", "õ", "õk", "õket",
    "pedig", "persze", "rá", "s", "saját", "sem", "semmi", "sok", "sokat",
    "sokkal", "számára", "szemben", "szerint", "szinte", "talán", "tehát",
    "teljes", "tovább", "továbbá", "több", "úgy", "ugyanis", "új", "újabb",
    "újra", "után", "utána", "utolsó", "vagy", "vagyis", "valaki", "valami",
    "valamint", "való", "vagyok", "van", "vannak", "volt", "voltam", "voltak",
    "voltunk", "vissza", "vele", "viszont", "volna",
    NULL
};
