/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.classpath.SystemProperties;
import java.io.DeleteFileHelper;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.VMFile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class File
implements Serializable,
Comparable {
    private static final long serialVersionUID = 301077366599181567L;
    public static final String separator = SystemProperties.getProperty("file.separator");
    private static final String dupSeparator = separator + separator;
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = SystemProperties.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    private static long last_tmp;
    private static int n_created;
    private String path;

    public boolean canRead() {
        if (!this.exists()) {
            return false;
        }
        return VMFile.canRead(this.path);
    }

    public boolean canWrite() {
        this.checkWrite();
        if (!VMFile.exists(this.path)) {
            return false;
        }
        if (VMFile.isDirectory(this.path)) {
            return VMFile.canWriteDirectory(this);
        }
        return VMFile.canWrite(this.path);
    }

    public boolean createNewFile() throws IOException {
        this.checkWrite();
        return VMFile.create(this.path);
    }

    public synchronized boolean delete() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkDelete(this.path);
        }
        return VMFile.delete(this.path);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof File)) {
            return false;
        }
        File other = (File)obj;
        return this.path.equals(other.path);
    }

    public boolean exists() {
        this.checkRead();
        return VMFile.exists(this.path);
    }

    private final String normalizePath(String p) {
        if (separatorChar == '\\' && (p = p.replace('/', '\\')).length() > 2 && p.charAt(0) == '\\' && (p.charAt(1) >= 'a' && p.charAt(1) <= 'z' || p.charAt(1) >= 'A' && p.charAt(1) <= 'Z') && p.charAt(2) == ':') {
            p = p.substring(1);
        }
        int dupIndex = p.indexOf(dupSeparator);
        int plen = p.length();
        if (dupSeparator.equals("\\\\") && dupIndex == 0) {
            dupIndex = p.indexOf(dupSeparator, 1);
        }
        if (dupIndex == -1) {
            if (plen > 1 && p.charAt(plen - 1) == separatorChar) {
                if (separatorChar != '\\' || plen != 3 || p.charAt(1) != ':') {
                    return p.substring(0, plen - 1);
                }
            } else {
                return p;
            }
        }
        StringBuffer newpath = new StringBuffer(plen);
        int last = 0;
        while (dupIndex != -1) {
            newpath.append(p.substring(last, dupIndex));
            while (p.charAt(dupIndex) == separatorChar) {
                if (++dupIndex != plen) continue;
                return newpath.toString();
            }
            newpath.append(separatorChar);
            last = dupIndex;
            dupIndex = p.indexOf(dupSeparator, last);
        }
        int end = plen > 1 && p.charAt(plen - 1) == separatorChar ? (separatorChar == '\\' && plen == 3 && p.charAt(1) == ':' ? plen : plen - 1) : plen;
        newpath.append(p.substring(last, end));
        return newpath.toString();
    }

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.path;
        }
        if (separatorChar == '\\' && this.path.length() > 0 && this.path.charAt(0) == '\\') {
            return System.getProperty("user.dir").substring(0, 2) + this.path;
        }
        if (separatorChar == '\\' && this.path.length() > 1 && this.path.charAt(1) == ':' && (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z')) {
            String drvDir = null;
            try {
                drvDir = new File(this.path.substring(0, 2)).getCanonicalPath();
            }
            catch (IOException e) {
                drvDir = this.path.substring(0, 2) + '\\';
            }
            if (this.path.length() > 2) {
                return drvDir + '\\' + this.path.substring(2, this.path.length());
            }
            return drvDir;
        }
        return System.getProperty("user.dir") + separatorChar + this.path;
    }

    public File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    public String getCanonicalPath() throws IOException {
        if (separatorChar == '\\' && this.path.length() == 2 && (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z') && this.path.charAt(1) == ':') {
            return VMFile.toCanonicalForm(this.path);
        }
        return VMFile.toCanonicalForm(this.getAbsolutePath());
    }

    public File getCanonicalFile() throws IOException {
        return new File(this.getCanonicalPath());
    }

    public String getName() {
        return VMFile.getName(this.path);
    }

    public String getParent() {
        String prefix = null;
        int nameSeqIndex = 0;
        if (separatorChar == '/' && this.path.charAt(0) == '/') {
            prefix = "/";
            nameSeqIndex = 1;
        } else if (separatorChar == '\\' && this.path.length() > 1 && (this.path.charAt(0) == '\\' && this.path.charAt(1) == '\\' || (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z') && this.path.charAt(1) == ':')) {
            prefix = this.path.substring(0, 2);
            nameSeqIndex = 2;
        }
        if (nameSeqIndex < this.path.length()) {
            String nameSeq = this.path.substring(nameSeqIndex, this.path.length());
            int last = nameSeq.lastIndexOf(separatorChar);
            if (last == -1) {
                return prefix;
            }
            if (last == nameSeq.length() - 1) {
                return null;
            }
            if (last == 0) {
                ++last;
            }
            if (prefix != null) {
                return prefix + nameSeq.substring(0, last);
            }
            return nameSeq.substring(0, last);
        }
        return null;
    }

    public File getParentFile() {
        String parent = this.getParent();
        return parent != null ? new File(parent) : null;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        if (separatorChar == '\\') {
            boolean bl = false;
            if (this.path.startsWith(dupSeparator) || this.path.length() > 2 && (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z') && this.path.charAt(1) == ':' && this.path.charAt(2) == '\\') {
                bl = true;
            }
            return bl;
        }
        return this.path.startsWith(separator);
    }

    public boolean isDirectory() {
        this.checkRead();
        return VMFile.isDirectory(this.path);
    }

    public boolean isFile() {
        this.checkRead();
        return VMFile.isFile(this.path);
    }

    public boolean isHidden() {
        return VMFile.isHidden(this.path);
    }

    public long lastModified() {
        this.checkRead();
        return VMFile.lastModified(this.path);
    }

    public long length() {
        this.checkRead();
        return VMFile.length(this.path);
    }

    public String[] list(FilenameFilter filter) {
        this.checkRead();
        if (!this.exists() || !this.isDirectory()) {
            return null;
        }
        String[] files = VMFile.list(this.path);
        if (files == null) {
            return null;
        }
        if (filter == null) {
            return files;
        }
        int count = 0;
        int i = 0;
        while (i < files.length) {
            if (filter.accept(this, files[i])) {
                ++count;
            } else {
                files[i] = null;
            }
            ++i;
        }
        String[] retfiles = new String[count];
        count = 0;
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2] != null) {
                retfiles[count++] = files[i2];
            }
            ++i2;
        }
        return retfiles;
    }

    public String[] list() {
        return this.list(null);
    }

    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    public File[] listFiles(FilenameFilter filter) {
        String[] filelist = this.list(filter);
        if (filelist == null) {
            return null;
        }
        File[] fobjlist = new File[filelist.length];
        int i = 0;
        while (i < filelist.length) {
            fobjlist[i] = new File(this, filelist[i]);
            ++i;
        }
        return fobjlist;
    }

    public File[] listFiles(FileFilter filter) {
        File[] fobjlist = this.listFiles((FilenameFilter)null);
        if (fobjlist == null) {
            return null;
        }
        if (filter == null) {
            return fobjlist;
        }
        int count = 0;
        int i = 0;
        while (i < fobjlist.length) {
            if (filter.accept(fobjlist[i])) {
                ++count;
            }
            ++i;
        }
        File[] final_list = new File[count];
        count = 0;
        int i2 = 0;
        while (i2 < fobjlist.length) {
            if (filter.accept(fobjlist[i2])) {
                final_list[count] = fobjlist[i2];
                ++count;
            }
            ++i2;
        }
        return final_list;
    }

    public String toString() {
        return this.path;
    }

    public URI toURI() {
        String abspath = this.getAbsolutePath();
        if (this.isDirectory()) {
            abspath = abspath + separatorChar;
        }
        if (separatorChar == '\\') {
            abspath = separatorChar + abspath;
        }
        try {
            return new URI("file", null, null, -1, abspath.replace(separatorChar, '/'), null, null);
        }
        catch (URISyntaxException use) {
            throw (InternalError)new InternalError("Unconvertible file: " + this).initCause(use);
        }
    }

    public URL toURL() throws MalformedURLException {
        if (separatorChar == '\\') {
            return new URL("file:/" + this.getAbsolutePath().replace('\\', '/') + (this.isDirectory() ? "/" : ""));
        }
        return new URL("file:" + this.getAbsolutePath() + (this.isDirectory() ? "/" : ""));
    }

    public boolean mkdir() {
        this.checkWrite();
        return VMFile.mkdir(this.path);
    }

    public boolean mkdirs() {
        boolean rc;
        String parent = this.getParent();
        if (parent == null) {
            return this.mkdir();
        }
        File f = new File(parent);
        if (!f.exists() && !(rc = f.mkdirs())) {
            return false;
        }
        return this.mkdir();
    }

    public static synchronized File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File file;
        if (directory == null) {
            String dirname = System.getProperty("java.io.tmpdir");
            if (dirname == null) {
                throw new IOException("Cannot determine system temporary directory");
            }
            directory = new File(dirname);
            if (!VMFile.exists(directory.path)) {
                throw new IOException("System temporary directory " + directory.getName() + " does not exist.");
            }
            if (!VMFile.isDirectory(directory.path)) {
                throw new IOException("System temporary directory " + directory.getName() + " is not really a directory.");
            }
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix too short: " + prefix);
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        do {
            long now;
            if ((now = System.currentTimeMillis()) > last_tmp) {
                last_tmp = now;
                n_created = 0;
            } else {
                ++n_created;
            }
            String name = Long.toHexString(now);
            if (n_created > 0) {
                name = name + '_' + Integer.toHexString(n_created);
            }
            String filename = prefix + name + suffix;
            file = new File(directory, filename);
        } while (VMFile.exists(file.path));
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkWrite(file.getAbsolutePath());
        }
        VMFile.create(file.getAbsolutePath());
        return file;
    }

    public boolean setReadOnly() {
        this.checkWrite();
        if (!VMFile.exists(this.path)) {
            return false;
        }
        return VMFile.setReadOnly(this.path);
    }

    public static File[] listRoots() {
        return VMFile.listRoots();
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }

    public int compareTo(File other) {
        return this.path.compareTo(other.path);
    }

    public int compareTo(Object obj) {
        return this.compareTo((File)obj);
    }

    public synchronized boolean renameTo(File dest) {
        this.checkWrite();
        dest.checkWrite();
        return VMFile.renameTo(this.path, dest.path);
    }

    public boolean setLastModified(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Negative modification time: " + time);
        }
        this.checkWrite();
        return VMFile.setLastModified(this.path, time);
    }

    private final void checkWrite() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(this.path);
        }
    }

    private final void checkRead() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(this.path);
        }
    }

    public void deleteOnExit() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkDelete(this.path);
        }
        DeleteFileHelper.add(this);
    }

    private final void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeChar(separatorChar);
    }

    private final void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        char oldSeparatorChar = ois.readChar();
        if (oldSeparatorChar != separatorChar) {
            this.path = this.path.replace(oldSeparatorChar, separatorChar);
        }
    }

    public File(String name) {
        this.path = this.normalizePath(name);
    }

    public File(String dirPath, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (dirPath != null) {
            if (dirPath.length() > 0) {
                this.path = dirPath.charAt(dirPath.length() - 1) == separatorChar || name.length() == 0 ? this.normalizePath(dirPath + name) : this.normalizePath(dirPath + separatorChar + name);
            } else {
                if (separatorChar == '\\') {
                    int skip = 0;
                    while (name.length() > skip && (name.charAt(skip) == separatorChar || name.charAt(skip) == '/')) {
                        ++skip;
                    }
                    name = name.substring(skip);
                }
                this.path = this.normalizePath(separatorChar + name);
            }
        } else {
            this.path = this.normalizePath(name);
        }
    }

    public File(File directory, String name) {
        this(directory == null ? null : directory.path, name);
    }

    public File(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        if (!uri.getScheme().equals("file")) {
            throw new IllegalArgumentException("invalid uri protocol");
        }
        this.path = this.normalizePath(uri.getPath());
    }
}

