/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    protected void flushBits() throws IOException {
        throw new Error("not implemented");
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void write(int var1) throws IOException;

    public void writeBit(int bit) throws IOException {
        throw new Error("not implemented");
    }

    public void writeBits(long bits, int numBits) throws IOException {
        throw new Error("not implemented");
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeByte(value ? 1 : 0);
    }

    public void writeByte(int value) throws IOException {
        this.write(value & 0xFF);
    }

    public void writeBytes(String data) throws IOException {
        this.write(data.getBytes());
    }

    public void writeChar(int value) throws IOException {
        this.writeShort((short)value);
    }

    public void writeChars(char[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeChar(data[offset + i]);
            ++len;
        }
    }

    public void writeChars(String data) throws IOException {
        throw new Error("not implemented");
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong((long)value);
    }

    public void writeDoubles(double[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeDouble(data[offset + i]);
            ++len;
        }
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt((int)value);
    }

    public void writeFloats(float[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeFloat(data[offset + i]);
            ++len;
        }
    }

    public void writeInt(int value) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
            this.buffer[2] = (byte)(value >> 16);
            this.buffer[3] = (byte)(value >> 24);
        } else {
            this.buffer[0] = (byte)(value >> 24);
            this.buffer[1] = (byte)(value >> 16);
            this.buffer[2] = (byte)(value >> 8);
            this.buffer[3] = (byte)value;
        }
        this.write(this.buffer, 0, 4);
    }

    public void writeInts(int[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeInt(data[offset + i]);
            ++len;
        }
    }

    public void writeLong(long value) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
            this.buffer[2] = (byte)(value >> 16);
            this.buffer[3] = (byte)(value >> 24);
            this.buffer[4] = (byte)(value >> 32);
            this.buffer[5] = (byte)(value >> 40);
            this.buffer[6] = (byte)(value >> 48);
            this.buffer[7] = (byte)(value >> 56);
        } else {
            this.buffer[0] = (byte)(value >> 56);
            this.buffer[1] = (byte)(value >> 48);
            this.buffer[2] = (byte)(value >> 40);
            this.buffer[3] = (byte)(value >> 32);
            this.buffer[4] = (byte)(value >> 24);
            this.buffer[5] = (byte)(value >> 16);
            this.buffer[6] = (byte)(value >> 8);
            this.buffer[7] = (byte)value;
        }
        this.write(this.buffer, 0, 8);
    }

    public void writeLongs(long[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeLong(data[offset + i]);
            ++len;
        }
    }

    public void writeShort(int value) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
        } else {
            this.buffer[0] = (byte)(value >> 8);
            this.buffer[1] = (byte)value;
        }
        this.write(this.buffer, 0, 2);
    }

    public void writeShorts(short[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeShort(data[offset + i]);
            ++len;
        }
    }

    public void writeUTF(String data) throws IOException {
        throw new Error("not implemented");
    }
}

