/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SpinnerUI;
import javax.swing.text.DateFormatter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JSpinner
extends JComponent {
    private static final long serialVersionUID = 3412663575706551720L;
    private SpinnerModel model;
    private JComponent editor;
    private ChangeListener listener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public void commitEdit() throws ParseException {
        if (this.editor instanceof DefaultEditor) {
            ((DefaultEditor)this.editor).commitEdit();
        }
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public void setEditor(JComponent editor) {
        if (editor == null) {
            throw new IllegalArgumentException("editor may not be null");
        }
        if (this.editor instanceof DefaultEditor) {
            ((DefaultEditor)editor).dismiss(this);
        } else if (this.editor instanceof ChangeListener) {
            this.removeChangeListener((ChangeListener)((Object)this.editor));
        }
        if (editor instanceof ChangeListener) {
            this.addChangeListener((ChangeListener)((Object)editor));
        }
        this.editor = editor;
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public void setModel(SpinnerModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException();
        }
        if (this.model == newModel) {
            return;
        }
        SpinnerModel oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, newModel);
        if (this.editor == null) {
            this.setEditor(this.createEditor(this.model));
        }
    }

    public Object getNextValue() {
        return this.model.getNextValue();
    }

    public Object getPreviousValue() {
        return this.model.getPreviousValue();
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.ui;
    }

    public Object getValue() {
        return this.model.getValue();
    }

    public void setValue(Object value) {
        this.model.setValue(value);
    }

    public String getUIClassID() {
        return "SpinnerUI";
    }

    public void updateUI() {
        this.setUI((SpinnerUI)UIManager.getUI(this));
    }

    public void setUI(SpinnerUI ui) {
        super.setUI(ui);
    }

    public void addChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JSpinner.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JSpinner.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JSpinner.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireStateChanged() {
        ChangeEvent evt = new ChangeEvent(this);
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(evt);
            ++i;
        }
    }

    protected JComponent createEditor(SpinnerModel model) {
        if (model instanceof SpinnerDateModel) {
            return new DateEditor(this);
        }
        if (model instanceof SpinnerNumberModel) {
            return new NumberEditor(this);
        }
        return new DefaultEditor(this);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listener = new ChangeListener(){

            public final void stateChanged(ChangeEvent evt) {
                JSpinner.this.fireStateChanged();
            }
        };
    }

    public JSpinner() {
        this(new SpinnerNumberModel());
    }

    public JSpinner(SpinnerModel model) {
        this.this();
        this.model = model;
        model.addChangeListener(this.listener);
        this.setEditor(this.createEditor(model));
        this.updateUI();
    }

    public static class DefaultEditor
    extends JPanel
    implements ChangeListener,
    PropertyChangeListener,
    LayoutManager {
        private static final long serialVersionUID = -5317788736173368172L;
        private JSpinner spinner;
        JFormattedTextField ftf;

        public JSpinner getSpinner() {
            return this.spinner;
        }

        public void commitEdit() throws ParseException {
        }

        public void dismiss(JSpinner spinner) {
            spinner.removeChangeListener(this);
        }

        public JFormattedTextField getTextField() {
            return this.ftf;
        }

        public void layoutContainer(Container parent) {
            Insets insets = this.getInsets();
            Dimension size = this.getSize();
            this.ftf.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = this.getInsets();
            Dimension minSize = this.ftf.getMinimumSize();
            return new Dimension(minSize.width + insets.left + insets.right, minSize.height + insets.top + insets.bottom);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = this.getInsets();
            Dimension prefSize = this.ftf.getPreferredSize();
            return new Dimension(prefSize.width + insets.left + insets.right, prefSize.height + insets.top + insets.bottom);
        }

        public void propertyChange(PropertyChangeEvent event) {
        }

        public void stateChanged(ChangeEvent event) {
        }

        public void removeLayoutComponent(Component child) {
        }

        public void addLayoutComponent(String name, Component child) {
        }

        public DefaultEditor(JSpinner spinner) {
            this.setLayout(this);
            this.spinner = spinner;
            this.ftf = new JFormattedTextField();
            this.add(this.ftf);
            this.ftf.setValue(spinner.getValue());
            spinner.addChangeListener(this);
        }
    }

    public static class DateEditor
    extends DefaultEditor {
        private static final long serialVersionUID = -4279356973770397815L;
        SimpleDateFormat dateFormat;

        private final void init(SimpleDateFormat format) {
            this.dateFormat = format;
            this.getTextField().setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

                public final JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField ftf) {
                    return new DateFormatter(DateEditor.this.dateFormat);
                }
            });
        }

        public SimpleDateFormat getFormat() {
            return this.dateFormat;
        }

        public SpinnerDateModel getModel() {
            return (SpinnerDateModel)this.getSpinner().getModel();
        }

        public DateEditor(JSpinner spinner) {
            super(spinner);
            this.init(new SimpleDateFormat());
        }

        public DateEditor(JSpinner spinner, String dateFormatPattern) {
            super(spinner);
            this.init(new SimpleDateFormat(dateFormatPattern));
        }
    }

    public static class NumberEditor
    extends DefaultEditor {
        private static final long serialVersionUID = 3791956183098282942L;

        public DecimalFormat getFormat() {
            return null;
        }

        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)this.getSpinner().getModel();
        }

        public NumberEditor(JSpinner spinner) {
            super(spinner);
        }

        public NumberEditor(JSpinner spinner, String decimalFormatPattern) {
            super(spinner);
        }
    }

    public static class ListEditor
    extends DefaultEditor {
        public SpinnerListModel getModel() {
            return (SpinnerListModel)this.getSpinner().getModel();
        }

        public ListEditor(JSpinner spinner) {
            super(spinner);
        }
    }
}

