/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.campagnelab.goby.algorithmic.algorithm.EquivalentIndelRegionCalculator;
import org.campagnelab.goby.algorithmic.indels.EquivalentIndelRegion;
import org.campagnelab.goby.alignments.processors.ObservedIndel;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;
import org.campagnelab.goby.util.Variant;
import org.campagnelab.goby.util.VariantMapHelper;
import org.campagnelab.goby.util.WarningCounter;

public class VariantMapCreator
extends VariantMapHelper {
    public int numIndelsEncountered;
    private EquivalentIndelRegionCalculator equivalentIndelRegionCalculator;
    protected RandomAccessSequenceInterface genome;
    static WarningCounter overLappingIndels = new WarningCounter(10);
    public int numFromMistmaches;

    public VariantMapCreator(RandomAccessSequenceInterface genome) {
        this.chMap = new Object2ObjectOpenHashMap(40);
        this.genome = genome;
        this.equivalentIndelRegionCalculator = new EquivalentIndelRegionCalculator(genome);
        this.equivalentIndelRegionCalculator.setFlankLeftSize(1);
        this.equivalentIndelRegionCalculator.setFlankRightSize(0);
    }

    public Variant addVariant(int gobyPos, String chrom, char reference, Set<Variant.FromTo> trueAlleles) {
        if (!this.chMap.containsKey((Object)chrom)) {
            this.chMap.put((Object)chrom, (Object)new Int2ObjectArrayMap(50000));
        }
        Variant var = new Variant(reference, trueAlleles, gobyPos, this.genome.getReferenceIndex(chrom));
        Map<Integer, Variant> realignedVars = this.realign(var, this.equivalentIndelRegionCalculator);
        Variant result = null;
        for (Variant reVar : realignedVars.values()) {
            Variant previousVariant = (Variant)((Int2ObjectMap)this.chMap.get((Object)chrom)).get(reVar.position);
            if (previousVariant != null) {
                previousVariant.merge(reVar);
                overLappingIndels.warn(LOG, "\nmerged variant. in map froms,tos: " + ((Variant)((Int2ObjectMap)this.chMap.get((Object)chrom)).get((int)reVar.position)).trueAlleles + "\nintended adding from,to: " + reVar.trueAlleles + "\nat " + chrom + ":" + reVar.position, new Object[0]);
                ++this.numOverlaps;
                result = previousVariant;
                continue;
            }
            ((Int2ObjectMap)this.chMap.get((Object)chrom)).put(reVar.position, (Object)reVar);
            result = reVar;
        }
        return result;
    }

    public void saveMap(String pathToMap) throws IOException {
        BinIO.storeObject((Object)this.chMap, (File)new File(pathToMap));
    }

    public void showStats() {
        int isSNP = 0;
        int isIndel = 0;
        int isHet = 0;
        int isHom = 0;
        int isNoCall = 0;
        for (Int2ObjectMap chrList : this.chMap.values()) {
            for (Variant variant : chrList.values()) {
                isIndel += variant.isIndel() ? 1 : 0;
                isSNP += variant.isSNP() ? 1 : 0;
                isHom += variant.isHomozygous() ? 1 : 0;
                isHet += variant.isHeterozygous() ? 1 : 0;
                isNoCall = variant.isNoCall() ? 1 : 0;
            }
        }
        System.out.printf("         isSNP=%d;\n         isIndel=%d;\n         isHet=%d;\n         isHom=%d;\n         isNoCall=%d;\n         het/hom ratio=%f%n", isSNP, isIndel, isHet, isHom, isNoCall, (double)isHet / (double)isHom);
    }

    Map<Integer, Variant> realign(Variant variant, EquivalentIndelRegionCalculator equivalentIndelRegionCalculator) {
        Int2ObjectArrayMap equivVariants = new Int2ObjectArrayMap(variant.trueAlleles.size());
        if (variant.maxLen == 1) {
            equivVariants.put(variant.position, variant);
            return equivVariants;
        }
        for (Variant.FromTo s : variant.trueAlleles) {
            String trueFromWithRef;
            String trueAlleleWithRef;
            String refBase;
            if (s.isRef()) continue;
            Variant.GobyIndelFromVCF gobyFormatIndel = new Variant.GobyIndelFromVCF(s, variant.position);
            String fromAffix = gobyFormatIndel.getGobyFromTo().getFrom();
            String toAffix = gobyFormatIndel.getGobyFromTo().getTo();
            int allelePos = gobyFormatIndel.getAllelePos();
            EquivalentIndelRegion result = new EquivalentIndelRegion();
            ObservedIndel indel = null;
            if (fromAffix.length() <= 1 && !fromAffix.contains("-") && !toAffix.contains("-")) {
                result.from = variant.referenceBase;
                result.to = toAffix.substring(0, 1);
                result.startPosition = allelePos;
            } else {
                indel = new ObservedIndel(allelePos, fromAffix, toAffix, variant.referenceIndex);
                result = equivalentIndelRegionCalculator.determine(variant.referenceIndex, indel);
                ++this.numIndelsEncountered;
            }
            if (result == null) continue;
            if (result.flankLeft != null) {
                refBase = result.flankLeft.substring(result.flankLeft.length() - 1);
                trueAlleleWithRef = result.toInContext();
                trueFromWithRef = result.fromInContext();
            } else {
                refBase = result.from;
                trueAlleleWithRef = result.to;
                trueFromWithRef = result.from;
            }
            Variant.FromTo realigned = new Variant.FromTo(trueFromWithRef, trueAlleleWithRef);
            Variant.FromTo reference = new Variant.FromTo(refBase, refBase);
            if (equivVariants.containsKey(result.startPosition)) {
                ((Variant)equivVariants.get((Object)Integer.valueOf((int)result.startPosition))).trueAlleles.add(realigned);
            } else {
                ObjectArraySet trueAlleles = new ObjectArraySet();
                trueAlleles.add(reference);
                trueAlleles.add(realigned);
                char referenceBaseResult = result.flankLeft != null && result.flankLeft.length() > 0 ? result.flankLeft.charAt(0) : variant.referenceBase.charAt(0);
                equivVariants.put(result.startPosition, new Variant(referenceBaseResult, (Set<Variant.FromTo>)trueAlleles, result.startPosition, variant.referenceIndex));
            }
            if (((Variant)equivVariants.get((Object)Integer.valueOf((int)result.startPosition))).trueAlleles.size() <= variant.trueAlleles.size()) continue;
            ((Variant)equivVariants.get((Object)Integer.valueOf((int)result.startPosition))).trueAlleles.remove(reference);
        }
        return equivVariants;
    }
}

