/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.srp6;

import gnu.java.security.Registry;
import gnu.java.security.key.IKeyPairCodec;
import gnu.javax.crypto.key.srp6.SRPPrivateKey;
import gnu.javax.crypto.key.srp6.SRPPublicKey;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SRPKeyPairRawCodec
implements IKeyPairCodec {
    public int getFormatID() {
        return 1;
    }

    public byte[] encodePublicKey(PublicKey publicKey) {
        if (!(publicKey instanceof SRPPublicKey)) {
            throw new IllegalArgumentException("key");
        }
        SRPPublicKey sRPPublicKey = (SRPPublicKey)publicKey;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(Registry.MAGIC_RAW_SRP_PUBLIC_KEY[0]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_SRP_PUBLIC_KEY[1]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_SRP_PUBLIC_KEY[2]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_SRP_PUBLIC_KEY[3]);
        byteArrayOutputStream.write(1);
        byte[] byArray = sRPPublicKey.getN().toByteArray();
        int n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = sRPPublicKey.getG().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = sRPPublicKey.getY().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        return byteArrayOutputStream.toByteArray();
    }

    public PublicKey decodePublicKey(byte[] byArray) {
        if (byArray[0] != Registry.MAGIC_RAW_SRP_PUBLIC_KEY[0] || byArray[1] != Registry.MAGIC_RAW_SRP_PUBLIC_KEY[1] || byArray[2] != Registry.MAGIC_RAW_SRP_PUBLIC_KEY[2] || byArray[3] != Registry.MAGIC_RAW_SRP_PUBLIC_KEY[3]) {
            throw new IllegalArgumentException("magic");
        }
        if (byArray[4] != 1) {
            throw new IllegalArgumentException("version");
        }
        int n = 5;
        int n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger = new BigInteger(1, byArray2);
        n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        return new SRPPublicKey(bigInteger, bigInteger2, bigInteger3);
    }

    public byte[] encodePrivateKey(PrivateKey privateKey) {
        if (!(privateKey instanceof SRPPrivateKey)) {
            throw new IllegalArgumentException("key");
        }
        SRPPrivateKey sRPPrivateKey = (SRPPrivateKey)privateKey;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(Registry.MAGIC_RAW_SRP_PRIVATE_KEY[0]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_SRP_PRIVATE_KEY[1]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_SRP_PRIVATE_KEY[2]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_SRP_PRIVATE_KEY[3]);
        byteArrayOutputStream.write(1);
        byte[] byArray = sRPPrivateKey.getN().toByteArray();
        int n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = sRPPrivateKey.getG().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = sRPPrivateKey.getX().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        if (sRPPrivateKey.getV() != null) {
            byteArrayOutputStream.write(1);
            byArray = sRPPrivateKey.getV().toByteArray();
            n = byArray.length;
            byteArrayOutputStream.write(n >>> 24);
            byteArrayOutputStream.write(n >>> 16 & 0xFF);
            byteArrayOutputStream.write(n >>> 8 & 0xFF);
            byteArrayOutputStream.write(n & 0xFF);
            byteArrayOutputStream.write(byArray, 0, n);
        } else {
            byteArrayOutputStream.write(0);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public PrivateKey decodePrivateKey(byte[] byArray) {
        if (byArray[0] != Registry.MAGIC_RAW_SRP_PRIVATE_KEY[0] || byArray[1] != Registry.MAGIC_RAW_SRP_PRIVATE_KEY[1] || byArray[2] != Registry.MAGIC_RAW_SRP_PRIVATE_KEY[2] || byArray[3] != Registry.MAGIC_RAW_SRP_PRIVATE_KEY[3]) {
            throw new IllegalArgumentException("magic");
        }
        if (byArray[4] != 1) {
            throw new IllegalArgumentException("version");
        }
        int n = 5;
        int n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger = new BigInteger(1, byArray2);
        n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        n2 = byArray[n++];
        if (n2 == 1) {
            n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            n += n2;
            BigInteger bigInteger4 = new BigInteger(1, byArray2);
            return new SRPPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }
        return new SRPPrivateKey(bigInteger, bigInteger2, bigInteger3);
    }
}

