/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.pageview;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Properties;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.apache.kafka.connect.json.JsonSerializer;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.examples.pageview.JsonTimestampExtractor;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;

public class PageViewUntypedDemo {
    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.put("application.id", "streams-pageview-untyped");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("default.timestamp.extractor", JsonTimestampExtractor.class);
        props.put("cache.max.bytes.buffering", (Object)0);
        props.put("auto.offset.reset", "earliest");
        StreamsBuilder builder = new StreamsBuilder();
        JsonSerializer jsonSerializer = new JsonSerializer();
        JsonDeserializer jsonDeserializer = new JsonDeserializer();
        Serde jsonSerde = Serdes.serdeFrom((Serializer)jsonSerializer, (Deserializer)jsonDeserializer);
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)jsonSerde);
        KStream views = builder.stream("streams-pageview-input", consumed);
        KTable users = builder.table("streams-userprofile-input", consumed);
        KTable userRegions = users.mapValues((ValueMapper)new ValueMapper<JsonNode, String>(){

            public String apply(JsonNode record) {
                return record.get("region").textValue();
            }
        });
        KStream regionCount = views.leftJoin(userRegions, (ValueJoiner)new ValueJoiner<JsonNode, String, JsonNode>(){

            public JsonNode apply(JsonNode view, String region) {
                ObjectNode jNode = JsonNodeFactory.instance.objectNode();
                return jNode.put("user", view.get("user").textValue()).put("page", view.get("page").textValue()).put("region", region == null ? "UNKNOWN" : region);
            }
        }).map((KeyValueMapper)new KeyValueMapper<String, JsonNode, KeyValue<String, JsonNode>>(){

            public KeyValue<String, JsonNode> apply(String user, JsonNode viewRegion) {
                return new KeyValue((Object)viewRegion.get("region").textValue(), (Object)viewRegion);
            }
        }).groupByKey(Serialized.with((Serde)Serdes.String(), (Serde)jsonSerde)).windowedBy((Windows)TimeWindows.of((long)604800000L).advanceBy(1000L)).count().toStream().map((KeyValueMapper)new KeyValueMapper<Windowed<String>, Long, KeyValue<JsonNode, JsonNode>>(){

            public KeyValue<JsonNode, JsonNode> apply(Windowed<String> key, Long value) {
                ObjectNode keyNode = JsonNodeFactory.instance.objectNode();
                keyNode.put("window-start", key.window().start()).put("region", (String)key.key());
                ObjectNode valueNode = JsonNodeFactory.instance.objectNode();
                valueNode.put("count", value);
                return new KeyValue((Object)keyNode, (Object)valueNode);
            }
        });
        regionCount.to("streams-pageviewstats-untyped-output", Produced.with((Serde)jsonSerde, (Serde)jsonSerde));
        KafkaStreams streams = new KafkaStreams(builder.build(), props);
        streams.start();
        Thread.sleep(5000L);
        streams.close();
    }
}

