/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tmv!B\u0001\u0003\u0011\u0003I\u0011A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005\r!\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\u0002\u0004\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u0003i!A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\u0014\u0005-q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0003\u0016\u0017\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013!)\u0001d\u0003C\u00013\u0005)\u0011\r\u001d9msRy!Da\u0019\u0003t\tu$q\u0010BH\u0005;\u00139\u000b\u0005\u0002\u000b7\u0019!AB\u0001\u0001\u001d'\rYb\"\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\tQ!\u001e;jYNL!AI\u0010\u0003\u000f1{wmZ5oO\"AAe\u0007B\u0001B\u0003%Q%\u0001\u0005ce>\\WM]%e!\tya%\u0003\u0002(!\t\u0019\u0011J\u001c;\t\u0011%Z\"\u0011!Q\u0001\n)\n\u0011\u0002\u001e=o\u0007>tg-[4\u0011\u0005)Y\u0013B\u0001\u0017\u0003\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017n\u001a\u0005\t]m\u0011\t\u0011)A\u0005_\u0005I1o\u00195fIVdWM\u001d\t\u0003=AJ!!M\u0010\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\u0002C\u001a\u001c\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002#A\u0014x\u000eZ;dKJLE-T1oC\u001e,'\u000f\u0005\u0002\u000bk%\u0011aG\u0001\u0002\u0012!J|G-^2fe&#W*\u00198bO\u0016\u0014\b\u0002\u0003\u001d\u001c\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u0015QDh.T1oC\u001e,'\u000f\u0005\u0002\u000bu%\u00111H\u0001\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJD\u0001\"P\u000e\u0003\u0002\u0003\u0006IAP\u0001\u0018ibtW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u0004\"AC \n\u0005\u0001\u0013!a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\"A!i\u0007B\u0001B\u0003%1)\u0001\u0003uS6,\u0007C\u0001#N\u001b\u0005)%B\u0001\u0011G\u0015\t9\u0005*\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f%S!AS&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0015aA8sO&\u0011a*\u0012\u0002\u0005)&lW\r\u0003\u0005Q7\t\u0005\t\u0015!\u0003R\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0003\tJK!aU#\u0003\u00151{wmQ8oi\u0016DH\u000fC\u0003\u00167\u0011\u0005Q\u000bF\u0005\u001b-^C\u0016LW.];\")A\u0005\u0016a\u0001K!)\u0011\u0006\u0016a\u0001U!)a\u0006\u0016a\u0001_!)1\u0007\u0016a\u0001i!)\u0001\b\u0016a\u0001s!)Q\b\u0016a\u0001}!)!\t\u0016a\u0001\u0007\")\u0001\u000b\u0016a\u0001#\u0016!ql\u0007\u0001a\u0005YIe.\u001b;Qe>$WoY3s\u0013\u0012\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003B\bbG\u001aL!A\u0019\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0006e\u0013\t)'A\u0001\u000bJ]&$\bK]8ek\u000e,'/\u00133SKN,H\u000e\u001e\t\u0003\u001f\u001dL!\u0001\u001b\t\u0003\tUs\u0017\u000e^\u0003\u0005Un\u00011NA\u000bBI\u0012\u0004\u0016M\u001d;ji&|gn]\"bY2\u0014\u0017mY6\u0011\t=\tGN\u001a\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u001a\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003c:\u0014a!\u0012:s_J\u001cX\u0001B:\u001c\u0001-\u0014a\"\u00128e)bt7)\u00197mE\u0006\u001c7.\u0002\u0003v7\u00011(!C!qSJ+7/\u001e7u+\r9\u00181\u0002\t\u0007q\u0006\u0005A.a\u0002\u000f\u0005ethB\u0001>~\u001b\u0005Y(B\u0001?\t\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u0000!\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0002\u0003\u000b\u0011a!R5uQ\u0016\u0014(BA@\u0011!\u0011\tI!a\u0003\r\u0001\u00119\u0011Q\u0002;C\u0002\u0005=!!\u0001+\u0012\t\u0005E\u0011q\u0003\t\u0004\u001f\u0005M\u0011bAA\u000b!\t9aj\u001c;iS:<\u0007cA\b\u0002\u001a%\u0019\u00111\u0004\t\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002 m\u0011\r\u0011\"\u0003\u0002\"\u0005A\u0011n]!di&4X-\u0006\u0002\u0002$A!\u0011QEA\u001c\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012AB1u_6L7M\u0003\u0003\u0002.\u0005=\u0012AC2p]\u000e,(O]3oi*!\u0011\u0011GA\u001a\u0003\u0011)H/\u001b7\u000b\u0005\u0005U\u0012\u0001\u00026bm\u0006LA!!\u000f\u0002(\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:D\u0001\"!\u0010\u001cA\u0003%\u00111E\u0001\nSN\f5\r^5wK\u0002Bq!!\u0011\u001c\t\u0003\t\u0019%\u0001\u000biC:$G.Z%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\bM\u0006\u0015\u0013\u0011LA/\u0011!\t9%a\u0010A\u0002\u0005%\u0013a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u0011\t\u0005-\u00131\u000b\b\u0005\u0003\u001b\ny\u0005\u0005\u0002{!%\u0019\u0011\u0011\u000b\t\u0002\rA\u0013X\rZ3g\u0013\u0011\t)&a\u0016\u0003\rM#(/\u001b8h\u0015\r\t\t\u0006\u0005\u0005\b\u00037\ny\u00041\u0001&\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\"A\u0011qLA \u0001\u0004\t\t'\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB\u0019\u00111\r0\u000e\u0003mAq!a\u001a\u001c\t\u0013\tI'A\u000eqe\u0016\u0004\u0018M]3J]&$\bK]8ek\u000e,\u0017\n\u001a+sC:\u001c\u0018\u000e\u001e\u000b\u000b\u0003W\nI(a\u001f\u0002~\u0005\u0005\u0005#BA2i\u00065\u0004CB\b\u0002p\u0015\n\u0019(C\u0002\u0002rA\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001\u0006\u0002v%\u0019\u0011q\u000f\u0002\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/\u0019\u0005\t\u0003\u000f\n)\u00071\u0001\u0002J!9\u00111LA3\u0001\u0004)\u0003bBA@\u0003K\u0002\r!J\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"D\u0001\"a!\u0002f\u0001\u0007\u0011QQ\u0001\fibtW*\u001a;bI\u0006$\u0018\rE\u0002\u000b\u0003\u000fK1!!#\u0003\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011\u001d\tii\u0007C\u0001\u0003\u001f\u000b\u0001\u0005[1oI2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016:b]N\f7\r^5p]RYa-!%\u0002\u0014\u0006u\u0015qUA`\u0011!\t9%a#A\u0002\u0005%\u0003\u0002CAK\u0003\u0017\u0003\r!a&\u0002\u0015A\u0014x\u000eZ;dKJLE\rE\u0002\u0010\u00033K1!a'\u0011\u0005\u0011auN\\4\t\u0011\u0005}\u00151\u0012a\u0001\u0003C\u000bQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007cA\b\u0002$&\u0019\u0011Q\u0015\t\u0003\u000bMCwN\u001d;\t\u0011\u0005%\u00161\u0012a\u0001\u0003W\u000b!\u0002]1si&$\u0018n\u001c8t!\u0019\ti+a-\u000286\u0011\u0011q\u0016\u0006\u0004\u0003c\u0003\u0012AC2pY2,7\r^5p]&!\u0011QWAX\u0005\r\u0019V\r\u001e\t\u0005\u0003s\u000bY,D\u0001G\u0013\r\tiL\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011!\ty&a#A\u0002\u0005\u0005\u0007cAA2S\"9\u0011QY\u000e\u0005\u0002\u0005\u001d\u0017\u0001\u00065b]\u0012dW\r\u0016=o\u00136l\u0017n\u001a:bi&|g\u000eF\u0003g\u0003\u0013\fi\rC\u0004\u0002L\u0006\r\u0007\u0019A\u0013\u0002'QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00133\t\u000f\u0005}\u00141\u0019a\u0001K!9\u0011\u0011[\u000e\u0005\u0002\u0005M\u0017a\u00055b]\u0012dW\r\u0016=o\u000b6LwM]1uS>tG#\u00024\u0002V\u0006]\u0007bBAf\u0003\u001f\u0004\r!\n\u0005\b\u0003\u007f\ny\r1\u0001&\u0011\u001d\tYn\u0007C\u0005\u0003;\fq\u0005\\8h\u0013:4\u0018\r\\5e'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]\u0006sGMU3ukJtWI\u001d:peRA\u0011q\\Au\u0003W\f)\u0010E\u0004\u0002b\u0006\u0015H.!\u0005\u000e\u0005\u0005\r(bAA\u0019!%!\u0011q]Ar\u0005\u0011aUM\u001a;\t\u0011\u0005\u001d\u0013\u0011\u001ca\u0001\u0003\u0013B\u0001\"!<\u0002Z\u0002\u0007\u0011q^\u0001\u0011iJ\fgn]1di&|gn\u0015;bi\u0016\u00042ACAy\u0013\r\t\u0019P\u0001\u0002\u0011)J\fgn]1di&|gn\u0015;bi\u0016D\u0001\"a>\u0002Z\u0002\u0007\u0011\u0011`\u0001\u0012iJ\fgn]1di&|gNU3tk2$\b\u0003BA~\u0005\u0003i!!!@\u000b\u0007\u0005}h)\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011\u0019!!@\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG\u000fC\u0004\u0003\bm!\tA!\u0003\u0002)!\fg\u000e\u001a7f\u000b:$GK]1og\u0006\u001cG/[8o)-1'1\u0002B\u0007\u0005\u001f\u0011\tB!\u0006\t\u0011\u0005\u001d#Q\u0001a\u0001\u0003\u0013B\u0001\"!&\u0003\u0006\u0001\u0007\u0011q\u0013\u0005\t\u0003?\u0013)\u00011\u0001\u0002\"\"A!1\u0003B\u0003\u0001\u0004\tI0A\buq:l\u0015M]6feJ+7/\u001e7u\u0011!\tyF!\u0002A\u0002\t]\u0001cAA2e\"9!1D\u000e\u0005\u0002\tu\u0011a\u0006;sC:\u001c\u0018m\u0019;j_:$v\u000e]5d\u0007>tg-[4t+\t\u0011y\u0002\u0005\u0003\u0003\"\t\rRBAA\u0018\u0013\u0011\u0011)#a\f\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0003*m!\tAa\u000b\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0015\u0007\u0015\u0012i\u0003\u0003\u0005\u0002H\t\u001d\u0002\u0019AA%\u0011\u001d\u0011\td\u0007C\u0005\u0005g\t\u0011$\u00192peR$\u0016.\\3e\u001fV$HK]1og\u0006\u001cG/[8ogR\ta\rC\u0004\u00038m!\tA!\u000f\u0002\u000fM$\u0018M\u001d;vaR\u0019aMa\u000f\t\u0015\tu\"Q\u0007I\u0001\u0002\u0004\u0011y$A\u0010f]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:\u00042a\u0004B!\u0013\r\u0011\u0019\u0005\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\u00119e\u0007C\u0001\u0005g\t\u0001b\u001d5vi\u0012|wO\u001c\u0005\n\u0005\u0017Z\u0012\u0013!C\u0001\u0005\u001b\n\u0011c\u001d;beR,\b\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yE\u000b\u0003\u0003@\tE3F\u0001B*!\u0011\u0011)Fa\u0018\u000e\u0005\t]#\u0002\u0002B-\u00057\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tu\u0003#\u0001\u0006b]:|G/\u0019;j_:LAA!\u0019\u0003X\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000f\t\u0015t\u00031\u0001\u0003h\u000511m\u001c8gS\u001e\u0004BA!\u001b\u0003p5\u0011!1\u000e\u0006\u0004\u0005[2\u0011AB:feZ,'/\u0003\u0003\u0003r\t-$aC&bM.\f7i\u001c8gS\u001eDqA!\u001e\u0018\u0001\u0004\u00119(\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\t\t%$\u0011P\u0005\u0005\u0005w\u0012YG\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000b9:\u0002\u0019A\u0018\t\u000f\t\u0005u\u00031\u0001\u0003\u0004\u0006A!p[\"mS\u0016tG\u000f\u0005\u0003\u0003\u0006\n-UB\u0001BD\u0015\r\u0011IIB\u0001\u0003u.LAA!$\u0003\b\ni1*\u00194lCj[7\t\\5f]RDqA!%\u0018\u0001\u0004\u0011\u0019*A\u0004nKR\u0014\u0018nY:\u0011\t\tU%\u0011T\u0007\u0003\u0005/S1A!%G\u0013\u0011\u0011YJa&\u0003\u000f5+GO]5dg\"9!qT\fA\u0002\t\u0005\u0016!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0003\u0003j\t\r\u0016\u0002\u0002BS\u0005W\u0012Q\"T3uC\u0012\fG/Y\"bG\",\u0007\"\u0002\"\u0018\u0001\u0004\u0019\u0005b\u0002BV\u0017\u0011%!QV\u0001\u0015S:LG\u000f\u0016:b]N\f7\r^5p]\u0016\u0013(o\u001c:\u0015\u0007\r\u0014y\u000bC\u0004\u00032\n%\u0006\u0019\u00017\u0002\u000b\u0015\u0014(o\u001c:\t\u000f\tU6\u0002\"\u0003\u00038\u00069\u0012N\\5u)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0004G\ne\u0006\u0002CAB\u0005g\u0003\r!a\u001d")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final ProducerIdManager producerIdManager;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, KafkaZkClient kafkaZkClient, Metrics metrics, MetadataCache metadataCache, Time time) {
        return TransactionCoordinator$.MODULE$.apply(kafkaConfig, replicaManager, scheduler, kafkaZkClient, metrics, metadataCache, time);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionCoordinator transactionCoordinator = this;
        synchronized (transactionCoordinator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Function1<InitProducerIdResult, BoxedUnit> responseCallback) {
        if (transactionalId == null) {
            long producerId = this.producerIdManager.generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
        } else if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
        } else if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
        } else {
            Right right;
            Tuple2 tuple2;
            Either coordinatorEpochAndMetadata = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Either<Errors, CoordinatorEpochAndTxnMetadata> either;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    long producerId = $this.producerIdManager.generateProducerId();
                    String x$6 = transactionalId;
                    long x$7 = producerId;
                    short x$8 = -1;
                    int x$9 = transactionTimeoutMs;
                    Empty$ x$10 = Empty$.MODULE$;
                    scala.collection.mutable.Set x$11 = Set$.MODULE$.empty();
                    long x$12 = $this.time.milliseconds();
                    long x$13 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
                    TransactionMetadata createdMetadata = new TransactionMetadata(x$6, x$7, x$8, x$9, x$10, (scala.collection.mutable.Set<TopicPartition>)x$11, x$13, x$12);
                    either = $this.txnManager.putTransactionStateIfNotExists(transactionalId, createdMetadata);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
                } else {
                    throw new MatchError((Object)option);
                }
                return either;
            });
            Either result = coordinatorEpochAndMetadata.right().flatMap((Function1 & Serializable & scala.Serializable)existingEpochAndMetadata -> {
                int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
                return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> this.prepareInitProduceIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata));
            });
            Either either = result;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors error2 = (Errors)left.value();
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                BoxedUnit boxedUnit;
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                TransactionState transactionState = newMetadata.txnState();
                PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                    this.handleEndTransaction(transactionalId, newMetadata.producerId(), newMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                        TransactionCoordinator.sendRetriableErrorCallback$1(error, responseCallback);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                        this.sendPidResponseCallback$1(error, transactionalId, responseCallback, newMetadata);
                        return BoxedUnit.UNIT;
                    }, this.txnManager.appendTransactionToLog$default$5());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProduceIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            Left left2;
            TransactionState transactionState = txnMetadata.state();
            boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
            if (bl) {
                left2 = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
                if (bl2) {
                    TxnTransitMetadata txnTransitMetadata;
                    if (txnMetadata.isProducerEpochExhausted()) {
                        long newProducerId = this.producerIdManager.generateProducerId();
                        txnTransitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds());
                    } else {
                        txnTransitMetadata = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, this.time.milliseconds());
                    }
                    TxnTransitMetadata transitMetadata = txnTransitMetadata;
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (Ongoing$.MODULE$.equals(transactionState)) {
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
                } else {
                    boolean bl3 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                    if (bl3) {
                        String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found transactionalId ", " with state ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, txnMetadata.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is illegal as we should never have transitioned to this state."})).s((Seq)Nil$.MODULE$);
                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                }
            }
            left = left2;
        }
        return left;
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning ", " error code to client for ", "'s AddPartitions request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.INVALID_REQUEST, transactionalId})));
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
        } else {
            Right right;
            Tuple2 tuple2;
            Either result = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Left left;
                Option option = x0$2;
                if (None$.MODULE$.equals(option)) {
                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                    TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                    left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        Left left;
                        block8: {
                            block7: {
                                if (txnMetadata.producerId() != producerId) {
                                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    return left;
                                }
                                if (txnMetadata.producerEpoch() != producerEpoch) {
                                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                                    return left;
                                }
                                if (txnMetadata.pendingTransitionInProgress()) {
                                    left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    return left;
                                }
                                TransactionState transactionState = txnMetadata.state();
                                PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                                if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                                TransactionState transactionState2 = txnMetadata.state();
                                PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                                if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                            }
                            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            return left;
                        }
                        TransactionState transactionState = txnMetadata.state();
                        Ongoing$ ongoing$ = Ongoing$.MODULE$;
                        if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                            left = package$.MODULE$.Left().apply((Object)Errors.NONE);
                            return left;
                        }
                        left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                        return left;
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                return left;
            });
            Either either = result;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning ", " error code to client for ", "'s AddPartitions request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{err, transactionalId})));
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)err);
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, this.txnManager.appendTransactionToLog$default$5());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    public void handleTxnImmigration(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function5 & Serializable & scala.Serializable)(transactionalId, coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void handleTxnEmigration(int txnTopicPartitionId, int coordinatorEpoch) {
        this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch);
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId: ", "'s state is ", ", but received transaction "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, transactionState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"marker result to send: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionResult})));
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
        } else {
            Right right;
            Tuple2 tuple2;
            Either preAppendResult = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Left left;
                Option option = x0$3;
                if (None$.MODULE$.equals(option)) {
                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                    int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                    left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        Right right;
                        TransactionState transactionState;
                        Right right2;
                        if (txnMetadata.producerId() != producerId) {
                            right2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            return right2;
                        }
                        if (producerEpoch < txnMetadata.producerEpoch()) {
                            right2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                            return right2;
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            Object object = txnMetadata.pendingState().get();
                            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                            if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                                right2 = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                return right2;
                            }
                        }
                        if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                            Product nextState;
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult2 = TransactionResult.COMMIT;
                            Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                                txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                                txnMetadata.producerEpoch_$eq(producerEpoch);
                            }
                            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                        } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult3 = TransactionResult.COMMIT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult4 = TransactionResult.ABORT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult5 = TransactionResult.COMMIT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult6 = TransactionResult.ABORT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (Empty$.MODULE$.equals(transactionState)) {
                            right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else {
                            boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                            if (!bl) throw new MatchError((Object)transactionState);
                            String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found transactionalId ", " with state ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, txnMetadata.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is illegal as we should never have transitioned to this state."})).s((Seq)Nil$.MODULE$);
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        right2 = right;
                        return right2;
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                return left;
            });
            Either either = preAppendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting append of ", " to transaction log with coordinator and returning ", " error to client for ", "'s EndTransaction request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarkerResult, err, transactionalId})));
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)err);
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                    this.sendTxnMarkersCallback$1(error, transactionalId, producerId, producerEpoch, txnMarkerResult, responseCallback, coordinatorEpoch, newMetadata);
                    return BoxedUnit.UNIT;
                }, this.txnManager.appendTransactionToLog$default$5());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void abortTimedOutTransactions() {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).right().flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Left left;
            Option option = x0$5;
            if (None$.MODULE$.equals(option)) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find transaction metadata when trying to timeout transaction with transactionalId "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". ProducerId: ", ". ProducerEpoch: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch.transactionalId(), BoxesRunTime.boxToLong((long)txnIdAndPidEpoch.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)txnIdAndPidEpoch.producerEpoch())})));
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
            } else if (option instanceof Some) {
                Left left2;
                Some some = (Some)option;
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                Either transitMetadata = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Object object;
                    if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found incorrect producerId when expiring transactionalId: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch.transactionalId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected producerId: ", ". Found producerId: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnIdAndPidEpoch.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnMetadata.producerId())})));
                        object = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    } else {
                        object = txnMetadata.pendingTransitionInProgress() ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : package$.MODULE$.Right().apply((Object)txnMetadata.prepareFenceProducerEpoch());
                    }
                    return object;
                });
                Either either = transitMetadata;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    TxnTransitMetadata txnTransitMetadata = (TxnTransitMetadata)right.value();
                    this.handleEndTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$6 -> {
                        TransactionCoordinator.$anonfun$abortTimedOutTransactions$6(this, txnIdAndPidEpoch, x0$6);
                        return BoxedUnit.UNIT;
                    });
                    left2 = package$.MODULE$.Right().apply((Object)txnTransitMetadata);
                } else {
                    left2 = package$.MODULE$.Left().apply((Object)either);
                }
                left = left2;
            } else {
                throw new MatchError((Object)option);
            }
            return left;
        }));
    }

    public void startup(boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.abortTimedOutTransactions(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        if (enableTransactionalIdExpiration) {
            this.txnManager.enableTransactionalIdExpiration();
        }
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$1() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager.shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
        } else {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
        }
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, Function1 responseCallback$1, TxnTransitMetadata newMetadata$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized transactionalId ", " with producerId ", " and producer "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, BoxesRunTime.boxToLong((long)newMetadata$1.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch ", " on partition "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)newMetadata$1.producerEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__transaction_state", BoxesRunTime.boxToInteger((int)$this.txnManager.partitionFor(transactionalId$1))})));
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning ", " error code to client for ", "'s InitProducerId request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, transactionalId$1})));
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$2, long producerId$1, short producerEpoch$1, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$2) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$2).right().flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Left left;
                Option option = x0$4;
                if (None$.MODULE$.equals(option)) {
                    String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The coordinator still owns the transaction partition for ", ", but there is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no metadata in the cache; this is not expected"})).s((Seq)Nil$.MODULE$);
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$4) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId$1) {
                                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            } else if (txnMetadata.producerEpoch() != producerEpoch$1) {
                                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                            } else if (txnMetadata.pendingTransitionInProgress()) {
                                left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            } else {
                                Left<Errors, Nothing$> left2;
                                TransactionState transactionState = txnMetadata.state();
                                boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                if (bl) {
                                    left2 = this.logInvalidStateTransitionAndReturnError(transactionalId$2, txnMetadata.state(), txnMarkerResult$1);
                                } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                    TransactionResult transactionResult = txnMarkerResult$1;
                                    TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                    left2 = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$2, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                    TransactionResult transactionResult = txnMarkerResult$1;
                                    TransactionResult transactionResult3 = TransactionResult.ABORT;
                                    left2 = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$2, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                } else {
                                    boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                    if (bl2) {
                                        String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found transactionalId ", " with state ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2, txnMetadata.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is illegal as we should never have transitioned to this state."})).s((Seq)Nil$.MODULE$);
                                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                        throw new IllegalStateException(errorMsg);
                                    }
                                    throw new MatchError((Object)transactionState);
                                }
                                left = left2;
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The transaction coordinator epoch has changed to ", " after ", " was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epochAndMetadata.coordinatorEpoch()), txnMarkerResult$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"successfully appended to the log for ", " with old epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2, BoxesRunTime.boxToInteger((int)coordinatorEpoch$4)})));
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError((Object)option);
                }
                Left left2 = left;
                return left2;
            });
            Either either = preSendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting sending of transaction markers after appended ", " to transaction log and returning ", " error to client for ", "'s EndTransaction request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarkerResult$1, err, transactionalId$2})));
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            } else {
                Right right;
                Tuple2 tuple2;
                if (!(either instanceof Right) || (tuple2 = (Tuple2)(right = (Right)either).value()) == null) throw new MatchError((Object)either);
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId$2, coordinatorEpoch$4, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting sending of transaction markers and returning ", " error to client for ", "'s EndTransaction request of ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, transactionalId$2, txnMarkerResult$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"since appending ", " to transaction log with coordinator epoch ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newMetadata$2, BoxesRunTime.boxToInteger((int)coordinatorEpoch$4)})));
            responseCallback$2.apply((Object)error);
        }
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$6(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$1, Errors x0$6) {
        Errors errors = x0$6;
        if (Errors.NONE.equals(errors)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed rollback ongoing transaction of transactionalId: ", " due to timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch$1.transactionalId()})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(errors) ? true : (Errors.INVALID_PRODUCER_EPOCH.equals(errors) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(errors));
            if (bl) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling back ongoing transaction of transactionalId: ", " has aborted due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch$1.transactionalId(), errors.exceptionName()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling back ongoing transaction of transactionalId: ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch$1.transactionalId(), errors.exceptionName()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public TransactionCoordinator(int brokerId, TransactionConfig txnConfig, Scheduler scheduler, ProducerIdManager producerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.producerIdManager = producerIdManager;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
    }
}

