<?php
/**
 * ラベル一覧の取得
 * @attribute list
 */
class LabelListAction extends SOY2Action{

    protected function execute(SOY2ActionRequest &$request,SOY2ActionForm &$form,SOY2ActionResponse &$response){
		$logic = SOY2Logic::createInstance("logic.site.Label.LabelLogic");
		try{
			$labels = $logic->get();
			
			//エントリー管理者の場合
			if(!UserInfoUtil::hasSiteAdminRole()){
				$res = array();
				foreach($labels as $key => $label){
					if(!preg_match('/^\*/',$label->getCaption())){
						$res[$key] = $label;
					}
				}
				
				$labels = $res;
			}
			
			$this->setAttribute("list",$labels);
		}catch(Exception $e){
			$this->setErrorMessage("failed","ラベル一覧の取得失敗");	
		}
		return SOY2Action::SUCCESS;
	}
}
?>