/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.run;

import br.arca.morcego.Config;
import br.arca.morcego.exception.WrongDataFormat;
import br.arca.morcego.run.Animator;
import br.arca.morcego.run.ControlledRunnable;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.GraphElementFactory;
import br.arca.morcego.structure.Link;
import br.arca.morcego.structure.Node;
import br.arca.morcego.transport.Transport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Feeder
extends ControlledRunnable {
    private Graph graph;
    private Transport transport;
    private Animator animator;
    private boolean shouldWait = false;

    public Feeder(Graph g, Transport t) {
        this.graph = g;
        this.transport = t;
        this.animator = new Animator(this.graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feed(Hashtable graphData) throws WrongDataFormat {
        Graph graph = this.graph;
        synchronized (graph) {
            Vector nodes = this.extractNodes(graphData);
            this.extractLinks(graphData);
            this.animator.animate(nodes);
        }
    }

    public Vector extractNodes(Hashtable graphData) throws WrongDataFormat {
        Hashtable nodesData;
        Vector<Node> nodes = new Vector<Node>();
        try {
            nodesData = (Hashtable)graphData.get("nodes");
        }
        catch (ClassCastException e) {
            throw new WrongDataFormat();
        }
        Enumeration eN = nodesData.keys();
        while (eN.hasMoreElements()) {
            String nodeId = (String)eN.nextElement();
            Hashtable nodeData = (Hashtable)nodesData.get(nodeId);
            Node node = GraphElementFactory.createNode(nodeId, this.graph, (String)nodeData.get("type"));
            node.setProperties(nodeData);
            node.init();
            nodes.add(node);
        }
        return nodes;
    }

    public void extractLinks(Hashtable graphData) throws WrongDataFormat {
        Vector linksData;
        try {
            linksData = (Vector)graphData.get("links");
        }
        catch (ClassCastException e) {
            throw new WrongDataFormat();
        }
        Enumeration eN = linksData.elements();
        while (eN.hasMoreElements()) {
            Hashtable linkData = (Hashtable)eN.nextElement();
            Node node1 = this.graph.getNodeById((String)linkData.get("from"));
            Node node2 = this.graph.getNodeById((String)linkData.get("to"));
            if (node1 == null || node2 == null) continue;
            Link link = GraphElementFactory.createLink(node1, node2, (String)linkData.get("type"));
            link.setProperties(linkData);
            link.init();
        }
    }

    public void notifyFeeder() {
        this.shouldWait = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        Thread animationThread = new Thread(this.animator);
        animationThread.start();
        this.running = true;
        while (this.running) {
            Hashtable graphData;
            Feeder feeder = this;
            synchronized (feeder) {
                try {
                    if (this.shouldWait) {
                        this.wait();
                    }
                    this.shouldWait = true;
                }
                catch (InterruptedException e1) {
                    break;
                }
            }
            try {
                graphData = this.transport.retrieveData(this.graph.getCenterId(), (Integer)Config.getValue("morcego.navigationDepth"));
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
            try {
                this.feed(graphData);
            }
            catch (WrongDataFormat e) {
                e.printStackTrace();
            }
        }
    }
}

