<?php

error_reporting(-1);

if (function_exists('ini_set')) {
    @ini_set('display_errors', 1);
    @ini_set('display_startup_errors', 1);
    @ini_set('opcache.enable_cli', '0');

    if (isset($_GET['opcache_reset']) && $_GET['opcache_reset'] === md5(Phar::running(false))) {
        $GLOBALS['opcacheEnabled'] = @ini_get('opcache.enable');
    } else {
        $GLOBALS['opcacheEnabled'] = @ini_set('opcache.enable', '0');
    }
}

if (PHP_VERSION_ID < 50509) {
    die('You are using PHP '.PHP_VERSION." but you need least PHP 5.5.9 to run the Contao Manager.\n");
}

if (!extension_loaded('Phar')) {
    echo 'PHP\'s phar extension is missing. Contao Manager requires it to run. Enable the extension or recompile php without --disable-phar then try again.' . PHP_EOL;
    exit(1);
}

if (PHP_VERSION_ID < 70205) {
    Phar::mapPhar('contao-manager.phar');
    @include 'phar://contao-manager.phar/downgrade.php';
    die('<script>setTimeout(function() { window.location.reload(true) }, 1000)</script>');
}

if (function_exists('date_default_timezone_set') && function_exists('date_default_timezone_get')) {
    date_default_timezone_set(@date_default_timezone_get());
}

if ('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) {
    if (isset($_SERVER['argv'][1]) && 'test' === $_SERVER['argv'][1]) {
        die(json_encode(['version' => PHP_VERSION, 'version_id' => PHP_VERSION_ID, 'sapi' => PHP_SAPI]));
    }

    Phar::mapPhar('contao-manager.phar');
    require 'phar://contao-manager.phar/api/console';
} else {
    function rewrites()
    {
        // The function argument is unreliable across servers, Nginx for example is always empty
        list(,$url) = explode(basename(__FILE__), $_SERVER['REQUEST_URI'], 2);

        if (strpos($url, '..')) {
            return false;
        }

        if ('' === $url) {
            header('Location: /'.basename(__FILE__).'/');
            exit;
        }

        if (0 === strpos($url, '/api/')) {
            return '/dist/api.php'.$url;
        }

        if (!empty($url) && is_file('phar://'.__FILE__.'/dist'.$url)) {
            return '/dist'.$url;
        }

        return '/dist/index.html';
    }

    Phar::webPhar(
        null,
        'index.html',
        null,
        array(
            'log' => 'text/plain',
            'txt' => 'text/plain',
            'php' => Phar::PHP, // parse as PHP
            'css' => 'text/css',
            'gif' => 'image/gif',
            'html' => 'text/html',
            'ico' => 'image/x-ico',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'js' => 'application/x-javascript',
            'png' => 'image/png',
            'svg' => 'image/svg+xml',
            'json' => 'application/json'
        ),
        'rewrites'
    );
}

__HALT_COMPILER(); ?>
a} A
                 .box/bin/check-requirements.php  1f  ^ʨ         .box/.requirements.php	  1f	  if.         .box/vendor/autoload.php   1f   s      ,   .box/vendor/composer/autoload_namespaces.php   1f   t!פ         .box/vendor/composer/LICENSE.  1f.         $   .box/vendor/composer/ClassLoader.php>  1f>  5Ky      &   .box/vendor/composer/autoload_psr4.php6  1f6   0Ӥ      *   .box/vendor/composer/autoload_classmap.php,
  1f,
  ӽǤ      (   .box/vendor/composer/autoload_static.phpK  1fK  ?      &   .box/vendor/composer/autoload_real.php   1f   yi\      .   .box/vendor/composer/semver/src/Comparator.phpu  1fu  	74      *   .box/vendor/composer/semver/src/Semver.php  1f  ׯ      1   .box/vendor/composer/semver/src/VersionParser.php9  1f9  Wz      B   .box/vendor/composer/semver/src/Constraint/ConstraintInterface.php  1f  wQ      >   .box/vendor/composer/semver/src/Constraint/MultiConstraint.php~  1f~  5[e      9   .box/vendor/composer/semver/src/Constraint/Constraint.php'&  1f'&  `         .box/src/Terminal.php
  1f
  %V         .box/src/IO.php   1f   [l%      !   .box/src/IsExtensionFulfilled.phpv  1fv  '0Ҥ         .box/src/Checker.php  1f  )W>      "   .box/src/IsPhpVersionFulfilled.php  1f  !83      "   .box/src/RequirementCollection.php  1f  Wb?         .box/src/Printer.php  1f  )8AV         .box/src/IsFulfilled.phpv   1fv   %*H         .box/src/Requirement.phpm  1fm  B         LICENSE  1f  p         dist/index.html(  1f(  R         dist/api.php--  1f  fd      #   dist/css/chunk-vendors.b192971e.cssǯ  1fǯ  wbƤ         dist/css/app.d418b1bd.css"< 1f"< M         dist/js/518-legacy.5feef192.jsg  1fg  IW         dist/js/120-legacy.4c99f92e.jsq  1fq  8,i         dist/js/560.75e6b27d.jsP  1fP  n̤         dist/js/721.d898189f.js  1f  ƿ         dist/js/706-legacy.08db35f2.js  1f  >z         dist/js/542-legacy.0741319d.js  1f  ]l1         dist/js/app-legacy.51e2026a.jsS 1fS          dist/js/874-legacy.7603d6d2.js  1f  ̤         dist/js/44-legacy.fcf9eee5.jsq  1fq  &         dist/js/486-legacy.6d5eb5d6.js  1f  #A         dist/js/557-legacy.6741a1e6.js  1f  j|         dist/js/710.3935c7a1.js| 1f|          dist/js/557.9c9e4940.js  1f  =]ɤ         dist/js/715.3a99c872.js  1f  H̶         dist/js/219.fc32cba9.js
  1f
  C
F         dist/js/139-legacy.894eff29.jsU  1fU  Zɤ         dist/js/606.f6453cd1.js  1f  O         dist/js/953.6c4bb92c.js.  1f.           dist/js/52-legacy.966ba7cd.js  1f  q	         dist/js/551.e416c3f7.js  1f  Xmޤ         dist/js/219-legacy.fc32cba9.js
  1f
  C
F         dist/js/643.d7463852.jsi  1fi  ڤ      (   dist/js/chunk-vendors-legacy.c4c10512.js 1f ¤         dist/js/638.7bf69167.js  1f  a믪         dist/js/606-legacy.fd640ebc.js  1f  h`
         dist/js/669.1872b03b.jsz  1fz  YH         dist/js/540-legacy.b8533ccf.js  1f  |H         dist/js/518.81524b2d.jsf  1ff  
      !   dist/js/chunk-vendors.2e54a44f.js% 1f% /Vl         dist/js/28-legacy.da5bae92.jsw  1fw  #&         dist/js/554.24fb269a.jsJ  1fJ  ~         dist/js/638-legacy.bc4501e3.js  1f           dist/js/551-legacy.3f3b1ac1.js  1f  b*         dist/js/194.a8ab8a1e.js  1f  ИU         dist/js/560-legacy.79a86693.jsQ  1fQ  }         dist/js/194-legacy.ed831e27.js  1f           dist/js/120.10e3ad71.jsp  1fp           dist/js/139.5c0071ca.jsU  1fU  x0L6         dist/js/553.c77dd5a9.js  1f  >l         dist/js/710-legacy.a4174541.js| 1f| s
         dist/js/851.f32f0a18.js  1f  QY         dist/js/367-legacy.39f93e6e.js  1f  n         dist/js/553-legacy.24506bdb.js  1f  i@Y         dist/js/477-legacy.908e4c92.js  1f  b         dist/js/140-legacy.e35b1166.js>  1f>  ~Tl         dist/js/164-legacy.40a47c66.js  1f  ER         dist/js/669-legacy.8a43d5bc.js{  1f{  !s         dist/js/581-legacy.74bebd8c.js  1f  
?         dist/js/540.ad333c3a.js  1f           dist/js/180.757c9298.js  1f  4(         dist/js/874.7cf6d49e.js
  1f
           dist/js/477.ce18d771.js  1f           dist/js/953-legacy.61dcbdfd.js/  1f/  
         dist/js/app.4e112694.js: 1f:          dist/js/706.d24c1564.js  1f  U8         dist/js/140.686354c2.js=  1f=  3N         dist/js/486.e00ad270.js  1f  !         dist/js/523.5b6e5a1c.js  1f  3         dist/js/769-legacy.91268d26.js  1f  .٤         dist/js/44.113ca43b.jsn  1fn  fO         dist/js/851-legacy.705ac32c.js  1f  H         dist/js/721-legacy.d6ed9613.js  1f  i         dist/js/958.18ef1cc5.jsS  1fS  CIsƤ         dist/js/958-legacy.7876f68e.jsS  1fS  *Y8         dist/js/164.d778c5ce.js  1f  X         dist/js/542.7bfce7d7.js  1f           dist/js/643-legacy.e8d2c597.jsj  1fj  a*         dist/js/367.5c1f9130.js  1f  j         dist/js/581.82f755e9.js  1f  4         dist/js/716.35348f3c.jsA  1fA  Cd         dist/js/554-legacy.a1aaca80.jsK  1fK  Ф         dist/js/523-legacy.b3e974f6.js  1f  :Ԥ         dist/js/769.c44bd44f.js  1f  	9         dist/js/715-legacy.dd945745.js  1f  °u         dist/js/716-legacy.6667f3c2.jsB  1fB   c         dist/js/28.e44c5c50.jsw  1fw  Ig0         dist/js/52.885d9a58.js  1f  yW         dist/js/180-legacy.1f370e2e.js  1f        !   dist/img/button-show.2336e1d9.svgS  1fS  U      #   dist/img/updated--dark.6c7ad8f3.svg?  1f?  R      )   dist/img/button-incompatible.6d0ea849.svg  1f  "      $   dist/img/button-details.78532630.svg  1f  EΤ         dist/img/funding.8a3c0e0e.svgB  1fB  rAݤ         dist/img/task.30a3fdc0.svgt  1ft  PƤ          dist/img/button-add.759df12e.svg   1f   O
         dist/img/logo.9c3b3279.svg  1f  
ͤ      (   dist/img/color_scheme--dark.57222cc0.svg:  1f:        %   dist/img/button-download.ce5cd0d3.svg-  1f-  F      "   dist/img/button-cloud.5015c41d.svg  1f  2攕      !   dist/img/button-edit.d4a8737e.svg  1f  uC      #   dist/img/server-config.1a2d0888.svgg  1fg  RN         dist/img/language.509ee1aa.svgq  1fq  ,;      "   dist/img/button-power.6b957f3a.svg/  1f/  ^S         dist/img/sad.c9a06488.svg6  1f6  lE1      &   dist/img/link-blank--dark.74e01873.svg   1f         $   dist/img/create-project.b22522ee.svg   1f   ʅ      #   dist/img/document-root.0e6dd2e4.svg   1f   D      (   dist/img/symfony-logo--dark.36941dc4.svg
  1f
  wC      "   dist/img/color_scheme.a51e992d.svg   1f   j      $   dist/img/button-console.93e68609.svg   1f   o۪      !   dist/img/button-hide.6a3eaaf7.svg  1f  q      "   dist/img/button-check.8170bc92.svg   1f   jG1         dist/img/favers.f48a12a8.svg6  1f6  }ͤ      &   dist/img/button-cloud-off.37842942.svg  1f  4N         dist/img/offline.1f95ae24.svg  1f  9         dist/img/person.00d78897.svg   1f   w*         dist/img/updated.b67e9160.svgB  1fB  nCOP      !   dist/img/button-lock.98988f08.svgc  1fc  5=6z      "   dist/img/symfony-logo.9bfb375e.svg
  1f
  y3         dist/img/php-logo.e15778f8.svg&	  1f&	  5û         dist/img/warning.a0297242.svg   1f   J         dist/img/user.129e863d.svg   1f   cǤ      "   dist/img/button-trash.a2f11028.svgt  1ft  T[      #   dist/img/button-update.c63bd5a5.svgX  1fX  tPɤ      '   dist/img/search-by-algolia.47401192.svg  1f  w1      '   dist/img/widget-radio--off.4e93f443.svg  1f        !   dist/img/button-save.7704614c.svg	  1f	  G         dist/img/hint.ba2ac97e.svg!  1f!           dist/img/database.7f0a8c49.svg  1f  <	      (   dist/img/button-maintenance.18fa2ce6.svgB  1fB  /Ӥ         dist/img/lock.3c42a55f.svgf  1ff  gG      )   dist/img/widget-checkbox--on.c05d996c.svg   1f   Ts>         dist/img/recovery.70ee118a.svg   1f   OTM`         dist/img/downloads.ef96865d.svg%  1f%  i`5      "   dist/img/favers--dark.8589e259.svg3  1f3  0         dist/img/boot.c1251f6b.svg  1f  b      "   dist/img/link-funding.c73bb011.svg   1f   i      !   dist/img/button-gear.75fa79f0.svg  1f  3      #   dist/img/button-unlock.51b76e07.svgi  1fi  
      %   dist/img/downloads--dark.6070f904.svg"  1f"  Ѥ      !   dist/img/button-more.e3eb2622.svg  1f  v          dist/img/link-blank.04773c88.svg   1f   agA      #   dist/img/button-search.6f2edfbf.svgH  1fH  2Z          dist/img/button-run.5c7703ae.svg  1f  7      &   dist/img/widget-radio--on.181461b6.svg:  1f:  j
M      #   dist/img/button-upload.b489ceec.svg/  1f/  }      %   dist/img/button-database.1f267fe1.svg   1f   }l      !   dist/img/button-link.e4488c1f.svg   1f   6         dist/img/close.88e95867.svg   1f   F$         dist/img/private.2455f3fb.svg
  1f
  Ս      $   dist/img/language--dark.384e91d7.svgn  1fn  PK;      *   dist/img/widget-checkbox--off.73856538.svg   1f   ~      #   dist/img/private--dark.1a50a552.svg  1f  3      (   dist/icons/task-active/favicon-16x16.png3  1f3  K       "   dist/icons/task-active/favicon.ico:  1f:  8      (   dist/icons/task-active/favicon-32x32.pngF  1fF  )fx      '   dist/icons/task-error/favicon-16x16.png;  1f;        !   dist/icons/task-error/favicon.ico:  1f:  u      '   dist/icons/task-error/favicon-32x32.pngB  1fB        )   dist/icons/task-success/favicon-16x16.pngU  1fU  {ؤ      #   dist/icons/task-success/favicon.ico:  1f:  TIm      )   dist/icons/task-success/favicon-32x32.pngq  1fq  ?.         dist/api.php  1f           dist/assets/favicon-16x16.png  1f           dist/assets/mstile-310x310.png  1f  =I      &   dist/assets/android-chrome-384x384.png	'  1f	'  @H      3   dist/assets/apple-touch-startup-image-1125x2436.png  1f  *OW      2   dist/assets/apple-touch-startup-image-1792x828.pngC  1fC   .+      2   dist/assets/apple-touch-startup-image-1334x750.pngE  1fE  +v         dist/assets/mstile-144x144.png  1f  Ҥ      3   dist/assets/apple-touch-startup-image-1290x2796.png9  1f9  =ُ,         dist/assets/favicon.ico  1f  }*~      (   dist/assets/apple-touch-icon-120x120.png
  1f
  !J      3   dist/assets/apple-touch-startup-image-2732x2048.pngr 1fr       &   dist/assets/android-chrome-192x192.pngm  1fm  "u,          dist/assets/apple-touch-icon.png'  1f'  8      3   dist/assets/apple-touch-startup-image-1242x2688.png
  1f
  r2      &   dist/assets/android-chrome-256x256.png  1f  X3@      3   dist/assets/apple-touch-startup-image-2436x1125.png*  1f*  J)         dist/assets/mstile-70x70.png  1f  eݺ=      2   dist/assets/apple-touch-startup-image-640x1136.pngV  1fV  ӣ      3   dist/assets/apple-touch-startup-image-1170x2532.pngr  1fr        *   dist/assets/apple-touch-icon-1024x1024.png  1f  y      (   dist/assets/apple-touch-icon-152x152.png  1f  K      3   dist/assets/apple-touch-startup-image-1620x2160.png+ 1f+ פ      3   dist/assets/apple-touch-startup-image-1668x2388.png> 1f> h[      2   dist/assets/apple-touch-startup-image-828x1792.pngx  1fx  KtS      3   dist/assets/apple-touch-startup-image-2048x1536.png~W 1f~W x      (   dist/assets/apple-touch-icon-180x180.png'  1f'  8      (   dist/assets/yandex-browser-manifest.json   1f   p#Ȥ      3   dist/assets/apple-touch-startup-image-1640x2160.png!2 1f!2 x̤      3   dist/assets/apple-touch-startup-image-2224x1668.png 1f &I      3   dist/assets/apple-touch-startup-image-1179x2556.png  1f  A         dist/assets/favicon-48x48.png  1f  .i         dist/assets/mstile-310x150.png%  1f%  {      3   dist/assets/apple-touch-startup-image-1242x2208.png  1f  ^w      (   dist/assets/apple-touch-icon-114x114.pngS	  1fS	  U      &   dist/assets/apple-touch-icon-76x76.png*  1f*  <&      &   dist/assets/android-chrome-512x512.png8  1f8  =l?      3   dist/assets/apple-touch-startup-image-2556x1179.png  1f         2   dist/assets/apple-touch-startup-image-1136x640.pngk  1fk  .      3   dist/assets/apple-touch-startup-image-2532x1170.png|  1f|  ~Z      3   dist/assets/apple-touch-startup-image-2208x1242.png0 1f0 =:      3   dist/assets/apple-touch-startup-image-1488x2266.png 1f w      &   dist/assets/apple-touch-icon-57x57.png  1f  1@      2   dist/assets/apple-touch-startup-image-750x1334.pngj  1fj  3Fä      3   dist/assets/apple-touch-startup-image-2266x1488.pngS 1fS ?      ,   dist/assets/apple-touch-icon-precomposed.png'  1f'  8      3   dist/assets/apple-touch-startup-image-2160x1620.pngv 1fv k;      3   dist/assets/apple-touch-startup-image-1284x2778.png  1f        3   dist/assets/apple-touch-startup-image-1668x2224.png8 1f8 ϳ      3   dist/assets/apple-touch-startup-image-2688x1242.png  1f  S      &   dist/assets/apple-touch-icon-72x72.png  1f  O      3   dist/assets/apple-touch-startup-image-2778x1284.png% 1f%       3   dist/assets/apple-touch-startup-image-1536x2048.png 1f gl      3   dist/assets/apple-touch-startup-image-2388x1668.png 1f so.         dist/assets/mstile-150x150.png  1f  z          dist/assets/manifest.webmanifest  1f  `l      3   dist/assets/apple-touch-startup-image-2796x1290.pngR& 1fR&       $   dist/assets/android-chrome-36x36.png+  1f+        $   dist/assets/android-chrome-96x96.png  1f  Af      (   dist/assets/apple-touch-icon-167x167.png
  1f
  uD      $   dist/assets/android-chrome-72x72.png  1f  hQ\      &   dist/assets/apple-touch-icon-60x60.png  1f        3   dist/assets/apple-touch-startup-image-2160x1640.png{ 1f{ 	      3   dist/assets/apple-touch-startup-image-2048x2732.png7 1f7 M_Ť      (   dist/assets/apple-touch-icon-144x144.png  1f  A0      $   dist/assets/yandex-browser-50x50.pngX  1fX  X         dist/assets/browserconfig.xmlr  1fr  v,      $   dist/assets/android-chrome-48x48.png  1f  .i         dist/assets/favicon-32x32.png  1f  #      &   dist/assets/android-chrome-144x144.png  1f  Ҥ      %   api/HttpKernel/ApiProblemResponse.php
  1f
  F$X      
   api/console--A  1fA  C~Ƥ         api/Config/UploadsConfig.php  1f  4         api/Config/UserConfig.php!  1f!  H         api/Config/ManagerConfig.php  1f           api/Config/AbstractConfig.php  1f  5qn¤         api/Config/ComposerConfig.php  1f           api/Config/PartialConfig.php  1f  ;Τ         api/Config/AuthConfig.php  1f  T6      *   api/Security/PasswordlessAuthenticator.phph  1fh  ̟      #   api/Security/TokenAuthenticator.php  1f  Qkb         api/Security/UserProvider.php
  1f
  de         api/Security/User.php  1f  ۾Ť      !   api/Security/JwtAuthenticator.php		  1f		  A      -   api/Security/AbstractBrowserAuthenticator.php  1f  %0QŤ      #   api/Security/LoginAuthenticator.phpf	  1ff	  ⴤ         api/Security/JwtManager.php  1f  e H3      .   api/TaskOperation/Composer/RemoveOperation.php  1f  EA      2   api/TaskOperation/Composer/ClearCacheOperation.php  1f  ȝe      4   api/TaskOperation/Composer/DumpAutoloadOperation.php  1f  rǀ      /   api/TaskOperation/Composer/InstallOperation.php  1f  J\      .   api/TaskOperation/Composer/UpdateOperation.php  1f  4      /   api/TaskOperation/Composer/RequireOperation.php  1f  |gO      5   api/TaskOperation/Composer/CreateProjectOperation.php  1f  ;t      -   api/TaskOperation/Composer/CloudOperation.php0  1f0   ᜤ      8   api/TaskOperation/Filesystem/InstallUploadsOperation.php  1f  2      6   api/TaskOperation/Filesystem/RemoveVendorOperation.php  1f  #0      7   api/TaskOperation/Filesystem/RemoveUploadsOperation.php&	  1f&	  8GJ¤      5   api/TaskOperation/Filesystem/RemoveCacheOperation.php  1f  2)=      1   api/TaskOperation/Manager/SelfUpdateOperation.php0  1f0  pUT      -   api/TaskOperation/AbstractInlineOperation.php  1f  =x      1   api/TaskOperation/SponsoredOperationInterface.php  1f  o&!      #   api/TaskOperation/ConsoleOutput.php)  1f)  -      .   api/TaskOperation/AbstractProcessOperation.php
  1f
  _      5   api/TaskOperation/Contao/MaintenanceModeOperation.php7  1f7  jJB      2   api/TaskOperation/Contao/BackupCreateOperation.php  1f        1   api/TaskOperation/Contao/CacheWarmupOperation.php  1f  ݤ      2   api/TaskOperation/Contao/CreateContaoOperation.phpW  1fW  hQ~      3   api/TaskOperation/Contao/BackupRestoreOperation.php  1f  դ      0   api/TaskOperation/Contao/CacheClearOperation.php  1f  i      ,   api/TaskOperation/TaskOperationInterface.php  1f  j         api/Composer/CloudResolver.phpH  1fH  /         api/Composer/CloudChanges.php&  1f&  <T         api/Composer/CloudJob.php	  1f	  R`}         api/Composer/CloudException.php  1f  à         api/Composer/Environment.php@$  1f@$  ^      T   api/Resources/cache/ContainerIXAtexx/getSecurity_Firewall_Map_Context_ApiService.php
  1f
  sjҤ      F   api/Resources/cache/ContainerIXAtexx/getComposerController2Service.php  1f  h3,      N   api/Resources/cache/ContainerIXAtexx/getConsole_Command_SecretsListService.php  1f  2z      P   api/Resources/cache/ContainerIXAtexx/getConsole_Command_SecretsRemoveService.php  1f  ނ(      C   api/Resources/cache/ContainerIXAtexx/getGraphicsLibCheckService.php  1f  S      C   api/Resources/cache/ContainerIXAtexx/getPhpCliControllerService.phpe  1fe  Ȥ      D   api/Resources/cache/ContainerIXAtexx/getTaskDeleteCommandService.php  1f  CQh      ]   api/Resources/cache/ContainerIXAtexx/get_Security_Command_UserPasswordEncoder_LazyService.php  1f  H      `   api/Resources/cache/ContainerIXAtexx/get_Console_Command_SecretsEncryptFromLocal_LazyService.php  1f  F5      G   api/Resources/cache/ContainerIXAtexx/getConstraintControllerService.php\  1f\  y      4   api/Resources/cache/ContainerIXAtexx/removed-ids.phpʎ  1fʎ  jt      G   api/Resources/cache/ContainerIXAtexx/getProcessRunnerCommandService.phpP  1fP  l      C   api/Resources/cache/ContainerIXAtexx/getJwtAuthenticatorService.php  1f  0X      C   api/Resources/cache/ContainerIXAtexx/getContaoControllerService.php>  1f>  Dp      E   api/Resources/cache/ContainerIXAtexx/getSecurity_AccessMapService.php:  1f:  vZ`      H   api/Resources/cache/ContainerIXAtexx/getIntegrityCheckFactoryService.php  1f  <Z      J   api/Resources/cache/ContainerIXAtexx/get_ServiceLocator_DieSC3PService.php  1f  L&      Q   api/Resources/cache/ContainerIXAtexx/getConsole_Command_ContainerDebugService.php  1f  @b<      W   api/Resources/cache/ContainerIXAtexx/get_Console_Command_ContainerDebug_LazyService.php  1f  f;3Ȥ      a   api/Resources/cache/ContainerIXAtexx/getSecurity_Authentication_Listener_Anonymous_ApiService.php  1f  J,Τ      F   api/Resources/cache/ContainerIXAtexx/getJwtCookieControllerService.php  1f  פ      E   api/Resources/cache/ContainerIXAtexx/getRouter_CacheWarmerService.php  1f  iZ      D   api/Resources/cache/ContainerIXAtexx/getBackupRestoreTaskService.php  1f  C/ݤ      H   api/Resources/cache/ContainerIXAtexx/getConsole_CommandLoaderService.php  1f  /_      <   api/Resources/cache/ContainerIXAtexx/getCache_AppService.php  1f  3J      M   api/Resources/cache/ContainerIXAtexx/getConsole_Command_SecretsSetService.php  1f  %D/      T   api/Resources/cache/ContainerIXAtexx/getSecurity_Command_UserPasswordHashService.php  1f  IB      H   api/Resources/cache/ContainerIXAtexx/getConsoleProcessFactoryService.phpc  1fc  m6      \   api/Resources/cache/ContainerIXAtexx/get_Console_Command_ConfigDumpReference_LazyService.php  1f    e      C   api/Resources/cache/ContainerIXAtexx/getCache_AppClearerService.phpj  1fj  [e      A   api/Resources/cache/ContainerIXAtexx/getUserControllerService.php  1f  ,      N   api/Resources/cache/ContainerIXAtexx/getConsole_Command_RouterDebugService.php  1f  B      Q   api/Resources/cache/ContainerIXAtexx/Contao_ManagerApi_ApiKernelProdContainer.php  1f  h ~      K   api/Resources/cache/ContainerIXAtexx/getAnnotations_CachedReaderService.phpl  1fl  E      W   api/Resources/cache/ContainerIXAtexx/get_Console_Command_CachePoolPrune_LazyService.phpj  1fj  >      D   api/Resources/cache/ContainerIXAtexx/getTaskUpdateCommandService.php  1f  1#U!      A   api/Resources/cache/ContainerIXAtexx/getTaskControllerService.php  1f        L   api/Resources/cache/ContainerIXAtexx/getMaintenanceModeControllerService.php  1f  Fݤ      A   api/Resources/cache/ContainerIXAtexx/getFileControllerService.php.  1f.  .ä      A   api/Resources/cache/ContainerIXAtexx/getRouting_LoaderService.php  1f  Q?      >   api/Resources/cache/ContainerIXAtexx/getEnvironmentService.php  1f  qߤ      C   api/Resources/cache/ContainerIXAtexx/getServicesResetterService.php<  1f<  u      D   api/Resources/cache/ContainerIXAtexx/getOpcacheControllerService.phpj  1fj  0^פ      P   api/Resources/cache/ContainerIXAtexx/getConsole_Command_AssetsInstallService.php  1f  k	      E   api/Resources/cache/ContainerIXAtexx/getLoginAuthenticatorService.php.  1f.  %T      O   api/Resources/cache/ContainerIXAtexx/getSecurity_EventDispatcher_ApiService.php   1f   akˤ      ?   api/Resources/cache/ContainerIXAtexx/getCache_SystemService.php  1f  ZB      A   api/Resources/cache/ContainerIXAtexx/getMonolog_LoggerService.php  1f  *_      X   api/Resources/cache/ContainerIXAtexx/get_Console_Command_CachePoolDelete_LazyService.php  1f  ֜v      J   api/Resources/cache/ContainerIXAtexx/getMonolog_Logger_SecurityService.php  1f  zˤ      @   api/Resources/cache/ContainerIXAtexx/getUpdateCommandService.php  1f  ]      U   api/Resources/cache/ContainerIXAtexx/getSecurity_Access_AuthenticatedVoterService.phpA  1fA  Ԥ      ?   api/Resources/cache/ContainerIXAtexx/getProcessCheckService.php  1f  .H      D   api/Resources/cache/ContainerIXAtexx/getSessionControllerService.php  1f  %      A   api/Resources/cache/ContainerIXAtexx/getSelfUpdateTaskService.php  1f  y      F   api/Resources/cache/ContainerIXAtexx/getCache_GlobalClearerService.phpH  1fH  #>(      >   api/Resources/cache/ContainerIXAtexx/getTaskManagerService.phpA  1fA  pK      H   api/Resources/cache/ContainerIXAtexx/getConsole_ErrorListenerService.php  1f  S      K   api/Resources/cache/ContainerIXAtexx/getUploadPackagesControllerService.php  1f  ]G?      <   api/Resources/cache/ContainerIXAtexx/getContaoApiService.php]  1f]  OX      C   api/Resources/cache/ContainerIXAtexx/getMemoryLimitCheckService.php  1f        W   api/Resources/cache/ContainerIXAtexx/get_Security_Command_DebugFirewall_LazyService.php  1f   դ      B   api/Resources/cache/ContainerIXAtexx/getSysTempDirCheckService.php  1f  얇      ]   api/Resources/cache/ContainerIXAtexx/getSecurity_Authentication_Listener_Guard_ApiService.php  1f  =      V   api/Resources/cache/ContainerIXAtexx/get_Console_Command_SecretsRemove_LazyService.phpl  1fl  Yk      R   api/Resources/cache/ContainerIXAtexx/getSecurity_Authentication_ManagerService.php  1f  6-      W   api/Resources/cache/ContainerIXAtexx/getSecurity_Authentication_GuardHandlerService.phpl  1fl  ^{      C   api/Resources/cache/ContainerIXAtexx/getConfigControllerService.php[  1f[  $.      =   api/Resources/cache/ContainerIXAtexx/getSelfUpdateService.php  1f  #      C   api/Resources/cache/ContainerIXAtexx/getTaskAbortCommandService.php  1f  "C	      @   api/Resources/cache/ContainerIXAtexx/getCloudResolverService.phpG  1fG  W6      ^   api/Resources/cache/ContainerIXAtexx/get_Console_Command_SecretsDecryptToLocal_LazyService.php  1f  Qˤ      R   api/Resources/cache/ContainerIXAtexx/getSecurity_EncoderFactory_GenericService.php  1f  O}      F   api/Resources/cache/ContainerIXAtexx/getAccessKeyControllerService.php  1f  v9      C   api/Resources/cache/ContainerIXAtexx/getPhpWebControllerService.php  1f  S      P   api/Resources/cache/ContainerIXAtexx/getConsole_Command_ContainerLintService.php  1f  BDeK      N   api/Resources/cache/ContainerIXAtexx/get_Console_Command_About_LazyService.php?  1f?  d      T   api/Resources/cache/ContainerIXAtexx/get_Console_Command_RouterMatch_LazyService.phpq  1fq  j      =   api/Resources/cache/ContainerIXAtexx/getTranslatorService.php  1f  m0      G   api/Resources/cache/ContainerIXAtexx/getSelfUpdateControllerService.phpy  1fy        K   api/Resources/cache/ContainerIXAtexx/getSecurity_ChannelListenerService.php  1f  fꕤ      D   api/Resources/cache/ContainerIXAtexx/getManagerControllerService.php  1f  &١      C   api/Resources/cache/ContainerIXAtexx/getBackupControllerService.phpy  1fy  $>      Q   api/Resources/cache/ContainerIXAtexx/get_Console_Command_YamlLint_LazyService.phpZ  1fZ  ʭ      ^   api/Resources/cache/ContainerIXAtexx/get_Container_Private_Security_PasswordEncoderService.phpG  1fG  z      @   api/Resources/cache/ContainerIXAtexx/getSecrets_VaultService.php  1f  1sA      V   api/Resources/cache/ContainerIXAtexx/getConsole_Command_ConfigDumpReferenceService.php  1f  ݷդ      N   api/Resources/cache/ContainerIXAtexx/getConsole_Command_CacheWarmupService.php  1f  .=      B   api/Resources/cache/ContainerIXAtexx/getLoaderInterfaceService.php  1f  ty      C   api/Resources/cache/ContainerIXAtexx/getBackupCreateTaskService.php  1f  aW      a   api/Resources/cache/ContainerIXAtexx/getSecurity_Authentication_Provider_Anonymous_ApiService.php<  1f<  Og      R   api/Resources/cache/ContainerIXAtexx/getConsole_Command_CachePoolDeleteService.php  1f  bJ      B   api/Resources/cache/ContainerIXAtexx/getCloudControllerService.phpb  1fb  'n      <   api/Resources/cache/ContainerIXAtexx/getSetupTaskService.phpW  1fW        S   api/Resources/cache/ContainerIXAtexx/get_Console_Command_SecretsSet_LazyService.phpR  1fR  j[c$      E   api/Resources/cache/ContainerIXAtexx/getTemplateControllerService.phpq  1fq  S>Ƥ      ]   api/Resources/cache/ContainerIXAtexx/get_Console_Command_EventDispatcherDebug_LazyService.php  1f  f      V   api/Resources/cache/ContainerIXAtexx/get_Console_Command_CachePoolList_LazyService.phpl  1fl  hؤ      W   api/Resources/cache/ContainerIXAtexx/getSecurity_Command_UserPasswordEncoderService.php  1f  rB<      W   api/Resources/cache/ContainerIXAtexx/getConsole_Command_EventDispatcherDebugService.phpp  1fp  r7      K   api/Resources/cache/ContainerIXAtexx/getArgumentResolver_ServiceService.php  1f  64m      T   api/Resources/cache/ContainerIXAtexx/get_Console_Command_CacheWarmup_LazyService.phpV  1fV  %      F   api/Resources/cache/ContainerIXAtexx/getCache_SystemClearerService.php  1f  o      G   api/Resources/cache/ContainerIXAtexx/getMonolog_Logger_TasksService.php  1f  A̝      F   api/Resources/cache/ContainerIXAtexx/getAdminUserControllerService.php  1f  [!⫤      H   api/Resources/cache/ContainerIXAtexx/getIntegrityCheckCommandService.php  1f  i      V   api/Resources/cache/ContainerIXAtexx/get_Console_Command_AssetsInstall_LazyService.php  1f  qv9y      E   api/Resources/cache/ContainerIXAtexx/getPhpExtensionsCheckService.php  1f  IL      A   api/Resources/cache/ContainerIXAtexx/getAuthControllerService.php  1f  :FY      ]   api/Resources/cache/ContainerIXAtexx/getSecurity_Authentication_Provider_Guard_ApiService.php	  1f	  :I      L   api/Resources/cache/ContainerIXAtexx/getInstallToolLockControllerService.php  1f  uTy      E   api/Resources/cache/ContainerIXAtexx/getComposerControllerService.php  1f  h      >   api/Resources/cache/ContainerIXAtexx/getCacheWarmerService.php%  1f%  x#c      E   api/Resources/cache/ContainerIXAtexx/getRedirectControllerService.phpB  1fB  ?g      E   api/Resources/cache/ContainerIXAtexx/getAnnotations_ReaderService.php  1f  rW4      @   api/Resources/cache/ContainerIXAtexx/getUploadsConfigService.php  1f  -      N   api/Resources/cache/ContainerIXAtexx/getDatabaseMigrationControllerService.php  1f  kJ      J   api/Resources/cache/ContainerIXAtexx/get_ServiceLocator_4uC2EhjService.php  1f  Ǥ      K   api/Resources/cache/ContainerIXAtexx/getConsole_Command_YamlLintService.php  1f  :+      G   api/Resources/cache/ContainerIXAtexx/getConfigBuilder_WarmerService.php  1f  ϙ      L   api/Resources/cache/ContainerIXAtexx/getPasswordlessAuthenticatorService.phpL  1fL  ޤ      A   api/Resources/cache/ContainerIXAtexx/getClearCacheTaskService.php  1f  8Y      H   api/Resources/cache/ContainerIXAtexx/getRootPackageControllerService.php  1f  of      Q   api/Resources/cache/ContainerIXAtexx/getSecurity_PasswordHasherFactoryService.phpa  1fa  G      @   api/Resources/cache/ContainerIXAtexx/getContaoConsoleService.php  1f  G      @   api/Resources/cache/ContainerIXAtexx/getManagerConfigService.php  1f  lf      M   api/Resources/cache/ContainerIXAtexx/getSecurity_UserValueResolverService.php  1f  +H      X   api/Resources/cache/ContainerIXAtexx/get_Console_Command_DebugAutowiring_LazyService.php  1f  >      Q   api/Resources/cache/ContainerIXAtexx/getSecurity_Command_DebugFirewallService.php  1f  &ӽ      J   api/Resources/cache/ContainerIXAtexx/getAnnotations_CacheWarmerService.php6  1f6  FϤ      W   api/Resources/cache/ContainerIXAtexx/get_Console_Command_CachePoolClear_LazyService.phpj  1fj  )      R   api/Resources/cache/ContainerIXAtexx/get_Container_Private_CacheClearerService.php  1f  p.@      M   api/Resources/cache/ContainerIXAtexx/getConsole_Command_CacheClearService.php  1f  M      J   api/Resources/cache/ContainerIXAtexx/get_ServiceLocator_XUrKPVUService.php	  1f	  W      D   api/Resources/cache/ContainerIXAtexx/getPhpinfoControllerService.phpj  1fj  7V-@      P   api/Resources/cache/ContainerIXAtexx/getConsole_Command_CachePoolListService.php  1f  $      E   api/Resources/cache/ContainerIXAtexx/getAllowUrlFopenCheckService.php  1f  ^fˤ      C   api/Resources/cache/ContainerIXAtexx/getRebuildCacheTaskService.phpo  1fo  a      [   api/Resources/cache/ContainerIXAtexx/get_Console_Command_SecretsGenerateKey_LazyService.php  1f  q      T   api/Resources/cache/ContainerIXAtexx/get_Console_Command_RouterDebug_LazyService.phpi  1fi  ֤      Q   api/Resources/cache/ContainerIXAtexx/getConsole_Command_CachePoolClearService.php  1f  V      @   api/Resources/cache/ContainerIXAtexx/getLogControllerService.php)  1f)  Ґ      L   api/Resources/cache/ContainerIXAtexx/getContainer_EnvVarProcessorService.php  1f  H      >   api/Resources/cache/ContainerIXAtexx/getInstallTaskService.php"  1f"  ¹פ      T   api/Resources/cache/ContainerIXAtexx/getContainer_EnvVarProcessorsLocatorService.php3  1f3  8      D   api/Resources/cache/ContainerIXAtexx/getExceptionListenerService.php  1f  TV      ?   api/Resources/cache/ContainerIXAtexx/getSymlinkCheckService.php  1f  (      :   api/Resources/cache/ContainerIXAtexx/getRequestService.php  1f  s6ݤ      ?   api/Resources/cache/ContainerIXAtexx/getSessionCheckService.php  1f  !"      L   api/Resources/cache/ContainerIXAtexx/getMissingPackagesControllerService.php  1f        U   api/Resources/cache/ContainerIXAtexx/getConsole_Command_SecretsGenerateKeyService.php  1f  ?3\      =   api/Resources/cache/ContainerIXAtexx/getUpdateTaskService.php  1f  ī}      T   api/Resources/cache/ContainerIXAtexx/get_Console_Command_SecretsList_LazyService.phpP  1fP  XH      A   api/Resources/cache/ContainerIXAtexx/getComposerConfigService.php  1f  wY      Z   api/Resources/cache/ContainerIXAtexx/getConsole_Command_SecretsEncryptFromLocalService.phpB  1fB  &3@      J   api/Resources/cache/ContainerIXAtexx/getSecurity_AccessListenerService.php  1f  V      Q   api/Resources/cache/ContainerIXAtexx/getConsole_Command_CachePoolPruneService.phpy  1fy  ɪ      Z   api/Resources/cache/ContainerIXAtexx/get_Security_Command_UserPasswordHash_LazyService.php  1f  IE      T   api/Resources/cache/ContainerIXAtexx/get_Console_Command_ConfigDebug_LazyService.phpo  1fo  C}:      E   api/Resources/cache/ContainerIXAtexx/getDatabaseControllerService.phpk  1fk  }?O      J   api/Resources/cache/ContainerIXAtexx/get_ServiceLocator_3CSu656Service.php  1f  Sqv      X   api/Resources/cache/ContainerIXAtexx/getConsole_Command_SecretsDecryptToLocalService.phpF  1fF  ]d}      J   api/Resources/cache/ContainerIXAtexx/getLocalPackagesControllerService.php  1f  pI      ?   api/Resources/cache/ContainerIXAtexx/getAboutCommandService.php  1f  ]_5      E   api/Resources/cache/ContainerIXAtexx/getTokenAuthenticatorService.php  1f  {x)      R   api/Resources/cache/ContainerIXAtexx/getConsole_Command_DebugAutowiringService.php  1f  ifO       =   api/Resources/cache/ContainerIXAtexx/getServerInfoService.php6  1f6  q      N   api/Resources/cache/ContainerIXAtexx/getConsole_Command_RouterMatchService.php~  1f~  (C      B   api/Resources/cache/ContainerIXAtexx/getErrorControllerService.phpl  1fl  fߤ      J   api/Resources/cache/ContainerIXAtexx/get_ServiceLocator_XRi_MOZService.php  1f  g      S   api/Resources/cache/ContainerIXAtexx/get_Console_Command_CacheClear_LazyService.phpH  1fH  H@Ԥ      H   api/Resources/cache/ContainerIXAtexx/getConsole_Command_AboutService.php  1f  7      C   api/Resources/cache/ContainerIXAtexx/getDumpAutoloadTaskService.php  1f  ƊA      V   api/Resources/cache/ContainerIXAtexx/get_Console_Command_ContainerLint_LazyService.php  1f        N   api/Resources/cache/ContainerIXAtexx/getConsole_Command_ConfigDebugService.php  1f  MZ}      #   api/Resources/cache/annotations.php  1f  #5      2   api/Resources/cache/url_generating_routes.php.meta!  1f!  |)      D   api/Resources/cache/pools/system/QW2qGtjRrA/R/Z/LAZJaY04hjh8xPg33m7Q   1f   e޸¤      D   api/Resources/cache/pools/system/QW2qGtjRrA/R/A/7KUIQcX1-otParycxm4g  1f  >      D   api/Resources/cache/pools/system/QW2qGtjRrA/R/P/2D3NGVsB2klPFDF4unVg   1f   Nq      D   api/Resources/cache/pools/system/QW2qGtjRrA/U/0/UOEV-iZUDwJO3IZrD4jg  1f  ە}      D   api/Resources/cache/pools/system/QW2qGtjRrA/U/I/kTkBor3QesIhvAUCBjGg  1f  
JZ      D   api/Resources/cache/pools/system/QW2qGtjRrA/U/I/fdJRp068D3mGBmrtZWBA   1f   @      D   api/Resources/cache/pools/system/QW2qGtjRrA/U/Z/-SP2SMqd3fksOPgcjXAg   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/U/T/ACEmMTkeKq2zJNrQp1YA   1f   {h      D   api/Resources/cache/pools/system/QW2qGtjRrA/U/O/MNUfyeybfwQ1np4Jgl6w  1f  `U      D   api/Resources/cache/pools/system/QW2qGtjRrA/U/Q/RC7h6P3ZN9qrj5AJpv-Q   1f   4֤      D   api/Resources/cache/pools/system/QW2qGtjRrA/U/B/aFGbCjH4No5dIE86tm1w  1f  13F      D   api/Resources/cache/pools/system/QW2qGtjRrA/9/T/nyDVAEYeU58Up2Kq4Bmw   1f   &`m      D   api/Resources/cache/pools/system/QW2qGtjRrA/9/X/Ei+Xa-YpA3jDTw3bQMXQ   1f   C,|      D   api/Resources/cache/pools/system/QW2qGtjRrA/9/W/DCuPAEECfl7gjXqA25sg   1f   7[      D   api/Resources/cache/pools/system/QW2qGtjRrA/0/G/27i4Mke1ocWZYgjzErXw   1f   {      D   api/Resources/cache/pools/system/QW2qGtjRrA/0/G/4moiUYMtI6IqqTqMzblA   1f   Ӻh      D   api/Resources/cache/pools/system/QW2qGtjRrA/7/R/0nGqYSuyHzbuPMBNjX0A  1f  61      D   api/Resources/cache/pools/system/QW2qGtjRrA/7/I/vvQtFDwqqVkBfPVfQEDA   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/7/G/LmnxNwNp3t4fkK8J7MEA   1f   oʤ      D   api/Resources/cache/pools/system/QW2qGtjRrA/7/M/rmeNbVB5DeCBdaxgCl2g   1f   S}Hy      D   api/Resources/cache/pools/system/QW2qGtjRrA/7/V/Slraxjry7zIhnWaIz3Gg   1f   $      D   api/Resources/cache/pools/system/QW2qGtjRrA/7/V/bBR5rKuDenloX+mtT-Gg  1f  /Y      D   api/Resources/cache/pools/system/QW2qGtjRrA/7/X/5+VJwRInhQxngCplj3eA   1f   i      D   api/Resources/cache/pools/system/QW2qGtjRrA/7/B/Ep4F96GUQiFMkLh75w0g  1f  ͏      D   api/Resources/cache/pools/system/QW2qGtjRrA/I/H/OY1FHCvqAS0P1S5LT-wg   1f   tF      D   api/Resources/cache/pools/system/QW2qGtjRrA/I/V/FDTFq9HdFPtnwD0MTd4A   1f   2ɤ      D   api/Resources/cache/pools/system/QW2qGtjRrA/I/Y/WYfL3JD4aUS3cK6t7u3g   1f   SD      D   api/Resources/cache/pools/system/QW2qGtjRrA/I/W/4X-GtvI4JB4nNVcUy2JQ   1f   Ud      D   api/Resources/cache/pools/system/QW2qGtjRrA/N/9/V6Rdtb4jnA6+azeCCjsw   1f   
Ӥ      D   api/Resources/cache/pools/system/QW2qGtjRrA/N/Z/Tu6kTd9yUFIEmzTlJipA   1f   }f_      D   api/Resources/cache/pools/system/QW2qGtjRrA/N/A/PIILre824TeYHtR3JjSg   1f   ?٤      D   api/Resources/cache/pools/system/QW2qGtjRrA/N/-/Imp8dIyNcyFCr3RH-xRw   1f   N-      D   api/Resources/cache/pools/system/QW2qGtjRrA/N/J/C51v9J7ULPkrAjRvpMCA  1f        D   api/Resources/cache/pools/system/QW2qGtjRrA/N/J/GqfF4qBBlmsg7SvOAKIg   1f   d      D   api/Resources/cache/pools/system/QW2qGtjRrA/N/C/PZXpa3z02m60JGDzjfIw   1f   M      D   api/Resources/cache/pools/system/QW2qGtjRrA/N/L/gCe+wHAPasIwlCfS3ogg  1f  3E      D   api/Resources/cache/pools/system/QW2qGtjRrA/G/Z/latXG9ggiuXZNoa8Eqow   1f   Eq      D   api/Resources/cache/pools/system/QW2qGtjRrA/G/A/KZH6256TOL39f4ObPRXg   1f   D      D   api/Resources/cache/pools/system/QW2qGtjRrA/G/M/fT53C+-yl8hOLH3VmLAA   1f   9      D   api/Resources/cache/pools/system/QW2qGtjRrA/G/4/+a9LPIVE6fUVq7pjQJsg  1f  }zO&      D   api/Resources/cache/pools/system/QW2qGtjRrA/+/7/V3hwwqO1oa5TQJAKaGcw   1f   J&b      D   api/Resources/cache/pools/system/QW2qGtjRrA/6/K/PCCDQzufWJzzLxMZNGiQ   1f   e=0      D   api/Resources/cache/pools/system/QW2qGtjRrA/6/K/-q0MYe9pysPbCWOG18PA   1f   i      D   api/Resources/cache/pools/system/QW2qGtjRrA/Z/-/n+kGfS8uBJDSk3Ieq5YQ   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/Z/F/rLwo5ESj++dtcAgvVwXA  1f  aT      D   api/Resources/cache/pools/system/QW2qGtjRrA/Z/C/RIaqUMyxqNPdHJEyTrYg  1f  W      D   api/Resources/cache/pools/system/QW2qGtjRrA/Z/X/T+jMZ2pToPP1OZ9J0E4g   1f   "      D   api/Resources/cache/pools/system/QW2qGtjRrA/Z/K/wj2D6nO2qHqFZ3bsnQVw  1f  ٤      D   api/Resources/cache/pools/system/QW2qGtjRrA/Z/L/6BwioJyuQxWkxKei7HEw   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/1/S/NNDhBH1Aow3f4VPKTWnA   1f   vK      D   api/Resources/cache/pools/system/QW2qGtjRrA/1/3/6A4lCP0BNlgEko8v-TsA   1f   J%      D   api/Resources/cache/pools/system/QW2qGtjRrA/1/E/ZgZxupE8C17NYevudlVg   1f   E      D   api/Resources/cache/pools/system/QW2qGtjRrA/1/B/Tii38M0BR1cwTM+uYWBQ   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/8/J/XOe97mjD0WUWEm5CIuqwv   1fv         D   api/Resources/cache/pools/system/QW2qGtjRrA/T/R/8-UGopXIcK5EBHRU14kw  1f  UO=      D   api/Resources/cache/pools/system/QW2qGtjRrA/T/R/sW08sUZWg-6banDCH2-Q   1f   )      D   api/Resources/cache/pools/system/QW2qGtjRrA/T/N/Au+QEfDh3WPMluNyeldg   1f   K\      D   api/Resources/cache/pools/system/QW2qGtjRrA/T/S/F24haDgeS+QoMfuFZdAA   1f   ؐS      D   api/Resources/cache/pools/system/QW2qGtjRrA/T/O/uWCgNRwAoVl3ZvvDe8fw   1f   S      D   api/Resources/cache/pools/system/QW2qGtjRrA/T/D/y5Wd01yQp6EMeTe-Usww   1f   (gѤ      D   api/Resources/cache/pools/system/QW2qGtjRrA/T/W/f+pXqNq24DTiccv7Y2yQ   1f   ӵe      D   api/Resources/cache/pools/system/QW2qGtjRrA/S/N/09R1sWgEyovhSP8yo4dw   1f   <^Ҥ      D   api/Resources/cache/pools/system/QW2qGtjRrA/S/A/HOTbPtyMxx9jQW53nHYw   1f   2\      D   api/Resources/cache/pools/system/QW2qGtjRrA/S/O/fGCLQbg3F0OOYlaPNz1Q   1f   {      D   api/Resources/cache/pools/system/QW2qGtjRrA/S/P/f+VrsqWwJCIGWSbMGsBg   1f   Ur      D   api/Resources/cache/pools/system/QW2qGtjRrA/S/P/VeJkVIItnwBQN9PcO9vw  1f  0      D   api/Resources/cache/pools/system/QW2qGtjRrA/S/P/Oj0vJ6JMF2HEamn4SJJQ   1f   쎂      D   api/Resources/cache/pools/system/QW2qGtjRrA/A/7/z8lyPuBMM5Yj6xapSqJQ   1f   >5      D   api/Resources/cache/pools/system/QW2qGtjRrA/A/N/Fk7c3J+nTIDxSQtlGZhQ   1f   #s      D   api/Resources/cache/pools/system/QW2qGtjRrA/A/A/B+GGgc7wTs2QF5lA1UQw  1f        D   api/Resources/cache/pools/system/QW2qGtjRrA/A/O/zkQYN1br6r2EJXKGYosw   1f   (LO      D   api/Resources/cache/pools/system/QW2qGtjRrA/A/P/GkQGsahBzeJMo+cRMhTw   1f   I      D   api/Resources/cache/pools/system/QW2qGtjRrA/A/P/gdnFqbWQoLJkGctqgvew   1f   ].      D   api/Resources/cache/pools/system/QW2qGtjRrA/A/W/tdk22APgGrq8bXup2ILQ   1f   |+      D   api/Resources/cache/pools/system/QW2qGtjRrA/-/7/pB1GuYSfTqDWswsp-GGw   1f   	      D   api/Resources/cache/pools/system/QW2qGtjRrA/-/A/Pio+HqrwbHA-vjKaKQIA   1f   B      D   api/Resources/cache/pools/system/QW2qGtjRrA/F/R/tbBU+MxR5rV1Htdjnb9g  1f  mB      D   api/Resources/cache/pools/system/QW2qGtjRrA/F/7/g2wbRsxLOsH8jWtyh0Ag   1f   1q
      D   api/Resources/cache/pools/system/QW2qGtjRrA/F/O/QK+PzWAT5fubrPfojomQ  1f  h*      D   api/Resources/cache/pools/system/QW2qGtjRrA/F/J/rVdlCFOpiVQbA1VOVLkA   1f   7      D   api/Resources/cache/pools/system/QW2qGtjRrA/F/W/m8cf6BPeiPbqCZGazZzQ  1f  )      D   api/Resources/cache/pools/system/QW2qGtjRrA/O/I/MyaY3WAUKnzcblXn6MRA   1f   !      D   api/Resources/cache/pools/system/QW2qGtjRrA/O/Z/Je5ks7GkiNY9RDTGMZRw  1f  n)      D   api/Resources/cache/pools/system/QW2qGtjRrA/O/T/-UM-bxgKxDx8fQBu-gJg   1f   G      D   api/Resources/cache/pools/system/QW2qGtjRrA/O/M/RnWlDkfy0H1NGFvJcmXg  1f  '6V      D   api/Resources/cache/pools/system/QW2qGtjRrA/O/V/Wu0gDCYRESB-UFqCjEqw   1f   㠌J      D   api/Resources/cache/pools/system/QW2qGtjRrA/O/4/ZbuR7rSan7QmqcyHno1w  1f  @4      D   api/Resources/cache/pools/system/QW2qGtjRrA/O/X/KI1FBtjE4f4HEt-LP2vw   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/O/3/JfqSSAuCpNTNUjM2iXNQ   1f   
jR      D   api/Resources/cache/pools/system/QW2qGtjRrA/H/T/uqBvMcblHFy+UCbOF7Qw   1f   M<      D   api/Resources/cache/pools/system/QW2qGtjRrA/H/J/iAoNEJ3EyEpAPi-Fep1g   1f   
      D   api/Resources/cache/pools/system/QW2qGtjRrA/H/V/nG2KxyRbTzExzbdCMcGg   1f   wĤ      D   api/Resources/cache/pools/system/QW2qGtjRrA/H/2/YGNEyazPh14BqnQp0yiw   1f   AY      D   api/Resources/cache/pools/system/QW2qGtjRrA/H/W/1UkXYuOmaHArDiXwAs9g  1f  ?      D   api/Resources/cache/pools/system/QW2qGtjRrA/M/F/rKH5qWKVya9sQZTdDkxQ   1f   $:      D   api/Resources/cache/pools/system/QW2qGtjRrA/M/H/Hb88Rpe4YJP+fCxHGt7A  1f  K      D   api/Resources/cache/pools/system/QW2qGtjRrA/M/V/4ez107KY-wes1Elt1SoA   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/M/L/i6cJOd7uINIx0zVILCGA   1f   -      D   api/Resources/cache/pools/system/QW2qGtjRrA/M/2/tH7oSLMSkT5QhSrtarOw   1f   7      D   api/Resources/cache/pools/system/QW2qGtjRrA/J/+/-hri6Ku8aRxDOQwdkcrg  1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/J/M/W+Yk6l0-sY1Gr6NiGeQw  1f  Λڤ      D   api/Resources/cache/pools/system/QW2qGtjRrA/J/J/ZI3dlsBQbp5p5E7GPfQg   1f   f      D   api/Resources/cache/pools/system/QW2qGtjRrA/J/X/3WTOwDNz5ZJCduG0uebw   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/J/Y/EzzpwETJoQ-5KRWfQKVA  1f  9      D   api/Resources/cache/pools/system/QW2qGtjRrA/C/R/KjFWvG5VoK9VJZMgKVjQ   1f   V      D   api/Resources/cache/pools/system/QW2qGtjRrA/C/9/RgP-Pc8QLoz3o7FedUPg  1f  i      D   api/Resources/cache/pools/system/QW2qGtjRrA/C/8/1kfbh1Hu6GYndVt4eXyg   1f   W<fs      D   api/Resources/cache/pools/system/QW2qGtjRrA/C/C/+5oLMLH7HbZvaDKwBfGw   1f   hפ      D   api/Resources/cache/pools/system/QW2qGtjRrA/C/4/ll4nwxx04P5NKyrM2pYQ  1f  3      D   api/Resources/cache/pools/system/QW2qGtjRrA/D/Z/jPYFTAOGyJ45DwH38E1g   1f   5K      D   api/Resources/cache/pools/system/QW2qGtjRrA/D/-/UO-EwuwB-u-7oesVLuDA   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/D/E/j94Cuv6W0dX+8WU-efCQ   1f   7XѤ      D   api/Resources/cache/pools/system/QW2qGtjRrA/D/E/5nyzeCEX4xPQcrisnaBA   1f   DS      D   api/Resources/cache/pools/system/QW2qGtjRrA/V/R/fRKwvMg0AlxYpg-Tf69w   1f   Y%$      D   api/Resources/cache/pools/system/QW2qGtjRrA/Q/U/xcE1afObqXOdANLnUs3A   1f   yF      D   api/Resources/cache/pools/system/QW2qGtjRrA/Q/0/93N9zx32mug1cI5z2s4w   1f    `      D   api/Resources/cache/pools/system/QW2qGtjRrA/Q/Z/1q0C15avf68uHkiUqFnA  1f  H=      D   api/Resources/cache/pools/system/QW2qGtjRrA/Q/Z/+axg0pUChZ+lK4XKCbeg  1f  .
+ʤ      D   api/Resources/cache/pools/system/QW2qGtjRrA/Q/F/Z0XRJCnmHFFvu3KRGuXg   1f   j{j      D   api/Resources/cache/pools/system/QW2qGtjRrA/Q/F/K3zds+i42tmuftsOFRXA   1f   1i(m      D   api/Resources/cache/pools/system/QW2qGtjRrA/Q/H/4QQeaEo-pXFebKAz8WUw   1f   L      D   api/Resources/cache/pools/system/QW2qGtjRrA/Q/C/3SeSt+CYISb1fU9tntXQ   1f   `	ʤ      D   api/Resources/cache/pools/system/QW2qGtjRrA/Q/3/hA0y6ZqLZnB+js6Rrt9A   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/4/P/sXzW9pvn6Jyx42u45tnA   1f   pA6      D   api/Resources/cache/pools/system/QW2qGtjRrA/X/V/X0GKI0dk0dmt1bHpxFrQ  1f  T      D   api/Resources/cache/pools/system/QW2qGtjRrA/X/L/2RCZeTvE4vNUYdEeD8kQ   1f   4      D   api/Resources/cache/pools/system/QW2qGtjRrA/X/Y/1NRb2AwJ-DfAf25-HS-A  1f  R"      D   api/Resources/cache/pools/system/QW2qGtjRrA/3/H/nIVsJP4BQ2ZvTEJpUD9A  1f  8      D   api/Resources/cache/pools/system/QW2qGtjRrA/E/R/+QVa5nTbrtKk1O4TBUvA   1f   "h      D   api/Resources/cache/pools/system/QW2qGtjRrA/E/6/09VeOWKmApL5ebfJ277w  1f  Fd      D   api/Resources/cache/pools/system/QW2qGtjRrA/E/6/nar+OcYC3FrG-rbkQQuQ   1f   O      D   api/Resources/cache/pools/system/QW2qGtjRrA/B/+/OmLTSK1RWUNPgx1WJynw   1f   MrԤ      D   api/Resources/cache/pools/system/QW2qGtjRrA/B/Z/WoCo5DSN-u7oA3dqnfOQ  1f  W      D   api/Resources/cache/pools/system/QW2qGtjRrA/B/A/JvhWrxMgogkaks0ilgIw   1f   , 汤      D   api/Resources/cache/pools/system/QW2qGtjRrA/B/K/tI0MSKVFmzQ0iIPUvpAw   1f   @N      D   api/Resources/cache/pools/system/QW2qGtjRrA/B/W/NqRfYMBbBjvEscMtHNsQ   1f   ÃFU      D   api/Resources/cache/pools/system/QW2qGtjRrA/K/F/SVhOX7E51RwBEuLldMSg   1f   BY      D   api/Resources/cache/pools/system/QW2qGtjRrA/K/O/u84jJZFwiRYqb3-3spRQ  1f  #      D   api/Resources/cache/pools/system/QW2qGtjRrA/K/C/83yLgStnUy0gT92PWPig  1f  81      D   api/Resources/cache/pools/system/QW2qGtjRrA/K/3/IpTXFAUdvPy9avle9VQQ   1f   $      D   api/Resources/cache/pools/system/QW2qGtjRrA/K/5/zxk-hZ4j5aoQ5j42Vk-Q   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/L/N/gd+rUc-BOFQUwHUanLAw   1f    :l      D   api/Resources/cache/pools/system/QW2qGtjRrA/L/N/EvvdF0xE661BhVrSaW7Q   1f   W+[      D   api/Resources/cache/pools/system/QW2qGtjRrA/L/F/KLKFIFScN8hAv5RMufNA   1f   J      D   api/Resources/cache/pools/system/QW2qGtjRrA/L/O/Ppox1+ljfyH-MDsSmKSg   1f   2Q%      D   api/Resources/cache/pools/system/QW2qGtjRrA/L/J/gByqdoXQ3ZFIpzkc7f1Q   1f   I      D   api/Resources/cache/pools/system/QW2qGtjRrA/L/C/DerUzJQpsga9boNSegiw   1f   w      D   api/Resources/cache/pools/system/QW2qGtjRrA/L/E/yE5leVw4INdqVAgsQ-ew   1f   Wi      D   api/Resources/cache/pools/system/QW2qGtjRrA/L/B/ZoZOZqbf4xxNAlg2wUOA   1f   ⛤      D   api/Resources/cache/pools/system/QW2qGtjRrA/L/L/lcDNdli9LIZJfesvvjsQ   1f   S      D   api/Resources/cache/pools/system/QW2qGtjRrA/2/B/Wmb+tbAPbG5C6wvuwh8w   1f   t      D   api/Resources/cache/pools/system/QW2qGtjRrA/Y/+/AloVHu2zHzIZQjasnC4A   1f   :      D   api/Resources/cache/pools/system/QW2qGtjRrA/Y/O/1O1lk4oGBd9xmauZILEgw   1fw   ؚb      D   api/Resources/cache/pools/system/QW2qGtjRrA/Y/L/ooSCge2IaoDuW2sK3VJQ   1f   5^      D   api/Resources/cache/pools/system/QW2qGtjRrA/5/9/BNIpfruiG93eGnUYnDMQ   1f   Ū      D   api/Resources/cache/pools/system/QW2qGtjRrA/5/G/tWg3smQrTYtf50nQ1W-g  1f  :      D   api/Resources/cache/pools/system/QW2qGtjRrA/5/6/LxtX2NxxtjXI2Dy2-K5w   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/P/H/nF3ybhOV0g-6B9sznW3w6  1f6  C(!      D   api/Resources/cache/pools/system/QW2qGtjRrA/P/M/94MyiLeo1YMkLo1khFJA  1f  z      D   api/Resources/cache/pools/system/QW2qGtjRrA/P/D/pMhOvAGnM5kfbu7bUCwA  1f  %դ      D   api/Resources/cache/pools/system/QW2qGtjRrA/P/Q/DLUN9ugv9cE+9WFJBCNg   1f   Ss)      D   api/Resources/cache/pools/system/QW2qGtjRrA/P/B/Ym6mL-Y3xQrh7wsiAFLQ   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/P/K/u9WOEgIRwowWDuKvbP5g   1f   4      D   api/Resources/cache/pools/system/QW2qGtjRrA/P/Y/fjreYGXENpzWzRLX+ALw   1f         D   api/Resources/cache/pools/system/QW2qGtjRrA/P/P/2tkLuSbKDvskXdIPZmzw   1f   Pt      D   api/Resources/cache/pools/system/QW2qGtjRrA/W/M/MF1oMu6AVXXk0aq0TQ+Q   1f   l$      @   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php  1f  $      E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.lock    1f              E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.metae 1fe p(      -   api/Resources/cache/url_generating_routes.php%  1f%  `      +   api/Resources/cache/url_matching_routes.php,  1f,  V.      0   api/Resources/cache/url_matching_routes.php.meta!  1f!  |)      H   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.preload.phpT  1fT  4ɸ      @   api/Resources/cache/Symfony/Config/Framework/HttpCacheConfig.php  1f  Bg
ؤ      <   api/Resources/cache/Symfony/Config/Framework/CacheConfig.php&  1f&  P      @   api/Resources/cache/Symfony/Config/Framework/FragmentsConfig.php
  1f
  T.      J   api/Resources/cache/Symfony/Config/Framework/Form/CsrfProtectionConfig.php  1f  aܱ      P   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptionsConfig.php;  1f;  /r      i   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailed/HttpCodeConfig.php  1f  xA      d   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/PeerFingerprintConfig.php	  1f	  .      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailedConfig.php  1f  ^l      N   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig.php%L  1f%L  Ag      e   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailed/HttpCodeConfig.php  1f  Q      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/PeerFingerprintConfig.php	  1f	  N`G      \   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailedConfig.php  1f  j      I   api/Resources/cache/Symfony/Config/Framework/Serializer/MappingConfig.php%  1f%  zƤ      A   api/Resources/cache/Symfony/Config/Framework/ValidationConfig.php#  1f#  lT3~      B   api/Resources/cache/Symfony/Config/Framework/RateLimiterConfig.phpN
  1fN
  x#      U   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig/RateConfig.phpi  1fi  +Ť      J   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig.php|  1f|  L)҇      A   api/Resources/cache/Symfony/Config/Framework/Cache/PoolConfig.php  1f  ;p      A   api/Resources/cache/Symfony/Config/Framework/SerializerConfig.php  1f  |/      E   api/Resources/cache/Symfony/Config/Framework/CsrfProtectionConfig.php5  1f5  g%      =   api/Resources/cache/Symfony/Config/Framework/AssetsConfig.php`  1f`  H      N   api/Resources/cache/Symfony/Config/Framework/Notifier/AdminRecipientConfig.phpV  1fV  ͤ      @   api/Resources/cache/Symfony/Config/Framework/MessengerConfig.php$  1f$  '      =   api/Resources/cache/Symfony/Config/Framework/RouterConfig.php  1f  f      A   api/Resources/cache/Symfony/Config/Framework/TranslatorConfig.phpS#  1fS#  J       @   api/Resources/cache/Symfony/Config/Framework/WorkflowsConfig.php  1f   n      J   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig.phpt(  1ft(  ޅ!      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/AuditTrailConfig.phpL  1fL  m      ]   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/MarkingStoreConfig.php	  1f	        [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/TransitionConfig.php  1f  Jvx      V   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/PlaceConfig.php  1f  !	      :   api/Resources/cache/Symfony/Config/Framework/EsiConfig.php+  1f+  bF      >   api/Resources/cache/Symfony/Config/Framework/WebLinkConfig.php/  1f/  h      F   api/Resources/cache/Symfony/Config/Framework/Mailer/EnvelopeConfig.php  1f  cJˤ      D   api/Resources/cache/Symfony/Config/Framework/Mailer/HeaderConfig.php  1f  ٤      :   api/Resources/cache/Symfony/Config/Framework/SsiConfig.php+  1f+  q      T   api/Resources/cache/Symfony/Config/Framework/Translator/PseudoLocalizationConfig.php}  1f}  4      J   api/Resources/cache/Symfony/Config/Framework/Translator/ProviderConfig.php	  1f	  P      ?   api/Resources/cache/Symfony/Config/Framework/ProfilerConfig.php  1f  r      >   api/Resources/cache/Symfony/Config/Framework/SecretsConfig.php
  1f
  3      E   api/Resources/cache/Symfony/Config/Framework/PropertyAccessConfig.php  1f  Лh      J   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig.php*  1f*        ]   api/Resources/cache/Symfony/Config/Framework/Messenger/Serializer/SymfonySerializerConfig.php"  1f"  %<      K   api/Resources/cache/Symfony/Config/Framework/Messenger/SerializerConfig.phpl  1fl  Za      ^   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig/RetryStrategyConfig.php5  1f5        H   api/Resources/cache/Symfony/Config/Framework/Messenger/RoutingConfig.php<  1f<  ~̤      U   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/MiddlewareConfig.php  1f  ̳      D   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig.php
  1f
  =      C   api/Resources/cache/Symfony/Config/Framework/PropertyInfoConfig.php3  1f3  N      =   api/Resources/cache/Symfony/Config/Framework/MailerConfig.php  1f  5      :   api/Resources/cache/Symfony/Config/Framework/UidConfig.php
  1f
  6      @   api/Resources/cache/Symfony/Config/Framework/ExceptionConfig.phpK  1fK  r      >   api/Resources/cache/Symfony/Config/Framework/SessionConfig.php4  1f4  e@      A   api/Resources/cache/Symfony/Config/Framework/HttpClientConfig.php  1f  ܤ      @   api/Resources/cache/Symfony/Config/Framework/PhpErrorsConfig.php  1f        ?   api/Resources/cache/Symfony/Config/Framework/NotifierConfig.php  1f  StVȤ      >   api/Resources/cache/Symfony/Config/Framework/RequestConfig.php  1f  :      B   api/Resources/cache/Symfony/Config/Framework/AnnotationsConfig.php}  1f}  
j(      E   api/Resources/cache/Symfony/Config/Framework/Assets/PackageConfig.php   1f         X   api/Resources/cache/Symfony/Config/Framework/Validation/NotCompromisedPasswordConfig.php5  1f5  	6      I   api/Resources/cache/Symfony/Config/Framework/Validation/MappingConfig.php%  1f%  ,      M   api/Resources/cache/Symfony/Config/Framework/Validation/AutoMappingConfig.phpM  1fM  BФ      ;   api/Resources/cache/Symfony/Config/Framework/LockConfig.php  1f        ;   api/Resources/cache/Symfony/Config/Framework/FormConfig.php  1f  
      P   api/Resources/cache/Symfony/Config/Security/ProviderConfig/Memory/UserConfig.php  1f  U`      I   api/Resources/cache/Symfony/Config/Security/ProviderConfig/LdapConfig.php~  1f~  b      K   api/Resources/cache/Symfony/Config/Security/ProviderConfig/MemoryConfig.phpE	  1fE	        J   api/Resources/cache/Symfony/Config/Security/ProviderConfig/ChainConfig.phpV  1fV  BFc)      D   api/Resources/cache/Symfony/Config/Security/PasswordHasherConfig.php  1f  T      >   api/Resources/cache/Symfony/Config/Security/ProviderConfig.php  1f  p      =   api/Resources/cache/Symfony/Config/Security/EncoderConfig.phpz  1fz  ؤ      >   api/Resources/cache/Symfony/Config/Security/FirewallConfig.phpp  1fp  Y      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMeConfig.php0  1f0  aܤ      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginConfig.phpA  1fA  w      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginLdapConfig.phpp)  1fp)        N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicConfig.php  1f  &      J   api/Resources/cache/Symfony/Config/Security/FirewallConfig/GuardConfig.php  1f  'i      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginConfig.php  1f  }      X   api/Resources/cache/Symfony/Config/Security/FirewallConfig/Logout/DeleteCookieConfig.php.  1f.  [r      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/SwitchUserConfig.php
  1f
  [B      T   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginThrottlingConfig.php
  1f
  n      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginLinkConfig.php]3  1f]3  
k      f   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProvider/DoctrineConfig.php  1f  Ҥ      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProviderConfig.php)  1f)  Tפ      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginLdapConfig.phpxM  1fxM  5W      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicLdapConfig.php  1f  
ĞȤ      I   api/Resources/cache/Symfony/Config/Security/FirewallConfig/X509Config.php*
  1f*
  y      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AnonymousConfig.php  1f  +f      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RemoteUserConfig.php  1f  &      K   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LogoutConfig.php  1f  ʿ,      K   api/Resources/cache/Symfony/Config/Security/AccessDecisionManagerConfig.php  1f  I      C   api/Resources/cache/Symfony/Config/Security/AccessControlConfig.php  1f  ϐ      5   api/Resources/cache/Symfony/Config/SecurityConfig.php:  1f:  m      4   api/Resources/cache/Symfony/Config/MonologConfig.php  1f  tˤ      <   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig.php 1f yդ      V   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ProcessPsr3MessagesConfig.php
  1f
  Ӭx      L   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PublisherConfig.php  1f        H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/RedisConfig.php  1f  =      P   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ElasticsearchConfig.php  1f  p7      Q   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/EmailPrototypeConfig.phpV  1fV  ˊ      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/MongoConfig.php  1f  d%7      R   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/VerbosityLevelsConfig.php  1f  Q,C      I   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PredisConfig.php6  1f6  |!v      S   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ExcludedHttpCodeConfig.php[  1f[        K   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ChannelsConfig.php  1f  v      6   api/Resources/cache/Symfony/Config/FrameworkConfig.php  1f  M      #   api/Resources/cache/annotations.map)  1f)  8J)f      #   api/Resources/config/config_dev.yml  1f  =y      $   api/Resources/config/config_prod.yml   1f   ݣ      !   api/Resources/config/services.yml  1f  gѤ         api/Resources/config/config.yml9  1f9  zH         api/Resources/i18n/cs.yml  1f  e%ߤ         api/Resources/i18n/br.yml  1f           api/Resources/i18n/es.yml  1f           api/Resources/i18n/pt.yml  1f  ۛ|         api/Resources/i18n/de.yml,  1f,           api/Resources/i18n/it.yml  1f  k         api/Resources/i18n/pl.yml  1f  6T         api/Resources/i18n/fa.yml;	  1f;	  1,         api/Resources/i18n/sv.yml  1f  {͜Ԥ         api/Resources/i18n/en.yml  1f  fZ/         api/Resources/i18n/ja.yml  1f  Pf         api/Resources/i18n/ru.yml  1f           api/Resources/i18n/sr.yml  1f  6Ϥ         api/Resources/i18n/fr.yml  1f  >{[         api/Resources/i18n/lv.ymlN  1fN  'ݤ         api/Resources/i18n/tr.yml  1f  f         api/Resources/i18n/nl.yml  1f  4         api/Resources/i18n/zh.yml
  1f
  ֤         api/ApiApplication.php5  1f5  4      #   api/Tests/Composer/CloudJobTest.php  1f  ^      '   api/Tests/Controller/LogPatternTest.php0  1f0  Ӥ      !   api/Controller/FileController.phpI  1fI  Ye@      !   api/Controller/UserController.php  1f  @H          api/Controller/LogController.phpO  1fO  
+      (   api/Controller/Config/AuthController.php  1f  Q      2   api/Controller/Config/AbstractConfigController.php)  1f)  s      ,   api/Controller/Config/ComposerController.php7  1f7  r      +   api/Controller/Config/ManagerController.php3  1f3  &Y      !   api/Controller/TaskController.php  1f  /      *   api/Controller/Server/PhpWebController.php  1f  ;ۉ      *   api/Controller/Server/ContaoController.php"  1f"  Rˤ      ,   api/Controller/Server/DatabaseController.php  1f  ?yq      -   api/Controller/Server/AdminUserController.php[
  1f[
        +   api/Controller/Server/PhpinfoController.php  1f  p%      +   api/Controller/Server/OpcacheController.php_  1f_  ؚ      *   api/Controller/Server/ConfigController.php  1f  @n-      ,   api/Controller/Server/ComposerController.php  1f  oϤ      *   api/Controller/Server/PhpCliController.php  1f  $      .   api/Controller/Server/SelfUpdateController.php  1f  	쟤      $   api/Controller/SessionController.php  1f        5   api/Controller/Packages/MissingPackagesController.php]	  1f]	  T
v      4   api/Controller/Packages/UploadPackagesController.php@'  1f@'  
      1   api/Controller/Packages/RootPackageController.php  1f  %I      +   api/Controller/Packages/CloudController.php[  1f[  ى      3   api/Controller/Packages/LocalPackagesController.php  1f  㦜      '   api/Controller/ConstraintController.php  1f  ;rs      3   api/Controller/Contao/InstallToolLockController.phpc  1fc  G?      5   api/Controller/Contao/DatabaseMigrationController.php/&  1f/&  wK      -   api/Controller/Contao/AccessKeyController.php
  1f
  	ؤ      *   api/Controller/Contao/BackupController.php  1f  <4      3   api/Controller/Contao/MaintenanceModeController.php  1f  Cӗh      -   api/Controller/Contao/JwtCookieController.phpz  1fz  Ҵٝ         api/ApiKernel.php4'  1f4'  D         api/System/ServerInfo.php  1f  Z$         api/System/Request.php  1f  8         api/System/SelfUpdate.phpn  1fn           api/Task/TaskStatus.phpG  1fG  HK      &   api/Task/Composer/DumpAutoloadTask.php  1f  (      $   api/Task/Composer/ClearCacheTask.phpd  1fd  :	      #   api/Task/Manager/SelfUpdateTask.php  1f  ݤ         api/Task/AbstractTask.phpT  1fT  ۤ         api/Task/Packages/SetupTask.php.  1f.  &L          api/Task/Packages/UpdateTask.php.*  1f.*  k      !   api/Task/Packages/InstallTask.phpU
  1fU
  sE      *   api/Task/Packages/AbstractPackagesTask.php<  1f<  iz=      $   api/Task/Contao/BackupCreateTask.phph  1fh  "=      %   api/Task/Contao/BackupRestoreTask.phpS  1fS  0      $   api/Task/Contao/RebuildCacheTask.php3
  1f3
  ]`         api/Task/TaskManager.php  1f  =p$         api/Task/TaskInterface.php  1f  ]$         api/Task/TaskConfig.php}
  1f}
  HYq      %   api/Command/IntegrityCheckCommand.phpf	  1ff	  a8D         api/Command/UpdateCommand.phpF  1fF  sR          api/Command/TaskAbortCommand.php  1f  _ޒ      !   api/Command/TaskUpdateCommand.php  1f  z      $   api/Command/ProcessRunnerCommand.php  1f  d6         api/Command/AboutCommand.php  1f  /(      !   api/Command/TaskDeleteCommand.phpO  1fO  BN         api/I18n/Translator.phpt  1ft  ߤ      %   api/Exception/ApiProblemException.phps  1fs  
Q\      (   api/Exception/ProcessOutputException.php  1f  Z
      &   api/Exception/InvalidJsonException.php  1f  껤      "   api/Exception/RequestException.php  1f  W91      )   api/IntegrityCheck/AllowUrlFopenCheck.php!  1f!  -.      '   api/IntegrityCheck/GraphicsLibCheck.php  1f        &   api/IntegrityCheck/SysTempDirCheck.php  1f  P      .   api/IntegrityCheck/IntegrityCheckInterface.phpz  1fz  {	|      #   api/IntegrityCheck/ProcessCheck.php  1f  nW$      #   api/IntegrityCheck/SymlinkCheck.php  1f  ߠ      #   api/IntegrityCheck/SessionCheck.php  1f  5ˋ      '   api/IntegrityCheck/MemoryLimitCheck.php  1f        )   api/IntegrityCheck/PhpExtensionsCheck.php  1f  P      -   api/IntegrityCheck/AbstractIntegrityCheck.php  1f  :{      ,   api/IntegrityCheck/IntegrityCheckFactory.php  1f  7'         api/Process/ContaoApi.php  1f  U      !   api/Process/ProcessController.phpe  1fe  xƤ      %   api/Process/Forker/AbstractForker.php  1f  [ 2      &   api/Process/Forker/ForkerInterface.phpd  1fd  /^      #   api/Process/Forker/DisownForker.php  1f  ]       "   api/Process/Forker/NohupForker.php  1f  !      )   api/Process/Forker/WindowsStartForker.php  1f  
      #   api/Process/Forker/InlineForker.php  1f  Ѷ#         api/Process/Utf8Process.php  1f  SҤ         api/Process/ProcessRunner.php  1f  ä         api/Process/AbstractProcess.php  1f  OG         api/Process/ContaoConsole.php!  1f!  vE      #   api/Process/PhpExecutableFinder.php&  1f&        %   api/Process/ConsoleProcessFactory.php  1f  `         api/console8  1f8  i.      $   api/EventListener/LocaleListener.php  1f  .ʴ,      '   api/EventListener/ExceptionListener.phpQ
  1fQ
  Hq      &   api/EventListener/SecurityListener.php  1f  _m      )   api/EventListener/JsonRequestListener.php  1f  ĩ      
   downgrade.php0  1f0  q2      $   vendor/seld/phar-utils/composer.lock/  1f/  cւ(         vendor/seld/phar-utils/LICENSE"  1f"  ?e          vendor/seld/phar-utils/README.mde  1fe  :N      $   vendor/seld/phar-utils/composer.json;  1f;  =      %   vendor/seld/phar-utils/src/Linter.php
  1f
  #:	      )   vendor/seld/phar-utils/src/Timestamps.phpk  1fk  F         vendor/seld/jsonlint/LICENSE"  1f"  asy      !   vendor/seld/jsonlint/bin/jsonlint  1f   
      !   vendor/seld/jsonlint/CHANGELOG.md	  1f	  ݣʤ         vendor/seld/jsonlint/README.md
  1f
  f      "   vendor/seld/jsonlint/composer.jsonU  1fU  TR      @   vendor/seld/jsonlint/src/Seld/JsonLint/DuplicateKeyException.php  1f  ArQ      ;   vendor/seld/jsonlint/src/Seld/JsonLint/ParsingException.php  1f  m2;      0   vendor/seld/jsonlint/src/Seld/JsonLint/Lexer.php"  1f"  ;      4   vendor/seld/jsonlint/src/Seld/JsonLint/Undefined.php*  1f*        5   vendor/seld/jsonlint/src/Seld/JsonLint/JsonParser.php,_  1f,_  v      "   vendor/seld/signal-handler/LICENSE"  1f"  ?e      (   vendor/seld/signal-handler/composer.json  1f  c      0   vendor/seld/signal-handler/src/SignalHandler.phpO  1fO  ,C         vendor/autoload.php  1f  l         vendor/bin/yaml-lint
  1f
  8<h      "   vendor/bin/patch-type-declarations`
  1f`
  +դ         vendor/bin/validate-json0
  1f0
  ̤         vendor/bin/composer	
  1f	
  k?ۤ         vendor/bin/var-dump-server?
  1f?
  &j         vendor/bin/jsonlint  1f  X      '   vendor/composer/autoload_namespaces.php   1f   /t      &   vendor/composer/xdebug-handler/LICENSE)  1f)  #;^      +   vendor/composer/xdebug-handler/CHANGELOG.md  1f  !YsK      (   vendor/composer/xdebug-handler/README.md4  1f4  S%      ,   vendor/composer/xdebug-handler/composer.jsony  1fy  -      0   vendor/composer/xdebug-handler/src/PhpConfig.php  1f  ]      -   vendor/composer/xdebug-handler/src/Status.phpz  1fz  "      4   vendor/composer/xdebug-handler/src/XdebugHandler.phpKV  1fKV  Eb      .   vendor/composer/xdebug-handler/src/Process.phpH  1fH  G      +   vendor/composer/class-map-generator/LICENSE  1f  DӤ      -   vendor/composer/class-map-generator/README.mdP  1fP  7ta      1   vendor/composer/class-map-generator/composer.json  1f  \1%ޤ      =   vendor/composer/class-map-generator/src/ClassMapGenerator.php'5  1f'5  |ɤ      :   vendor/composer/class-map-generator/src/PhpFileCleaner.php?  1f?  s      4   vendor/composer/class-map-generator/src/FileList.phpc  1fc  r5      9   vendor/composer/class-map-generator/src/PhpFileParser.php  1f  S      4   vendor/composer/class-map-generator/src/ClassMap.php  1f  LR+         vendor/composer/LICENSE.  1f.            vendor/composer/ClassLoader.php?  1f?  2@u      +   vendor/composer/composer/phpstan/rules.neon  1f  ~d      1   vendor/composer/composer/res/composer-schema.jsonW  1fW  HK      <   vendor/composer/composer/res/composer-repository-schema.json  1f  |0      &   vendor/composer/composer/composer.lockGK 1fGK u           vendor/composer/composer/LICENSE,  1f,  Vg      %   vendor/composer/composer/bin/composer  1f        $   vendor/composer/composer/bin/compile  1f  \0      &   vendor/composer/composer/composer.jsong  1fg  =f      S   vendor/composer/composer/src/Composer/PHPStan/RuleReasonDataReturnTypeExtension.php
  1f
  
      K   vendor/composer/composer/src/Composer/PHPStan/ConfigReturnTypeExtension.php"  1f"  w      1   vendor/composer/composer/src/Composer/Factory.phpf~  1ff~  H"Ť      H   vendor/composer/composer/src/Composer/Repository/RepositoryInterface.php#  1f#  }      R   vendor/composer/composer/src/Composer/Repository/InstalledFilesystemRepository.php  1f  J=      F   vendor/composer/composer/src/Composer/Repository/PackageRepository.phpl  1fl  +Z%      H   vendor/composer/composer/src/Composer/Repository/LockArrayRepository.php  1f  Ȥ      G   vendor/composer/composer/src/Composer/Repository/PlatformRepository.php  1f  ajҤ      F   vendor/composer/composer/src/Composer/Repository/RepositoryFactory.php    1f    )      Q   vendor/composer/composer/src/Composer/Repository/InstalledRepositoryInterface.php  1f  +      P   vendor/composer/composer/src/Composer/Repository/WritableRepositoryInterface.php@  1f@  ek      D   vendor/composer/composer/src/Composer/Repository/RepositoryUtils.php
  1f
        P   vendor/composer/composer/src/Composer/Repository/RepositorySecurityException.php  1f  l	Ф      H   vendor/composer/composer/src/Composer/Repository/CompositeRepository.php  1f  $	)      D   vendor/composer/composer/src/Composer/Repository/ArrayRepository.phpw(  1fw(  x)      L   vendor/composer/composer/src/Composer/Repository/WritableArrayRepository.php	  1f	  X      B   vendor/composer/composer/src/Composer/Repository/VcsRepository.php"Q  1f"Q  BԾ      G   vendor/composer/composer/src/Composer/Repository/ComposerRepository.php 1f XEۤ      C   vendor/composer/composer/src/Composer/Repository/PearRepository.php`  1f`        B   vendor/composer/composer/src/Composer/Repository/RepositorySet.phpA  1fA  ҏX      G   vendor/composer/composer/src/Composer/Repository/ArtifactRepository.php  1f  	=x      J   vendor/composer/composer/src/Composer/Repository/RootPackageRepository.php:  1f:  V>      F   vendor/composer/composer/src/Composer/Repository/RepositoryManager.php  1f  nH      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitHubDriver.phpV  1fV        B   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriver.php  1f  rO      B   vendor/composer/composer/src/Composer/Repository/Vcs/SvnDriver.php4  1f4  매      A   vendor/composer/composer/src/Composer/Repository/Vcs/HgDriver.php  1f  ٤      G   vendor/composer/composer/src/Composer/Repository/Vcs/PerforceDriver.php  1f  %6ɤ      K   vendor/composer/composer/src/Composer/Repository/Vcs/GitBitbucketDriver.php8  1f8  Mn      B   vendor/composer/composer/src/Composer/Repository/Vcs/GitDriver.php"  1f"  QǪȤ      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitLabDriver.phpR  1fR  #      K   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriverInterface.php
  1f
  O
4ۤ      E   vendor/composer/composer/src/Composer/Repository/Vcs/FossilDriver.php  1f  {Yߤ      C   vendor/composer/composer/src/Composer/Repository/PathRepository.php!  1f!  O      J   vendor/composer/composer/src/Composer/Repository/VersionCacheInterface.phpd  1fd  ~      K   vendor/composer/composer/src/Composer/Repository/CanonicalPackagesTrait.php  1f  =      E   vendor/composer/composer/src/Composer/Repository/FilterRepository.php  1f  X      H   vendor/composer/composer/src/Composer/Repository/InstalledRepository.php3  1f3  !      N   vendor/composer/composer/src/Composer/Repository/AdvisoryProviderInterface.php  1f  XD@      I   vendor/composer/composer/src/Composer/Repository/FilesystemRepository.php>  1f>  /l      M   vendor/composer/composer/src/Composer/Repository/InstalledArrayRepository.php  1f  f~      T   vendor/composer/composer/src/Composer/Repository/ConfigurableRepositoryInterface.php  1f  F*'      O   vendor/composer/composer/src/Composer/Repository/InvalidRepositoryException.php  1f  f=      <   vendor/composer/composer/src/Composer/Util/PackageSorter.phpN  1fN  8
      >   vendor/composer/composer/src/Composer/Util/ConfigValidator.php[$  1f[$   zf      2   vendor/composer/composer/src/Composer/Util/Git.phpOZ  1fOZ  {q&      2   vendor/composer/composer/src/Composer/Util/Svn.php%  1f%  Bͤ      =   vendor/composer/composer/src/Composer/Util/NoProxyPattern.php)  1f)  x      =   vendor/composer/composer/src/Composer/Util/ComposerMirror.phpG	  1fG	  |u      :   vendor/composer/composer/src/Composer/Util/PackageInfo.phpA  1fA  #R      9   vendor/composer/composer/src/Composer/Util/AuthHelper.php8  1f8        2   vendor/composer/composer/src/Composer/Util/Zip.phpR
  1fR
  Aä      7   vendor/composer/composer/src/Composer/Util/Silencer.php;  1f;  <I      9   vendor/composer/composer/src/Composer/Util/Filesystem.phpw  1fw  $E      2   vendor/composer/composer/src/Composer/Util/Tar.php  1f        5   vendor/composer/composer/src/Composer/Util/GitHub.php!  1f!        5   vendor/composer/composer/src/Composer/Util/GitLab.php/  1f/  0      8   vendor/composer/composer/src/Composer/Util/Bitbucket.php1&  1f1&  A.(      =   vendor/composer/composer/src/Composer/Util/HttpDownloader.php)H  1f)H  s%G      8   vendor/composer/composer/src/Composer/Util/IniHelper.phpm  1fm  7r      7   vendor/composer/composer/src/Composer/Util/Platform.php"  1f"        C   vendor/composer/composer/src/Composer/Util/StreamContextFactory.php"  1f"  ?x      8   vendor/composer/composer/src/Composer/Util/TlsHelper.php  1f  b      2   vendor/composer/composer/src/Composer/Util/Url.php  1f  ?%      7   vendor/composer/composer/src/Composer/Util/Perforce.phpJ  1fJ        @   vendor/composer/composer/src/Composer/Util/Http/ProxyManager.phpN  1fN  [1I      <   vendor/composer/composer/src/Composer/Util/Http/Response.phpa  1fa  ^      @   vendor/composer/composer/src/Composer/Util/Http/RequestProxy.php  1f  Mg      B   vendor/composer/composer/src/Composer/Util/Http/CurlDownloader.phpt  1ft  \A      @   vendor/composer/composer/src/Composer/Util/Http/CurlResponse.php  1f  1'ɤ      =   vendor/composer/composer/src/Composer/Util/Http/ProxyItem.php  1f  =eY      ?   vendor/composer/composer/src/Composer/Util/MetadataMinifier.php  1f  #`      >   vendor/composer/composer/src/Composer/Util/ProcessExecutor.php:?  1f:?  7M>ܤ      1   vendor/composer/composer/src/Composer/Util/Hg.php  1f  1[c      ?   vendor/composer/composer/src/Composer/Util/RemoteFilesystem.phpk  1fk  2F      ;   vendor/composer/composer/src/Composer/Util/ErrorHandler.php*
  1f*
  h      9   vendor/composer/composer/src/Composer/Util/SyncHelper.php
  1f
  ެpQ      3   vendor/composer/composer/src/Composer/Util/Loop.php2  1f2        A   vendor/composer/composer/src/Composer/Config/JsonConfigSource.phpv)  1fv)        F   vendor/composer/composer/src/Composer/Config/ConfigSourceInterface.phpf  1ff  (פ      =   vendor/composer/composer/src/Composer/SelfUpdate/Versions.php  1f  .]!      9   vendor/composer/composer/src/Composer/SelfUpdate/Keys.php  1f  -*      /   vendor/composer/composer/src/Composer/Cache.php+  1f+  2v      ?   vendor/composer/composer/src/Composer/EventDispatcher/Event.php  1f  ~ k      R   vendor/composer/composer/src/Composer/EventDispatcher/ScriptExecutionException.php  1f  ;;      I   vendor/composer/composer/src/Composer/EventDispatcher/EventDispatcher.phpj|  1fj|  Uu      R   vendor/composer/composer/src/Composer/EventDispatcher/EventSubscriberInterface.phpu  1fu  h_}      9   vendor/composer/composer/src/Composer/PartialComposer.phpF	  1fF	  =      :   vendor/composer/composer/src/Composer/Platform/Runtime.php  1f  H.      ?   vendor/composer/composer/src/Composer/Platform/HhvmDetector.php  1f  8       :   vendor/composer/composer/src/Composer/Platform/Version.php
  1f
  \      5   vendor/composer/composer/src/Composer/IO/BufferIO.php  1f  /a      6   vendor/composer/composer/src/Composer/IO/ConsoleIO.phpK)  1fK)  51      3   vendor/composer/composer/src/Composer/IO/BaseIO.php'!  1f'!  1      3   vendor/composer/composer/src/Composer/IO/NullIO.php	  1f	  {      8   vendor/composer/composer/src/Composer/IO/IOInterface.phpZ   1fZ   
      =   vendor/composer/composer/src/Composer/Plugin/PluginEvents.phpe  1fe  1+ˤ      C   vendor/composer/composer/src/Composer/Plugin/PreCommandRunEvent.php2  1f2  :q@      K   vendor/composer/composer/src/Composer/Plugin/Capability/CommandProvider.php  1f  d,      F   vendor/composer/composer/src/Composer/Plugin/Capability/Capability.php  1f  Lk      G   vendor/composer/composer/src/Composer/Plugin/PluginBlockedException.php  1f  Nu      =   vendor/composer/composer/src/Composer/Plugin/CommandEvent.phpy  1fy  /      @   vendor/composer/composer/src/Composer/Plugin/PluginInterface.php?  1f?  #?"      >   vendor/composer/composer/src/Composer/Plugin/PluginManager.phpC  1fC  jw3      E   vendor/composer/composer/src/Composer/Plugin/PreFileDownloadEvent.php9  1f9        F   vendor/composer/composer/src/Composer/Plugin/PostFileDownloadEvent.php
  1f
        8   vendor/composer/composer/src/Composer/Plugin/Capable.php  1f  u      C   vendor/composer/composer/src/Composer/Plugin/PrePoolCreateEvent.php  1f  H      B   vendor/composer/composer/src/Composer/Downloader/RarDownloader.php
  1f
        R   vendor/composer/composer/src/Composer/Downloader/VcsCapableDownloaderInterface.phpC  1fC  H      B   vendor/composer/composer/src/Composer/Downloader/VcsDownloader.php3  1f3  j      H   vendor/composer/composer/src/Composer/Downloader/FilesystemException.php  1f  J      D   vendor/composer/composer/src/Composer/Downloader/DownloadManager.phpR<  1fR<  H      B   vendor/composer/composer/src/Composer/Downloader/TarDownloader.php  1f  K7J      E   vendor/composer/composer/src/Composer/Downloader/FossilDownloader.php  1f  i[      Q   vendor/composer/composer/src/Composer/Downloader/MaxFileSizeExceededException.php  1f  `ܤ      H   vendor/composer/composer/src/Composer/Downloader/DownloaderInterface.php  1f  x      A   vendor/composer/composer/src/Composer/Downloader/XzDownloader.phpu  1fu  b      A   vendor/composer/composer/src/Composer/Downloader/HgDownloader.php  1f  |      B   vendor/composer/composer/src/Composer/Downloader/SvnDownloader.php"  1f"  -e      C   vendor/composer/composer/src/Composer/Downloader/FileDownloader.php
Q  1f
Q  ,Ϥ      J   vendor/composer/composer/src/Composer/Downloader/ChangeReportInterface.php'  1f'  }s$      G   vendor/composer/composer/src/Composer/Downloader/TransportException.php  1f  ҳ/      F   vendor/composer/composer/src/Composer/Downloader/ArchiveDownloader.php!  1f!  
      L   vendor/composer/composer/src/Composer/Downloader/DvcsDownloaderInterface.php6  1f6  1N}      C   vendor/composer/composer/src/Composer/Downloader/PharDownloader.php  1f  /&֤      C   vendor/composer/composer/src/Composer/Downloader/PathDownloader.php2  1f2  ȞO      G   vendor/composer/composer/src/Composer/Downloader/PerforceDownloader.php
  1f
  R.      B   vendor/composer/composer/src/Composer/Downloader/GitDownloader.phpJb  1fJb  S:      B   vendor/composer/composer/src/Composer/Downloader/ZipDownloader.php'9  1f'9  Dx      C   vendor/composer/composer/src/Composer/Downloader/GzipDownloader.php  1f  ~o      0   vendor/composer/composer/src/Composer/Config.php_  1f_  ~n      6   vendor/composer/composer/src/Composer/Script/Event.php  1f  D]      =   vendor/composer/composer/src/Composer/Script/ScriptEvents.php  1f  KGꮤ      M   vendor/composer/composer/src/Composer/Question/StrictConfirmationQuestion.php  1f  z2      2   vendor/composer/composer/src/Composer/Composer.php  1f  2      F   vendor/composer/composer/src/Composer/Json/JsonValidationException.phpl  1fl  exˤ      <   vendor/composer/composer/src/Composer/Json/JsonFormatter.php  1f  #n|      7   vendor/composer/composer/src/Composer/Json/JsonFile.php2  1f2  <^=      >   vendor/composer/composer/src/Composer/Json/JsonManipulator.phpbS  1fbS  ٺ      ;   vendor/composer/composer/src/Composer/InstalledVersions.php?  1f?  Fb      W   vendor/composer/composer/src/Composer/DependencyResolver/Operation/InstallOperation.phpz  1fz  =~i      b   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasInstalledOperation.phpx  1fx  nҤ      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/OperationInterface.php  1f  }|(̤      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UpdateOperation.phpw  1fw  c;      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/SolverOperation.php  1f  Iw      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UninstallOperation.phpb  1fb  &Yl      d   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasUninstalledOperation.php~  1f~        H   vendor/composer/composer/src/Composer/DependencyResolver/Transaction.php7  1f7  aT      L   vendor/composer/composer/src/Composer/DependencyResolver/PolicyInterface.phpx  1fx  -]      Q   vendor/composer/composer/src/Composer/DependencyResolver/LocalRepoTransaction.php(  1f(  tʺ      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchGraph.phpA  1fA  >      H   vendor/composer/composer/src/Composer/DependencyResolver/GenericRule.php  1f  6|      L   vendor/composer/composer/src/Composer/DependencyResolver/LockTransaction.php  1f  h      C   vendor/composer/composer/src/Composer/DependencyResolver/Solver.phpg  1fg  ӂu      A   vendor/composer/composer/src/Composer/DependencyResolver/Rule.phpN  1fN  UG      J   vendor/composer/composer/src/Composer/DependencyResolver/Rule2Literals.php
  1f
  7|K      T   vendor/composer/composer/src/Composer/DependencyResolver/SolverProblemsException.php^  1f^  |!8      O   vendor/composer/composer/src/Composer/DependencyResolver/SolverBugException.php  1f  /d      J   vendor/composer/composer/src/Composer/DependencyResolver/DefaultPolicy.php'  1f'  '_      J   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchNode.php  1f  '      D   vendor/composer/composer/src/Composer/DependencyResolver/RuleSet.php=  1f=  _4      A   vendor/composer/composer/src/Composer/DependencyResolver/Pool.php   1f   ?6lJ      N   vendor/composer/composer/src/Composer/DependencyResolver/MultiConflictRule.php
  1f
  _      D   vendor/composer/composer/src/Composer/DependencyResolver/Request.phpa!  1fa!  j      J   vendor/composer/composer/src/Composer/DependencyResolver/PoolOptimizer.phpL  1fL  5ߤ      M   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetGenerator.php6  1f6  NkǤ      F   vendor/composer/composer/src/Composer/DependencyResolver/Decisions.php  1f  3N      H   vendor/composer/composer/src/Composer/DependencyResolver/PoolBuilder.phpa  1fa  2[+4      D   vendor/composer/composer/src/Composer/DependencyResolver/Problem.phpr  1fr  ϒۤ      L   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetIterator.php@
  1f@
  w      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchChain.php  1f  ]      D   vendor/composer/composer/src/Composer/Autoload/AutoloadGenerator.php"  1f"  (*)(      >   vendor/composer/composer/src/Composer/Autoload/ClassLoader.phpg>  1fg>  v      D   vendor/composer/composer/src/Composer/Autoload/ClassMapGenerator.php  1f  I%c       A   vendor/composer/composer/src/Composer/Command/SuggestsCommand.php;  1f;  :&|      ?   vendor/composer/composer/src/Composer/Command/SearchCommand.php  1f  k^      =   vendor/composer/composer/src/Composer/Command/BumpCommand.php+&  1f+&  Q\      @   vendor/composer/composer/src/Composer/Command/ArchiveCommand.php!  1f!  +ä      >   vendor/composer/composer/src/Composer/Command/AuditCommand.php1
  1f1
  T      A   vendor/composer/composer/src/Composer/Command/ValidateCommand.php$  1f$        =   vendor/composer/composer/src/Composer/Command/FundCommand.php  1f  {      G   vendor/composer/composer/src/Composer/Command/PackageDiscoveryTrait.phpO  1fO   ީ      D   vendor/composer/composer/src/Composer/Command/ScriptAliasCommand.php
  1f
  \       F   vendor/composer/composer/src/Composer/Command/CreateProjectCommand.php\  1f\  D      =   vendor/composer/composer/src/Composer/Command/BaseCommand.phpA  1fA  4n      A   vendor/composer/composer/src/Composer/Command/OutdatedCommand.php  1f  X      E   vendor/composer/composer/src/Composer/Command/DumpAutoloadCommand.phpJ  1fJ  C      =   vendor/composer/composer/src/Composer/Command/HomeCommand.phpa  1fa  Tq      B   vendor/composer/composer/src/Composer/Command/ReinstallCommand.php  1f        ?   vendor/composer/composer/src/Composer/Command/RemoveCommand.php;  1f;  '/      =   vendor/composer/composer/src/Composer/Command/ShowCommand.php 1f iq      @   vendor/composer/composer/src/Composer/Command/InstallCommand.php  1f  
q      =   vendor/composer/composer/src/Composer/Command/InitCommand.phpX  1fX  ȁ      B   vendor/composer/composer/src/Composer/Command/RunScriptCommand.php  1f  rm      ?   vendor/composer/composer/src/Composer/Command/ConfigCommand.php  1f  !I      A   vendor/composer/composer/src/Composer/Command/LicensesCommand.php  1f  8$䂤      ?   vendor/composer/composer/src/Composer/Command/UpdateCommand.php?  1f?  RŪ      ?   vendor/composer/composer/src/Composer/Command/StatusCommand.phpv   1fv   y	0      G   vendor/composer/composer/src/Composer/Command/BaseDependencyCommand.phpL-  1fL-        @   vendor/composer/composer/src/Composer/Command/DependsCommand.php  1f  vN      B   vendor/composer/composer/src/Composer/Command/ProhibitsCommand.php  1f   &      J   vendor/composer/composer/src/Composer/Command/CheckPlatformReqsCommand.php  1f  Yj      C   vendor/composer/composer/src/Composer/Command/SelfUpdateCommand.phph  1fh  E!      @   vendor/composer/composer/src/Composer/Command/RequireCommand.php7t  1f7t  w^z      A   vendor/composer/composer/src/Composer/Command/CompletionTrait.php  1f  |ޤ      C   vendor/composer/composer/src/Composer/Command/ClearCacheCommand.phpX
  1fX
  (      A   vendor/composer/composer/src/Composer/Command/DiagnoseCommand.phpƀ  1fƀ  N6Ф      ?   vendor/composer/composer/src/Composer/Command/GlobalCommand.php  1f  ~i      >   vendor/composer/composer/src/Composer/Command/AboutCommand.php  1f  
      =   vendor/composer/composer/src/Composer/Command/ExecCommand.php>  1f>  Ƙi      3   vendor/composer/composer/src/Composer/Installer.php  1f  "F      m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterInterface.php  1f         m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreAllPlatformRequirementFilter.php  1f  u      n   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreListPlatformRequirementFilter.php  1f  f      q   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreNothingPlatformRequirementFilter.php  1f  u      k   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterFactory.php  1f  $¤      A   vendor/composer/composer/src/Composer/Installer/PackageEvents.php"  1f"  ]m      C   vendor/composer/composer/src/Composer/Installer/BinaryInstaller.php8  1f8  (n      C   vendor/composer/composer/src/Composer/Installer/PluginInstaller.phpw  1fw  0\      K   vendor/composer/composer/src/Composer/Installer/BinaryPresenceInterface.php  1f  <P      C   vendor/composer/composer/src/Composer/Installer/InstallerEvents.php  1f  "e      @   vendor/composer/composer/src/Composer/Installer/PackageEvent.php  1f  T      B   vendor/composer/composer/src/Composer/Installer/InstallerEvent.php  1f  r>      D   vendor/composer/composer/src/Composer/Installer/LibraryInstaller.php&,  1f&,        F   vendor/composer/composer/src/Composer/Installer/InstallerInterface.php1  1f1  K;      H   vendor/composer/composer/src/Composer/Installer/MetapackageInstaller.php  1f  ն٤      D   vendor/composer/composer/src/Composer/Installer/ProjectInstaller.php
  1f
        M   vendor/composer/composer/src/Composer/Installer/SuggestedPackagesReporter.php  1f  vӤ      G   vendor/composer/composer/src/Composer/Installer/InstallationManager.php4_  1f4_  &      A   vendor/composer/composer/src/Composer/Installer/NoopInstaller.phpY  1fY  ^.      C   vendor/composer/composer/src/Composer/Advisory/SecurityAdvisory.php  1f  ݭ      J   vendor/composer/composer/src/Composer/Advisory/PartialSecurityAdvisory.php  1f  u      :   vendor/composer/composer/src/Composer/Advisory/Auditor.php9  1f9        J   vendor/composer/composer/src/Composer/Advisory/IgnoredSecurityAdvisory.phpk  1fk  K`      R   vendor/composer/composer/src/Composer/Exception/IrrecoverableDownloadException.php  1f        B   vendor/composer/composer/src/Composer/Exception/NoSslException.php  1f  ;P      2   vendor/composer/composer/src/Composer/Compiler.php)-  1f)-  ?      9   vendor/composer/composer/src/Composer/Package/Package.php-E  1f-E  }      6   vendor/composer/composer/src/Composer/Package/Link.php
  1f
  +H      J   vendor/composer/composer/src/Composer/Package/CompletePackageInterface.php  1f  }{+      I   vendor/composer/composer/src/Composer/Package/Archiver/ArchiveManager.php$  1f$  f      P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFinder.php  1f         G   vendor/composer/composer/src/Composer/Package/Archiver/PharArchiver.php  1f  ǁM      L   vendor/composer/composer/src/Composer/Package/Archiver/BaseExcludeFilter.php  1f  @ݤ      P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFilter.php  1f  ߵ      K   vendor/composer/composer/src/Composer/Package/Archiver/GitExcludeFilter.php  1f  ^      P   vendor/composer/composer/src/Composer/Package/Archiver/ComposerExcludeFilter.php  1f  ޣ      L   vendor/composer/composer/src/Composer/Package/Archiver/ArchiverInterface.php  1f  ;w      F   vendor/composer/composer/src/Composer/Package/Archiver/ZipArchiver.php  1f        F   vendor/composer/composer/src/Composer/Package/CompleteAliasPackage.php  1f  lN(      >   vendor/composer/composer/src/Composer/Package/AliasPackage.phpe'  1fe'  Ҥ      8   vendor/composer/composer/src/Composer/Package/Locker.phpN  1fN  ]+      B   vendor/composer/composer/src/Composer/Package/PackageInterface.php$/  1f$/  vp      G   vendor/composer/composer/src/Composer/Package/Version/VersionBumper.php  1f  OC      I   vendor/composer/composer/src/Composer/Package/Version/StabilityFilter.phpQ  1fQ  Tw      H   vendor/composer/composer/src/Composer/Package/Version/VersionGuesser.phpC  1fC  1Z      I   vendor/composer/composer/src/Composer/Package/Version/VersionSelector.phps/  1fs/  Ӥ      G   vendor/composer/composer/src/Composer/Package/Version/VersionParser.php  1f  
?      N   vendor/composer/composer/src/Composer/Package/Loader/ValidatingArrayLoader.phpr  1fr  Az      P   vendor/composer/composer/src/Composer/Package/Loader/InvalidPackageException.phpo  1fo  ,Ҥ      D   vendor/composer/composer/src/Composer/Package/Loader/ArrayLoader.phpF  1fF  W
      H   vendor/composer/composer/src/Composer/Package/Loader/LoaderInterface.phpj  1fj  7      J   vendor/composer/composer/src/Composer/Package/Loader/RootPackageLoader.php-  1f-   G&      C   vendor/composer/composer/src/Composer/Package/Loader/JsonLoader.phpc  1fc  ܝ@      =   vendor/composer/composer/src/Composer/Package/BasePackage.php  1f  գ      C   vendor/composer/composer/src/Composer/Package/Comparer/Comparer.phpu  1fu  L`      B   vendor/composer/composer/src/Composer/Package/RootAliasPackage.php  1f  r      A   vendor/composer/composer/src/Composer/Package/CompletePackage.php@  1f@  ew      F   vendor/composer/composer/src/Composer/Package/RootPackageInterface.php  1f  7      =   vendor/composer/composer/src/Composer/Package/RootPackage.php@  1f@  B:      D   vendor/composer/composer/src/Composer/Package/Dumper/ArrayDumper.php  1f  pƤ      =   vendor/composer/composer/src/Composer/Console/Application.php+|  1f+|  j.0Ӥ      C   vendor/composer/composer/src/Composer/Console/GithubActionError.phpl  1fl  g`+      E   vendor/composer/composer/src/Composer/Console/Input/InputArgument.php
  1f
        C   vendor/composer/composer/src/Composer/Console/Input/InputOption.php  1f  /      E   vendor/composer/composer/src/Composer/Console/HtmlOutputFormatter.php1  1f1  g?Ѥ      *   vendor/composer/composer/src/bootstrap.php7  1f7  t      (   vendor/composer/ca-bundle/res/cacert.pem} 1f} ۤ      !   vendor/composer/ca-bundle/LICENSE  1f  *!^`      #   vendor/composer/ca-bundle/README.md1  1f1  >VuĤ      '   vendor/composer/ca-bundle/composer.jsonU  1fU  }      *   vendor/composer/ca-bundle/src/CaBundle.php+  1f+  c٤      !   vendor/composer/autoload_psr4.php}  1f}  CV      %   vendor/composer/autoload_classmap.php 1f Qꖤ      "   vendor/composer/platform_check.php  1f  UԤ      #   vendor/composer/autoload_static.phpw 1fw K	      !   vendor/composer/autoload_real.php  1f  Rue         vendor/composer/semver/LICENSE  1f  Bh      #   vendor/composer/semver/CHANGELOG.md&  1f&  Nꡤ          vendor/composer/semver/README.mdH
  1fH
   }Τ      $   vendor/composer/semver/composer.json  1f  .      /   vendor/composer/semver/src/CompilingMatcher.php
  1f
  x      '   vendor/composer/semver/src/Interval.phpu  1fu         )   vendor/composer/semver/src/Comparator.php<
  1f<
  <L      (   vendor/composer/semver/src/Intervals.phpLP  1fLP  K.      %   vendor/composer/semver/src/Semver.phpr
  1fr
  Τ      ,   vendor/composer/semver/src/VersionParser.phpSU  1fSU  <J?F      =   vendor/composer/semver/src/Constraint/ConstraintInterface.php  1f  겤      9   vendor/composer/semver/src/Constraint/MultiConstraint.php#  1f#  o      4   vendor/composer/semver/src/Constraint/Constraint.php2  1f2  *      <   vendor/composer/semver/src/Constraint/MatchAllConstraint.php,  1f,  [j<      =   vendor/composer/semver/src/Constraint/MatchNoneConstraint.php(  1f(  h      /   vendor/composer/semver/src/Constraint/Bound.php
  1f
        "   vendor/composer/autoload_files.php*  1f*  +T      %   vendor/composer/InstalledVersions.php?  1f?  Fb         vendor/composer/installed.phpK  1fK  {B         vendor/composer/pcre/LICENSE  1f  hg^         vendor/composer/pcre/README.md>!  1f>!        #   vendor/composer/pcre/extension.neon  1f  &&1      "   vendor/composer/pcre/composer.json  1f        E   vendor/composer/pcre/src/PHPStan/PregMatchTypeSpecifyingExtension.phpq  1fq  4      L   vendor/composer/pcre/src/PHPStan/PregReplaceCallbackClosureTypeExtension.php	  1f	  +      G   vendor/composer/pcre/src/PHPStan/PregMatchParameterOutTypeExtension.php  1f        <   vendor/composer/pcre/src/PHPStan/InvalidRegexPatternRule.phpV  1fV   r      3   vendor/composer/pcre/src/PHPStan/PregMatchFlags.php  1f  je      ?   vendor/composer/pcre/src/PHPStan/UnsafeStrictGroupsCallRule.php
  1f
  tCs      (   vendor/composer/pcre/src/MatchResult.php  1f  ڇҤ      "   vendor/composer/pcre/src/Regex.php8  1f8  h:      6   vendor/composer/pcre/src/MatchAllWithOffsetsResult.php  1f        3   vendor/composer/pcre/src/MatchWithOffsetsResult.php  1f  o      7   vendor/composer/pcre/src/MatchAllStrictGroupsResult.phpw  1fw  Q      9   vendor/composer/pcre/src/UnexpectedNullMatchException.php"  1f"  _      4   vendor/composer/pcre/src/MatchStrictGroupsResult.php  1f        +   vendor/composer/pcre/src/MatchAllResult.php  1f  	Z      *   vendor/composer/pcre/src/ReplaceResult.php  1f  /      !   vendor/composer/pcre/src/Preg.phpJ  1fJ  Y]      *   vendor/composer/pcre/src/PcreException.php  1f  g[/      )   vendor/composer/metadata-minifier/LICENSE  1f  hg^      +   vendor/composer/metadata-minifier/README.mdL  1fL  Mv<      3   vendor/composer/metadata-minifier/phpstan.neon.distB   1fB   #f      /   vendor/composer/metadata-minifier/composer.json  1f  D0פ      :   vendor/composer/metadata-minifier/src/MetadataMinifier.php
  1f
         6   vendor/composer/spdx-licenses/res/spdx-exceptions.json  1f  "m      4   vendor/composer/spdx-licenses/res/spdx-licenses.json  1f  
x       %   vendor/composer/spdx-licenses/LICENSE  1f  Bh      *   vendor/composer/spdx-licenses/CHANGELOG.mdS  1fS  p+      '   vendor/composer/spdx-licenses/README.md<  1f<  se      /   vendor/composer/spdx-licenses/phpstan.neon.dist   1f   -      +   vendor/composer/spdx-licenses/composer.json  1f   '      2   vendor/composer/spdx-licenses/src/SpdxLicenses.php%  1f%  ]H
      &   vendor/paragonie/random_compat/LICENSEJ  1fJ  >       =   vendor/paragonie/random_compat/dist/random_compat.phar.pubkey   1f   *A|      A   vendor/paragonie/random_compat/dist/random_compat.phar.pubkey.asc  1f  ١i      3   vendor/paragonie/random_compat/other/build_phar.phpI  1fI   c      ,   vendor/paragonie/random_compat/build-phar.sh   1f   t8Q      1   vendor/paragonie/random_compat/psalm-autoload.php  1f        -   vendor/paragonie/random_compat/lib/random.phpJ  1fJ  .N      ,   vendor/paragonie/random_compat/composer.json  1f  ŀM      (   vendor/paragonie/random_compat/psalm.xmlT  1fT  D         vendor/doctrine/lexer/LICENSE)  1f)  `XQ         vendor/doctrine/lexer/README.mdo  1fo  6q          vendor/doctrine/lexer/UPGRADE.mdw  1fw  oK      #   vendor/doctrine/lexer/composer.json  1f  VL¤      #   vendor/doctrine/lexer/src/Token.php  1f  @D      +   vendor/doctrine/lexer/src/AbstractLexer.php  1f  x	      #   vendor/doctrine/annotations/LICENSE)  1f)  ``      %   vendor/doctrine/annotations/README.md  1f  5פ      I   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/PhpParser.php	  1f	  b7      S   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationException.php  1f        O   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/FileCacheReader.php!   1f!   W[      c   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/NamedArgumentConstructor.php  1f  \      [   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/IgnoreAnnotation.php  1f  ז&ߤ      U   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Attributes.php6  1f6  :פ      O   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Enum.phpE  1fE  Z'      T   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Attribute.phpu  1fu  Bʤ      Q   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Target.php
	  1f
	  5      S   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Required.php   1f   hf      M   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/IndexedReader.php 	  1f 	  7Ku      F   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Reader.php	  1f	  F      J   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation.php
  1f
  |Τ      V   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/SimpleAnnotationReader.phpa
  1fa
        O   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/PsrCachedReader.php  1f  g      I   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/DocParser.php  1f  C      L   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/CachedReader.php  1f  DP5)      K   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/TokenParser.php  1f  p#      `   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/ImplicitlyIgnoredAnnotationNames.php  1f  M      P   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationReader.php,  1f,  (m      R   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationRegistry.php
  1f
  'L{x      H   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/DocLexer.php
  1f
  U)      b   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/NamedArgumentConstructorAnnotation.phpi  1fi  !      )   vendor/doctrine/annotations/composer.json  1f  Ф      %   vendor/doctrine/annotations/psalm.xml  1f   C,      $   vendor/doctrine/deprecations/LICENSE)  1f)  "0      &   vendor/doctrine/deprecations/README.md$  1f$  qU      U   vendor/doctrine/deprecations/lib/Doctrine/Deprecations/PHPUnit/VerifyDeprecations.php  1f  K      F   vendor/doctrine/deprecations/lib/Doctrine/Deprecations/Deprecation.php\$  1f\$  L_      *   vendor/doctrine/deprecations/composer.json  1f  ;R      %   vendor/firebase/php-jwt/composer.lock/  1f/  ݝ         vendor/firebase/php-jwt/LICENSE  1f  -nK      #   vendor/firebase/php-jwt/package.xml[  1f[  2t      !   vendor/firebase/php-jwt/README.md  1f  H      %   vendor/firebase/php-jwt/composer.json  1f  @      9   vendor/firebase/php-jwt/src/SignatureInvalidException.phpu   1fu   Ͻ      4   vendor/firebase/php-jwt/src/BeforeValidException.phpp   1fp   +Ȥ      0   vendor/firebase/php-jwt/src/ExpiredException.phpl   1fl   Sֶ
      #   vendor/firebase/php-jwt/src/JWT.php5  1f5        (   vendor/justinrainbow/json-schema/LICENSE   1f         2   vendor/justinrainbow/json-schema/bin/validate-json  1f        F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-03.json  1f  -aߤ      F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-04.json  1f  Nߤ      *   vendor/justinrainbow/json-schema/README.mdz  1fz  ˱      .   vendor/justinrainbow/json-schema/composer.json  1f  7      ;   vendor/justinrainbow/json-schema/src/JsonSchema/Rfc3339.php  1f  ̤      =   vendor/justinrainbow/json-schema/src/JsonSchema/Validator.php
  1f
         I   vendor/justinrainbow/json-schema/src/JsonSchema/UriRetrieverInterface.php  1f  hJ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ObjectConstraint.php{  1f{  =6      G   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Factory.php  1f  ߤ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/NumberConstraint.php
  1f
  Uj      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeConstraint.php  1f  MY      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/BaseConstraint.php   1f   ֤      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/EnumConstraint.php  1f  l$М      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/StringConstraint.php  1f  ^      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ConstraintInterface.php3  1f3  9¤      T   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/CollectionConstraint.php  1f  5q      J   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Constraint.php  1f  d5      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/FormatConstraint.php.#  1f.#  '      \   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/TypeCheckInterface.php  1f  y      Y   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/StrictTypeCheck.php:  1f:  *9      X   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/LooseTypeCheck.php  1f  r(      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/UndefinedConstraint.php<  1f<  U>      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/SchemaConstraint.php!  1f!        F   vendor/justinrainbow/json-schema/src/JsonSchema/Entity/JsonPointer.php4
  1f4
        H   vendor/justinrainbow/json-schema/src/JsonSchema/UriResolverInterface.php   1f   "      K   vendor/justinrainbow/json-schema/src/JsonSchema/Iterator/ObjectIterator.php
  1f
  hl      A   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorage.php  1f  Nq      X   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/UriRetrieverInterface.php  1f  -,      T   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/AbstractRetriever.php  1f  _Ǥ      G   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/Curl.php  1f  x(      R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/FileGetContents.php^
  1f^
        R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/PredefinedArray.php
  1f
  /8      D   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriRetriever.php$  1f$  Aq      C   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriResolver.php  1f  _9<      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ResourceNotFoundException.phpb  1fb  `      P   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ExceptionInterface.phpX   1fX   [      N   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/RuntimeException.phpo  1fo  Cr      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSourceUriException.phpj  1fj  *5      V   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidArgumentException.php  1f  N      ^   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UnresolvableJsonPointerException.php  1f  ZHe      Q   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ValidationException.php'  1f'  Aj      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidConfigException.php_  1f_  P      S   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/JsonDecodingException.php  1f  nW      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaException.php\  1f\  @S6      R   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UriResolverException.phpX  1fX  Ӕ      ]   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaMediaTypeException.phpe  1fe  U3$      J   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorageInterface.php.  1f.  VԠg      1   vendor/crell/api-problem/docker/php/81/Dockerfile  1f  L>      1   vendor/crell/api-problem/docker/php/81/xdebug.inil   1fl   b0      >   vendor/crell/api-problem/docker/php/conf.d/error_reporting.ini   1f   lc¤      !   vendor/crell/api-problem/Makefile]  1f]  Zib      *   vendor/crell/api-problem/phpstan.neon.dist0   1f0   b      +   vendor/crell/api-problem/docker-compose.ymlb  1fb  Ruv      &   vendor/crell/api-problem/composer.json  1f  @      %   vendor/crell/api-problem/default-.env  1f  ]h	Q      4   vendor/crell/api-problem/src/JsonEncodeException.php   1f   ewF      .   vendor/crell/api-problem/src/HttpConverter.phpe
  1fe
  ΊE      3   vendor/crell/api-problem/src/JsonParseException.phpH  1fH  %P(      .   vendor/crell/api-problem/src/JsonException.php  1f  5-      +   vendor/crell/api-problem/src/ApiProblem.phpH  1fH  |o         vendor/psr/cache/CHANGELOG.md  1f  -	G         vendor/psr/cache/README.md  1f  m         vendor/psr/cache/LICENSE.txt8  1f8  Df         vendor/psr/cache/composer.json3  1f3  ̥P      /   vendor/psr/cache/src/CacheItemPoolInterface.php+  1f+  S%Ĥ      +   vendor/psr/cache/src/CacheItemInterface.php  1f  J      1   vendor/psr/cache/src/InvalidArgumentException.php:  1f:  MY      '   vendor/psr/cache/src/CacheException.php   1f   w"'      #   vendor/psr/event-dispatcher/LICENSE(  1f(  }]      %   vendor/psr/event-dispatcher/README.mdE  1fE  S      )   vendor/psr/event-dispatcher/composer.jsonb  1fb  q      =   vendor/psr/event-dispatcher/src/ListenerProviderInterface.php  1f  bh      <   vendor/psr/event-dispatcher/src/EventDispatcherInterface.php  1f        ;   vendor/psr/event-dispatcher/src/StoppableEventInterface.php!  1f!  T>q         vendor/psr/container/LICENSEy  1fy  Op         vendor/psr/container/README.mdB  1fB  g?      "   vendor/psr/container/composer.jsonu  1fu  g      7   vendor/psr/container/src/NotFoundExceptionInterface.php   1f   B@      /   vendor/psr/container/src/ContainerInterface.php  1f  M      8   vendor/psr/container/src/ContainerExceptionInterface.php   1f   &         vendor/psr/log/LICENSE=  1f=  pO         vendor/psr/log/README.mdB  1fB  '      /   vendor/psr/log/Psr/Log/LoggerAwareInterface.php8  1f8  "#      #   vendor/psr/log/Psr/Log/LogLevel.phpH  1fH  u      3   vendor/psr/log/Psr/Log/Test/LoggerInterfaceTest.php_  1f_  
 .      *   vendor/psr/log/Psr/Log/Test/TestLogger.php  1f  0      )   vendor/psr/log/Psr/Log/Test/DummyTest.php
  1f
  4B      +   vendor/psr/log/Psr/Log/LoggerAwareTrait.php  1f        3   vendor/psr/log/Psr/Log/InvalidArgumentException.phpo   1fo   MWd      %   vendor/psr/log/Psr/Log/NullLogger.php  1f  ;      *   vendor/psr/log/Psr/Log/LoggerInterface.php1  1f1  M      &   vendor/psr/log/Psr/Log/LoggerTrait.php^
  1f^
  кڤ      )   vendor/psr/log/Psr/Log/AbstractLogger.php(  1f(  D         vendor/psr/log/composer.jsoni  1fi           vendor/monolog/monolog/LICENSE'  1f'        #   vendor/monolog/monolog/CHANGELOG.md  1f  3%          vendor/monolog/monolog/README.mdH  1fH  \      !   vendor/monolog/monolog/UPGRADE.md_  1f_  ƻ,      $   vendor/monolog/monolog/composer.json:
  1f:
  #*_      >   vendor/monolog/monolog/src/Monolog/Handler/SendGridHandler.phpY  1fY  o      @   vendor/monolog/monolog/src/Monolog/Handler/InsightOpsHandler.php  1f  7i      :   vendor/monolog/monolog/src/Monolog/Handler/TestHandler.php  1f  a      ;   vendor/monolog/monolog/src/Monolog/Handler/IFTTTHandler.phpw  1fw  C      H   vendor/monolog/monolog/src/Monolog/Handler/WebRequestRecognizerTrait.php  1f  zP      <   vendor/monolog/monolog/src/Monolog/Handler/SocketHandler.php/  1f/  \6      C   vendor/monolog/monolog/src/Monolog/Handler/SymfonyMailerHandler.phpA  1fA  [oˤ      :   vendor/monolog/monolog/src/Monolog/Handler/NoopHandler.php  1f  >u'      <   vendor/monolog/monolog/src/Monolog/Handler/BufferHandler.php`  1f`  l      <   vendor/monolog/monolog/src/Monolog/Handler/SyslogHandler.php  1f  \=/      =   vendor/monolog/monolog/src/Monolog/Handler/RollbarHandler.php  1f  
ä      D   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.php!  1f!  Y      >   vendor/monolog/monolog/src/Monolog/Handler/OverflowHandler.phpy  1fy  KY      =   vendor/monolog/monolog/src/Monolog/Handler/HandlerWrapper.phpB
  1fB
  T+"      Y   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php  1f  fj      Z   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.phpy  1fy  1      \   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ChannelLevelActivationStrategy.php	  1f	  G/      ;   vendor/monolog/monolog/src/Monolog/Handler/GroupHandler.php  1f        C   vendor/monolog/monolog/src/Monolog/Handler/ElasticsearchHandler.php  1f  4|      >   vendor/monolog/monolog/src/Monolog/Handler/SamplingHandler.php  1f  Fפ      6   vendor/monolog/monolog/src/Monolog/Handler/Handler.php  1f  5(      >   vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php
  1f
  .Ƥ      A   vendor/monolog/monolog/src/Monolog/Handler/SwiftMailerHandler.php  1f  擝      >   vendor/monolog/monolog/src/Monolog/Handler/FlowdockHandler.php
  1f
  ec9      >   vendor/monolog/monolog/src/Monolog/Handler/PushoverHandler.php  1f  <N\      J   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php  1f  &ک      H   vendor/monolog/monolog/src/Monolog/Handler/MissingExtensionException.php  1f   
l      D   vendor/monolog/monolog/src/Monolog/Handler/AbstractSyslogHandler.php
  1f
  Ax      ?   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdpHandler.phpP  1fP  n*      D   vendor/monolog/monolog/src/Monolog/Handler/BrowserConsoleHandler.php$  1f$  %b3      <   vendor/monolog/monolog/src/Monolog/Handler/FilterHandler.php#  1f#  ޛ      9   vendor/monolog/monolog/src/Monolog/Handler/SqsHandler.php  1f  -kA      B   vendor/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php+  1f+  }|      C   vendor/monolog/monolog/src/Monolog/Handler/FallbackGroupHandler.php  1f  JY      B   vendor/monolog/monolog/src/Monolog/Handler/NativeMailerHandler.php  1f  6      =   vendor/monolog/monolog/src/Monolog/Handler/MongoDBHandler.php?
  1f?
  5(ۤ      =   vendor/monolog/monolog/src/Monolog/Handler/ProcessHandler.phpC  1fC  Vʤ      F   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php+  1f+  >G/      :   vendor/monolog/monolog/src/Monolog/Handler/GelfHandler.php  1f        A   vendor/monolog/monolog/src/Monolog/Handler/ZendMonitorHandler.php+  1f+  IPR      @   vendor/monolog/monolog/src/Monolog/Handler/PHPConsoleHandler.php)  1f)  %      >   vendor/monolog/monolog/src/Monolog/Handler/ErrorLogHandler.phpK
  1fK
  ?&      @   vendor/monolog/monolog/src/Monolog/Handler/LogEntriesHandler.php  1f  [eD      >   vendor/monolog/monolog/src/Monolog/Handler/LogmaticHandler.php
  1f
  0!Ƥ      C   vendor/monolog/monolog/src/Monolog/Handler/DeduplicationHandler.php  1f  .X      =   vendor/monolog/monolog/src/Monolog/Handler/FirePHPHandler.php  1f  	K      8   vendor/monolog/monolog/src/Monolog/Handler/Curl/Util.phpA  1fA  z      E   vendor/monolog/monolog/src/Monolog/Handler/DoctrineCouchDBHandler.php  1f  ;uĤ      >   vendor/monolog/monolog/src/Monolog/Handler/DynamoDbHandler.php	  1f	  u      J   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.phpk  1fk  0Ѥ      A   vendor/monolog/monolog/src/Monolog/Handler/RedisPubSubHandler.phpa  1fa  C^a      :   vendor/monolog/monolog/src/Monolog/Handler/MailHandler.phpO	  1fO	  j      <   vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php  1f  %d      <   vendor/monolog/monolog/src/Monolog/Handler/LogglyHandler.php?  1f?  G<      B   vendor/monolog/monolog/src/Monolog/Handler/SlackWebhookHandler.php  1f  Rj      >   vendor/monolog/monolog/src/Monolog/Handler/ElasticaHandler.php
  1f
  r<      F   vendor/monolog/monolog/src/Monolog/Handler/WhatFailureGroupHandler.php  1f  NBJ      ?   vendor/monolog/monolog/src/Monolog/Handler/ChromePHPHandler.php9  1f9  ;      @   vendor/monolog/monolog/src/Monolog/Handler/Slack/SlackRecord.php'  1f'  e]      9   vendor/monolog/monolog/src/Monolog/Handler/PsrHandler.php	  1f	  K삤      >   vendor/monolog/monolog/src/Monolog/Handler/NewRelicHandler.phpa  1fa  !      F   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php  1f        ?   vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php  1f  ԍ&      ;   vendor/monolog/monolog/src/Monolog/Handler/SlackHandler.phpk  1fk  $D      ?   vendor/monolog/monolog/src/Monolog/Handler/FleepHookHandler.php
  1f
  9%       :   vendor/monolog/monolog/src/Monolog/Handler/NullHandler.phpd  1fd  P6      :   vendor/monolog/monolog/src/Monolog/Handler/AmqpHandler.php)  1f)   <      A   vendor/monolog/monolog/src/Monolog/Handler/TelegramBotHandler.php   1f   i]      >   vendor/monolog/monolog/src/Monolog/Handler/MandrillHandler.php	  1f	  k      H   vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php  1f  <      =   vendor/monolog/monolog/src/Monolog/Handler/CouchDBHandler.php  1f  `7      ;   vendor/monolog/monolog/src/Monolog/Handler/RedisHandler.php  1f  )      :   vendor/monolog/monolog/src/Monolog/Handler/CubeHandler.php  1f  ݢŤ      B   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdp/UdpSocket.php  1f  %      -   vendor/monolog/monolog/src/Monolog/Logger.phpBX  1fBX  4"I      C   vendor/monolog/monolog/src/Monolog/Attribute/AsMonologProcessor.php  1f  _ʏ      8   vendor/monolog/monolog/src/Monolog/DateTimeImmutable.php  1f  㻤      4   vendor/monolog/monolog/src/Monolog/Test/TestCase.php  1f  b#E>      /   vendor/monolog/monolog/src/Monolog/Registry.php  1f  gä      B   vendor/monolog/monolog/src/Monolog/Processor/HostnameProcessor.php  1f  3Y      G   vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.php  1f  cä      =   vendor/monolog/monolog/src/Monolog/Processor/WebProcessor.php
  1f
  *3>      I   vendor/monolog/monolog/src/Monolog/Processor/MemoryPeakUsageProcessor.phpR  1fR  @      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessIdProcessor.phpo  1fo  Ф      C   vendor/monolog/monolog/src/Monolog/Processor/MercurialProcessor.phpb  1fb  9Ť      =   vendor/monolog/monolog/src/Monolog/Processor/TagProcessor.phpn  1fn  커      =   vendor/monolog/monolog/src/Monolog/Processor/GitProcessor.php  1f  
2      @   vendor/monolog/monolog/src/Monolog/Processor/MemoryProcessor.php5  1f5  y[*      G   vendor/monolog/monolog/src/Monolog/Processor/IntrospectionProcessor.php  1f  ֱ      =   vendor/monolog/monolog/src/Monolog/Processor/UidProcessor.php7  1f7  `      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php  1f  L      E   vendor/monolog/monolog/src/Monolog/Processor/MemoryUsageProcessor.php?  1f?  9٤      :   vendor/monolog/monolog/src/Monolog/ResettableInterface.php  1f  I{      4   vendor/monolog/monolog/src/Monolog/SignalHandler.php  1f  r.      B   vendor/monolog/monolog/src/Monolog/Formatter/LogmaticFormatter.php  1f  ʓh#      B   vendor/monolog/monolog/src/Monolog/Formatter/ElasticaFormatter.php1  1f1  قȤ      >   vendor/monolog/monolog/src/Monolog/Formatter/LineFormatter.phpL  1fL  ~:      >   vendor/monolog/monolog/src/Monolog/Formatter/JsonFormatter.php  1f  Fɤ      B   vendor/monolog/monolog/src/Monolog/Formatter/FlowdockFormatter.php	  1f	  Ϭ}      C   vendor/monolog/monolog/src/Monolog/Formatter/FormatterInterface.php  1f  =c      B   vendor/monolog/monolog/src/Monolog/Formatter/LogstashFormatter.php&
  1f&
  P      @   vendor/monolog/monolog/src/Monolog/Formatter/LogglyFormatter.php'  1f'  lN      G   vendor/monolog/monolog/src/Monolog/Formatter/ElasticsearchFormatter.phpM  1fM  Jl      @   vendor/monolog/monolog/src/Monolog/Formatter/ScalarFormatter.php  1f  m"o      A   vendor/monolog/monolog/src/Monolog/Formatter/MongoDBFormatter.php   1f   y      C   vendor/monolog/monolog/src/Monolog/Formatter/ChromePHPFormatter.php  1f  `2Q      A   vendor/monolog/monolog/src/Monolog/Formatter/FluentdFormatter.php  1f  5X      E   vendor/monolog/monolog/src/Monolog/Formatter/GelfMessageFormatter.php  1f  N      B   vendor/monolog/monolog/src/Monolog/Formatter/WildfireFormatter.php}  1f}  ֻˤ      L   vendor/monolog/monolog/src/Monolog/Formatter/GoogleCloudLoggingFormatter.php  1f        D   vendor/monolog/monolog/src/Monolog/Formatter/NormalizerFormatter.php$   1f$   vä      >   vendor/monolog/monolog/src/Monolog/Formatter/HtmlFormatter.php  1f  ٨פ      0   vendor/monolog/monolog/src/Monolog/LogRecord.php  1f  b	9      3   vendor/monolog/monolog/src/Monolog/ErrorHandler.php9)  1f9)  @L      ,   vendor/monolog/monolog/src/Monolog/Utils.php %  1f %  Fk      !   vendor/studio24/rotate/LICENSE.md>  1f>  3ä      "   vendor/studio24/rotate/phpunit.xml   1f   gE          vendor/studio24/rotate/README.md  1f  ?/      $   vendor/studio24/rotate/composer.json  1f  WѤ      .   vendor/studio24/rotate/src/RotateException.php_   1f_    ;      %   vendor/studio24/rotate/src/Rotate.php#  1f#  j      -   vendor/studio24/rotate/src/FilenameFormat.php  1f  =D      -   vendor/studio24/rotate/src/RotateAbstract.php  1f  D      6   vendor/studio24/rotate/src/FilenameFormatException.phpg   1fg   ܙ      %   vendor/studio24/rotate/src/Delete.php|#  1f|#  ؤ      0   vendor/studio24/rotate/src/DirectoryIterator.phpk  1fk  mA      G   vendor/symfony/framework-bundle/DataCollector/AbstractDataCollector.php#  1f#  N      E   vendor/symfony/framework-bundle/DataCollector/RouterDataCollector.php5  1f5  g      U   vendor/symfony/framework-bundle/DataCollector/TemplateAwareDataCollectorInterface.phpU  1fU  ~suܤ      '   vendor/symfony/framework-bundle/LICENSE,  1f,  U      7   vendor/symfony/framework-bundle/Test/KernelTestCase.phpt  1ft  b0      B   vendor/symfony/framework-bundle/Test/DomCrawlerAssertionsTrait.php  1f  X,      >   vendor/symfony/framework-bundle/Test/MailerAssertionsTrait.php  1f  Ѕ>I      B   vendor/symfony/framework-bundle/Test/BrowserKitAssertionsTrait.php   1f   '6      9   vendor/symfony/framework-bundle/Test/TestBrowserToken.phpq  1fq  E      4   vendor/symfony/framework-bundle/Test/WebTestCase.php  1f        ?   vendor/symfony/framework-bundle/Test/WebTestAssertionsTrait.php  1f  jo      6   vendor/symfony/framework-bundle/Test/TestContainer.php  1f  C      ,   vendor/symfony/framework-bundle/CHANGELOG.md1}  1f1}  $      :   vendor/symfony/framework-bundle/Translation/Translator.php)  1f)  &_      7   vendor/symfony/framework-bundle/Secrets/SodiumVault.php#  1f#  B[z      7   vendor/symfony/framework-bundle/Secrets/DotenvVault.phpA  1fA  Ȟ      9   vendor/symfony/framework-bundle/Secrets/AbstractVault.php  1f  ,s>U      I   vendor/symfony/framework-bundle/Resources/bin/check-unused-known-tags.php  1f  1      8   vendor/symfony/framework-bundle/Resources/config/esi.php  1f        @   vendor/symfony/framework-bundle/Resources/config/translation.php  1f   =դ      ?   vendor/symfony/framework-bundle/Resources/config/serializer.php %  1f %  w¤      ?   vendor/symfony/framework-bundle/Resources/config/form_debug.php  1f  "      >   vendor/symfony/framework-bundle/Resources/config/validator.php
  1f
  ;      @   vendor/symfony/framework-bundle/Resources/config/annotations.phpw
  1fw
  u]      >   vendor/symfony/framework-bundle/Resources/config/profiling.php  1f  +$      ;   vendor/symfony/framework-bundle/Resources/config/mailer.php
  1f
  "R      F   vendor/symfony/framework-bundle/Resources/config/fragment_listener.phpw  1fw  Vg      F   vendor/symfony/framework-bundle/Resources/config/translation_debug.php  1f  $      C   vendor/symfony/framework-bundle/Resources/config/notifier_debug.php  1f  /T_2      A   vendor/symfony/framework-bundle/Resources/config/rate_limiter.php  1f  |s      9   vendor/symfony/framework-bundle/Resources/config/lock.php  1f  z      H   vendor/symfony/framework-bundle/Resources/config/identity_translator.php!  1f!        @   vendor/symfony/framework-bundle/Resources/config/http_client.php  1f  ,      A   vendor/symfony/framework-bundle/Resources/config/mailer_debug.php  1f  `܄       =   vendor/symfony/framework-bundle/Resources/config/services.php  1f  <Ƥ      :   vendor/symfony/framework-bundle/Resources/config/cache.php~   1f~   Kg      <   vendor/symfony/framework-bundle/Resources/config/session.php>  1f>  ~*      F   vendor/symfony/framework-bundle/Resources/config/mailer_transports.php7  1f7  Щ      J   vendor/symfony/framework-bundle/Resources/config/translation_providers.php1  1f1  ܩ      :   vendor/symfony/framework-bundle/Resources/config/debug.php  1f  "5V      F   vendor/symfony/framework-bundle/Resources/config/fragment_renderer.php	  1f	         =   vendor/symfony/framework-bundle/Resources/config/web_link.phpW  1fW  
      <   vendor/symfony/framework-bundle/Resources/config/routing.php  1f  D*s      G   vendor/symfony/framework-bundle/Resources/config/schema/symfony-1.0.xsdX  1fX  f0ߤ      =   vendor/symfony/framework-bundle/Resources/config/notifier.phpA  1fA  IA      F   vendor/symfony/framework-bundle/Resources/config/http_client_debug.php  1f  "5$      <   vendor/symfony/framework-bundle/Resources/config/request.php  1f  kP?      9   vendor/symfony/framework-bundle/Resources/config/test.php  1f  ȧ      D   vendor/symfony/framework-bundle/Resources/config/validator_debug.php  1f  GU      C   vendor/symfony/framework-bundle/Resources/config/error_renderer.php/  1f/        >   vendor/symfony/framework-bundle/Resources/config/mime_type.php  1f  H̤      >   vendor/symfony/framework-bundle/Resources/config/messenger.php  1f  PX      <   vendor/symfony/framework-bundle/Resources/config/console.phpN,  1fN,  .=ߤ      8   vendor/symfony/framework-bundle/Resources/config/uid.php=  1f=  S      B   vendor/symfony/framework-bundle/Resources/config/property_info.php	  1f	  j      8   vendor/symfony/framework-bundle/Resources/config/ssi.php  1f  5{      8   vendor/symfony/framework-bundle/Resources/config/web.php  1f  ]|      D   vendor/symfony/framework-bundle/Resources/config/messenger_debug.php  1f  o灤      ?   vendor/symfony/framework-bundle/Resources/config/collectors.phpM  1fM  %fB      C   vendor/symfony/framework-bundle/Resources/config/routing/errors.xml  1f  >      <   vendor/symfony/framework-bundle/Resources/config/secrets.php  1f  *n      9   vendor/symfony/framework-bundle/Resources/config/form.php  1f  `      >   vendor/symfony/framework-bundle/Resources/config/form_csrf.phpD  1fD  A3U      =   vendor/symfony/framework-bundle/Resources/config/workflow.php  1f  V/      B   vendor/symfony/framework-bundle/Resources/config/security_csrf.php}  1f}  jnk      H   vendor/symfony/framework-bundle/Resources/config/notifier_transports.php9  1f9        ?   vendor/symfony/framework-bundle/Resources/config/debug_prod.php  1f  U      D   vendor/symfony/framework-bundle/Resources/config/property_access.php  1f  Bʤ      ;   vendor/symfony/framework-bundle/Resources/config/assets.phpl
  1fl
  Cd|<      @   vendor/symfony/framework-bundle/Resources/config/cache_debug.php  1f  %]      1   vendor/symfony/framework-bundle/KernelBrowser.php  1f  rI馤      D   vendor/symfony/framework-bundle/CacheWarmer/ValidatorCacheWarmer.php
  1f
  W      H   vendor/symfony/framework-bundle/CacheWarmer/ConfigBuilderCacheWarmer.php&  1f&  3%      J   vendor/symfony/framework-bundle/CacheWarmer/AbstractPhpFileCacheWarmer.php
  1f
        A   vendor/symfony/framework-bundle/CacheWarmer/RouterCacheWarmer.php8  1f8        G   vendor/symfony/framework-bundle/CacheWarmer/TranslationsCacheWarmer.php  1f  A      E   vendor/symfony/framework-bundle/CacheWarmer/SerializerCacheWarmer.php!  1f!  e{      K   vendor/symfony/framework-bundle/CacheWarmer/CachePoolClearerCacheWarmer.php  1f  	#A
      F   vendor/symfony/framework-bundle/CacheWarmer/AnnotationsCacheWarmer.php<  1f<  OY      A   vendor/symfony/framework-bundle/Controller/AbstractController.phpJ  1fJ  og0      A   vendor/symfony/framework-bundle/Controller/TemplateController.php  1f  hu      A   vendor/symfony/framework-bundle/Controller/ControllerResolver.phpG  1fG  ,uߤ      A   vendor/symfony/framework-bundle/Controller/RedirectController.phpn  1fn  hs>      )   vendor/symfony/framework-bundle/README.md  1f  ^)J      7   vendor/symfony/framework-bundle/HttpCache/HttpCache.php
  1f
  @.F      3   vendor/symfony/framework-bundle/FrameworkBundle.phpI-  1fI-        >   vendor/symfony/framework-bundle/Command/SecretsListCommand.php
  1f
  _      @   vendor/symfony/framework-bundle/Command/SecretsRemoveCommand.php7
  1f7
  C      =   vendor/symfony/framework-bundle/Command/CacheClearCommand.php5'  1f5'   ~US      <   vendor/symfony/framework-bundle/Command/XliffLintCommand.php  1f  J L0      H   vendor/symfony/framework-bundle/Command/SecretsDecryptToLocalCommand.php  1f  9      A   vendor/symfony/framework-bundle/Command/AbstractConfigCommand.php  1f  p      >   vendor/symfony/framework-bundle/Command/RouterDebugCommand.php  1f  h      D   vendor/symfony/framework-bundle/Command/TranslationUpdateCommand.phpsH  1fsH  ym      F   vendor/symfony/framework-bundle/Command/ConfigDumpReferenceCommand.php  1f  kzE      @   vendor/symfony/framework-bundle/Command/AssetsInstallCommand.php(  1f(  q8      A   vendor/symfony/framework-bundle/Command/CachePoolPruneCommand.php  1f  }=      A   vendor/symfony/framework-bundle/Command/CachePoolClearCommand.php  1f  ͉f      @   vendor/symfony/framework-bundle/Command/ContainerLintCommand.phpP  1fP  KA      J   vendor/symfony/framework-bundle/Command/SecretsEncryptFromLocalCommand.php  1f  #E      B   vendor/symfony/framework-bundle/Command/DebugAutowiringCommand.php  1f  j%      >   vendor/symfony/framework-bundle/Command/CacheWarmupCommand.php\  1f\  hӗ      ?   vendor/symfony/framework-bundle/Command/WorkflowDumpCommand.php  1f  }[      G   vendor/symfony/framework-bundle/Command/EventDispatcherDebugCommand.phph  1fh  /      A   vendor/symfony/framework-bundle/Command/ContainerDebugCommand.php12  1f12  #      C   vendor/symfony/framework-bundle/Command/TranslationDebugCommand.phpN<  1fN<  5      ;   vendor/symfony/framework-bundle/Command/YamlLintCommand.php<  1f<  =      @   vendor/symfony/framework-bundle/Command/CachePoolListCommand.phpI  1fI  z      F   vendor/symfony/framework-bundle/Command/SecretsGenerateKeysCommand.phpr  1fr  N      B   vendor/symfony/framework-bundle/Command/CachePoolDeleteCommand.php  1f  ]nM      D   vendor/symfony/framework-bundle/Command/BuildDebugContainerTrait.phpL
  1fL
  )Hf      8   vendor/symfony/framework-bundle/Command/AboutCommand.php  1f  ]      >   vendor/symfony/framework-bundle/Command/RouterMatchCommand.phpE  1fE  m`      =   vendor/symfony/framework-bundle/Command/SecretsSetCommand.php  1f  I.Ҥ      >   vendor/symfony/framework-bundle/Command/ConfigDebugCommand.php`!  1f`!  oK*      J   vendor/symfony/framework-bundle/Routing/RedirectableCompiledUrlMatcher.phpF  1fF        @   vendor/symfony/framework-bundle/Routing/RouteLoaderInterface.php  1f  b       2   vendor/symfony/framework-bundle/Routing/Router.php  1f  .      <   vendor/symfony/framework-bundle/Routing/DelegatingLoader.php
  1f
  Fޤ      J   vendor/symfony/framework-bundle/Routing/AnnotatedRouteControllerLoader.php  1f  @      E   vendor/symfony/framework-bundle/DependencyInjection/Configuration.php  1f  ބ      J   vendor/symfony/framework-bundle/DependencyInjection/FrameworkExtension.php  1f  Қ      ^   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ContainerBuilderDebugDumpPass.php  1f  br      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerRealRefPass.phpm  1fm  V      c   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.php  1f  \\b      O   vendor/symfony/framework-bundle/DependencyInjection/Compiler/UnusedTagsPass.phpM  1fM  Zt      R   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AssetsContextPass.php  1f  Ƅ      X   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ErrorLoggerCompilerPass.php  1f  7      Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/WorkflowGuardListenerPass.php  1f  f      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerWeakRefPass.php  1f  P      V   vendor/symfony/framework-bundle/DependencyInjection/Compiler/LoggingTranslatorPass.php	  1f	  R      L   vendor/symfony/framework-bundle/DependencyInjection/Compiler/SessionPass.php  1f  3	      \   vendor/symfony/framework-bundle/DependencyInjection/Compiler/DataCollectorTranslatorPass.php  1f  ל      _   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddAnnotationsCachedReaderPass.php  1f  4FcԤ      M   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ProfilerPass.php	  1f	  2ɤ      j   vendor/symfony/framework-bundle/DependencyInjection/Compiler/RemoveUnusedSessionMarshallingHandlerPass.php  1f  _n      Y   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddDebugLogProcessorPass.php  1f   &Ƥ      -   vendor/symfony/framework-bundle/composer.jsonj  1fj        ;   vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.php"  1f"  E      7   vendor/symfony/framework-bundle/Console/Application.phpB  1fB  򚬤      E   vendor/symfony/framework-bundle/Console/Descriptor/TextDescriptor.phpjf  1fjf  jͤ      D   vendor/symfony/framework-bundle/Console/Descriptor/XmlDescriptor.phpa  1fa  D6¤      A   vendor/symfony/framework-bundle/Console/Descriptor/Descriptor.phpQ3  1fQ3  O      E   vendor/symfony/framework-bundle/Console/Descriptor/JsonDescriptor.php<  1f<  M1      I   vendor/symfony/framework-bundle/Console/Descriptor/MarkdownDescriptor.phpB  1fB  -      C   vendor/symfony/framework-bundle/Console/Helper/DescriptorHelper.php  1f  p      Q   vendor/symfony/framework-bundle/EventListener/SuggestMissingPackageSubscriber.php
  1f
  cT      A   vendor/symfony/framework-bundle/Session/ServiceSessionFactory.php  1f   pUۤ      D   vendor/symfony/framework-bundle/Session/DeprecatedSessionFactory.php4  1f4  MU      %   vendor/symfony/monolog-bundle/LICENSE)  1f)  Ǥ      *   vendor/symfony/monolog-bundle/CHANGELOG.md  1f  :L      :   vendor/symfony/monolog-bundle/Resources/config/monolog.xml.  1f.   0yK      E   vendor/symfony/monolog-bundle/Resources/config/schema/monolog-1.0.xsd'  1f'  )X      <   vendor/symfony/monolog-bundle/SwiftMailer/MessageFactory.php  1f        '   vendor/symfony/monolog-bundle/README.mdY  1fY        /   vendor/symfony/monolog-bundle/MonologBundle.php  1f  @g      F   vendor/symfony/monolog-bundle/DependencyInjection/MonologExtension.phpi  1fi  ve      C   vendor/symfony/monolog-bundle/DependencyInjection/Configuration.php  1f  vr      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddProcessorsPass.php  1f  R      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/LoggerChannelPass.php  1f        O   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/DebugHandlerPass.php
  1f
  HS      Q   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/FixEmptyLoggerPass.php  1f  DN      Z   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddSwiftMailerTransportPass.php  1f   *Q      +   vendor/symfony/monolog-bundle/composer.json  1f  Ǉ      %   vendor/symfony/polyfill-php73/LICENSE,  1f,        '   vendor/symfony/polyfill-php73/Php73.phps  1fs  D\      ?   vendor/symfony/polyfill-php73/Resources/stubs/JsonException.phpE  1fE  8S      +   vendor/symfony/polyfill-php73/bootstrap.php  1f  |      '   vendor/symfony/polyfill-php73/README.md/  1f/  m      +   vendor/symfony/polyfill-php73/composer.json  1f  =Ǥ      *   vendor/symfony/polyfill-php80/PhpToken.php  1f  s`      %   vendor/symfony/polyfill-php80/LICENSE,  1f,  K      :   vendor/symfony/polyfill-php80/Resources/stubs/PhpToken.phpw  1fw  =7T8      <   vendor/symfony/polyfill-php80/Resources/stubs/ValueError.php>  1f>  g      ;   vendor/symfony/polyfill-php80/Resources/stubs/Attribute.php  1f  MK<      E   vendor/symfony/polyfill-php80/Resources/stubs/UnhandledMatchError.phpG  1fG  ֈ+      <   vendor/symfony/polyfill-php80/Resources/stubs/Stringable.php  1f  t]\ڤ      +   vendor/symfony/polyfill-php80/bootstrap.php  1f  .Ĥ      '   vendor/symfony/polyfill-php80/README.md  1f  "tF      '   vendor/symfony/polyfill-php80/Php80.php  1f  H      +   vendor/symfony/polyfill-php80/composer.jsonb  1fb         7   vendor/symfony/monolog-bridge/Handler/MailerHandler.php  1f  wI      8   vendor/symfony/monolog-bridge/Handler/ConsoleHandler.phpf  1ff         S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php  1f  E      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/NotFoundActivationStrategy.php  1f  A      <   vendor/symfony/monolog-bridge/Handler/SwiftMailerHandler.php	  1f	  Yl8      :   vendor/symfony/monolog-bridge/Handler/ServerLogHandler.phpm  1fm  W!      9   vendor/symfony/monolog-bridge/Handler/NotifierHandler.php^	  1f^	  `Zj      8   vendor/symfony/monolog-bridge/Handler/FirePHPHandler.php  1f  AĬ      :   vendor/symfony/monolog-bridge/Handler/ChromePhpHandler.phpY  1fY        F   vendor/symfony/monolog-bridge/Handler/ElasticsearchLogstashHandler.php  1f  h      (   vendor/symfony/monolog-bridge/Logger.php	  1f	  ,	I      %   vendor/symfony/monolog-bridge/LICENSE,  1f,  U      *   vendor/symfony/monolog-bridge/CHANGELOG.md
  1f
  Ez      :   vendor/symfony/monolog-bridge/Processor/TokenProcessor.phpg  1fg  V      D   vendor/symfony/monolog-bridge/Processor/SwitchUserTokenProcessor.php$  1f$  xsz      8   vendor/symfony/monolog-bridge/Processor/WebProcessor.php  1f  \OL      :   vendor/symfony/monolog-bridge/Processor/RouteProcessor.php-	  1f-	  pF7      C   vendor/symfony/monolog-bridge/Processor/ConsoleCommandProcessor.phpn  1fn  
K      B   vendor/symfony/monolog-bridge/Processor/AbstractTokenProcessor.php4  1f4  2uƤ      :   vendor/symfony/monolog-bridge/Processor/DebugProcessor.php  1f  
f      '   vendor/symfony/monolog-bridge/README.md  1f  =~      <   vendor/symfony/monolog-bridge/Formatter/ConsoleFormatter.php  1f  =      >   vendor/symfony/monolog-bridge/Formatter/VarDumperFormatter.php  1f  -[֞      H   vendor/symfony/monolog-bridge/Messenger/ResetLoggersWorkerSubscriber.php_  1f_  #wd      :   vendor/symfony/monolog-bridge/Command/ServerLogCommand.phpv  1fv  [,      +   vendor/symfony/monolog-bridge/composer.json:  1f:  o2      9   vendor/symfony/cache/DataCollector/CacheDataCollector.php  1f  z      "   vendor/symfony/cache/CacheItem.php2  1f2  8r      #   vendor/symfony/cache/Psr16Cache.php
"  1f
"  mNt         vendor/symfony/cache/LICENSE,  1f,  X      +   vendor/symfony/cache/PruneableInterface.php  1f  U      !   vendor/symfony/cache/CHANGELOG.md  1f  OF.      5   vendor/symfony/cache/Traits/RedisClusterNodeProxy.phpX  1fX  X      *   vendor/symfony/cache/Traits/RedisTrait.phpip  1fip  *<      *   vendor/symfony/cache/Traits/ProxyTrait.phpZ  1fZ  nq      5   vendor/symfony/cache/Traits/FilesystemCommonTrait.phpd  1fd  5      1   vendor/symfony/cache/Traits/RedisClusterProxy.php  1f  Pv      *   vendor/symfony/cache/Traits/RedisProxy.php,  1f,  kp      .   vendor/symfony/cache/Traits/ContractsTrait.phpi  1fi  G      /   vendor/symfony/cache/Traits/FilesystemTrait.php  1f  C      4   vendor/symfony/cache/Traits/AbstractAdapterTrait.php1  1f1  v      )   vendor/symfony/cache/DoctrineProvider.php
  1f
  ;w      -   vendor/symfony/cache/Adapter/ProxyAdapter.php:!  1f:!  hHФ      ,   vendor/symfony/cache/Adapter/ApcuAdapter.php  1f  >i:      ;   vendor/symfony/cache/Adapter/CouchbaseCollectionAdapter.phpq  1fq  P      1   vendor/symfony/cache/Adapter/TraceableAdapter.php|  1f|  Vt      +   vendor/symfony/cache/Adapter/PdoAdapter.phpT  1fT  .:      -   vendor/symfony/cache/Adapter/ArrayAdapter.php,  1f,  K      5   vendor/symfony/cache/Adapter/RedisTagAwareAdapter.php1  1f1  X5      7   vendor/symfony/cache/Adapter/CouchbaseBucketAdapter.phpT  1fT  ώ      ,   vendor/symfony/cache/Adapter/NullAdapter.php
  1f
  s      4   vendor/symfony/cache/Adapter/ParameterNormalizer.php  1f  oe      0   vendor/symfony/cache/Adapter/TagAwareAdapter.phpE,  1fE,  N      0   vendor/symfony/cache/Adapter/PhpFilesAdapter.php(  1f(  (]ˤ      4   vendor/symfony/cache/Adapter/DoctrineDbalAdapter.phpC  1fC  `V      9   vendor/symfony/cache/Adapter/TagAwareAdapterInterface.php  1f  :      1   vendor/symfony/cache/Adapter/MemcachedAdapter.php6  1f6         -   vendor/symfony/cache/Adapter/RedisAdapter.php  1f  eR!=      1   vendor/symfony/cache/Adapter/AdapterInterface.php
  1f
  ڑ      :   vendor/symfony/cache/Adapter/FilesystemTagAwareAdapter.phpH  1fH  !¤      9   vendor/symfony/cache/Adapter/TraceableTagAwareAdapter.php  1f  ;K      -   vendor/symfony/cache/Adapter/Psr16Adapter.php  1f   Ó      -   vendor/symfony/cache/Adapter/ChainAdapter.php$  1f$  -/      2   vendor/symfony/cache/Adapter/FilesystemAdapter.php  1f  (Acb      0   vendor/symfony/cache/Adapter/DoctrineAdapter.php*  1f*  t      0   vendor/symfony/cache/Adapter/AbstractAdapter.phpz!  1fz!  >֤      8   vendor/symfony/cache/Adapter/AbstractTagAwareAdapter.php?2  1f?2  Jx|      0   vendor/symfony/cache/Adapter/PhpArrayAdapter.php1  1f1  ;դ      %   vendor/symfony/cache/LockRegistry.php@  1f@  B'      ,   vendor/symfony/cache/ResettableInterface.php  1f  NR         vendor/symfony/cache/README.md  1f  `t:      9   vendor/symfony/cache/Messenger/EarlyExpirationHandler.php	  1f	  I4t      9   vendor/symfony/cache/Messenger/EarlyExpirationMessage.php[
  1f[
  g#      <   vendor/symfony/cache/Messenger/EarlyExpirationDispatcher.phpf	  1ff	  yOK      5   vendor/symfony/cache/Marshaller/DefaultMarshaller.php  1f  }ȵ      5   vendor/symfony/cache/Marshaller/DeflateMarshaller.php  1f  UIf      7   vendor/symfony/cache/Marshaller/MarshallerInterface.phpG  1fG  |ѷ      6   vendor/symfony/cache/Marshaller/TagAwareMarshaller.php%  1f%  =	Ԥ      4   vendor/symfony/cache/Marshaller/SodiumMarshaller.php	  1f	  6      :   vendor/symfony/cache/DependencyInjection/CachePoolPass.phpy-  1fy-  O      @   vendor/symfony/cache/DependencyInjection/CachePoolPrunerPass.php  1f  '      ?   vendor/symfony/cache/DependencyInjection/CacheCollectorPass.php  1f        A   vendor/symfony/cache/DependencyInjection/CachePoolClearerPass.phpN  1fN  jc      1   vendor/symfony/cache/Exception/LogicException.php  1f  9d      ;   vendor/symfony/cache/Exception/InvalidArgumentException.php  1f  j      1   vendor/symfony/cache/Exception/CacheException.php  1f  Q4      "   vendor/symfony/cache/composer.json  1f  $      -   vendor/symfony/polyfill-ctype/bootstrap80.phpr  1fr  F)      %   vendor/symfony/polyfill-ctype/LICENSE,  1f,        +   vendor/symfony/polyfill-ctype/bootstrap.php@  1f@  jQ9      '   vendor/symfony/polyfill-ctype/README.md^  1f^  lHk      '   vendor/symfony/polyfill-ctype/Ctype.php  1f   /      +   vendor/symfony/polyfill-ctype/composer.json  1f  ӹ      %   vendor/symfony/polyfill-php81/LICENSE,  1f,  0      F   vendor/symfony/polyfill-php81/Resources/stubs/ReturnTypeWillChange.php  1f  5+      @   vendor/symfony/polyfill-php81/Resources/stubs/CURLStringFile.php  1f  JT      +   vendor/symfony/polyfill-php81/bootstrap.php  1f  <P      '   vendor/symfony/polyfill-php81/README.md  1f        '   vendor/symfony/polyfill-php81/Php81.php  1f  3E      +   vendor/symfony/polyfill-php81/composer.json  1f  0      F   vendor/symfony/security-bundle/DataCollector/SecurityDataCollector.php$6  1f$6  B.6      &   vendor/symfony/security-bundle/LICENSE,  1f,  U      +   vendor/symfony/security-bundle/CHANGELOG.md6  1f6  @E      G   vendor/symfony/security-bundle/Security/LegacyLogoutHandlerListener.php,  1f,  i      ?   vendor/symfony/security-bundle/Security/LazyFirewallContext.php	  1f	  
ä      =   vendor/symfony/security-bundle/Security/UserAuthenticator.phpc  1fc  1      ;   vendor/symfony/security-bundle/Security/FirewallContext.phpk  1fk  (RS      7   vendor/symfony/security-bundle/Security/FirewallMap.php8	  1f8	   &      :   vendor/symfony/security-bundle/Security/FirewallConfig.php@  1f@  ;_      >   vendor/symfony/security-bundle/Security/FirewallAwareTrait.php  1f  MA      C   vendor/symfony/security-bundle/Resources/config/templating_twig.php  1f  @']      F   vendor/symfony/security-bundle/Resources/config/security_listeners.php  1f  we      U   vendor/symfony/security-bundle/Resources/config/security_authenticator_login_link.php	  1f	  +      G   vendor/symfony/security-bundle/Resources/config/security_rememberme.php
  1f
        9   vendor/symfony/security-bundle/Resources/config/guard.php  1f  B{ˤ      C   vendor/symfony/security-bundle/Resources/config/security_legacy.phpq  1fq  )	      B   vendor/symfony/security-bundle/Resources/config/security_debug.php3  1f3  6!H!      A   vendor/symfony/security-bundle/Resources/config/debug_console.php   1f         G   vendor/symfony/security-bundle/Resources/config/schema/security-1.0.xsdQ  1fQ  a      ;   vendor/symfony/security-bundle/Resources/config/console.php  1f  ,g      C   vendor/symfony/security-bundle/Resources/config/password_hasher.php  1f  ް      >   vendor/symfony/security-bundle/Resources/config/collectors.php  1f  u|      J   vendor/symfony/security-bundle/Resources/config/security_authenticator.php.  1f.  ΘL      <   vendor/symfony/security-bundle/Resources/config/security.phpI-  1fI-  E      V   vendor/symfony/security-bundle/Resources/config/security_authenticator_remember_me.php8  1f8  \&+      A   vendor/symfony/security-bundle/Resources/views/Collector/icon.svg  1f  r      K   vendor/symfony/security-bundle/Resources/views/Collector/security.html.twig\  1f\  O\      D   vendor/symfony/security-bundle/CacheWarmer/ExpressionCacheWarmer.php3  1f3  ;Z3z      1   vendor/symfony/security-bundle/SecurityBundle.phpS  1fS  ?      (   vendor/symfony/security-bundle/README.md  1f  [A      H   vendor/symfony/security-bundle/RememberMe/DecoratedRememberMeHandler.php  1f  =/g      L   vendor/symfony/security-bundle/RememberMe/FirewallAwareRememberMeHandler.php@  1f@  G٤      ?   vendor/symfony/security-bundle/Command/DebugFirewallCommand.phpL$  1fL$  ;WĤ      E   vendor/symfony/security-bundle/Command/UserPasswordEncoderCommand.php  1f  
◪      J   vendor/symfony/security-bundle/LoginLink/FirewallAwareLoginLinkHandler.php  1f  ʤ      H   vendor/symfony/security-bundle/DependencyInjection/MainConfiguration.phpB  1fB  S      X   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/LdapFactory.phpV	  1fV	  J[      \   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/InMemoryFactory.php
  1f
  qv      i   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/UserProviderFactoryInterface.php  1f  @      b   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/GuardAuthenticationFactory.php  1f  ʖ      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginLinkFactory.php@  1f@  y      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicLdapFactory.php  1f  )\n      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginLdapFactory.phpE	  1fE	  b`դ      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginFactory.php  1f  UO      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginLdapFactory.php	  1f	  .      b   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/CustomAuthenticatorFactory.php  1f  R      `   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/SecurityFactoryInterface.phpL  1fL  aѤ      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RemoteUserFactory.phpM  1fM  1Ϥ      e   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AuthenticatorFactoryInterface.php  1f        Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RememberMeFactory.phpV?  1fV?  95      W   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AbstractFactory.php  1f  $<      S   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/X509Factory.php  1f  #S      h   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FirewallListenerFactoryInterface.phpq  1fq  !e      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AnonymousFactory.php"  1f"  5I      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginFactory.php  1f        X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicFactory.php>  1f>  yC٤      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LdapFactoryTrait.phpm	  1fm	  盤      ^   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginThrottlingFactory.php  1f  V      H   vendor/symfony/security-bundle/DependencyInjection/SecurityExtension.phpW  1fW  6_ؤ      b   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.phpe  1fe  8Ƥ      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterTokenUsageTrackingPass.phpd	  1fd	  πΤ      j   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterCsrfTokenClearingLogoutHandlerPass.php}  1f}  {      W   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterLdapLocatorPass.phpP  1fP  a5       h   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterGlobalSecurityEventListenersPass.php
  1f
  ϗ       Y   vendor/symfony/security-bundle/DependencyInjection/Compiler/SortFirewallListenersPass.php  1f  \Un      e   vendor/symfony/security-bundle/DependencyInjection/Compiler/ReplaceDecoratedRememberMeHandlerPass.php	  1f	  A      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSessionDomainConstraintPass.php  1f        U   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSecurityVotersPass.php
  1f
  q      V   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterEntryPointPass.php  1f  9paB      [   vendor/symfony/security-bundle/DependencyInjection/Compiler/CleanRememberMeVerifierPass.php  1f  L2i      X   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterCsrfFeaturesPass.phpp	  1fp	  e}      ,   vendor/symfony/security-bundle/composer.json#
  1f#
  K      B   vendor/symfony/security-bundle/Debug/TraceableFirewallListener.php  1f  A˖      8   vendor/symfony/security-bundle/Debug/WrappedListener.php  1f  (      ?   vendor/symfony/security-bundle/Debug/TraceableListenerTrait.php  1f        <   vendor/symfony/security-bundle/Debug/WrappedLazyListener.phpH  1fH  Ǫ`      A   vendor/symfony/security-bundle/EventListener/FirewallListener.php  1f  %      =   vendor/symfony/security-bundle/EventListener/VoteListener.phpo  1fo  g      4   vendor/symfony/config/ResourceCheckerConfigCache.php  1f  e{M         vendor/symfony/config/LICENSE,  1f,  U      '   vendor/symfony/config/Util/XmlUtils.php&  1f&  {o      <   vendor/symfony/config/Util/Exception/XmlParsingException.php  1f  䢗      <   vendor/symfony/config/Util/Exception/InvalidXmlException.php4  1f4        "   vendor/symfony/config/CHANGELOG.md  1f  QyȤ      .   vendor/symfony/config/ConfigCacheInterface.php  1f  O2      .   vendor/symfony/config/FileLocatorInterface.php?  1f?  ,c      %   vendor/symfony/config/ConfigCache.php  1f  ō      5   vendor/symfony/config/ConfigCacheFactoryInterface.php  1f  EizĤ      %   vendor/symfony/config/FileLocator.php	  1f	  2      2   vendor/symfony/config/ResourceCheckerInterface.php  1f  åؤ         vendor/symfony/config/README.mdT  1fT        '   vendor/symfony/config/Loader/Loader.php  1f  l      +   vendor/symfony/config/Loader/FileLoader.php  1f  
=Ol      2   vendor/symfony/config/Loader/ParamConfigurator.phpj  1fj  O3      0   vendor/symfony/config/Loader/LoaderInterface.php  1f  q7      8   vendor/symfony/config/Loader/LoaderResolverInterface.php  1f  o[ߤ      /   vendor/symfony/config/Loader/LoaderResolver.php  1f  YM      1   vendor/symfony/config/Loader/DelegatingLoader.php  1f  x9      /   vendor/symfony/config/Loader/GlobFileLoader.php  1f  .ο      .   vendor/symfony/config/Definition/FloatNode.php  1f  D      -   vendor/symfony/config/Definition/BaseNode.phpG?  1fG?  (`      0   vendor/symfony/config/Definition/NumericNode.php  1f  7      0   vendor/symfony/config/Definition/IntegerNode.phpv  1fv  H*      ;   vendor/symfony/config/Definition/PrototypeNodeInterface.phpU  1fU  bnB      8   vendor/symfony/config/Definition/PrototypedArrayNode.php|,  1f|,  &,      .   vendor/symfony/config/Definition/Processor.php
  1f
        2   vendor/symfony/config/Definition/NodeInterface.php	  1f	  m)Ȥ      -   vendor/symfony/config/Definition/EnumNode.php  1f  #¤      0   vendor/symfony/config/Definition/BooleanNode.php  1f  Mޤ      .   vendor/symfony/config/Definition/ArrayNode.php.  1f.  c٤      /   vendor/symfony/config/Definition/ScalarNode.php  1f  ݜͤ      ;   vendor/symfony/config/Definition/ConfigurationInterface.php  1f  _+      8   vendor/symfony/config/Definition/Builder/ExprBuilder.php  1f        ?   vendor/symfony/config/Definition/Builder/EnumNodeDefinition.php  1f  nŤ      9   vendor/symfony/config/Definition/Builder/MergeBuilder.php  1f  E#      B   vendor/symfony/config/Definition/Builder/NumericNodeDefinition.php  1f        8   vendor/symfony/config/Definition/Builder/NodeBuilder.php  1f  Q      C   vendor/symfony/config/Definition/Builder/VariableNodeDefinition.phpP  1fP  q      @   vendor/symfony/config/Definition/Builder/ArrayNodeDefinition.php>  1f>  #$      B   vendor/symfony/config/Definition/Builder/BuilderAwareInterface.phpQ  1fQ  Wج      >   vendor/symfony/config/Definition/Builder/ValidationBuilder.php  1f  "      8   vendor/symfony/config/Definition/Builder/TreeBuilder.php  1f  AJ      B   vendor/symfony/config/Definition/Builder/IntegerNodeDefinition.php-  1f-  ܩǤ      @   vendor/symfony/config/Definition/Builder/NodeParentInterface.php  1f  ʤ      A   vendor/symfony/config/Definition/Builder/NormalizationBuilder.php  1f  w      B   vendor/symfony/config/Definition/Builder/BooleanNodeDefinition.php4  1f4  ~֤      J   vendor/symfony/config/Definition/Builder/ParentNodeDefinitionInterface.php  1f  WG֤      A   vendor/symfony/config/Definition/Builder/ScalarNodeDefinition.php  1f  Bڤ      @   vendor/symfony/config/Definition/Builder/FloatNodeDefinition.php"  1f"  Uf+      ;   vendor/symfony/config/Definition/Builder/NodeDefinition.php"  1f"  6$      D   vendor/symfony/config/Definition/Exception/DuplicateKeyException.phpS  1fS  g      I   vendor/symfony/config/Definition/Exception/InvalidDefinitionException.php  1f  re      C   vendor/symfony/config/Definition/Exception/InvalidTypeException.php  1f  2      @   vendor/symfony/config/Definition/Exception/UnsetKeyException.php*  1f*  %2d      L   vendor/symfony/config/Definition/Exception/InvalidConfigurationException.phpO  1fO  36A*      J   vendor/symfony/config/Definition/Exception/ForbiddenOverwriteException.php_  1f_  :      8   vendor/symfony/config/Definition/Exception/Exception.php  1f  RrO      1   vendor/symfony/config/Definition/VariableNode.php
  1f
  ͤ      ?   vendor/symfony/config/Definition/Dumper/YamlReferenceDumper.php   1f   #r      >   vendor/symfony/config/Definition/Dumper/XmlReferenceDumper.phpK)  1fK)  4^      @   vendor/symfony/config/Resource/SelfCheckingResourceInterface.php  1f        /   vendor/symfony/config/Resource/FileResource.php  1f  D[      :   vendor/symfony/config/Resource/ReflectionClassResource.php$  1f$  ?EU      >   vendor/symfony/config/Resource/SelfCheckingResourceChecker.php  1f  9ڤ      3   vendor/symfony/config/Resource/ComposerResource.phpD  1fD  >pf      8   vendor/symfony/config/Resource/FileExistenceResource.php  1f  I      4   vendor/symfony/config/Resource/ResourceInterface.php  1f  (      9   vendor/symfony/config/Resource/ClassExistenceResource.phpP  1fP  MW      4   vendor/symfony/config/Resource/DirectoryResource.php
  1f
  gd      /   vendor/symfony/config/Resource/GlobResource.php  1f  h2      8   vendor/symfony/config/Builder/ConfigBuilderInterface.php  1f  {O      (   vendor/symfony/config/Builder/Method.php  1f  5_      .   vendor/symfony/config/Builder/ClassBuilder.php  1f  ^NI      *   vendor/symfony/config/Builder/Property.php  1f  	      A   vendor/symfony/config/Builder/ConfigBuilderGeneratorInterface.php  1f        8   vendor/symfony/config/Builder/ConfigBuilderGenerator.phpH  1fH  ʤ      7   vendor/symfony/config/Exception/LoaderLoadException.phpn  1fn  o      N   vendor/symfony/config/Exception/FileLoaderImportCircularReferenceException.php$  1f$  2WS      D   vendor/symfony/config/Exception/FileLocatorFileNotFoundException.php   1f   Ĥ      #   vendor/symfony/config/composer.json  1f  a      ,   vendor/symfony/config/ConfigCacheFactory.php\  1f\        ;   vendor/symfony/config/ResourceCheckerConfigCacheFactory.php:  1f:   4      D   vendor/symfony/security-http/RateLimiter/DefaultLoginRateLimiter.php	  1f	  #J      6   vendor/symfony/security-http/Attribute/CurrentUser.php  1f  ޤ      $   vendor/symfony/security-http/LICENSE,  1f,  U      5   vendor/symfony/security-http/Util/TargetPathTrait.phpT  1fT  m      )   vendor/symfony/security-http/CHANGELOG.md5  1f5        ,   vendor/symfony/security-http/FirewallMap.phpb  1fb  y      )   vendor/symfony/security-http/Firewall.php  1f  ,h      >   vendor/symfony/security-http/Logout/LogoutHandlerInterface.php  1f  p7Y      <   vendor/symfony/security-http/Logout/SessionLogoutHandler.php  1f  j      E   vendor/symfony/security-http/Logout/LogoutSuccessHandlerInterface.php  1f  Z설      C   vendor/symfony/security-http/Logout/CookieClearingLogoutHandler.php  1f  |V^      F   vendor/symfony/security-http/Logout/CsrfTokenClearingLogoutHandler.php  1f  	Ȥ      :   vendor/symfony/security-http/Logout/LogoutUrlGenerator.php  1f  'Ww      C   vendor/symfony/security-http/Logout/DefaultLogoutSuccessHandler.phpl  1fl        /   vendor/symfony/security-http/SecurityEvents.php  1f  7      8   vendor/symfony/security-http/Firewall/AccessListener.php  1f  _訤      9   vendor/symfony/security-http/Firewall/ContextListener.phpz@  1fz@        I   vendor/symfony/security-http/Firewall/AnonymousAuthenticationListener.phpr  1fr  +      :   vendor/symfony/security-http/Firewall/AbstractListener.phpj  1fj  *Ȇ      <   vendor/symfony/security-http/Firewall/RememberMeListener.phpk  1fk  .      F   vendor/symfony/security-http/Firewall/AuthenticatorManagerListener.phpL  1fL  p
Ť      E   vendor/symfony/security-http/Firewall/BasicAuthenticationListener.phpo  1fo  CJ      J   vendor/symfony/security-http/Firewall/AbstractPreAuthenticatedListener.php  1f  2      ;   vendor/symfony/security-http/Firewall/ExceptionListener.php(  1f(  '7      C   vendor/symfony/security-http/Firewall/FirewallListenerInterface.php"  1f"  P2lI      9   vendor/symfony/security-http/Firewall/ChannelListener.php  1f  F      T   vendor/symfony/security-http/Firewall/UsernamePasswordJsonAuthenticationListener.php'  1f'  .E      <   vendor/symfony/security-http/Firewall/SwitchUserListener.php$  1f$  H      8   vendor/symfony/security-http/Firewall/LogoutListener.php  1f  Hr5      T   vendor/symfony/security-http/Firewall/UsernamePasswordFormAuthenticationListener.phpC  1fC        H   vendor/symfony/security-http/Firewall/AbstractAuthenticationListener.phpz&  1fz&  Pqܤ      D   vendor/symfony/security-http/Firewall/X509AuthenticationListener.php	  1f	   T%      J   vendor/symfony/security-http/Firewall/RemoteUserAuthenticationListener.php  1f  ]@z      =   vendor/symfony/security-http/Controller/UserValueResolver.phpI  1fI  8&      &   vendor/symfony/security-http/README.md  1f  QT`I      G   vendor/symfony/security-http/RememberMe/RememberMeServicesInterface.php  1f  x|i      R   vendor/symfony/security-http/RememberMe/PersistentTokenBasedRememberMeServices.php+  1f+  WO      <   vendor/symfony/security-http/RememberMe/ResponseListener.php  1f  PS(      H   vendor/symfony/security-http/RememberMe/TokenBasedRememberMeServices.php  1f  wT      G   vendor/symfony/security-http/RememberMe/PersistentRememberMeHandler.phpv  1fv  ;=f      F   vendor/symfony/security-http/RememberMe/RememberMeHandlerInterface.php
  1f
  	~¤      =   vendor/symfony/security-http/RememberMe/RememberMeDetails.php8  1f8  Ϣ      E   vendor/symfony/security-http/RememberMe/AbstractRememberMeHandler.php&  1f&  &Zˤ      F   vendor/symfony/security-http/RememberMe/AbstractRememberMeServices.php*  1f*  Yd      F   vendor/symfony/security-http/RememberMe/SignatureRememberMeHandler.php_
  1f_
  CȤ      M   vendor/symfony/security-http/EntryPoint/AuthenticationEntryPointInterface.php  1f  3i      I   vendor/symfony/security-http/EntryPoint/RetryAuthenticationEntryPoint.php6  1f6  }]*-      I   vendor/symfony/security-http/EntryPoint/BasicAuthenticationEntryPoint.php  1f  yOQ      N   vendor/symfony/security-http/EntryPoint/Exception/NotAnEntryPointException.php5  1f5  aYܤ      H   vendor/symfony/security-http/EntryPoint/FormAuthenticationEntryPoint.php  1f  x      *   vendor/symfony/security-http/HttpUtils.php  1f  \      5   vendor/symfony/security-http/FirewallMapInterface.php  1f  9J      L   vendor/symfony/security-http/Authenticator/Token/PostAuthenticationToken.php  1f  3Ȥ      P   vendor/symfony/security-http/Authenticator/InteractiveAuthenticatorInterface.phpk  1fk  ԥw      M   vendor/symfony/security-http/Authenticator/AbstractLoginFormAuthenticator.php	  1f	  J
      E   vendor/symfony/security-http/Authenticator/AuthenticatorInterface.php  1f  ʰY      D   vendor/symfony/security-http/Authenticator/AbstractAuthenticator.php	  1f	        E   vendor/symfony/security-http/Authenticator/HttpBasicAuthenticator.php[  1f[  /3      E   vendor/symfony/security-http/Authenticator/LoginLinkAuthenticator.php  1f  .      E   vendor/symfony/security-http/Authenticator/JsonLoginAuthenticator.php   1f   ]o      N   vendor/symfony/security-http/Authenticator/Passport/SelfValidatingPassport.php  1f  YWW      I   vendor/symfony/security-http/Authenticator/Passport/PassportInterface.php-  1f-  C      @   vendor/symfony/security-http/Authenticator/Passport/Passport.php 
  1f 
        E   vendor/symfony/security-http/Authenticator/Passport/PassportTrait.phpE  1fE        M   vendor/symfony/security-http/Authenticator/Passport/UserPassportInterface.phpG  1fG  ׶a      X   vendor/symfony/security-http/Authenticator/Passport/Credentials/CredentialsInterface.php  1f  P      U   vendor/symfony/security-http/Authenticator/Passport/Credentials/CustomCredentials.php  1f  \qx      W   vendor/symfony/security-http/Authenticator/Passport/Credentials/PasswordCredentials.php+  1f+  H#r      W   vendor/symfony/security-http/Authenticator/Passport/Badge/PreAuthenticatedUserBadge.php  1f  yΤ      L   vendor/symfony/security-http/Authenticator/Passport/Badge/CsrfTokenBadge.php>  1f>  Rۤ      R   vendor/symfony/security-http/Authenticator/Passport/Badge/PasswordUpgradeBadge.php  1f  !RMg      G   vendor/symfony/security-http/Authenticator/Passport/Badge/UserBadge.php4
  1f4
  Eh      M   vendor/symfony/security-http/Authenticator/Passport/Badge/RememberMeBadge.php  1f  i_$      L   vendor/symfony/security-http/Authenticator/Passport/Badge/BadgeInterface.php  1f  ˙Au      @   vendor/symfony/security-http/Authenticator/X509Authenticator.php.  1f.        F   vendor/symfony/security-http/Authenticator/RemoteUserAuthenticator.php  1f  /q!      E   vendor/symfony/security-http/Authenticator/FormLoginAuthenticator.php"  1f"  Bd      T   vendor/symfony/security-http/Authenticator/AbstractPreAuthenticatedAuthenticator.php  1f        K   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticator.php  1f  @b      Z   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticatorManagerListener.php   1f   w       F   vendor/symfony/security-http/Authenticator/RememberMeAuthenticator.phpI  1fI  J'[Ԥ      K   vendor/symfony/security-http/Authorization/AccessDeniedHandlerInterface.php  1f  bP      3   vendor/symfony/security-http/AccessMapInterface.phpa  1fa  u      ;   vendor/symfony/security-http/LoginLink/LoginLinkDetails.phpB  1fB  LZ
      ;   vendor/symfony/security-http/LoginLink/LoginLinkHandler.php  1f  Z      @   vendor/symfony/security-http/LoginLink/LoginLinkNotification.php
  1f
  ;;d      D   vendor/symfony/security-http/LoginLink/LoginLinkHandlerInterface.php  1f  2AΤ      W   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkExceptionInterface.php  1f  HF      N   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkException.php  1f        \   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkAuthenticationException.php  1f  M      N   vendor/symfony/security-http/LoginLink/Exception/ExpiredLoginLinkException.phpI  1fI  Z      I   vendor/symfony/security-http/Authentication/NoopAuthenticationManager.php  1f  Jp      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationFailureHandler.php>  1f>  C[      M   vendor/symfony/security-http/Authentication/AuthenticatorManagerInterface.php  1f  1      R   vendor/symfony/security-http/Authentication/CustomAuthenticationSuccessHandler.php~  1f~  
Ť      U   vendor/symfony/security-http/Authentication/AuthenticationFailureHandlerInterface.php  1f  ^      C   vendor/symfony/security-http/Authentication/AuthenticationUtils.php+	  1f+	  pq      R   vendor/symfony/security-http/Authentication/CustomAuthenticationFailureHandler.php  1f  9      U   vendor/symfony/security-http/Authentication/AuthenticationSuccessHandlerInterface.php  1f  T      J   vendor/symfony/security-http/Authentication/UserAuthenticatorInterface.php  1f  
>      D   vendor/symfony/security-http/Authentication/AuthenticatorManager.php;  1f;        S   vendor/symfony/security-http/Authentication/DefaultAuthenticationSuccessHandler.php&  1f&  zC      *   vendor/symfony/security-http/AccessMap.phpz  1fz  /      8   vendor/symfony/security-http/Event/LoginFailureEvent.php
  1f
        8   vendor/symfony/security-http/Event/LoginSuccessEvent.php  1f  9u_      ;   vendor/symfony/security-http/Event/DeauthenticatedEvent.phpL  1fL  b      8   vendor/symfony/security-http/Event/LazyResponseEvent.php  1f  @      6   vendor/symfony/security-http/Event/SwitchUserEvent.php[  1f[  8oӤ      F   vendor/symfony/security-http/Event/AuthenticationTokenCreatedEvent.php  1f        9   vendor/symfony/security-http/Event/CheckPassportEvent.php  1f  /aJ      <   vendor/symfony/security-http/Event/InteractiveLoginEvent.php0  1f0  X      2   vendor/symfony/security-http/Event/LogoutEvent.php  1f  %      @   vendor/symfony/security-http/Event/TokenDeauthenticatedEvent.php  1f  "C      D   vendor/symfony/security-http/Impersonate/ImpersonateUrlGenerator.php"
  1f"
  T      2   vendor/symfony/security-http/ParameterBagUtils.php%
  1f%
  E      *   vendor/symfony/security-http/composer.json3  1f3        D   vendor/symfony/security-http/EventListener/SessionLogoutListener.php  1f  t      D   vendor/symfony/security-http/EventListener/DefaultLogoutListener.php\  1f\  O4HE      H   vendor/symfony/security-http/EventListener/PasswordMigratingListener.php  1f  -1      A   vendor/symfony/security-http/EventListener/RememberMeListener.php	  1f	  x      F   vendor/symfony/security-http/EventListener/LoginThrottlingListener.php  1f  [%      C   vendor/symfony/security-http/EventListener/UserProviderListener.phpq  1fq  p\      K   vendor/symfony/security-http/EventListener/CookieClearingLogoutListener.php  1f  h@      G   vendor/symfony/security-http/EventListener/CheckCredentialsListener.php  1f  6+?      G   vendor/symfony/security-http/EventListener/RememberMeLogoutListener.php  1f  ͤ      F   vendor/symfony/security-http/EventListener/SessionStrategyListener.php  1f  1#6)      N   vendor/symfony/security-http/EventListener/CsrfTokenClearingLogoutListener.phpi  1fi  ='9      B   vendor/symfony/security-http/EventListener/UserCheckerListener.php  1f  Ӗ      E   vendor/symfony/security-http/EventListener/CsrfProtectionListener.phpg  1fg  !z      P   vendor/symfony/security-http/EventListener/CheckRememberMeConditionsListener.php
  1f
        O   vendor/symfony/security-http/Session/SessionAuthenticationStrategyInterface.php(  1f(  ୃԤ      F   vendor/symfony/security-http/Session/SessionAuthenticationStrategy.php7  1f7  ?5Ǵ      <   vendor/symfony/event-dispatcher/EventDispatcherInterface.php  1f  ʦv      =   vendor/symfony/event-dispatcher/Attribute/AsEventListener.php  1f  $      '   vendor/symfony/event-dispatcher/LICENSE,  1f,  U      ,   vendor/symfony/event-dispatcher/CHANGELOG.md,  1f,  *פ      >   vendor/symfony/event-dispatcher/LegacyEventDispatcherProxy.php  1f  |2      3   vendor/symfony/event-dispatcher/EventDispatcher.php $  1f $  ;N      )   vendor/symfony/event-dispatcher/README.mdW  1fW  ,fB      <   vendor/symfony/event-dispatcher/EventSubscriberInterface.php  1f  A{)      <   vendor/symfony/event-dispatcher/ImmutableEventDispatcher.php  1f  4zS      0   vendor/symfony/event-dispatcher/GenericEvent.php  1f  wD      M   vendor/symfony/event-dispatcher/DependencyInjection/RegisterListenersPass.php%  1f%  4      K   vendor/symfony/event-dispatcher/DependencyInjection/AddEventAliasesPass.php  1f  n      -   vendor/symfony/event-dispatcher/composer.json  1f  S      B   vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php.  1f.  -X'      9   vendor/symfony/event-dispatcher/Debug/WrappedListener.php-  1f-  ^      +   vendor/symfony/var-dumper/Cloner/Cursor.phpH  1fH  cq      .   vendor/symfony/var-dumper/Cloner/VarCloner.php5  1f5  ѵ      4   vendor/symfony/var-dumper/Cloner/ClonerInterface.php  1f   Mf      4   vendor/symfony/var-dumper/Cloner/DumperInterface.phpG  1fG  g      3   vendor/symfony/var-dumper/Cloner/AbstractCloner.php\  1f\  )      )   vendor/symfony/var-dumper/Cloner/Data.php6  1f6  k      )   vendor/symfony/var-dumper/Cloner/Stub.php  1f  J&      !   vendor/symfony/var-dumper/LICENSE,  1f,  .z      5   vendor/symfony/var-dumper/Test/VarDumperTestTrait.php
  1f
        &   vendor/symfony/var-dumper/CHANGELOG.md  1f  /h      .   vendor/symfony/var-dumper/Caster/GmpCaster.php
  1f
  "       5   vendor/symfony/var-dumper/Caster/ReflectionCaster.php9  1f9  
      /   vendor/symfony/var-dumper/Caster/StubCaster.phpt  1ft  ߤ      2   vendor/symfony/var-dumper/Caster/SymfonyCaster.php
  1f
  /Q]      .   vendor/symfony/var-dumper/Caster/FrameStub.php  1f  aa      7   vendor/symfony/var-dumper/Caster/ProxyManagerCaster.php  1f  ;      /   vendor/symfony/var-dumper/Caster/DateCaster.php  1f  6Y      .   vendor/symfony/var-dumper/Caster/PdoCaster.php  1f  9      6   vendor/symfony/var-dumper/Caster/XmlResourceCaster.phpW	  1fW	  =      3   vendor/symfony/var-dumper/Caster/ResourceCaster.phpc  1fc  >*      4   vendor/symfony/var-dumper/Caster/ExceptionCaster.phpR?  1fR?  ћϤ      -   vendor/symfony/var-dumper/Caster/DsCaster.phpS  1fS  c      -   vendor/symfony/var-dumper/Caster/LinkStub.phpb
  1fb
  (17      4   vendor/symfony/var-dumper/Caster/MemcachedCaster.php	  1f	  ֤      3   vendor/symfony/var-dumper/Caster/DoctrineCaster.php  1f  l      2   vendor/symfony/var-dumper/Caster/RdKafkaCaster.php  1f  ęs      1   vendor/symfony/var-dumper/Caster/MysqliCaster.php  1f        ,   vendor/symfony/var-dumper/Caster/ImgStub.php  1f  ͤ      .   vendor/symfony/var-dumper/Caster/ClassStub.php2  1f2  +S      .   vendor/symfony/var-dumper/Caster/TraceStub.php  1f  _      1   vendor/symfony/var-dumper/Caster/CutArrayStub.php  1f  QG      0   vendor/symfony/var-dumper/Caster/PgSqlCaster.php  1f  x      +   vendor/symfony/var-dumper/Caster/Caster.php  1f  ;
ߤ      .   vendor/symfony/var-dumper/Caster/SplCaster.php  1f  `      .   vendor/symfony/var-dumper/Caster/ConstStub.php  1f  }      /   vendor/symfony/var-dumper/Caster/DsPairStub.phpb  1fb  P-      /   vendor/symfony/var-dumper/Caster/IntlCaster.php)  1f)  ˵J      0   vendor/symfony/var-dumper/Caster/RedisCaster.php  1f  ("mt      0   vendor/symfony/var-dumper/Caster/FiberCaster.phpA  1fA  >zӤ      2   vendor/symfony/var-dumper/Caster/ImagineCaster.php  1f  |gdߤ      /   vendor/symfony/var-dumper/Caster/AmqpCaster.php  1f  YR      .   vendor/symfony/var-dumper/Caster/DOMCaster.php   1f   ۤ      /   vendor/symfony/var-dumper/Caster/UuidCaster.php  1f  E7      4   vendor/symfony/var-dumper/Caster/XmlReaderCaster.php6  1f6  z      -   vendor/symfony/var-dumper/Caster/ArgsStub.php	  1f	  ͨ      -   vendor/symfony/var-dumper/Caster/EnumStub.php  1f  `"      ,   vendor/symfony/var-dumper/Caster/CutStub.php  1f  $N      7   vendor/symfony/var-dumper/Resources/bin/var-dump-server  1f  '      :   vendor/symfony/var-dumper/Resources/css/htmlDescriptor.css  1f  Dva      8   vendor/symfony/var-dumper/Resources/js/htmlDescriptor.jsb  1fb  h|      6   vendor/symfony/var-dumper/Resources/functions/dump.php+  1f+  7      /   vendor/symfony/var-dumper/Server/Connection.php
  1f
  SJn      /   vendor/symfony/var-dumper/Server/DumpServer.php

  1f

  ڤ      #   vendor/symfony/var-dumper/README.md_  1f_  Fq      7   vendor/symfony/var-dumper/Command/ServerDumpCommand.php  1f  l+      H   vendor/symfony/var-dumper/Command/Descriptor/DumpDescriptorInterface.php  1f  a*      >   vendor/symfony/var-dumper/Command/Descriptor/CliDescriptor.php
  1f
  F      ?   vendor/symfony/var-dumper/Command/Descriptor/HtmlDescriptor.php  1f  "      ?   vendor/symfony/var-dumper/Exception/ThrowingCasterException.php  1f  Q	k      1   vendor/symfony/var-dumper/Dumper/ServerDumper.php~  1f~  NHΤ      8   vendor/symfony/var-dumper/Dumper/DataDumperInterface.php  1f  ׌.      M   vendor/symfony/var-dumper/Dumper/ContextProvider/ContextProviderInterface.php(  1f(  EFf      K   vendor/symfony/var-dumper/Dumper/ContextProvider/RequestContextProvider.php  1f  p      G   vendor/symfony/var-dumper/Dumper/ContextProvider/CliContextProvider.php  1f  y9.L      J   vendor/symfony/var-dumper/Dumper/ContextProvider/SourceContextProvider.php  1f  C^)      3   vendor/symfony/var-dumper/Dumper/AbstractDumper.phpR  1fR  	ܾQ      .   vendor/symfony/var-dumper/Dumper/CliDumper.phpX  1fX  {Ϥ      9   vendor/symfony/var-dumper/Dumper/ContextualizedDumper.php  1f  y5|      /   vendor/symfony/var-dumper/Dumper/HtmlDumper.phpc  1fc  Ms      '   vendor/symfony/var-dumper/composer.jsonq  1fq  T      '   vendor/symfony/var-dumper/VarDumper.php  1f  /:      !   vendor/symfony/filesystem/LICENSE,  1f,  U      &   vendor/symfony/filesystem/CHANGELOG.md  1f  I      (   vendor/symfony/filesystem/Filesystem.phpu  1fu  ($9      "   vendor/symfony/filesystem/Path.php f  1f f  簦      #   vendor/symfony/filesystem/README.md  1f        <   vendor/symfony/filesystem/Exception/IOExceptionInterface.php  1f  yp      :   vendor/symfony/filesystem/Exception/ExceptionInterface.php  1f  (l`Ф      8   vendor/symfony/filesystem/Exception/RuntimeException.php  1f  A      3   vendor/symfony/filesystem/Exception/IOException.php  1f         @   vendor/symfony/filesystem/Exception/InvalidArgumentException.php  1f  $
      =   vendor/symfony/filesystem/Exception/FileNotFoundException.php  1f   [:      '   vendor/symfony/filesystem/composer.json  1f  _m      G   vendor/symfony/security-csrf/TokenStorage/NativeSessionTokenStorage.php
  1f
  '      A   vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.php  1f  "      L   vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php  1f  @M      C   vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.phpz  1fz  W-m      $   vendor/symfony/security-csrf/LICENSE,  1f,  U      )   vendor/symfony/security-csrf/CHANGELOG.md   1f         *   vendor/symfony/security-csrf/CsrfToken.php  1f  ϗ      &   vendor/symfony/security-csrf/README.md  1f   Ъ      :   vendor/symfony/security-csrf/CsrfTokenManagerInterface.php  1f  c      E   vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php  1f  bwx      G   vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php&  1f&  Hvܤ      1   vendor/symfony/security-csrf/CsrfTokenManager.php  1f        A   vendor/symfony/security-csrf/Exception/TokenNotFoundException.php  1f   U      *   vendor/symfony/security-csrf/composer.jsonl  1fl  Sˤ      D   vendor/symfony/security-guard/Token/PostAuthenticationGuardToken.php  1f  9v      C   vendor/symfony/security-guard/Token/PreAuthenticationGuardToken.phpm  1fm  Q      ;   vendor/symfony/security-guard/Token/GuardTokenInterface.php  1f  nɚ      8   vendor/symfony/security-guard/AuthenticatorInterface.php  1f  Nn      %   vendor/symfony/security-guard/LICENSE,  1f,  U      <   vendor/symfony/security-guard/AbstractGuardAuthenticator.php  1f  Ȍ      *   vendor/symfony/security-guard/CHANGELOG.md   1f         F   vendor/symfony/security-guard/Provider/GuardAuthenticationProvider.phpK%  1fK%  e      @   vendor/symfony/security-guard/PasswordAuthenticatedInterface.phpv  1fv  Q:L      F   vendor/symfony/security-guard/Firewall/GuardAuthenticationListener.php]-  1f]-  <      '   vendor/symfony/security-guard/README.md  1f  @      ;   vendor/symfony/security-guard/GuardAuthenticatorHandler.php  1f  $6      N   vendor/symfony/security-guard/Authenticator/AbstractFormLoginAuthenticator.php  1f  d$      H   vendor/symfony/security-guard/Authenticator/GuardBridgeAuthenticator.php  1f  -tM      +   vendor/symfony/security-guard/composer.json  1f  z      7   vendor/symfony/polyfill-intl-normalizer/bootstrap80.php  1f  ,      /   vendor/symfony/polyfill-intl-normalizer/LICENSE,  1f,  H      6   vendor/symfony/polyfill-intl-normalizer/Normalizer.php8$  1f8$  &(C      F   vendor/symfony/polyfill-intl-normalizer/Resources/stubs/Normalizer.php  1f  %      L   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/combiningClass.php.  1f.  Cb      T   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalDecomposition.phpx  1fx        R   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalComposition.php=  1f=  V{      X   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/compatibilityDecomposition.php  1f  [
+      5   vendor/symfony/polyfill-intl-normalizer/bootstrap.php  1f  #p      1   vendor/symfony/polyfill-intl-normalizer/README.md  1f  +tK      5   vendor/symfony/polyfill-intl-normalizer/composer.jsonx  1fx  ~O      F   vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php
  1f
  l      3   vendor/symfony/event-dispatcher-contracts/Event.php  1f  %ߤ      1   vendor/symfony/event-dispatcher-contracts/LICENSE,  1f,        6   vendor/symfony/event-dispatcher-contracts/CHANGELOG.md   1f   h{#      3   vendor/symfony/event-dispatcher-contracts/README.md\  1f\  ͗      7   vendor/symfony/event-dispatcher-contracts/composer.json  1f  $>ɤ      8   vendor/symfony/property-access/PropertyPathInterface.phpa  1fa  ,      7   vendor/symfony/property-access/PropertyPathIterator.php  1f  d      &   vendor/symfony/property-access/LICENSE,  1f,  U      @   vendor/symfony/property-access/PropertyPathIteratorInterface.php$  1f$  F8      +   vendor/symfony/property-access/CHANGELOG.md  1f  {r      <   vendor/symfony/property-access/PropertyAccessorInterface.php  1f  `ml:      /   vendor/symfony/property-access/PropertyPath.php  1f  Z      :   vendor/symfony/property-access/PropertyAccessorBuilder.php
  1f
  _ͤ      (   vendor/symfony/property-access/README.md1  1f1  !Q      3   vendor/symfony/property-access/PropertyAccessor.phpN~  1fN~  e      1   vendor/symfony/property-access/PropertyAccess.php  1f        6   vendor/symfony/property-access/PropertyPathBuilder.php#  1f#  1>      <   vendor/symfony/property-access/Exception/AccessException.php  1f  KW      K   vendor/symfony/property-access/Exception/UninitializedPropertyException.php  1f  ,      ?   vendor/symfony/property-access/Exception/ExceptionInterface.php  1f  l      A   vendor/symfony/property-access/Exception/OutOfBoundsException.php  1f  ؤ      =   vendor/symfony/property-access/Exception/RuntimeException.php  1f  Cn      E   vendor/symfony/property-access/Exception/InvalidArgumentException.php  1f  IF[3      I   vendor/symfony/property-access/Exception/InvalidPropertyPathException.php  1f  zޤ      D   vendor/symfony/property-access/Exception/UnexpectedTypeException.phps  1fs  >r      A   vendor/symfony/property-access/Exception/NoSuchIndexException.php  1f  NQp      D   vendor/symfony/property-access/Exception/NoSuchPropertyException.php  1f  ?      ,   vendor/symfony/property-access/composer.json  1f  S[      %   vendor/symfony/finder/SplFileInfo.php(  1f(  a8      5   vendor/symfony/finder/Comparator/NumberComparator.php
  1f
        /   vendor/symfony/finder/Comparator/Comparator.php  1f  pe,      3   vendor/symfony/finder/Comparator/DateComparator.php  1f            vendor/symfony/finder/Finder.phpX  1fX  1pr         vendor/symfony/finder/LICENSE,  1f,  U      "   vendor/symfony/finder/CHANGELOG.md  1f  sn         vendor/symfony/finder/Glob.phpF  1fF  )h         vendor/symfony/finder/README.md  1f  C      /   vendor/symfony/finder/Iterator/LazyIterator.php  1f  zz      ;   vendor/symfony/finder/Iterator/VcsIgnoredFilterIterator.php  1f  K      <   vendor/symfony/finder/Iterator/FilecontentFilterIterator.php  1f  (      =   vendor/symfony/finder/Iterator/MultiplePcreFilterIterator.php  1f  %      :   vendor/symfony/finder/Iterator/SizeRangeFilterIterator.php  1f        9   vendor/symfony/finder/Iterator/FilenameFilterIterator.php  1f        :   vendor/symfony/finder/Iterator/DateRangeFilterIterator.php  1f  Q      7   vendor/symfony/finder/Iterator/CustomFilterIterator.php/  1f/  ~N<      =   vendor/symfony/finder/Iterator/RecursiveDirectoryIterator.php  1f  9ޤ      A   vendor/symfony/finder/Iterator/ExcludeDirectoryFilterIterator.php
  1f
  ܤ      3   vendor/symfony/finder/Iterator/SortableIterator.phpf  1ff  򺩤      ;   vendor/symfony/finder/Iterator/DepthRangeFilterIterator.php  1f  `(d      9   vendor/symfony/finder/Iterator/FileTypeFilterIterator.php}  1f}  /u      5   vendor/symfony/finder/Iterator/PathFilterIterator.php  1f  zΤ      #   vendor/symfony/finder/Gitignore.php!  1f!  HWkJ      9   vendor/symfony/finder/Exception/AccessDeniedException.php  1f        >   vendor/symfony/finder/Exception/DirectoryNotFoundException.php  1f  )      #   vendor/symfony/finder/composer.jsonF  1fF  i      >   vendor/symfony/http-kernel/DataCollector/DumpDataCollector.php&*  1f&*        @   vendor/symfony/http-kernel/DataCollector/MemoryDataCollector.php	  1f	  aϤ      G   vendor/symfony/http-kernel/DataCollector/LateDataCollectorInterface.php  1f  |7r      @   vendor/symfony/http-kernel/DataCollector/RouterDataCollector.phpr	  1fr	  6v      >   vendor/symfony/http-kernel/DataCollector/TimeDataCollector.php  1f        C   vendor/symfony/http-kernel/DataCollector/DataCollectorInterface.php  1f        A   vendor/symfony/http-kernel/DataCollector/RequestDataCollector.php.<  1f.<  (]/      >   vendor/symfony/http-kernel/DataCollector/AjaxDataCollector.php^  1f^  0      :   vendor/symfony/http-kernel/DataCollector/DataCollector.php  1f  _      @   vendor/symfony/http-kernel/DataCollector/LoggerDataCollector.php)  1f)  TFN      @   vendor/symfony/http-kernel/DataCollector/ConfigDataCollector.phpQ  1fQ  F:ߤ      ?   vendor/symfony/http-kernel/DataCollector/EventDataCollector.php  1f  E      C   vendor/symfony/http-kernel/DataCollector/ExceptionDataCollector.php  1f  zP      5   vendor/symfony/http-kernel/Attribute/AsController.php  1f  ݤ      :   vendor/symfony/http-kernel/Attribute/ArgumentInterface.php&  1f&  ߓ
      "   vendor/symfony/http-kernel/LICENSE,  1f,  U      R   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php  1f  )#      B   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadata.php  1f  .T      I   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php
  1f
  ɰI      '   vendor/symfony/http-kernel/CHANGELOG.mdeB  1feB  y      1   vendor/symfony/http-kernel/Config/FileLocator.php}  1f}  S      /   vendor/symfony/http-kernel/HttpClientKernel.php  1f  WuL      2   vendor/symfony/http-kernel/TerminableInterface.php  1f  +      A   vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php  1f  炱      =   vendor/symfony/http-kernel/CacheClearer/ChainCacheClearer.php_  1f_  (.      <   vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php  1f        5   vendor/symfony/http-kernel/Resources/welcome.html.php}  1f}  K@      )   vendor/symfony/http-kernel/HttpKernel.php)  1f)  ;l      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerAggregate.phpB  1fB  w5      6   vendor/symfony/http-kernel/CacheWarmer/CacheWarmer.php  1f  t      <   vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.phpr  1fr        ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerInterface.php  1f  {w]b      ,   vendor/symfony/http-kernel/Bundle/Bundle.phpg  1fg  ta֤      5   vendor/symfony/http-kernel/Bundle/BundleInterface.phpL  1fL  'K      .   vendor/symfony/http-kernel/KernelInterface.php[  1f[  ܵy      :   vendor/symfony/http-kernel/Controller/ArgumentResolver.php  1f  #S      =   vendor/symfony/http-kernel/Controller/ControllerReference.php5  1f5  Ul      9   vendor/symfony/http-kernel/Controller/ErrorController.php  1f  aoͤ      E   vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php
  1f
  _c	n      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/VariadicValueResolver.php  1f  ܵ      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/ServiceValueResolver.phpS  1fS  g%      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/DefaultValueResolver.php  1f  {      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestValueResolver.php  1f        O   vendor/symfony/http-kernel/Controller/ArgumentResolver/SessionValueResolver.php  1f  r7      X   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestAttributeValueResolver.php  1f  :;)'      [   vendor/symfony/http-kernel/Controller/ArgumentResolver/NotTaggedControllerValueResolver.php2  1f2        Q   vendor/symfony/http-kernel/Controller/ArgumentResolver/TraceableValueResolver.php  1f  ۵      C   vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.phpG  1fG  ^M      E   vendor/symfony/http-kernel/Controller/ControllerResolverInterface.phph  1fh  3      C   vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.phpT  1fT        <   vendor/symfony/http-kernel/Controller/ControllerResolver.php8  1f8        E   vendor/symfony/http-kernel/Controller/TraceableControllerResolver.php8  1f8  ܍4      H   vendor/symfony/http-kernel/Controller/ArgumentValueResolverInterface.php  1f  ~      $   vendor/symfony/http-kernel/README.md  1f         E   vendor/symfony/http-kernel/Fragment/FragmentUriGeneratorInterface.php;  1f;  ?      >   vendor/symfony/http-kernel/Fragment/InlineFragmentRenderer.php7  1f7   ޤ      ;   vendor/symfony/http-kernel/Fragment/SsiFragmentRenderer.phpA  1fA  ,      I   vendor/symfony/http-kernel/Fragment/AbstractSurrogateFragmentRenderer.phpJ  1fJ  `A      A   vendor/symfony/http-kernel/Fragment/FragmentRendererInterface.php  1f  䴀      <   vendor/symfony/http-kernel/Fragment/FragmentUriGenerator.php%  1f%  ~2\      ;   vendor/symfony/http-kernel/Fragment/EsiFragmentRenderer.phpA  1fA  lY^$      @   vendor/symfony/http-kernel/Fragment/HIncludeFragmentRenderer.php*
  1f*
  ז{      7   vendor/symfony/http-kernel/Fragment/FragmentHandler.php  1f  f٤      @   vendor/symfony/http-kernel/Fragment/RoutableFragmentRenderer.php  1f  ݤ      +   vendor/symfony/http-kernel/KernelEvents.phpd  1fd  Z$      ,   vendor/symfony/http-kernel/HttpCache/Esi.php6
  1f6
  ד'      2   vendor/symfony/http-kernel/HttpCache/HttpCache.phpd  1fd  }tQC      .   vendor/symfony/http-kernel/HttpCache/Store.php9  1f9  J݉Ԥ      ;   vendor/symfony/http-kernel/HttpCache/SurrogateInterface.php  1f        G   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategyInterface.php  1f  H      >   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategy.php(#  1f(#   |      7   vendor/symfony/http-kernel/HttpCache/StoreInterface.php  1f  ȴ      ,   vendor/symfony/http-kernel/HttpCache/Ssi.php
  1f
  H      :   vendor/symfony/http-kernel/HttpCache/AbstractSurrogate.php  1f  [      :   vendor/symfony/http-kernel/HttpCache/SubRequestHandler.php1  1f1  イ      2   vendor/symfony/http-kernel/HttpKernelInterface.php  1f  ~8      )   vendor/symfony/http-kernel/Log/Logger.php(  1f(  K_/      7   vendor/symfony/http-kernel/Log/DebugLoggerInterface.php  1f  q<      ;   vendor/symfony/http-kernel/Profiler/FileProfilerStorage.phpR"  1fR"        /   vendor/symfony/http-kernel/Profiler/Profile.php  1f  >P6      0   vendor/symfony/http-kernel/Profiler/Profiler.php4  1f4  Te      @   vendor/symfony/http-kernel/Profiler/ProfilerStorageInterface.php  1f  5g      G   vendor/symfony/http-kernel/DependencyInjection/FragmentRendererPass.php=
  1f=
  #      C   vendor/symfony/http-kernel/DependencyInjection/ServicesResetter.phph  1fh  Q      R   vendor/symfony/http-kernel/DependencyInjection/RegisterLocaleAwareServicesPass.php`  1f`  e`      H   vendor/symfony/http-kernel/DependencyInjection/ResettableServicePass.php	  1f	  Q:      R   vendor/symfony/http-kernel/DependencyInjection/MergeExtensionConfigurationPass.php  1f  )      Q   vendor/symfony/http-kernel/DependencyInjection/AddAnnotatedClassesToCachePass.phpI  1fI  ڤ      H   vendor/symfony/http-kernel/DependencyInjection/ConfigurableExtension.php  1f  ;t      =   vendor/symfony/http-kernel/DependencyInjection/LoggerPass.php0  1f0  s-      <   vendor/symfony/http-kernel/DependencyInjection/Extension.phpR  1fR  P@      V   vendor/symfony/http-kernel/DependencyInjection/ControllerArgumentValueResolverPass.php
  1f
  `P      Y   vendor/symfony/http-kernel/DependencyInjection/RegisterControllerArgumentLocatorsPass.phpJ-  1fJ-  nlgH      \   vendor/symfony/http-kernel/DependencyInjection/RemoveEmptyControllerArgumentLocatorsPass.php  1f  >      M   vendor/symfony/http-kernel/DependencyInjection/LazyLoadingFragmentHandler.php  1f  P      E   vendor/symfony/http-kernel/Exception/TooManyRequestsHttpException.php  1f  @b[Ť      >   vendor/symfony/http-kernel/Exception/ConflictHttpException.php#  1f#  6uG      6   vendor/symfony/http-kernel/Exception/HttpException.php(  1f(  $      B   vendor/symfony/http-kernel/Exception/UnauthorizedHttpException.php  1f  O0F      A   vendor/symfony/http-kernel/Exception/InvalidMetadataException.phpj  1fj  ;녤      D   vendor/symfony/http-kernel/Exception/LengthRequiredHttpException.php)  1f)  	      I   vendor/symfony/http-kernel/Exception/UnprocessableEntityHttpException.php7  1f7  
      H   vendor/symfony/http-kernel/Exception/PreconditionFailedHttpException.php-  1f-  pjϤ      :   vendor/symfony/http-kernel/Exception/GoneHttpException.php  1f  h      J   vendor/symfony/http-kernel/Exception/UnsupportedMediaTypeHttpException.php/  1f/  x稤      H   vendor/symfony/http-kernel/Exception/UnexpectedSessionUsageException.php  1f  Zis      H   vendor/symfony/http-kernel/Exception/ServiceUnavailableHttpException.php  1f  
      ?   vendor/symfony/http-kernel/Exception/HttpExceptionInterface.php  1f  <ͯ      B   vendor/symfony/http-kernel/Exception/AccessDeniedHttpException.php\  1f\  ~&դ      @   vendor/symfony/http-kernel/Exception/BadRequestHttpException.php%  1f%  4]      Q   vendor/symfony/http-kernel/Exception/ControllerDoesNotReturnResponseException.phpE  1fE  :      C   vendor/symfony/http-kernel/Exception/NotAcceptableHttpException.php(  1f(  /      J   vendor/symfony/http-kernel/Exception/PreconditionRequiredHttpException.php]  1f]  !F3      >   vendor/symfony/http-kernel/Exception/NotFoundHttpException.php*  1f*        F   vendor/symfony/http-kernel/Exception/MethodNotAllowedHttpException.php  1f  Z(^      4   vendor/symfony/http-kernel/Event/ControllerEvent.php  1f        3   vendor/symfony/http-kernel/Event/ExceptionEvent.php  1f  -ү      7   vendor/symfony/http-kernel/Event/FinishRequestEvent.php  1f  TY      2   vendor/symfony/http-kernel/Event/ResponseEvent.php  1f  ~      3   vendor/symfony/http-kernel/Event/TerminateEvent.php}  1f}  i+      =   vendor/symfony/http-kernel/Event/ControllerArgumentsEvent.phpV  1fV  +Ƥ      0   vendor/symfony/http-kernel/Event/KernelEvent.phpW	  1fW	  j      1   vendor/symfony/http-kernel/Event/RequestEvent.php  1f  gS      .   vendor/symfony/http-kernel/Event/ViewEvent.php:  1f:  W<      (   vendor/symfony/http-kernel/composer.json
  1f
  ,      2   vendor/symfony/http-kernel/RebootableInterface.php!  1f!  1Ƥ      %   vendor/symfony/http-kernel/Kernel.phps  1fs  Ѥ      (   vendor/symfony/http-kernel/UriSigner.php  1f  Mu      =   vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.php
  1f
  ;֌      6   vendor/symfony/http-kernel/Debug/FileLinkFormatter.php
  1f
  IH      0   vendor/symfony/http-kernel/HttpKernelBrowser.php  1f  M֤      E   vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php  1f  y      =   vendor/symfony/http-kernel/EventListener/ResponseListener.phps  1fs  b      ;   vendor/symfony/http-kernel/EventListener/LocaleListener.php  1f  '      =   vendor/symfony/http-kernel/EventListener/FragmentListener.php  1f  T      D   vendor/symfony/http-kernel/EventListener/AbstractSessionListener.php3  1f3  鑍0      @   vendor/symfony/http-kernel/EventListener/TestSessionListener.php  1f  Hb      D   vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php  1f  A      K   vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.php  1f  "v      F   vendor/symfony/http-kernel/EventListener/AddRequestFormatsListener.php  1f  	
ܤ      =   vendor/symfony/http-kernel/EventListener/ProfilerListener.php  1f  5+;      >   vendor/symfony/http-kernel/EventListener/SurrogateListener.php:  1f:  *      B   vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php
  1f
  &g      H   vendor/symfony/http-kernel/EventListener/AbstractTestSessionListener.php  1f  Ng      @   vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php	  1f	  s      9   vendor/symfony/http-kernel/EventListener/DumpListener.php@  1f@        :   vendor/symfony/http-kernel/EventListener/ErrorListener.php$  1f$  ^}      <   vendor/symfony/http-kernel/EventListener/SessionListener.php8  1f8  s      ;   vendor/symfony/http-kernel/EventListener/RouterListener.php\  1f\  t         vendor/symfony/yaml/LICENSE,  1f,  U         vendor/symfony/yaml/Parser.php  1f  hi          vendor/symfony/yaml/CHANGELOG.md6  1f6  W         vendor/symfony/yaml/Escaper.php  1f  
      +   vendor/symfony/yaml/Resources/bin/yaml-lint  1f  3VԈ         vendor/symfony/yaml/README.md  1f  ـT      !   vendor/symfony/yaml/Unescaper.php  1f  <L         vendor/symfony/yaml/Dumper.php  1f  V         vendor/symfony/yaml/Inline.php'  1f'  ̤         vendor/symfony/yaml/Yaml.php  1f  xw      +   vendor/symfony/yaml/Command/LintCommand.php=(  1f=(  ُ      /   vendor/symfony/yaml/Exception/DumpException.php  1f  ?<̤      4   vendor/symfony/yaml/Exception/ExceptionInterface.php  1f  ,P      2   vendor/symfony/yaml/Exception/RuntimeException.php  1f  #OU      0   vendor/symfony/yaml/Exception/ParseException.phpq  1fq  8      '   vendor/symfony/yaml/Tag/TaggedValue.php  1f  .|      !   vendor/symfony/yaml/composer.json=  1f=  K'      )   vendor/symfony/string/CodePointString.php  1f  }Ѥ         vendor/symfony/string/LICENSE,  1f,  զ_Ϥ      "   vendor/symfony/string/CHANGELOG.mdD  1fD        (   vendor/symfony/string/AbstractString.phpO  1fO  ,}'      -   vendor/symfony/string/Resources/functions.phpl  1fl        <   vendor/symfony/string/Resources/data/wcswidth_table_zero.php  1f  °jj      <   vendor/symfony/string/Resources/data/wcswidth_table_wide.php  1f  }NM      3   vendor/symfony/string/Inflector/FrenchInflector.php  1f  .7      6   vendor/symfony/string/Inflector/InflectorInterface.phpR  1fR  _      4   vendor/symfony/string/Inflector/EnglishInflector.phpB  1fB  u`1         vendor/symfony/string/README.md+  1f+  L      /   vendor/symfony/string/AbstractUnicodeString.phpHi  1fHi  y*      $   vendor/symfony/string/LazyString.phpn  1fn  D`      $   vendor/symfony/string/ByteString.php<  1f<  u֤      '   vendor/symfony/string/UnicodeString.php2  1f2  cŤ      6   vendor/symfony/string/Exception/ExceptionInterface.php_  1f_  :      4   vendor/symfony/string/Exception/RuntimeException.php~  1f~  )Ʉ      <   vendor/symfony/string/Exception/InvalidArgumentException.php  1f  B;8      #   vendor/symfony/string/composer.json  1f  ~&      2   vendor/symfony/string/Slugger/SluggerInterface.php  1f        .   vendor/symfony/string/Slugger/AsciiSlugger.php#  1f#  6%      4   vendor/symfony/security-core/Role/SwitchUserRole.php  1f  'v      <   vendor/symfony/security-core/Role/RoleHierarchyInterface.php]  1f]  Բ'      *   vendor/symfony/security-core/Role/Role.php  1f  i֜      3   vendor/symfony/security-core/Role/RoleHierarchy.php  1f  xw      C   vendor/symfony/security-core/Validator/Constraints/UserPassword.php  1f  Y      L   vendor/symfony/security-core/Validator/Constraints/UserPasswordValidator.phpP  1fP  *㏤      $   vendor/symfony/security-core/LICENSE,  1f,  U      D   vendor/symfony/security-core/Test/AccessDecisionStrategyTestCase.php	  1f	        B   vendor/symfony/security-core/Signature/ExpiredSignatureStorage.php  1f        N   vendor/symfony/security-core/Signature/Exception/InvalidSignatureException.php  1f  [.ܤ      N   vendor/symfony/security-core/Signature/Exception/ExpiredSignatureException.php  1f  (:      :   vendor/symfony/security-core/Signature/SignatureHasher.php  1f  i      )   vendor/symfony/security-core/CHANGELOG.md  1f  sڱ      ;   vendor/symfony/security-core/Encoder/LegacyEncoderTrait.php  1f  O%      @   vendor/symfony/security-core/Encoder/EncoderFactoryInterface.php  1f  Յ      <   vendor/symfony/security-core/Encoder/BasePasswordEncoder.php
  1f
  ;-      >   vendor/symfony/security-core/Encoder/Pbkdf2PasswordEncoder.php-  1f-  m9Ԥ      7   vendor/symfony/security-core/Encoder/EncoderFactory.phpK!  1fK!  -      A   vendor/symfony/security-core/Encoder/PlaintextPasswordEncoder.php  1f  ]䟤      A   vendor/symfony/security-core/Encoder/PasswordEncoderInterface.php  1f  oM      >   vendor/symfony/security-core/Encoder/PasswordHasherAdapter.php*  1f*  I      >   vendor/symfony/security-core/Encoder/SodiumPasswordEncoder.php  1f  +	      A   vendor/symfony/security-core/Encoder/MigratingPasswordEncoder.php  1f  l      E   vendor/symfony/security-core/Encoder/MessageDigestPasswordEncoder.php  1f  K      D   vendor/symfony/security-core/Encoder/SelfSaltingEncoderInterface.php  1f  s      D   vendor/symfony/security-core/Encoder/LegacyPasswordHasherEncoder.php%  1f%  Ah      <   vendor/symfony/security-core/Encoder/UserPasswordEncoder.php2  1f2  
Xh4      >   vendor/symfony/security-core/Encoder/PasswordHasherEncoder.phpF  1fF  ڈդ      >   vendor/symfony/security-core/Encoder/NativePasswordEncoder.php  1f        >   vendor/symfony/security-core/Encoder/EncoderAwareInterface.phpC  1fC  w      E   vendor/symfony/security-core/Encoder/UserPasswordEncoderInterface.php6  1f6  '      C   vendor/symfony/security-core/Resources/translations/security.sq.xlfu  1fu  v      C   vendor/symfony/security-core/Resources/translations/security.ru.xlf  1f  m      C   vendor/symfony/security-core/Resources/translations/security.hy.xlf  1f  B      C   vendor/symfony/security-core/Resources/translations/security.fr.xlfU  1fU  $      C   vendor/symfony/security-core/Resources/translations/security.fa.xlf  1f  K      C   vendor/symfony/security-core/Resources/translations/security.pl.xlf  1f  u      C   vendor/symfony/security-core/Resources/translations/security.sv.xlf  1f  cn      C   vendor/symfony/security-core/Resources/translations/security.el.xlf8  1f8  yva      H   vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf  1f  z'U      C   vendor/symfony/security-core/Resources/translations/security.en.xlfl  1fl  gBZ      C   vendor/symfony/security-core/Resources/translations/security.ja.xlf  1f  H      F   vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf  1f  iH!      C   vendor/symfony/security-core/Resources/translations/security.no.xlf  1f  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.vi.xlf,  1f,  a      C   vendor/symfony/security-core/Resources/translations/security.ur.xlf  1f  g      C   vendor/symfony/security-core/Resources/translations/security.nn.xlf  1f  l      C   vendor/symfony/security-core/Resources/translations/security.nl.xlf  1f        C   vendor/symfony/security-core/Resources/translations/security.cy.xlfv  1fv  FŤ      C   vendor/symfony/security-core/Resources/translations/security.af.xlf  1f  ojo      C   vendor/symfony/security-core/Resources/translations/security.lv.xlf  1f  E֤      C   vendor/symfony/security-core/Resources/translations/security.ar.xlf  1f  OD      C   vendor/symfony/security-core/Resources/translations/security.lb.xlf)  1f)  z7      C   vendor/symfony/security-core/Resources/translations/security.tr.xlfe  1fe  lx+      C   vendor/symfony/security-core/Resources/translations/security.lt.xlfv  1fv  @Ȥ      F   vendor/symfony/security-core/Resources/translations/security.zh_CN.xlfw  1fw  
ޘN      C   vendor/symfony/security-core/Resources/translations/security.ca.xlf  1f  
      C   vendor/symfony/security-core/Resources/translations/security.be.xlf.  1f.  
ZZ      C   vendor/symfony/security-core/Resources/translations/security.th.xlf  1f  x=ݤ      C   vendor/symfony/security-core/Resources/translations/security.uz.xlfl  1fl  M      C   vendor/symfony/security-core/Resources/translations/security.mk.xlf  1f  ڞ      C   vendor/symfony/security-core/Resources/translations/security.bs.xlf  1f  %}o      C   vendor/symfony/security-core/Resources/translations/security.bg.xlf  1f  .>-      H   vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf  1f         C   vendor/symfony/security-core/Resources/translations/security.uk.xlf  1f  6V      F   vendor/symfony/security-core/Resources/translations/security.zh_TW.xlfq  1fq  Ș      C   vendor/symfony/security-core/Resources/translations/security.cs.xlf  1f  hr      C   vendor/symfony/security-core/Resources/translations/security.tl.xlf  1f  %$      C   vendor/symfony/security-core/Resources/translations/security.my.xlf  1f  [v      C   vendor/symfony/security-core/Resources/translations/security.nb.xlf  1f  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.mn.xlf  1f  އ      C   vendor/symfony/security-core/Resources/translations/security.az.xlf^  1f^  9      C   vendor/symfony/security-core/Resources/translations/security.eu.xlf  1f  bs`      C   vendor/symfony/security-core/Resources/translations/security.he.xlf^  1f^  [I*      C   vendor/symfony/security-core/Resources/translations/security.hr.xlf[  1f[        C   vendor/symfony/security-core/Resources/translations/security.pt.xlf  1f  5>      C   vendor/symfony/security-core/Resources/translations/security.et.xlf  1f  s      C   vendor/symfony/security-core/Resources/translations/security.de.xlfV  1fV  :      C   vendor/symfony/security-core/Resources/translations/security.sl.xlf  1f  ڤ      C   vendor/symfony/security-core/Resources/translations/security.it.xlf  1f  |LQ      C   vendor/symfony/security-core/Resources/translations/security.gl.xlf8  1f8  Ϗ      C   vendor/symfony/security-core/Resources/translations/security.es.xlfQ  1fQ  cP)      C   vendor/symfony/security-core/Resources/translations/security.hu.xlf:  1f:  KY      C   vendor/symfony/security-core/Resources/translations/security.da.xlf  1f  mm      C   vendor/symfony/security-core/Resources/translations/security.fi.xlf  1f   T      C   vendor/symfony/security-core/Resources/translations/security.id.xlf  1f  x"      C   vendor/symfony/security-core/Resources/translations/security.sk.xlf  1f  +7e      C   vendor/symfony/security-core/Resources/translations/security.ro.xlfy  1fy  Aze      9   vendor/symfony/security-core/User/InMemoryUserChecker.php  1f  X$      3   vendor/symfony/security-core/User/UserInterface.php
  1f
  f^      ;   vendor/symfony/security-core/User/UserProviderInterface.php	  1f	  %TX      *   vendor/symfony/security-core/User/User.php  1f  b      9   vendor/symfony/security-core/User/MissingUserProvider.php  1f  ɺ      N   vendor/symfony/security-core/User/LegacyPasswordAuthenticatedUserInterface.php1  1f1  ,      ?   vendor/symfony/security-core/User/PasswordUpgraderInterface.php  1f        2   vendor/symfony/security-core/User/InMemoryUser.php  1f  ܿ{      :   vendor/symfony/security-core/User/InMemoryUserProvider.php}  1f}  $      8   vendor/symfony/security-core/User/EquatableInterface.php  1f  -\      H   vendor/symfony/security-core/User/PasswordAuthenticatedUserInterface.php  1f  hΤ      :   vendor/symfony/security-core/User/UserCheckerInterface.php,  1f,  	      1   vendor/symfony/security-core/User/UserChecker.php  1f  c'      7   vendor/symfony/security-core/User/ChainUserProvider.php  1f  e{      &   vendor/symfony/security-core/README.md  1f  EK      L   vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.phpW  1fW  "      I   vendor/symfony/security-core/Authorization/ExpressionLanguageProvider.php  1f  `u      M   vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php  1f  {0      D   vendor/symfony/security-core/Authorization/AccessDecisionManager.phpa  1fa  3      M   vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php  1f  ҟ      C   vendor/symfony/security-core/Authorization/Voter/VoterInterface.php  1f  >      L   vendor/symfony/security-core/Authorization/Voter/CacheableVoterInterface.php~  1f~  9      D   vendor/symfony/security-core/Authorization/Voter/ExpressionVoter.php
  1f
  &      G   vendor/symfony/security-core/Authorization/Voter/RoleHierarchyVoter.phpU  1fU  `F      C   vendor/symfony/security-core/Authorization/Voter/TraceableVoter.php  1f  ^      :   vendor/symfony/security-core/Authorization/Voter/Voter.php

  1f

        >   vendor/symfony/security-core/Authorization/Voter/RoleVoter.php  1f        G   vendor/symfony/security-core/Authorization/Voter/AuthenticatedVoter.phpZ  1fZ  P㳤      A   vendor/symfony/security-core/Authorization/ExpressionLanguage.php  1f        C   vendor/symfony/security-core/Authorization/AuthorizationChecker.php  1f  t      H   vendor/symfony/security-core/Authorization/Strategy/PriorityStrategy.php/  1f/  cR      I   vendor/symfony/security-core/Authorization/Strategy/UnanimousStrategy.phpO  1fO  ȅ1٤      K   vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.phpV  1fV        I   vendor/symfony/security-core/Authorization/Strategy/ConsensusStrategy.php  1f        W   vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php]  1f]  pf      )   vendor/symfony/security-core/Security.php  1f  h}      @   vendor/symfony/security-core/Exception/AccessDeniedException.php  1f  a      D   vendor/symfony/security-core/Exception/InvalidCsrfTokenException.php  1f        :   vendor/symfony/security-core/Exception/LogoutException.php  1f  y'פ      9   vendor/symfony/security-core/Exception/LogicException.php  1f  $2      @   vendor/symfony/security-core/Exception/LazyResponseException.php  1f  _K      S   vendor/symfony/security-core/Exception/CustomUserMessageAuthenticationException.php  1f  2+V      =   vendor/symfony/security-core/Exception/ExceptionInterface.php  1f  ^      B   vendor/symfony/security-core/Exception/BadCredentialsException.php  1f  nh      ;   vendor/symfony/security-core/Exception/RuntimeException.php  1f  >
      <   vendor/symfony/security-core/Exception/DisabledException.php  1f  [Ω      A   vendor/symfony/security-core/Exception/TokenNotFoundException.php  1f  |jˤ      D   vendor/symfony/security-core/Exception/ProviderNotFoundException.php  1f  =x      F   vendor/symfony/security-core/Exception/SessionUnavailableException.php  1f  aE      C   vendor/symfony/security-core/Exception/InvalidArgumentException.php  1f  W.      B   vendor/symfony/security-core/Exception/AccountExpiredException.php  1f  MҤ      I   vendor/symfony/security-core/Exception/AuthenticationExpiredException.phpc  1fc  #m      D   vendor/symfony/security-core/Exception/UsernameNotFoundException.php  1f  ӯn      V   vendor/symfony/security-core/Exception/TooManyLoginAttemptsAuthenticationException.php  1f  xܤ      ?   vendor/symfony/security-core/Exception/CookieTheftException.php  1f  k      I   vendor/symfony/security-core/Exception/AuthenticationServiceException.php  1f  4!      C   vendor/symfony/security-core/Exception/UnsupportedUserException.phpJ  1fJ  jۤ      A   vendor/symfony/security-core/Exception/AccountStatusException.phpB  1fB  G      R   vendor/symfony/security-core/Exception/CustomUserMessageAccountStatusException.php  1f  Z^      N   vendor/symfony/security-core/Exception/InsufficientAuthenticationException.phpB  1fB  -      :   vendor/symfony/security-core/Exception/LockedException.php  1f  8      B   vendor/symfony/security-core/Exception/AuthenticationException.php  1f  yP      @   vendor/symfony/security-core/Exception/UserNotFoundException.phpv	  1fv	        U   vendor/symfony/security-core/Exception/AuthenticationCredentialsNotFoundException.php  1f  l.      F   vendor/symfony/security-core/Exception/CredentialsExpiredException.php  1f  EXΤ      C   vendor/symfony/security-core/Authentication/Token/AbstractToken.php9'  1f9'  ي      ?   vendor/symfony/security-core/Authentication/Token/NullToken.php
  1f
  Sˤ      D   vendor/symfony/security-core/Authentication/Token/AnonymousToken.php  1f  k{      W   vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php  1f        J   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.phpv  1fv  d=      S   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php  1f  kcZޤ      E   vendor/symfony/security-core/Authentication/Token/RememberMeToken.php  1f  [      E   vendor/symfony/security-core/Authentication/Token/SwitchUserToken.phpi  1fi  8      K   vendor/symfony/security-core/Authentication/Token/PreAuthenticatedToken.php  1f  ڎ~      D   vendor/symfony/security-core/Authentication/Token/TokenInterface.phpz  1fz  ʒ      K   vendor/symfony/security-core/Authentication/Token/UsernamePasswordToken.php
  1f
  q      T   vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.phpx  1fx  O
      K   vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.php  1f  C      S   vendor/symfony/security-core/Authentication/Provider/UserAuthenticationProvider.phpF  1fF  jʞ      R   vendor/symfony/security-core/Authentication/Provider/DaoAuthenticationProvider.php  1f  R{      W   vendor/symfony/security-core/Authentication/Provider/LdapBindAuthenticationProvider.php  1f  I	      X   vendor/symfony/security-core/Authentication/Provider/AuthenticationProviderInterface.phpY  1fY  'Xs      _   vendor/symfony/security-core/Authentication/Provider/PreAuthenticatedAuthenticationProvider.php
  1f
  %J      Y   vendor/symfony/security-core/Authentication/Provider/RememberMeAuthenticationProvider.php!  1f!  M      X   vendor/symfony/security-core/Authentication/Provider/AnonymousAuthenticationProvider.php  1f  `      M   vendor/symfony/security-core/Authentication/AuthenticationProviderManager.php  1f  Ա      S   vendor/symfony/security-core/Authentication/RememberMe/PersistentTokenInterface.php
  1f
  Ӥ      P   vendor/symfony/security-core/Authentication/RememberMe/InMemoryTokenProvider.php  1f        M   vendor/symfony/security-core/Authentication/RememberMe/CacheTokenVerifier.php	  1f	  Jp      J   vendor/symfony/security-core/Authentication/RememberMe/PersistentToken.php  1f  0@f      Q   vendor/symfony/security-core/Authentication/RememberMe/TokenVerifierInterface.php  1f  ä      Q   vendor/symfony/security-core/Authentication/RememberMe/TokenProviderInterface.php  1f  GU=      N   vendor/symfony/security-core/Authentication/AuthenticationManagerInterface.php  1f  {<      A   vendor/symfony/security-core/Event/AuthenticationSuccessEvent.phpu  1fu        :   vendor/symfony/security-core/Event/AuthenticationEvent.phpX  1fX  +Y      A   vendor/symfony/security-core/Event/AuthenticationFailureEvent.phps  1fs  KGM      0   vendor/symfony/security-core/Event/VoteEvent.php   1f   (͐      *   vendor/symfony/security-core/composer.jsonu  1fu  9      5   vendor/symfony/security-core/AuthenticationEvents.php  1f  E      ,   vendor/symfony/deprecation-contracts/LICENSE,  1f,  K      1   vendor/symfony/deprecation-contracts/CHANGELOG.md   1f   h{#      1   vendor/symfony/deprecation-contracts/function.php  1f  rg      .   vendor/symfony/deprecation-contracts/README.md  1f  3      2   vendor/symfony/deprecation-contracts/composer.jsonS  1fS  IN>      (   vendor/symfony/routing/CompiledRoute.php}  1f}  _         vendor/symfony/routing/LICENSE,  1f,  U      (   vendor/symfony/routing/RouteCompiler.phpB9  1fB9  c      #   vendor/symfony/routing/CHANGELOG.md/  1f/  	      )   vendor/symfony/routing/RequestContext.php  1f  tK      +   vendor/symfony/routing/Annotation/Route.phpy  1fy  #L      :   vendor/symfony/routing/Matcher/RequestMatcherInterface.php?  1f?  С      =   vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php  1f        -   vendor/symfony/routing/Matcher/UrlMatcher.phpW$  1fW$  Y      B   vendor/symfony/routing/Matcher/RedirectableUrlMatcherInterface.php  1f  ۤ      6   vendor/symfony/routing/Matcher/UrlMatcherInterface.php  1f        5   vendor/symfony/routing/Matcher/CompiledUrlMatcher.php  1f  *g      6   vendor/symfony/routing/Matcher/TraceableUrlMatcher.php  1f  6      B   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherDumper.php1J  1f1J  mK.      7   vendor/symfony/routing/Matcher/Dumper/MatcherDumper.php!  1f!  !Ҵ      @   vendor/symfony/routing/Matcher/Dumper/MatcherDumperInterface.php  1f  SQ      A   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherTrait.php;  1f;  6H      @   vendor/symfony/routing/Matcher/Dumper/StaticPrefixCollection.php  1f  o      9   vendor/symfony/routing/Matcher/RedirectableUrlMatcher.phpa  1fa  |:          vendor/symfony/routing/README.md  1f  .      9   vendor/symfony/routing/Generator/CompiledUrlGenerator.php
  1f
  PgZ      1   vendor/symfony/routing/Generator/UrlGenerator.phpZ=  1fZ=  5      F   vendor/symfony/routing/Generator/ConfigurableRequirementsInterface.php  1f  )      :   vendor/symfony/routing/Generator/UrlGeneratorInterface.php
  1f
  #Ѵ%      D   vendor/symfony/routing/Generator/Dumper/GeneratorDumperInterface.php  1f  )_      F   vendor/symfony/routing/Generator/Dumper/CompiledUrlGeneratorDumper.php  1f  9ݥ      ;   vendor/symfony/routing/Generator/Dumper/GeneratorDumper.php'  1f'  V6      *   vendor/symfony/routing/RouteCollection.php,  1f,  n      7   vendor/symfony/routing/RequestContextAwareInterface.php/  1f/  h3      7   vendor/symfony/routing/Loader/AnnotationClassLoader.phpO4  1fO4  &ϮR      0   vendor/symfony/routing/Loader/YamlFileLoader.php0  1f0  {!      6   vendor/symfony/routing/Loader/AnnotationFileLoader.php
  1f
  #      <   vendor/symfony/routing/Loader/schema/routing/routing-1.0.xsd6  1f6  Vܤ      /   vendor/symfony/routing/Loader/PhpFileLoader.phpJ	  1fJ	  |%      /   vendor/symfony/routing/Loader/XmlFileLoader.phpqE  1fqE  }[
      .   vendor/symfony/routing/Loader/ObjectLoader.php  1f  _ʲҤ      ?   vendor/symfony/routing/Loader/Configurator/Traits/HostTrait.php  1f  Es2      A   vendor/symfony/routing/Loader/Configurator/Traits/PrefixTrait.php	
  1f	
  $      I   vendor/symfony/routing/Loader/Configurator/Traits/LocalizedRouteTrait.php&
  1f&
  p eݤ      @   vendor/symfony/routing/Loader/Configurator/Traits/RouteTrait.php  1f  =/'
      >   vendor/symfony/routing/Loader/Configurator/Traits/AddTrait.php9  1f9        @   vendor/symfony/routing/Loader/Configurator/RouteConfigurator.php  1f  /7      E   vendor/symfony/routing/Loader/Configurator/CollectionConfigurator.php  1f  vŤ      @   vendor/symfony/routing/Loader/Configurator/AliasConfigurator.php  1f  }      B   vendor/symfony/routing/Loader/Configurator/RoutingConfigurator.php  1f  蝤      A   vendor/symfony/routing/Loader/Configurator/ImportConfigurator.php  1f  Ww      1   vendor/symfony/routing/Loader/ContainerLoader.php  1f  {)      1   vendor/symfony/routing/Loader/DirectoryLoader.php&  1f&  \      0   vendor/symfony/routing/Loader/GlobFileLoader.phpK  1fK  x      /   vendor/symfony/routing/Loader/ClosureLoader.phpR  1fR  f:+      ;   vendor/symfony/routing/Loader/AnnotationDirectoryLoader.php
  1f
  JT          vendor/symfony/routing/Route.php<0  1f<0  ֩      1   vendor/symfony/routing/RouteCollectionBuilder.php%  1f%  YM      *   vendor/symfony/routing/RouterInterface.php"  1f"  WF      !   vendor/symfony/routing/Router.phpc1  1fc1  |
C      1   vendor/symfony/routing/RouteCompilerInterface.php   1f             vendor/symfony/routing/Alias.php	  1f	        B   vendor/symfony/routing/DependencyInjection/RoutingResolverPass.php  1f  g<      >   vendor/symfony/routing/Exception/ResourceNotFoundException.php2  1f2  FL"1      7   vendor/symfony/routing/Exception/ExceptionInterface.php  1f  &      ;   vendor/symfony/routing/Exception/RouteNotFoundException.php  1f  	C      5   vendor/symfony/routing/Exception/RuntimeException.php  1f  $>G      H   vendor/symfony/routing/Exception/MissingMandatoryParametersException.php@  1f@  Tv      =   vendor/symfony/routing/Exception/InvalidArgumentException.php  1f  ֤      >   vendor/symfony/routing/Exception/MethodNotAllowedException.phpJ  1fJ  u#      =   vendor/symfony/routing/Exception/NoConfigurationException.php  1f  r      D   vendor/symfony/routing/Exception/RouteCircularReferenceException.php>  1f>  \T      >   vendor/symfony/routing/Exception/InvalidParameterException.php  1f  !N      $   vendor/symfony/routing/composer.json  1f        ?   vendor/symfony/service-contracts/ServiceSubscriberInterface.php  1f  L      @   vendor/symfony/service-contracts/Attribute/SubscribedService.php2  1f2  UȤ      7   vendor/symfony/service-contracts/Attribute/Required.php  1f  `e      (   vendor/symfony/service-contracts/LICENSE,  1f,        @   vendor/symfony/service-contracts/Test/ServiceLocatorTestCase.php  1f         <   vendor/symfony/service-contracts/Test/ServiceLocatorTest.php  1f  ]1C      -   vendor/symfony/service-contracts/CHANGELOG.md   1f   h{#      *   vendor/symfony/service-contracts/README.mdL  1fL  Ȥ      3   vendor/symfony/service-contracts/ResetInterface.php  1f  {Ф      =   vendor/symfony/service-contracts/ServiceProviderInterface.php  1f  yl      ;   vendor/symfony/service-contracts/ServiceSubscriberTrait.php  1f  [|^      8   vendor/symfony/service-contracts/ServiceLocatorTrait.php  1f  0"i      .   vendor/symfony/service-contracts/composer.json  1f  x#S      9   vendor/symfony/property-info/PhpStan/NameScopeFactory.php  1f  w      2   vendor/symfony/property-info/PhpStan/NameScope.php  1f  ~w      ?   vendor/symfony/property-info/PropertyInfoExtractorInterface.php  1f  U-R      %   vendor/symfony/property-info/Type.php!  1f!  B      $   vendor/symfony/property-info/LICENSE,  1f,  H      6   vendor/symfony/property-info/Util/PhpDocTypeHelper.php?  1f?  ّ      7   vendor/symfony/property-info/Util/PhpStanTypeHelper.php  1f  .v{      )   vendor/symfony/property-info/CHANGELOG.md  1f  :      ;   vendor/symfony/property-info/PropertyInfoCacheExtractor.php
  1f
  Kai      D   vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php  1f  xBy\      A   vendor/symfony/property-info/PropertyAccessExtractorInterface.php  1f  2$C      ?   vendor/symfony/property-info/PropertyTypeExtractorInterface.phpQ  1fQ        1   vendor/symfony/property-info/PropertyReadInfo.php  1f  KΤ      ;   vendor/symfony/property-info/Extractor/PhpStanExtractor.php*  1f*  _0      >   vendor/symfony/property-info/Extractor/SerializerExtractor.php  1f  8      ?   vendor/symfony/property-info/Extractor/ConstructorExtractor.php  1f  X5      T   vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php  1f  jv\      >   vendor/symfony/property-info/Extractor/ReflectionExtractor.phpM  1fM  M]      :   vendor/symfony/property-info/Extractor/PhpDocExtractor.php/  1f/  Z      F   vendor/symfony/property-info/PropertyDescriptionExtractorInterface.phpP  1fP  &      2   vendor/symfony/property-info/PropertyWriteInfo.phpc  1fc  4b(}      &   vendor/symfony/property-info/README.md  1f  '7      C   vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php  1f  :|`դ      H   vendor/symfony/property-info/PropertyInitializableExtractorInterface.php  1f  OW      6   vendor/symfony/property-info/PropertyInfoExtractor.php^  1f^  ji      ?   vendor/symfony/property-info/PropertyListExtractorInterface.php  1f  J$      P   vendor/symfony/property-info/DependencyInjection/PropertyInfoConstructorPass.php  1f  E      E   vendor/symfony/property-info/DependencyInjection/PropertyInfoPass.php  1f  ֤      *   vendor/symfony/property-info/composer.json  1f  X)      3   vendor/symfony/http-foundation/StreamedResponse.phpE  1fE  񠈤      :   vendor/symfony/http-foundation/RequestMatcherInterface.php  1f  XY      5   vendor/symfony/http-foundation/BinaryFileResponse.php6  1f6  C      +   vendor/symfony/http-foundation/InputBag.phpA  1fA  m      I   vendor/symfony/http-foundation/RateLimiter/AbstractRequestRateLimiter.php  1f  c      J   vendor/symfony/http-foundation/RateLimiter/RequestRateLimiterInterface.php
  1f
  ¤      &   vendor/symfony/http-foundation/LICENSE,  1f,  U      J   vendor/symfony/http-foundation/Test/Constraint/ResponseCookieValueSame.php  1f  i      D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasCookie.php  1f  *      I   vendor/symfony/http-foundation/Test/Constraint/ResponseStatusCodeSame.phpU  1fU  Q      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsSuccessful.php  1f  -      J   vendor/symfony/http-foundation/Test/Constraint/ResponseIsUnprocessable.php  1f  F      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsRedirected.php  1f  Ƥ      D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasHeader.php  1f  Y      L   vendor/symfony/http-foundation/Test/Constraint/RequestAttributeValueSame.php  1f  f,      E   vendor/symfony/http-foundation/Test/Constraint/ResponseFormatSame.phpb  1fb  t$ؤ      E   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderSame.php:  1f:  0W      ,   vendor/symfony/http-foundation/ServerBag.php  1f  (      +   vendor/symfony/http-foundation/CHANGELOG.mdD=  1fD=  N|      ,   vendor/symfony/http-foundation/File/File.php7  1f7  qsF      .   vendor/symfony/http-foundation/File/Stream.phpE  1fE  Z      4   vendor/symfony/http-foundation/File/UploadedFile.phpa(  1fa(  i$p      G   vendor/symfony/http-foundation/File/Exception/AccessDeniedException.phpi  1fi  Y      A   vendor/symfony/http-foundation/File/Exception/NoFileException.php  1f  -A      F   vendor/symfony/http-foundation/File/Exception/IniSizeFileException.php  1f  I      J   vendor/symfony/http-foundation/File/Exception/CannotWriteFileException.php  1f  :ݤ      H   vendor/symfony/http-foundation/File/Exception/ExtensionFileException.php  1f  )      ?   vendor/symfony/http-foundation/File/Exception/FileException.php  1f  j2      A   vendor/symfony/http-foundation/File/Exception/UploadException.php  1f  S      I   vendor/symfony/http-foundation/File/Exception/UnexpectedTypeException.php3  1f3  t*      G   vendor/symfony/http-foundation/File/Exception/FormSizeFileException.php  1f  m;      G   vendor/symfony/http-foundation/File/Exception/FileNotFoundException.phpY  1fY  {WɈ      F   vendor/symfony/http-foundation/File/Exception/PartialFileException.php  1f  *      G   vendor/symfony/http-foundation/File/Exception/NoTmpDirFileException.php  1f  n      +   vendor/symfony/http-foundation/Response.phpH  1fH  N"      )   vendor/symfony/http-foundation/Cookie.php-  1f-  Cw      /   vendor/symfony/http-foundation/AcceptHeader.php<  1f<  d      1   vendor/symfony/http-foundation/RequestMatcher.php:  1f:  &      4   vendor/symfony/http-foundation/ResponseHeaderBag.php  1f  &G      .   vendor/symfony/http-foundation/HeaderUtils.php$  1f$  4      /   vendor/symfony/http-foundation/RequestStack.phps  1fs  ˾'      3   vendor/symfony/http-foundation/RedirectResponse.php8  1f8        /   vendor/symfony/http-foundation/JsonResponse.phpw  1fw  (v      (   vendor/symfony/http-foundation/README.md  1f  %      *   vendor/symfony/http-foundation/Request.php
 1f
       ;   vendor/symfony/http-foundation/ExpressionRequestMatcher.php  1f   L      /   vendor/symfony/http-foundation/ParameterBag.php  1f  Dd      *   vendor/symfony/http-foundation/IpUtils.php  1f  άͤ      3   vendor/symfony/http-foundation/AcceptHeaderItem.phpQ
  1fQ
  1      ,   vendor/symfony/http-foundation/UrlHelper.php  1f  {      ,   vendor/symfony/http-foundation/HeaderBag.php0  1f0  ȥ_      *   vendor/symfony/http-foundation/FileBag.php(  1f(  ɿ      H   vendor/symfony/http-foundation/Exception/ConflictingHeadersException.php  1f  .>+w      F   vendor/symfony/http-foundation/Exception/RequestExceptionInterface.php  1f  R      @   vendor/symfony/http-foundation/Exception/BadRequestException.php  1f  դ      I   vendor/symfony/http-foundation/Exception/SuspiciousOperationException.php  1f  㝜      :   vendor/symfony/http-foundation/Exception/JsonException.php  1f  ~|mW      E   vendor/symfony/http-foundation/Exception/SessionNotFoundException.phpY  1fY  1      ,   vendor/symfony/http-foundation/composer.jsonI  1fI  I      J   vendor/symfony/http-foundation/Session/Attribute/AttributeBagInterface.php  1f        K   vendor/symfony/http-foundation/Session/Attribute/NamespacedAttributeBag.php  1f  "      A   vendor/symfony/http-foundation/Session/Attribute/AttributeBag.php  1f  z<      B   vendor/symfony/http-foundation/Session/SessionFactoryInterface.php  1f  f*      2   vendor/symfony/http-foundation/Session/Session.php  1f  U/6      7   vendor/symfony/http-foundation/Session/SessionUtils.phpt  1ft  OY      M   vendor/symfony/http-foundation/Session/Storage/Handler/NullSessionHandler.php  1f  Uޤ      Q   vendor/symfony/http-foundation/Session/Storage/Handler/AbstractSessionHandler.php=  1f=        P   vendor/symfony/http-foundation/Session/Storage/Handler/SessionHandlerFactory.php  1f  '      L   vendor/symfony/http-foundation/Session/Storage/Handler/PdoSessionHandler.php  1f  3      T   vendor/symfony/http-foundation/Session/Storage/Handler/MarshallingSessionHandler.phpm	  1fm	  8      S   vendor/symfony/http-foundation/Session/Storage/Handler/NativeFileSessionHandler.php  1f  :^      R   vendor/symfony/http-foundation/Session/Storage/Handler/MigratingSessionHandler.phpJ  1fJ  ]Eq      M   vendor/symfony/http-foundation/Session/Storage/Handler/IdentityMarshaller.php  1f  R=p      P   vendor/symfony/http-foundation/Session/Storage/Handler/MongoDbSessionHandler.php  1f  DT      N   vendor/symfony/http-foundation/Session/Storage/Handler/RedisSessionHandler.php  1f  d      O   vendor/symfony/http-foundation/Session/Storage/Handler/StrictSessionHandler.php
  1f
  oqФ      R   vendor/symfony/http-foundation/Session/Storage/Handler/MemcachedSessionHandler.phpW
  1fW
  Rj      G   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorage.php?  1f?        J   vendor/symfony/http-foundation/Session/Storage/SessionStorageInterface.php=  1f=  ʒ      P   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorageFactory.php  1f  
TҤ      L   vendor/symfony/http-foundation/Session/Storage/Proxy/SessionHandlerProxy.phpy
  1fy
  s      F   vendor/symfony/http-foundation/Session/Storage/Proxy/AbstractProxy.php	  1f	  &.      N   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorageFactory.phpc  1fc        J   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorage.php  1f   3      Q   vendor/symfony/http-foundation/Session/Storage/SessionStorageFactoryInterface.phpw  1fw  ]n      H   vendor/symfony/http-foundation/Session/Storage/ServiceSessionFactory.php  1f  }       I   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorage.php  1f  B      Q   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorageFactory.php  1f  *5>      >   vendor/symfony/http-foundation/Session/Storage/MetadataBag.php  1f  91      J   vendor/symfony/http-foundation/Session/Storage/MockArraySessionStorage.phpu  1fu  ̤      ;   vendor/symfony/http-foundation/Session/SessionInterface.phpq  1fq   te      C   vendor/symfony/http-foundation/Session/Flash/AutoExpireFlashBag.php
  1f
  Ճ5      B   vendor/symfony/http-foundation/Session/Flash/FlashBagInterface.phpf  1ff  3      9   vendor/symfony/http-foundation/Session/Flash/FlashBag.php
  1f
  ۖV      9   vendor/symfony/http-foundation/Session/SessionFactory.php  1f  bE;      :   vendor/symfony/http-foundation/Session/SessionBagProxy.php2  1f2  W@      >   vendor/symfony/http-foundation/Session/SessionBagInterface.php\  1f\  hI      ,   vendor/symfony/var-exporter/Instantiator.php  1f  Yd      #   vendor/symfony/var-exporter/LICENSE,  1f,        (   vendor/symfony/var-exporter/CHANGELOG.md   1f         /   vendor/symfony/var-exporter/Internal/Values.php  1f  `ǿ      1   vendor/symfony/var-exporter/Internal/Hydrator.phpr  1fr  :c      1   vendor/symfony/var-exporter/Internal/Registry.php>  1f>  M,      2   vendor/symfony/var-exporter/Internal/Reference.php;  1f;  *Q/ˤ      1   vendor/symfony/var-exporter/Internal/Exporter.phpA  1fA  h'      %   vendor/symfony/var-exporter/README.md  1f  8      +   vendor/symfony/var-exporter/VarExporter.php  1f   
      <   vendor/symfony/var-exporter/Exception/ExceptionInterface.phpd  1fd        @   vendor/symfony/var-exporter/Exception/ClassNotFoundException.php1  1f1  w w      F   vendor/symfony/var-exporter/Exception/NotInstantiableTypeException.php>  1f>  }      )   vendor/symfony/var-exporter/composer.json  1f  ҽe      E   vendor/symfony/error-handler/ErrorEnhancer/ErrorEnhancerInterface.php	  1f	  ޺      I   vendor/symfony/error-handler/ErrorEnhancer/ClassNotFoundErrorEnhancer.php  1f  pn[      M   vendor/symfony/error-handler/ErrorEnhancer/UndefinedFunctionErrorEnhancer.phpK  1fK  -      K   vendor/symfony/error-handler/ErrorEnhancer/UndefinedMethodErrorEnhancer.php  1f  a      $   vendor/symfony/error-handler/LICENSE,  1f,  զ_Ϥ      )   vendor/symfony/error-handler/CHANGELOG.md|  1f|  n:t      B   vendor/symfony/error-handler/Resources/bin/patch-type-declarations
  1f
  R      M   vendor/symfony/error-handler/Resources/bin/extract-tentative-return-types.php   1f   mE      ?   vendor/symfony/error-handler/Resources/views/exception.html.php>  1f>  ˚      <   vendor/symfony/error-handler/Resources/views/traces.html.php]	  1f]	  m}      A   vendor/symfony/error-handler/Resources/views/traces_text.html.php  1f  j+2      :   vendor/symfony/error-handler/Resources/views/logs.html.php)	  1f)	  _&      ;   vendor/symfony/error-handler/Resources/views/trace.html.phpU  1fU  4K'      ;   vendor/symfony/error-handler/Resources/views/error.html.php  1f  < z      D   vendor/symfony/error-handler/Resources/views/exception_full.html.php  1f        ?   vendor/symfony/error-handler/Resources/assets/css/exception.css=7  1f=7  9@n      D   vendor/symfony/error-handler/Resources/assets/css/exception_full.css
  1f
  *bc      ;   vendor/symfony/error-handler/Resources/assets/css/error.css  1f  %7      J   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square.svgQ  1fQ  p      B   vendor/symfony/error-handler/Resources/assets/images/icon-book.svg  1f        E   vendor/symfony/error-handler/Resources/assets/images/icon-support.svgz  1fz  S̤      F   vendor/symfony/error-handler/Resources/assets/images/chevron-right.svg  1f        J   vendor/symfony/error-handler/Resources/assets/images/symfony-ghost.svg.php   1f   9꒤      I   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square.svg  1f  U      E   vendor/symfony/error-handler/Resources/assets/images/symfony-logo.svg  1f  %0ɤ      B   vendor/symfony/error-handler/Resources/assets/images/icon-copy.svg	  1f	  "Ȗ      G   vendor/symfony/error-handler/Resources/assets/images/favicon.png.base64  1f  "i^      K   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square-o.svg  1f  -      L   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square-o.svg  1f  s0      =   vendor/symfony/error-handler/Resources/assets/js/exception.js4  1f4  2d      8   vendor/symfony/error-handler/Internal/TentativeTypes.php  1f        &   vendor/symfony/error-handler/Debug.phpB  1fB  ;~      F   vendor/symfony/error-handler/ErrorRenderer/SerializerErrorRenderer.phpI  1fI  唤      ?   vendor/symfony/error-handler/ErrorRenderer/CliErrorRenderer.php  1f  0      E   vendor/symfony/error-handler/ErrorRenderer/ErrorRendererInterface.php  1f  5g      @   vendor/symfony/error-handler/ErrorRenderer/HtmlErrorRenderer.php	`  1f	`  ۤ՜      &   vendor/symfony/error-handler/README.md=  1f=  \      1   vendor/symfony/error-handler/DebugClassLoader.phpv  1fv  r%      0   vendor/symfony/error-handler/BufferingLogger.php"  1f"  i9-      -   vendor/symfony/error-handler/ErrorHandler.phpv  1fv  F*b      /   vendor/symfony/error-handler/ThrowableUtils.php  1f  ~+G      7   vendor/symfony/error-handler/Error/OutOfMemoryError.php[  1f[  N      ;   vendor/symfony/error-handler/Error/UndefinedMethodError.php^  1f^  +3
      1   vendor/symfony/error-handler/Error/FatalError.php0  1f0  䩤      =   vendor/symfony/error-handler/Error/UndefinedFunctionError.php`  1f`  ]W,      9   vendor/symfony/error-handler/Error/ClassNotFoundError.php\  1f\  3Xޤ      ;   vendor/symfony/error-handler/Exception/FlattenException.php(  1f(  i	      ?   vendor/symfony/error-handler/Exception/SilencedErrorContext.php]  1f]  SƤ      *   vendor/symfony/error-handler/composer.json:  1f:  P      4   vendor/symfony/cache-contracts/CallbackInterface.phpG  1fG        0   vendor/symfony/cache-contracts/ItemInterface.php$  1f$        &   vendor/symfony/cache-contracts/LICENSE,  1f,        +   vendor/symfony/cache-contracts/CHANGELOG.md   1f   h{#      1   vendor/symfony/cache-contracts/CacheInterface.php	  1f	  )W	      (   vendor/symfony/cache-contracts/README.mdH  1fH  Z#      -   vendor/symfony/cache-contracts/CacheTrait.php-
  1f-
  ]?      9   vendor/symfony/cache-contracts/TagAwareCacheInterface.php	  1f	        ,   vendor/symfony/cache-contracts/composer.jsong  1fg  (      7   vendor/symfony/dependency-injection/EnvVarProcessor.php*  1f*  Y      ;   vendor/symfony/dependency-injection/ContainerAwareTrait.phpj  1fj  N      B   vendor/symfony/dependency-injection/ExpressionLanguageProvider.php  1f  s      1   vendor/symfony/dependency-injection/Container.php(7  1f(7  XE      8   vendor/symfony/dependency-injection/ReverseContainer.php	  1f	        0   vendor/symfony/dependency-injection/Variable.php  1f  VB#      D   vendor/symfony/dependency-injection/Extension/ExtensionInterface.php  1f  Ƥ      ;   vendor/symfony/dependency-injection/Extension/Extension.php  1f  sj      K   vendor/symfony/dependency-injection/Extension/PrependExtensionInterface.php8  1f8  %i      Q   vendor/symfony/dependency-injection/Extension/ConfigurationExtensionInterface.phpS  1fS  )      ?   vendor/symfony/dependency-injection/Attribute/Autoconfigure.php\  1f\  SH      >   vendor/symfony/dependency-injection/Attribute/AsTaggedItem.php  1f  k      8   vendor/symfony/dependency-injection/Attribute/Target.php  1f  
S      6   vendor/symfony/dependency-injection/Attribute/When.php  1f  Xˤ      @   vendor/symfony/dependency-injection/Attribute/TaggedIterator.php=  1f=  *"      B   vendor/symfony/dependency-injection/Attribute/AutoconfigureTag.php  1f  	       ?   vendor/symfony/dependency-injection/Attribute/TaggedLocator.php<  1f<  Eͤ      +   vendor/symfony/dependency-injection/LICENSE,  1f,  U      0   vendor/symfony/dependency-injection/CHANGELOG.md9  1f9        Q   vendor/symfony/dependency-injection/Config/ContainerParametersResourceChecker.phpu  1fu  ʔs
      J   vendor/symfony/dependency-injection/Config/ContainerParametersResource.php  1f  J`      J   vendor/symfony/dependency-injection/Argument/ReferenceSetArgumentTrait.phpF  1fF  k[      A   vendor/symfony/dependency-injection/Argument/AbstractArgument.php  1f  v      D   vendor/symfony/dependency-injection/Argument/RewindableGenerator.php  1f  ?~\      G   vendor/symfony/dependency-injection/Argument/ServiceLocatorArgument.phpB  1fB  p3      >   vendor/symfony/dependency-injection/Argument/BoundArgument.php  1f  a      A   vendor/symfony/dependency-injection/Argument/IteratorArgument.php  1f  ba      G   vendor/symfony/dependency-injection/Argument/TaggedIteratorArgument.php
  1f
  2C      B   vendor/symfony/dependency-injection/Argument/ArgumentInterface.phpG  1fG  ﺔ      ?   vendor/symfony/dependency-injection/Argument/ServiceLocator.php9  1f9  ͞$      G   vendor/symfony/dependency-injection/Argument/ServiceClosureArgument.php  1f  vA      8   vendor/symfony/dependency-injection/ContainerBuilder.phpP  1fP  
Q      7   vendor/symfony/dependency-injection/ChildDefinition.php
  1f
  g      1   vendor/symfony/dependency-injection/Reference.php  1f  ^].      J   vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php:
  1f:
  ˒-      O   vendor/symfony/dependency-injection/ParameterBag/EnvPlaceholderParameterBag.php   1f   +L{      A   vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php{  1f{  ݇      J   vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.phpw  1fw  s      A   vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php  1f  BS      G   vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php_  1f_  nȤ      2   vendor/symfony/dependency-injection/Definition.phpW  1fW  $Sɤ      @   vendor/symfony/dependency-injection/EnvVarProcessorInterface.php  1f  }o>X      -   vendor/symfony/dependency-injection/README.mdC  1fC  <      :   vendor/symfony/dependency-injection/ContainerInterface.php#
  1f#
  a
|      9   vendor/symfony/dependency-injection/Loader/FileLoader.php5)  1f5)  *      =   vendor/symfony/dependency-injection/Loader/YamlFileLoader.php  1f  _Ӥ      O   vendor/symfony/dependency-injection/Loader/schema/dic/services/services-1.0.xsdr9  1fr9  -0      <   vendor/symfony/dependency-injection/Loader/PhpFileLoader.phpY!  1fY!  E      <   vendor/symfony/dependency-injection/Loader/XmlFileLoader.php  1f  D      <   vendor/symfony/dependency-injection/Loader/IniFileLoader.php  1f  uq7      P   vendor/symfony/dependency-injection/Loader/Configurator/ServicesConfigurator.php  1f  F$j      P   vendor/symfony/dependency-injection/Loader/Configurator/DefaultsConfigurator.php  1f  ƭb      Q   vendor/symfony/dependency-injection/Loader/Configurator/ReferenceConfigurator.php  1f  *b      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ClassTrait.php/  1f/  ݅      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/CallTrait.phpL  1fL        Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/SyntheticTrait.php  1f        P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PropertyTrait.phpd  1fd  k      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ArgumentTrait.php  1f  萯      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConfiguratorTrait.php  1f  ސ      N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ParentTrait.php  1f        O   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FactoryTrait.php  1f  ֍      K   vendor/symfony/dependency-injection/Loader/Configurator/Traits/TagTrait.php  1f  s      N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PublicTrait.php  1f  Z$Ѫ      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DecorateTrait.phpy  1fy  л*/      U   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutoconfigureTrait.phpC  1fC  V      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DeprecateTrait.phpR  1fR  ]*      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/BindTrait.phpS  1fS  #       L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/LazyTrait.php6  1f6  ~q      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FileTrait.phpE  1fE  L      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AbstractTrait.php  1f  F-      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ShareTrait.phpJ  1fJ  @	      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutowireTrait.phpK  1fK        P   vendor/symfony/dependency-injection/Loader/Configurator/AbstractConfigurator.php  1f  '0      X   vendor/symfony/dependency-injection/Loader/Configurator/ClosureReferenceConfigurator.php  1f  #y      K   vendor/symfony/dependency-injection/Loader/Configurator/EnvConfigurator.php0  1f0  pe      W   vendor/symfony/dependency-injection/Loader/Configurator/AbstractServiceConfigurator.php  1f  Crڠ      R   vendor/symfony/dependency-injection/Loader/Configurator/InstanceofConfigurator.php  1f  BрY      Q   vendor/symfony/dependency-injection/Loader/Configurator/ContainerConfigurator.php  1f  Ɣ      M   vendor/symfony/dependency-injection/Loader/Configurator/AliasConfigurator.php  1f  RF,b      U   vendor/symfony/dependency-injection/Loader/Configurator/InlineServiceConfigurator.php  1f  (Ё      Q   vendor/symfony/dependency-injection/Loader/Configurator/PrototypeConfigurator.php
  1f
  h      R   vendor/symfony/dependency-injection/Loader/Configurator/ParametersConfigurator.php  1f  o9-      O   vendor/symfony/dependency-injection/Loader/Configurator/ServiceConfigurator.php#  1f#  s˜ۤ      >   vendor/symfony/dependency-injection/Loader/DirectoryLoader.phpa  1fa  Ǥ      =   vendor/symfony/dependency-injection/Loader/GlobFileLoader.php  1f  9$      <   vendor/symfony/dependency-injection/Loader/ClosureLoader.php  1f  [      =   vendor/symfony/dependency-injection/LazyProxy/ProxyHelper.php
  1f
  <      K   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/DumperInterface.php  1f  lݴ      F   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/NullDumper.php  1f  aY      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/RealServiceInstantiator.php  1f  5'פ      T   vendor/symfony/dependency-injection/LazyProxy/Instantiator/InstantiatorInterface.phpx  1fx  9|      :   vendor/symfony/dependency-injection/ExpressionLanguage.phpd  1fd  b      6   vendor/symfony/dependency-injection/ServiceLocator.php>  1f>  J      6   vendor/symfony/dependency-injection/TypedReference.php  1f  2)      -   vendor/symfony/dependency-injection/Alias.php  1f  v%      U   vendor/symfony/dependency-injection/Exception/ParameterCircularReferenceException.php  1f  ?u      @   vendor/symfony/dependency-injection/Exception/LogicException.php  1f  }|Ȥ      F   vendor/symfony/dependency-injection/Exception/EnvNotFoundException.php  1f  &      L   vendor/symfony/dependency-injection/Exception/ParameterNotFoundException.phpQ
  1fQ
  \      D   vendor/symfony/dependency-injection/Exception/ExceptionInterface.php~  1f~        F   vendor/symfony/dependency-injection/Exception/OutOfBoundsException.php  1f  On      S   vendor/symfony/dependency-injection/Exception/ServiceCircularReferenceException.php  1f   +      J   vendor/symfony/dependency-injection/Exception/ServiceNotFoundException.php$  1f$   r      B   vendor/symfony/dependency-injection/Exception/RuntimeException.php	  1f	  
      J   vendor/symfony/dependency-injection/Exception/InvalidArgumentException.php'  1f'        H   vendor/symfony/dependency-injection/Exception/BadMethodCallException.php  1f  ,w      K   vendor/symfony/dependency-injection/Exception/AutowiringFailedException.php  1f  e      O   vendor/symfony/dependency-injection/Exception/InvalidParameterTypeException.php0  1f0  I      G   vendor/symfony/dependency-injection/Exception/EnvParameterException.php  1f  =&)      @   vendor/symfony/dependency-injection/TaggedContainerInterface.php  1f  ǝ      1   vendor/symfony/dependency-injection/Parameter.php|  1f|  nJ      E   vendor/symfony/dependency-injection/Compiler/DecoratorServicePass.php  1f   '      M   vendor/symfony/dependency-injection/Compiler/ResolveInvalidReferencesPass.phpK  1fK  A      L   vendor/symfony/dependency-injection/Compiler/ValidateEnvPlaceholdersPass.php  1f  Af      M   vendor/symfony/dependency-injection/Compiler/RegisterEnvVarProcessorsPass.php  1f  S/      T   vendor/symfony/dependency-injection/Compiler/RegisterAutoconfigureAttributesPass.php  1f         L   vendor/symfony/dependency-injection/Compiler/CheckDefinitionValidityPass.php  1f  _9      ;   vendor/symfony/dependency-injection/Compiler/PassConfig.php  1f  `Z      F   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraph.php~
  1f~
  FAaä      E   vendor/symfony/dependency-injection/Compiler/ResolveNoPreloadPass.phpX
  1fX
  L_;      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphNode.php	  1f	  H      J   vendor/symfony/dependency-injection/Compiler/CheckTypeDeclarationsPass.php1  1f1  1Fʤ      M   vendor/symfony/dependency-injection/Compiler/InlineServiceDefinitionsPass.php)  1f)  <`      H   vendor/symfony/dependency-injection/Compiler/ResolveFactoryClassPass.php  1f  /O      D   vendor/symfony/dependency-injection/Compiler/ResolveBindingsPass.php&  1f&   e      K   vendor/symfony/dependency-injection/Compiler/PriorityTaggedServiceTrait.phpS  1fS  *	+      M   vendor/symfony/dependency-injection/Compiler/RegisterReverseContainerPass.php	  1f	        F   vendor/symfony/dependency-injection/Compiler/AbstractRecursivePass.php3%  1f3%  xI      R   vendor/symfony/dependency-injection/Compiler/AliasDeprecatedPublicServicesPass.php	
  1f	
  Ls]      R   vendor/symfony/dependency-injection/Compiler/ResolveInstanceofConditionalsPass.phpv  1fv  vW      O   vendor/symfony/dependency-injection/Compiler/ResolveReferencesToAliasesPass.php  1f  p      K   vendor/symfony/dependency-injection/Compiler/CheckArgumentsValidityPass.phpT  1fT  L      O   vendor/symfony/dependency-injection/Compiler/AttributeAutoconfigurationPass.php  1f  Bu      D   vendor/symfony/dependency-injection/Compiler/ResolvePrivatesPass.php  1f  פ      O   vendor/symfony/dependency-injection/Compiler/AutowireRequiredPropertiesPass.php&	  1f&	  K.      J   vendor/symfony/dependency-injection/Compiler/ResolveNamedArgumentsPass.php,  1f,  t}Ȥ      I   vendor/symfony/dependency-injection/Compiler/RemovePrivateAliasesPass.phpv  1fv  x#      P   vendor/symfony/dependency-injection/Compiler/MergeExtensionConfigurationPass.phpR!  1fR!  L6k      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphEdge.php  1f  \      M   vendor/symfony/dependency-injection/Compiler/DefinitionErrorExceptionPass.php7
  1f7
        L   vendor/symfony/dependency-injection/Compiler/RemoveUnusedDefinitionsPass.phpT  1fT        =   vendor/symfony/dependency-injection/Compiler/AutowirePass.phpkb  1fkb  LR      F   vendor/symfony/dependency-injection/Compiler/ServiceLocatorTagPass.phpM  1fM  \hT      R   vendor/symfony/dependency-injection/Compiler/ResolveTaggedIteratorArgumentPass.php  1f  D>Ϥ      K   vendor/symfony/dependency-injection/Compiler/ResolveEnvPlaceholdersPass.phpm  1fm  I2a      L   vendor/symfony/dependency-injection/Compiler/CheckCircularReferencesPass.php	  1f	  b4      ]   vendor/symfony/dependency-injection/Compiler/CheckExceptionOnInvalidReferenceBehaviorPass.phpx  1fx  cM      E   vendor/symfony/dependency-injection/Compiler/AutoAliasServicePass.php  1f  	#      Q   vendor/symfony/dependency-injection/Compiler/ResolveParameterPlaceHoldersPass.php  1f        A   vendor/symfony/dependency-injection/Compiler/ResolveClassPass.php^  1f^  j'      N   vendor/symfony/dependency-injection/Compiler/RemoveAbstractDefinitionsPass.php  1f  V𿐤      K   vendor/symfony/dependency-injection/Compiler/CheckReferenceValidityPass.php  1f  Ⅴ      O   vendor/symfony/dependency-injection/Compiler/RegisterServiceSubscribersPass.php  1f  1[      C   vendor/symfony/dependency-injection/Compiler/ResolveHotPathPass.php9
  1f9
  1f\      J   vendor/symfony/dependency-injection/Compiler/ResolveDecoratorStackPass.php  1f  cǤ      N   vendor/symfony/dependency-injection/Compiler/ResolveServiceSubscribersPass.php  1f  [{      F   vendor/symfony/dependency-injection/Compiler/CompilerPassInterface.php  1f  @      S   vendor/symfony/dependency-injection/Compiler/ReplaceAliasByActualDefinitionPass.php  1f  ,<o      L   vendor/symfony/dependency-injection/Compiler/ResolveChildDefinitionsPass.phpw  1fw  W      9   vendor/symfony/dependency-injection/Compiler/Compiler.php
  1f
  e7      F   vendor/symfony/dependency-injection/Compiler/ExtensionCompilerPass.php  1f  @	Ť      M   vendor/symfony/dependency-injection/Compiler/AnalyzeServiceReferencesPass.php  1f  F      L   vendor/symfony/dependency-injection/Compiler/AutowireRequiredMethodsPass.php  1f  .ݤ      =   vendor/symfony/dependency-injection/Dumper/GraphvizDumper.php$  1f$  G`      9   vendor/symfony/dependency-injection/Dumper/YamlDumper.phpx5  1fx5  	f
      8   vendor/symfony/dependency-injection/Dumper/Preloader.php-  1f-  "!      8   vendor/symfony/dependency-injection/Dumper/XmlDumper.php@  1f@  ǿ      >   vendor/symfony/dependency-injection/Dumper/DumperInterface.phpj  1fj  m      5   vendor/symfony/dependency-injection/Dumper/Dumper.php  1f  U;a      8   vendor/symfony/dependency-injection/Dumper/PhpDumper.phpdg 1fdg :ä      1   vendor/symfony/dependency-injection/composer.jsonx  1fx  Ed      =   vendor/symfony/dependency-injection/EnvVarLoaderInterface.php  1f  Aar      ?   vendor/symfony/dependency-injection/ContainerAwareInterface.php]  1f]  雤      :   vendor/symfony/password-hasher/PasswordHasherInterface.php  1f  k>      >   vendor/symfony/password-hasher/Hasher/SodiumPasswordHasher.php  1f  U      B   vendor/symfony/password-hasher/Hasher/CheckPasswordLengthTrait.phpw  1fw  #1      <   vendor/symfony/password-hasher/Hasher/UserPasswordHasher.php  1f  rπ      >   vendor/symfony/password-hasher/Hasher/Pbkdf2PasswordHasher.php  1f  (SA      F   vendor/symfony/password-hasher/Hasher/PasswordHasherAwareInterface.php  1f  ϡ*      >   vendor/symfony/password-hasher/Hasher/NativePasswordHasher.php  1f        E   vendor/symfony/password-hasher/Hasher/MessageDigestPasswordHasher.php  1f  x      E   vendor/symfony/password-hasher/Hasher/UserPasswordHasherInterface.php   1f   VkT      A   vendor/symfony/password-hasher/Hasher/PlaintextPasswordHasher.php6	  1f6	  juq      H   vendor/symfony/password-hasher/Hasher/PasswordHasherFactoryInterface.php1  1f1  |<      A   vendor/symfony/password-hasher/Hasher/MigratingPasswordHasher.phpL  1fL  SG      ?   vendor/symfony/password-hasher/Hasher/PasswordHasherFactory.php#  1f#  vӫ      &   vendor/symfony/password-hasher/LICENSE,  1f,  U      +   vendor/symfony/password-hasher/CHANGELOG.md]   1f]   {>I      @   vendor/symfony/password-hasher/LegacyPasswordHasherInterface.phpv  1fv  V      (   vendor/symfony/password-hasher/README.md  1f  !      B   vendor/symfony/password-hasher/Command/UserPasswordHashCommand.php.  1f.  d      ;   vendor/symfony/password-hasher/Exception/LogicException.php  1f  A      ?   vendor/symfony/password-hasher/Exception/ExceptionInterface.php  1f  EWL      E   vendor/symfony/password-hasher/Exception/InvalidPasswordException.php  1f  L      ,   vendor/symfony/password-hasher/composer.json  1f  uB$6         vendor/symfony/process/LICENSE,  1f,  U      +   vendor/symfony/process/ExecutableFinder.php	  1f	        #   vendor/symfony/process/CHANGELOG.md  1f  (C          vendor/symfony/process/README.md  1f  H!X      *   vendor/symfony/process/Pipes/UnixPipes.php  1f  bU      -   vendor/symfony/process/Pipes/WindowsPipes.phpc  1fc  $ޙ      .   vendor/symfony/process/Pipes/AbstractPipes.php  1f  #      /   vendor/symfony/process/Pipes/PipesInterface.php  1f        &   vendor/symfony/process/InputStream.php	  1f	  D_      %   vendor/symfony/process/PhpProcess.php	  1f	  nq      .   vendor/symfony/process/PhpExecutableFinder.php]
  1f]
  "!Τ      =   vendor/symfony/process/Exception/ProcessSignaledException.php  1f  V      3   vendor/symfony/process/Exception/LogicException.php  1f  iUQ      7   vendor/symfony/process/Exception/ExceptionInterface.php  1f  
j%W      ;   vendor/symfony/process/Exception/ProcessFailedException.phpA  1fA  lk      5   vendor/symfony/process/Exception/RuntimeException.php  1f  P      =   vendor/symfony/process/Exception/ProcessTimedOutException.phpt  1ft  /      =   vendor/symfony/process/Exception/InvalidArgumentException.php  1f  ڴ      $   vendor/symfony/process/composer.json  1f  Sg      '   vendor/symfony/process/ProcessUtils.phpT  1fT        "   vendor/symfony/process/Process.php  1f  ?6      (   vendor/symfony/console/ConsoleEvents.php  1f  .
      !   vendor/symfony/console/Cursor.php7  1f7  E      &   vendor/symfony/console/Application.phpp  1fp  (;      /   vendor/symfony/console/Logger/ConsoleLogger.php  1f  2      .   vendor/symfony/console/Attribute/AsCommand.phpJ  1fJ  c         vendor/symfony/console/LICENSE,  1f,  U      #   vendor/symfony/console/CHANGELOG.md   1f   P      9   vendor/symfony/console/Input/StreamableInputInterface.phpv  1fv  @      +   vendor/symfony/console/Input/ArrayInput.php  1f  $      *   vendor/symfony/console/Input/ArgvInput.php0  1f0         .   vendor/symfony/console/Input/InputArgument.php
  1f
  2      4   vendor/symfony/console/Input/InputAwareInterface.phpH  1fH  Ea      ,   vendor/symfony/console/Input/InputOption.phpT  1fT  '$      0   vendor/symfony/console/Input/InputDefinition.phpH.  1fH.  ʄ=s      ,   vendor/symfony/console/Input/StringInput.php
  1f
  JYc      &   vendor/symfony/console/Input/Input.php1  1f1  m      /   vendor/symfony/console/Input/InputInterface.php  1f  
+      #   vendor/symfony/console/Terminal.phpi  1fi  5wt8      2   vendor/symfony/console/CI/GithubActionReporter.php  1f  s      0   vendor/symfony/console/Resources/completion.bash
  1f
  z(      4   vendor/symfony/console/Resources/bin/hiddeninput.exe $  1f $  v      5   vendor/symfony/console/Output/TrimmedBufferOutput.phpc  1fc        8   vendor/symfony/console/Output/ConsoleOutputInterface.php-  1f-  U      0   vendor/symfony/console/Output/BufferedOutput.php_  1f_  PR1      1   vendor/symfony/console/Output/OutputInterface.phpl  1fl   -I      (   vendor/symfony/console/Output/Output.php[  1f[  46      6   vendor/symfony/console/Output/ConsoleSectionOutput.php  1f  ɤ      /   vendor/symfony/console/Output/ConsoleOutput.php!  1f!  -i¤      ,   vendor/symfony/console/Output/NullOutput.php,	  1f,	  GPJ      .   vendor/symfony/console/Output/StreamOutput.php  1f  |~`      A   vendor/symfony/console/Completion/Output/BashCompletionOutput.php	  1f	  Q2      F   vendor/symfony/console/Completion/Output/CompletionOutputInterface.php  1f  :]      0   vendor/symfony/console/Completion/Suggestion.php  1f   s      ;   vendor/symfony/console/Completion/CompletionSuggestions.phpf  1ff  \      5   vendor/symfony/console/Completion/CompletionInput.phpG   1fG   秤      ,   vendor/symfony/console/Style/OutputStyle.php8  1f8  '      -   vendor/symfony/console/Style/SymfonyStyle.php9  1f9  y      /   vendor/symfony/console/Style/StyleInterface.phpN
  1fN
  ͎)      2   vendor/symfony/console/Question/ChoiceQuestion.php  1f  .!ܤ      ,   vendor/symfony/console/Question/Question.phpr  1fr  l      8   vendor/symfony/console/Question/ConfirmationQuestion.php%  1f%  䦤          vendor/symfony/console/README.md  1f  =NP      9   vendor/symfony/console/Formatter/OutputFormatterStyle.php  1f  .}2      B   vendor/symfony/console/Formatter/OutputFormatterStyleInterface.phpe  1fe  5ޤ      =   vendor/symfony/console/Formatter/NullOutputFormatterStyle.php  1f  ]*      =   vendor/symfony/console/Formatter/OutputFormatterInterface.php@  1f@  ?&      4   vendor/symfony/console/Formatter/OutputFormatter.php   1f   d      8   vendor/symfony/console/Formatter/NullOutputFormatter.phpk  1fk  Nl      F   vendor/symfony/console/Formatter/WrappableOutputFormatterInterface.php  1f  pޤ      >   vendor/symfony/console/Formatter/OutputFormatterStyleStack.php
  1f
  0          vendor/symfony/console/Color.phpR  1fR  P      8   vendor/symfony/console/SignalRegistry/SignalRegistry.php@  1f@         3   vendor/symfony/console/SingleCommandApplication.php)  1f)  6^      ?   vendor/symfony/console/CommandLoader/CommandLoaderInterface.phpv  1fv  h      ?   vendor/symfony/console/CommandLoader/ContainerCommandLoader.php
  1f
  7!      =   vendor/symfony/console/CommandLoader/FactoryCommandLoader.php]  1f]  j7      4   vendor/symfony/console/Descriptor/TextDescriptor.php1  1f1  X      <   vendor/symfony/console/Descriptor/ApplicationDescription.php  1f  5x      3   vendor/symfony/console/Descriptor/XmlDescriptor.php'  1f'  fʕ'      9   vendor/symfony/console/Descriptor/DescriptorInterface.phpI  1fI  N)      0   vendor/symfony/console/Descriptor/Descriptor.php  1f  =      4   vendor/symfony/console/Descriptor/JsonDescriptor.php  1f  k/6       8   vendor/symfony/console/Descriptor/MarkdownDescriptor.phpK  1fK   Ѥ      /   vendor/symfony/console/Tester/CommandTester.php>	  1f>	  ڑc      -   vendor/symfony/console/Tester/TesterTrait.php  1f  ́      3   vendor/symfony/console/Tester/ApplicationTester.php
  1f
  $Z      9   vendor/symfony/console/Tester/CommandCompletionTester.php<  1f<  y      @   vendor/symfony/console/Tester/Constraint/CommandIsSuccessful.php  1f  Ld      .   vendor/symfony/console/Command/LazyCommand.php&  1f&  i      0   vendor/symfony/console/Command/LockableTrait.php  1f  ̤      .   vendor/symfony/console/Command/HelpCommand.php  1f        2   vendor/symfony/console/Command/CompleteCommand.php   1f   gQ@      .   vendor/symfony/console/Command/ListCommand.php  1f  8MZ      8   vendor/symfony/console/Command/DumpCompletionCommand.php  1f  Dә      =   vendor/symfony/console/Command/SignalableCommandInterface.php  1f  ,      *   vendor/symfony/console/Command/Command.phpP  1fP  vK      ,   vendor/symfony/console/Helper/TableStyle.php0  1f0  ?V      +   vendor/symfony/console/Helper/TableRows.phpR  1fR  HD      7   vendor/symfony/console/Helper/SymfonyQuestionHelper.php+
  1f+
  ݙ      1   vendor/symfony/console/Helper/HelperInterface.phpZ  1fZ  6      +   vendor/symfony/console/Helper/TableCell.php
  1f
  ~3      /   vendor/symfony/console/Helper/ProcessHelper.php  1f  Iʤ      0   vendor/symfony/console/Helper/TableSeparator.php!  1f!  n2      1   vendor/symfony/console/Helper/FormatterHelper.phpx	  1fx	  @d
Ϥ      0   vendor/symfony/console/Helper/TableCellStyle.php\  1f\  9|S      -   vendor/symfony/console/Helper/ProgressBar.php3H  1f3H  +-1      6   vendor/symfony/console/Helper/DebugFormatterHelper.phpX
  1fX
  젤      +   vendor/symfony/console/Helper/HelperSet.php;
  1f;
  J>~      (   vendor/symfony/console/Helper/Dumper.phpD  1fD  z      2   vendor/symfony/console/Helper/InputAwareHelper.php  1f  E      0   vendor/symfony/console/Helper/QuestionHelper.phpL  1fL  n'u      (   vendor/symfony/console/Helper/Helper.php  1f  I 0      '   vendor/symfony/console/Helper/Table.phpr  1fr  GrƤ      3   vendor/symfony/console/Helper/ProgressIndicator.php  1f  :      2   vendor/symfony/console/Helper/DescriptorHelper.php	  1f	  Nq      D   vendor/symfony/console/DependencyInjection/AddConsoleCommandPass.php  1f  S      3   vendor/symfony/console/Exception/LogicException.php  1f  5      ;   vendor/symfony/console/Exception/InvalidOptionException.php  1f  %:      7   vendor/symfony/console/Exception/ExceptionInterface.php  1f  oOȤ      5   vendor/symfony/console/Exception/RuntimeException.php  1f        ?   vendor/symfony/console/Exception/NamespaceNotFoundException.php  1f  xD      =   vendor/symfony/console/Exception/InvalidArgumentException.php  1f  x
Τ      :   vendor/symfony/console/Exception/MissingInputException.php  1f  L      =   vendor/symfony/console/Exception/CommandNotFoundException.php  1f  
kg      6   vendor/symfony/console/Event/ConsoleTerminateEvent.phpZ  1fZ  TJ      2   vendor/symfony/console/Event/ConsoleErrorEvent.php  1f  o}4Ϥ      4   vendor/symfony/console/Event/ConsoleCommandEvent.php9  1f9  tp      -   vendor/symfony/console/Event/ConsoleEvent.php  1f  .bF      3   vendor/symfony/console/Event/ConsoleSignalEvent.php  1f  #4pԤ      $   vendor/symfony/console/composer.json  1f  S(      6   vendor/symfony/console/EventListener/ErrorListener.phpB  1fB  a      0   vendor/symfony/polyfill-mbstring/bootstrap80.php$  1f$  cj      (   vendor/symfony/polyfill-mbstring/LICENSE,  1f,  H      B   vendor/symfony/polyfill-mbstring/Resources/unidata/caseFolding.php  1f  ]SC      @   vendor/symfony/polyfill-mbstring/Resources/unidata/lowerCase.phpU  1fU  D׎      F   vendor/symfony/polyfill-mbstring/Resources/unidata/titleCaseRegexp.php  1f  oቤ      @   vendor/symfony/polyfill-mbstring/Resources/unidata/upperCase.phpO[  1fO[  (      -   vendor/symfony/polyfill-mbstring/Mbstring.phpU  1fU  ,3      .   vendor/symfony/polyfill-mbstring/bootstrap.php  1f  Oa      *   vendor/symfony/polyfill-mbstring/README.mdr  1fr  A`      .   vendor/symfony/polyfill-mbstring/composer.json8  1f8  .      5   vendor/symfony/polyfill-intl-grapheme/bootstrap80.phpg
  1fg
  E{      -   vendor/symfony/polyfill-intl-grapheme/LICENSE,  1f,  H      2   vendor/symfony/polyfill-intl-grapheme/Grapheme.php&  1f&  8      3   vendor/symfony/polyfill-intl-grapheme/bootstrap.php  1f        /   vendor/symfony/polyfill-intl-grapheme/README.mdK  1fK  C>      3   vendor/symfony/polyfill-intl-grapheme/composer.json   1f            vendor/ramsey/uuid/LICENSED  1fD  D¤         vendor/ramsey/uuid/README.mdh  1fh  g          vendor/ramsey/uuid/composer.json7  1f7  J      $   vendor/ramsey/uuid/src/functions.phpj	  1fj	  "      :   vendor/ramsey/uuid/src/Converter/Time/PhpTimeConverter.php  1f  濤      ?   vendor/ramsey/uuid/src/Converter/Time/DegradedTimeConverter.php  1f  :      @   vendor/ramsey/uuid/src/Converter/Time/BigNumberTimeConverter.php
  1f
  l      C   vendor/ramsey/uuid/src/Converter/Number/DegradedNumberConverter.php  1f        >   vendor/ramsey/uuid/src/Converter/Number/BigNumberConverter.php  1f        ;   vendor/ramsey/uuid/src/Converter/TimeConverterInterface.phpD  1fD  x      =   vendor/ramsey/uuid/src/Converter/NumberConverterInterface.php  1f  uѢ      8   vendor/ramsey/uuid/src/Codec/TimestampFirstCombCodec.php  1f  o^      1   vendor/ramsey/uuid/src/Codec/OrderedTimeCodec.php"  1f"  а      /   vendor/ramsey/uuid/src/Codec/CodecInterface.php  1f  EΤ      0   vendor/ramsey/uuid/src/Codec/GuidStringCodec.php  1f  U`      ,   vendor/ramsey/uuid/src/Codec/StringCodec.phpR  1fR  
      7   vendor/ramsey/uuid/src/Codec/TimestampLastCombCodec.php  1f  0         vendor/ramsey/uuid/src/Uuid.php0Z  1f0Z  x      9   vendor/ramsey/uuid/src/Provider/NodeProviderInterface.php  1f  ڤ      ;   vendor/ramsey/uuid/src/Provider/Time/SystemTimeProvider.php  1f        :   vendor/ramsey/uuid/src/Provider/Time/FixedTimeProvider.php  1f  UtC      9   vendor/ramsey/uuid/src/Provider/TimeProviderInterface.php^  1f^  ۤ      ;   vendor/ramsey/uuid/src/Provider/Node/RandomNodeProvider.php]  1f]  An      =   vendor/ramsey/uuid/src/Provider/Node/FallbackNodeProvider.php  1f  [I      ;   vendor/ramsey/uuid/src/Provider/Node/SystemNodeProvider.php
  1f
  CKd      %   vendor/ramsey/uuid/src/FeatureSet.php$  1f$  3/t      (   vendor/ramsey/uuid/src/UuidInterface.php%  1f%  He"L      /   vendor/ramsey/uuid/src/UuidFactoryInterface.phpr  1fr  V+X      9   vendor/ramsey/uuid/src/Generator/RandomBytesGenerator.php  1f  cߤ      5   vendor/ramsey/uuid/src/Generator/OpenSslGenerator.php  1f  4$      ;   vendor/ramsey/uuid/src/Generator/RandomGeneratorFactory.phpq  1fq  )Q!      9   vendor/ramsey/uuid/src/Generator/TimeGeneratorFactory.php  1f  ZFzN      9   vendor/ramsey/uuid/src/Generator/DefaultTimeGenerator.php*  1f*  p      5   vendor/ramsey/uuid/src/Generator/RandomLibAdapter.php(  1f(  <      ;   vendor/ramsey/uuid/src/Generator/TimeGeneratorInterface.php  1f  ^ܟ"      2   vendor/ramsey/uuid/src/Generator/CombGenerator.php  1f  y?$      =   vendor/ramsey/uuid/src/Generator/RandomGeneratorInterface.php  1f  Ȕ      <   vendor/ramsey/uuid/src/Generator/PeclUuidRandomGenerator.phpo  1fo  (      4   vendor/ramsey/uuid/src/Generator/MtRandGenerator.php  1f  g      :   vendor/ramsey/uuid/src/Generator/SodiumRandomGenerator.php  1f  :L      :   vendor/ramsey/uuid/src/Generator/PeclUuidTimeGenerator.php  1f  A      &   vendor/ramsey/uuid/src/BinaryUtils.php4  1f4  F@ۤ      &   vendor/ramsey/uuid/src/UuidFactory.phpE!  1fE!  Jji      '   vendor/ramsey/uuid/src/DegradedUuid.php
  1f
  @{      6   vendor/ramsey/uuid/src/Builder/DegradedUuidBuilder.php  1f  L      7   vendor/ramsey/uuid/src/Builder/UuidBuilderInterface.php  1f        5   vendor/ramsey/uuid/src/Builder/DefaultUuidBuilder.php  1f        B   vendor/ramsey/uuid/src/Exception/UnsupportedOperationException.php  1f  z{      C   vendor/ramsey/uuid/src/Exception/UnsatisfiedDependencyException.php  1f  佢      ?   vendor/ramsey/uuid/src/Exception/InvalidUuidStringException.php  1f  Ep8         vendor/react/promise/LICENSEg  1fg  F      !   vendor/react/promise/CHANGELOG.md9  1f9  OT:         vendor/react/promise/README.mdQY  1fQY  1      "   vendor/react/promise/composer.json  1f  NjB      -   vendor/react/promise/src/PromiseInterface.php  1f  MFx8      &   vendor/react/promise/src/functions.php1-  1f1-  t      .   vendor/react/promise/src/functions_include.php   1f   dx\      $   vendor/react/promise/src/Promise.php(  1f(  s;6      %   vendor/react/promise/src/Deferred.php0  1f0        5   vendor/react/promise/src/Internal/RejectedPromise.php
  1f
  |      6   vendor/react/promise/src/Internal/FulfilledPromise.php3	  1f3	  *      7   vendor/react/promise/src/Internal/CancellationQueue.php  1f  r2      6   vendor/react/promise/src/Exception/LengthException.php^   1f^   ?q      9   vendor/react/promise/src/Exception/CompositeException.phpa  1fa  '      3   vendor/terminal42/service-annotation-bundle/LICENSE#  1f#  }      5   vendor/terminal42/service-annotation-bundle/README.md  1f  #      9   vendor/terminal42/service-annotation-bundle/composer.json  1f  ũ>      U   vendor/terminal42/service-annotation-bundle/src/Terminal42ServiceAnnotationBundle.php  1f  -M!?      N   vendor/terminal42/service-annotation-bundle/src/ServiceAnnotationInterface.php  1f  oj      I   vendor/terminal42/service-annotation-bundle/src/Annotation/ServiceTag.phpM  1fM  _;      R   vendor/terminal42/service-annotation-bundle/src/Annotation/ServiceTagInterface.php  1f  S^      f   vendor/terminal42/service-annotation-bundle/src/DependencyInjection/Compiler/ServiceAnnotationPass.php.  1f.  "##      <?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

require __DIR__ . '/../vendor/autoload.php';
if (\false === \in_array(\PHP_SAPI, array('cli', 'phpdbg', 'embed'), \true)) {
    echo \PHP_EOL . 'The application may only be invoked from a command line, got "' . \PHP_SAPI . '"' . \PHP_EOL;
    exit(1);
}
if ((\false === isset($_SERVER['BOX_REQUIREMENT_CHECKER']) || \true === (bool) $_SERVER['BOX_REQUIREMENT_CHECKER']) && \false === Checker::checkRequirements()) {
    exit(1);
}
<?php

return array (
  0 => 
  array (
    'type' => 'php',
    'condition' => '^7.2.5 || ^8.0',
    'message' => 'The application requires the version "^7.2.5 || ^8.0" or greater.',
    'helpMessage' => 'The application requires the version "^7.2.5 || ^8.0" or greater.',
  ),
  1 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The application requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "json".',
  ),
  2 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "ramsey/uuid" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "ramsey/uuid" requires the extension "json".',
  ),
  3 => 
  array (
    'type' => 'extension',
    'condition' => 'zip',
    'message' => 'The application requires the extension "zip". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "zip".',
  ),
  4 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "composer/ca-bundle" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "openssl".',
  ),
  5 => 
  array (
    'type' => 'extension',
    'condition' => 'pcre',
    'message' => 'The package "composer/ca-bundle" requires the extension "pcre". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "pcre".',
  ),
  6 => 
  array (
    'type' => 'extension',
    'condition' => 'tokenizer',
    'message' => 'The package "doctrine/annotations" requires the extension "tokenizer". Enable it or install a polyfill.',
    'helpMessage' => 'The package "doctrine/annotations" requires the extension "tokenizer".',
  ),
  7 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/framework-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/framework-bundle" requires the extension "xml".',
  ),
  8 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/security-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/security-bundle" requires the extension "xml".',
  ),
);<?php

// autoload.php @generated by Composer

require_once __DIR__ . '/composer/autoload_real.php';

return ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893::getLoader();
<?php

// autoload_namespaces.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
);

Copyright (c) Nils Adermann, Jordi Boggiano

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is furnished
to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

<?php

/*
 * This file is part of Composer.
 *
 * (c) Nils Adermann <naderman@naderman.de>
 *     Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Composer\Autoload;

/**
 * ClassLoader implements a PSR-0, PSR-4 and classmap class loader.
 *
 *     $loader = new \Composer\Autoload\ClassLoader();
 *
 *     // register classes with namespaces
 *     $loader->add('Symfony\Component', __DIR__.'/component');
 *     $loader->add('Symfony',           __DIR__.'/framework');
 *
 *     // activate the autoloader
 *     $loader->register();
 *
 *     // to enable searching the include path (eg. for PEAR packages)
 *     $loader->setUseIncludePath(true);
 *
 * In this example, if you try to use a class in the Symfony\Component
 * namespace or one of its children (Symfony\Component\Console for instance),
 * the autoloader will first look for the class under the component/
 * directory, and it will then fallback to the framework/ directory if not
 * found before giving up.
 *
 * This class is loosely based on the Symfony UniversalClassLoader.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 * @author Jordi Boggiano <j.boggiano@seld.be>
 * @see    https://www.php-fig.org/psr/psr-0/
 * @see    https://www.php-fig.org/psr/psr-4/
 */
class ClassLoader
{
    /** @var ?string */
    private $vendorDir;

    // PSR-4
    /**
     * @var array[]
     * @psalm-var array<string, array<string, int>>
     */
    private $prefixLengthsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, array<int, string>>
     */
    private $prefixDirsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr4 = array();

    // PSR-0
    /**
     * @var array[]
     * @psalm-var array<string, array<string, string[]>>
     */
    private $prefixesPsr0 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr0 = array();

    /** @var bool */
    private $useIncludePath = false;

    /**
     * @var string[]
     * @psalm-var array<string, string>
     */
    private $classMap = array();

    /** @var bool */
    private $classMapAuthoritative = false;

    /**
     * @var bool[]
     * @psalm-var array<string, bool>
     */
    private $missingClasses = array();

    /** @var ?string */
    private $apcuPrefix;

    /**
     * @var self[]
     */
    private static $registeredLoaders = array();

    /**
     * @param ?string $vendorDir
     */
    public function __construct($vendorDir = null)
    {
        $this->vendorDir = $vendorDir;
    }

    /**
     * @return string[]
     */
    public function getPrefixes()
    {
        if (!empty($this->prefixesPsr0)) {
            return call_user_func_array('array_merge', array_values($this->prefixesPsr0));
        }

        return array();
    }

    /**
     * @return array[]
     * @psalm-return array<string, array<int, string>>
     */
    public function getPrefixesPsr4()
    {
        return $this->prefixDirsPsr4;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirs()
    {
        return $this->fallbackDirsPsr0;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirsPsr4()
    {
        return $this->fallbackDirsPsr4;
    }

    /**
     * @return string[] Array of classname => path
     * @psalm-return array<string, string>
     */
    public function getClassMap()
    {
        return $this->classMap;
    }

    /**
     * @param string[] $classMap Class to filename map
     * @psalm-param array<string, string> $classMap
     *
     * @return void
     */
    public function addClassMap(array $classMap)
    {
        if ($this->classMap) {
            $this->classMap = array_merge($this->classMap, $classMap);
        } else {
            $this->classMap = $classMap;
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix, either
     * appending or prepending to the ones previously set for this prefix.
     *
     * @param string          $prefix  The prefix
     * @param string[]|string $paths   The PSR-0 root directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @return void
     */
    public function add($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            if ($prepend) {
                $this->fallbackDirsPsr0 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr0
                );
            } else {
                $this->fallbackDirsPsr0 = array_merge(
                    $this->fallbackDirsPsr0,
                    (array) $paths
                );
            }

            return;
        }

        $first = $prefix[0];
        if (!isset($this->prefixesPsr0[$first][$prefix])) {
            $this->prefixesPsr0[$first][$prefix] = (array) $paths;

            return;
        }
        if ($prepend) {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                (array) $paths,
                $this->prefixesPsr0[$first][$prefix]
            );
        } else {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                $this->prefixesPsr0[$first][$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace, either
     * appending or prepending to the ones previously set for this namespace.
     *
     * @param string          $prefix  The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths   The PSR-4 base directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function addPsr4($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            // Register directories for the root namespace.
            if ($prepend) {
                $this->fallbackDirsPsr4 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr4
                );
            } else {
                $this->fallbackDirsPsr4 = array_merge(
                    $this->fallbackDirsPsr4,
                    (array) $paths
                );
            }
        } elseif (!isset($this->prefixDirsPsr4[$prefix])) {
            // Register directories for a new namespace.
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        } elseif ($prepend) {
            // Prepend directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                (array) $paths,
                $this->prefixDirsPsr4[$prefix]
            );
        } else {
            // Append directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                $this->prefixDirsPsr4[$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix,
     * replacing any others previously set for this prefix.
     *
     * @param string          $prefix The prefix
     * @param string[]|string $paths  The PSR-0 base directories
     *
     * @return void
     */
    public function set($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr0 = (array) $paths;
        } else {
            $this->prefixesPsr0[$prefix[0]][$prefix] = (array) $paths;
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace,
     * replacing any others previously set for this namespace.
     *
     * @param string          $prefix The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths  The PSR-4 base directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function setPsr4($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr4 = (array) $paths;
        } else {
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        }
    }

    /**
     * Turns on searching the include path for class files.
     *
     * @param bool $useIncludePath
     *
     * @return void
     */
    public function setUseIncludePath($useIncludePath)
    {
        $this->useIncludePath = $useIncludePath;
    }

    /**
     * Can be used to check if the autoloader uses the include path to check
     * for classes.
     *
     * @return bool
     */
    public function getUseIncludePath()
    {
        return $this->useIncludePath;
    }

    /**
     * Turns off searching the prefix and fallback directories for classes
     * that have not been registered with the class map.
     *
     * @param bool $classMapAuthoritative
     *
     * @return void
     */
    public function setClassMapAuthoritative($classMapAuthoritative)
    {
        $this->classMapAuthoritative = $classMapAuthoritative;
    }

    /**
     * Should class lookup fail if not found in the current class map?
     *
     * @return bool
     */
    public function isClassMapAuthoritative()
    {
        return $this->classMapAuthoritative;
    }

    /**
     * APCu prefix to use to cache found/not-found classes, if the extension is enabled.
     *
     * @param string|null $apcuPrefix
     *
     * @return void
     */
    public function setApcuPrefix($apcuPrefix)
    {
        $this->apcuPrefix = function_exists('apcu_fetch') && filter_var(ini_get('apc.enabled'), FILTER_VALIDATE_BOOLEAN) ? $apcuPrefix : null;
    }

    /**
     * The APCu prefix in use, or null if APCu caching is not enabled.
     *
     * @return string|null
     */
    public function getApcuPrefix()
    {
        return $this->apcuPrefix;
    }

    /**
     * Registers this instance as an autoloader.
     *
     * @param bool $prepend Whether to prepend the autoloader or not
     *
     * @return void
     */
    public function register($prepend = false)
    {
        spl_autoload_register(array($this, 'loadClass'), true, $prepend);

        if (null === $this->vendorDir) {
            return;
        }

        if ($prepend) {
            self::$registeredLoaders = array($this->vendorDir => $this) + self::$registeredLoaders;
        } else {
            unset(self::$registeredLoaders[$this->vendorDir]);
            self::$registeredLoaders[$this->vendorDir] = $this;
        }
    }

    /**
     * Unregisters this instance as an autoloader.
     *
     * @return void
     */
    public function unregister()
    {
        spl_autoload_unregister(array($this, 'loadClass'));

        if (null !== $this->vendorDir) {
            unset(self::$registeredLoaders[$this->vendorDir]);
        }
    }

    /**
     * Loads the given class or interface.
     *
     * @param  string    $class The name of the class
     * @return true|null True if loaded, null otherwise
     */
    public function loadClass($class)
    {
        if ($file = $this->findFile($class)) {
            includeFile($file);

            return true;
        }

        return null;
    }

    /**
     * Finds the path to the file where the class is defined.
     *
     * @param string $class The name of the class
     *
     * @return string|false The path if found, false otherwise
     */
    public function findFile($class)
    {
        // class map lookup
        if (isset($this->classMap[$class])) {
            return $this->classMap[$class];
        }
        if ($this->classMapAuthoritative || isset($this->missingClasses[$class])) {
            return false;
        }
        if (null !== $this->apcuPrefix) {
            $file = apcu_fetch($this->apcuPrefix.$class, $hit);
            if ($hit) {
                return $file;
            }
        }

        $file = $this->findFileWithExtension($class, '.php');

        // Search for Hack files if we are running on HHVM
        if (false === $file && defined('HHVM_VERSION')) {
            $file = $this->findFileWithExtension($class, '.hh');
        }

        if (null !== $this->apcuPrefix) {
            apcu_add($this->apcuPrefix.$class, $file);
        }

        if (false === $file) {
            // Remember that this class does not exist.
            $this->missingClasses[$class] = true;
        }

        return $file;
    }

    /**
     * Returns the currently registered loaders indexed by their corresponding vendor directories.
     *
     * @return self[]
     */
    public static function getRegisteredLoaders()
    {
        return self::$registeredLoaders;
    }

    /**
     * @param  string       $class
     * @param  string       $ext
     * @return string|false
     */
    private function findFileWithExtension($class, $ext)
    {
        // PSR-4 lookup
        $logicalPathPsr4 = strtr($class, '\\', DIRECTORY_SEPARATOR) . $ext;

        $first = $class[0];
        if (isset($this->prefixLengthsPsr4[$first])) {
            $subPath = $class;
            while (false !== $lastPos = strrpos($subPath, '\\')) {
                $subPath = substr($subPath, 0, $lastPos);
                $search = $subPath . '\\';
                if (isset($this->prefixDirsPsr4[$search])) {
                    $pathEnd = DIRECTORY_SEPARATOR . substr($logicalPathPsr4, $lastPos + 1);
                    foreach ($this->prefixDirsPsr4[$search] as $dir) {
                        if (file_exists($file = $dir . $pathEnd)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-4 fallback dirs
        foreach ($this->fallbackDirsPsr4 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr4)) {
                return $file;
            }
        }

        // PSR-0 lookup
        if (false !== $pos = strrpos($class, '\\')) {
            // namespaced class name
            $logicalPathPsr0 = substr($logicalPathPsr4, 0, $pos + 1)
                . strtr(substr($logicalPathPsr4, $pos + 1), '_', DIRECTORY_SEPARATOR);
        } else {
            // PEAR-like class name
            $logicalPathPsr0 = strtr($class, '_', DIRECTORY_SEPARATOR) . $ext;
        }

        if (isset($this->prefixesPsr0[$first])) {
            foreach ($this->prefixesPsr0[$first] as $prefix => $dirs) {
                if (0 === strpos($class, $prefix)) {
                    foreach ($dirs as $dir) {
                        if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-0 fallback dirs
        foreach ($this->fallbackDirsPsr0 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                return $file;
            }
        }

        // PSR-0 include paths.
        if ($this->useIncludePath && $file = stream_resolve_include_path($logicalPathPsr0)) {
            return $file;
        }

        return false;
    }
}

/**
 * Scope isolated include.
 *
 * Prevents access to $this/self from included files.
 *
 * @param  string $file
 * @return void
 * @private
 */
function includeFile($file)
{
    include $file;
}
<?php

// autoload_psr4.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'HumbugBox3150\\KevinGH\\RequirementChecker\\' => array($baseDir . '/src'),
    'HumbugBox3150\\Composer\\Semver\\' => array($vendorDir . '/composer/semver/src'),
);
<?php

// autoload_classmap.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'Composer\\InstalledVersions' => $vendorDir . '/composer/InstalledVersions.php',
    'HumbugBox3150\\Composer\\Semver\\Comparator' => $vendorDir . '/composer/semver/src/Comparator.php',
    'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => $vendorDir . '/composer/semver/src/CompilingMatcher.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => $vendorDir . '/composer/semver/src/Constraint/Bound.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => $vendorDir . '/composer/semver/src/Constraint/Constraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => $vendorDir . '/composer/semver/src/Constraint/ConstraintInterface.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchAllConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => $vendorDir . '/composer/semver/src/Constraint/MultiConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Interval' => $vendorDir . '/composer/semver/src/Interval.php',
    'HumbugBox3150\\Composer\\Semver\\Intervals' => $vendorDir . '/composer/semver/src/Intervals.php',
    'HumbugBox3150\\Composer\\Semver\\Semver' => $vendorDir . '/composer/semver/src/Semver.php',
    'HumbugBox3150\\Composer\\Semver\\VersionParser' => $vendorDir . '/composer/semver/src/VersionParser.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => $baseDir . '/src/Checker.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => $baseDir . '/src/IO.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => $baseDir . '/src/IsExtensionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => $baseDir . '/src/IsFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => $baseDir . '/src/IsPhpVersionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => $baseDir . '/src/Printer.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => $baseDir . '/src/Requirement.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => $baseDir . '/src/RequirementCollection.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => $baseDir . '/src/Terminal.php',
);
<?php

// autoload_static.php @generated by Composer

namespace Composer\Autoload;

class ComposerStaticInit7b1918d23e69dc64db20ca1f98396893
{
    public static $prefixLengthsPsr4 = array (
        'H' => 
        array (
            'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 41,
            'HumbugBox3150\\Composer\\Semver\\' => 30,
        ),
    );

    public static $prefixDirsPsr4 = array (
        'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 
        array (
            0 => __DIR__ . '/../..' . '/src',
        ),
        'HumbugBox3150\\Composer\\Semver\\' => 
        array (
            0 => __DIR__ . '/..' . '/composer/semver/src',
        ),
    );

    public static $classMap = array (
        'Composer\\InstalledVersions' => __DIR__ . '/..' . '/composer/InstalledVersions.php',
        'HumbugBox3150\\Composer\\Semver\\Comparator' => __DIR__ . '/..' . '/composer/semver/src/Comparator.php',
        'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => __DIR__ . '/..' . '/composer/semver/src/CompilingMatcher.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Bound.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Constraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => __DIR__ . '/..' . '/composer/semver/src/Constraint/ConstraintInterface.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchAllConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MultiConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Interval' => __DIR__ . '/..' . '/composer/semver/src/Interval.php',
        'HumbugBox3150\\Composer\\Semver\\Intervals' => __DIR__ . '/..' . '/composer/semver/src/Intervals.php',
        'HumbugBox3150\\Composer\\Semver\\Semver' => __DIR__ . '/..' . '/composer/semver/src/Semver.php',
        'HumbugBox3150\\Composer\\Semver\\VersionParser' => __DIR__ . '/..' . '/composer/semver/src/VersionParser.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => __DIR__ . '/../..' . '/src/Checker.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => __DIR__ . '/../..' . '/src/IO.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => __DIR__ . '/../..' . '/src/IsExtensionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => __DIR__ . '/../..' . '/src/IsFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => __DIR__ . '/../..' . '/src/IsPhpVersionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => __DIR__ . '/../..' . '/src/Printer.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => __DIR__ . '/../..' . '/src/Requirement.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => __DIR__ . '/../..' . '/src/RequirementCollection.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => __DIR__ . '/../..' . '/src/Terminal.php',
    );

    public static function getInitializer(ClassLoader $loader)
    {
        return \Closure::bind(function () use ($loader) {
            $loader->prefixLengthsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixLengthsPsr4;
            $loader->prefixDirsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixDirsPsr4;
            $loader->classMap = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$classMap;

        }, null, ClassLoader::class);
    }
}
<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        spl_autoload_register(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader(\dirname(\dirname(__FILE__)));
        spl_autoload_unregister(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'));

        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            require __DIR__ . '/autoload_static.php';

            call_user_func(\Composer\Autoload\ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::getInitializer($loader));
        } else {
            $classMap = require __DIR__ . '/autoload_classmap.php';
            if ($classMap) {
                $loader->addClassMap($classMap);
            }
        }

        $loader->setClassMapAuthoritative(true);
        $loader->register(true);

        return $loader;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Comparator
{
    public static function greaterThan($version1, $version2)
    {
        return self::compare($version1, '>', $version2);
    }
    public static function greaterThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '>=', $version2);
    }
    public static function lessThan($version1, $version2)
    {
        return self::compare($version1, '<', $version2);
    }
    public static function lessThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '<=', $version2);
    }
    public static function equalTo($version1, $version2)
    {
        return self::compare($version1, '==', $version2);
    }
    public static function notEqualTo($version1, $version2)
    {
        return self::compare($version1, '!=', $version2);
    }
    public static function compare($version1, $operator, $version2)
    {
        $constraint = new Constraint($operator, $version2);
        return $constraint->matchSpecific(new Constraint('==', $version1), \true);
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Semver
{
    const SORT_ASC = 1;
    const SORT_DESC = -1;
    private static $versionParser;
    public static function satisfies($version, $constraints)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $provider = new Constraint('==', $versionParser->normalize($version));
        $parsedConstraints = $versionParser->parseConstraints($constraints);
        return $parsedConstraints->matches($provider);
    }
    public static function satisfiedBy(array $versions, $constraints)
    {
        $versions = \array_filter($versions, function ($version) use($constraints) {
            return Semver::satisfies($version, $constraints);
        });
        return \array_values($versions);
    }
    public static function sort(array $versions)
    {
        return self::usort($versions, self::SORT_ASC);
    }
    public static function rsort(array $versions)
    {
        return self::usort($versions, self::SORT_DESC);
    }
    private static function usort(array $versions, $direction)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $normalized = array();
        foreach ($versions as $key => $version) {
            $normalizedVersion = $versionParser->normalize($version);
            $normalizedVersion = $versionParser->normalizeDefaultBranch($normalizedVersion);
            $normalized[] = array($normalizedVersion, $key);
        }
        \usort($normalized, function (array $left, array $right) use($direction) {
            if ($left[0] === $right[0]) {
                return 0;
            }
            if (Comparator::lessThan($left[0], $right[0])) {
                return -$direction;
            }
            return $direction;
        });
        $sorted = array();
        foreach ($normalized as $item) {
            $sorted[] = $versions[$item[1]];
        }
        return $sorted;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\ConstraintInterface;
use HumbugBox3150\Composer\Semver\Constraint\MatchAllConstraint;
use HumbugBox3150\Composer\Semver\Constraint\MultiConstraint;
use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class VersionParser
{
    private static $modifierRegex = '[._-]?(?:(stable|beta|b|RC|alpha|a|patch|pl|p)((?:[.-]?\\d+)*+)?)?([.-]?dev)?';
    private static $stabilitiesRegex = 'stable|RC|beta|alpha|dev';
    public static function parseStability($version)
    {
        $version = \preg_replace('{#.+$}i', '', $version);
        if (\strpos($version, 'dev-') === 0 || '-dev' === \substr($version, -4)) {
            return 'dev';
        }
        \preg_match('{' . self::$modifierRegex . '(?:\\+.*)?$}i', \strtolower($version), $match);
        if (!empty($match[3])) {
            return 'dev';
        }
        if (!empty($match[1])) {
            if ('beta' === $match[1] || 'b' === $match[1]) {
                return 'beta';
            }
            if ('alpha' === $match[1] || 'a' === $match[1]) {
                return 'alpha';
            }
            if ('rc' === $match[1]) {
                return 'RC';
            }
        }
        return 'stable';
    }
    public static function normalizeStability($stability)
    {
        $stability = \strtolower($stability);
        return $stability === 'rc' ? 'RC' : $stability;
    }
    public function normalize($version, $fullVersion = null)
    {
        $version = \trim($version);
        $origVersion = $version;
        if (null === $fullVersion) {
            $fullVersion = $version;
        }
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{@(?:' . self::$stabilitiesRegex . ')$}i', $version, $match)) {
            $version = \substr($version, 0, \strlen($version) - \strlen($match[0]));
        }
        if (\in_array($version, array('master', 'trunk', 'default'), \true)) {
            $version = 'dev-' . $version;
        }
        if (\stripos($version, 'dev-') === 0) {
            return 'dev-' . \substr($version, 4);
        }
        if (\preg_match('{^([^,\\s+]++)\\+[^\\s]++$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{^v?(\\d{1,5})(\\.\\d++)?(\\.\\d++)?(\\.\\d++)?' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = $matches[1] . (!empty($matches[2]) ? $matches[2] : '.0') . (!empty($matches[3]) ? $matches[3] : '.0') . (!empty($matches[4]) ? $matches[4] : '.0');
            $index = 5;
        } elseif (\preg_match('{^v?(\\d{4}(?:[.:-]?\\d{2}){1,6}(?:[.:-]?\\d{1,3})?)' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = \preg_replace('{\\D}', '.', $matches[1]);
            $index = 2;
        }
        if (isset($index)) {
            if (!empty($matches[$index])) {
                if ('stable' === $matches[$index]) {
                    return $version;
                }
                $version .= '-' . $this->expandStability($matches[$index]) . (!empty($matches[$index + 1]) ? \ltrim($matches[$index + 1], '.-') : '');
            }
            if (!empty($matches[$index + 2])) {
                $version .= '-dev';
            }
            return $version;
        }
        if (\preg_match('{(.*?)[.-]?dev$}i', $version, $match)) {
            try {
                $normalized = $this->normalizeBranch($match[1]);
                if (\strpos($normalized, 'dev-') === \false) {
                    return $normalized;
                }
            } catch (\Exception $e) {
            }
        }
        $extraMessage = '';
        if (\preg_match('{ +as +' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))?$}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias must be an exact version';
        } elseif (\preg_match('{^' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))? +as +}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias source must be an exact version, if it is a branch name you should prefix it with dev-';
        }
        throw new \UnexpectedValueException('Invalid version string "' . $origVersion . '"' . $extraMessage);
    }
    public function parseNumericAliasPrefix($branch)
    {
        if (\preg_match('{^(?P<version>(\\d++\\.)*\\d++)(?:\\.x)?-dev$}i', $branch, $matches)) {
            return $matches['version'] . '.';
        }
        return \false;
    }
    public function normalizeBranch($name)
    {
        $name = \trim($name);
        if (\preg_match('{^v?(\\d++)(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?$}i', $name, $matches)) {
            $version = '';
            for ($i = 1; $i < 5; ++$i) {
                $version .= isset($matches[$i]) ? \str_replace(array('*', 'X'), 'x', $matches[$i]) : '.x';
            }
            return \str_replace('x', '9999999', $version) . '-dev';
        }
        return 'dev-' . $name;
    }
    public function normalizeDefaultBranch($name)
    {
        if ($name === 'dev-master' || $name === 'dev-default' || $name === 'dev-trunk') {
            return '9999999-dev';
        }
        return $name;
    }
    public function parseConstraints($constraints)
    {
        $prettyConstraint = $constraints;
        $orConstraints = \preg_split('{\\s*\\|\\|?\\s*}', \trim($constraints));
        $orGroups = array();
        foreach ($orConstraints as $constraints) {
            $andConstraints = \preg_split('{(?<!^|as|[=>< ,]) *(?<!-)[, ](?!-) *(?!,|as|$)}', $constraints);
            if (\count($andConstraints) > 1) {
                $constraintObjects = array();
                foreach ($andConstraints as $constraint) {
                    foreach ($this->parseConstraint($constraint) as $parsedConstraint) {
                        $constraintObjects[] = $parsedConstraint;
                    }
                }
            } else {
                $constraintObjects = $this->parseConstraint($andConstraints[0]);
            }
            if (1 === \count($constraintObjects)) {
                $constraint = $constraintObjects[0];
            } else {
                $constraint = new MultiConstraint($constraintObjects);
            }
            $orGroups[] = $constraint;
        }
        $constraint = MultiConstraint::create($orGroups, \false);
        $constraint->setPrettyString($prettyConstraint);
        return $constraint;
    }
    private function parseConstraint($constraint)
    {
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^([^,\\s]*?)@(' . self::$stabilitiesRegex . ')$}i', $constraint, $match)) {
            $constraint = '' !== $match[1] ? $match[1] : '*';
            if ($match[2] !== 'stable') {
                $stabilityModifier = $match[2];
            }
        }
        if (\preg_match('{^(dev-[^,\\s@]+?|[^,\\s@]+?\\.x-dev)#.+$}i', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^(v)?[xX*](\\.[xX*])*$}i', $constraint, $match)) {
            if (!empty($match[1]) || !empty($match[2])) {
                return array(new Constraint('>=', '0.0.0.0-dev'));
            }
            return array(new MatchAllConstraint());
        }
        $versionRegex = 'v?(\\d++)(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?' . self::$modifierRegex . '(?:\\+[^\\s]+)?';
        if (\preg_match('{^~>?' . $versionRegex . '$}i', $constraint, $matches)) {
            if (\strpos($constraint, '~>') === 0) {
                throw new \UnexpectedValueException('Could not parse version constraint ' . $constraint . ': ' . 'Invalid operator "~>", you probably meant to use the "~" operator');
            }
            if (isset($matches[4]) && '' !== $matches[4] && null !== $matches[4]) {
                $position = 4;
            } elseif (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            for ($i = $position; $i >= 0; $i--) {
                if ($matches[$i] === 'x' || $matches[$i] === 'X' || $matches[$i] === '*') {
                    $matches[$i] = '9999999';
                }
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highPosition = \max(1, $position - 1);
            $highVersion = $this->manipulateVersionString($matches, $highPosition, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^\\^' . $versionRegex . '($)}i', $constraint, $matches)) {
            if ('0' !== $matches[1] || '' === $matches[2] || null === $matches[2]) {
                $position = 1;
            } elseif ('0' !== $matches[2] || '' === $matches[3] || null === $matches[3]) {
                $position = 2;
            } else {
                $position = 3;
            }
            if ($position === 2 && ($matches[2] === 'x' || $matches[2] === 'X' || $matches[2] === '*')) {
                $position = 1;
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^v?(\\d++)(?:\\.(\\d++))?(?:\\.(\\d++))?(?:\\.[xX*])++$}', $constraint, $matches)) {
            if (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            $lowVersion = $this->manipulateVersionString($matches, $position) . '-dev';
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            if ($lowVersion === '0.0.0.0-dev') {
                return array(new Constraint('<', $highVersion));
            }
            return array(new Constraint('>=', $lowVersion), new Constraint('<', $highVersion));
        }
        if (\preg_match('{^(?P<from>' . $versionRegex . ') +- +(?P<to>' . $versionRegex . ')($)}i', $constraint, $matches)) {
            $lowStabilitySuffix = '';
            if (empty($matches[6]) && empty($matches[8])) {
                $lowStabilitySuffix = '-dev';
            }
            $lowVersion = $this->normalize($matches['from']);
            $lowerBound = new Constraint('>=', $lowVersion . $lowStabilitySuffix);
            $empty = function ($x) {
                return $x === 0 || $x === '0' ? \false : empty($x);
            };
            if (!$empty($matches[11]) && !$empty($matches[12]) || !empty($matches[14]) || !empty($matches[16])) {
                $highVersion = $this->normalize($matches['to']);
                $upperBound = new Constraint('<=', $highVersion);
            } else {
                $highMatch = array('', $matches[10], $matches[11], $matches[12], $matches[13]);
                $this->normalize($matches['to']);
                $highVersion = $this->manipulateVersionString($highMatch, $empty($matches[11]) ? 1 : 2, 1) . '-dev';
                $upperBound = new Constraint('<', $highVersion);
            }
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^(<>|!=|>=?|<=?|==?)?\\s*(.*)}', $constraint, $matches)) {
            try {
                try {
                    $version = $this->normalize($matches[2]);
                } catch (\UnexpectedValueException $e) {
                    if (\substr($matches[2], -4) === '-dev') {
                        $version = $this->normalize('dev-' . \substr($matches[2], 0, -4));
                    } else {
                        throw $e;
                    }
                }
                $op = $matches[1] ?: '=';
                if ($op !== '==' && $op !== '=' && !empty($stabilityModifier) && self::parseStability($version) === 'stable') {
                    $version .= '-' . $stabilityModifier;
                } elseif ('<' === $op || '>=' === $op) {
                    if (!\preg_match('/-' . self::$modifierRegex . '$/', \strtolower($matches[2]))) {
                        if (\strpos($matches[2], 'dev-') !== 0) {
                            $version .= '-dev';
                        }
                    }
                }
                return array(new Constraint($matches[1] ?: '=', $version));
            } catch (\Exception $e) {
            }
        }
        $message = 'Could not parse version constraint ' . $constraint;
        if (isset($e)) {
            $message .= ': ' . $e->getMessage();
        }
        throw new \UnexpectedValueException($message);
    }
    private function manipulateVersionString($matches, $position, $increment = 0, $pad = '0')
    {
        for ($i = 4; $i > 0; --$i) {
            if ($i > $position) {
                $matches[$i] = $pad;
            } elseif ($i === $position && $increment) {
                $matches[$i] += $increment;
                if ($matches[$i] < 0) {
                    $matches[$i] = $pad;
                    --$position;
                    if ($i === 1) {
                        return null;
                    }
                }
            }
        }
        return $matches[1] . '.' . $matches[2] . '.' . $matches[3] . '.' . $matches[4];
    }
    private function expandStability($stability)
    {
        $stability = \strtolower($stability);
        switch ($stability) {
            case 'a':
                return 'alpha';
            case 'b':
                return 'beta';
            case 'p':
            case 'pl':
                return 'patch';
            case 'rc':
                return 'RC';
            default:
                return $stability;
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

interface ConstraintInterface
{
    public function matches(ConstraintInterface $provider);
    public function compile($operator);
    public function getUpperBound();
    public function getLowerBound();
    public function getPrettyString();
    public function setPrettyString($prettyString);
    public function __toString();
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class MultiConstraint implements ConstraintInterface
{
    protected $constraints;
    protected $prettyString;
    protected $string;
    protected $conjunctive;
    protected $lowerBound;
    protected $upperBound;
    public function __construct(array $constraints, $conjunctive = \true)
    {
        if (\count($constraints) < 2) {
            throw new \InvalidArgumentException('Must provide at least two constraints for a MultiConstraint. Use ' . 'the regular Constraint class for one constraint only or MatchAllConstraint for none. You may use ' . 'MultiConstraint::create() which optimizes and handles those cases automatically.');
        }
        $this->constraints = $constraints;
        $this->conjunctive = $conjunctive;
    }
    public function getConstraints()
    {
        return $this->constraints;
    }
    public function isConjunctive()
    {
        return $this->conjunctive;
    }
    public function isDisjunctive()
    {
        return !$this->conjunctive;
    }
    public function compile($otherOperator)
    {
        $parts = array();
        foreach ($this->constraints as $constraint) {
            $code = $constraint->compile($otherOperator);
            if ($code === 'true') {
                if (!$this->conjunctive) {
                    return 'true';
                }
            } elseif ($code === 'false') {
                if ($this->conjunctive) {
                    return 'false';
                }
            } else {
                $parts[] = '(' . $code . ')';
            }
        }
        if (!$parts) {
            return $this->conjunctive ? 'true' : 'false';
        }
        return $this->conjunctive ? \implode('&&', $parts) : \implode('||', $parts);
    }
    public function matches(ConstraintInterface $provider)
    {
        if (\false === $this->conjunctive) {
            foreach ($this->constraints as $constraint) {
                if ($provider->matches($constraint)) {
                    return \true;
                }
            }
            return \false;
        }
        foreach ($this->constraints as $constraint) {
            if (!$provider->matches($constraint)) {
                return \false;
            }
        }
        return \true;
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return (string) $this;
    }
    public function __toString()
    {
        if ($this->string !== null) {
            return $this->string;
        }
        $constraints = array();
        foreach ($this->constraints as $constraint) {
            $constraints[] = (string) $constraint;
        }
        return $this->string = '[' . \implode($this->conjunctive ? ' ' : ' || ', $constraints) . ']';
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    public static function create(array $constraints, $conjunctive = \true)
    {
        if (0 === \count($constraints)) {
            return new MatchAllConstraint();
        }
        if (1 === \count($constraints)) {
            return $constraints[0];
        }
        $optimized = self::optimizeConstraints($constraints, $conjunctive);
        if ($optimized !== null) {
            list($constraints, $conjunctive) = $optimized;
            if (\count($constraints) === 1) {
                return $constraints[0];
            }
        }
        return new self($constraints, $conjunctive);
    }
    private static function optimizeConstraints(array $constraints, $conjunctive)
    {
        if (!$conjunctive) {
            $left = $constraints[0];
            $mergedConstraints = array();
            $optimized = \false;
            for ($i = 1, $l = \count($constraints); $i < $l; $i++) {
                $right = $constraints[$i];
                if ($left instanceof MultiConstraint && $left->conjunctive && $right instanceof MultiConstraint && $right->conjunctive && ($left0 = (string) $left->constraints[0]) && $left0[0] === '>' && $left0[1] === '=' && ($left1 = (string) $left->constraints[1]) && $left1[0] === '<' && ($right0 = (string) $right->constraints[0]) && $right0[0] === '>' && $right0[1] === '=' && ($right1 = (string) $right->constraints[1]) && $right1[0] === '<' && \substr($left1, 2) === \substr($right0, 3)) {
                    $optimized = \true;
                    $left = new MultiConstraint(\array_merge(array($left->constraints[0], $right->constraints[1]), \array_slice($left->constraints, 2), \array_slice($right->constraints, 2)), \true);
                } else {
                    $mergedConstraints[] = $left;
                    $left = $right;
                }
            }
            if ($optimized) {
                $mergedConstraints[] = $left;
                return array($mergedConstraints, \false);
            }
        }
        return null;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        foreach ($this->constraints as $constraint) {
            if (null === $this->lowerBound && null === $this->upperBound) {
                $this->lowerBound = $constraint->getLowerBound();
                $this->upperBound = $constraint->getUpperBound();
                continue;
            }
            if ($constraint->getLowerBound()->compareTo($this->lowerBound, $this->isConjunctive() ? '>' : '<')) {
                $this->lowerBound = $constraint->getLowerBound();
            }
            if ($constraint->getUpperBound()->compareTo($this->upperBound, $this->isConjunctive() ? '<' : '>')) {
                $this->upperBound = $constraint->getUpperBound();
            }
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class Constraint implements ConstraintInterface
{
    const OP_EQ = 0;
    const OP_LT = 1;
    const OP_LE = 2;
    const OP_GT = 3;
    const OP_GE = 4;
    const OP_NE = 5;
    /**
    @phpstan-var
    */
    private static $transOpStr = array('=' => self::OP_EQ, '==' => self::OP_EQ, '<' => self::OP_LT, '<=' => self::OP_LE, '>' => self::OP_GT, '>=' => self::OP_GE, '<>' => self::OP_NE, '!=' => self::OP_NE);
    /**
    @phpstan-var
    */
    private static $transOpInt = array(self::OP_EQ => '==', self::OP_LT => '<', self::OP_LE => '<=', self::OP_GT => '>', self::OP_GE => '>=', self::OP_NE => '!=');
    /**
    @phpstan-var
    */
    protected $operator;
    protected $version;
    protected $prettyString;
    protected $lowerBound;
    protected $upperBound;
    public function __construct($operator, $version)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $this->operator = self::$transOpStr[$operator];
        $this->version = $version;
    }
    public function getVersion()
    {
        return $this->version;
    }
    public function getOperator()
    {
        return self::$transOpInt[$this->operator];
    }
    public function matches(ConstraintInterface $provider)
    {
        if ($provider instanceof self) {
            return $this->matchSpecific($provider);
        }
        return $provider->matches($this);
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return $this->__toString();
    }
    public static function getSupportedOperators()
    {
        return \array_keys(self::$transOpStr);
    }
    /**
    @phpstan-return
    */
    public static function getOperatorConstant($operator)
    {
        return self::$transOpStr[$operator];
    }
    public function versionCompare($a, $b, $operator, $compareBranches = \false)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $aIsBranch = 'dev-' === \substr($a, 0, 4);
        $bIsBranch = 'dev-' === \substr($b, 0, 4);
        if ($operator === '!=' && ($aIsBranch || $bIsBranch)) {
            return $a !== $b;
        }
        if ($aIsBranch && $bIsBranch) {
            return $operator === '==' && $a === $b;
        }
        if (!$compareBranches && ($aIsBranch || $bIsBranch)) {
            return \false;
        }
        return \version_compare($a, $b, $operator);
    }
    public function compile($otherOperator)
    {
        if ($this->version[0] === 'd' && 'dev-' === \substr($this->version, 0, 4)) {
            if (self::OP_EQ === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('$b && $v === %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                return 'false';
            }
            if (self::OP_NE === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return 'true';
                }
                return '!$b';
            }
            return 'false';
        }
        if (self::OP_EQ === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('\\version_compare($v, %s, \'==\')', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return \sprintf('$b || \\version_compare($v, %s, \'!=\')', \var_export($this->version, \true));
            }
            return \sprintf('!$b && \\version_compare(%s, $v, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$otherOperator]);
        }
        if (self::OP_NE === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('$b || (!$b && \\version_compare($v, %s, \'!=\'))', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return 'true';
            }
            return '!$b';
        }
        if (self::OP_LT === $this->operator || self::OP_LE === $this->operator) {
            if (self::OP_LT === $otherOperator || self::OP_LE === $otherOperator) {
                return '!$b';
            }
        } elseif (self::OP_GT === $this->operator || self::OP_GE === $this->operator) {
            if (self::OP_GT === $otherOperator || self::OP_GE === $otherOperator) {
                return '!$b';
            }
        }
        if (self::OP_NE === $otherOperator) {
            return 'true';
        }
        $codeComparison = \sprintf('\\version_compare($v, %s, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$this->operator]);
        if ($this->operator === self::OP_LE) {
            if ($otherOperator === self::OP_GT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        } elseif ($this->operator === self::OP_GE) {
            if ($otherOperator === self::OP_LT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        }
        return \sprintf('!$b && %s', $codeComparison);
    }
    public function matchSpecific(Constraint $provider, $compareBranches = \false)
    {
        $noEqualOp = \str_replace('=', '', self::$transOpInt[$this->operator]);
        $providerNoEqualOp = \str_replace('=', '', self::$transOpInt[$provider->operator]);
        $isEqualOp = self::OP_EQ === $this->operator;
        $isNonEqualOp = self::OP_NE === $this->operator;
        $isProviderEqualOp = self::OP_EQ === $provider->operator;
        $isProviderNonEqualOp = self::OP_NE === $provider->operator;
        if ($isNonEqualOp || $isProviderNonEqualOp) {
            if ($isNonEqualOp && !$isProviderNonEqualOp && !$isProviderEqualOp && 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            if ($isProviderNonEqualOp && !$isNonEqualOp && !$isEqualOp && 'dev-' === \substr($this->version, 0, 4)) {
                return \false;
            }
            if (!$isEqualOp && !$isProviderEqualOp) {
                return \true;
            }
            return $this->versionCompare($provider->version, $this->version, '!=', $compareBranches);
        }
        if ($this->operator !== self::OP_EQ && $noEqualOp === $providerNoEqualOp) {
            if ('dev-' === \substr($this->version, 0, 4) || 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            return \true;
        }
        $version1 = $isEqualOp ? $this->version : $provider->version;
        $version2 = $isEqualOp ? $provider->version : $this->version;
        $operator = $isEqualOp ? $provider->operator : $this->operator;
        if ($this->versionCompare($version1, $version2, self::$transOpInt[$operator], $compareBranches)) {
            return !(self::$transOpInt[$provider->operator] === $providerNoEqualOp && self::$transOpInt[$this->operator] !== $noEqualOp && \version_compare($provider->version, $this->version, '=='));
        }
        return \false;
    }
    public function __toString()
    {
        return self::$transOpInt[$this->operator] . ' ' . $this->version;
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        if (\strpos($this->version, 'dev-') === 0) {
            $this->lowerBound = Bound::zero();
            $this->upperBound = Bound::positiveInfinity();
            return;
        }
        switch ($this->operator) {
            case self::OP_EQ:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_LT:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \false);
                break;
            case self::OP_LE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_GT:
                $this->lowerBound = new Bound($this->version, \false);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_GE:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_NE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = Bound::positiveInfinity();
                break;
        }
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

class Terminal
{
    private static $width;
    private static $height;
    private static $stty;
    public function getWidth()
    {
        $width = \getenv('COLUMNS');
        if (\false !== $width) {
            return (int) \trim($width);
        }
        if (null === self::$width) {
            self::initDimensions();
        }
        return self::$width ?: 80;
    }
    public function getHeight()
    {
        $height = \getenv('LINES');
        if (\false !== $height) {
            return (int) \trim($height);
        }
        if (null === self::$height) {
            self::initDimensions();
        }
        return self::$height ?: 50;
    }
    public static function hasSttyAvailable()
    {
        if (null !== self::$stty) {
            return self::$stty;
        }
        if (!\function_exists('exec')) {
            return \false;
        }
        \exec('stty 2>&1', $output, $exitcode);
        return self::$stty = 0 === $exitcode;
    }
    private static function initDimensions()
    {
        if ('\\' === \DIRECTORY_SEPARATOR) {
            if (\preg_match('/^(\\d+)x(\\d+)(?: \\((\\d+)x(\\d+)\\))?$/', \trim(\getenv('ANSICON')), $matches)) {
                self::$width = (int) $matches[1];
                self::$height = isset($matches[4]) ? (int) $matches[4] : (int) $matches[2];
            } elseif (!self::hasVt100Support() && self::hasSttyAvailable()) {
                self::initDimensionsUsingStty();
            } elseif (null !== ($dimensions = self::getConsoleMode())) {
                self::$width = (int) $dimensions[0];
                self::$height = (int) $dimensions[1];
            }
        } else {
            self::initDimensionsUsingStty();
        }
    }
    private static function hasVt100Support()
    {
        return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\fopen('php://stdout', 'wb'));
    }
    private static function initDimensionsUsingStty()
    {
        if ($sttyString = self::getSttyColumns()) {
            if (\preg_match('/rows.(\\d+);.columns.(\\d+);/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            } elseif (\preg_match('/;.(\\d+).rows;.(\\d+).columns/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            }
        }
    }
    private static function getConsoleMode()
    {
        $info = self::readFromProcess('mode CON');
        if (null === $info || !\preg_match('/--------+\\r?\\n.+?(\\d+)\\r?\\n.+?(\\d+)\\r?\\n/', $info, $matches)) {
            return null;
        }
        return array((int) $matches[2], (int) $matches[1]);
    }
    private static function getSttyColumns()
    {
        return self::readFromProcess('stty -a | grep columns');
    }
    private static function readFromProcess($command)
    {
        if (!\function_exists('proc_open')) {
            return null;
        }
        $descriptorspec = array(1 => array('pipe', 'w'), 2 => array('pipe', 'w'));
        $process = \proc_open($command, $descriptorspec, $pipes, null, null, array('suppress_errors' => \true));
        if (!\is_resource($process)) {
            return null;
        }
        $info = \stream_get_contents($pipes[1]);
        \fclose($pipes[1]);
        \fclose($pipes[2]);
        \proc_close($process);
        return $info;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IO
{
    const VERBOSITY_QUIET = 16;
    const VERBOSITY_NORMAL = 32;
    const VERBOSITY_VERBOSE = 64;
    const VERBOSITY_VERY_VERBOSE = 128;
    const VERBOSITY_DEBUG = 256;
    private $interactive;
    private $verbosity = self::VERBOSITY_NORMAL;
    private $colorSupport;
    private $options;
    public function __construct()
    {
        $this->options = \implode(' ', $_SERVER['argv']);
        $shellVerbosity = $this->configureVerbosity();
        $this->interactive = $this->checkInteractivity($shellVerbosity);
        $this->colorSupport = $this->checkColorSupport();
    }
    public function isInteractive()
    {
        return $this->interactive;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function hasColorSupport()
    {
        return $this->colorSupport;
    }
    public function hasParameter($values)
    {
        $values = (array) $values;
        foreach ($values as $value) {
            $regexp = \sprintf('/\\s%s\\b/', \str_replace(' ', '\\s+', \preg_quote($value, '/')));
            if (1 === \preg_match($regexp, $this->options)) {
                return \true;
            }
        }
        return \false;
    }
    private function checkInteractivity($shellVerbosity)
    {
        if (-1 === $shellVerbosity) {
            return \false;
        }
        if (\true === $this->hasParameter(array('--no-interaction', '-n'))) {
            return \false;
        }
        if (\function_exists('posix_isatty') && !@\posix_isatty(\STDOUT) && \false === \getenv('SHELL_INTERACTIVE')) {
            return \false;
        }
        return \true;
    }
    private function configureVerbosity()
    {
        switch ($shellVerbosity = (int) \getenv('SHELL_VERBOSITY')) {
            case -1:
                $this->verbosity = self::VERBOSITY_QUIET;
                break;
            case 1:
                $this->verbosity = self::VERBOSITY_VERBOSE;
                break;
            case 2:
                $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
                break;
            case 3:
                $this->verbosity = self::VERBOSITY_DEBUG;
                break;
            default:
                $shellVerbosity = 0;
                break;
        }
        if ($this->hasParameter(array('--quiet', '-q'))) {
            $this->verbosity = self::VERBOSITY_QUIET;
            $shellVerbosity = -1;
        } elseif ($this->hasParameter(array('-vvv', '--verbose=3', '--verbose 3'))) {
            $this->verbosity = self::VERBOSITY_DEBUG;
            $shellVerbosity = 3;
        } elseif ($this->hasParameter(array('-vv', '--verbose=2', '--verbose 2'))) {
            $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
            $shellVerbosity = 2;
        } elseif ($this->hasParameter(array('-v', '--verbose=1', '--verbose 1', '--verbose'))) {
            $this->verbosity = self::VERBOSITY_VERBOSE;
            $shellVerbosity = 1;
        }
        return $shellVerbosity;
    }
    private function checkColorSupport()
    {
        if ($this->hasParameter(array('--ansi'))) {
            return \true;
        }
        if ($this->hasParameter(array('--no-ansi'))) {
            return \false;
        }
        if (\DIRECTORY_SEPARATOR === '\\') {
            return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\STDOUT) || \false !== \getenv('ANSICON') || 'ON' === \getenv('ConEmuANSI') || 'xterm' === \getenv('TERM');
        }
        if (\function_exists('stream_isatty')) {
            return \stream_isatty(\STDOUT);
        }
        if (\function_exists('posix_isatty')) {
            return \posix_isatty(\STDOUT);
        }
        $stat = \fstat(\STDOUT);
        return $stat ? 020000 === ($stat['mode'] & 0170000) : \false;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IsExtensionFulfilled implements IsFulfilled
{
    private $requiredExtension;
    public function __construct($requiredExtension)
    {
        $this->requiredExtension = $requiredExtension;
    }
    public function __invoke()
    {
        return \extension_loaded($this->requiredExtension);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Checker
{
    private static $requirementsConfig;
    public static function checkRequirements()
    {
        $requirements = self::retrieveRequirements();
        $checkPassed = $requirements->evaluateRequirements();
        $io = new IO();
        self::printCheck($checkPassed, new Printer($io->getVerbosity(), $io->hasColorSupport()), $requirements);
        return $checkPassed;
    }
    public static function printCheck($checkPassed, Printer $printer, RequirementCollection $requirements)
    {
        if (\false === $checkPassed && IO::VERBOSITY_VERY_VERBOSE > $printer->getVerbosity()) {
            $printer->setVerbosity(IO::VERBOSITY_VERY_VERBOSE);
        }
        $verbosity = IO::VERBOSITY_VERY_VERBOSE;
        $iniPath = $requirements->getPhpIniPath();
        $printer->title('Box Requirements Checker', $verbosity);
        $printer->printv('> Using PHP ', $verbosity);
        $printer->printvln(\PHP_VERSION, $verbosity, 'green');
        $printer->printvln('> PHP is using the following php.ini file:', $verbosity);
        if ($iniPath) {
            $printer->printvln('  ' . $iniPath, $verbosity, 'green');
        } else {
            $printer->printvln('  WARNING: No configuration file (php.ini) used by PHP!', $verbosity, 'yellow');
        }
        $printer->printvln('', $verbosity);
        if (\count($requirements) > 0) {
            $printer->printvln('> Checking Box requirements:', $verbosity);
            $printer->printv('  ', $verbosity);
        } else {
            $printer->printvln('> No requirements found.', $verbosity);
        }
        $errorMessages = array();
        foreach ($requirements->getRequirements() as $requirement) {
            if ($errorMessage = $printer->getRequirementErrorMessage($requirement)) {
                if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                    $printer->printvln('✘ ' . $requirement->getTestMessage(), IO::VERBOSITY_DEBUG, 'red');
                    $printer->printv('  ', IO::VERBOSITY_DEBUG);
                    $errorMessages[] = $errorMessage;
                } else {
                    $printer->printv('E', $verbosity, 'red');
                    $errorMessages[] = $errorMessage;
                }
                continue;
            }
            if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                $printer->printvln('✔ ' . $requirement->getHelpText(), IO::VERBOSITY_DEBUG, 'green');
                $printer->printv('  ', IO::VERBOSITY_DEBUG);
            } else {
                $printer->printv('.', $verbosity, 'green');
            }
        }
        if (IO::VERBOSITY_DEBUG !== $printer->getVerbosity() && \count($requirements) > 0) {
            $printer->printvln('', $verbosity);
        }
        if ($requirements->evaluateRequirements()) {
            $printer->block('OK', 'Your system is ready to run the application.', $verbosity, 'success');
        } else {
            $printer->block('ERROR', 'Your system is not ready to run the application.', $verbosity, 'error');
            $printer->title('Fix the following mandatory requirements:', $verbosity, 'red');
            foreach ($errorMessages as $errorMessage) {
                $printer->printv(' * ' . $errorMessage, $verbosity);
            }
        }
        $printer->printvln('', $verbosity);
    }
    private static function retrieveRequirements()
    {
        if (null === self::$requirementsConfig) {
            self::$requirementsConfig = __DIR__ . '/../.requirements.php';
        }
        $config = (require self::$requirementsConfig);
        $requirements = new RequirementCollection();
        foreach ($config as $constraint) {
            $requirements->addRequirement('php' === $constraint['type'] ? new IsPhpVersionFulfilled($constraint['condition']) : new IsExtensionFulfilled($constraint['condition']), $constraint['message'], $constraint['helpMessage']);
        }
        return $requirements;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use HumbugBox3150\Composer\Semver\Semver;
final class IsPhpVersionFulfilled implements IsFulfilled
{
    private $requiredPhpVersion;
    public function __construct($requiredPhpVersion)
    {
        $this->requiredPhpVersion = $requiredPhpVersion;
    }
    public function __invoke()
    {
        return Semver::satisfies(\sprintf('%d.%d.%d', \PHP_MAJOR_VERSION, \PHP_MINOR_VERSION, \PHP_RELEASE_VERSION), $this->requiredPhpVersion);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use ArrayIterator;
use Countable;
use IteratorAggregate;
use ReturnTypeWillChange;
use Traversable;
final class RequirementCollection implements IteratorAggregate, Countable
{
    private $requirements = array();
    #[\ReturnTypeWillChange]
    public function getIterator()
    {
        return new ArrayIterator($this->requirements);
    }
    #[\ReturnTypeWillChange]
    public function count()
    {
        return \count($this->requirements);
    }
    public function add(Requirement $requirement)
    {
        $this->requirements[] = $requirement;
    }
    public function addRequirement($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->add(new Requirement($checkIsFulfilled, $testMessage, $helpText));
    }
    public function getRequirements()
    {
        return $this->requirements;
    }
    public function getPhpIniPath()
    {
        return \get_cfg_var('cfg_file_path');
    }
    public function evaluateRequirements()
    {
        return \array_reduce($this->requirements, function ($checkPassed, Requirement $requirement) {
            return $checkPassed && $requirement->isFulfilled();
        }, \true);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Printer
{
    private $styles = array('reset' => "\x1b[0m", 'red' => "\x1b[31m", 'green' => "\x1b[32m", 'yellow' => "\x1b[33m", 'title' => "\x1b[33m", 'error' => "\x1b[37;41m", 'success' => "\x1b[30;42m");
    private $verbosity;
    private $supportColors;
    private $width;
    public function __construct($verbosity, $supportColors, $width = null)
    {
        if (null === $width) {
            $terminal = new Terminal();
            $width = $terminal->getWidth();
        }
        $this->verbosity = $verbosity;
        $this->supportColors = $supportColors;
        $this->width = $width ?: 80;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function setVerbosity($verbosity)
    {
        $this->verbosity = $verbosity;
    }
    public function title($title, $verbosity, $style = null)
    {
        if (null === $style) {
            $style = 'title';
        }
        $this->printvln('', $verbosity, $style);
        $this->printvln($title, $verbosity, $style);
        $this->printvln(\str_repeat('=', \min(\strlen($title), $this->width)), $verbosity, $style);
        $this->printvln('', $verbosity, $style);
    }
    public function getRequirementErrorMessage(Requirement $requirement)
    {
        if ($requirement->isFulfilled()) {
            return null;
        }
        $errorMessage = \wordwrap($requirement->getTestMessage(), $this->width - 3, \PHP_EOL . '   ') . \PHP_EOL;
        return $errorMessage;
    }
    public function block($title, $message, $verbosity, $style = null)
    {
        $prefix = ' [' . $title . '] ';
        $lineLength = $this->width - \strlen($prefix) - 1;
        if ($lineLength < 0) {
            $lineLength = 0;
        }
        $message = $prefix . \trim($message);
        $lines = array();
        $remainingMessage = $message;
        $wrapped = \wordwrap($remainingMessage, $lineLength, '¬');
        $wrapped = \explode('¬', $wrapped);
        do {
            $line = \array_shift($wrapped);
            if ($lines && $lineLength > 0) {
                $line = \str_repeat(' ', \strlen($prefix)) . \ltrim($line);
            }
            $lines[] = \str_pad($line, $this->width, ' ', \STR_PAD_RIGHT);
        } while (\count($wrapped));
        $this->printvln('', $verbosity);
        $this->printvln(\str_repeat(' ', $this->width), $verbosity, $style);
        foreach ($lines as $line) {
            $this->printvln($line, $verbosity, $style);
        }
        $this->printv(\str_repeat(' ', $this->width), $verbosity, $style);
        $this->printvln('', $verbosity);
    }
    public function printvln($message, $verbosity, $style = null)
    {
        $this->printv($message, $verbosity, $style);
        $this->printv(\PHP_EOL, $verbosity, null);
    }
    public function printv($message, $verbosity, $style = null)
    {
        if ($verbosity > $this->verbosity) {
            return;
        }
        $message = \wordwrap($message, $this->width);
        $message = \sprintf('%s%s%s', $this->supportColors && isset($this->styles[$style]) ? $this->styles[$style] : '', $message, $this->supportColors ? $this->styles['reset'] : '');
        echo $message;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

interface IsFulfilled
{
    public function __invoke();
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Requirement
{
    private $checkIsFulfilled;
    private $fulfilled;
    private $testMessage;
    private $helpText;
    public function __construct($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->checkIsFulfilled = $checkIsFulfilled;
        $this->testMessage = $testMessage;
        $this->helpText = $helpText;
    }
    public function isFulfilled()
    {
        if (null === $this->fulfilled) {
            $this->fulfilled = $this->checkIsFulfilled->__invoke();
        }
        return (bool) $this->fulfilled;
    }
    public function getIsFullfilledChecker()
    {
        return $this->checkIsFulfilled;
    }
    public function getTestMessage()
    {
        return $this->testMessage;
    }
    public function getHelpText()
    {
        return $this->helpText;
    }
}
                   GNU LESSER GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  0. Additional Definitions.

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  1. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  2. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

   a) under this License, provided that you make a good faith effort to
   ensure that, in the event an Application does not supply the
   function or data, the facility still operates, and performs
   whatever part of its purpose remains meaningful, or

   b) under the GNU GPL, with none of the additional permissions of
   this License applicable to that copy.

  3. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

   a) Give prominent notice with each copy of the object code that the
   Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the object code with a copy of the GNU GPL and this license
   document.

  4. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

   a) Give prominent notice with each copy of the Combined Work that
   the Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the Combined Work with a copy of the GNU GPL and this license
   document.

   c) For a Combined Work that displays copyright notices during
   execution, include the copyright notice for the Library among
   these notices, as well as a reference directing the user to the
   copies of the GNU GPL and this license document.

   d) Do one of the following:

       0) Convey the Minimal Corresponding Source under the terms of this
       License, and the Corresponding Application Code in a form
       suitable for, and under terms that permit, the user to
       recombine or relink the Application with a modified version of
       the Linked Version to produce a modified Combined Work, in the
       manner specified by section 6 of the GNU GPL for conveying
       Corresponding Source.

       1) Use a suitable shared library mechanism for linking with the
       Library.  A suitable mechanism is one that (a) uses at run time
       a copy of the Library already present on the user's computer
       system, and (b) will operate properly with a modified version
       of the Library that is interface-compatible with the Linked
       Version.

   e) Provide Installation Information, but only if you would otherwise
   be required to provide such information under section 6 of the
   GNU GPL, and only to the extent that such information is
   necessary to install and execute a modified version of the
   Combined Work produced by recombining or relinking the
   Application with a modified version of the Linked Version. (If
   you use option 4d0, the Installation Information must accompany
   the Minimal Corresponding Source and Corresponding Application
   Code. If you use option 4d1, you must provide the Installation
   Information in the manner specified by section 6 of the GNU GPL
   for conveying Corresponding Source.)

  5. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

   a) Accompany the combined library with a copy of the same work based
   on the Library, uncombined with any other library facilities,
   conveyed under the terms of this License.

   b) Give prominent notice with the combined library that part of it
   is a work based on the Library, and explaining where to find the
   accompanying uncombined form of the same work.

  6. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
<!doctype html><html lang="en"><head><meta charset="utf-8"><title>Contao Manager</title><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1"/><meta name="description" content=""><meta name="robots" content="noindex,follow"><meta http-equiv="Content-Security-Policy" content="img-src 'self' data: blob: contao.github.io extensions.contao.org; object-src 'none'"/><link rel="icon" type="image/x-icon" href="assets/favicon.ico"><link rel="icon" type="image/png" sizes="16x16" href="assets/favicon-16x16.png"><link rel="icon" type="image/png" sizes="32x32" href="assets/favicon-32x32.png"><link rel="icon" type="image/png" sizes="48x48" href="assets/favicon-48x48.png"><link rel="manifest" href="assets/manifest.webmanifest"><meta name="mobile-web-app-capable" content="yes"><meta name="theme-color" content="#ffffff"><meta name="application-name" content="Contao Manager"><link rel="apple-touch-icon" sizes="57x57" href="assets/apple-touch-icon-57x57.png"><link rel="apple-touch-icon" sizes="60x60" href="assets/apple-touch-icon-60x60.png"><link rel="apple-touch-icon" sizes="72x72" href="assets/apple-touch-icon-72x72.png"><link rel="apple-touch-icon" sizes="76x76" href="assets/apple-touch-icon-76x76.png"><link rel="apple-touch-icon" sizes="114x114" href="assets/apple-touch-icon-114x114.png"><link rel="apple-touch-icon" sizes="120x120" href="assets/apple-touch-icon-120x120.png"><link rel="apple-touch-icon" sizes="144x144" href="assets/apple-touch-icon-144x144.png"><link rel="apple-touch-icon" sizes="152x152" href="assets/apple-touch-icon-152x152.png"><link rel="apple-touch-icon" sizes="167x167" href="assets/apple-touch-icon-167x167.png"><link rel="apple-touch-icon" sizes="180x180" href="assets/apple-touch-icon-180x180.png"><link rel="apple-touch-icon" sizes="1024x1024" href="assets/apple-touch-icon-1024x1024.png"><meta name="apple-mobile-web-app-capable" content="yes"><meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"><meta name="apple-mobile-web-app-title" content="Contao Manager"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-640x1136.png"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1136x640.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-750x1334.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1334x750.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1125x2436.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2436x1125.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1170x2532.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2532x1170.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1179x2556.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2556x1179.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-828x1792.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1792x828.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2688.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2688x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2208.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2208x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1284x2778.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2778x1284.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1290x2796.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2796x1290.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1488x2266.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2266x1488.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1536x2048.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2048x1536.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1620x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1620.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1640x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1640.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2388.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2388x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2224.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2224x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-2048x2732.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2732x2048.png"><meta name="msapplication-TileColor" content="#ffffff"><meta name="msapplication-TileImage" content="assets/mstile-144x144.png"><meta name="msapplication-config" content="assets/browserconfig.xml"><link rel="yandex-tableau-widget" href="assets/yandex-browser-manifest.json"><script defer="defer" src="js/chunk-vendors.2e54a44f.js" type="module"></script><script defer="defer" src="js/app.4e112694.js" type="module"></script><link href="css/chunk-vendors.b192971e.css" rel="stylesheet"><link href="css/app.d418b1bd.css" rel="stylesheet"><script defer="defer" src="js/chunk-vendors-legacy.c4c10512.js" nomodule></script><script defer="defer" src="js/app-legacy.51e2026a.js" nomodule></script></head><body><noscript><strong>We're sorry but the Contao Manager does not work without JavaScript enabled. Please enable it to continue.</strong></noscript><div id="app"></div></body></html><?php

declare(strict_types=1);

/*
 * This file is part of Contao Manager.
 *
 * (c) Contao Association
 *
 * @license LGPL-3.0-or-later
 */

use Contao\ManagerApi\ApiKernel;
use Contao\ManagerApi\HttpKernel\ApiProblemResponse;
use Symfony\Component\HttpFoundation\Request;

require __DIR__.'/../vendor/autoload.php';

try {
    $kernel = new ApiKernel('@symfony_env@' === 'prod' ? 'prod' : 'dev');

    $request = Request::createFromGlobals();
    $response = $kernel->handle($request);
    $response->send();
    $kernel->terminate($request, $response);
} catch (Throwable $e) {
    ApiProblemResponse::createFromException($e, '@symfony_env@' !== 'prod')->send();
}
.popup-overlay{position:fixed;inset:0;z-index:1000;background:var(--popup-overlay-bg)}@media(min-width:960px){.popup-overlay{padding:20px 0;overflow-y:auto}}.loader__item{float:left;width:16px;height:16px;margin-right:1px;background-color:var(--contao);-webkit-animation:loading 1.4s ease-in-out infinite both;animation:loading 1.4s ease-in-out infinite both}.loader__item--20{-webkit-animation-delay:-.64s;animation-delay:-.64s}.loader__item--40{-webkit-animation-delay:-.48s;animation-delay:-.48s}.loader__item--60{-webkit-animation-delay:-.32s;animation-delay:-.32s}.loader__item--80{-webkit-animation-delay:-.16s;animation-delay:-.16s}@-webkit-keyframes loading{0%,90%,to{opacity:0}20%{opacity:1}}@keyframes loading{0%,90%,to{opacity:0}20%{opacity:1}}.loader__text{float:left;width:40px}.sk-circle{width:25px;height:25px;position:relative}.sk-circle .sk-child{width:100%;height:100%;position:absolute;left:0;top:0}.sk-circle .sk-child:before{content:"";display:block;margin:0 auto;width:15%;height:15%;background-color:var(--text);border-radius:100%;-webkit-animation:sk-circleBounceDelay 1.2s ease-in-out infinite both;animation:sk-circleBounceDelay 1.2s ease-in-out infinite both}.sk-circle .sk-circle2{-webkit-transform:rotate(30deg);transform:rotate(30deg)}.sk-circle .sk-circle3{-webkit-transform:rotate(60deg);transform:rotate(60deg)}.sk-circle .sk-circle4{-webkit-transform:rotate(90deg);transform:rotate(90deg)}.sk-circle .sk-circle5{-webkit-transform:rotate(120deg);transform:rotate(120deg)}.sk-circle .sk-circle6{-webkit-transform:rotate(150deg);transform:rotate(150deg)}.sk-circle .sk-circle7{-webkit-transform:rotate(180deg);transform:rotate(180deg)}.sk-circle .sk-circle8{-webkit-transform:rotate(210deg);transform:rotate(210deg)}.sk-circle .sk-circle9{-webkit-transform:rotate(240deg);transform:rotate(240deg)}.sk-circle .sk-circle10{-webkit-transform:rotate(270deg);transform:rotate(270deg)}.sk-circle .sk-circle11{-webkit-transform:rotate(300deg);transform:rotate(300deg)}.sk-circle .sk-circle12{-webkit-transform:rotate(330deg);transform:rotate(330deg)}.sk-circle .sk-circle2:before{-webkit-animation-delay:-1.1s;animation-delay:-1.1s}.sk-circle .sk-circle3:before{-webkit-animation-delay:-1s;animation-delay:-1s}.sk-circle .sk-circle4:before{-webkit-animation-delay:-.9s;animation-delay:-.9s}.sk-circle .sk-circle5:before{-webkit-animation-delay:-.8s;animation-delay:-.8s}.sk-circle .sk-circle6:before{-webkit-animation-delay:-.7s;animation-delay:-.7s}.sk-circle .sk-circle7:before{-webkit-animation-delay:-.6s;animation-delay:-.6s}.sk-circle .sk-circle8:before{-webkit-animation-delay:-.5s;animation-delay:-.5s}.sk-circle .sk-circle9:before{-webkit-animation-delay:-.4s;animation-delay:-.4s}.sk-circle .sk-circle10:before{-webkit-animation-delay:-.3s;animation-delay:-.3s}.sk-circle .sk-circle11:before{-webkit-animation-delay:-.2s;animation-delay:-.2s}.sk-circle .sk-circle12:before{-webkit-animation-delay:-.1s;animation-delay:-.1s}@-webkit-keyframes sk-circleBounceDelay{0%,80%,to{-webkit-transform:scale(0);transform:scale(0)}40%{-webkit-transform:scale(1);transform:scale(1)}}@keyframes sk-circleBounceDelay{0%,80%,to{-webkit-transform:scale(0);transform:scale(0)}40%{-webkit-transform:scale(1);transform:scale(1)}}.widget-button .loader{width:25px;margin:0 auto}.widget-button .sk-circle .sk-child:before{background-color:#fff}.loading-button{position:relative}.loading-button>.loader{position:absolute;left:calc(50% - 12.5px);top:calc(50% - 12.5px)}.loading-button>.loading{visibility:hidden}.theme-switch{position:relative;display:inline-block}.theme-switch button{width:auto;height:auto;padding:0 0 0 24px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--color-scheme) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.theme-switch button:hover{color:var(--black)}.package-logo--fallback[data-v-4e318e6c]{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center}svg[data-v-4e318e6c]{width:80px;height:80px;fill:#ccc}.discover-package{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;position:relative;overflow:hidden;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.discover-package.is--hint{border-color:var(--border--light)}.discover-package.is--hint .discover-package__inside>*{opacity:.65}.discover-package__hint{position:relative;background:var(--border--light);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.2;z-index:1}.discover-package__hint p a{display:inline-block;padding-right:10px}.discover-package__hint p a:first-child{margin-left:10px}.discover-package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.discover-package__inside{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;padding:16px}.discover-package__abandoned{display:inline-block;margin-bottom:1em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);cursor:help;z-index:10}@media(min-width:600px){.discover-package__abandoned{position:absolute;top:20px;left:-25px;padding:2px 30px;border-top:1px solid var(--btn-alert-active);-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}}.discover-package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.discover-package__icon>figure{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;height:100%;max-height:140px}.discover-package__icon img,.discover-package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;-o-object-fit:contain;object-fit:contain}.discover-package__details{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;min-height:96px}.discover-package__headline{margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.discover-package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__versions{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;gap:5px;list-style:none;margin:5px 0;padding:0}.discover-package__version{display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;padding:3px 5px;border-radius:4px;line-height:1;min-width:40px;font-size:13px;color:#fff;background:var(--badge-bg);pointer-events:none}.discover-package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.discover-package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__more{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-flow:row wrap;flex-flow:row wrap;-webkit-box-align:end;-ms-flex-align:end;align-items:flex-end;gap:4px;line-height:28px}.discover-package__counts,.discover-package__more{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.discover-package__counts{-webkit-box-pack:start;-ms-flex-pack:start;justify-content:flex-start}.discover-package__count{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.discover-package__count--private{background-image:var(--svg--private)}.discover-package__count--updated{background-image:var(--svg--updated)}.discover-package__count--downloads{background-image:var(--svg--downloads)}.discover-package__count--favers{background-image:var(--svg--favers)}.discover-package__actions{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;gap:8px}@media(max-width:599.98px){.discover-package__headline-container{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:reverse;-ms-flex-direction:column-reverse;flex-direction:column-reverse}}@media(min-width:600px){.discover-package__inside{text-align:initial;display:-webkit-box;display:-ms-flexbox;display:flex;padding:0}.discover-package__icon{width:130px;height:100%;min-height:130px;margin:0;border-radius:0;position:revert;right:revert}.discover-package__icon img{width:100px;height:100px}.discover-package__icon svg{width:90px;height:90px}.discover-package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);-webkit-box-flex:1;-ms-flex:1;flex:1}.discover-package__versions{float:right;margin:-3px 0 0 16px}.discover-package__description,.discover-package__headline{margin-right:0}.discover-package__more{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row}.discover-package__actions{-webkit-box-pack:end;-ms-flex-pack:end;justify-content:end}}.vueperslide{white-space:normal;background-size:cover;-ms-flex-negative:0;flex-shrink:0;display:block;width:100%;position:relative}.vueperslide--clone-1{position:absolute;top:0;bottom:0;right:100%}.vueperslides--rtl .vueperslide--clone-1{right:auto;left:100%}.vueperslide[href]{-webkit-user-drag:none}.vueperslide__image{background-size:cover}.vueperslide__image,.vueperslide__loader{position:absolute;top:0;left:0;right:0;bottom:0}.vueperslide__loader{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){height:100%;margin:auto}.vueperslides--fade .vueperslide{position:absolute;top:0;left:0;right:0;bottom:0;opacity:0;-webkit-transition:opacity ease-in-out;transition:opacity ease-in-out;-webkit-transition-duration:inherit;transition-duration:inherit}.vueperslides--fade .vueperslide--active,.vueperslides--fade .vueperslide--visible{z-index:1;opacity:1}.vueperslides--slide-image-inside .vueperslide{overflow:hidden}.vueperslides--3d .vueperslide{position:absolute;z-index:-1;height:100%}.vueperslides--3d .vueperslide--active,.vueperslides--3d .vueperslide--next-slide,.vueperslides--3d .vueperslide--previous-slide{z-index:0}.vueperslides--3d .vueperslide--active{z-index:1}.vueperslides--3d .vueperslide[face=front]{-webkit-transform:rotateY(90deg) translateX(-50%) rotateY(-90deg);transform:rotateY(90deg) translateX(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=right]{-webkit-transform:rotateY(90deg) translateX(50%);transform:rotateY(90deg) translateX(50%);-webkit-transform-origin:100% 0;transform-origin:100% 0}.vueperslides--3d .vueperslide[face=back]{-webkit-transform:rotateY(270deg) translateX(-50%) rotateY(-90deg);transform:rotateY(270deg) translateX(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=left]{-webkit-transform:rotateY(270deg) translateX(-50%);transform:rotateY(270deg) translateX(-50%);-webkit-transform-origin:0 0;transform-origin:0 0}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after,.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:before{content:"";position:absolute;bottom:100%;left:-1em;right:-1em;height:2em;-webkit-box-shadow:0 0 20px rgba(0,0,0,.25);box-shadow:0 0 20px rgba(0,0,0,.25);z-index:2}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after{top:100%;bottom:auto}.vueperslides__arrows{color:#fff}.vueperslides__arrows--outside{color:currentColor}.vueperslides__arrow{top:50%;background-color:transparent;border:none;opacity:.7}.vueperslides--rtl .vueperslides__arrow--next,.vueperslides__arrow--prev{right:auto;left:.5em}.vueperslides--rtl .vueperslides__arrow--prev,.vueperslides__arrow--next{left:auto;right:.5em}.vueperslides__arrow:hover{opacity:1}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--next,.vueperslides__arrows--outside .vueperslides__arrow--prev{right:auto;left:-3.5em}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--prev,.vueperslides__arrows--outside .vueperslides__arrow--next{left:auto;right:-3.5em}.vueperslides__paused{top:.7em;right:.7em;opacity:0;text-shadow:0 0 3px rgba(0,0,0,.4);z-index:1}.vueperslides:hover .vueperslides__paused{opacity:1}.vueperslides__bullets:not(.vueperslides__bullets--outside){color:#fff}.vueperslides__bullet{margin:1.5em .6em;padding:0;border:none;background:none}.vueperslides__bullet .default{width:12px;height:12px;border-radius:12px;border:1px solid currentColor;background-color:transparent;-webkit-box-shadow:0 0 1px rgba(0,0,0,.5),0 0 3px rgba(0,0,0,.3);box-shadow:0 0 1px rgba(0,0,0,.5),0 0 3px rgba(0,0,0,.3);-webkit-transition:.4s ease-in-out;transition:.4s ease-in-out;-webkit-box-sizing:border-box;box-sizing:border-box}.vueperslides__bullet .default span{display:none}.vueperslides__bullet--active .default{border-width:6px}.vueperslide,.vueperslide__image{background-position:50%}.vueperslide__video{outline:none}.vueperslide--no-pointer-events:before{content:"";position:absolute;top:0;bottom:0;left:0;right:0}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-flex:1;-ms-flex:1 1 auto;flex:1 1 auto;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;text-align:center}.vueperslide--has-image-inside .vueperslide__content-wrapper,.vueperslide--has-video .vueperslide__content-wrapper,.vueperslide__content-wrapper.parallax-fixed-content{position:absolute;z-index:2;top:0;bottom:0;left:0;right:0;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;pointer-events:none}.vueperslides{position:relative}.vueperslides--fixed-height .vueperslide,.vueperslides--fixed-height .vueperslides__inner,.vueperslides--fixed-height .vueperslides__parallax-wrapper{height:inherit}.vueperslides--fixed-height .vueperslides__parallax-wrapper{padding-bottom:0!important}.vueperslides--fixed-height.vueperslides--bullets-outside{margin-bottom:4em}.vueperslides__inner{position:relative;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.vueperslides__parallax-wrapper{position:relative;overflow:hidden}.vueperslides--3d .vueperslides__parallax-wrapper{overflow:visible}.vueperslides__track{position:absolute;top:0;height:100%;left:0;right:0;overflow:hidden;z-index:1}.vueperslides--parallax .vueperslides__track{height:200%;-webkit-transform:translateY(0);transform:translateY(0)}.vueperslides--touchable .vueperslides__track{cursor:ew-resize;cursor:-webkit-grab;cursor:grab}.vueperslides--touchable .vueperslides__track--dragging,.vueperslides--touchable .vueperslides__track--mousedown{cursor:-webkit-grabbing;cursor:grabbing}.vueperslides--3d .vueperslides__track{overflow:visible;-webkit-perspective:100em;perspective:100em}.vueperslides__track-inner{white-space:nowrap;-webkit-transition:transform .5s ease-in-out;-webkit-transition:-webkit-transform .5s ease-in-out;transition:-webkit-transform .5s ease-in-out;transition:transform .5s ease-in-out;transition:transform .5s ease-in-out,-webkit-transform .5s ease-in-out;height:100%;display:-webkit-box;display:-ms-flexbox;display:flex}.vueperslides--no-animation .vueperslides__track-inner{-webkit-transition-duration:0s!important;transition-duration:0s!important}.vueperslides--fade .vueperslides__track-inner{white-space:normal;-webkit-transition:none;transition:none}.vueperslides--3d .vueperslides__track-inner{-webkit-transform-style:preserve-3d;transform-style:preserve-3d}.vueperslides__track--mousedown .vueperslides__track-inner{-webkit-transition:transform .25s ease-in-out!important;-webkit-transition:-webkit-transform .25s ease-in-out!important;transition:-webkit-transform .25s ease-in-out!important;transition:transform .25s ease-in-out!important;transition:transform .25s ease-in-out,-webkit-transform .25s ease-in-out!important}.vueperslides__track--dragging .vueperslides__track-inner{-webkit-transition:none;transition:none}.vueperslides__arrow{position:absolute;font-size:inherit;color:inherit;text-align:center;-webkit-transform:translateY(-50%);transform:translateY(-50%);cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;outline:none;z-index:2;line-height:1}.vueperslides__arrow,.vueperslides__arrow svg{-webkit-transition:.3s ease-in-out;transition:.3s ease-in-out}.vueperslides__arrow svg{vertical-align:middle;stroke:currentColor;fill:none;width:3.5em;padding:1em;stroke-width:1;-webkit-box-sizing:border-box;box-sizing:border-box}.vueperslides__arrow svg:hover{stroke-width:1.3}.vueperslides__paused{position:absolute;-webkit-transition:.3s ease-in-out;transition:.3s ease-in-out}.vueperslides__bullets{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;position:absolute;bottom:0;left:0;right:0}.vueperslides__bullets--outside{position:relative}.vueperslides__bullet,.vueperslides__bullets button{cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;outline:none;z-index:2;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;color:inherit}.vueperslides__bullet::-moz-focus-inner,.vueperslides__bullets button::-moz-focus-inner{border:0}.vueperslides__fractions{position:absolute;top:.8em;left:.5em;z-index:2;padding:.2em 1em;border:1px solid hsla(0,0%,100%,.5);border-radius:2em;background:hsla(0,0%,100%,.2);color:#fff}.vueperslides__progress{position:absolute;top:0;left:0;right:0;z-index:2;height:6px;color:rgba(0,0,0,.7)}.vueperslides__progress>*{position:absolute;top:0;bottom:0;left:0;background:currentColor;-webkit-transition:.3s ease-in-out;transition:.3s ease-in-out}[data-v-3c070d03]:root{--text:#535353;--link:#f47c00;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.04773c88.svg);--svg--private:url(../img/private.2455f3fb.svg);--svg--updated:url(../img/updated.b67e9160.svg);--svg--downloads:url(../img/downloads.ef96865d.svg);--svg--favers:url(../img/favers.f48a12a8.svg);--svg--language:url(../img/language.509ee1aa.svg);--svg--color-scheme:url(../img/color_scheme.a51e992d.svg)}html[data-color-scheme=dark][data-v-3c070d03]{--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--link-footer:#fff;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.74e01873.svg);--svg--private:url(../img/private--dark.1a50a552.svg);--svg--updated:url(../img/updated--dark.6c7ad8f3.svg);--svg--downloads:url(../img/downloads--dark.6070f904.svg);--svg--favers:url(../img/favers--dark.8589e259.svg);--svg--language:url(../img/language--dark.384e91d7.svg);--svg--color-scheme:url(../img/color_scheme--dark.57222cc0.svg)}html[data-color-scheme=dark] #contao-network[data-v-3c070d03]{background:#292c32!important;color:#ddd!important}img[data-v-3c070d03]{width:100%;aspect-ratio:2}@media(min-width:1200px){.ads[data-v-3c070d03]{margin:59px 0 69px}}.link[data-v-3c070d03]{padding-top:5px;text-align:right}.link a[data-v-3c070d03]{padding-left:16px;font-size:.8em;color:inherit;background:var(--svg--link-blank) left center no-repeat;background-size:13px 13px}.container[data-v-3c070d03]{position:relative;background:var(--popup-bg);-webkit-box-shadow:var(--ad-shadow);box-shadow:var(--ad-shadow);border-radius:14px;overflow:hidden}.package-sorting{margin:20px 0 15px;text-align:right}.package-sorting__label{display:inline-block;text-transform:uppercase}.package-sorting__label:after{content:":"}.package-sorting__group{position:relative;display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;margin:0;padding:0 15px 0 0;list-style-type:none;text-align:left}.package-sorting__group:after{content:"";position:absolute;top:.8em;right:0;width:0;height:0;border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid #777}.package-sorting__item{display:none;margin:0 0 0 10px;padding:3px 0;text-transform:uppercase;cursor:pointer;border-bottom:2px solid transparent}.package-sorting__item:hover{color:var(--link)}.package-sorting__item--open{display:inline}.package-sorting__item--active{display:inline;color:var(--link);border-bottom:2px solid var(--link)}@media(min-width:600px){.package-sorting__group{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;padding:0}.package-sorting__group:after{content:none}.package-sorting__item{display:inline}}.search-bar{position:relative}.search-bar__input{height:50px!important;padding-right:45px!important;border-radius:50px!important}.search-bar__button{position:absolute;top:0;right:5px;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;width:38px;height:50px;margin:0;padding:7px;line-height:36px;border:none;background:none;outline:none}.package-search{position:relative}.package-search__input{max-width:400px;margin:0 20px}@media(min-width:1024px){.package-search__input{margin-right:0}}.package-search__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.package-search__results{display:grid;gap:20px;margin-bottom:20px}@media(min-width:1024px){.package-search__results{grid-template-columns:repeat(2,1fr)}}.package-search__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-search__status--empty{padding-top:140px;background:url(../img/sad.c9a06488.svg) top no-repeat;background-size:100px 100px}.package-search__status--offline{padding-top:140px;background:url(../img/offline.1f95ae24.svg) top no-repeat;background-size:100px 100px}.package-search__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-search__status button{margin-top:2em}.package-search__explain{font-size:16px}.package-search__more{margin:10px 0 30px;text-align:center}.package-search__more-button{display:inline-block;margin:0 auto;padding:0;text-transform:uppercase;background:none;border:none;cursor:pointer}.package-search__more-button:hover{text-decoration:underline}.package-search__algolia{display:block;width:200px;margin:50px auto 0}.link-menu{position:absolute;display:block;left:50%;margin:0;padding:0;text-align:center;list-style-type:none;white-space:nowrap;background:var(--form-bg);border-top:3px solid var(--text);border-radius:5px;z-index:100;-webkit-box-shadow:0 0 1px var(--shadow);box-shadow:0 0 1px var(--shadow)}.link-menu:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--text) transparent;content:""}.link-menu--align-left{left:0;right:auto}.link-menu--align-left:before{left:17px;right:auto}.link-menu--align-right{left:auto;right:0}.link-menu--align-right:before{left:auto;right:17px}.link-menu--valign-top{bottom:0;border-top:none;border-bottom:3px solid var(--text);-webkit-box-shadow:0 0 2px var(--shadow);box-shadow:0 0 2px var(--shadow)}.link-menu--valign-top:before{top:auto;bottom:-7px;border-width:4px 3.5px 0 3.5px;border-color:var(--text) transparent transparent transparent}.link-menu--contao{border-color:var(--contao)}.link-menu--contao:before{border-bottom-color:var(--contao)}.link-menu--contao.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--contao)}.link-menu--primary{border-color:var(--btn-primary)}.link-menu--primary:before{border-bottom-color:var(--btn-primary)}.link-menu--primary.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-primary)}.link-menu--warning{border-color:var(--btn-warning)}.link-menu--warning:before{border-bottom-color:var(--btn-warning)}.link-menu--warning.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-warning)}.link-menu--alert{border-color:var(--btn-alert)}.link-menu--alert:before{border-bottom-color:var(--btn-alert)}.link-menu--alert.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-alert)}.link-menu__item{margin:0;padding:0;display:block}.link-menu__action{display:block;margin:2px;border-radius:5px;padding:8px 16px;color:var(--text);cursor:pointer}.link-menu__action:hover{color:var(--text);background:var(--focus);text-decoration:none}.vjs-tree-brackets{cursor:pointer}.vjs-tree-brackets:hover{color:#1890ff}.vjs-check-controller{position:absolute;left:0}.vjs-check-controller.is-checked .vjs-check-controller-inner{background-color:#1890ff;border-color:#0076e4}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-checkbox:after{-webkit-transform:rotate(45deg) scaleY(1);transform:rotate(45deg) scaleY(1)}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-radio:after{-webkit-transform:translate(-50%,-50%) scale(1);transform:translate(-50%,-50%) scale(1)}.vjs-check-controller .vjs-check-controller-inner{display:inline-block;position:relative;border:1px solid #bfcbd9;border-radius:2px;vertical-align:middle;-webkit-box-sizing:border-box;box-sizing:border-box;width:16px;height:16px;background-color:#fff;z-index:1;cursor:pointer;-webkit-transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46);transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46)}.vjs-check-controller .vjs-check-controller-inner:after{-webkit-box-sizing:content-box;box-sizing:content-box;content:"";border:2px solid #fff;border-left:0;border-top:0;height:8px;left:4px;position:absolute;top:1px;-webkit-transform:rotate(45deg) scaleY(0);transform:rotate(45deg) scaleY(0);width:4px;-webkit-transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s,-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;-webkit-transform-origin:center;transform-origin:center}.vjs-check-controller .vjs-check-controller-inner.is-radio{border-radius:100%}.vjs-check-controller .vjs-check-controller-inner.is-radio:after{border-radius:100%;height:4px;background-color:#fff;left:50%;top:50%}.vjs-check-controller .vjs-check-controller-original{opacity:0;outline:none;position:absolute;z-index:-1;top:0;left:0;right:0;bottom:0;margin:0}.vjs-carets{position:absolute;right:0;cursor:pointer}.vjs-carets svg{-webkit-transition:-webkit-transform .3s;transition:-webkit-transform .3s;transition:transform .3s;transition:transform .3s,-webkit-transform .3s}.vjs-carets:hover{color:#1890ff}.vjs-carets-close{-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.vjs-tree-node{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative;line-height:20px}.vjs-tree-node.has-carets{padding-left:15px}.vjs-tree-node.has-carets.has-selector,.vjs-tree-node.has-selector{padding-left:30px}.vjs-tree-node.is-highlight,.vjs-tree-node:hover{background-color:#e6f7ff}.vjs-tree-node .vjs-indent{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative}.vjs-tree-node .vjs-indent-unit{width:1em}.vjs-tree-node .vjs-indent-unit.has-line{border-left:1px dashed #bfcbd9}.vjs-node-index{position:absolute;right:100%;margin-right:4px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.vjs-colon{white-space:pre}.vjs-comment{color:#bfcbd9}.vjs-value{word-break:break-word}.vjs-value-null,.vjs-value-undefined{color:#d55fde}.vjs-value-boolean,.vjs-value-number{color:#1d8ce0}.vjs-value-string{color:#13ce66}.vjs-tree{font-family:Monaco,Menlo,Consolas,Bitstream Vera Sans Mono,monospace;font-size:14px;text-align:left}.vjs-tree.is-virtual{overflow:auto}.vjs-tree.is-virtual .vjs-tree-node{white-space:nowrap}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{-webkit-transform:translateX(-50%);transform:translateX(-50%)}.package-link{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-column-gap:8px;-moz-column-gap:8px;column-gap:8px;-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:-webkit-box;display:-ms-flexbox;display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:-webkit-box;display:-ms-flexbox;display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}[data-v-627490b6]:root{--text:#535353;--link:#f47c00;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.04773c88.svg);--svg--private:url(../img/private.2455f3fb.svg);--svg--updated:url(../img/updated.b67e9160.svg);--svg--downloads:url(../img/downloads.ef96865d.svg);--svg--favers:url(../img/favers.f48a12a8.svg);--svg--language:url(../img/language.509ee1aa.svg);--svg--color-scheme:url(../img/color_scheme.a51e992d.svg)}html[data-color-scheme=dark][data-v-627490b6]{--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--link-footer:#fff;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.74e01873.svg);--svg--private:url(../img/private--dark.1a50a552.svg);--svg--updated:url(../img/updated--dark.6c7ad8f3.svg);--svg--downloads:url(../img/downloads--dark.6070f904.svg);--svg--favers:url(../img/favers--dark.8589e259.svg);--svg--language:url(../img/language--dark.384e91d7.svg);--svg--color-scheme:url(../img/color_scheme--dark.57222cc0.svg)}html[data-color-scheme=dark] #contao-network[data-v-627490b6]{background:#292c32!important;color:#ddd!important}.package-funding[data-v-627490b6]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.8a3c0e0e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-627490b6]{overflow:hidden}.package-funding span[data-v-627490b6]{margin-right:15px}.package-funding a[data-v-627490b6]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.c73bb011.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-627490b6]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-627490b6]:nth-child(2):before{content:none}:root{--text:#535353;--link:#f47c00;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.04773c88.svg);--svg--private:url(../img/private.2455f3fb.svg);--svg--updated:url(../img/updated.b67e9160.svg);--svg--downloads:url(../img/downloads.ef96865d.svg);--svg--favers:url(../img/favers.f48a12a8.svg);--svg--language:url(../img/language.509ee1aa.svg);--svg--color-scheme:url(../img/color_scheme.a51e992d.svg)}html[data-color-scheme=dark]{--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--link-footer:#fff;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.74e01873.svg);--svg--private:url(../img/private--dark.1a50a552.svg);--svg--updated:url(../img/updated--dark.6c7ad8f3.svg);--svg--downloads:url(../img/downloads--dark.6070f904.svg);--svg--favers:url(../img/favers--dark.8589e259.svg);--svg--language:url(../img/language--dark.384e91d7.svg);--svg--color-scheme:url(../img/color_scheme--dark.57222cc0.svg)}html[data-color-scheme=dark] #contao-network{background:#292c32!important;color:#ddd!important}.package-popup{position:fixed;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:start;-ms-flex-pack:start;justify-content:flex-start;width:100%;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{-ms-flex-preferred-size:auto;flex-basis:auto;-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.package-popup__loader{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0;-ms-flex-negative:1;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__headline--complete{background-color:var(--btn-primary)}.package-popup__headline--error{background-color:var(--btn-alert)}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__headline--complete .package-popup__button:hover{background-color:var(--btn-primary-active)}.package-popup__headline--error .package-popup__button:hover{background-color:var(--btn-alert)}.package-popup__summary{-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:-webkit-box;display:-ms-flexbox;display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;-o-object-fit:contain;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;-webkit-box-flex:revert;-ms-flex-positive:revert;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:-webkit-gradient(linear,right top,left top,color-stop(0,transparent),color-stop(50%,var(--popup-bg)));background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:-webkit-gradient(linear,left top,right top,color-stop(0,transparent),color-stop(50%,var(--popup-bg)));background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{-ms-flex-negative:0;flex-shrink:0;-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-column-gap:4px;-moz-column-gap:4px;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer;outline:none}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content)}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;-webkit-transform:translateY(-50%);transform:translateY(-50%)}}body.nav-active{overflow:hidden!important}#app{-webkit-transition:-webkit-transform .4s cubic-bezier(.55,0,.1,1);transition:-webkit-transform .4s cubic-bezier(.55,0,.1,1);transition:transform .4s cubic-bezier(.55,0,.1,1);transition:transform .4s cubic-bezier(.55,0,.1,1),-webkit-transform .4s cubic-bezier(.55,0,.1,1)}.nav-active #app{overflow-y:visible;-webkit-transform:translateX(-280px);transform:translateX(-280px)}@media(min-width:1024px){.nav-active #app{-webkit-transform:none;transform:none}}.navigation{float:right}.navigation__toggle{display:block;float:right;position:relative;margin:5px 15px;padding:0;width:30px;height:30px;cursor:pointer;z-index:20}.navigation__toggle span,.navigation__toggle span:after,.navigation__toggle span:before{content:"";display:block;width:100%;height:4px;background:var(--text);border-radius:4px;position:absolute}.navigation__toggle span{-webkit-transition-duration:75ms;transition-duration:75ms;-webkit-transition-timing-function:cubic-bezier(.215,.61,.355,1);transition-timing-function:cubic-bezier(.215,.61,.355,1);top:50%;margin-top:-2px}.navigation__toggle span:before{top:-10px;-webkit-transition:top 75ms ease .12s,opacity 75ms ease;transition:top 75ms ease .12s,opacity 75ms ease}.navigation__toggle span:after{bottom:-10px;-webkit-transition:bottom 75ms ease .12s,-webkit-transform 75ms cubic-bezier(.55,.055,.675,.19);transition:bottom 75ms ease .12s,-webkit-transform 75ms cubic-bezier(.55,.055,.675,.19);transition:bottom 75ms ease .12s,transform 75ms cubic-bezier(.55,.055,.675,.19);transition:bottom 75ms ease .12s,transform 75ms cubic-bezier(.55,.055,.675,.19),-webkit-transform 75ms cubic-bezier(.55,.055,.675,.19)}.nav-active .navigation__toggle span{-webkit-transform:rotate(45deg);transform:rotate(45deg);-webkit-transition-delay:.12s;transition-delay:.12s;-webkit-transition-timing-function:cubic-bezier(.215,.61,.355,1);transition-timing-function:cubic-bezier(.215,.61,.355,1)}.nav-active .navigation__toggle span:before{top:0;opacity:0;-webkit-transition:top 75ms ease,opacity 75ms ease .12s;transition:top 75ms ease,opacity 75ms ease .12s}.nav-active .navigation__toggle span:after{-webkit-transition:bottom 75ms ease,-webkit-transform 75ms cubic-bezier(.215,.61,.355,1) .12s;transition:bottom 75ms ease,-webkit-transform 75ms cubic-bezier(.215,.61,.355,1) .12s;transition:bottom 75ms ease,transform 75ms cubic-bezier(.215,.61,.355,1) .12s;transition:bottom 75ms ease,transform 75ms cubic-bezier(.215,.61,.355,1) .12s,-webkit-transform 75ms cubic-bezier(.215,.61,.355,1) .12s;bottom:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.navigation__group,.navigation__item{list-style-type:none;margin:0;padding:0}.navigation__group--main{position:fixed;top:0;bottom:0;right:-280px;width:280px;padding:20px;overflow-y:auto;overflow-scrolling:touch;background:var(--header-main-bg);border-left:1px solid var(--header-bdr);z-index:10}.navigation__item a{display:block;padding:12px 10px;font-size:16px;color:var(--text);white-space:pre}.navigation__item a:hover{text-decoration:none}.navigation__item a[href]:hover{color:var(--link)}.navigation__item--main>a{text-transform:uppercase}.navigation__item--sub>a{margin-left:15px}.navigation__item--icon svg{display:none}.navigation__item-badge{position:relative;top:-2px;margin-left:8px;padding:2px 5px;font-size:10px;color:var(--clr-btn);font-weight:600;background:var(--contao);border-radius:40%}@media(min-width:1024px){.navigation__toggle{display:none}.navigation__group--main{position:inherit;top:auto;bottom:auto;right:auto;width:auto;padding:0;overflow:visible;background:none;border:none;-webkit-box-shadow:none;box-shadow:none;-webkit-transform:none;transform:none;-webkit-transition:none;transition:none}.navigation__group--sub{display:none;position:absolute;left:50%;min-width:180px;margin-top:-3px;text-align:center;background:var(--form-bg);border-top:3px solid var(--link);border-radius:5px;-webkit-transform:translateX(-50%);transform:translateX(-50%);z-index:100;-webkit-box-shadow:0 0 2px var(--shadow);box-shadow:0 0 2px var(--shadow)}.navigation__group--sub:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--link) transparent;content:""}.navigation__group--right{left:auto;right:7px;-webkit-transform:translateX(0);transform:translateX(0)}.navigation__group--right:before{left:auto;right:18px}.navigation__item{position:relative;display:inline-block;padding:0 8px}.navigation__item.router-link-active>a,.navigation__item:hover>a{color:var(--link)!important;border-bottom:3px solid var(--link)}.navigation__item:hover>.navigation__group--sub{display:block}.navigation__item--sub{display:block;margin:calc(var(--border-radius)/2);border-radius:var(--border-radius)}.navigation__item--sub a{margin:0;border:none!important}.navigation__item--sub.router-link-active,.navigation__item--sub:hover{background:var(--focus)}.navigation__item--sub.router-link-active a,.navigation__item--sub:hover a{color:var(--text)!important}.navigation__item--icon>a{padding-top:7px}.navigation__item--icon>a svg{display:inline;position:relative;top:4px;width:22px;height:22px;fill:var(--text)}.navigation__item--icon>a:hover svg{fill:var(--link)}.navigation__item--icon>a span{display:none}.navigation:hover li>a{border:none}.navigation:hover li:hover>a{border-bottom:3px solid var(--link)}.navigation:hover li:hover>a svg{fill:var(--link)}}.logout-warning{position:fixed;display:block;top:50%;left:50%;width:500px;max-width:90%;text-align:center;background:var(--popup-bg);z-index:10;opacity:1;-webkit-transform:translate(-50%,-50%);transform:translate(-50%,-50%);border-radius:var(--border-radius);overflow:hidden}.logout-warning__headline{position:relative;background:var(--contao);color:#fff;font-weight:300;line-height:40px}.logout-warning__headline--complete{background-color:var(--btn-primary)}.logout-warning__headline--error{background-color:var(--btn-alert)}.logout-warning__text{margin:2em 40px}.logout-warning__countdown{margin:-20px 0 20px;font:600 4em/1.6 SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:var(--btn-warning)}.logout-warning .widget-button{width:auto;height:35px;margin:0 5px 2em 5px;padding:0 30px;line-height:35px}.fragment-footer{width:280px;margin:10px auto 0;padding:15px 0 25px;font-size:12px;text-align:center;border-top:1px solid var(--footer-bdr)}.fragment-footer--main{width:auto;margin-top:52px!important;padding:20px 0}.fragment-footer--boxed{border-color:var(--footer-fragment-bdr)}.fragment-footer__product{font-weight:300}.fragment-footer__links{margin:5px 0 0;padding:0;list-style-type:none}.fragment-footer__links li{display:inline-block}.fragment-footer__links li:not(:first-child):before{content:"|";padding:0 10px 0 8px}.fragment-footer__links a{display:inline!important;color:var(--link-footer)}.fragment-footer__settings{margin-top:10px;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-flow:column;flex-flow:column;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;gap:10px}.fragment-footer__language{position:relative;display:inline-block}.fragment-footer__language button{width:auto;height:auto;padding:0 0 0 25px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--language) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.fragment-footer__language button:hover{color:var(--black)}.fragment-footer__language ul{display:grid;overflow:hidden;grid-template-columns:1fr 1fr;grid-auto-flow:row;gap:2px;padding:2px;bottom:25px;white-space:nowrap;-webkit-transform:translateX(-50%);transform:translateX(-50%)}.fragment-footer__language li a{display:block;padding:6px;border-radius:5px;color:var(--text);cursor:pointer}.fragment-footer__language li a.active{font-weight:600}.fragment-footer__language li a.active,.fragment-footer__language li a:hover{color:var(--text);background:var(--focus);text-decoration:none}@media(min-width:960px){.fragment-footer{display:grid;grid-auto-flow:column;grid-auto-columns:minmax(0,1fr);gap:16px;-ms-flex-line-pack:center;align-content:center}.fragment-footer--boxed .fragment-footer__product,.fragment-footer--main .fragment-footer__product{margin-right:auto}.fragment-footer--boxed .fragment-footer__links,.fragment-footer--main .fragment-footer__links{-webkit-box-ordinal-group:16;-ms-flex-order:15;order:15;margin:0 0 0 auto}.fragment-footer--boxed .fragment-footer__settings,.fragment-footer--main .fragment-footer__settings{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-flow:row;flex-flow:row;margin-top:0}.fragment-footer--boxed{width:840px}}.layout-main{overflow:hidden;min-height:100vh}.layout-main__header{height:56px;padding:8px;background:var(--header-main-bg)}.layout-main__header--margin{margin-bottom:30px}.layout-main__badge-title{background:var(--border);color:var(--text);padding:2px 5px;position:relative;top:-5px;border-radius:8px;font-size:.75rem;font-weight:600;line-height:1;display:-webkit-box;-webkit-line-clamp:1;-webkit-box-orient:vertical;word-break:break-word;overflow:hidden;text-overflow:ellipsis}.layout-main__subheader{margin:0 0 45px;padding:20px 0;background:var(--header-bg);border-bottom:1px solid var(--header-bdr)}.layout-main__subheader-inside{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column}.layout-main__news{width:320px;height:50px;margin-bottom:20px}.layout-main .search-bar{width:100%;margin:0}.layout-main__logo{display:inline;color:var(--text);text-decoration:none;font-weight:100;font-size:27px;line-height:40px}.layout-main__logo img{float:left;margin:0 10px 0 12px}@media(min-width:1024px){.layout-main__logo img{margin-left:0}}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{position:relative;margin:0 20px}.layout-main__has-badge-title{-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between}.layout-main__has-badge-title,.layout-main__has-badge-title .layout-main__logo,.layout-main__has-badge-title .layout-main__title{display:-webkit-box;display:-ms-flexbox;display:flex}.layout-main__has-badge-title .layout-main__title{-ms-flex-wrap:wrap;flex-wrap:wrap;-webkit-box-align:center;-ms-flex-align:center;align-items:center;line-height:1;-webkit-column-gap:10px;-moz-column-gap:10px;column-gap:10px;row-gap:5px}@media(max-width:600px){.layout-main__badge-title{max-width:220px}}@media(min-width:700px){.layout-main__subheader-inside{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row}.layout-main__news{margin:0 20px 0 0}}@media(min-width:1024px){.layout-main__has-badge-title .navigation__group--main{display:-webkit-box;display:-ms-flexbox;display:flex}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:960px;margin:0 auto}}@media(min-width:1200px){.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:1180px}}.confirm-button{position:relative}.confirm-button__icon{display:none;position:absolute;opacity:0;z-index:100}.confirm-button__icon--confirm{display:block;-webkit-animation:confirm_button .5s ease-out 0s;animation:confirm_button .5s ease-out 0s}.confirm-button__icon svg{fill:var(--btn-primary);width:100%;height:100%}@-webkit-keyframes confirm_button{0%{opacity:1;height:10px;width:10px;left:calc(50% - 5px);top:calc(50% - 5px)}to{opacity:0;height:150px;width:150px;left:calc(50% - 75px);top:calc(50% - 75px)}}@keyframes confirm_button{0%{opacity:1;height:10px;width:10px;left:calc(50% - 5px);top:calc(50% - 5px)}to{opacity:0;height:150px;width:150px;left:calc(50% - 75px);top:calc(50% - 75px)}}.package-tools{position:relative;clear:both;text-align:center}@media(min-width:800px){.package-tools{margin-bottom:40px}}.package-tools__button.widget-button{margin-bottom:10px}@media(min-width:800px){.package-tools{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center}.package-tools__button.widget-button{width:auto;margin:0 15px;padding:0 15px}}.package-actions{position:fixed;left:0;right:0;bottom:0;max-height:0;background:#000;background:rgba(0,0,0,.8);color:#fff;-webkit-transition:max-height .4s ease;transition:max-height .4s ease;z-index:100}.package-actions--active{max-height:200px}.package-actions__inner{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;-webkit-box-align:center;-ms-flex-align:center;align-items:center;margin:0;padding:12px;text-align:right}@media(min-width:1024px){.package-actions__inner{max-width:976px;margin:0 auto;padding-left:0;padding-right:0}}@media(min-width:1200px){.package-actions__inner{max-width:1196px}}.package-actions__text{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;display:initial;margin:0 8px;font-weight:600}.package-actions__button{display:block;padding:0 15px!important;margin:8px}.package-actions__button--dryRun{width:auto!important;-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}@media(min-width:600px){.package-actions__button{width:auto!important}.package-actions__button--dryRun{-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0}}.package-actions__button-group{display:block;width:100%;margin:8px}.package-actions__button-group>.button-group__primary{padding:0 15px!important}@media(min-width:600px){.package-actions__button-group{width:auto!important}}.package{position:relative;margin-bottom:20px;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.package.is--hint{border-color:var(--btn-alert)}.package--contao:not(:last-child){margin-bottom:5em}.package__hint{position:relative;background:var(--hint-bg);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.8;border-radius:14px 14px 0 0;z-index:1}.package__hint p a{display:inline-block;padding-right:10px}.package__hint p a:first-child{margin-left:10px}.package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.package__hint-close{float:right;padding-left:18px;color:var(--hint-link);background:url(../img/close.88e95867.svg) 0 no-repeat;background-size:14px 14px}.package__inside{position:relative;padding:16px}.package__inside:after{display:table;clear:both;content:""}.package__badge{display:inline-block;margin-bottom:.5em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);border-radius:var(--border-radius);cursor:help}.package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.package__icon>figure{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;height:100%}.package__icon img,.package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;-o-object-fit:contain;object-fit:contain}.package__details{min-height:96px}.package__about{margin-bottom:20px}.package__headline{position:relative;margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__title{display:block;margin-right:10px}.package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__additional{margin-top:-5px}.package .package__release{text-align:right;margin-bottom:5px}.package__version--additional{margin-bottom:5px}.package__version--additional strong{margin-right:10px}.package__version--release{display:none}.package__version--release time{display:block}.package__version--missing{padding:4px 8px;background:var(--btn-alert);border-radius:var(--border-radius);color:#fff;font-weight:700}.package__version-update{display:inline-block;margin:0 0 2px;padding:1px 8px;color:#fff;border-radius:var(--border-radius)}.package__version-update--available{background:var(--btn-primary)}.package__version-update--error{background:var(--btn-alert)}.package__version-update--none{background:var(--border)}.package__version-latest{float:right;position:relative;right:-7px;width:24px;height:20px;background:var(--btn-primary) url(../img/button-update.c63bd5a5.svg) center center/20px 20px no-repeat}.package__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-flow:column;flex-flow:column;gap:5px}.package__actions .button-group button{margin-bottom:0!important}@media(min-width:600px){.package__description,.package__title{margin-right:0}.package__hint{padding-left:52px;background:rgba(var(--hint-rgb),.9) url(../img/hint.ba2ac97e.svg) 12px 5px no-repeat;background-size:28px 28px}.package__inside{-webkit-box-align:stretch;-ms-flex-align:stretch;align-items:stretch;padding:0}.package__headline--badge,.package__inside{display:-webkit-box;display:-ms-flexbox;display:flex}.package__headline--badge{gap:6px;-webkit-box-align:start;-ms-flex-align:start;align-items:flex-start}.package__headline{margin:0 0 8px}.package__badge{-webkit-box-ordinal-group:2;-ms-flex-order:1;order:1;margin:0 0 0 2px}.package__icon{width:130px;height:auto;min-height:130px;margin:0;border-radius:12px 0 0 12px;position:revert;right:revert}.package__icon img,.package__icon svg{width:110px;height:110px}.is--hint .package__icon{border-top-left-radius:0}.package--contao{overflow:hidden}.package--contao .package__icon{border-radius:0}.package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);-webkit-box-flex:1;-ms-flex:1;flex:1}.package.is--hint .package__icon{border-top-left-radius:0}}@media(min-width:680px){.package .package__release{display:block;float:left;width:33%}.package__actions{float:right;width:64%;-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-flow:row;flex-flow:row;gap:4%;text-align:right}.package__actions>*{-webkit-box-flex:1;-ms-flex:1;flex:1}}@media(min-width:1024px){.package__version--additional{display:none}.package__version--release{display:block;margin-top:15px;text-align:center}.package__version-update{display:block;margin:2px 0 0}.package__about{float:left;width:396px;margin-bottom:0}.package .package__release{width:180px;margin-left:20px;margin-bottom:0}.package__actions{-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-flow:column;flex-flow:column;gap:10px;width:180px;margin-left:20px}.package__details{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-item-align:center;align-self:center;-webkit-box-align:start;-ms-flex-align:start;align-items:flex-start}}@media(min-width:1200px){.package__about{width:616px}}.progress-bar{position:relative;width:100%;height:30px;background:var(--clr-btn);border:2px solid var(--btn-warning);color:#000;font-weight:600;text-align:center;line-height:26px}.progress-bar__bar{position:absolute;overflow:hidden;left:0;right:0;top:0;bottom:0;background:var(--btn-warning)}.progress-bar__bar span{display:block;color:var(--clr-btn);text-align:center}.feature-package{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;padding:6px 16px;border-top:1px solid var(--border--light)}.feature-package__name{font-weight:600;white-space:nowrap}.feature-package__name:after{content:": "}.feature-package__text{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;display:-webkit-box;overflow:hidden;-webkit-line-clamp:1;-webkit-box-orient:vertical;margin-right:.5em;padding:4px 0;line-height:20px}.feature-package__text--hint{display:inline;-webkit-line-clamp:none}.feature-package__badge{margin-left:5px;padding:2px 8px;background:var(--btn-alert);border-radius:var(--border-radius);font-size:12px;font-weight:600;line-height:19px;color:#fff;cursor:help}.feature-package__hint{line-height:1.2;padding:2px 5px;background:var(--hint-bg);font-size:12px}.feature-package__actions{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;margin:0 -4px 0 0}.feature-package__actions>*{margin:0 4px}.feature-package__restore{padding-left:18px;font-size:12px;color:var(--hint-link);background:url(../img/close.88e95867.svg) 0 no-repeat;background-size:14px 14px;border:none;outline:none;cursor:pointer}.feature-package__restore:hover{text-decoration:underline}@media(min-width:800px){.feature-package{-ms-flex-wrap:nowrap;flex-wrap:nowrap}}@media(min-width:1024px){.feature-package__hint{padding:8px 10px 8px 36px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 5px no-repeat;background-size:20px 20px}.feature-package__actions{margin:0 -4px 0 0}}[data-v-382a7b7e]:root{--text:#535353;--link:#f47c00;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.04773c88.svg);--svg--private:url(../img/private.2455f3fb.svg);--svg--updated:url(../img/updated.b67e9160.svg);--svg--downloads:url(../img/downloads.ef96865d.svg);--svg--favers:url(../img/favers.f48a12a8.svg);--svg--language:url(../img/language.509ee1aa.svg);--svg--color-scheme:url(../img/color_scheme.a51e992d.svg)}html[data-color-scheme=dark][data-v-382a7b7e]{--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--link-footer:#fff;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.74e01873.svg);--svg--private:url(../img/private--dark.1a50a552.svg);--svg--updated:url(../img/updated--dark.6c7ad8f3.svg);--svg--downloads:url(../img/downloads--dark.6070f904.svg);--svg--favers:url(../img/favers--dark.8589e259.svg);--svg--language:url(../img/language--dark.384e91d7.svg);--svg--color-scheme:url(../img/color_scheme--dark.57222cc0.svg)}html[data-color-scheme=dark] #contao-network[data-v-382a7b7e]{background:#292c32!important;color:#ddd!important}.package-constraint input[type=text][data-v-382a7b7e]{margin-right:2px;background:#fff;border:2px solid var(--btn-warning);color:var(--black);font-weight:600;text-align:center;border-top-right-radius:0;border-bottom-right-radius:0}.package-constraint input[type=text][data-v-382a7b7e]::-webkit-input-placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-382a7b7e]::-moz-placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-382a7b7e]:-ms-input-placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-382a7b7e]::-ms-input-placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-382a7b7e]::placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-382a7b7e]:disabled{color:var(--clr-btn);opacity:1;background:var(--btn-warning);-webkit-text-fill-color:var(--clr-btn)}.package-constraint input[type=text].disabled[data-v-382a7b7e]{background:var(--border);border-color:var(--border)}.package-constraint input[type=text].error[data-v-382a7b7e]{-webkit-animation:input-error .15s linear 3;animation:input-error .15s linear 3}.package-constraint>input[type=text][data-v-382a7b7e],.package-constraint>input[type=text][data-v-382a7b7e]:disabled{float:left;width:calc(100% - 32px)}.package-constraint button[data-v-382a7b7e]{position:relative;width:30px;background:var(--btn-warning);line-height:20px;text-indent:-999em;border-top-left-radius:0;border-bottom-left-radius:0}.package-constraint button[data-v-382a7b7e]:hover{background:var(--btn-warning-active);border-color:var(--btn-warning-active)}.package-constraint button[data-v-382a7b7e]:before{position:absolute;left:50%;top:50%;margin:-10px 0 0 -10px}.package-constraint button.rotate[data-v-382a7b7e]:before{-webkit-animation:release-validating-382a7b7e 2s linear infinite;animation:release-validating-382a7b7e 2s linear infinite}@-webkit-keyframes release-validating-382a7b7e{to{-webkit-transform:rotate(1turn);transform:rotate(1turn)}}@keyframes release-validating-382a7b7e{to{-webkit-transform:rotate(1turn);transform:rotate(1turn)}}@media(min-width:1024px){.package-constraint button[data-v-382a7b7e],.package-constraint input[type=text][data-v-382a7b7e]{height:30px}}.button-group{display:-webkit-box;display:-ms-flexbox;display:flex;gap:1px;position:relative}.button-group__primary.widget-button{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;border-top-right-radius:0;border-bottom-right-radius:0}.button-group__more.widget-button{-ms-flex-negative:0;flex-shrink:0;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-group__more.widget-button svg{width:24px;height:24px}.button-group__group{position:absolute;top:39px;width:100%;z-index:100}.button-group__group:focus{outline:none}.button-group__group .widget-button{margin-top:1px}.button-group__group .link-menu{margin-top:3px}.button-group__group--top{top:auto;bottom:39px}.button-group__group--top .link-menu{margin-top:0;margin-bottom:3px}.composer-package__stats{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.composer-package__stats--license{padding-left:0}.composer-package__stats--downloads{background-image:var(--svg--downloads)}.composer-package__stats--favers{background-image:var(--svg--favers)}.composer-package__stats--funding{width:16px;background-image:url(../img/funding.8a3c0e0e.svg);background-size:16px 16px;background-repeat:no-repeat;text-decoration:none!important}.package-uploads__overlay{top:0;bottom:0;right:0;left:0;position:fixed;z-index:9999;opacity:.6;text-align:center;background:#000}.package-uploads__overlay div{margin:-.5em 0 0;position:absolute;top:50%;left:0;right:0;-webkit-transform:translateY(-50%);transform:translateY(-50%);font-size:40px;color:#fff;padding:0}.cloud-status{margin-left:8px;position:relative}.cloud-status__button{margin-left:0;margin-right:0;padding-left:8px;cursor:help!important}.cloud-status__popup{position:absolute;text-align:center;left:0;bottom:55px;margin:0;padding:0 0 15px;outline:none;background:var(--form-bg);color:var(--text);border-bottom:3px solid var(--contao);border-radius:5px;-webkit-box-shadow:0 0 2px var(--shadow);box-shadow:0 0 2px var(--shadow);z-index:100}.cloud-status__popup:after{position:absolute;left:38px;bottom:-6px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:4px 3.5px 0 3.5px;border-color:var(--contao) transparent transparent transparent;content:""}.cloud-status__popup--error{color:var(--clr-btn);background-color:var(--btn-alert);border-color:var(--btn-alert)}.cloud-status__popup--error:after{left:27px;border-color:var(--btn-alert) transparent transparent transparent}.cloud-status__headline{padding:15px 20px 0;font-size:16px;white-space:pre}.cloud-status__version{margin:0 0 8px;font-size:12px}.cloud-status__link{display:inline-block;margin:15px 10px 0}.cloud-status__error{padding:8px 20px 8px;-webkit-hyphens:auto;-ms-hyphens:auto;hyphens:auto}.cloud-status table{width:100%;margin-top:12px;text-align:left;border-spacing:0;border-collapse:collapse}.cloud-status th{padding:3px 5px 3px 20px}.cloud-status td{padding:3px 20px 3px 0}.cloud-status tr:nth-child(odd){background:var(--table-odd-bg)}.package-list{position:relative}.package-list__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-list__status .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-list__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.animate-blur-in,.animate-blur-out,.layout-boxed{display:table;width:100%;height:100%}.layout-boxed__cell{display:table-cell;overflow:hidden;vertical-align:middle;padding:10px}.layout-boxed__container{position:relative;max-width:380px;margin:0 auto;background:var(--popup-bg);border-radius:8px}@media(min-width:960px){.layout-boxed__container{margin-top:20px;margin-bottom:20px}.layout-boxed__container--wide{max-width:940px}}.view-oauth__header{max-width:280px;margin:0 auto 60px;padding-top:40px;text-align:center}.view-oauth__product{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-oauth__form{position:relative;max-width:280px;margin:0 auto 80px;text-align:center}.view-oauth__form input,.view-oauth__form select{margin:5px 0 10px}.view-oauth__headline{margin-bottom:0}.view-oauth__description{margin-top:.5em;margin-bottom:.5em}.view-oauth__client{margin:1em 0;font-size:32px}.view-oauth__warning{color:var(--btn-alert);margin-top:.5em;margin-bottom:2em}.view-oauth__button{margin-top:20px}.view-oauth__button .sk-circle{color:#fff;text-align:center}.message-overlay{position:relative}.message-overlay__blur{opacity:.75;-webkit-filter:blur(2px);filter:blur(2px);-webkit-transition:opacity .5s,-webkit-filter .5s;transition:opacity .5s,-webkit-filter .5s;transition:opacity .5s,filter .5s;transition:opacity .5s,filter .5s,-webkit-filter .5s}.message-overlay__overlay{position:absolute;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;left:0;right:0;top:0;bottom:0}.message-overlay__message{padding:10px;font-size:2em;font-weight:400;text-align:center}.maintenance{margin-bottom:14px;background:var(--tiles-bg);border-radius:var(--border-radius)}.maintenance__inside{padding:10px 20px 20px}.maintenance__inside:after{display:table;clear:both;content:""}@media(min-width:1024px){.maintenance__inside{padding:25px 20px}}.maintenance__image{display:none}.maintenance__image img{width:100%;height:100%;border-radius:var(--border-radius);overflow:hidden}@media(min-width:1024px){.maintenance__image{display:block;float:left;width:90px;height:90px;margin-right:20px}}.maintenance__about{margin-bottom:20px}@media(min-width:1024px){.maintenance__about{float:left;width:510px;margin-bottom:0}}.maintenance__about h1{position:relative;margin-bottom:5px}.maintenance__about p{margin:0 0 1em;display:inline}.maintenance__error,.maintenance__warning{position:relative;top:-2px;margin-left:.5em;padding:2px 8px;font-size:14px;line-height:1em;font-weight:300;background:var(--btn-warning);color:var(--clr-btn);border-radius:var(--border-radius)}.maintenance__error{background:var(--btn-alert)}@media(min-width:600px){.maintenance__actions{margin:0 -10px}}@media(min-width:1024px){.maintenance__actions{float:right;width:280px;margin:0 0 0 40px}}.maintenance__actions>.button-group,.maintenance__actions>button{width:100%;margin-bottom:10px}@media(min-width:600px){.maintenance__actions>.button-group,.maintenance__actions>button{float:right;width:calc(50% - 20px);margin:0 10px}}@media(min-width:1024px){.maintenance__actions>.button-group,.maintenance__actions>button{width:100%;margin:0 0 10px}}.maintenance__loader{width:50px;margin:0 auto}.maintenance__loader .sk-circle{width:50px;height:50px}.log-viewer__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.log-viewer__status--empty{padding-top:140px;background:url(../img/warning.a0297242.svg) top no-repeat;background-size:100px 100px}.log-viewer__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.log-viewer__status button{margin-top:2em}.log-viewer__loading{width:30px;margin:40px auto}.log-viewer__loading .sk-circle{width:30px;height:30px}.log-viewer__filters{-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;-ms-flex-wrap:wrap;flex-wrap:wrap}.log-viewer__filters,.log-viewer__filters>div{display:-webkit-box;display:-ms-flexbox;display:flex;gap:20px}.log-viewer__filters>div{-webkit-box-align:end;-ms-flex-align:end;align-items:flex-end}.log-viewer__filters a{-ms-flex-negative:0;flex-shrink:0}.log-viewer__file{-ms-flex-negative:1;flex-shrink:1;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:end;-ms-flex-align:end;align-items:flex-end}.log-viewer__file select{border-right:none;border-top-right-radius:0;border-bottom-right-radius:0}.log-viewer__file button{border-top-left-radius:0;border-bottom-left-radius:0}.log-viewer__list{margin-top:2em;padding-bottom:1px;background:var(--form-bg);border-radius:var(--border-radius)}@media(min-width:600px){.log-viewer__list{overflow-y:scroll;max-height:calc(100vh - 300px)}}.log-viewer__line{position:relative;padding:10px 0;border-bottom:1px solid var(--border--light)}@media(min-width:600px){.log-viewer__line{display:-webkit-box;display:-ms-flexbox;display:flex}}.log-viewer__line:hover{background:var(--focus)}.log-viewer__line:last-child{border-bottom:none}.log-viewer__line--header{display:none}@media(min-width:600px){.log-viewer__line--header{display:-webkit-box;display:-ms-flexbox;display:flex;position:sticky;top:0;z-index:1;font-weight:600;background:var(--log-header-bg)!important;color:#fff;border-top-left-radius:2px;border-top-right-radius:2px;border-bottom-color:var(--border)}}.log-viewer__line--alert:before,.log-viewer__line--critical:before,.log-viewer__line--emergency:before,.log-viewer__line--error:before,.log-viewer__line--warning:before{content:"";position:absolute;left:0;top:-1px;bottom:-1px;width:4px;background:var(--btn-alert)}.log-viewer__line--warning:before{background:var(--btn-warning)}.log-viewer__line--raw{padding:5px 10px;background:#24292e;border-bottom:none;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;font-size:.8em;line-height:1.5}.log-viewer__line--raw:hover{background:#2f363d}.log-viewer__more{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;padding:20px}.log-viewer__content,.log-viewer__meta{padding:10px 20px}.log-viewer__content--header,.log-viewer__meta--header{padding:0 20px!important}.log-viewer__meta{padding-bottom:0;-ms-flex-negative:0;flex-shrink:0;font-style:italic}.log-viewer__meta--header{font-style:normal}@media(min-width:600px){.log-viewer__meta{width:220px;padding-bottom:10px}}.log-viewer__content{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.log-viewer__datetime{display:block}@media(min-width:600px){.log-viewer__datetime{margin-bottom:1em}}.log-viewer__badge{display:inline-block;margin-right:10px;padding:1px 4px;background:var(--border);border-radius:var(--border-radius);font-size:.9em;font-weight:400;text-transform:lowercase}.log-viewer__badge--desktop{display:none}@media(min-width:600px){.log-viewer__badge--desktop{display:inline-block}.log-viewer__badge--mobile{display:none}}.log-viewer__badge--channel{padding-top:0;padding-bottom:0;border:1px solid var(--border);background:var(--white)}.log-viewer__badge--level-warning{background:var(--btn-warning);color:#fff}.log-viewer__badge--level-alert,.log-viewer__badge--level-critical,.log-viewer__badge--level-emergency,.log-viewer__badge--level-error{background:var(--btn-alert);color:#fff}.log-viewer__message span:nth-child(2n){font-weight:600;color:var(--black)}.log-viewer__details{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;margin-top:1em}.log-viewer__toggle{margin-right:10px;padding:0;border:none;background:none;color:var(--link);text-decoration:none;cursor:pointer}.log-viewer__toggle:hover{text-decoration:underline}.log-viewer__json{margin:10px 0 0}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{background:var(--btn-primary) url(../img/button-update.c63bd5a5.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{background:var(--contao) url(../img/button-incompatible.6d0ea849.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__funding+.package-popup__update{margin-top:-10px}.view-error{position:fixed;left:0;right:0;top:0;bottom:0;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;padding:10px;color:#e8e8e8;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-size:13px;line-height:1.2;background-color:rgba(0,0,0,.851);background-position:0 0;background-repeat:repeat;z-index:9998}.view-error,.view-error__content{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center}.view-error__content{-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;max-width:800px;max-height:100vh;line-height:1.5;text-align:center}.view-error__icon{display:block;height:100px;margin:2em 0;fill:#fff}.view-error__status{margin-bottom:1em;padding:2px 4px;background-color:#e36049;border-radius:var(--border-radius)}.view-error__headline{margin:0;font-size:1em;line-height:1.5}.view-error__status a{color:#e8e8e8;text-decoration:underline}.view-error__details{display:block;margin-top:2em;white-space:pre-line}.view-error__debug{-ms-flex-item-align:start;align-self:flex-start;max-height:60vh;overflow-y:auto;margin-top:2em;text-align:left;white-space:pre-line}.view-error__actions{margin:4em 0;text-align:center}.view-error__link{margin:10px;padding:10px 20px;border:1px solid #fff;border-radius:4px;color:#fff}.widget-text--password input{padding-right:40px!important}.widget__password-toggle{position:absolute;right:8px;bottom:2px;padding:0;margin:0;background:none;border:none;cursor:pointer}.widget__password-toggle--hidden svg{fill:var(--btn-primary)}.widget__password-toggle--visible svg{fill:var(--btn)}.view-account__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-account__product{margin-top:15px;margin-bottom:40px;font-weight:600}.view-account__product strong{display:block;margin-bottom:10px;font-size:54px;font-weight:100;line-height:1}.view-account__headline{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.view-account__description{margin-bottom:1em;text-align:justify}.view-account__form{position:relative;max-width:280px;margin:0 auto}.view-account__form .widget-text{margin-top:10px}.view-account__form .widget-text label{display:block;padding-bottom:5px}.view-account__form .widget-button{margin-top:1.5em}.view-account__contribute{max-width:280px;margin:60px auto 0;font-size:12px;text-align:center}.view-account__contribute br{display:none}@media(min-width:960px){.view-account{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-flow:row wrap;flex-flow:row wrap;-webkit-box-align:center;-ms-flex-align:center;align-items:center;padding-top:50px}.view-account__form,.view-account__header{padding:50px;width:50%;max-width:none}.view-account__form .widget-text label{float:left;width:120px;padding-top:10px;font-weight:400}.view-account__form input[type=password],.view-account__form input[type=text],.view-account__form select{width:250px!important}.view-account__form .widget-button{width:250px;margin-left:120px}.view-account__contribute{max-width:840px}.view-account__contribute br{display:block}}.view-login__header{max-width:280px;margin:0 auto 60px;padding-top:40px;text-align:center}.view-login__product{margin-top:15px;font-size:38px;font-weight:100;line-height:1}.view-login__form{position:relative;max-width:280px;margin:0 auto 80px}.view-login__form input{padding-right:30px;margin:5px 0 10px}.view-login__locked{max-width:290px;margin:-20px auto 60px;padding:20px;background:var(--btn-alert);color:#fff;text-align:center}.view-login__locked strong{white-space:pre}.view-login__headline{margin-bottom:0}.view-login__description{margin-top:.5em;margin-bottom:30px}.view-login label{position:absolute;text-indent:-999em;pointer-events:none}.view-login label[for=ctrl_username]{top:0;bottom:0;margin:auto;right:13px;width:16px;height:16px;background:url(../img/person.00d78897.svg) 0 0 no-repeat;background-size:16px 16px;z-index:10}.view-login label[for=ctrl_password]{top:0;bottom:0;margin:auto;right:12px;width:16px;height:16px;background:url(../img/lock.3c42a55f.svg) 0 0 no-repeat;background-size:14px 14px;z-index:10}.view-login__password input,.view-login__user input{margin:0}.view-login__user input{border-radius:var(--border-radius) var(--border-radius) 0 0!important}.view-login__password{margin-top:-1px}.view-login__password input{border-radius:0 0 var(--border-radius) var(--border-radius)!important}.view-login .widget-text--password button{opacity:0}.view-login__link{display:block;margin-top:1em;font-size:12px;text-align:right}.view-login__button{margin:12px 0 6px}.view-login__button .sk-circle{color:#fff;text-align:center}.view-login .fragment-footer{display:block}.button-menu{position:relative}.button-menu__primary.widget-button{float:left;width:calc(100% - 39px);border-top-right-radius:0;border-bottom-right-radius:0}.button-menu__more.widget-button{float:right;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-menu__more.widget-button svg{width:24px;height:24px}.button-menu__menu{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;position:absolute;top:38px;right:0;width:auto;z-index:100;background:var(--form-bg);border-radius:var(--border-radius)}.button-menu__menu:before{content:"";position:absolute;top:-5px;right:15px;width:0;height:0;border-right:none;border-bottom:none;border-left:5px solid transparent;border-right:5px solid transparent;border-bottom:5px solid var(--form-bg)}.button-menu__menu:focus{outline:none}.button-menu__menu button{padding:8px 16px;background:none;border:none;text-align:left;white-space:nowrap;border-bottom:1px solid var(--border);cursor:pointer}.button-menu__menu button:hover{color:var(--text);background:var(--focus)}.button-menu__menu button:first-child{border-top-left-radius:2px;border-top-right-radius:2px}.button-menu__menu button:last-child{border-bottom:none;border-bottom-left-radius:2px;border-bottom-right-radius:2px}.button-menu__menu .link-menu{margin-top:3px}.console-operation{position:relative;padding:0 16px;text-align:left;font-size:12px;color:#959da5}.console-operation__summary{margin-left:13px;padding:8px;-webkit-box-sizing:border-box;box-sizing:border-box;outline:none}.console-operation__summary--console{margin-left:0}.console-operation summary{cursor:pointer}.console-operation__status{display:inline-block;position:relative;-webkit-box-sizing:border-box;box-sizing:border-box;padding-right:8px;width:24px;height:18px;text-align:center;vertical-align:middle}.console-operation__icon{position:absolute;left:0;top:0}.console-operation__icon--skipped{fill:#666b71}.console-operation__icon--pending{fill:#dbab0a}.console-operation__icon--active{fill:#dbab0a;-webkit-animation:console-active 1s linear infinite;animation:console-active 1s linear infinite}@-webkit-keyframes console-active{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}50%{-webkit-transform:rotate(180deg);transform:rotate(180deg)}to{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}@keyframes console-active{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}50%{-webkit-transform:rotate(180deg);transform:rotate(180deg)}to{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}.console-operation__icon--success{fill:var(--btn-primary)}.console-operation__icon--error{fill:var(--btn-alert)}.console-operation__label{display:inline-block;overflow:hidden;max-width:750px;vertical-align:top}.console-operation__title{display:inline;margin:0;color:#fff}.console-operation__title--disabled{text-decoration:line-through}.console-operation__description{display:inline;margin:0 0 0 10px}.console-operation__console{position:relative}.console-operation__lines{overflow-y:auto;max-height:280px;padding:8px 0 16px;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;line-height:1.5;white-space:pre-wrap;word-break:break-word;overflow-wrap:break-word}.console-operation__line{display:-webkit-box;display:-ms-flexbox;display:flex}.console-operation__line:hover{background-color:#2f363d}.console-operation__line-number{display:inline-block;overflow:hidden;width:48px;min-width:48px;color:#959da5;text-align:right;text-overflow:ellipsis;white-space:nowrap;vertical-align:middle;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.console-operation__line-content{display:inline-block;margin-left:16px;vertical-align:middle}.console-operation__scroll{position:absolute;left:0;right:0;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:end;-ms-flex-align:end;align-items:flex-end;width:100%;height:30px;padding:0;border:none;cursor:pointer}.console-operation__scroll svg{fill:#fff;width:16px;height:16px}.console-operation__scroll--top{top:0;background:-webkit-gradient(linear,left top,left bottom,from(#24292e),color-stop(50%,rgba(36,41,46,.502)));background:linear-gradient(#24292e,rgba(36,41,46,.502) 50%)}.console-operation__scroll--top svg{-webkit-transform:rotate(180deg);transform:rotate(180deg)}.console-operation__scroll--bottom{bottom:0;background:-webkit-gradient(linear,left top,left bottom,from(rgba(36,41,46,.502)),color-stop(50%,#24292e));background:linear-gradient(rgba(36,41,46,.502),#24292e 50%)}.console-operation__scroll--bottom svg{-webkit-transform:rotate(0deg);transform:rotate(0deg)}.console{background:#24292e;border-radius:8px}.console__header{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;-webkit-box-align:center;-ms-flex-align:center;align-items:center;padding:12px 12px 12px 24px;border-bottom:1px solid #444d56}.console__headline{margin:0;font-size:inherit;line-height:1.5;color:#fff}.console__description{color:#959da5;font-size:12px}.console__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;-webkit-box-align:center;-ms-flex-align:center;align-items:center}.console__action,.console__action>button{height:30px!important;line-height:30px!important;width:auto!important;min-width:0;margin:0 2px;padding:0 5px!important;border:none!important}.console__action:hover,.console__action>button:hover{background-color:#2f363d!important}.console__action--active,.console__action>button--active{background-color:#586069!important}.console__operations{padding:20px 0}.widget-checkbox input{position:absolute;visibility:hidden}.widget-checkbox label{display:block;padding-left:25px;background:url(../img/widget-checkbox--off.73856538.svg) 0 0 no-repeat;background-size:20px 20px;text-align:left}.widget-checkbox input:checked+label{background-image:url(../img/widget-checkbox--on.c05d996c.svg)}.widget-checkbox input:disabled+label{opacity:.5}.widget-checkbox__description{padding-left:25px}.widget-checkbox__description--disabled{opacity:.5}.view-task__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-task__icon{background:var(--contao);border-radius:10px;padding:10px}.view-task__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-task__description{margin:0;font-weight:600}.view-task__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;margin-top:2em}@media(min-width:960px){.view-task__actions{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row}}.view-task .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.view-task .widget-button{width:auto}}.view-task__main{margin:0 50px 50px}.view-task__loading{width:30px;margin:40px auto}.view-task__loading .sk-circle{width:30px;height:30px}.view-task__sponsor{margin:-30px 50px 50px;text-align:center}@media(min-width:960px){.view-task__sponsor br{display:none}}.view-task__donate{position:relative;top:5px;margin-left:.5em;line-height:0}.boot-check{padding:10px}.boot-check:after{display:table;clear:both;content:""}.boot-check__icon{float:left}.boot-check__icon .sk-circle{width:34px;height:34px;margin:3px}.boot-check__icon svg{display:block;width:40px;height:40px}.boot-check__icon--success svg{fill:var(--btn-primary)}.boot-check__icon--info svg,.boot-check__icon--warning svg{fill:var(--btn-warning)}.boot-check__icon--error svg{fill:var(--btn-alert)}.boot-check__label{margin-left:50px}.boot-check__description,.boot-check__detail,.boot-check__title{margin:0;line-height:inherit;overflow:hidden;text-overflow:ellipsis}.boot-check__detail{margin-top:5px;font-size:12px}.boot-check__action{margin-left:50px}.boot-check__action button{margin:15px 0 10px;height:33px;line-height:33px}@media(min-width:960px){.boot-check__label{float:left;width:540px;margin-left:10px}.boot-check__action{float:right;margin:0 0 0 10px;width:140px;text-align:center}.boot-check__action button{margin:3px 0}.boot-check__action a[target=_blank]{display:inline-block;margin:10px 0;padding-left:20px;background:var(--svg--link-blank);background-size:16px 16px}}.config-check__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.config-check__icon{background:var(--contao);border-radius:10px;padding:10px}.config-check__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.config-check__description{text-align:justify}.config-check__form{position:relative;max-width:280px;margin:0 auto 50px}.config-check__form .widget-select,.config-check__form .widget-text{margin-top:20px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.config-check__fields{margin-bottom:2em}.config-check__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.config-check__fielddesc{margin-bottom:1em}.config-check__issues{margin-bottom:1em;color:var(--btn-alert)}.config-check__issues p{font-weight:600}.config-check__issues ul{margin:0;padding:0}.config-check__issues li{margin:.5em 0 0 25px;padding:0}.config-check .widget-button{margin-bottom:.5em}@media(min-width:960px){.config-check{padding-top:100px}.config-check__header{float:left;width:470px;max-width:none;padding:0 60px 100px}.config-check__form{float:left;width:370px;max-width:none;margin:20px 50px 0;padding-bottom:100px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}}.view-boot__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-boot__icon{background:var(--contao);border-radius:10px;padding:10px}.view-boot__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-boot__description{margin:0;font-weight:600}.view-boot__loading{width:30px;margin:0 auto 40px}.view-boot__loading .sk-circle{width:30px;height:30px}.view-boot__checks{margin:0 16px 50px}.view-boot__checks .boot-check:nth-child(odd){border-radius:var(--border-radius);background:var(--table-odd-bg)}.view-boot__summary{margin:50px 0 0}.view-boot__summary--error svg{width:100%;height:40px;fill:var(--btn-alert)}.view-boot__issue{max-width:60%;margin:10px auto;text-align:center;color:var(--btn-alert);line-height:1.2em}.view-boot__safeMode{margin:2em auto 0}.view-boot__continue,.view-boot__safeMode{clear:both;display:block!important;width:220px!important}.view-boot__continue{margin:0 auto}@media(min-width:960px){.view-boot__checks{margin:0 80px 50px}}.widget-radio-button legend{margin-bottom:2px}.widget-radio-button>div{position:relative;margin:.25em 0}.widget-radio-button input{position:absolute;visibility:hidden}.widget-radio-button label{display:block;padding-left:25px;background:url(../img/widget-radio--off.4e93f443.svg) 0 -1px no-repeat;background-size:20px 20px}.widget-radio-button input:checked+label{background-image:url(../img/widget-radio--on.181461b6.svg)}.widget-radio-button input:disabled+label{opacity:.5}.setup__directories{margin-top:2em}.setup__directories>dt{margin-top:1em;font-weight:600}.setup__directories>dd{margin:0;word-break:break-all}.setup__directories>dd span{background-color:var(--highlight-bg);color:var(--highlight-color);font-weight:400}.theme-details__constraint{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.file-tree{margin:0;padding:0;list-style:none}.file-tree__folder{position:relative;padding-left:20px}.file-tree__folder:before{content:"";position:absolute;left:10px;top:6px;width:0;height:0;border-top:5px solid transparent;border-bottom:5px solid transparent;border-left:5px solid var(--text);-webkit-transition:-webkit-transform .1s ease-in-out;transition:-webkit-transform .1s ease-in-out;transition:transform .1s ease-in-out;transition:transform .1s ease-in-out,-webkit-transform .1s ease-in-out}.file-tree__folder--open:before{-webkit-transform:rotate(90deg);transform:rotate(90deg)}.file-tree__file{padding-left:20px}.file-tree button{background:none;border:none;font-weight:400;cursor:pointer}.setup__versions{margin:0;padding:0 0 0 15px}.setup__version{margin:.5em 0;text-align:left}.setup__version--warning{color:var(--btn-alert)}.setup__releaseplan{margin-top:1.5em}.setup__fielddesc--version{margin-bottom:-1em!important}.setup__core-features{margin:5px 0 0 5px;font-size:12px}.setup__theme-image{max-width:100%;height:auto;border:1px solid var(--border)}.setup__theme p{margin:1em 0}.setup__theme-upload{position:absolute!important;visibility:hidden}.setup__themes{padding:0 14px}.setup__themes-results{display:grid;gap:14px}@media(min-width:1024px){.setup__themes-results{grid-template-columns:repeat(2,1fr)}.setup__themes-results-item{-ms-flex-preferred-size:calc(50% - 16px);flex-basis:calc(50% - 16px);margin-left:8px;margin-right:8px}}.setup__themes-item{border:1px solid var(--tiles-bdr)}.setup__themes-more{margin-top:20px;text-align:center}.setup__theme-search{margin:20px 0 0;text-align:center}.setup__theme-search--empty{padding-top:60px;background:url(../img/sad.c9a06488.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--offline{padding-top:60px;background:url(../img/offline.1f95ae24.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--loader .sk-circle{width:50px;height:50px;margin:0 auto 20px}.setup__theme-search button{margin-top:2em}.setup__fielddesc--warning{padding:10px 10px 10px 40px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 10px no-repeat}.setup__tabs{margin:1em 0}.setup__tab-controls{display:-webkit-box;display:-ms-flexbox;display:flex}.setup__tab-control{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;padding:4px 10px;border:none;border-top:1px solid var(--border);border-left:1px solid var(--border);background:none;cursor:pointer}.setup__tab-control:last-child{border-right:1px solid var(--border)}.setup__tab-control--active{border-color:var(--btn);background:var(--btn);color:#fff}.setup__tab{border:1px solid var(--border)}.setup__tab--files{white-space:pre;overflow:scroll;height:200px}.setup__requires{width:100%;border-collapse:collapse}.setup__requires td,.setup__requires th{margin:0;padding:3px 10px;text-align:start;vertical-align:top}.setup__requires th{background:var(--btn);color:#fff}.setup__requires td{border-bottom:1px solid var(--border)}.setup__requires tr:last-child td{border-bottom:none}.setup__requires tr:nth-child(odd) td{background:var(--table-odd-bg)}.setup__or{position:relative;overflow:hidden;margin:1em 0;text-align:center}.setup__or:before{content:"";position:absolute;top:.8em;left:0;right:0;display:block;height:1px;background:var(--border);z-index:1}.setup__or span{position:relative;padding:0 10px;background:var(--popup-bg);z-index:2}:root{--header-main-bg:#fff;--footer-fragment-bdr:#eee;--table-odd-bg:#f5f9fa;--border-radius:6px;--log-header-bg:var(--shadow)}html[data-color-scheme=dark]{--header-main-bg:#292c32;--footer-fragment-bdr:var(--footer-bdr);--table-odd-bg:var(--tiles-bg);--hint-bg:#151619;--hint-rgb:21,22,25;--log-header-bg:var(--btn)}html[data-color-scheme=dark] .vjs-tree-node:hover{background-color:#2b3439}.color-scheme--light,html[data-color-scheme=dark] .color-scheme--dark{display:initial}.color-scheme--dark,html[data-color-scheme=dark] .color-scheme--light{display:none}.view-setup{padding-top:40px}.view-setup footer{margin-top:40px}.view-setup__steps{padding:0 0 50px 0}.view-setup__steps ul{list-style-type:none}.view-setup__steps li,.view-setup__steps ul{display:-webkit-box;display:-ms-flexbox;display:flex;margin:0;padding:0}.view-setup__steps li{-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;position:relative;height:6px}.view-setup__steps li:before{content:"";position:absolute;left:-50%;right:50%;background:var(--border);height:5px}.view-setup__steps li:after{content:"";position:absolute;top:-18px;left:50%;margin-left:-21px;width:42px;height:42px;color:#fff;text-indent:0;text-align:center;line-height:35px;background:var(--border);border-radius:50%;z-index:1}.view-setup__steps li:first-child:before{content:none}.view-setup__steps li.active:after,.view-setup__steps li.active:before{background:var(--contao)}.view-setup__steps button{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;background:transparent;border:none;z-index:10;cursor:pointer}.view-setup__steps button:disabled{cursor:default}.view-setup__steps svg{fill:#fff}.view-setup__main{text-align:center}.view-setup__party{font-size:64px}.view-setup__headline{margin:10px 0 20px;padding:15px 0;font-size:42px;font-weight:100}.view-setup__description{max-width:500px;margin:1em 25px}.view-setup__start.widget-button{height:50px;margin:30px 10px 0;padding:0 50px;font-size:1.2em;line-height:50px}.view-setup__continue.widget-button{width:80%!important;margin:10px 0 0}.view-setup__funding{width:80%;margin:50px auto 0;padding:20px 25px;border:2px solid var(--funding);border-radius:var(--border-radius);background:rgba(var(--funding-rgb),.025);font-weight:400}.view-setup__funding figure{margin-bottom:1em}.view-setup__funding p{margin:0 0 .5em 0}.view-setup__funding-link{margin:1em 0 0}@media(min-width:960px){.view-setup{padding-top:80px}.view-setup footer{margin-top:80px}.view-setup__steps{padding-bottom:80px}.view-setup__headline{margin:20px 0 40px;font-size:64px}.view-setup__continue.widget-button{width:auto!important;margin:25px 10px 0;padding:0 20px}.view-setup__description{max-width:550px;margin:1em auto;font-size:1.2em}.view-setup__funding{display:-webkit-box;display:-ms-flexbox;display:flex;margin:60px auto -20px;text-align:left}.view-setup__funding figure{margin-right:25px}}.setup__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.setup__header .widget-button{margin-top:1em}.setup__icon{background:var(--contao);border-radius:10px;padding:10px}.setup__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.setup__description,.setup__warning{margin:1em 0;text-align:justify}.setup__warning{color:var(--btn-alert);font-weight:600}.setup__form{position:relative;max-width:280px;margin:0 auto 50px;opacity:1}.setup__form svg.setup__check{display:block;width:80px;height:80px;margin:0 auto 2em;fill:var(--btn-primary)}.setup__form .widget-select,.setup__form .widget-text{margin-top:10px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.setup__form .widget-checkbox{margin-top:20px;font-weight:400}.setup__form .widget-radio-button{margin-top:20px}.setup__fields{margin-bottom:2em}.setup__fields--center{text-align:center}.setup__fields .button-group .widget-button{margin-bottom:1px}.setup__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.setup__fielddesc{margin-bottom:1em;text-align:left}.setup__fielddesc code{word-break:break-word}.setup__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;gap:10px}.setup__actions--center{-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center}.setup__actions .button-group,.setup__actions .widget-button{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.setup__actions .button-group--inline,.setup__actions .widget-button--inline{-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0}@media(min-width:960px){.setup{padding-top:100px}.setup__header{float:left;width:470px;max-width:none;padding:0 60px 50px}.setup__form{float:left;width:370px;max-width:none;margin:0 50px 50px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}.setup__form .widget-select input,.setup__form .widget-select select,.setup__form .widget-text input,.setup__form .widget-text select{width:250px!important}}.view-recovery__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0 10px;text-align:center}.view-recovery__icon{background:var(--contao);border-radius:10px;padding:10px}.view-recovery__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-recovery__content{margin:0 30px 50px}@media(min-width:960px){.view-recovery__content{margin-left:50px;margin-right:50px}}.view-recovery__description{font-weight:600;max-width:600px;margin:0 auto;text-align:center}.view-recovery__console{margin:30px 0 60px}.view-recovery__option{margin:50px 0 0;padding:20px 20px 30px;background:var(--table-odd-bg);text-align:center}.view-recovery__option h3{position:relative;top:-40px;margin-bottom:-25px;font-size:2em;font-weight:300}.view-recovery__option button{margin-top:1.5em}.view-recovery__failed{margin:10px 0;color:var(--btn-alert);font-weight:600}.database-migration__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.database-migration__icon{background:var(--contao);border-radius:10px;padding:10px}.database-migration__headline{margin-top:.5em;margin-bottom:.5em;font-size:36px;font-weight:100;line-height:1}.database-migration__description{margin:0 50px;font-weight:600}.database-migration__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;margin-top:2em;padding:0 50px}@media(min-width:960px){.database-migration__actions{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row}}.database-migration .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.database-migration .widget-button{width:auto}}.database-migration__main{margin:0 50px 50px;background:#24292e}.database-migration__loading{width:30px;margin:40px auto}.database-migration__loading .sk-circle{width:30px;height:30px}html{-webkit-box-sizing:border-box;box-sizing:border-box}*,:after,:before{-webkit-box-sizing:inherit;box-sizing:inherit}#app,body,html{height:100%}blockquote,body,figure,form,p{margin:0;padding:0}article,aside,figcaption,figure,footer,header,main,nav,section{display:block}body,div,fieldset,form,h1,h2,h3,h4,h5,h6,html,p{-webkit-text-size-adjust:none;-moz-text-size-adjust:none;-ms-text-size-adjust:none;text-size-adjust:none}body{background:var(--body-bg);overflow-y:hidden}#app{overflow-y:scroll}fieldset{border:none;margin:0;padding:0}legend{-webkit-padding-start:0;-webkit-padding-end:0}figure{line-height:0}body,button,input,textarea{font:300 14px/1.4 -apple-system,system-ui,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;color:var(--text)}strong{font-weight:600}code{font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace}input,select,textarea{font-size:99%}input:disabled,select:disabled,textarea:disabled{color:var(--text);-webkit-text-fill-color:var(--text);cursor:text}input::-ms-clear,input::-ms-reveal,select::-ms-clear,select::-ms-reveal,textarea::-ms-clear,textarea::-ms-reveal{display:none}.invisible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.clearfix{*zoom:1}.clearfix:after,.clearfix:before{display:table;content:"";line-height:0}.clearfix:after{clear:both}h1,h2,h3,h4,h5,h6{font-size:inherit;line-height:inherit;font-weight:600;margin:0}a{color:var(--link);text-decoration:none}a:hover{text-decoration:underline}h1{font-size:18px;line-height:30px;margin-bottom:10px}@-webkit-keyframes input-error{0%{left:0}25%{left:-5px}75%{left:5px}to{left:0}}@keyframes input-error{0%{left:0}25%{left:-5px}75%{left:5px}to{left:0}}:root{--text:#535353;--link:#f47c00;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.04773c88.svg);--svg--private:url(../img/private.2455f3fb.svg);--svg--updated:url(../img/updated.b67e9160.svg);--svg--downloads:url(../img/downloads.ef96865d.svg);--svg--favers:url(../img/favers.f48a12a8.svg);--svg--language:url(../img/language.509ee1aa.svg);--svg--color-scheme:url(../img/color_scheme.a51e992d.svg)}html[data-color-scheme=dark]{--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--link-footer:#fff;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.74e01873.svg);--svg--private:url(../img/private--dark.1a50a552.svg);--svg--updated:url(../img/updated--dark.6c7ad8f3.svg);--svg--downloads:url(../img/downloads--dark.6070f904.svg);--svg--favers:url(../img/favers--dark.8589e259.svg);--svg--language:url(../img/language--dark.384e91d7.svg);--svg--color-scheme:url(../img/color_scheme--dark.57222cc0.svg)}html[data-color-scheme=dark] #contao-network{background:#292c32!important;color:#ddd!important}.widget{position:relative}.widget__error{display:none;position:absolute;bottom:-6px;left:0;right:0;margin:0;padding:4px 10px;color:var(--clr-btn);background:var(--btn-alert);border-radius:2px;-webkit-transform:translateY(100%);transform:translateY(100%);z-index:10;white-space:pre-line}.widget__error:after,.widget__error:before{bottom:100%;left:50%;border:solid transparent;content:" ";height:0;width:0;position:absolute;pointer-events:none}.widget__error:after{border-bottom-color:var(--btn-alert);border-width:3px;margin-left:-3px}.widget__error:before{border-bottom-color:var(--btn-alert);border-width:5px;margin-left:-5px}input:focus+.widget__error,input:hover+.widget__error,select:hover+.widget__error{display:block}input:not([type=checkbox]):not([type=radio]),select{position:relative;width:100%;height:38px;padding:0 20px;background:var(--form-bg);border:1px solid var(--border);border-radius:6px;color:var(--text);-webkit-appearance:none;-moz-appearance:none;appearance:none}input:not([type=checkbox]):not([type=radio]):focus,select:focus{outline:none;background-color:var(--focus)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-moz-placeholder-shown):valid,.widget--validate select:not(:-moz-placeholder-shown):valid{border-color:var(--btn-primary)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-ms-input-placeholder):valid,.widget--validate select:not(:-ms-input-placeholder):valid{border-color:var(--btn-primary)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):valid,.widget--validate select:not(:placeholder-shown):valid{border-color:var(--btn-primary)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-moz-placeholder-shown):invalid,.widget--validate select:not(:-moz-placeholder-shown):invalid{border-color:var(--btn-alert)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-ms-input-placeholder):invalid,.widget--validate select:not(:-ms-input-placeholder):invalid{border-color:var(--btn-alert)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):invalid,.widget--validate select:not(:placeholder-shown):invalid{border-color:var(--btn-alert)}.widget--error input:not([type=checkbox]):not([type=radio]),.widget--error select{border-color:var(--btn-alert);-webkit-animation:input-error .15s linear 3;animation:input-error .15s linear 3}select{padding-right:30px}.widget-select:after{position:absolute;right:12px;bottom:16px;width:0;height:0;border-left:6px solid transparent;border-right:6px solid transparent;border-top:6px solid var(--border);content:"";pointer-events:none}.widget-button{display:inline-block;width:100%;height:38px;padding:0;border:none;background-color:var(--btn);color:var(--clr-btn);font-weight:600;line-height:38px;text-decoration:none;text-align:center;white-space:nowrap;cursor:pointer;border-radius:5px}.widget-button:active,.widget-button:hover{background-color:var(--btn-active)}.widget-button--inline{width:auto!important;min-width:100px;padding:0 20px}.widget-button--transparent{background:transparent}.widget-button--small{height:28px;width:auto!important;min-width:0;padding:0 15px;font-size:13px;line-height:28px;font-weight:300}.widget-button--small:before,.widget-button--small>:before{top:3px!important;width:15px!important;height:15px!important;margin-right:4px!important;background-size:15px 15px!important}.widget-button--primary{--btn:var(--btn-primary);--btn-active:var(--btn-primary-active)}.widget-button--warning{--btn:var(--btn-warning);--btn-active:var(--btn-warning-active)}.widget-button--alert{--btn:var(--btn-alert);--btn-active:var(--btn-alert-active)}.widget-button--info{--btn:var(--btn-info);--btn-active:var(--btn-info-active)}.widget-button--funding{--btn:var(--btn-funding);--btn-active:var(--btn-funding-active)}.widget-button--add:before{background-image:url(../img/button-add.759df12e.svg)}.widget-button--check:before{background-image:url(../img/button-check.8170bc92.svg)}.widget-button--cloud:before{background-image:url(../img/button-cloud.5015c41d.svg)}.widget-button--cloud-off:before{background-image:url(../img/button-cloud-off.37842942.svg)}.widget-button--console:before{background-image:url(../img/button-console.93e68609.svg)}.widget-button--database:before{background-image:url(../img/button-database.1f267fe1.svg)}.widget-button--download:before{background-image:url(../img/button-download.ce5cd0d3.svg)}.widget-button--edit:before{background-image:url(../img/button-edit.d4a8737e.svg)}.widget-button--gear:before{background-image:url(../img/button-gear.75fa79f0.svg)}.widget-button--hide:before{background-image:url(../img/button-hide.6a3eaaf7.svg)}.widget-button--details:before{background-image:url(../img/button-details.78532630.svg)}.widget-button--link:before{background-image:url(../img/button-link.e4488c1f.svg)}.widget-button--lock:before{background-image:url(../img/button-lock.98988f08.svg)}.widget-button--maintenance:before{background-image:url(../img/button-maintenance.18fa2ce6.svg)}.widget-button--more:before{background-image:url(../img/button-more.e3eb2622.svg)}.widget-button--power:before{background-image:url(../img/button-power.6b957f3a.svg)}.widget-button--run:before{background-image:url(../img/button-run.5c7703ae.svg)}.widget-button--save:before{background-image:url(../img/button-save.7704614c.svg)}.widget-button--search:before{background-image:url(../img/button-search.6f2edfbf.svg)}.widget-button--show:before{background-image:url(../img/button-show.2336e1d9.svg)}.widget-button--trash:before{background-image:url(../img/button-trash.a2f11028.svg)}.widget-button--unlock:before{background-image:url(../img/button-unlock.51b76e07.svg)}.widget-button--update:before{background-image:url(../img/button-update.c63bd5a5.svg)}.widget-button--upload:before{background-image:url(../img/button-upload.b489ceec.svg)}.widget-button .icon-selector:before,.widget-button--add:before,.widget-button--check:before,.widget-button--cloud-off:before,.widget-button--cloud:before,.widget-button--console:before,.widget-button--database:before,.widget-button--details:before,.widget-button--download:before,.widget-button--edit:before,.widget-button--gear:before,.widget-button--hide:before,.widget-button--link:before,.widget-button--lock:before,.widget-button--maintenance:before,.widget-button--more:before,.widget-button--power:before,.widget-button--run:before,.widget-button--save:before,.widget-button--search:before,.widget-button--show:before,.widget-button--trash:before,.widget-button--unlock:before,.widget-button--update:before,.widget-button--upload:before{position:relative;display:inline-block;top:5px;width:20px;height:20px;margin-right:8px;background-position:50%;background-repeat:no-repeat;background-size:20px 20px;content:""}.widget-button .icon-selector:empty:before,.widget-button--add:empty:before,.widget-button--check:empty:before,.widget-button--cloud-off:empty:before,.widget-button--cloud:empty:before,.widget-button--console:empty:before,.widget-button--database:empty:before,.widget-button--details:empty:before,.widget-button--download:empty:before,.widget-button--edit:empty:before,.widget-button--gear:empty:before,.widget-button--hide:empty:before,.widget-button--link:empty:before,.widget-button--lock:empty:before,.widget-button--maintenance:empty:before,.widget-button--more:empty:before,.widget-button--power:empty:before,.widget-button--run:empty:before,.widget-button--save:empty:before,.widget-button--search:empty:before,.widget-button--show:empty:before,.widget-button--trash:empty:before,.widget-button--unlock:empty:before,.widget-button--update:empty:before,.widget-button--upload:empty:before{margin-right:0!important}.widget-button:empty{min-width:auto;padding:0 10px}.widget-button:empty:before{margin-right:0!important}.widget-button:hover{text-decoration:none}.widget-button.disabled,.widget-button:disabled{background-color:var(--btn-disabled)!important;border-color:var(--btn-disabled)!important;cursor:not-allowed;opacity:var(--opacity-disabled,1)}.widget-button.disabled{pointer-events:none}label{padding:0}.widget--required label:after{margin-left:2px;content:"*";color:var(--btn-alert)}input:-webkit-autofill,select:-webkit-autofill{-webkit-text-fill-color:var(--text);-webkit-box-shadow:inset 0 0 0 1000px hsla(0,0%,100%,0);-webkit-transition:background-color 5000s ease-in-out 0s;transition:background-color 5000s ease-in-out 0s}.animate-initializing{-webkit-animation:initializing 1s linear infinite;animation:initializing 1s linear infinite}@-webkit-keyframes initializing{0%{opacity:.5}50%{opacity:1}to{opacity:.5}}@keyframes initializing{0%{opacity:.5}50%{opacity:1}to{opacity:.5}}.animate-blur-in{z-index:-1;opacity:.5;-webkit-filter:blur(4px);filter:blur(4px);-webkit-transition:opacity .35s,-webkit-filter .5s;transition:opacity .35s,-webkit-filter .5s;transition:opacity .35s,filter .5s;transition:opacity .35s,filter .5s,-webkit-filter .5s}.animate-blur-out{opacity:1;-webkit-transition:opacity .35s;transition:opacity .35s}.animate-fade-enter-active,.animate-fade-leave-active{-webkit-transition-duration:.2s;transition-duration:.2s;-webkit-transition-property:opacity;transition-property:opacity;-webkit-transition-timing-function:ease;transition-timing-function:ease}.animate-fade-enter,.animate-fade-leave-active{opacity:0}.animate-flip-enter-active,.animate-flip-leave-active{-webkit-transform-style:preserve-3d;transform-style:preserve-3d;-webkit-backface-visibility:hidden;backface-visibility:hidden;-webkit-transition-duration:.5s;transition-duration:.5s;-webkit-transition-property:opacity,-webkit-transform;transition-property:opacity,-webkit-transform;transition-property:transform,opacity;transition-property:transform,opacity,-webkit-transform}.animate-flip-leave-active{-webkit-transform:perspective(600px) rotateY(0deg);transform:perspective(600px) rotateY(0deg);opacity:1}.animate-flip-leave-to{-webkit-transform:perspective(600px) rotateY(90deg);transform:perspective(600px) rotateY(90deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in;opacity:0}.animate-flip-enter-active{-webkit-transform:perspective(400px) rotateY(270deg);transform:perspective(400px) rotateY(270deg);opacity:0}.animate-flip-enter-to{-webkit-transform:perspective(400px) rotateY(1turn);transform:perspective(400px) rotateY(1turn);-webkit-transition-timing-function:ease-out;transition-timing-function:ease-out;opacity:1}.https-warning{position:absolute;top:0;left:0;right:0;height:27px;padding:4px 8px;background:var(--btn-warning);color:#fff;text-align:center;z-index:100}.https-warning__description{display:none}@media(min-width:600px){.https-warning__description{display:inline}}.https-warning__link{color:#fff;text-decoration:underline}.https-warning+div{padding-top:25px}.safe-mode{position:absolute;top:0;left:0;right:0;height:27px;padding:4px 8px;background:var(--btn-alert);color:#fff;text-align:center;z-index:100}.safe-mode__description{display:none}@media(min-width:600px){.safe-mode__description{display:inline}}.safe-mode__link{color:#fff;text-decoration:underline}.safe-mode+div{padding-top:25px}.view-init{display:table;width:100%;height:100%}.view-init__cell{display:table-cell;font-size:1.5em;text-align:center;vertical-align:middle}"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[518],{22518:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Extensies","ui.app.loading":"Extensie Lijst laden …","ui.app.language":"Wijzig de taal voor de Contao Manager","ui.app.colorDark":"Donkere modus","ui.app.colorDarkTitle":"Verander het kleurenschema naar donker","ui.app.colorLight":"Lichte modus","ui.app.colorLightTitle":"Verander het kleurenschema naar licht","ui.discover.advertisement":"Advertentie in de extensielijst","ui.discover.loading":"Bezig met laden ...","ui.discover.offline":"Kon geen resultaten ophalen.","ui.discover.offlineExplain":"Controleer uw internetverbinding en schakel JavaScript blokkers uit in uw browser.","ui.discover.offlineButton":"Probeer opnieuw","ui.discover.searchPlaceholder":"Zoeken in {count} extensies…","ui.discover.empty":"Geen resultaten voor {query}","ui.discover.more":"Meer resultaten","ui.discover.sortBy":"Sorteren op","ui.discover.sortReleased":"Uitgebracht","ui.discover.sortReleasedTitle":"Sorteer de resultaten op releasedatum","ui.discover.sortLatest":"Updated","ui.discover.sortLatestTitle":"Sorteer de resultaten op laatst bijgewerkt","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Sorteer resultaten op aantal downloads","ui.discover.sortFavers":"Beoordeling","ui.discover.sortFaversTitle":"Sorteer de resultaten op beoordeling","ui.discover.detailsButton":"Details","ui.discover.latestPackages":"Nieuwste en bijgewerkte extensies","ui.discover.faversPackages":"Best beoordeelde extensies","ui.discover.downloadsPackages":"Meest gedownloade extensies","ui.package.homepage":"Project Website","ui.package.private":"Privépakket","ui.package.privateTitle":"Privépakketten zijn alleen verkrijgbaar bij de leverancier (bijvoorbeeld als ZIP-download). Bezoek de website voor meer informatie.","ui.package.abandoned":"niet meer ondersteund","ui.package.abandonedText":"Dit pakket wordt niet langer ondersteund en onderhouden.","ui.package.abandonedReplace":"Dit pakket wordt niet langer ondersteund en onderhouden. De auteur stelt voor om in plaats daarvan het {vervangend} pakket te gebruiken.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Vorige Extensie Details","ui.package-details.close":"Sluit Extensie Details","ui.package-details.loading":"Bezig met laden ...","ui.package-details.tabDescription":"Beschrijving","ui.package-details.tabRequire":"Vereisten","ui.package-details.tabFeatures":"Kenmerken","ui.package-details.tabSuggest":"Suggesties","ui.package-details.tabConflict":"Conflicten","ui.package-details.tabDependents":"Afhankelijkheden","ui.package-details.linkRequires":"vereist","ui.package-details.linkReplaces":"vervangt","ui.package-details.linkProvides":"biedt","ui.package-details.linkConflicts":"conflicten","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Laatste versie","ui.package-details.released":"uitgebracht op","ui.package-details.license":"Licentie(s)","ui.package-details.authors":"van","ui.package-details.more":"Meer","ui.package-details.packagist":"Details bundel","ui.package-details.metadata":"Bewerk Metadata","ui.package-details.support_docs":"Documentatie","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support Forum","ui.package-details.support_issues":"Problemen / Foutrapport","ui.package-details.support_source":"Broncode","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[120],{98120:function(e){e.exports=JSON.parse('{"ui.app.title":"Extensions Contao","ui.app.loading":"Chargement de la liste des extensions…","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Publicité dans la liste des extensions","ui.discover.loading":"Chargement…","ui.discover.offline":"Impossible de récupérer des résultats.","ui.discover.offlineExplain":"Vérifiez votre connexion Internet et désactivez les bloqueurs JavaScript dans votre navigateur.","ui.discover.offlineButton":"Réessayer","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"Pas de résultats pour {query}","ui.discover.more":"Plus de résulats","ui.discover.sortBy":"Trier par","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Mis à jour","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Téléchargements","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Note","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Détails","ui.discover.latestPackages":"Extensions les plus récentes et mises à jour","ui.discover.faversPackages":"Extensions les mieux notées","ui.discover.downloadsPackages":"Extensions les plus téléchargées","ui.package.homepage":"Site web du projet","ui.package.private":"Package privé","ui.package.privateTitle":"Les packages privés ne sont disponibles que chez le fournisseur (par exemple sous forme de téléchargement ZIP). Veuillez visiter le site Web pour plus d\'informations","ui.package.abandoned":"abandonné","ui.package.abandonedText":"Ce package est abandonné et n\'est plus maintenu.","ui.package.abandonedReplace":"Ce package est abandonné et n\'est plus maintenu. L\'auteur suggère d\'utiliser le package {replacement} à la place.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Extension précédente","ui.package-details.close":"Fermer les détails","ui.package-details.loading":"Chargement…","ui.package-details.tabDescription":"Description","ui.package-details.tabRequire":"Prérequis","ui.package-details.tabFeatures":"Fonctionnalités","ui.package-details.tabSuggest":"Suggestions","ui.package-details.tabConflict":"Conflits","ui.package-details.tabDependents":"Dépendants","ui.package-details.linkRequires":"nécessite","ui.package-details.linkReplaces":"remplaces","ui.package-details.linkProvides":"fournis","ui.package-details.linkConflicts":"conflits","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Dernière version","ui.package-details.released":"Publié le","ui.package-details.license":"License(s)","ui.package-details.authors":"de","ui.package-details.more":"Plus","ui.package-details.packagist":"Détails du Package","ui.package-details.metadata":"Editer les Metadata","ui.package-details.support_docs":"Documentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support","ui.package-details.support_issues":"Issues / Bug Report","ui.package-details.support_source":"Code source","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[560],{1560:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Nedrošs savienojums !!","ui.app.httpsDescription":"Bez HTTPS jūsu konfidenciālie dati tiks pārsūtīti nešifrēti.","ui.app.httpsLink":"Vairāk informācijas","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Ieslēgts drošais režīms !!","ui.app.safeModeDescription":"Dažas Contao Manager funkcijas nav pieejamas.","ui.app.safeModeExit":"Iziet no drošā režīma","ui.app.loading":"Ielādē Contao pārvaldnieku ...","ui.app.apiError":"Negaidīts API statuss","ui.app.configSecurity1":"DROŠĪBAS BRĪDINĀJUMS !!! Konstatēts neaizsargāts konfigurācijas direktorijs","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Laipni lūdzam","ui.account.intro1":"Laipni lūgti Contao pārvaldniekā, kas ir universāls rīks Contao atvērtā koda CMS instalēšanai un pārvaldībai. Ja esat jauns lietotājs, lūdzu, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, lai sāktu","ui.account.introManual":"izlasiet rokasgrāmatu","ui.account.intro2":"Ja jums rodas kādas problēmas, pārbaudiet {ourGithubIssues} un nekautrējieties izveidot jaunu problēmu, ja par to vēl nav ziņots.","ui.account.introIssues":"mūsu GitHub problēmas","ui.account.headline":"Lietotāja konts","ui.account.description":"Lai pārvaldītu savu instalāciju, lūdzu, izveidojiet Contao pārvaldnieka kontu. Ņemiet vērā, ka šis konts nav saistīts ar Contao aizmuguri vai priekšu.","ui.account.username":"Lietotājvārds","ui.account.password":"Parole","ui.account.passwordPlaceholder":"min. 8 rakstzīmes","ui.account.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.account.submit":"Izveidot kontu","ui.account.contribute1":"Contao un Contao Manager sponsorē bezpeļņas organizācija Contao Association.","ui.account.contribute2":"Lūdzu, apsveriet iespēju sniegt ieguldījumu atvērtajā pirmkodā {donate}.","ui.account.contributeDonate":"ziedojuma veikšana","ui.login.headline":"Pierakstīties","ui.login.description":"Pierakstīties, lai pārvaldītu savu instalāciju.","ui.login.username":"Lietotājvārds","ui.login.password":"Parole","ui.login.forgotPassword":"Aizmirsāt paroli?","ui.login.button":"Pierakstīties","ui.login.locked":"Piekļuve ir liegta, jo Contao Manager ir bloķēts. Lai atbloķētu, izdzēsiet {lockFile} datni Contao galvenajā direktorijā.","ui.logout.headline":"Sesijas laika limits","ui.logout.warning":"Jūs esat bijis neaktīvs ilgāk par 25 minūtēm. Drošības apsvērumu dēļ jūsu sesija drīz tiks pārtraukta.","ui.logout.expired":"Jūsu sesija tika automātiski pārtraukta, jo esat bijis neaktīvs ilgāk par 30 minūtēm.","ui.logout.renew":"Palikt pieteikušamies","ui.logout.logout":"Izrakstīties","ui.logout.login":"Atpakaļ uz pieteikšanos","ui.oauth.error":"Nederīgs OAuth mēģinājums. Pārbaudiet pieprasījuma parametrus.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Attālā autentifikācija","ui.oauth.description":"Šāda lietojumprogramma vai pakalpojums pieprasa attālo piekļuvi jūsu Contao Manager instancei.","ui.oauth.domain":"Pirms atļaujat piekļuvi, pārliecinieties, ka zināt šo URL un uzticaties tā īpašniekam!","ui.oauth.allow":"Atļaut piekļuvi","ui.oauth.deny":"Liegt piekļuvi","ui.boot.headline":"Sistēmas pārbaude","ui.boot.description":"Lūdzu, uzgaidiet, mēs analizējam jūsu serveri ...","ui.boot.issue1":"Konstatētās  instalēšanas problēmas","ui.boot.issue2":"Jūsu instalācijā ir problēmas, kas jānovērš, pirms var izmantot Contao Manager.","ui.boot.run":"Palaist Contao pārvaldnieku","ui.boot.safeMode":"Palaist drošajā režīmā","ui.recovery.headline":"Sistēmas atkopšana","ui.recovery.description":"Contao Manager atklāja datnes, kas izskatās kā Contao, bet komandrindas saskarne nedarbojas, kā paredzēts.","ui.recovery.console":"Konsoles izvade","ui.recovery.repairOptions":"Lūdzu, izvēlieties iespēju, lai salabotu instalāciju.","ui.recovery.repairHeadline":"Automātiskā izlabošana","ui.recovery.repairDescription":"Mēģina automātiski labot instalāciju, atjaunojot lietojumprogrammu kešatmiņu un atkārtoti instalējot Composer paketes.","ui.recovery.repairWarning":"Procesa laikā var tikt dzēstas visas piegādātāja datņu izmaiņas!","ui.recovery.repairFailed":"Automātiskā labošana nebija veiksmīga. Izmēģiniet instalāciju labot manuāli drošajā režīmā.","ui.recovery.repairButton":"Palaist sistēmas izlabošanu","ui.recovery.safeModeHeadline":"Drošais režīms","ui.recovery.safeModeDescription":"Programmas Contao Manager palaišana drošajā režīmā ļauj pārvaldīt paketes un veikt dažus uzturēšanas uzdevumus, taču funkcijas, kas ir atkarīgas no darbojošās Contao instalācijas, nebūs pieejamas.","ui.recovery.safeModeButton":"Palaist drošajā režīmā","ui.server.pending":"Gaida ...","ui.server.running":"Analizē ...","ui.server.error":"Pārbaude neizdevās, jo no servera saņemta neparedzēta atbilde.","ui.server.details":"Sīkāka informācija","ui.server.prerequisite":"Pārbaude atcelta trūkstošā priekšnosacījuma dēļ.","ui.server.selfUpdate.title":"Contao pārvaldnieka atjauninājumi","ui.server.selfUpdate.update":"Ir pieejama jauna Contao pārvaldnieka versija {latest}.","ui.server.selfUpdate.manualUpdate":"Ir pieejama jauna Contao Manager versija {latest}. Jūsu serveris neatbalsta automātiskus atjauninājumus, lūdzu, lejupielādējiet jauno versiju no {download}.","ui.server.selfUpdate.latest":"Jūs izmantojat jaunāko versiju {current}.","ui.server.selfUpdate.dev":"Izstrādes būves neatbalsta automātiskus atjauninājumus.","ui.server.selfUpdate.unsupported":"Ir pieejama jauna versija, taču tā neatbalsta jūsu PHP versiju.","ui.server.selfUpdate.button":"Palaist pašatjauninājumu","ui.server.selfUpdate.continue":"Turpināt","ui.server.config.title":"Servera konfigurācija","ui.server.config.setup":"Konfigurēt","ui.server.config.change":"Mainīt","ui.server.config.save":"Saglabāt","ui.server.config.cancel":"Atcelt","ui.server.config.customOption":"Cits ...","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Servera konfigurācija","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Izmantot Composer Resolver Cloud","ui.server.config.cli":"PHP binārs","ui.server.config.stateErrorCli":"Serverī netika atrasts derīgs PHP binārs.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud netiek atbalstīts.","ui.server.config.stateSuccess":"PHP binārais kodols {php_cli}.","ui.server.php_web.title":"PHP Web process","ui.server.php_web.below7":"Atrasta PHP versija {versija}. Lūdzu, pēc iespējas ātrāk pārejiet uz PHP 7!","ui.server.php_web.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.php_cli.title":"PHP komandrindas saskarne","ui.server.php_cli.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.composer.title":"Composer vide","ui.server.composer.success":"Netika atrastas zināmas problēmas.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Uzstādīt","ui.server.contao.title":"Contao instalācija","ui.server.contao.setup":"Uzstādīt","ui.server.contao.check":"Pārbaudīt datubāzi","ui.server.contao.empty":"Neviena Contao instalācija nav atrasta.","ui.server.contao.old":"Contao versija {versija} nav savietojama ar Contao pārvaldnieku, lūdzu, manuāli atjauniniet instalāciju.","ui.server.contao.found":"Atrasts Contao {versija} (API versija {api}).","ui.server.contao.connectionError":"Nevar izveidot savienojumu ar datubāzes serveri.","ui.server.contao.connectionProblem":"Atrasta datubāzes problēma.","ui.server.contao.missingUser":"Administratora konts nav atrasts.","ui.setup.continue":"Turpināt","ui.setup.manager":"Palaist Contao pārvaldnieku","ui.setup.cancel":"Atcelt","ui.setup.welcome":"Laipni lūdzam","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"kopienas atbalsts","ui.setup.start":"Sākt","ui.setup.complete":"Apsveicam!","ui.setup.complete1":"Contao {versija} ir veiksmīgi instalēta.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Atveriet instalēšanas rīku","ui.setup.login":"Pieslēgties Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Uzzināt vairāk","ui.setup.document-root.headline":"Tīmekļa servera iestatīšana","ui.setup.document-root.warning":"Lai instalētu Contao, izmantojot Contao Manager, tīmekļa serverī ir jānosaka dokumenta sakne.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Ja nezināt, kā konfigurēt dokumentu sakni, izlasiet Contao dokumentāciju vai sazinieties ar savu hostinga pakalpojumu sniedzēju.","ui.setup.document-root.documentation":"Izlasiet dokumentāciju","ui.setup.document-root.conflictsTitle":"Instalācijas direktorijs nav tukšs","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Pārbaudiet vēlreiz","ui.setup.document-root.create":"Izveidot direktorijus","ui.setup.document-root.change":"Mainīt direktorijus","ui.setup.document-root.formTitle":"Direktoriju iestatīšana","ui.setup.document-root.formText1":"Contao Manager var automātiski izveidot jaunu direktoriju struktūru serverī.","ui.setup.document-root.formText2":"Jums būs manuāli jākonfigurē jaunā dokumenta sakne (piemēram, izmantojot hostinga administratora paneli).","ui.setup.document-root.autoconfig":"Es saprotu, ka man ir jāmaina servera konfigurācija. Dokumenta saknes nekonfigurēšana sabojās Contao Manager un atklās konfigurācijas failus (tostarp konta informāciju un paroles)!","ui.setup.document-root.directory":"Jauns direktorijs","ui.setup.document-root.currentRoot":"Pašreizējā dokumenta sakne","ui.setup.document-root.newRoot":"Jauna dokumenta sakne","ui.setup.document-root.finish":"Direktoriju iestatīšana","ui.setup.document-root.publicDir":"Izmantojiet {dir} publiskajām datnēm (Contao {version})","ui.setup.document-root.directoryInvalid":"Lūdzu, ievadiet derīgu direktorija nosaukumu.","ui.setup.document-root.directoryExists":"Mērķa direktorijs jau pastāv. Lūdzu, ievadiet citu nosaukumu.","ui.setup.document-root.confirmation":"Contao pārvaldnieks ir veiksmīgi izveidojis nepieciešamo direktoriju jūsu Contao instalācijai. Tagad jums ir jākonfigurē dokumenta sakne tīmekļa serverī. Līdz tam nepārlādējiet šo lapu no jauna.","ui.setup.document-root.reload":"Pārlādēt lapu","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Lietojumprogrammas datnes tiks instalētas {dir}.","ui.setup.document-root.installingPublicDir":"Publiskās datnes tiks instalētas {dir}.","ui.setup.document-root.installedProjectDir":"Lietojumprogrammas datnes ir instalētas {dir}.","ui.setup.document-root.installedPublicDir":"Publiskās datnes ir instalētas {dir}.","ui.setup.create-project.headline":"Contao instalācija","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Jaunākais","ui.setup.create-project.ltsTitle":"Ilgtermiņa atbalsts","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"Dokumenta saknei jābūt \\"{folder}\\".","ui.setup.create-project.releaseplan":"Sīkāku informāciju skatiet {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"Contao izlaišanas plāns","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Izvēlēties distribūciju","ui.setup.create-project.formText":"Lūdzu, izvēlieties, kura versija jāuzstāda.","ui.setup.create-project.version":"Versija","ui.setup.create-project.demo":"Instalēt Contao demo vietni","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Minimāla instalācija (tikai Core)","ui.setup.create-project.noUpdate":"Izlaist instalāciju (tikai eksperts!)","ui.setup.create-project.theme":"Contao tēma","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao tēmu veikals","ui.setup.create-project.themeUpload":"Augšupielādēt tēmas datni (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Meklēt tēmas","ui.setup.create-project.theme.more":"Vairāk tēmas","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"Tēmas datne tika veiksmīgi augšupielādēta.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Versija","ui.setup.create-project.theme.authors":"Autors(i)","ui.setup.create-project.install":"Uzstādīt","ui.setup.create-project.cancel":"Atcelt","ui.setup.database-connection.headline":"Datubāzes savienojums","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Savienojuma parametri","ui.setup.database-connection.formText":"Ievadiet datubāzes URL vai atsevišķi aizpildiet lietotājvārdu, paroli, serveri un datubāzes laukus.","ui.setup.database-connection.url":"Datubāzes URL","ui.setup.database-connection.validUrl":"Datubāzes URL ir nederīgs vai neizdevās izveidot savienojumu ar serveri.","ui.setup.database-connection.or":"vai","ui.setup.database-connection.user":"Lietotājvārds","ui.setup.database-connection.password":"Parole","ui.setup.database-connection.server":"Serveris (:ports)","ui.setup.database-connection.database":"Datubāzes nosaukums","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Kļūda, savienojoties ar datubāzi.","ui.setup.database-connection.problem":"Contao ir atklājis problēmu ar jūsu datubāzes serveri.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Jūsu datubāzes shēma ir aktuāla.","ui.setup.database-connection.check":"Pārbaudīt datubāzi","ui.setup.database-connection.skip":"Izlaist","ui.setup.database-connection.save":"Saglabāt","ui.setup.database-connection.change":"Mainīt akreditācijas datus","ui.setup.database-connection.restoreTitle":"Datubāzes imports","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Dublējiet pašreizējo datu bāzi pirms importēšanas","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Aizmugures konts","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Izveidot kontu","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Lietotājvārds","ui.setup.backend-user.name":"Vārds","ui.setup.backend-user.email":"E-pasta adrese","ui.setup.backend-user.emailInvalid":"Lūdzu, ievadiet derīgu e-pasta adresi","ui.setup.backend-user.password":"Parole","ui.setup.backend-user.passwordPlaceholder":"min. 8 rakstzīmes","ui.setup.backend-user.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.setup.backend-user.create":"Pievienot kontu","ui.task.headline":"Fona uzdevums","ui.task.loading":"Ielādē informāciju ...","ui.task.created":"Ielādē informāciju ...","ui.task.active":"Lūdzu, pagaidiet, kamēr Contao Manager fona režīmā tiek veiktas uzdevumu operācijas.","ui.task.complete":"Visas operācijas ir veiksmīgi pabeigtas. Sīkāku informāciju skatiet konsoles izvades failā.","ui.task.aborting":"Lūdzu, uzgaidiet, kamēr tiek atceltas fona operācijas.","ui.task.stopped":"Dažas fona darbības tika atceltas. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.error":"Fona operācija negaidīti apstājās. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.failed":"Contao pārvaldniekam neizdevās palaist fona uzdevumu!","ui.task.failedDescription1":"Mēģinot izpildīt operācijas fonā, kaut kas notika nepareizi.","ui.task.failedDescription2":"Ja tas atkārtojas, iespējams, ka jūsu serveris netiek atbalstīts.","ui.task.reportProblem":"Ziņot par problēmu","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Atjaunināt datubāzi","ui.task.buttonClose":"Aizvērt","ui.task.buttonConfirm":"Apstiprināt & aizvērt","ui.task.buttonCancel":"Atcelt","ui.task.confirmCancel":"Vai noteikti vēlaties atcelt šo uzdevumu? Tas var atstāt jūsu Contao instalāciju bojātā stāvoklī!","ui.task.autoclose":"Aizvērt uzdevuma informāciju pēc izdošanās","ui.console.toggle":"Rādīt/slēpt konsoles izvadi","ui.console.showLog":"Rādīt pilnu konsoles žurnālu","ui.console.copyLog":"Kopēt žurnālu uz starpliktuvi","ui.migrate.headline":"Datubāzes atjauninājumi","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Lūdzu, uzgaidiet, mēs pārbaudām jūsu datubāzi...","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Izpildīt","ui.migrate.close":"Aizvērt","ui.migrate.confirm":"Apstiprināt & aizvērt","ui.migrate.cancel":"Atcelt","ui.migrate.continue":"Turpināt","ui.migrate.setup":"Uzstādīt","ui.migrate.skip":"Izlaist","ui.migrate.retry":"Pārbaudiet vēlreiz","ui.migrate.retryAll":"Atzīmēt visus","ui.migrate.withDeletes":"Izpildīt visas datubāzes izmaiņas, tostarp DROP vaicājumus.","ui.migrate.migrationTitle":"Datubāzu migrācija","ui.migrate.schemaTitle":"Shēmas atjauninājumi","ui.migrate.problemTitle":"Datubāzes problēmas","ui.migrate.warningTitle":"Datubāzes brīdinājumi","ui.migrate.addTable":"Pievienot tabulu {table}","ui.migrate.dropTable":"Nomest tabulu {table}","ui.migrate.addField":"Pievienot lauku {table}.{field}","ui.migrate.changeField":"Mainīt lauku {table}.{field}","ui.migrate.dropField":"Nomest lauku {table}.{field}","ui.migrate.createIndex":"Izveidot indeksu \\"{name}\\" uz {table}","ui.migrate.dropIndex":"Nomest indeksu \\"{name}\\" uz {table}","ui.widget.mandatory":"Šis lauks nedrīkst būt tukšs.","ui.widget.blankOption":"Lūdzu, izvēlieties ...","ui.widget.showPassword":"Rādīt paroli","ui.widget.hidePassword":"Slēpt paroli","ui.error.title":"HTTP pieprasījums \\"{metod} {url}\\" neizdevās.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"Serveris atbildēja ar statusa kodu {status}.","ui.error.moreLink":"Vairāk informācijas","ui.error.support":"Contao atbalsts","ui.footer.help":"Palīdzība","ui.footer.reportProblem":"Ziņot par problēmu","ui.navigation.discover":"Atklāt","ui.navigation.packages":"Pakotnes","ui.navigation.tools":"Rīki","ui.navigation.installTool":"Instalēšanas rīks","ui.navigation.backend":"Contao aizmugure","ui.navigation.debug":"Contao atkļūdošanas režīms","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP informācija","ui.navigation.phpinfoLoading":"PHP informācijas ielāde...","ui.navigation.maintenance":"Uzturēšana","ui.navigation.rebuildCache":"Pārbūvēt kešatmiņu","ui.navigation.systemCheck":"Sistēmas pārbaude","ui.navigation.advanced":"Papildu","ui.navigation.logout":"Izrakstīties","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Atrasta datubāzes problēma.","ui.maintenance.database.warning":"Atrasti datubāzes brīdinājumi.","ui.maintenance.database.button":"Pārbaudīt datubāzi","ui.maintenance.database.migrationOnly":"Pārbaudīt tikai migrācijas","ui.maintenance.database.schemaOnly":"Pārbaudīt tikai shēmu","ui.maintenance.database.installTool":"Atvērt instalēšanas rīku","ui.maintenance.database.createBackup":"Izveidot dublējumu","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Lietojumprogrammas kešatmiņa","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Ražošanas kešatmiņas pārbūve","ui.maintenance.rebuildCache.rebuildDev":"Izstrādes kešatmiņas pārbūve","ui.maintenance.rebuildCache.clearProd":"Notīrīt ražošanas kešatmiņu","ui.maintenance.rebuildCache.clearDev":"Notīrīt izstrādes kešatmiņu","ui.maintenance.installTool.title":"Contao instalēšanas rīks","ui.maintenance.installTool.description":"Contao instalēšanas rīks tiek automātiski bloķēts, ja trīs reizes pēc kārtas ievadāt nepareizu paroli.","ui.maintenance.installTool.unlock":"Atbloķēt instalēšanas rīku","ui.maintenance.installTool.lock":"Bloķēt instalēšanas rīku","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Palaist instalētāju","ui.maintenance.composerInstall.update":"Palaist Composer jauninājumu","ui.maintenance.composerCache.title":"Composer kešatmiņa","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Iztīrīt kešatmiņu","ui.maintenance.maintenanceMode.title":"Uzturēšanas režīms","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Iespējot","ui.maintenance.maintenanceMode.disable":"Atspējot","ui.maintenance.debugMode.title":"Atkļūdošanas režīms","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Aktivizēt","ui.maintenance.debugMode.deactivate":"Deaktivizēt","ui.maintenance.debugMode.credentials":"Akreditācijas dati","ui.maintenance.debugMode.user":"Lūdzu, ievadiet atkļūdošanas režīma lietotājvārdu.","ui.maintenance.debugMode.password":"Lūdzu, ievadiet paroli atkļūdošanas režīmam.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Saīsināt kešatmiņu","ui.maintenance.safeMode":"Nav pieejams drošajā režīmā","ui.maintenance.unsupported":"Neatbalsta jūsu Contao versija","ui.packages.updateButton":"Atjaunināt pakotnes","ui.packages.searchButton":"Meklēt pakotnes","ui.packages.searchPlaceholder":"Meklēt pakotnes ...","ui.packages.uploadOverlay":"Lai augšupielādētu, velciet un nometiet failus","ui.packages.uploadButton":"Augšupielādēt pakotnes","ui.packages.uploadMessage":"Jums ir viena neapstiprināta augšupielāde. | Jums ir {count} neapstiprināta/u augšupielāde/žu.","ui.packages.uploadApply":"Apstiprināt augšupielādi","ui.packages.uploadReset":"Dzēst augšupielādes","ui.packages.uploadIncomplete":"Šis datne netika augšupielādēts pilnībā. Lūdzu, noņemiet to un mēģiniet vēlreiz.","ui.packages.uploadDuplicate":"Šķiet, ka šī datne ir augšupielādēts vairākas reizes. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadInstalled":"Šis datne jau ir instalēta. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Pielietot izmaiņas","ui.packages.changesApplyAll":"Atjaunināt visas pakotnes","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Atiestatīt izmaiņas","ui.packages.changesReview":"Pārskatīt izmaiņas","ui.packagelist.loading":"Ielādē ...","ui.packagelist.uploads":"Augšupielādes","ui.packagelist.added":"Jaunas pakotnes","ui.packagelist.installed":"Instalētās pakotnes","ui.package.hintRevert":"Atgriezt izmaiņas","ui.package.hintNoupdate":"Neatjaunināt","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"Šī pakotne tiks atjaunināta, kad piemērosiet izmaiņas.","ui.package.hintAdded":"Šī pakotne tiks instalēta, kad piemērosiet izmaiņas.","ui.package.hintRemoved":"Šī pakotne tiks noņemta, kad piemērosiet izmaiņas.","ui.package.requiredTitle":"manuāli pievienots","ui.package.requiredText":"Šī pakotne ir nepieciešama jūsu composer.json, bet nav instalēta.","ui.package.removedTitle":"manuāli noņemts","ui.package.removedText":"Šī pakotne tika noņemta no jūsu composer.json.","ui.package.installed":"Pašlaik instalēts:","ui.package.version":"Versija {version}","ui.package.additionalDownloads":"{count} Lejupielāde | {count} Lejupielādes","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Rediģēt","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Jaunināt","ui.package.removeButton":"Noņemt","ui.package.installButton":"Pievienot pakotni","ui.package.installButtonShort":"Pievienot","ui.package.detailsButton":"Sīkāka informācija","ui.package.latestConstraint":"jaunākā versija","ui.package.update":"Pieejams atjauninājums","ui.package.updateLatest":"jaunākā versija","ui.package.updateAvailable":"Pieejama {versija}","ui.package.updateUnknown":"nezināma versija","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versija {version}","ui.cloudStatus.waitingTime":"Gaidīšanas laiks","ui.cloudStatus.jobs":"Pašreizējie darbi","ui.cloudStatus.workers":"Strādnieki","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nav","ui.cloudStatus.short":"apt. {minutes} min","ui.cloudStatus.long":"apt. {minutes} min {seconds} sek","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Mākoņa statuss","ui.cloudStatus.refresh":"Atjaunināt mākoņa statusu","ui.log-viewer.loading":"Ielādē ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Līmenis","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Laiks","ui.log-viewer.messageHeader":"Ziņa","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Lejupielādēt","ui.log-viewer.downloadTitle":"Lejupielādēt datni \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[721],{9721:function(a){a.exports=JSON.parse('{"ui.app.title":"Contao機能拡張","ui.app.loading":"機能拡張の一覧を読み込み中...","ui.app.language":"Contao Managerの言語を切り替え","ui.app.colorDark":"ダークモード","ui.app.colorDarkTitle":"配色をダークモードに切り替え","ui.app.colorLight":"ライトモード","ui.app.colorLightTitle":"配色をライトモードに切り替え","ui.discover.advertisement":"機能拡張のリストに広告","ui.discover.loading":"読み込み中...","ui.discover.offline":"何も結果を取得できませんでした。","ui.discover.offlineExplain":"Internet接続を確認し、ブラウザーのJavaScriptのブロッカーを無効にしてください。","ui.discover.offlineButton":"再実行","ui.discover.searchPlaceholder":"{count}の機能拡張から検索中...","ui.discover.empty":"{query}の結果はありません。","ui.discover.more":"さらに結果を表示","ui.discover.sortBy":"並べ替え","ui.discover.sortReleased":"リリース","ui.discover.sortReleasedTitle":"リリース日で並べ替え","ui.discover.sortLatest":"更新日時","ui.discover.sortLatestTitle":"更新日時で並べ替え","ui.discover.sortDownloads":"ダウンロード","ui.discover.sortDownloadsTitle":"ダウンロード数で並べ替え","ui.discover.sortFavers":"評価","ui.discover.sortFaversTitle":"評価の結果で並べ替え","ui.discover.detailsButton":"詳細","ui.discover.latestPackages":"最新と更新された機能拡張","ui.discover.faversPackages":"最上位のレートの機能拡張","ui.discover.downloadsPackages":"もっともダウンロードされた機能拡張","ui.package.homepage":"プロジェクトのウェブサイト","ui.package.private":"私的なパッケージ","ui.package.privateTitle":"私的なパッケージはベンダーからだけ(例えば、ZIPのダウンロードで)入手できます。詳細はウェブサイトを参照してください。","ui.package.abandoned":"放棄","ui.package.abandonedText":"このパッケージは放棄され、もう保守されていません。","ui.package.abandonedReplace":"このパッケージは放棄され、もう保守されていません。代わりに{replacement}パッケージの使用を作者は推奨しています。","ui.package.contaoVersion":"Contaoで利用可能","ui.package-details.previous":"以前の機能拡張の詳細","ui.package-details.close":"機能拡張の詳細を閉じる","ui.package-details.loading":"読み込み中...","ui.package-details.tabDescription":"説明","ui.package-details.tabRequire":"必須要件","ui.package-details.tabFeatures":"機能","ui.package-details.tabSuggest":"提案","ui.package-details.tabConflict":"競合","ui.package-details.tabDependents":"依存関係","ui.package-details.linkRequires":"必要","ui.package-details.linkReplaces":"置き換え","ui.package-details.linkProvides":"提供","ui.package-details.linkConflicts":"競合","ui.package-details.funding":"パッケージの保守に資金を提供!","ui.package-details.contaoVersions":"サポートしているContaoのバージョン","ui.package-details.latest":"最新版","ui.package-details.released":"リリース日","ui.package-details.license":"ライセンス","ui.package-details.authors":"次から","ui.package-details.more":"詳細","ui.package-details.packagist":"パッケージの詳細","ui.package-details.metadata":"メタデータを編集","ui.package-details.support_docs":"ドキュメント","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"サポートフォーラム","ui.package-details.support_issues":"問題 / バグ報告","ui.package-details.support_source":"ソースコード","ui.package-details.support_irc":"IRC / チャット","ui.package-details.support_email":"サポートの電子メール","ui.package-details.support_rss":"RSSフィード"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[706],{72706:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Conexión insegura !!","ui.app.httpsDescription":"Sin HTTPS, sus datos confidenciales se transferirán sin cifrar.","ui.app.httpsLink":"Mas información","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"¡Modo seguro habilitado!","ui.app.safeModeDescription":"Algunas funciones de Contao Manager no están disponibles.","ui.app.safeModeExit":"Salida del modo seguro","ui.app.loading":"Cargando Contao Manager ...","ui.app.apiError":"Estado inesperado de la API","ui.app.configSecurity1":"ALERTA DE SEGURIDAD !!! Detectado directorio de configuración desprotegido","ui.app.configSecurity2":"Contao Manager ha detectado que sus archivos de configuración son de acceso público. Todas las operaciones están deshabilitadas hasta que el directorio esté seguro; de lo contrario, un atacante podría acceder a datos confidenciales de su instalación.\\n\\nPara solucionar este problema, asegúrese de evitar el acceso al directorio \\"contao-manager\\" en su servidor. Para saber cómo hacer esto, consulte el manual de su servidor web o póngase en contacto con su proveedor de alojamiento.","ui.account.welcome":"Bienvenido","ui.account.intro1":"Bienvenido a Contao Manager, una herramienta universal para instalar y administrar Contao Open Source CMS. Si es nuevo en esto, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} para comenzar","ui.account.introManual":"lea el manual","ui.account.intro2":"Si encuentra algún problema, consulte {ourGithubIssues} y siéntase libre de crear uno nuevo para cualquier cosa que aún no se haya informado.","ui.account.introIssues":"nuestros problemas de GitHub","ui.account.headline":"Cuenta de usuario","ui.account.description":"Para administrar su instalación, cree una cuenta para Contao Manager. Tenga en cuenta que esta cuenta no está relacionada con el back end o front end de Contao.","ui.account.username":"Nombre de usuario","ui.account.password":"Contraseña","ui.account.passwordPlaceholder":"min. 8 caracteres","ui.account.passwordLength":"Por favor introduzca al menos 8 caracteres.","ui.account.submit":"Crear una cuenta","ui.account.contribute1":"Contao y Contao Manager están patrocinados por la Asociación Contao sin fines de lucro.","ui.account.contribute2":"Considere contribuir al código abierto con {donate}.","ui.account.contributeDonate":"hacer una donación","ui.login.headline":"Registrarse","ui.login.description":"Inicie sesión para administrar su instalación.","ui.login.username":"Nombre de usuario","ui.login.password":"Contraseña","ui.login.forgotPassword":"¿Ha olvidado su contraseña?","ui.login.button":"Registrarse","ui.login.locked":"Se ha denegado el acceso porque Contao Manager está bloqueado. Para desbloquear, elimine el archivo {lockFile} en su directorio raíz de Contao.","ui.logout.headline":"Timeout de la sesión","ui.logout.warning":"Ha estado inactivo por más de 25 minutos. Por razones de seguridad, su sesión finalizará en breve.","ui.logout.expired":"Su sesión finalizó automáticamente porque ha estado inactivo durante más de 30 minutos.","ui.logout.renew":"Mantener conectado","ui.logout.logout":"Cerrar sesión","ui.logout.login":"Volver para iniciar sesión","ui.oauth.error":"Intento de OAuth no válido Verifique los parámetros de solicitud.","ui.oauth.https":"El URI de redireccionamiento DEBE usar un protocolo seguro (https :) para evitar que el token de autenticación se transmita en texto sin cifrar. ","ui.oauth.headline":"Autenticación remota ","ui.oauth.description":"La siguiente aplicación o servicio está solicitando acceso remoto a su instancia del Contao Manager.","ui.oauth.domain":"Antes de permitir el acceso, asegúrese de conocer esta URL y confíe en su propietario.","ui.oauth.allow":"Permitir el acceso","ui.oauth.deny":"Acceso denegado","ui.boot.headline":"Comprobar sistema","ui.boot.description":"Por favor espere, estamos analizando su servidor ...","ui.boot.issue1":"Se han detectado problemas de instalación","ui.boot.issue2":"Su instalación tiene problemas que deben solucionarse antes de que se pueda utilizar Contao Manager.","ui.boot.run":"Lanzamiento de Contao Manager","ui.boot.safeMode":"Lanzamiento en modo seguro","ui.recovery.headline":"Recuperación del sistema","ui.recovery.description":"El Contao Manager detectó archivos que se parecen a Contao, pero la Interfaz de línea de comandos no funciona como se esperaba.","ui.recovery.console":"Salida de consola","ui.recovery.repairOptions":"Por favor, elija una opción para reparar su instalación.","ui.recovery.repairHeadline":"Reparación automática","ui.recovery.repairDescription":"Intenta reparar automáticamente la instalación reconstruyendo el caché de la aplicación y reinstalando los paquetes de Composer.","ui.recovery.repairWarning":"¡Cualquier modificación de los archivos del proveedor podría ser eliminada en el proceso!","ui.recovery.repairFailed":"La reparación automática no tuvo éxito. Pruebe el Modo seguro para reparar manualmente la instalación.","ui.recovery.repairButton":"Ejecutar la reparación del sistema","ui.recovery.safeModeHeadline":"Modo seguro","ui.recovery.safeModeDescription":"Iniciar el Contao Manager en Modo seguro permite administrar paquetes y ejecutar ciertas tareas de mantenimiento, pero las funciones que dependen de una instalación de Contao que funcione no estarán disponibles.","ui.recovery.safeModeButton":"Lanzamiento en modo seguro","ui.server.pending":"Esperando …","ui.server.running":"Analizando ...","ui.server.error":"La comprobación falló debido a una respuesta inesperada del servidor.","ui.server.details":"Detalles","ui.server.prerequisite":"Verificación cancelada debido a un prerrequisito faltante.","ui.server.selfUpdate.title":"Actualizaciones del Contao Manager","ui.server.selfUpdate.update":"Una nueva versión {latest} de Contao Manager está disponible.","ui.server.selfUpdate.manualUpdate":"Hay disponible una nueva versión {latest} de Contao Manager. Su servidor no admite actualizaciones automáticas, descargue la nueva versión de {download}.","ui.server.selfUpdate.latest":"Estás utilizando la última versión {current}.","ui.server.selfUpdate.dev":"Las compilaciones de desarrollo no admiten actualizaciones automáticas.","ui.server.selfUpdate.unsupported":"Hay una nueva versión disponible pero no es compatible con su versión de PHP.","ui.server.selfUpdate.button":"Ejecutar autoactualización","ui.server.selfUpdate.continue":"Continuar","ui.server.config.title":"Configuración del servidor","ui.server.config.setup":"Configurar","ui.server.config.change":"Cambiar","ui.server.config.save":"Guardar","ui.server.config.cancel":"Cancelar","ui.server.config.customOption":"Otros ...","ui.server.config.description":"Para ejecutar correctamente las tareas en segundo plano, Contao Manager necesita saber dónde encontrar el binario de la línea de comandos PHP y cómo ejecutar comandos separados del proceso web.","ui.server.config.formTitle":"Configuración del servidor","ui.server.config.formText":"Por favor ingrese la ruta a su binario de PHP. Asegúrese de que el binario sea la misma versión PHP que su proceso web.","ui.server.config.cloudTitle":"Compositor Resolver Cloud","ui.server.config.cloudText":"El Composer Resolver Cloud permite instalar dependencias de Composer incluso si su servidor no proporciona suficiente memoria local. Tenga en cuenta que la información de su paquete se transmitirá a un servidor en la nube operado por la Asociación Contao.","ui.server.config.cloud":"Utilice la nube Composer Resolver Cloud","ui.server.config.cli":"PHP binario","ui.server.config.stateErrorCli":"No se encontró ningún binario PHP válido en el servidor.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud no es compatible.","ui.server.config.stateSuccess":"PHP binario en {php_cli}.","ui.server.php_web.title":"Proceso web de PHP","ui.server.php_web.below7":"Versión PHP encontrada {versión}. ¡Cambie a PHP 7 lo antes posible!","ui.server.php_web.success":"Se encontró la versión PHP {versión}, no se encontraron problemas conocidos.","ui.server.php_cli.title":"Interfaz de línea de comandos de PHP","ui.server.php_cli.success":"Se encontró la versión PHP {versión}, no se encontraron problemas conocidos.","ui.server.composer.title":"Entorno Composer","ui.server.composer.success":"No se encontraron problemas conocidos.","ui.server.composer.install":"Las dependencias del Composer no están instaladas.","ui.server.composer.button":"Instalar","ui.server.contao.title":"Instalación de Contao","ui.server.contao.setup":"Configuración","ui.server.contao.check":"Consultar base de datos","ui.server.contao.empty":"No se ha encontrado una instalación de Contao.","ui.server.contao.old":"La versión de Contao {versión} no es compatible con Contao Manager, actualice su instalación manualmente.","ui.server.contao.found":"Se ha encontrado Contao {version} (API version {api}).","ui.server.contao.connectionError":"No se puede conectar con el servidor de la base de datos.","ui.server.contao.connectionProblem":"Problema de base de datos encontrado.","ui.server.contao.missingUser":"Cuenta de administrador no encontrada.","ui.setup.continue":"Continuar","ui.setup.manager":"Lanzamiento de Contao Manager","ui.setup.cancel":"Cancelar","ui.setup.welcome":"Bienvenido","ui.setup.welcome1":"Este asistente le guiará a través de los pasos necesarios para configurar su instalación de CMS de código abierto de Contao.","ui.setup.welcome2":"Si tiene alguna pregunta, busque documentación, foros, un canal de Slack y más en la página de {support}.","ui.setup.support":"soporte comunitario","ui.setup.start":"Empezar","ui.setup.complete":"¡Enhorabuena!","ui.setup.complete1":"Contao {versión} se ha instalado correctamente.","ui.setup.complete2":"Para finalizar el proceso de configuración, abra la herramienta de instalación para configurar la conexión de la base de datos y crear un usuario final.","ui.setup.complete3":"Ahora puede comenzar a crear su sitio web en el back-end de Contao. Si necesita extensiones adicionales, continúe con Contao Manager.","ui.setup.installTool":"Abra la herramienta de instalación","ui.setup.login":"Iniciar sesión en Contao","ui.setup.funding":"El software libre es \\"libre\\" como en \\"libertad de expresión\\", no como en \\"cerveza gratis\\". Un proyecto de código abierto como Contao requiere cantidades de dinero que no pueden ser recaudadas por una sola persona o empresa.\\nSi tiene un sitio web o vende sitios web creados con Contao, nos encantaría ver que contribuye financieramente al producto del que depende su negocio.","ui.setup.fundingLink":"Aprende más","ui.setup.document-root.headline":"Configuración del servidor web","ui.setup.document-root.warning":"Para instalar Contao a través de Contao Manager, debe arreglar la raíz del documento en el servidor web.","ui.setup.document-root.description1":"Contao usa una carpeta separada para los archivos públicos, los archivos de la aplicación se instalan en su carpeta principal. Contao no se puede instalar si la estructura de carpetas no es correcta o las carpetas no están vacías.","ui.setup.document-root.description2":"Si no sabe cómo configurar la raíz de su documento, lea la documentación de Contao o comuníquese con su proveedor de alojamiento.","ui.setup.document-root.documentation":"Lea la documentación","ui.setup.document-root.conflictsTitle":"El directorio de instalación no está vacío","ui.setup.document-root.conflictsDirectory":"El directorio raíz de su futura instalación de Contao no está vacío, hemos encontrado (un) archivo(s) {count} que podrían sobrescribirse durante el proceso de instalación. Se recomienda crear una estructura de directorios vacía para Contao, pero también puede eliminar los siguientes archivos y verificar nuevamente si está seguro de que no se utilizan.","ui.setup.document-root.ignoreConflicts":"Quiero instalar Contao en el directorio no vacío. Entiendo que esto podría sobrescribir cualquier archivo existente en mi espacio web.","ui.setup.document-root.check":"Revisar otra vez","ui.setup.document-root.create":"Crear directorios","ui.setup.document-root.change":"Cambiar directorios","ui.setup.document-root.formTitle":"Configuración de directorio","ui.setup.document-root.formText1":"Contao Manager puede crear automáticamente una nueva estructura de directorio en el servidor.","ui.setup.document-root.formText2":"Deberá configurar manualmente la nueva raíz del documento (por ejemplo, a través de un panel de administración de alojamiento).","ui.setup.document-root.autoconfig":"Entiendo que tengo que cambiar la configuración de mi servidor. ¡No configurar la raíz del documento romperá el Contao Manager y expondrá los archivos de configuración (incluidos los detalles de la cuenta y las contraseñas)!","ui.setup.document-root.directory":"Nuevo directorio","ui.setup.document-root.currentRoot":"Raíz del documento actual","ui.setup.document-root.newRoot":"Nueva raíz del documento","ui.setup.document-root.finish":"Configurar directorios","ui.setup.document-root.publicDir":"Use {dir} para archivos públicos (para Contao {version})","ui.setup.document-root.directoryInvalid":"Introduzca un nombre de directorio válido.","ui.setup.document-root.directoryExists":"El directorio de destino ya existe. Ingrese un nombre diferente.","ui.setup.document-root.confirmation":"Contao Manager ha creado con éxito el directorio necesario para su instalación de Contao. Ahora debe configurar la raíz del documento en su servidor web. No recargues esta página hasta entonces.","ui.setup.document-root.reload":"Recargar página","ui.setup.document-root.success":"¡La estructura de directorios en su servidor web está configurada correctamente!","ui.setup.document-root.installingProjectDir":"Los archivos de la aplicación se instalarán en {dir}.","ui.setup.document-root.installingPublicDir":"Los archivos públicos se instalarán en {dir}.","ui.setup.document-root.installedProjectDir":"Los archivos de la aplicación se instalan en {dir}.","ui.setup.document-root.installedPublicDir":"Los archivos públicos se instalan en {dir}.","ui.setup.create-project.headline":"Instalación de Contao","ui.setup.create-project.description":"El desarrollo de Contao sigue el principio de {semver}, se lanza una nueva versión secundaria cada seis meses. Las versiones admitidas actualmente son:","ui.setup.create-project.semver":"Versionado semántico","ui.setup.create-project.latestTitle":"Última","ui.setup.create-project.ltsTitle":"Soporte a largo plazo","ui.setup.create-project.latestQ1":"Nuestra última versión ofrece la mayoría de las funciones con soporte hasta febrero de {year}.","ui.setup.create-project.latestQ3":"Nuestra última versión ofrece la mayor cantidad de funciones con soporte hasta agosto del {year}.","ui.setup.create-project.ltsText":"Nuestra versión LTS actual, si te enfocas en la estabilidad. Ofrece soporte a largo plazo hasta febrero {year}.","ui.setup.create-project.pltsText":"La versión anterior de LTS todavía tiene soporte a largo plazo hasta febrero de {year}.","ui.setup.create-project.requiresPHP":"Requiere al menos PHP {version}, tiene PHP {current}.","ui.setup.create-project.requiresDocroot":"La raíz del documento debe ser \\"{folder}\\".","ui.setup.create-project.releaseplan":"Consulte el {contaoReleasePlan} para obtener información detallada.","ui.setup.create-project.releaseplanLink":"Plan de lanzamiento de Contao","ui.setup.create-project.installed":"Contao {version} se instaló correctamente en el servidor. Continúe configurando su base de datos o inicie Contao Manager para instalar una versión diferente.","ui.setup.create-project.formTitle":"Seleccione una distribución","ui.setup.create-project.formText":"Elija qué versión debe instalarse.","ui.setup.create-project.version":"Versión","ui.setup.create-project.demo":"Instale el sitio web de demostración de Contao","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.Instale el sitio web de demostración de Contao","ui.setup.create-project.coreOnly":"Instalación mínima (solo el núcleo)","ui.setup.create-project.noUpdate":"Omitir instalación (¡Solo experto!)","ui.setup.create-project.theme":"Tema Contao","ui.setup.create-project.themeInstall":"Para instalar un tema de Contao, utilice la entrada de búsqueda o cargue un archivo de tema (.cto/.zip) que admita la instalación a través de Contao Manager.","ui.setup.create-project.themeBuy":"Asegúrate de visitar la {store} oficial.","ui.setup.create-project.themeStore":"Tienda de temas Contao","ui.setup.create-project.themeUpload":"Cargar archivo de tema (.cto/.zip)","ui.setup.create-project.themeInvalid":"El archivo cargado no es un tema de Contao o no es compatible con Contao Manager.","ui.setup.create-project.themeWarning":"El Contao Manager no puede saber si este tema es compatible con su servidor. Consulte con el proveedor del tema si tiene alguna pregunta.","ui.setup.create-project.themeTitle":"Revisar los detalles del tema","ui.setup.create-project.themeDetails":"Las siguientes dependencias y archivos se instalarán con este tema.","ui.setup.create-project.themeRequire":"{count} Dependencias | {count} Dependencias","ui.setup.create-project.themeFiles":"{count} Archivo | {count} Archivos","ui.setup.create-project.theme.or":"o buscar temas públicos","ui.setup.create-project.theme.search":"Buscar temas","ui.setup.create-project.theme.more":"Más temas","ui.setup.create-project.theme.empty":"No hay temas que coincidan con {query}","ui.setup.create-project.theme.uploaded":"El archivo del tema se cargó correctamente.","ui.setup.create-project.theme.packageName":"Nombre del paquete","ui.setup.create-project.theme.version":"Versión","ui.setup.create-project.theme.authors":"Autor(es)","ui.setup.create-project.install":"Instalar","ui.setup.create-project.cancel":"Cancelar","ui.setup.database-connection.headline":"Conexión de base de datos","ui.setup.database-connection.description":"Contao requiere una base de datos MySQL (o una bifurcación compatible como MariaDB) para almacenar páginas, contenido, usuarios y otros datos relacionales. Los parámetros de conexión se almacenan en el archivo {env} en la raíz del proyecto de su instalación de Contao.","ui.setup.database-connection.formTitle":"Parámetros de conexión","ui.setup.database-connection.formText":"Ingrese una URL de base de datos o complete los campos de nombre de usuario, contraseña, servidor y base de datos por separado.","ui.setup.database-connection.url":"URL de la base de datos","ui.setup.database-connection.validUrl":"La URL de la base de datos no es válida o la conexión con el servidor falló.","ui.setup.database-connection.or":"o","ui.setup.database-connection.user":"Nombre de usuario","ui.setup.database-connection.password":"Contraseña","ui.setup.database-connection.server":"Servidor (:Port)","ui.setup.database-connection.database":"Nombre de la base de datos","ui.setup.database-connection.connected":"Conexión exitosa a la base de datos {database} en {server}.","ui.setup.database-connection.error":"Error al conectarse a la base de datos.","ui.setup.database-connection.problem":"Contao ha detectado un problema con su servidor de base de datos.","ui.setup.database-connection.schemaTitle":"Esquema de base de datos","ui.setup.database-connection.migration":"Hay una migración pendiente. | Hay {count} migraciones pendientes.","ui.setup.database-connection.schema":"Hay una actualización de esquema pendiente. | Hay {count} actualizaciones de esquema pendientes.","ui.setup.database-connection.noChanges":"El esquema de su base de datos está actualizado.","ui.setup.database-connection.check":"Consultar base de datos","ui.setup.database-connection.skip":"Saltar","ui.setup.database-connection.save":"Guardar","ui.setup.database-connection.change":"Cambiar credenciales","ui.setup.database-connection.restoreTitle":"Importar base de datos","ui.setup.database-connection.restoreText":"El tema que acaba de instalar contiene una copia de seguridad de la base de datos. Restaure la base de datos para importar datos del tema u omita este paso para comenzar con una instalación de Contao en blanco. | El tema que acaba de instalar contiene múltiples copias de seguridad de bases de datos. Seleccione un archivo de respaldo para importar datos del tema u omita este paso para comenzar con una instalación de Contao en blanco.","ui.setup.database-connection.backup":"Copia de seguridad de la base de datos actual antes de importar","ui.setup.database-connection.backupWarning":"¡Todos los datos de la base de datos se sobrescribirán al importar! Primero cree una copia de seguridad si la base de datos no está vacía.","ui.setup.database-connection.restore":"Importar base de datos de temas","ui.setup.database-connection.restoreOption":"Copia de seguridad de {date} ({size})","ui.setup.database-connection.restored":"Su base de datos de temas se importó correctamente. Continúe validando el esquema de su base de datos.","ui.setup.backend-user.success":"Se encontró una cuenta de administrador para el back-end de Contao en su base de datos. Use el back-end de Contao para agregar más usuarios.","ui.setup.backend-user.error":"No se puede recuperar la lista de usuarios. Consulte la salida de la consola para obtener más detalles.","ui.setup.backend-user.headline":"Cuenta back-end","ui.setup.backend-user.description":"Para administrar su sitio web, debe tener al menos una cuenta de administrador para el back-end de Contao. Tenga en cuenta que esta cuenta no está relacionada con Contao Manager.","ui.setup.backend-user.formTitle":"Crear una cuenta","ui.setup.backend-user.formText":"Introduzca los detalles de la nueva cuenta back-end.","ui.setup.backend-user.username":"Nombre de usuario","ui.setup.backend-user.name":"Nombre","ui.setup.backend-user.email":"Dirección de correo electrónico","ui.setup.backend-user.emailInvalid":"Por favor, introduzca una dirección de correo electrónico válida","ui.setup.backend-user.password":"Contraseña","ui.setup.backend-user.passwordPlaceholder":"min. 8 caracteres","ui.setup.backend-user.passwordLength":"Por favor introduzca al menos 8 caracteres.","ui.setup.backend-user.create":"Añadir cuenta","ui.task.headline":"Tarea de fondo","ui.task.loading":"Cargando detalles…","ui.task.created":"Cargando detalles…","ui.task.active":"Espere mientras Contao Manager ejecuta las operaciones de tareas en segundo plano.","ui.task.complete":"Todas las operaciones se completan con éxito. Consulte la salida de la consola para obtener más detalles.","ui.task.aborting":"Espere mientras se cancelan las operaciones en segundo plano.","ui.task.stopped":"Se cancelaron algunas operaciones en segundo plano. Compruebe la salida de la consola.","ui.task.error":"Una operación en segundo plano se detuvo inesperadamente. Compruebe la salida de la consola.","ui.task.failed":"¡El Contao Manager no pudo iniciar una tarea en segundo plano!","ui.task.failedDescription1":"Algo salió mal al intentar ejecutar operaciones en segundo plano.","ui.task.failedDescription2":"Si esto vuelve a suceder, es posible que su servidor no sea compatible.","ui.task.reportProblem":"Informar de un problema","ui.task.sponsor":"Composer Cloud patrocinado por {sponsor}","ui.task.buttonAudit":"Actualizar base de datos","ui.task.buttonClose":"Cerrar","ui.task.buttonConfirm":"Confirmar y cerrar","ui.task.buttonCancel":"Cancelar","ui.task.confirmCancel":"¿Está seguro de cancelar esta tarea? ¡Esto podría dejar su instalación de Contao en un estado roto!","ui.task.autoclose":"Cerrar los detalles de la tarea en caso de éxito","ui.console.toggle":"Mostrar / Ocultar salida de consola","ui.console.showLog":"Mostrar registro completo de la consola","ui.console.copyLog":"Copiar registro al portapapeles","ui.migrate.headline":"Actualizaciones de la base de datos","ui.migrate.migrationsOnly":"(solo migraciones)","ui.migrate.schemaOnly":"(solo esquema)","ui.migrate.loading":"Por favor espere, estamos revisando su base de datos...","ui.migrate.empty":"No se encontraron migraciones pendientes ni actualizaciones de esquema. Su base de datos está actualizada.","ui.migrate.emptyMigrations":"No se encontraron migraciones pendientes. Asegúrese de verificar también las actualizaciones del esquema.","ui.migrate.emptySchema":"No se encontraron actualizaciones de esquema pendientes. Asegúrese de verificar también las migraciones.","ui.migrate.pending":"Su base de datos no está actualizada. Revise la salida de la consola a continuación y ejecute los cambios.","ui.migrate.previousChanges":"No se confirmó una migración de base de datos anterior.\\nRevise el resultado de la consola a continuación, luego continúe para ver los próximos cambios.","ui.migrate.previousComplete":"No se confirmó una migración de base de datos anterior, revise el resultado de la consola a continuación.\\nNo hay más cambios pendientes.","ui.migrate.appliedChanges":"Se han aplicado actualizaciones de la base de datos.\\nRevise el resultado de la consola a continuación, luego continúe para ver los próximos cambios.","ui.migrate.appliedComplete":"Se han aplicado actualizaciones de la base de datos.\\nNo hay más migraciones pendientes ni actualizaciones de esquemas. Su base de datos está actualizada.","ui.migrate.problem":"Contao ha detectado un problema con su servidor de base de datos.\\nRevise la salida de la consola a continuación para averiguar qué debe corregirse. | Contao ha detectado problemas con su servidor de base de datos.\\nRevise la salida de la consola a continuación para averiguar qué debe corregirse.","ui.migrate.warning":"Contao ha detectado una configuración incorrecta de su servidor de base de datos.\\nLas advertencias se pueden omitir temporalmente, pero se deben corregir para lograr un rendimiento y una integridad de los datos óptimos.","ui.migrate.error":"No se pudieron aplicar los cambios. Es posible que su base de datos haya cambiado, verifique nuevamente para volver a intentarlo.","ui.migrate.execute":"Ejecutar","ui.migrate.close":"Cerrar","ui.migrate.confirm":"Confirmar y cerrar","ui.migrate.cancel":"Cancelar","ui.migrate.continue":"Continuar","ui.migrate.setup":"Configuración","ui.migrate.skip":"Saltar","ui.migrate.retry":"Revisar otra vez","ui.migrate.retryAll":"Comprobar todo","ui.migrate.withDeletes":"Ejecute todos los cambios de la base de datos, incluidas las consultas DROP.","ui.migrate.migrationTitle":"Migraciones de bases de datos","ui.migrate.schemaTitle":"Actualizaciones de esquema","ui.migrate.problemTitle":"Problemas de base de datos","ui.migrate.warningTitle":"Advertencias de la base de datos","ui.migrate.addTable":"Añadir tabla {table}","ui.migrate.dropTable":"Soltar tabla {table}","ui.migrate.addField":"Añadir campo {table}.{field}","ui.migrate.changeField":"Cambiar campo {table}.{field}","ui.migrate.dropField":"Soltar campo {table}.{field}","ui.migrate.createIndex":"Crear índice \\"{name}\\" en {table}","ui.migrate.dropIndex":"Coloque el índice \\"{name}\\" en {table}","ui.widget.mandatory":"Este campo no debe estar vacío.","ui.widget.blankOption":"Por favor seleccione","ui.widget.showPassword":"Mostrar contraseña","ui.widget.hidePassword":"Ocultar contraseña","ui.error.title":"Error en la solicitud HTTP para \\"{method} {url}\\".","ui.error.server500":"Parece que ocurrió un error inesperado en su servidor. Consulte los archivos de registro de su servidor web (Apache/Nginx) y los registros de Contao Manager en \\"contao-manager/logs\\".","ui.error.response":"El servidor devolvió una respuesta con el código de estado {status}.","ui.error.moreLink":"Más información","ui.error.support":"Soporte Contao","ui.footer.help":"Ayuda","ui.footer.reportProblem":"Informar de un problema","ui.navigation.discover":"Descubrir","ui.navigation.packages":"Paquetes","ui.navigation.tools":"Herramientas","ui.navigation.installTool":"Herramienta de instalación","ui.navigation.backend":"Backend de Contao","ui.navigation.debug":"Modo Contao Debug","ui.navigation.logViewer":"Visor de registros","ui.navigation.phpinfo":"Información PHP","ui.navigation.phpinfoLoading":"Cargando información de PHP…","ui.navigation.maintenance":"Mantenimiento","ui.navigation.rebuildCache":"Reconstruir caché","ui.navigation.systemCheck":"Comprobar sistema","ui.navigation.advanced":"Avanzado","ui.navigation.logout":"Cerrar sesión","ui.maintenance.database.title":"Migraciones y copias de seguridad de bases de datos","ui.maintenance.database.description":"Las migraciones de bases de datos garantizan esquemas de tablas y datos coherentes.","ui.maintenance.database.migrations":"Una migración de base de datos pendiente | {count} migraciones de bases de datos pendientes","ui.maintenance.database.schemaUpdates":"Una actualización de esquema pendiente | {count} actualizaciones de esquema pendientes","ui.maintenance.database.error":"Problema de base de datos encontrado.","ui.maintenance.database.warning":"Se encontraron advertencias de la base de datos.","ui.maintenance.database.button":"Consultar base de datos","ui.maintenance.database.migrationOnly":"Comprobar solo migraciones","ui.maintenance.database.schemaOnly":"Comprobar solamente esquema ","ui.maintenance.database.installTool":"Abrir herramienta de instalación","ui.maintenance.database.createBackup":"Crear copia de seguridad","ui.maintenance.database.backupUnsupported":"Las copias de seguridad de bases de datos no son compatibles con su versión de Contao.","ui.maintenance.database.backupList":"Tiene una copia de seguridad de la base de datos, creada el {fecha}. | Tiene {count} copias de seguridad de la base de datos; la última se creó el {fecha}.","ui.maintenance.database.backupEmpty":"Actualmente no tiene copias de seguridad de la base de datos.","ui.maintenance.rebuildCache.title":"Caché de la aplicación","ui.maintenance.rebuildCache.description":"Es necesario volver a generar la caché de la aplicación después de modificar cualquiera de los archivos de configuración.","ui.maintenance.rebuildCache.rebuildProd":"Reconstruir caché de producción","ui.maintenance.rebuildCache.rebuildDev":"Reconstruir caché de desarrollo","ui.maintenance.rebuildCache.clearProd":"Borrar caché de producción","ui.maintenance.rebuildCache.clearDev":"Borrar caché de desarrollo","ui.maintenance.installTool.title":"Herramienta de Instalación Contao","ui.maintenance.installTool.description":"La herramienta de instalación de Contao se bloquea automáticamente si introduce una contraseña incorrecta tres veces seguidas.","ui.maintenance.installTool.unlock":"Desbloquear herramienta de instalación","ui.maintenance.installTool.lock":"Bloquear herramienta de instalación","ui.maintenance.dumpAutoload.title":"Cargador Composer Class","ui.maintenance.dumpAutoload.description":"El autocargador Composer es responsable de la carga de la clase PHP. El autocargador debe volcarse después de agregar espacios de nombres personalizados a la raíz composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dependencias Composer","ui.maintenance.composerInstall.description":"Las dependencias de Composer se encuentran en la carpeta {vendor} en la raíz de su aplicación. Puede ser necesario reinstalar las dependencias después de la manipulación o de cargar manualmente el archivo {composerLock}.","ui.maintenance.composerInstall.button":"Ejecutar instalador","ui.maintenance.composerInstall.update":"Ejecutar actualización de Composer","ui.maintenance.composerCache.title":"Caché del Composer","ui.maintenance.composerCache.description":"El Composer almacena en el caché los paquetes descargados para un mejor rendimiento. Si tiene problemas como archivos rotos, intente eliminar el caché de Composer para forzar una nueva descarga.","ui.maintenance.composerCache.button":"Limpiar cache","ui.maintenance.maintenanceMode.title":"Modo de mantenimiento","ui.maintenance.maintenanceMode.description":"Poner a Contao en modo de mantenimiento mostrará una plantilla \\"503 Servicio no disponible\\" para el sitio web.","ui.maintenance.maintenanceMode.enable":"Habilitar","ui.maintenance.maintenanceMode.disable":"Deshabilitar","ui.maintenance.debugMode.title":"Modo Debug","ui.maintenance.debugMode.description":"Active el modo de depuración configurando un usuario y una contraseña para el punto de entrada {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Active el modo de depuración configurando la cookie de depuración para el dominio actual.","ui.maintenance.debugMode.activate":"Activar","ui.maintenance.debugMode.deactivate":"Desactivar","ui.maintenance.debugMode.credentials":"Credenciales","ui.maintenance.debugMode.user":"Introduzca un nombre de usuario para el modo Debug.","ui.maintenance.debugMode.password":"Introduzca una contraseña de usuario para el modo Debug.","ui.maintenance.opcodeCache.title":"Caché Opcode","ui.maintenance.opcodeCache.description":"Opcode guarda en caché los archivos PHP en el proceso web para una ejecución más rápida. Debe borrarse bajo ciertas circunstancias si los archivos no son reconocidos después de cambiarlos.","ui.maintenance.opcodeCache.button":"Truncar caché","ui.maintenance.safeMode":"No disponible en modo seguro","ui.maintenance.unsupported":"No es compatible con su versión de Contao","ui.packages.updateButton":"Paquetes de actualización","ui.packages.searchButton":"Buscar paquetes","ui.packages.searchPlaceholder":"Buscando paquetes ...","ui.packages.uploadOverlay":"Arrastra y suelta archivos para subir","ui.packages.uploadButton":"Subir paquetes","ui.packages.uploadMessage":"Tiene una carga sin confirmar. | Tienes {count} cargas sin confirmar.","ui.packages.uploadApply":"Confirmar subidas","ui.packages.uploadReset":"Eliminar subidas","ui.packages.uploadIncomplete":"Este archivo no se cargó por completo. Elimínelo e intente nuevamente.","ui.packages.uploadDuplicate":"Este archivo parece haberse cargado varias veces. Por favor, elimine los duplicados.","ui.packages.uploadInstalled":"Este archivo ya está instalado. Por favor, elimine los duplicados.","ui.packages.uploadUnsupported":"Las cargas no son compatibles con su instalación. Asegúrese de que la extensión PHP ZIP esté instalada y actualice sus dependencias.","ui.packages.changesMessage":"Tiene un cambio sin confirmar. | Tiene {count} cambios sin confirmar.","ui.packages.changesDryrun":"Funcionamiento en seco","ui.packages.changesApply":"Aplicar cambios","ui.packages.changesApplyAll":"Actualizar todos los paquetes ","ui.packages.changesDryrunAll":"Ejecutar en seco todos los paquetes","ui.packages.changesReset":"Restablecer cambios","ui.packages.changesReview":"Revisar cambios","ui.packagelist.loading":"Cargando ...","ui.packagelist.uploads":"Subidas","ui.packagelist.added":"Neuvos paquetes","ui.packagelist.installed":"paquetes instalados","ui.package.hintRevert":"Revertir cambios","ui.package.hintNoupdate":"No actualice","ui.package.hintConstraint":"Este paquete se instalará con restricción {constraint} al aplicar los cambios.","ui.package.hintConstraintBest":"Este paquete se instalará en la mejor versión disponible cuando aplique los cambios.","ui.package.hintConstraintChange":"La restricción para este paquete cambiará de \\"{from}\\" a \\"{to}\\" cuando aplique los cambios.","ui.package.hintConstraintUpdate":"Este paquete se actualizará cuando aplique los cambios.","ui.package.hintAdded":"Este paquete se instalará cuando aplique los cambios.","ui.package.hintRemoved":"Este paquete se eliminará cuando aplique los cambios.","ui.package.requiredTitle":"agregado manualmente","ui.package.requiredText":"Este paquete es obligatorio en su composer.json pero no está instalado.","ui.package.removedTitle":"Eliminado manualmente","ui.package.removedText":"Este paquete se eliminó de su composer.json.","ui.package.installed":"Actualmente instalado:","ui.package.version":"Versión {version}","ui.package.additionalDownloads":"{count} Descargar | {count} Descargas","ui.package.additionalStars":"{count} estrella | {count} estrellas","ui.package.editConstraint":"Editar","ui.package.uploadConstraint":"Esta restricción está definida por el paquete cargado.","ui.package.updateButton":"Actualizar","ui.package.removeButton":"Eliminar","ui.package.installButton":"Agregar paquete","ui.package.installButtonShort":"Añadir","ui.package.detailsButton":"Detalles","ui.package.latestConstraint":"Última versión","ui.package.update":"Actualización disponible ","ui.package.updateLatest":"Última versión","ui.package.updateAvailable":"{version} disponible","ui.package.updateUnknown":"versión desconocida ","ui.package.updateConstraint":"Hay disponible una versión más nueva fuera de su restricción de versión.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Compositor Resolver Cloud","ui.cloudStatus.version":"Versión {version}","ui.cloudStatus.waitingTime":"Tiempo de espera","ui.cloudStatus.jobs":"Trabajos actuales","ui.cloudStatus.workers":"Trabajadores","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"ninguno","ui.cloudStatus.short":"aprox. {minutes} min","ui.cloudStatus.long":"aprox. {minutes} min {seconds} seg","ui.cloudStatus.error":"No se puede obtener el estado del Composer Resolver Cloud. Puede haber una ventana de mantenimiento o problemas del sistema.","ui.cloudStatus.button":"Cloud-Status ","ui.cloudStatus.refresh":"Actualizar el Cloud-Status","ui.log-viewer.loading":"Cargando ...","ui.log-viewer.empty":"No hay archivos de registro en su servidor.","ui.log-viewer.reload":"Recargar","ui.log-viewer.file":"Archivo de registro","ui.log-viewer.channel":"Canal","ui.log-viewer.channelTitle":"El canal en el que se registró este mensaje.","ui.log-viewer.level":"Nivel","ui.log-viewer.levelTitle":"Gravedad del mensaje de registro.","ui.log-viewer.timeHeader":"Tiempo","ui.log-viewer.messageHeader":"Mensaje","ui.log-viewer.showContext":"Mostrar contenido","ui.log-viewer.hideContext":"Ocultar contenido","ui.log-viewer.showExtra":"Mostrar Extra","ui.log-viewer.hideExtra":"Ocultar Extra","ui.log-viewer.more":"Cargar más ...","ui.log-viewer.download":"Descargar","ui.log-viewer.downloadTitle":"Descargar archivo \\"{file}\\"","ui.log-viewer.prodEnvironment":"Entorno de producción","ui.log-viewer.devEnvironment":"Entorno de desarrollo (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[542],{87542:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao 扩展","ui.app.loading":"扩展列表加载中 …","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"加载 …","ui.discover.offline":"无法获取任何结果","ui.discover.offlineExplain":"检查网络连接并在浏览器中禁用JavaScript拦截器。","ui.discover.offlineButton":"重试","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"No results for {query}","ui.discover.more":"更多","ui.discover.sortBy":"排序","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"已更新","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"下载","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"评级","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"详情","ui.discover.latestPackages":"最新和已更新扩展","ui.discover.faversPackages":"最高评级扩展","ui.discover.downloadsPackages":"下载最多扩展","ui.package.homepage":"项目网站","ui.package.private":"私有包","ui.package.privateTitle":"私有包仅可从提供商获取 (e.g. ZIP 下载)。请访问网站获取更多信息。","ui.package.abandoned":"放弃","ui.package.abandonedText":"该程序包已放弃不再维护。","ui.package.abandonedReplace":"该程序包已放弃不再维护。作者建议使用 {replacement} 包替代.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"以前的扩展详细信息","ui.package-details.close":"关闭扩展详情","ui.package-details.loading":"加载 …","ui.package-details.tabDescription":"描述","ui.package-details.tabRequire":"需求","ui.package-details.tabFeatures":"特征","ui.package-details.tabSuggest":"建议","ui.package-details.tabConflict":"冲突","ui.package-details.tabDependents":"依赖","ui.package-details.linkRequires":"需要","ui.package-details.linkReplaces":"替换","ui.package-details.linkProvides":"提供","ui.package-details.linkConflicts":"冲突","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"最新版","ui.package-details.released":"发布于","ui.package-details.license":"许可(s)","ui.package-details.authors":"from","ui.package-details.more":"更多","ui.package-details.packagist":"包详情","ui.package-details.metadata":"编辑元数据","ui.package-details.support_docs":"文档","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"支持论坛","ui.package-details.support_issues":"问题 / 错误 报告","ui.package-details.support_source":"源代码","ui.package-details.support_irc":"IRC / 聊天","ui.package-details.support_email":"支持 E-Mail","ui.package-details.support_rss":"RSS"}')}}]);(function(){var t={24395:function(t,e,a){"use strict";a(41022),a(39600),a(60051),a(11209),a(44114),a(34782);var n,s,i,o,r,c,u,l=a(85471),d=a(75993),p=a(68261),h=a.n(p),g=a(83192),m=(a(62010),a(40173)),f={discover:{name:"discover"},packages:{name:"packages"},oauth:{name:"oauth"},maintenance:{name:"maintenance"},logViewer:{name:"logs"}},_=function(){var t=this,e=t._self._c;return e("discover-list",{attrs:{wrapper:t.wrapper,"hide-themes":""},scopedSlots:t._u([{key:"package-hint",fn:function(a){var n=a.data;return[t.contaoSupported(n.contaoConstraint)?t._e():e("p",[t._v(t._s(t.$t("ui.package.incompatible",{package:n.name,constraint:t.packageConstraint("contao/manager-bundle")})))])]}},{key:"package-actions",fn:function(a){var n=a.data;return[n&&n.private&&!t.packageSuggested(n.name)?e("a",{staticClass:"widget-button widget-button--small widget-button--primary widget-button--link",attrs:{target:"_blank",href:n.homepage}},[t._v(t._s(t.$t("ui.package.homepage")))]):e("install-button",{attrs:{small:"",inline:"",data:n}})]}}])})},v=[],b=a(78042),k=a(95353),w=(a(27495),a(5746),function(){var t=this,e=t._self._c;return e("div",{staticClass:"layout-main"},[e("header",{staticClass:"layout-main__header",class:{"layout-main__header--margin":!t.$slots.search,"layout-main__has-badge-title":t.badgeTitle}},[e("div",{staticClass:"layout-main__logo"},[e("img",{attrs:{src:a(6894),width:"40",height:"40",alt:"Contao Logo"}}),e("span",{staticClass:"layout-main__title"},[e("span",{staticClass:"layout-main__manager-title"},[t._v("Contao Manager")]),t.badgeTitle?e("span",{staticClass:"layout-main__badge-title"},[t._v(t._s(t.badgeTitle))]):t._e()])]),e("navigation-fragment")],1),t.$slots.search?e("div",{staticClass:"layout-main__subheader"},[e("div",{staticClass:"layout-main__subheader-inside"},[t.currentNews?e("div",{staticClass:"layout-main__news"},[e("a",{attrs:{href:t.currentNews.url,title:t.currentNews.title,target:"_blank",rel:"noreferrer noopener"}},[e("img",{attrs:{src:t.currentNews.image,width:"320",height:"50",alt:t.currentNews.title}})])]):t._e(),t._t("search")],2)]):t._e(),e("main",{staticClass:"layout-main__content"},[t._t("default")],2),e("footer-fragment",{attrs:{display:"main"}})],1)}),C=[],y=function(){var t=this,e=t._self._c;return e("nav",{staticClass:"navigation",attrs:{role:"navigation"}},[e("a",{staticClass:"navigation__toggle",on:{click:function(e){return e.preventDefault(),t.toggleNavigation.apply(null,arguments)}}},[e("span")]),e("ul",{staticClass:"navigation__group navigation__group--main"},[e("router-link",{staticClass:"navigation__item navigation__item--main",attrs:{tag:"li",to:t.routes.discover}},[e("a",[t._v(t._s(t.$t("ui.navigation.discover")))])]),e("router-link",{staticClass:"navigation__item navigation__item--main",attrs:{tag:"li",to:t.routes.packages}},[e("a",[t._v(t._s(t.$t("ui.navigation.packages"))),t.packageChanges>0?e("span",{staticClass:"navigation__item-badge"},[t._v(t._s(t.packageChanges))]):t._e()])]),e("router-link",{staticClass:"navigation__item navigation__item--main",attrs:{tag:"li",to:t.routes.maintenance}},[e("a",[t._v(t._s(t.$t("ui.navigation.maintenance"))),t.hasDatabaseChanges||t.hasDatabaseWarning||t.hasDatabaseError?e("span",{staticClass:"navigation__item-badge"},[t._v("1")]):t._e()])]),e("li",{staticClass:"navigation__item navigation__item--main"},[e("a",{attrs:{tabindex:"0","aria-haspopup":"true",onclick:""}},[t._v(t._s(t.$t("ui.navigation.tools")))]),e("ul",{staticClass:"navigation__group navigation__group--sub"},[t.safeMode?t._e():e("li",{staticClass:"navigation__item navigation__item--sub"},[e("a",{attrs:{href:t.backendUrl}},[t._v(t._s(t.$t("ui.navigation.backend")))])]),!t.safeMode&&t.showAppDev?e("li",{staticClass:"navigation__item navigation__item--sub"},[e("a",{attrs:{href:"/app_dev.php/",target:"_blank"}},[t._v(t._s(t.$t("ui.navigation.debug")))])]):t._e(),!t.safeMode&&t.showPreview?e("li",{staticClass:"navigation__item navigation__item--sub"},[e("a",{attrs:{href:t.previewUrl,target:"_blank"}},[t._v(t._s(t.$t("ui.navigation.debug")))])]):t._e(),!t.safeMode&&t.showInstallTool?e("li",{staticClass:"navigation__item navigation__item--sub"},[e("a",{attrs:{href:t.installToolUrl,target:"_blank"}},[t._v(t._s(t.$t("ui.navigation.installTool")))])]):t._e(),e("router-link",{staticClass:"navigation__item navigation__item--sub",attrs:{tag:"li",to:t.routes.logViewer}},[e("a",[t._v(t._s(t.$t("ui.navigation.logViewer")))])]),e("li",{staticClass:"navigation__item navigation__item--sub"},[e("a",{attrs:{href:"#"},on:{click:function(e){return e.preventDefault(),t.phpinfo.apply(null,arguments)}}},[t._v(t._s(t.$t("ui.navigation.phpinfo")))])])],1)]),e("li",{staticClass:"navigation__item navigation__item--main navigation__item--icon"},[e("a",{attrs:{tabindex:"0","aria-haspopup":"true",onclick:""}},[e("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 204.993 204.993"}},[e("path",{attrs:{d:"M113.711 202.935H92.163c-3.242 0-4.373.007-15.421-27.364l-8.532-3.468c-23.248 10.547-26 10.547-26.92 10.547h-1.779l-1.517-1.303-15.275-14.945c-2.323-2.319-3.128-3.124 8.825-30.137l-3.479-8.231C0 117.977 0 116.81 0 113.496V92.37c0-3.31 0-4.355 27.972-15.171l3.479-8.249c-12.644-26.602-11.774-27.428-9.28-29.776l16.427-16.105 2.04-.064c2.48 0 11.681 3.357 27.371 9.981l8.507-3.454C86.758 2.054 88.015 2.058 91.246 2.058h21.548c3.228 0 4.363.004 15.411 27.382l8.546 3.443c23.212-10.533 26-10.533 26.927-10.533h1.768l1.517 1.281 15.275 14.92c2.323 2.344 3.117 3.146-8.836 30.17l3.489 8.278c28.101 10.014 28.101 11.177 28.101 14.498v21.101c0 3.232 0 4.37-28.008 15.192l-3.457 8.256c12.58 26.487 11.749 27.317 9.394 29.69l-16.552 16.205-2.051.057c-2.469 0-11.649-3.361-27.317-9.992l-8.557 3.457c-10.27 27.472-11.437 27.472-14.733 27.472zm-19.308-8.722h16.996c1.95-3.976 6.166-14.516 9.541-23.595l.68-1.807 15.475-6.249 1.664.705c9.223 3.933 20.124 8.292 24.372 9.631l11.943-11.681c-1.517-4.205-6.116-14.494-10.264-23.173l-.837-1.764 6.403-15.285 1.743-.673c9.316-3.586 20.11-8.013 24.143-10.032V93.88c-4.08-1.918-14.831-6.009-24.096-9.294l-1.814-.648-6.445-15.3.769-1.725c3.965-8.947 8.375-19.501 9.788-23.753l-11.975-11.706c-3.865 1.349-14.688 5.987-23.817 10.153l-1.7.78-15.475-6.238-.691-1.721c-3.658-9.13-8.203-19.716-10.253-23.635H93.569c-1.961 3.965-6.163 14.509-9.53 23.585l-.669 1.797-15.432 6.27-1.664-.712c-9.244-3.926-20.167-8.278-24.429-9.616L29.923 43.805c1.496 4.198 6.109 14.48 10.243 23.159l.848 1.768-6.435 15.278-1.732.669c-9.301 3.582-20.077 8.006-24.111 10.017v16.431c4.08 1.925 14.82 6.027 24.079 9.326l1.8.655 6.446 15.249-.769 1.721c-3.965 8.94-8.371 19.48-9.788 23.724l12 11.742c3.854-1.36 14.663-5.998 23.803-10.168l1.711-.784 15.443 6.277.691 1.721c3.669 9.133 8.2 19.701 10.251 23.623zm8.092-56.56c-19.759 0-35.849-15.772-35.849-35.159 0-19.372 16.087-35.134 35.849-35.134 19.748 0 35.799 15.765 35.799 35.134 0 19.387-16.051 35.159-35.799 35.159zm0-61.563c-14.956 0-27.113 11.846-27.113 26.405 0 14.569 12.154 26.426 27.113 26.426 14.931 0 27.078-11.857 27.078-26.426-.004-14.559-12.147-26.405-27.078-26.405z"}})]),e("span",[t._v(t._s(t.$t("ui.navigation.advanced")))])]),e("ul",{staticClass:"navigation__group navigation__group--sub navigation__group--right"},[e("li",{staticClass:"navigation__item navigation__item--sub"},[e("a",{attrs:{href:"#"},on:{click:function(e){return e.preventDefault(),t.systemCheck.apply(null,arguments)}}},[t._v(t._s(t.$t("ui.navigation.systemCheck")))])]),e("li",{staticClass:"navigation__item navigation__item--sub"},[e("a",{attrs:{href:"#"},on:{click:function(e){return e.preventDefault(),t.logout.apply(null,arguments)}}},[t._v(t._s(t.$t("ui.navigation.logout")))])])])])],1)])},$=[],A={INIT:"init",ACCOUNT:"account",LOGIN:"login",BOOT:"boot",SETUP:"setup",RECOVERY:"recovery",MIGRATION:"migration",READY:"ready"},x={data:function(){return{routes:f,databaseChanges:0}},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)(["safeMode"])),(0,k.aH)("contao/install-tool",{showInstallTool:"isSupported"})),(0,k.aH)("contao/access-key",{showAppDev:"isEnabled"})),(0,k.aH)("contao/jwt-cookie",{showPreview:"isDebugEnabled"})),(0,k.aH)("server/contao",["contaoConfig"])),(0,k.L8)("packages",["totalChanges"])),(0,k.L8)("packages/uploads",["totalUploads"])),(0,k.L8)("server/database",{hasDatabaseChanges:"hasChanges",hasDatabaseWarning:"hasWarning",hasDatabaseError:"hasError"})),{},{packageChanges:function(t){return t.totalChanges+t.totalUploads},backendUrl:function(t){var e;return(null===(e=t.contaoConfig)||void 0===e||null===(e=e.backend)||void 0===e?void 0:e.route_prefix)||"/contao"},previewUrl:function(t){var e;return"".concat((null===(e=t.contaoConfig)||void 0===e||null===(e=e.backend)||void 0===e?void 0:e.preview_script)||"/preview.php","/")},installToolUrl:function(t){var e;return"".concat((null===(e=t.contaoConfig)||void 0===e||null===(e=e.backend)||void 0===e?void 0:e.route_prefix)||"/contao","/install")}}),methods:(0,b.A)((0,b.A)({},(0,k.i0)("auth",["logout"])),{},{toggleNavigation:function(){document.body.classList.toggle("nav-active")},phpinfo:function(){var t=window.open();t&&(t.document.open(),t.document.write('<p class="phpinfo__loading" style="display: flex; justify-content: center; align-items: center; min-height: 100vh; font: 4vmin -apple-system, system-ui, &quot;Segoe UI&quot;, Roboto, Oxygen-Sans, Ubuntu, Cantarell, &quot;Helvetica Neue&quot;, sans-serif;">'),t.document.write(this.$t("ui.navigation.phpinfoLoading")),t.document.write("</p>"),this.$store.dispatch("server/phpinfo/get").then((function(e){t.document.write(e),t.document.close(),t.document.body.removeChild(t.document.querySelector(".phpinfo__loading"))})))},systemCheck:function(){window.localStorage.removeItem("contao_manager_booted"),this.$store.commit("setView",A.BOOT)}}),mounted:function(){this.$store.dispatch("contao/install-tool/fetch"),this.$store.dispatch("contao/jwt-cookie/get").catch((function(){})),this.$store.dispatch("contao/access-key/get").catch((function(){})),this.$store.dispatch("server/database/get")}},S=x,D=a(81656),M=(0,D.A)(S,y,$,!1,null,null,null),O=M.exports,T=function(){var t=this,e=t._self._c;return e("footer",{class:"fragment-footer"+(t.display?" fragment-footer--"+t.display:"")},[t.isLogin?t._e():e("strong",{staticClass:"fragment-footer__product"},[t._v("Contao Manager 1.8.9")]),e("ul",{staticClass:"fragment-footer__links"},[e("li",[e("a",{attrs:{href:"https://docs.contao.org",target:"_blank"}},[t._v(t._s(t.$t("ui.footer.help")))])]),e("li",[e("a",{attrs:{href:"https://to.contao.org/support",target:"_blank"}},[t._v(t._s(t.$t("ui.footer.reportProblem")))])])]),e("div",{staticClass:"fragment-footer__settings"},[e("div",{staticClass:"fragment-footer__language"},[e("button",{attrs:{title:t.$t("ui.app.language")},on:{click:t.toggle}},[t._v(t._s(t.languageOptions[t.currentLanguage]))]),e("ul",{directives:[{name:"show",rawName:"v-show",value:t.visible,expression:"visible"}],ref:"menu",staticClass:"link-menu link-menu--contao link-menu--valign-top",attrs:{tabindex:"-1"},on:{blur:t.close,click:t.close}},t._l(t.languageOptions,(function(a,n){return e("li",{key:n,staticClass:"link-menu__item"},[e("a",{class:{active:n===t.currentLanguage},on:{click:function(e){return t.updateLanguage(n)},touchstart:function(t){t.stopPropagation()}}},[t._v(t._s(a))])])})),0)]),e("theme-toggle")],1)])},j=[],L=a(27952),P=a(20580),E=(a(23418),a(74423),a(26099),a(21699),a(47764),a(62953),a(64765)),B=function(){var t=this,e=t._self._c;return e("popup-overlay",{attrs:{"popup-class":t.popupClass}},[e("h1",{class:t.headlineClass},[t._v(t._s(t.$t("ui.logout.headline")))]),t.countdown>0?[e("p",{staticClass:"logout-warning__text"},[t._v(t._s(t.$t("ui.logout.warning")))]),e("p",{staticClass:"logout-warning__countdown"},[t._v(t._s(t.minutes)+":"+t._s(t.seconds))]),e("loading-button",{attrs:{color:"primary",loading:t.renew,disabled:t.logout},on:{click:t.keepAlive}},[t._v(t._s(t.$t("ui.logout.renew")))]),e("loading-button",{attrs:{loading:t.logout,disabled:t.renew},on:{click:t.doLogout}},[t._v(t._s(t.$t("ui.logout.logout")))])]:[e("p",{staticClass:"logout-warning__text"},[t._v(t._s(t.$t("ui.logout.expired")))]),e("loading-button",{on:{click:t.close}},[t._v(t._s(t.$t("ui.logout.login")))])]],2)},U=[],q=a(90425),R=a(99036),I={components:{PopupOverlay:q.A,LoadingButton:R.A},data:function(){return{renew:!1,logout:!1}},computed:(0,b.A)((0,b.A)({},(0,k.aH)("auth",["countdown"])),{},{minutes:function(){return Math.floor(this.countdown/60)},seconds:function(){var t=this.countdown%60;return t<10?"0".concat(t):t},popupClass:function(){return{"logout-warning":!0,"logout-warning--fixed":!this.$refs.popup||this.$refs.popup.clientHeight<window.innerHeight}},headlineClass:function(){return{"logout-warning__headline":!0,"logout-warning__headline--error":0===this.countdown}}}),methods:{keepAlive:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.renew=!0,e.next=3,t.$store.dispatch("auth/status");case 3:t.renew=!1;case 4:case"end":return e.stop()}}),e)})))()},doLogout:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.logout=!0,e.next=3,t.$store.dispatch("auth/logout");case 3:t.logout=!1;case 4:case"end":return e.stop()}}),e)})))()},close:function(){this.$store.commit("auth/resetCountdown")}}},H=I,V=(0,D.A)(H,B,U,!1,null,null,null),F=V.exports,z=function(){clearTimeout(n),i=Date.now()+18e5,s=1800,n=setInterval(J,1e3),o.commit("setCountdown",s),o.commit("modals/close","logout-warning",{root:!0})},N=function(){i=null,s=null,clearInterval(n),n=void 0,o.commit("setCountdown",s),o.commit("modals/close","logout-warning",{root:!0})},J=function(){s>0&&(s=Math.floor(Math.max(i-Date.now(),0)/1e3)),s<=300&&o.commit("modals/open",{id:"logout-warning",component:F,priority:255},{root:!0}),0===s&&(o.dispatch("logout"),clearInterval(n)),o.commit("setCountdown",s)},W={namespaced:!0,state:{username:null,countdown:null},mutations:{setUsername:function(t,e){t.username=e},setCountdown:function(t,e){t.countdown=e},renewCountdown:function(){o&&z()},resetCountdown:function(){o&&N()}},actions:{status:function(t){return o=t,l.Ay.http.get("api/session").then((function(e){return e.body&&e.body.username?(t.commit("setUsername",e.body.username),z()):(t.commit("setUsername",null),N()),e.status}),(function(e){return t.commit("setUsername",null),N(),403===e.status&&t.commit("setLocked",null,{root:!0}),e.status}))},login:function(t,e){var a=e.username,n=e.password;return o=t,l.Ay.http.post("api/session",{username:a,password:n}).then((function(e){return t.commit("setUsername",e.body.username),z(),!0}),(function(e){return 403===e.status&&t.commit("setLocked",null,{root:!0}),!1}))},logout:function(t){var e=t.commit;return l.Ay.http.delete("api/session").then((function(){return!0}),(function(t){return 401===t.status})).then((function(t){return t&&(e("setUsername",null),e("setView",A.LOGIN,{root:!0}),N()),t}))}}},G=a(24427),X={namespaced:!0,state:{enabled:null,status:null},getters:{isLoading:function(t){return null===t.enabled||null===t.status},isReady:function(t){return t.enabled&&null!==t.status&&!!t.status.appVersion},hasError:function(t,e){return t.enabled&&!e.isLoading&&!e.isReady}},mutations:{setEnabled:function(t,e){t.enabled=e},setStatus:function(t,e){t.status=e}},actions:{fetch:function(t){return(0,P.A)((0,L.A)().mark((function e(){var a,n,s,i,o,r,c,u;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:if(a=t.state,n=t.commit,s=t.dispatch,i=a.enabled,null!==a.enabled){e.next=14;break}return e.prev=3,e.next=6,s("server/config/get",null,{root:!0});case 6:r=e.sent,i=!(null===(o=r.cloud)||void 0===o||!o.enabled),e.next=13;break;case 10:e.prev=10,e.t0=e["catch"](3),i=!1;case 13:n("setEnabled",i);case 14:if(i){e.next=17;break}return n("setStatus",{}),e.abrupt("return");case 17:return e.prev=17,e.next=20,l.Ay.http.get("https://www.composer-resolver.cloud/",{timeout:2500,responseType:"json",headers:{"Composer-Resolver-Client":"contao"}});case 20:if(u=e.sent,null!==(c=u.body)&&void 0!==c&&c.appVersion){e.next=24;break}return n("setStatus",{}),e.abrupt("return");case 24:n("setStatus",u.body),e.next=30;break;case 27:e.prev=27,e.t1=e["catch"](17),n("setStatus",{});case 30:case"end":return e.stop()}}),e,null,[[3,10],[17,27]])})))()}}},Q={namespaced:!0,actions:{get:function(){return l.Ay.http.get("api/config/composer").then((function(t){return t.body}))},put:function(t,e){return l.Ay.http.put("api/config/composer",e).then((function(t){return t.body}))},patch:function(t,e){return l.Ay.http.patch("api/config/composer",e).then((function(t){return t.body}))},writeDefaults:function(t){var e=t.dispatch;return e("patch",{config:{"preferred-install":"dist","store-auths":!1,"optimize-autoloader":!0,"sort-packages":!0,"discard-changes":!0}}).then((function(t){return t.body}))}}},Y={namespaced:!0,modules:{composer:Q}},K=a(156),Z=(a(28706),a(2008),a(50113),a(54554),a(79432),a(16034),a(23500),a(99589)),tt=a(50950),et=a(9997),at=(a(62062),function(t){var e=Object.values(t).reduce((function(t,e){return t[e.hash]=(t[e.hash]||0)+1,t}),{});return!!Object.values(e).find((function(t){return t>1}))}),nt={namespaced:!0,state:{uploads:null,uploading:!1,files:[],confirmed:[],removing:[]},getters:{hasUploads:function(t,e){return e.totalUploads>0},isDuplicate:function(t){return function(e,a){return Object.values(t.uploads).find((function(n){var s;return n.id!==e&&(n.hash===t.uploads[e].hash||(null===(s=t.uploads[n.id])||void 0===s||null===(s=s.package)||void 0===s?void 0:s.name)===a)}))}},isRemoving:function(t){return function(e){return t.removing.includes(e)}},totalUploads:function(t,e){return t.uploads?e.unconfirmedUploads.length:0},unconfirmedUploads:function(t){return Object.values(t.uploads).filter((function(e){return!t.confirmed.includes(e.id)}))},canConfirmUploads:function(t,e,a,n){return!!t.uploads&&(void 0===Object.values(t.uploads).find((function(t){return!t.success||t.error||Object.keys(a.packages.installed).includes(t.package.name)&&a.packages.installed[t.package.name].version===t.package.version||t.package.require&&!n["packages/contaoSupported"](t.package.require["contao/core-bundle"]||t.package.require["contao/manager-bundle"])}))&&!at(t.uploads))}},mutations:{setUploads:function(t,e){t.uploads=e},setUploading:function(t,e){t.uploading=!!e},setFiles:function(t,e){t.files=e},setConfirmed:function(t,e){t.confirmed.push(e)},setUnconfirmed:function(t,e){l.Ay.delete(t.confirmed,t.confirmed.indexOf(e))},setRemoving:function(t,e){t.removing.push(e)},setRemoved:function(t,e){t.removing=t.removing.filter((function(t){return t!==e}))}},actions:{load:function(t){return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return a=t.commit,e.prev=1,e.t0=a,e.next=5,l.Ay.http.get("api/packages/uploads");case 5:e.t1=e.sent.body,(0,e.t0)("setUploads",e.t1),e.next=14;break;case 9:if(e.prev=9,e.t2=e["catch"](1),501===e.t2.status){e.next=13;break}throw e.t2;case 13:a("setUploads",!1);case 14:case"end":return e.stop()}}),e,null,[[1,9]])})))()},confirm:function(t,e){var a=this;return(0,P.A)((0,L.A)().mark((function n(){var s,i,o;return(0,L.A)().wrap((function(n){while(1)switch(n.prev=n.next){case 0:if(s=t.state,i=t.commit,o=s.uploads[e].package,o){n.next=4;break}return n.abrupt("return");case 4:if(a.getters["packages/packageInstalled"](o.name)?a.commit("packages/change",o):a.commit("packages/add",Object.assign({},o,{constraint:o.version})),!o.suggest){n.next=8;break}return n.next=8,Promise.all(Object.keys(o.suggest).map(function(){var t=(0,P.A)((0,L.A)().mark((function t(e){var n;return(0,L.A)().wrap((function(t){while(1)switch(t.prev=t.next){case 0:if(a.getters["packages/packageInstalled"](e)){t.next=5;break}return t.next=3,a.dispatch("packages/metadata",{name:e});case 3:n=t.sent,n.contaoConstraint&&!a.getters["packages/contaoSupported"](n.contaoConstraint)||a.commit("packages/add",{name:e});case 5:case"end":return t.stop()}}),t)})));return function(e){return t.apply(this,arguments)}}()));case 8:i("setConfirmed",e);case 9:case"end":return n.stop()}}),n)})))()},confirmAll:function(t){var e=t.state,a=t.dispatch;Object.keys(e.uploads).forEach((function(t){return a("confirm",t)}))},unconfirm:function(t,e){var a=this,n=t.state,s=t.commit,i=n.confirmed.includes(e)?e:Object.keys(n.uploads).find((function(t){return n.uploads[t].package&&n.uploads[t].package.name===e&&n.confirmed.includes(t)}));if(i){s("setUnconfirmed",i);var o=n.uploads[i].package;o&&o.suggest&&Object.keys(o.suggest).forEach((function(t){a.getters["packages/packageAdded"](t)&&a.commit("packages/restore",t)}))}},unconfirmAll:function(t){var e=t.state,a=t.dispatch;Object.keys(e.uploads).forEach((function(t){return a("unconfirm",t)}))},remove:function(t,e){return(0,P.A)((0,L.A)().mark((function a(){var n,s;return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:return n=t.commit,s=t.dispatch,n("setRemoving",e),a.next=4,l.Ay.http.delete("api/packages/uploads/".concat(e));case 4:return a.next=6,s("load");case 6:return n("setRemoved",e),a.next=9,s("unconfirm",e);case 9:case"end":return a.stop()}}),a)})))()},removeAll:function(t){return(0,P.A)((0,L.A)().mark((function e(){var a,n,s;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return a=t.state,n=t.commit,s=t.dispatch,e.next=3,Promise.all(Object.keys(a.uploads).map(function(){var t=(0,P.A)((0,L.A)().mark((function t(e){return(0,L.A)().wrap((function(t){while(1)switch(t.prev=t.next){case 0:if(a.confirmed.includes(e)){t.next=5;break}return n("setRemoving",e),t.next=4,l.Ay.http.delete("api/packages/uploads/".concat(e));case 4:n("setRemoved",e);case 5:case"end":return t.stop()}}),t)})));return function(e){return t.apply(this,arguments)}}()));case 3:return e.next=5,s("load");case 5:case"end":return e.stop()}}),e)})))()}}},st=["contao/core-bundle","contao/installation-bundle","contao/conflicts"],it=function(t){return t.includes("/")&&!st.includes(t)},ot=function(t,e){return it(t)&&!e.packageFeature(t)},rt={namespaced:!0,modules:{details:tt.A,uploads:nt},state:{root:null,local:null,installed:null,required:{},add:{},change:{},update:[],remove:[]},getters:{hasRoot:function(t){return!!t.root},packageInstalled:function(t,e){return function(a){return Object.keys(t.installed).includes(a)&&!e.packageMissing(a)}},versionInstalled:function(t){return function(e,a){return Object.keys(t.installed).includes(e)&&t.installed[e].version===a}},packageRoot:function(t){return function(e){return!!t.root&&Object.keys(t.root.require).includes(e)}},packageRequired:function(t){return function(e){return Object.keys(t.required).includes(e)&&!!t.required[e].constraint}},packageMissing:function(t){return function(e){return Object.keys(t.required).includes(e)&&!t.required[e].constraint}},packageAdded:function(t){return function(e){return Object.keys(t.add).includes(e)}},packageChanged:function(t){return function(e){return Object.keys(t.change).includes(e)}},packageUpdated:function(t){return function(e){return t.update.includes(e)}},packageRemoved:function(t){return function(e){return t.remove.includes(e)}},packageFeatures:function(){return function(t){return et.A[t]?et.A[t]:[]}},packageFeature:function(t,e){return function(t){return!!Object.keys(et.A).find((function(a){return et.A[a].includes(t)&&(e.packageInstalled(a)||e.packageRequired(a))}))}},packageVisible:function(t,e){return function(t){return ot(t,e)}},packageSuggested:function(t){return function(e){return!!Object.values(t.local||{}).concat(Object.values(t.add||{})).find((function(t){return t.type&&("contao-"===t.type.substr(0,7)||"contao/"===t.name.substr(0,7))&&t.suggest&&Object.prototype.hasOwnProperty.call(t.suggest,e)}))}},totalChanges:function(t){return Object.keys(t.add).filter(it).length+Object.keys(t.required).filter(it).length+Object.keys(t.change).filter(it).length+t.update.length+t.remove.length-Object.values(t.add).filter((function(e){return Object.keys(t.required).includes(e.name)})).length-Object.values(t.change).filter((function(e){return Object.keys(t.required).includes(e.name)})).length-t.remove.filter((function(e){return Object.keys(t.required).includes(e)})).length},totalRequired:function(t){return Object.keys(t.required).length-Object.values(t.add).filter((function(e){return Object.keys(t.required).includes(e.name)})).length-Object.values(t.change).filter((function(e){return Object.keys(t.required).includes(e.name)})).length-t.remove.filter((function(e){return Object.keys(t.required).includes(e)})).length},canResetChanges:function(t,e){return e.totalChanges>e.totalRequired},visibleRequired:function(t,e){return Object.values(t.required).filter((function(t){return ot(t.name,e)}))},visibleInstalled:function(t,e){return Object.values(e.installed).filter((function(t){return ot(t.name,e)}))},visibleAdded:function(t,e){return Object.values(t.add).filter((function(t){return ot(t.name,e)}))},installed:function(t){if(!t.root||!t.installed)return{};var e={};return Object.keys(t.root.require).forEach((function(a){a.includes("/")&&t.installed[a]&&(e[a]={name:a,version:!1,constraint:t.root.require[a]},e[a]=Object.assign(e[a],t.installed[a]))})),e},packageConstraint:function(t,e){return function(t){return e.packageConstraintAdded(t)||e.packageConstraintChanged(t)||e.packageConstraintInstalled(t)||e.packageConstraintRequired(t)}},packageConstraintAdded:function(t,e){return function(a){return e.packageAdded(a)?t.add[a].constraint:null}},packageConstraintChanged:function(t,e){return function(a){return e.packageChanged(a)?t.change[a]:null}},packageConstraintInstalled:function(t,e){return function(t){return e.packageInstalled(t)&&e.packageRoot(t)?e.installed[t].constraint:null}},packageConstraintRequired:function(t,e){return function(a){return e.packageRequired(a)?e.packageChanged(a)?e.constraintChanged(a):t.required[a].constraint:null}},contaoSupported:function(t,e){return function(t){return!t||(0,Z.intersects)(t,e.packageConstraint("contao/manager-bundle"),!0)}}},mutations:{setInstalled:function(t,e){var a=e.root,n=e.local,s=e.missing,i={},o={};n&&Object.keys(n).forEach((function(t){!1===n[t].version?o[t]=n[t]:i[t]=n[t]})),a&&Object.keys(a.require).forEach((function(t){t.includes("/")&&(Object.prototype.hasOwnProperty.call(i,t)||Object.prototype.hasOwnProperty.call(o,t)||(o[t]={name:t,constraint:a.require[t]}))})),s&&s.forEach((function(t){o[t]={name:t,constraint:null}})),t.root=a,t.local=n,t.installed=i,t.required=o},clearInstalled:function(t){t.root=null,t.local=null,t.installed=null,t.required={}},add:function(t,e){l.Ay.set(t.add,e.name,e)},change:function(t,e){var a=e.name,n=e.version;this.commit("packages/restore",a),l.Ay.set(t.change,a,n)},update:function(t,e){this.commit("packages/restore",e),t.update.push(e)},remove:function(t,e){this.commit("packages/restore",e),t.remove.push(e)},restore:function(t,e){l.Ay.delete(t.add,e),l.Ay.delete(t.change,e),t.remove.includes(e)&&t.remove.splice(t.remove.indexOf(e),1),t.update.includes(e)&&t.update.splice(t.update.indexOf(e),1)},reset:function(t){t.add={},t.change={},t.update=[],t.remove=[]}},actions:{metadata:function(t,e){return(0,P.A)((0,L.A)().mark((function a(){var n,s,i,o,r,c,u,l,d,p;return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:if(s=t.state,i=t.dispatch,o=e.name,!e||e.source||!e.extra||!e.extra["contao-metadata-url"]){a.next=4;break}return a.abrupt("return",e);case 4:return a.next=6,i("algolia/getPackage",o,{root:!0});case 6:if(r=a.sent,r){a.next=9;break}return a.abrupt("return",e);case 9:return c=function(t){return t.version&&(0,Z.valid)(t.version)?(0,Z.parse)(t.version):t.version_normalized?(0,Z.coerce)(t.version_normalized,{loose:!0}):null},u=s.change[o]||(null===(n=s.root)||void 0===n?void 0:n.require[o]),l=s.installed?c(e):null,r.update=null,r.versions&&u&&"dev-"!==u.substr(0,4)&&"-dev"!==u.substr(-4)&&(r.update={valid:!0,latest:!0,version:null,time:null},u&&l&&(d=r.versions.filter((function(t){return t.version===l.version||(0,Z.satisfies)(c(t),u)})).pop(),d?(r.update.version=d.version,r.update.time=d.time,r.update.latest=(0,Z.eq)(c(d),l),r.latest&&r.latest.version&&(r.latest.active=(0,Z.eq)(c(d),r.latest.version))):r.update.valid=!1)),p=Object.assign({},r,{dependents:e.dependents||r.dependents,conflict:e.conflict||r.conflict,require:e.require||r.require,"require-dev":e["require-dev"]||r["require-dev"],suggest:r.suggest}),e.suggest&&(p.suggest={},Object.keys(e.suggest).forEach((function(t){p.suggest[t]=r.suggest&&r.suggest[t]||e.suggest[t]}))),a.abrupt("return",p);case 17:case"end":return a.stop()}}),a)})))()},load:function(t){return(0,P.A)((0,L.A)().mark((function e(){var a,n,s;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return a=t.commit,a("clearInstalled"),a("reset"),a("algolia/reset",null,{root:!0}),n={},s=[l.Ay.http.get("api/packages/root"),l.Ay.http.get("api/packages/local"),l.Ay.http.get("api/packages/missing")],e.t0=a,e.next=9,s[0];case 9:return e.t1=e.sent.body,e.next=12,s[1];case 12:return e.t2=e.sent.body,e.next=15,s[2];case 15:return e.t3=e.sent.body,e.t4={root:e.t1,local:e.t2,missing:e.t3},(0,e.t0)("setInstalled",e.t4),e.abrupt("return",n);case 19:case"end":return e.stop()}}),e)})))()},apply:function(t){var e=t.state,a=t.dispatch,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{dry_run:!1,update_all:!1},s=e.change,i=e.remove,o=e.update.concat(Object.keys(e.required),Object.keys(e.change).filter((function(t){return!Object.keys(e.required).includes(t)})),e.remove.filter((function(t){return!Object.keys(e.required).includes(t)})));Object.keys(e.add).forEach((function(t){s[e.add[t].name]=e.add[t].constraint||null,o.push(e.add[t].name)})),Object.keys(et.A).forEach((function(t){et.A[t].forEach((function(a){var n;if(e.root&&Object.keys(e.root.require).includes(a)||e.installed&&Object.keys(e.installed).includes(a))return o.includes(t)&&o.push(a),void(s[t]?s[a]=s[t]:i.includes(t)&&i.push(a));Object.prototype.hasOwnProperty.call(s,a)&&(o.includes(a)||o.push(a),!Object.prototype.hasOwnProperty.call(s,t)&&null!==(n=e.root)&&void 0!==n&&n.require[t]?s[a]=e.root.require[t]:Object.prototype.hasOwnProperty.call(s,t)&&(s[a]=s[t]))}))}));var r={require:s,remove:i,uploads:!0,dry_run:!!n.dry_run};n.update_all||(r.update=o);var c={name:"composer/update",config:r};return a("tasks/execute",c,{root:!0})},updateAll:function(t){var e=t.state,a=t.getters,n=t.commit;Object.keys(e.root.require).forEach((function(t){ot(t,a)&&n("update",t)}))}}},ct=function(t,e){var a=e.commit;return new Promise((function(e,n){t.then((function(t){a("setCache",t.body["access-key"]),a("setIsEnabled",""!==t.body["access-key"]),e(t.body["access-key"])}),(function(){a("setIsEnabled",!1),n()}))}))},ut={namespaced:!0,state:{cache:null,isEnabled:null},mutations:{setCache:function(t,e){t.cache=e},setIsEnabled:function(t,e){t.isEnabled=e}},actions:{get:function(t){var e,a=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return a&&t.state.cache?Promise.resolve(t.state.cache):t.rootState.safeMode||t.rootState.server.contao.contaoApi.version<1||null===(e=t.rootState.server.contao.contaoApi.features)||void 0===e||null===(e=e["contao/manager-bundle"])||void 0===e||null===(e=e["dot-env"])||void 0===e||!e.includes("APP_DEV_ACCESSKEY")?Promise.reject():ct(l.Ay.http.get("api/contao/access-key"),t)},set:function(t,e){return ct(l.Ay.http.put("api/contao/access-key",e),t)},delete:function(t){return ct(l.Ay.http.delete("api/contao/access-key"),t)}}},lt={namespaced:!0,state:{cache:null,isSupported:null,isLocked:null},mutations:{setCache:function(t,e){t.cache=e,t.isSupported=!e&&null,t.isLocked=null,e&&200===e.status&&(t.isSupported=!0,t.isLocked=!0===e.body.locked)}},actions:{fetch:function(t){var e=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(e&&t.state.cache)return Promise.resolve(t.state.cache);if(t.rootState.safeMode)return t.commit("setCache"),Promise.resolve();var a=function(e){return t.commit("setCache",e),Promise.resolve(e)};return l.Ay.http.get("api/contao/install-tool/lock").then(a,a)},lock:function(t){var e=function(e){return t.commit("setCache",e),Promise.resolve(e)};return l.Ay.http.put("api/contao/install-tool/lock").then(e,e)},unlock:function(t){var e=function(e){return t.commit("setCache",e),Promise.resolve(e)};return l.Ay.http.delete("api/contao/install-tool/lock").then(e,e)}}},dt=function(t,e){var a=e.commit;return new Promise((function(e,n){t.then((function(t){a("setCache",t.body),a("setIsDebugEnabled",204!==t.status&&t.data.debug),e(t.body)}),(function(){a("setIsDebugEnabled",!1),n()}))}))},pt={namespaced:!0,state:{cache:null,isDebugEnabled:null},mutations:{setCache:function(t,e){t.cache=e},setIsDebugEnabled:function(t,e){t.isDebugEnabled=e}},actions:{get:function(t){var e,a=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return a&&t.state.cache?Promise.resolve(t.state.cache):t.rootState.safeMode||t.rootState.server.contao.contaoApi.version<2||null===(e=t.rootState.server.contao.contaoApi.features)||void 0===e||null===(e=e["contao/manager-bundle"])||void 0===e||null===(e=e["jwt-cookie"])||void 0===e||!e.includes("debug")?Promise.reject():dt(l.Ay.http.get("api/contao/jwt-cookie"),t)},enableDebug:function(t){return dt(l.Ay.http.put("api/contao/jwt-cookie",{debug:!0}),t)},disableDebug:function(t){return dt(l.Ay.http.put("api/contao/jwt-cookie",{debug:!1}),t)},delete:function(t){return dt(l.Ay.http.delete("api/contao/jwt-cookie"),t)}}},ht=function(t,e){var a=e.commit;return new Promise((function(e,n){t.then((function(t){a("setCache",t.body["enabled"]),a("setIsEnabled",!0===t.body["enabled"]),e(t.body["enabled"])}),(function(){a("setIsEnabled",!1),n()}))}))},gt={namespaced:!0,state:{cache:null,isEnabled:null},mutations:{setCache:function(t,e){t.cache=e},setIsEnabled:function(t,e){t.isEnabled=e}},actions:{isEnabled:function(t){var e=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return e&&t.state.cache?Promise.resolve(t.state.cache):t.rootState.safeMode?Promise.reject():ht(l.Ay.http.get("api/contao/maintenance-mode"),t)},enable:function(t){return ht(l.Ay.http.put("api/contao/maintenance-mode"),t)},disable:function(t){return ht(l.Ay.http.delete("api/contao/maintenance-mode"),t)}}},mt={namespaced:!0,state:{cache:null,loading:!1,supported:!1,files:[],restore:!1,restored:!1},getters:{hasBackups:function(t){return t.supported&&t.files&&t.files.length>0}},mutations:{setLoading:function(t,e){t.loading=!!e},setCache:function(t,e){t.cache=e,t.loading=!1,t.supported=!e&&null,t.files=[],e&&200===e.status&&(t.supported=!0,t.files=e.data)},setRestore:function(t,e){t.restore=e},setRestored:function(t){t.restored=!0}},actions:{fetch:function(t){var e=t.state,a=t.commit,n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(n&&e.cache)return new Promise((function(t){t(e.cache)}));var s=function(t){return a("setCache",t),t};return a("setLoading",!0),l.Ay.http.get("api/contao/backup").then(s,s)}}},ft={namespaced:!0,modules:{"access-key":ut,backup:mt,"install-tool":lt,"jwt-cookie":pt,"maintenance-mode":gt},state:{package:null,version:null},mutations:{installTheme:function(t,e){var a=e.package,n=e.version;t.package=a,t.version=n}},actions:{install:function(t,e){var a=t.dispatch,n={name:"contao/install",config:e};return a("config/composer/writeDefaults",null,{root:!0}).then((function(){return a("tasks/execute",n,{root:!0})}))}}},_t={namespaced:!0,state:{cache:null},mutations:{setCache:function(t,e){t.cache=e}},actions:{get:function(t){var e=t.state,a=t.commit,n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return n&&e.cache?new Promise((function(t){t(e.cache)})):l.Ay.http.get("api/server/composer").then((function(t){return t.body})).then((function(t){return a("setCache",t),t}))}}},vt={namespaced:!0,state:{cache:null},mutations:{setCache:function(t,e){t.cache=e}},actions:{get:function(t){var e=arguments;return(0,P.A)((0,L.A)().mark((function a(){var n,s,i,o;return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:if(n=t.state,s=t.commit,i=!(e.length>1&&void 0!==e[1])||e[1],!i||!n.cache){a.next=4;break}return a.abrupt("return",n.cache);case 4:return a.next=6,l.Ay.http.get("api/server/config");case 6:return o=a.sent.body,s("setCache",o),a.abrupt("return",o);case 9:case"end":return a.stop()}}),a)})))()},set:function(t,e){return(0,P.A)((0,L.A)().mark((function a(){var n,s;return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:return n=t.commit,a.next=3,l.Ay.http.put("api/server/config",e);case 3:return s=a.sent.body,n("setCache",s),a.abrupt("return",s);case 6:case"end":return a.stop()}}),a)})))()}}},bt={namespaced:!0,state:{cache:null,contaoVersion:null,contaoApi:null,contaoConfig:null},getters:{badgeTitle:function(t){var e;return null===(e=t.contaoConfig)||void 0===e||null===(e=e.backend)||void 0===e?void 0:e.badge_title}},mutations:{setCache:function(t,e){t.cache=e,t.contaoVersion=null,t.contaoApi=null,t.contaoConfig=null,e&&(t.contaoVersion=e.body.version,t.contaoApi=e.body.api,t.contaoConfig=e.body.config)}},actions:{get:function(t){var e=t.state,a=t.commit,n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(n&&e.cache)return new Promise((function(t){t(e.cache)}));var s=function(t){return a("setCache",t),t};return l.Ay.http.get("api/server/contao").then(s,s)},documentRoot:function(t,e){var a=e.directory,n=e.usePublicDir,s=void 0!==n&&n,i={usePublicDir:s};return a&&(i.directory=a),l.Ay.http.post("api/server/contao",i).catch((function(t){return t}))}}},kt={namespaced:!0,state:{cache:null,loading:!1,supported:null,status:null,pattern:null,url:null},getters:{totalMigrations:function(t){return t.status&&"migration"===t.status.type?t.status.total:0},totalSchemaUpdates:function(t){return t.status&&"schema"===t.status.type?t.status.total:0},hasError:function(t){return!!t.status&&("error"===t.status.type||"problem"===t.status.type)},hasWarning:function(t){return!!t.status&&t.status.warnings>0},hasChanges:function(t,e){return!!e.totalMigrations||!!e.totalSchemaUpdates},totalChanges:function(t,e){return e.totalMigrations+e.totalSchemaUpdates},accessProblem:function(t){return!!t.status&&"error"===t.status.type&&t.status.message.toLowerCase().includes("access denied")}},mutations:{setLoading:function(t,e){t.loading=!!e},setCache:function(t,e){t.cache=e,t.loading=!1,t.supported=!e&&null,t.status=null,t.url=null,e&&200===e.status&&(t.supported=!0,t.status=e.body.status,t.pattern=e.body.pattern,t.url=e.body.url)}},actions:{get:function(t){var e=t.state,a=t.commit,n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(n&&e.cache)return new Promise((function(t){t(e.cache)}));var s=function(t){return a("setCache",t),t};return a("setLoading",!0),l.Ay.http.get("api/server/database").then(s,s)},set:function(t,e){var a=t.commit,n=function(t){return a("setCache",t),t};return a("setLoading",!0),l.Ay.http.post("api/server/database",{url:e}).then(n,n)}}},wt={namespaced:!0,state:{cache:null,supported:!1,hasUser:null},mutations:{setCache:function(t,e){t.cache=e,t.supported=!1,t.hasUser=null,!e||200!==e.status&&201!==e.status||(t.supported=!0,t.hasUser=!!e.body.hasUser)}},actions:{get:function(t){var e=t.state,a=t.commit,n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(n&&e.cache)return new Promise((function(t){t(e.cache)}));var s=function(t){return a("setCache",t),t};return l.Ay.http.get("api/server/admin-user").then(s,s)},set:function(t,e){var a=t.commit,n=function(t){return a("setCache",t),t};return l.Ay.http.post("api/server/admin-user",e).then(n,n)}}},Ct={namespaced:!0,state:{cache:null},mutations:{setCache:function(t,e){t.cache=e}},actions:{get:function(t){var e=t.state,a=t.commit,n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return n&&e.cache?new Promise((function(t){t(e.cache)})):l.Ay.http.get("api/server/opcache").then((function(t){return t.body})).then((function(t){return a("setCache",t),t}))},delete:function(t,e){var a=t.commit;return l.Ay.http.delete("api/server/opcache?opcache_reset=".concat(e)).then((function(t){return t.body})).then((function(t){return a("setCache",t),t}))}}},yt={namespaced:!0,state:{cache:null},mutations:{setCache:function(t,e){t.cache=e}},actions:{get:function(t){var e=t.state,a=t.commit,n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return n&&e.cache?new Promise((function(t){t(e.cache)})):l.Ay.http.get("api/server/php-cli").then((function(t){return t.body})).then((function(t){return a("setCache",t),t}))}}},$t={namespaced:!0,state:{cache:null},mutations:{setCache:function(t,e){t.cache=e}},actions:{get:function(t){var e=arguments;return(0,P.A)((0,L.A)().mark((function a(){var n,s,i,o;return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:if(n=t.state,s=t.commit,i=!(e.length>1&&void 0!==e[1])||e[1],!i||!n.cache){a.next=4;break}return a.abrupt("return",n.cache);case 4:return a.next=6,l.Ay.http.get("api/server/phpinfo");case 6:return o=a.sent.bodyText,s("setCache",o),a.abrupt("return",o);case 9:case"end":return a.stop()}}),a)})))()}}},At={namespaced:!0,state:{cache:null,phpVersion:null,phpVersionId:null},mutations:{setCache:function(t,e){t.cache=e,t.phpVersion=null,t.phpVersionId=null,e&&200===e.status&&(t.phpVersion=e.body.version,t.phpVersionId=e.body.version_id)}},actions:{get:function(t){var e=t.state,a=t.commit,n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(n&&e.cache)return new Promise((function(t){t(e.cache)}));var s=function(t){return a("setCache",t),Promise.resolve(t)};return l.Ay.http.get("api/server/php-web").then(s,s)}}},xt={namespaced:!0,state:{cache:null},mutations:{setCache:function(t,e){t.cache=e}},actions:{get:function(t){var e=t.state,a=t.commit,n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return n&&e.cache?new Promise((function(t){t(e.cache)})):l.Ay.http.get("api/server/self-update").then((function(t){return t.body}),(function(t){if(501===t.status)return{current_version:null,latest_version:null,channel:"dev",supported:!1,error:null};throw t})).then((function(t){return a("setCache",t),t}))},latest:function(){return(0,P.A)((0,L.A)().mark((function t(){var e;return(0,L.A)().wrap((function(t){while(1)switch(t.prev=t.next){case 0:return t.next=2,l.Ay.http.get("https://download.contao.org/contao-manager/stable/contao-manager.version");case 2:return e=t.sent,t.abrupt("return",e.body.version);case 4:case"end":return t.stop()}}),t)})))()}}},St={namespaced:!0,modules:{composer:_t,config:vt,contao:bt,database:kt,adminUser:wt,opcache:Ct,phpinfo:$t,"php-cli":yt,"php-web":At,"self-update":xt}},Dt=0,Mt=!1,Ot=function(t,e,a){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:5e3,s=arguments.length>4&&void 0!==arguments[4]?arguments[4]:1;setTimeout((function(){l.Ay.http.get("api/task",{timeout:5e3*s}).then((function(n){return r(n,t,e,a)}),(function(n){return c(n,t,e,a)}))}),n)};r=function(t,e,a,n){if(Dt=0,204!==t.status){if(!(t.body instanceof Object))return Mt||e.commit("apiError",t,{root:!0}),void n();var s=t.body;switch(e.commit("setCurrent",s),s.status){case"active":case"aborting":Ot(e,a,n);break;case"terminated":case"complete":s.autoclose&&"1"===window.localStorage.getItem("contao_manager_autoclose")&&e.dispatch("deleteCurrent"),a(s);break;case"stopped":case"error":n(s);break;default:n(s);break}}else a()},c=function(t,e,a,n){0===t.status&&(Dt+=1,Dt<=5)?Ot(e,a,n,5e3,Dt+1):(Mt||e.commit("setStatus","failed"),n())};var Tt={namespaced:!0,state:{status:null,current:null,deleting:!1,initialized:!1},mutations:{setStatus:function(t,e){t.status=e},setCurrent:function(t,e){t.deleting=!1,t.current=e,t.status=e?e.status:null},setDeleting:function(t,e){t.deleting=!!e},setInitialized:function(t,e){t.initialized=!!e,e||(u=null)}},actions:{init:function(t){return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return u||(u=new Promise((function(e){var a=function(){t.commit("setInitialized",!0),e()};Ot(t,a,a)}))),e.abrupt("return",u);case 2:case"end":return e.stop()}}),e)})))()},execute:function(t,e){return new Promise((function(a,n){null!==t.state.status&&n(),Mt=!!e.ignoreErrors,delete e.ignoreErrors,Mt&&l.Ay.http.interceptors.unshift((function(t,e){e((function(e){if("api/"===t.url.substring(0,4)&&"application/json"!==e.headers.get("Content-Type")&&e.status>=400&&e.status<=599)throw e.data}))})),t.commit("setCurrent",e),t.commit("setStatus","created"),l.Ay.http.put("api/task",e).then((function(e){return r(e,t,a,n)}),(function(e){return c(e,t,a,n)}))}))},abort:function(t){return null===t.state.status?new Promise((function(t,e){e()})):(t.commit("setStatus","aborting"),new Promise((function(e,a){l.Ay.http.patch("api/task",{status:"aborting"}).then((function(n){return r(n,t,e,a)}),(function(n){return c(n,t,e,a)}))})))},deleteCurrent:function(t){var e=arguments;return(0,P.A)((0,L.A)().mark((function a(){var n,s,i;return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:return n=t.commit,s=t.dispatch,i=e.length>1&&void 0!==e[1]?e[1]:2,n("setDeleting",!0),a.prev=3,a.next=6,l.Ay.http.delete("api/task");case 6:return n("setCurrent",null),a.next=9,s("server/contao/get",!1,{root:!0});case 9:a.next=20;break;case 11:if(a.prev=11,a.t0=a["catch"](3),400!==a.t0.status){a.next=16;break}return n("setCurrent",null),a.abrupt("return");case 16:if(!(403===a.t0.status&&i>0)){a.next=18;break}return a.abrupt("return",new Promise((function(t){setTimeout((function(){t(s("deleteCurrent",i-1))}),5e3)})));case 18:throw"application/problem+json"===a.t0.headers.get("Content-Type")?n("setError",a.t0.data,{root:!0}):n("setError",{type:"about:blank",status:a.t0.status,response:a.t0},{root:!0}),a.t0;case 20:case"end":return a.stop()}}),a,null,[[3,11]])})))()}}};l.Ay.use(k.Ay);var jt=new k.Ay.Store({modules:{auth:W,algolia:G.A,cloud:X,config:Y,modals:K.A,packages:rt,contao:ft,server:St,tasks:Tt},state:{view:A.INIT,setupStep:0,migrationsType:"",error:null,locked:!1,safeMode:!1},mutations:{setView:function(t,e){t.view=e,e===A.READY&&(t.setupStep=0)},setLocked:function(t){t.view=A.LOGIN,t.locked=!0},setError:function(t,e){t.error||(t.error=e)},setSafeMode:function(t,e){t.safeMode=!!e},setup:function(t,e){t.view=A.SETUP,t.setupStep=e},checkMigrations:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"";t.view=A.MIGRATION,t.migrationsType=e},apiError:function(t,e){var a=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;t.error||(t.error={type:"about:blank",status:e.status||"",response:e,request:a})}},actions:{reset:function(t){var e=t.commit;e("server/composer/setCache"),e("server/config/setCache"),e("server/contao/setCache"),e("server/database/setCache"),e("server/adminUser/setCache"),e("server/opcache/setCache"),e("server/phpinfo/setCache"),e("server/php-cli/setCache"),e("server/php-web/setCache"),e("server/self-update/setCache"),e("contao/install-tool/setCache"),e("contao/backup/setCache"),e("tasks/setInitialized",!1),e("cloud/setStatus",null),e("setSafeMode",!1)}}}),Lt=jt,Pt=a(54210),Et=function(){var t=(0,P.A)((0,L.A)().mark((function t(){var e,a,n,s,i,o=arguments;return(0,L.A)().wrap((function(t){while(1)switch(t.prev=t.next){case 0:for(e={},n=o.length,s=new Array(n),i=0;i<n;i++)s[i]=o[i];a=0;case 3:if(!(a<s.length)){t.next=13;break}return t.t0=Object,t.t1=e,t.next=8,s[a];case 8:t.t2=t.sent.default,e=t.t0.assign.call(t.t0,t.t1,t.t2);case 10:a++,t.next=3;break;case 13:return t.abrupt("return",e);case 14:case"end":return t.stop()}}),t)})));return function(){return t.apply(this,arguments)}}(),Bt={en:function(){return Et(a.e(219).then(a.t.bind(a,3219,19)),a.e(553).then(a.t.bind(a,75553,19)))},de:function(){return Et(a.e(523).then(a.t.bind(a,70523,19)),a.e(477).then(a.t.bind(a,46477,19)))},br:function(){return Et(a.e(140).then(a.t.bind(a,61140,19)),a.e(958).then(a.t.bind(a,32958,19)))},cs:function(){return Et(a.e(874).then(a.t.bind(a,62874,19)),a.e(540).then(a.t.bind(a,64540,19)))},es:function(){return Et(a.e(180).then(a.t.bind(a,52180,19)),a.e(706).then(a.t.bind(a,72706,19)))},fa:function(){return Et(a.e(669).then(a.t.bind(a,99669,19)),a.e(139).then(a.t.bind(a,94139,19)))},fr:function(){return Et(a.e(120).then(a.t.bind(a,98120,19)),a.e(554).then(a.t.bind(a,74554,19)))},it:function(){return Et(a.e(769).then(a.t.bind(a,34769,19)),a.e(851).then(a.t.bind(a,66851,19)))},ja:function(){return Et(a.e(721).then(a.t.bind(a,39721,19)),a.e(551).then(a.t.bind(a,42551,19)))},lv:function(){return Et(a.e(194).then(a.t.bind(a,70194,19)),a.e(560).then(a.t.bind(a,31560,19)))},nl:function(){return Et(a.e(518).then(a.t.bind(a,22518,19)),a.e(164).then(a.t.bind(a,86164,19)))},pl:function(){return Et(a.e(716).then(a.t.bind(a,53716,19)),a.e(638).then(a.t.bind(a,23638,19)))},pt:function(){return Et(a.e(52).then(a.t.bind(a,39052,19)),a.e(606).then(a.t.bind(a,74606,19)))},ru:function(){return Et(a.e(557).then(a.t.bind(a,51557,19)),a.e(715).then(a.t.bind(a,63715,19)))},sr:function(){return Et(a.e(581).then(a.t.bind(a,54581,19)),a.e(367).then(a.t.bind(a,58367,19)))},sv:function(){return Et(a.e(953).then(a.t.bind(a,13953,19)),a.e(643).then(a.t.bind(a,66643,19)))},tr:function(){return Et(a.e(486).then(a.t.bind(a,48486,19)),a.e(44).then(a.t.bind(a,60044,19)))},zh:function(){return Et(a.e(542).then(a.t.bind(a,87542,19)),a.e(28).then(a.t.bind(a,44028,19)))}};l.Ay.use(E.A);var Ut=new E.A,qt=function(t){Ut.locale=t,(0,Pt.x)(t),Lt.commit("algolia/setLanguage",t),document.querySelector("html").setAttribute("lang",t)},Rt={plugin:Ut,init:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n,s;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return Ut.fallbackLocale="en",e.next=3,t.load("en");case 3:if(a=localStorage.getItem("contao_manager_locale"),!a||!Bt[a]){e.next=6;break}return e.abrupt("return",t.load(a));case 6:n=Array.from(navigator.languages),s=0;case 8:if(!(s<n.length)){e.next=14;break}if(!Bt[n[s]]){e.next=11;break}return e.abrupt("return",t.load(n[s]));case 11:s+=1,e.next=8;break;case 14:case"end":return e.stop()}}),e)})))()},switch:function(t){var e=this;return(0,P.A)((0,L.A)().mark((function a(){return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:window.localStorage.setItem("contao_manager_locale",t),e.load(t),Lt.dispatch("algolia/discover");case 3:case"end":return a.stop()}}),a)})))()},load:function(t){var e=this;return(0,P.A)((0,L.A)().mark((function a(){return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:if(!Ut.availableLocales.includes(t)){a.next=3;break}return qt(t),a.abrupt("return");case 3:if(Bt[t]){a.next=7;break}if(5!==t.length){a.next=6;break}return a.abrupt("return",e.load(t.slice(0,2)));case 6:throw"Locale ".concat(t," does not exist.");case 7:return a.t0=Ut,a.t1=t,a.t2=Object,a.t3={},a.next=13,Bt[t]();case 13:a.t4=a.sent,a.t5=a.t2.assign.call(a.t2,a.t3,a.t4),a.t0.setLocaleMessage.call(a.t0,a.t1,a.t5),qt(t);case 17:case"end":return a.stop()}}),a)})))()}},It=a(79376),Ht=a(75726),Vt={components:{ThemeToggle:Ht.A},props:{display:String},data:function(){return{visible:!1}},computed:{isLogin:function(t){return t.$store.state.view===A.LOGIN},currentLanguage:function(){return this.$i18n.locale},languageOptions:function(){return It.A}},methods:{updateLanguage:function(t){Rt.switch(t)},open:function(){var t=this;this.visible=!0,this.$nextTick((function(){return t.$refs.menu.focus()}))},close:function(){var t=this;this.$refs.menu.blur(),setTimeout((function(){t.visible=!1}),300)},toggle:function(){this.visible?this.close():this.open()}}},Ft=Vt,zt=(0,D.A)(Ft,T,j,!1,null,null,null),Nt=zt.exports,Jt={components:{NavigationFragment:O,FooterFragment:Nt},computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("algolia",["news"])),(0,k.L8)("server/contao",["badgeTitle"])),{},{currentNews:function(t){return t.news.length?t.news[0]:null}}),mounted:function(){this.$store.dispatch("server/contao/get")}},Wt=Jt,Gt=(0,D.A)(Wt,w,C,!1,null,null,null),Xt=Gt.exports,Qt=a(23848),Yt=(a(89195),function(){var t=this,e=t._self._c;return e("confirm-button",{attrs:{color:"primary",icon:"add",small:t.small,inline:t.inline,disabled:t.disabled||t.isRootInstalled||t.isAdded||t.isRequired||!t.canBeInstalled},on:{click:t.install}},[t._v(t._s(t.$t(t.small?"ui.package.installButtonShort":"ui.package.installButton")))])}),Kt=[],Zt=(a(84864),a(57465),a(87745),a(90906),a(38781),a(40416)),te={mixins:[Zt.A],computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("packages",["required","add","change"])),(0,k.L8)("packages",["installed","hasRoot","packageInstalled","packageRoot","packageRequired","packageMissing","packageAdded","packageUpdated","packageChanged","packageRemoved","packageFeature","packageVisible","packageSuggested","packageConstraintAdded","packageConstraintChanged","packageConstraintInstalled","packageConstraintRequired","contaoSupported"])),{},{isInstalled:function(t){return t.packageInstalled(t.data.name)},isRootInstalled:function(t){return t.isInstalled&&t.packageRoot(t.data.name)},isRequired:function(t){return t.packageRequired(t.data.name)},isAdded:function(t){return t.packageAdded(t.data.name)},isMissing:function(t){return t.packageMissing(t.data.name)},isChanged:function(t){return t.packageChanged(t.data.name)},isUpdated:function(t){return t.packageUpdated(t.data.name)},willBeRemoved:function(t){return t.packageRemoved(t.data.name)},willBeInstalled:function(t){return t.packageAdded(t.data.name)},isModified:function(t){return t.isUpdated||t.isChanged||t.willBeRemoved||t.willBeInstalled},isSuggested:function(t){return t.packageSuggested(t.data.name)},isPrivate:function(t){return t.metadata&&!!t.metadata.private},isDependency:function(t){return t.metadata&&!!t.metadata.dependency},isFeature:function(t){return t.packageFeature(t.data.name)},isVisible:function(t){return t.packageVisible(t.data.name)},isTheme:function(t){return"contao-theme"===t.data.type||t.metadata&&"contao-theme"===t.metadata.type},isContao:function(t){return"contao/manager-bundle"===t.data.name},isUpload:function(t){return t.metadata&&"dist"===t.metadata["installation-source"]&&t.metadata.dist&&new RegExp("/contao-manager/packages/[^/]+.zip$","i").test(t.metadata.dist.url)},installedVersion:function(t){return t.installed[t.data.name]?t.installed[t.data.name].version:null},installedTime:function(t){return t.installed[t.data.name]?t.installed[t.data.name].time:null},isCompatible:function(t){return t.contaoSupported(t.metadata.contaoConstraint)},canBeInstalled:function(t){return(!t.isPrivate||t.isSuggested)&&!t.isTheme&&(!t.isDependency||t.isSuggested)&&t.isCompatible},constraintInstalled:function(t){return t.packageConstraintInstalled(t.data.name)},constraintRequired:function(t){return t.packageConstraintRequired(t.data.name)},constraintAdded:function(t){return t.packageConstraintAdded(t.data.name)},constraintChanged:function(t){return t.packageConstraintChanged(t.data.name)},targetConstraint:function(t){var e,a;return(null===(e=t.$store.state.packages)||void 0===e?void 0:e.change[t.data.name])||(null===(a=t.$store.state.packages)||void 0===a||null===(a=a.root)||void 0===a?void 0:a.require[t.data.name])}}),methods:{install:function(){this.$store.commit("packages/add",{name:this.data.name})},update:function(){this.$store.commit("packages/update",this.data.name)},uninstall:function(){this.willBeInstalled&&!this.isInstalled?this.$store.commit("packages/restore",this.data.name):(this.$store.commit("packages/restore",this.data.name),this.$store.dispatch("packages/uploads/unconfirm",this.data.name),this.$store.commit("packages/remove",this.data.name))}},watch:{targetConstraint:function(){this.$store.commit("algolia/uncache",this.data.name),this.loadMetadata()}}},ee=function(){var t=this,e=t._self._c;return e("button",{class:t.buttonClass,attrs:{type:"button",disabled:t.disabled},on:{click:t.click}},[e("span",{class:t.slotClass},[t._t("default")],2),e("span",{staticClass:"confirm-button__icon",class:{"confirm-button__icon--confirm":t.confirm}},[e("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M0 0h24v24H0z",fill:"none"}}),e("path",{attrs:{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"}})])])])},ae=[],ne=a(8916),se={props:{color:String,icon:String,inline:Boolean,small:Boolean,disabled:Boolean},data:function(){return{confirm:!1}},computed:{buttonClass:function(t){return(0,ne.A)({"confirm-button":!0,"widget-button":!0,"widget-button--inline":t.inline,"widget-button--small":t.small},"widget-button--".concat(t.color),t.color)},slotClass:function(t){return(0,ne.A)({},"widget-button--".concat(t.icon),t.icon)}},methods:{click:function(t){var e=this;this.confirm||(t.preventDefault(),t.target.blur(),this.$emit("click",t),this.confirm=!0,setTimeout((function(){e.confirm=!1}),1e3))}}},ie=se,oe=(0,D.A)(ie,ee,ae,!1,null,null,null),re=oe.exports,ce={components:{ConfirmButton:re},mixins:[te],props:{data:{type:Object,required:!0},small:Boolean,inline:Boolean,disabled:Boolean},methods:{install:function(){this.$store.commit("packages/add",{name:this.data.name})}}},ue=ce,le=(0,D.A)(ue,Yt,Kt,!1,null,null,null),de=le.exports,pe={components:{DiscoverList:Qt.A,InstallButton:de},computed:(0,b.A)((0,b.A)({},(0,k.L8)("packages",["packageSuggested","contaoSupported","packageConstraint"])),{},{wrapper:function(){return Xt}})},he=pe,ge=(0,D.A)(he,_,v,!1,null,null,null),me=ge.exports,fe=function(){var t=this,e=t._self._c;return e("package-base",{on:{"start-upload":function(e){return t.openFileSelector()}},scopedSlots:t._u([{key:"actions",fn:function(){return[t.hasUploads&&!t.uploading?e("div",{staticClass:"package-actions__inner"},[e("p",{staticClass:"package-actions__text"},[t._v(t._s(t.$tc("ui.packages.uploadMessage",t.totalUploads)))]),e("button",{staticClass:"package-actions__button widget-button widget-button--primary",attrs:{disabled:!t.canConfirmUploads||t.removingUploads},on:{click:t.confirmUploads}},[t._v(t._s(t.$t("ui.packages.uploadApply")))]),e("loading-button",{staticClass:"package-actions__button",attrs:{color:"alert",loading:t.removingUploads},on:{click:t.removeUploads}},[t._v(t._s(t.$t("ui.packages.uploadReset")))])],1):t.totalChanges&&!t.uploading?e("div",{staticClass:"package-actions__inner"},[e("cloud-status",{attrs:{"button-class":"package-actions__button package-actions__button--cloud"}}),e("p",{staticClass:"package-actions__text"},[t._v(t._s(t.$tc("ui.packages.changesMessage",t.totalChanges)))]),e("button-group",{staticClass:"package-actions__button-group",attrs:{"align-top":"",type:"primary",icon:"update",loading:t.cloudLoading,disabled:t.cloudError,"more-disabled":t.cloudLoading||t.cloudError,label:t.$t("ui.packages.changesApply")},on:{click:function(e){t.hasLockFile?t.applyChanges():t.applyChangesAll()}}},[e("link-menu",{attrs:{align:"right",valign:"top",items:t.applyActions,color:"primary"}})],1),e("button",{staticClass:"package-actions__button widget-button widget-button--alert",attrs:{disabled:!t.canResetChanges&&!t.confirmed.length},on:{click:t.resetChanges}},[t._v(t._s(t.$t("ui.packages.changesReset")))])],1):t._e()]},proxy:!0}])},[e("div",{staticClass:"package-list"},[!1!==t.uploads?e("package-uploads",{ref:"uploader"}):t._e(),t.hasAdded?e("h2",{staticClass:"package-list__headline"},[t._v(t._s(t.$t("ui.packagelist.added")))]):t._e(),t._l(t.addedPackages,(function(t){return e("composer-package",{key:t.name,attrs:{data:t}})})),t.showHeadline?e("h2",{staticClass:"package-list__headline"},[t._v(t._s(t.$t("ui.packagelist.installed")))]):t._e(),t._l(t.installedPackages,(function(t){return e("composer-package",{key:t.name,attrs:{data:t}})}))],2)])},_e=[],ve=(a(26910),function(){var t=this,e=t._self._c;return e("main-layout",[e("section",{staticClass:"package-tools"},[t._t("search",(function(){return[e("button",{staticClass:"package-tools__button widget-button widget-button--update",attrs:{disabled:t.totalChanges>0||t.uploading},on:{click:t.updateAll}},[t._v(t._s(t.$t("ui.packages.updateButton")))]),e("button",{staticClass:"package-tools__button widget-button widget-button--upload",attrs:{disabled:!t.uploads||t.uploading,title:t.uploadError},on:{click:function(e){return e.preventDefault(),t.$emit("start-upload")}}},[t._v(t._s(t.$t("ui.packages.uploadButton")))])]}))],2),t._t("default"),e("div",{class:{"package-actions":!0,"package-actions--active":!!t.$slots.actions}},[t._t("actions")],2)],2)}),be=[],ke={components:{MainLayout:Xt},computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.L8)("packages",["totalChanges"])),(0,k.aH)("packages/uploads",["uploads","uploading"])),{},{uploadError:function(t){return!1===t.uploads?t.$t("ui.packages.uploadUnsupported"):""}}),methods:(0,b.A)({},(0,k.i0)("packages",["updateAll"]))},we=ke,Ce=(0,D.A)(we,ve,be,!1,null,null,null),ye=Ce.exports,$e=function(){var t=this,e=t._self._c;return null!==t.uploads?e("div",[e("div",{directives:[{name:"show",rawName:"v-show",value:t.$refs.uploader&&t.$refs.uploader.dropActive,expression:"$refs.uploader && $refs.uploader.dropActive"}],staticClass:"package-uploads__overlay"},[e("div",[e("img",{attrs:{src:a(77591),alt:"",width:"128",height:"128"}}),e("p",[t._v(t._s(t.$t("ui.packages.uploadOverlay")))])])]),e("file-upload",{ref:"uploader",attrs:{name:"package","post-action":"api/packages/uploads",multiple:!0,drop:!0,"drop-directory":!1,"chunk-enabled":!0,chunk:{action:"api/packages/uploads"}},on:{input:t.setFiles,"input-file":t.updateFile,"input-filter":t.filterFile}}),t.$refs.uploader?[t.hasUploads||t.files.length?e("h2",{staticClass:"package-list__headline"},[t._v(t._s(t.$t("ui.packagelist.uploads")))]):t._e(),t._l(t.files,(function(a){return e("uploading-package",{key:a.id,attrs:{file:a,uploader:t.$refs.uploader}})})),t._l(t.unconfirmedUploads,(function(a){return e("uploaded-package",{key:a.id,attrs:{upload:a,uploader:t.$refs.uploader}})}))]:t._e()],2):t._e()},Ae=[],xe=a(78568),Se=a.n(xe),De=function(){var t=this,e=t._self._c;return e("base-package",{attrs:{title:t.file.name},scopedSlots:t._u([{key:"release",fn:function(){return[e("progress-bar",{attrs:{amount:t.file.progress}}),e("div",{staticClass:"package__version package__version--release"},[e("p",[e("strong",[t._v(t._s(t.filesize))])])])]},proxy:!0}])})},Me=[],Oe=(a(52675),a(89463),function(){var t=this,e=t._self._c;return e("article",{staticClass:"package",class:t.hint||t.$slots.hint?"is--hint":""},[t.hint||t.$slots.hint?e("div",{staticClass:"package__hint"},[t._t("hint",(function(){return[t.hintClose?e("a",{staticClass:"package__hint-close",attrs:{href:"#"},on:{click:function(e){return e.preventDefault(),t.$emit("close-hint")}}},[t._v(t._s(t.hintClose))]):t._e(),e("p",[t._v(t._s(t.hint))])]}))],2):t._e(),e("div",{staticClass:"package__inside"},[e("package-logo",{staticClass:"package__icon",attrs:{src:t.logo}}),e("div",{staticClass:"package__details"},[e("div",{staticClass:"package__about"},[e("h1",{class:{package__headline:!0,"package__headline--badge":t.badge}},[t.badge?e("span",{staticClass:"package__badge",attrs:{title:t.badge.title}},[t._v(t._s(t.badge.text))]):t._e(),e("span",{staticClass:"package__title"},[t._v(t._s(t.title))])]),e("p",{staticClass:"package__description"},[t._v(t._s(t.description))]),e("p",{staticClass:"package__additional"},[t._t("additional")],2)]),e("div",{staticClass:"package__release"},[t._t("release",(function(){return[e("div")]}))],2),e("fieldset",{staticClass:"package__actions"},[t._t("actions",(function(){return[e("div")]}))],2)])],1),t._t("features")],2)}),Te=[],je=a(29703),Le={components:{PackageLogo:je.A},props:{title:String,logo:String,badge:Object,description:String,hint:String,hintClose:String}},Pe=Le,Ee=(0,D.A)(Pe,Oe,Te,!1,null,null,null),Be=Ee.exports,Ue=function(){var t=this,e=t._self._c;return e("div",{staticClass:"progress-bar"},[e("div",{ref:"bar",staticClass:"progress-bar__label"},[t._v(t._s(t.label?t.label:"".concat(t.progress,"%")))]),e("div",{staticClass:"progress-bar__bar",style:"width:".concat(t.progress,"%")},[e("span",{style:"width:".concat(t.width,"px")},[t._v(t._s(t.label?t.label:"".concat(t.progress,"%")))])])])},qe=[],Re=(a(2892),{props:{amount:[String,Number],label:String},data:function(){return{width:0}},computed:{progress:function(){return Math.floor(this.amount)}},methods:{updateWidth:function(){this.$refs.bar&&(this.width=this.$refs.bar.clientWidth)}},mounted:function(){this.$nextTick(this.updateWidth)}}),Ie=Re,He=(0,D.A)(Ie,Ue,qe,!1,null,null,null),Ve=He.exports,Fe={components:{ProgressBar:Ve,BasePackage:Be},props:{file:{type:Object,required:!0},uploader:{type:Object,required:!0}},computed:{filesize:function(){var t=["KB","MB","GB"],e="Bytes",a=this.file.size;while(a>1024)a/=1024,e=t.shift();return"".concat(Math.round(100*a)/100," ").concat(e)}}},ze=Fe,Ne=(0,D.A)(ze,De,Me,!1,null,null,null),Je=Ne.exports,We=function(){var t=this,e=t._self._c;return!t.upload.success||t.upload.error?e("base-package",{attrs:{title:t.upload.name,hint:t.hintUploading},scopedSlots:t._u([t.upload.error?{key:"hint",fn:function(){return[e("p",[t._v(" "+t._s(t.upload.error)+" "),t.upload.exception?[t._v(t._s(t.upload.exception))]:t._e()],2)]},proxy:!0}:null,{key:"release",fn:function(){return[e("progress-bar",{attrs:{amount:t.progress}}),e("div",{staticClass:"package__version package__version--release"},[e("p",[e("strong",[t._v(t._s(t._f("filesize")(t.upload.size)))])])])]},proxy:!0},{key:"actions",fn:function(){return[e("loading-button",{attrs:{color:"alert",icon:"trash",loading:t.removing},on:{click:t.removeUpload}},[t._v(t._s(t.$t("ui.package.removeButton")))])]},proxy:!0}],null,!0)}):e("composer-package",{attrs:{"uncloseable-hint":"",data:t.pkg},scopedSlots:t._u([{key:"hint",fn:function(){return[t.isDuplicate(t.upload.id,t.pkg.name)?e("p",[t._v(t._s(t.$t("ui.packages.uploadDuplicate")))]):t.versionInstalled(t.pkg.name,t.pkg.version)?e("p",[t._v(t._s(t.$t("ui.packages.uploadInstalled")))]):t.isCompatible?t._e():e("p",[t._v(t._s(t.$t("ui.package.incompatible",{package:t.pkg.name,constraint:t.packageConstraint("contao/manager-bundle")})))])]},proxy:!0},{key:"actions",fn:function(){return[e("button",{staticClass:"widget-button widget-button--primary widget-button--add",attrs:{disabled:!t.canBeInstalled},on:{click:t.addPackage}},[t._v(t._s(t.$t("ui.package.installButton")))]),e("loading-button",{attrs:{color:"alert",icon:"trash",loading:t.removing},on:{click:t.removeUpload}},[t._v(t._s(t.$t("ui.package.removeButton")))])]},proxy:!0}])})},Ge=[],Xe=(a(48598),function(){var t,e=this,a=e._self._c;return a("base-package",{class:{"package--contao":e.isContao},attrs:{title:e.packageData.title||e.data.name,logo:e.packageData.logo,badge:e.badge,description:e.packageData.description,hint:e.packageHint,"hint-close":e.packageHintClose},on:{"close-hint":e.restore},scopedSlots:e._u([{key:"hint",fn:function(){return[e._t("hint")]},proxy:!0},{key:"additional",fn:function(){return[e.packageData.version?a("div",{staticClass:"package__version package__version--additional"},[a("strong",{attrs:{title:e.packageData.time?e.datimFormat(e.packageData.time):""}},[e._v(e._s(e.$t("ui.package.version",{version:e.packageData.version})))]),e.packageData.update?[e.packageData.update.valid?e.packageData.update.latest?a("div",{staticClass:"package__version-update package__version-update--none"},[e._v(" "+e._s(e.$t("ui.package.updateLatest"))+" "),e.packageData.latest&&!e.packageData.latest.active?a("span",{staticClass:"package__version-latest",attrs:{title:e.$t("ui.package.updateConstraint")}}):e._e()]):a("div",{staticClass:"package__version-update package__version-update--available"},[e._v(e._s(e.$t("ui.package.updateAvailable",{version:e.packageData.update.version})))]):a("div",{staticClass:"package__version-update package__version-update--error"},[e._v(e._s(e.$t("ui.package.updateUnknown")))])]:e._e()],2):e._e(),e.license?a("span",{staticClass:"composer-package__stats composer-package__stats--license"},[e._v(e._s(e.license))]):e._e(),e.packageData.downloads?a("span",{staticClass:"composer-package__stats composer-package__stats--downloads"},[e._v(e._s(e._f("numberFormat")(e.packageData.downloads)))]):e._e(),e.packageData.favers?a("span",{staticClass:"composer-package__stats composer-package__stats--favers"},[e._v(e._s(e._f("numberFormat")(e.packageData.favers)))]):e._e(),e.packageData.funding?a("router-link",{staticClass:"composer-package__stats composer-package__stats--funding",attrs:{to:{query:{p:e.data.name}}}},[e._v(" ")]):e._e()]},proxy:!0},{key:"release",fn:function(){return[e._t("release",(function(){return[a("package-constraint",{staticClass:"package__constraint",attrs:{data:e.data}}),e.packageData.version?a("div",{staticClass:"package__version package__version--release"},[a("strong",{attrs:{title:e.packageData.time?e.datimFormat(e.packageData.time):""}},[e._v(e._s(e.$t("ui.package.version",{version:e.packageData.version})))]),e.packageData.update?[e.packageData.update.valid?e.packageData.update.latest?a("div",{staticClass:"package__version-update package__version-update--none"},[e._v(" "+e._s(e.$t("ui.package.updateLatest"))+" "),e.packageData.latest&&!e.packageData.latest.active?a("span",{staticClass:"package__version-latest",attrs:{title:e.$t("ui.package.updateConstraint")}}):e._e()]):a("div",{staticClass:"package__version-update package__version-update--available"},[e._v(e._s(e.$t("ui.package.updateAvailable",{version:e.packageData.update.version})))]):a("div",{staticClass:"package__version-update package__version-update--error"},[e._v(e._s(e.$t("ui.package.updateUnknown")))])]:e._e()],2):e._e()]}))]},proxy:!0},{key:"actions",fn:function(){return[e._t("actions",(function(){return[e.data.name?a("details-button",{attrs:{name:e.data.name}}):e._e(),e.isContao?[e.isRequired?e._e():a("button",{staticClass:"widget-button widget-button--update",attrs:{disabled:e.isModified},on:{click:e.update}},[e._v(e._s(e.$t("ui.package.updateButton")))])]:[e.isMissing?a("button",{staticClass:"widget-button widget-button--primary widget-button--add",attrs:{disabled:e.willBeInstalled},on:{click:e.install}},[e._v(e._s(e.$t("ui.package.installButton")))]):e.isRequired?a("button",{staticClass:"widget-button widget-button--alert widget-button--trash",attrs:{disabled:e.willBeRemoved},on:{click:e.uninstall}},[e._v(e._s(e.$t("ui.package.removeButton")))]):e.isRootInstalled?a("button-group",{attrs:{label:e.$t("ui.package.updateButton"),icon:"update",disabled:e.isModified},on:{click:e.update}},[a("button",{staticClass:"widget-button widget-button--alert widget-button--trash",attrs:{disabled:e.willBeRemoved},on:{click:e.uninstall}},[e._v(e._s(e.$t("ui.package.removeButton")))])]):e._e()]]}))]},proxy:!0},null!==(t=e.packageFeatures(e.data.name))&&void 0!==t&&t.length?{key:"features",fn:function(){return[a("section",{staticClass:"package__features"},[e._l(e.packageFeatures(e.data.name),(function(t){return[a("feature-package",{key:t,attrs:{name:t}})]}))],2)]},proxy:!0}:null],null,!0)})}),Qe=[],Ye=function(){var t=this,e=t._self._c;return t.isRequired||t.isMissing||t.isRootInstalled||t.willBeInstalled?e("article",{staticClass:"feature-package"},[e("p",{staticClass:"feature-package__text",class:{"feature-package__text--hint":this.packageHint}},[e("strong",{staticClass:"feature-package__name"},[t._v(t._s(t.packageTitle))]),this.packageHint?e("span",{staticClass:"feature-package__hint"},[t._v(t._s(t.packageHint))]):t.isMissing?e("span",{staticClass:"feature-package__badge",attrs:{title:t.$t("ui.package.removedText")}},[t._v(t._s(t.$t("ui.package.removedTitle")))]):t.isRequired?e("span",{staticClass:"feature-package__badge",attrs:{title:t.$t("ui.package.requiredText")}},[t._v(t._s(t.$t("ui.package.requiredTitle")))]):[t._v(t._s(t.metadata.description))]],2),e("div",{staticClass:"feature-package__actions"},[t.packageHint?e("button",{staticClass:"feature-package__restore",on:{click:t.restore}},[t._v(t._s(t.$t("ui.package.hintRevert")))]):t._e(),e("details-button",{attrs:{small:"",name:t.name}}),!t.isRequired&&!t.isRootInstalled||t.willBeRemoved?t._e():e("button",{staticClass:"widget-button widget-button--alert widget-button--trash widget-button--small",attrs:{title:t.$t("ui.package.removeButton")},on:{click:t.uninstall}})],1)]):t._e()},Ke=[],Ze=a(71159),ta={mixins:[te],components:{DetailsButton:Ze.A},props:{name:String,reason:String},computed:{data:function(t){return{name:t.name}},packageTitle:function(){var t;return null!==(t=this.metadata)&&void 0!==t&&t.name?this.metadata.title||this.metadata.name:this.data.name},packageHint:function(){return this.willBeRemoved?this.$t("ui.package.hintRemoved"):this.willBeInstalled?this.$t("ui.package.hintAdded"):null}},methods:{restore:function(){this.$store.commit("packages/restore",this.data.name)}}},ea=ta,aa=(0,D.A)(ea,Ye,Ke,!1,null,null,null),na=aa.exports,sa=function(){var t=this,e=t._self._c;return!t.isFeature&&t.isVisible?e("fieldset",{staticClass:"package-constraint"},[e("input",{directives:[{name:"model",rawName:"v-model",value:t.inputValue,expression:"inputValue"}],ref:"constraint",class:{disabled:!t.emit&&(t.willBeRemoved||!t.isInstalled&&!t.willBeInstalled&&!t.isRequired||t.isUpload),error:t.constraintError},attrs:{type:"text",placeholder:t.inputPlaceholder,title:t.inputTitle,disabled:!t.constraintEditable||t.willBeRemoved||!t.emit&&!t.isInstalled&&!t.willBeInstalled&&!t.isRequired||t.isUpload},domProps:{value:t.inputValue},on:{keypress:[function(e){return!e.type.indexOf("key")&&t._k(e.keyCode,"enter",13,e.key,"Enter")?null:(e.preventDefault(),t.saveConstraint.apply(null,arguments))},function(e){return!e.type.indexOf("key")&&t._k(e.keyCode,"esc",27,e.key,["Esc","Escape"])?null:(e.preventDefault(),t.resetConstraint.apply(null,arguments))}],blur:t.saveConstraint,input:function(e){e.target.composing||(t.inputValue=e.target.value)}}}),e("button",{class:{"widget-button widget-button--gear":!0,rotate:t.constraintValidating},attrs:{title:t.buttonTitle,disabled:!t.emit&&(t.willBeRemoved||!t.isInstalled&&!t.willBeInstalled&&!t.isRequired||t.isUpload)},on:{click:t.editConstraint}},[t._v(t._s(t.buttonValue))])]):t._e()},ia=[],oa={mixins:[te],props:{data:{type:Object,required:!0},emit:{type:Boolean,default:!1},value:{type:String,default:""}},data:function(){return{constraint:"",constraintEditable:!1,constraintValidating:!1,constraintError:!1}},computed:{buttonTitle:function(t){return t.isUpload?t.$t("ui.package.uploadConstraint"):""},buttonValue:function(t){return t.isUpload?t.$t("ui.package.editConstraint"):t.$t("ui.package.private")},inputTitle:function(t){return t.isUpload?t.$t("ui.package.privateTitle"):t.constraint},inputPlaceholder:function(t){return t.isUpload||t.$store.state.packages.root&&Object.keys(t.$store.state.packages.root.require).includes(t.data.name)?"":t.$t("ui.package.latestConstraint")},inputValue:{get:function(t){return t.isUpload?t.$t("ui.package.private"):t.constraint},set:function(t){this.isUpload||(this.constraint=t)}}},methods:{editConstraint:function(){var t=this;this.constraintValidating||(this.constraintEditable=!0,this.$nextTick((function(){t.$refs.constraint.focus()})))},saveConstraint:function(){var t=this;if(this.constraintEditable){if(this.constraintEditable=!1,this.constraintError=!1,!this.emit&&(this.isInstalled&&(!this.constraint||this.constraintInstalled===this.constraint)||this.isRequired&&(!this.constraint||this.constraintRequired===this.constraint)))return this.$store.commit("packages/restore",this.data.name),this.$store.dispatch("packages/uploads/unconfirm",this.data.name),void this.resetConstraint();if(!this.emit&&!this.isRequired&&this.willBeInstalled&&!this.constraint)return this.$store.commit("packages/add",Object.assign({},this.data,{constraint:null})),void this.resetConstraint();if(this.emit&&!this.constraint)return this.$emit("input",this.constraint),void this.resetConstraint();this.$refs.constraint.blur(),this.constraintValidating=!0,l.Ay.http.post("api/constraint",{constraint:this.constraint}).then((function(e){t.constraintValidating=!1,e.body.valid?t.emit?t.$emit("input",t.constraint):t.isRootInstalled||t.isRequired?t.$store.commit("packages/change",{name:t.data.name,version:t.constraint}):t.$store.commit("packages/add",Object.assign({},t.data,{constraint:t.constraint})):(t.constraintError=!0,t.$nextTick((function(){return t.editConstraint()})))}))}},resetConstraint:function(){this.emit?this.constraint=this.value:this.willBeInstalled?this.constraint=this.constraintAdded:this.isChanged?this.constraint=this.constraintChanged:this.isInstalled?this.constraint=this.constraintInstalled:this.isRequired&&(this.constraint=this.constraintRequired),this.constraintEditable&&(this.constraintEditable=!1,this.constraintError=!1,this.constraintValidating=!1)}},watch:{value:function(t){this.constraint=t},constraintAdded:function(t){this.constraint=t},constraintChanged:function(t){this.constraint=t||this.constraintInstalled||this.constraintRequired}},mounted:function(){this.resetConstraint()}},ra=oa,ca=(0,D.A)(ra,sa,ia,!1,null,"382a7b7e",null),ua=ca.exports,la=function(){var t=this,e=t._self._c;return e("div",{staticClass:"button-group"},[e("loading-button",{class:t.primaryClass,attrs:{href:t.href,to:t.to,disabled:t.disabled,loading:t.loading},on:{click:function(e){return t.$emit("click",e)}}},[t._v(t._s(t.label))]),e("button",{class:t.moreClass,attrs:{disabled:t.moreDisabled},on:{click:t.toggle}},[e("svg",{attrs:{fill:"#FFF",height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"}},[e("path",{attrs:{d:"M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"}}),e("path",{attrs:{d:"M0 0h24v24H0z",fill:"none"}})])]),e("div",{directives:[{name:"show",rawName:"v-show",value:t.showGroup,expression:"showGroup"}],ref:"group",class:(0,ne.A)({"button-group__group":!0},"button-group__group--top",t.alignTop),attrs:{tabindex:"-1"},on:{blur:t.close,click:t.close}},[t._t("default")],2)],1)},da=[],pa={components:{LoadingButton:R.A},props:{label:{type:String,required:!0},type:String,href:String,to:[String,Object],icon:String,color:String,disabled:Boolean,loading:Boolean,moreDisabled:Boolean,alignTop:Boolean},data:function(){return{showGroup:!1}},computed:{primaryClass:function(){var t="widget-button button-group__primary";return this.type&&(t+=" widget-button--".concat(this.type)),this.icon&&(t+=" widget-button--".concat(this.icon)),this.color&&(t+=" widget-button--".concat(this.color)),t},moreClass:function(){var t="widget-button button-group__more";return this.type&&(t+=" widget-button--".concat(this.type)),this.color&&(t+=" widget-button--".concat(this.color)),t}},methods:{open:function(){var t=this;this.showGroup=!0,this.$nextTick((function(){var e;return null===(e=t.$refs.group)||void 0===e?void 0:e.focus()}))},close:function(){var t,e=this;null===(t=this.$refs.group)||void 0===t||t.blur(),setTimeout((function(){e.showGroup=!1}),300)},toggle:function(){this.showGroup?this.close():this.open()}}},ha=pa,ga=(0,D.A)(ha,la,da,!1,null,null,null),ma=ga.exports,fa={mixins:[te],components:{BasePackage:Be,FeaturePackage:na,PackageConstraint:ua,ButtonGroup:ma,DetailsButton:Ze.A},props:{data:{type:Object,required:!0},hint:String,uncloseableHint:Boolean},computed:(0,b.A)((0,b.A)({},(0,k.L8)("packages",["packageFeatures"])),{},{packageData:function(t){return Object.assign({},t.data,t.installed[t.data.name]||{},t.metadata||{})},license:function(t){return t.packageData.license instanceof Array?t.packageData.license.join("/"):t.packageData.license},packageHint:function(){return this.hint?this.hint:this.willBeRemoved||this.isMissing&&!this.willBeInstalled?this.$t("ui.package.hintRemoved"):this.isRequired?this.$t("ui.package.hintConstraint",{constraint:this.constraintRequired}):this.willBeInstalled?this.constraintAdded?this.$t("ui.package.hintConstraint",{constraint:this.constraintAdded}):this.$t("ui.package.hintConstraintBest"):this.isChanged?this.$t("ui.package.hintConstraintChange",{from:this.constraintInstalled,to:this.constraintChanged}):this.isUpdated?this.$t("ui.package.hintConstraintUpdate"):null},packageHintClose:function(){return this.uncloseableHint||this.isRequired&&!this.willBeRemoved&&!this.isChanged||this.isMissing&&!this.willBeInstalled?null:this.isUpdated?this.$t("ui.package.hintNoupdate"):this.$t("ui.package.hintRevert")},packageUpdates:function(){return this.isInstalled&&(Object.keys(this.$store.state.packages.add).length>0||Object.keys(this.$store.state.packages.change).length>0||this.$store.state.packages.update.length>0||this.$store.state.packages.remove.length>0)},badge:function(){return this.isRequired?{title:this.$t("ui.package.requiredText"),text:this.$t("ui.package.requiredTitle")}:this.isMissing?{title:this.$t("ui.package.removedText"),text:this.$t("ui.package.removedTitle")}:this.packageData.abandoned?{title:!0===this.packageData.abandoned?this.$t("ui.package.abandonedText"):this.$t("ui.package.abandonedReplace",{replacement:this.packageData.abandoned}),text:this.$t("ui.package.abandoned")}:null}}),methods:{restore:function(){this.$store.commit("packages/restore",this.data.name),this.$store.dispatch("packages/uploads/unconfirm",this.data.name)},datimFormat:function(t){return(0,Pt.A)(t)}}},_a=fa,va=(0,D.A)(_a,Xe,Qe,!1,null,null,null),ba=va.exports,ka={mixins:[Zt.A],components:{ProgressBar:Ve,BasePackage:Be,ComposerPackage:ba,LoadingButton:R.A},props:{upload:{type:Object,required:!0},uploader:{type:Object,required:!0}},computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.L8)("packages",["packageRemoved","versionInstalled","contaoSupported","packageConstraint"])),(0,k.L8)("packages/uploads",["isDuplicate","isRemoving"])),{},{removing:function(t){return t.isRemoving(t.upload.id)},progress:function(t){return 100/t.upload.size*t.upload.filesize},isTheme:function(t){return"contao-theme"===t.data.type||t.metadata&&"contao-theme"===t.metadata.type},isCompatible:function(t){return!t.data.require||t.contaoSupported(t.data.require["contao/core-bundle"]||t.data.require["contao/manager-bundle"]||"0")},canBeInstalled:function(t){return!t.isDuplicate(t.upload.id,t.pkg.name)&&!t.versionInstalled(t.pkg.name,t.pkg.version)&&!t.removing&&!t.packageRemoved(t.pkg.name)&&!t.isTheme&&t.isCompatible},data:function(t){return t.upload.package||{name:""}},pkg:function(t){return Object.assign({name:t.upload.name,version:null},t.upload.package||{})},hintUploading:function(){return this.upload.error?this.upload.error:this.upload.size!==this.upload.filesize?this.$t("ui.packages.uploadIncomplete"):""},additional:function(){var t=[];return this.pkg.license&&(this.pkg.license instanceof Array?t.push(this.pkg.license.join("/")):t.push(this.pkg.license)),this.pkg.downloads&&t.push(this.$tc("ui.package.additionalDownloads",this.pkg.downloads)),this.pkg.favers&&t.push(this.$tc("ui.package.additionalStars",this.pkg.favers)),t}}),methods:{addPackage:function(){this.$store.dispatch("packages/uploads/confirm",this.upload.id)},removeUpload:function(){this.$store.dispatch("packages/uploads/remove",this.upload.id)}}},wa=ka,Ca=(0,D.A)(wa,We,Ge,!1,null,null,null),ya=Ca.exports,$a={components:{FileUpload:Se(),UploadingPackage:Je,UploadedPackage:ya},computed:(0,b.A)((0,b.A)({},(0,k.aH)("packages/uploads",["uploads","files"])),(0,k.L8)("packages/uploads",["hasUploads","unconfirmedUploads"])),methods:(0,b.A)((0,b.A)({},(0,k.PY)("packages/uploads",["setUploading","setFiles"])),{},{openFileSelector:function(){this.$refs.uploader&&this.$refs.uploader.$el.querySelector("input").click()},filterFile:function(t,e,a){return(0,P.A)((0,L.A)().mark((function n(){return(0,L.A)().wrap((function(n){while(1)switch(n.prev=n.next){case 0:if(!t||e){n.next=3;break}if(/\.zip$/i.test(t.name)){n.next=3;break}return n.abrupt("return",a());case 3:case"end":return n.stop()}}),n)})))()},updateFile:function(t,e){var a=this;return(0,P.A)((0,L.A)().mark((function n(){return(0,L.A)().wrap((function(n){while(1)switch(n.prev=n.next){case 0:if(a.setUploading(!a.$refs.uploader.uploaded),!e||t){n.next=4;break}return a.$refs.uploader.uploaded&&!a.$refs.uploader.active&&a.setFiles([]),n.abrupt("return");case 4:if(t.error&&t.xhr&&(401===t.xhr.status?a.$store.commit("setView",A.LOGIN):"application/problem+json"===t.xhr.getResponseHeader("Content-Type")&&a.$store.commit("setError",JSON.parse(t.response))),Boolean(t)===Boolean(e)&&e.error===t.error||a.$refs.uploader.active||(a.$refs.uploader.active=!0),!(a.$refs.uploader.uploaded&&t&&e&&!t.active&&e.active)){n.next=10;break}return n.next=9,a.$store.dispatch("packages/uploads/load");case 9:a.$refs.uploader.remove(t);case 10:case"end":return n.stop()}}),n)})))()}})},Aa=$a,xa=(0,D.A)(Aa,$e,Ae,!1,null,null,null),Sa=xa.exports,Da=function(){var t=this,e=t._self._c;return t.enabled?e("div",{staticClass:"cloud-status"},[e("loading-button",{class:"cloud-status__button ".concat(t.buttonClass),attrs:{color:"info",icon:t.hasError?"cloud-off":"cloud",loading:t.isLoading,disabled:t.hasError},on:{mouseover:t.open,mouseout:t.close,click:t.open}},[t.isReady?[t._v(t._s(t.$t("ui.cloudStatus.approx",{minutes:t.approxMinutes})))]:t._e()],2),t.isReady?e("div",{directives:[{name:"show",rawName:"v-show",value:t.visible,expression:"visible"}],staticClass:"cloud-status__popup",attrs:{tabindex:"-1"},on:{blur:t.close,mouseover:t.open,mouseout:t.close,click:t.open}},[e("h2",{staticClass:"cloud-status__headline"},[t._v(t._s(t.$t("ui.cloudStatus.headline")))]),e("p",{staticClass:"cloud-status__version"},[t._v(t._s(t.$t("ui.cloudStatus.version",{version:t.status.appVersion})))]),e("table",[e("tr",[e("th",[t._v(t._s(t.$t("ui.cloudStatus.waitingTime"))+":")]),e("td",[t._v(t._s(t.waitingLabel))])]),e("tr",[e("th",[t._v(t._s(t.$t("ui.cloudStatus.jobs"))+":")]),e("td",[t._v(t._s(t.status.numberOfJobsInQueue>0?t.status.numberOfJobsInQueue+t.status.numberOfWorkers:"≤ ".concat(t.status.numberOfWorkers)))])]),e("tr",[e("th",[t._v(t._s(t.$t("ui.cloudStatus.workers"))+":")]),e("td",[t._v(t._s(t.status.numberOfWorkers))])])]),e("a",{staticClass:"widget-button widget-button--info widget-button--link widget-button--small cloud-status__link",attrs:{href:"https://composer-resolver-cloud.statuspage.io/",target:"_blank",rel:"noreferrer noopener"}},[t._v(t._s(t.$t("ui.cloudStatus.button")))])]):t.hasError?e("div",{staticClass:"cloud-status__popup cloud-status__popup--error",attrs:{tabindex:"-1"}},[e("h2",{staticClass:"cloud-status__headline cloud-status__headline--error"},[t._v(t._s(t.$t("ui.cloudStatus.headline")))]),e("p",{staticClass:"cloud-status__error"},[t._v(t._s(t.$t("ui.cloudStatus.error")))]),e("a",{staticClass:"widget-button widget-button--info widget-button--link widget-button--small cloud-status__link",attrs:{href:"https://composer-resolver-cloud.statuspage.io/",target:"_blank",rel:"noreferrer noopener"}},[t._v(t._s(t.$t("ui.cloudStatus.button")))]),e("button",{staticClass:"widget-button widget-button--update widget-button--small",attrs:{title:t.$t("ui.cloudStatus.approxError")},on:{click:t.refreshCloud}})]):t._e()],1):t._e()},Ma=[],Oa={components:{LoadingButton:R.A},props:{buttonClass:String},data:function(){return{visible:!1,timeout:null,mouseout:null}},computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("cloud",["enabled","status"])),(0,k.L8)("cloud",["isLoading","isReady","hasError"])),{},{waitingTime:function(t){return Math.round(t.status.numberOfJobsInQueue*(t.status.averageProcessingTimeInMs/1e3)/Math.max(t.status.numberOfWorkers,1))},waitingMinutes:function(t){return Math.floor(t.waitingTime/60)},waitingSeconds:function(t){return t.waitingTime-60*t.waitingMinutes},approxMinutes:function(t){return Math.round(t.waitingTime/60)},waitingLabel:function(){return this.waitingTime?this.waitingSeconds?this.$t("ui.cloudStatus.long",{minutes:this.waitingMinutes,seconds:this.waitingSeconds}):this.$t("ui.cloudStatus.short",{minutes:this.waitingMinutes}):this.$t("ui.cloudStatus.none")}}),methods:{open:function(){clearTimeout(this.mouseout),this.visible=!0},close:function(){var t=this;this.mouseout=setTimeout((function(){t.visible=!1}),300)},refreshCloud:function(){this.$store.commit("cloud/setStatus",null),this.fetchCloud()},fetchCloud:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("cloud/fetch");case 2:t.enabled&&!t.hasError&&(t.timeout=setTimeout(t.fetchCloud,6e4));case 3:case"end":return e.stop()}}),e)})))()}},mounted:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:t.fetchCloud();case 1:case"end":return e.stop()}}),e)})))()},beforeDestroy:function(){clearTimeout(this.timeout)}},Ta=Oa,ja=(0,D.A)(Ta,Da,Ma,!1,null,null,null),La=ja.exports,Pa=a(13409),Ea=function(t,e){return"contao/manager-bundle"===t.name?-1:"contao/manager-bundle"===e.name?1:0},Ba={components:{PackageBase:ye,PackageUploads:Sa,ComposerPackage:ba,LoadingButton:R.A,CloudStatus:La,ButtonGroup:ma,LinkMenu:Pa.A},data:function(){return{hasLockFile:!0}},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.L8)("cloud",{cloudLoading:"isLoading",cloudError:"hasError"})),(0,k.aH)("packages",{requiredPackages:"required"})),(0,k.aH)("packages/uploads",["uploads","uploading","files","removing","confirmed"])),(0,k.L8)("packages",["totalChanges","packageMissing","canResetChanges","visibleRequired","visibleInstalled","visibleAdded"])),(0,k.L8)("packages/uploads",["hasUploads","totalUploads","canConfirmUploads"])),{},{addedPackages:function(t){return t.visibleRequired.concat(t.visibleAdded).filter((function(e){return!t.packageMissing(e.name)})).sort(Ea)},installedPackages:function(t){return t.visibleRequired.filter((function(e){return t.packageMissing(e.name)})).concat(t.visibleInstalled).sort(Ea)},removingUploads:function(t){return t.removing.length>0},showHeadline:function(t){return t.installedPackages.length>0&&(t.hasAdded||t.hasUploads||t.files.length)},hasAdded:function(t){return t.addedPackages.length},applyActions:function(){return this.hasLockFile?[{label:this.$t("ui.packages.changesDryrun"),action:this.dryrunChanges},{label:this.$t("ui.packages.changesDryrunAll"),action:this.dryrunChangesAll},{label:this.$t("ui.packages.changesApplyAll"),action:this.applyChangesAll}]:[{label:this.$t("ui.packages.changesDryrun"),action:this.dryrunChanges}]}}),methods:{openFileSelector:function(){this.$refs.uploader&&this.$refs.uploader.openFileSelector()},confirmUploads:function(){this.$store.dispatch("packages/uploads/confirmAll")},removeUploads:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("packages/uploads/removeAll");case 2:case"end":return e.stop()}}),e)})))()},dryrunChanges:function(){this.$store.dispatch("packages/apply",{dry_run:!0})},dryrunChangesAll:function(){this.$store.dispatch("packages/apply",{dry_run:!0,update_all:!0})},applyChanges:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("packages/apply");case 2:return e.next=4,t.$store.dispatch("packages/load");case 4:case"end":return e.stop()}}),e)})))()},applyChangesAll:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("packages/apply",{update_all:!0});case 2:return e.next=4,t.$store.dispatch("packages/load");case 4:case"end":return e.stop()}}),e)})))()},resetChanges:function(){this.$store.commit("packages/reset"),this.$store.dispatch("packages/uploads/unconfirmAll")}},mounted:function(){var t=this;this.$store.dispatch("server/composer/get").then((function(e){t.hasLockFile=e.lock.found}))}},Ua=Ba,qa=(0,D.A)(Ua,fe,_e,!1,null,null,null),Ra=qa.exports,Ia=function(){var t=this,e=t._self._c;return e("boxed-layout",{attrs:{slotClass:"view-oauth"}},[e("header",{staticClass:"view-oauth__header"},[e("img",{attrs:{src:a(6894),width:"80",height:"80",alt:"Contao Logo"}}),e("p",{staticClass:"view-oauth__product"},[t._v("Contao Manager")])]),e("main",{staticClass:"view-oauth__form"},[e("h1",{staticClass:"view-oauth__headline"},[t._v(t._s(t.$t("ui.oauth.headline")))]),e("p",{staticClass:"view-oauth__description"},[t._v(t._s(t.$t("ui.oauth.description")))]),e("p",{staticClass:"view-oauth__client"},[t._v(t._s(t.hostname))]),e("p",{staticClass:"view-oauth__warning"},[t._v(t._s(t.$t("ui.oauth.domain")))]),e("loading-button",{staticClass:"view-oauth__button",attrs:{color:"primary",disabled:!t.valid,loading:t.authenticating},on:{click:t.allowAccess}},[t._v(" "+t._s(t.$t("ui.oauth.allow"))+" ")]),e("button",{staticClass:"view-oauth__button widget-button",attrs:{disabled:!t.valid||t.authenticating},on:{click:function(e){return e.preventDefault(),t.denyAccess.apply(null,arguments)}}},[t._v(" "+t._s(t.$t("ui.oauth.deny"))+" ")])],1)])},Ha=[],Va=(a(3296),a(48408),a(14603),a(47566),a(98721),function(){var t=this,e=t._self._c;return e("div",{staticClass:"layout-boxed"},[e("div",{staticClass:"layout-boxed__cell"},[e("div",{class:"layout-boxed__container "+(t.wide?" layout-boxed__container--wide ":"")+t.slotClass},[t._t("default"),e("footer-fragment",{attrs:{display:t.wide?"boxed":""}})],2)])])}),Fa=[],za={components:{FooterFragment:Nt},props:{slotClass:String,wide:Boolean}},Na=za,Ja=(0,D.A)(Na,Va,Fa,!1,null,null,null),Wa=Ja.exports,Ga={components:{BoxedLayout:Wa,LoadingButton:R.A},data:function(){return{valid:!1,authenticating:!1}},computed:{hostname:function(){return this.$route.query.redirect_uri?new URL(this.$route.query.redirect_uri).hostname:"???"}},methods:{allowAccess:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.authenticating=!0,e.prev=1,e.next=4,t.$http.post("api/users/".concat(t.$store.state.auth.username,"/tokens"),{client_id:t.$route.query.client_id,scope:t.$route.query.scope});case 4:a=e.sent,t.redirect({access_token:a.body.token,token_type:"bearer",scope:t.$route.query.scope,endpoint:"".concat(location.origin).concat(location.pathname)}),e.next=11;break;case 8:e.prev=8,e.t0=e["catch"](1),t.redirect({error:"server_error"});case 11:case"end":return e.stop()}}),e,null,[[1,8]])})))()},denyAccess:function(){this.redirect({error:"access_denied"})},redirect:function(t){var e=[];for(var a in t)e.push(encodeURIComponent(a)+"="+encodeURIComponent(t[a]));this.$route.query.state&&e.push(encodeURIComponent("state")+"="+encodeURIComponent(this.$route.query.state));var n=e.join("&"),s=this.$route.query.redirect_uri;s.includes("#")?document.location.href="".concat(s,"&").concat(n):document.location.href="".concat(s,"#").concat(n)}},mounted:function(){var t=!1;try{var e=new URL(this.$route.query.redirect_uri);"https:"!==e.protocol&&"localhost"!==e.hostname&&(t=!0)}catch(a){t=!0}if(!t)return"token"!==this.$route.query.response_type?this.redirect({error:"unsupported_response_type"}):"admin"!==this.$route.query.scope?this.redirect({error:"invalid_scope"}):this.$route.query.client_id?void(this.valid=!0):this.redirect({error:"invalid_request"});this.$store.commit("setError",{title:this.$t("ui.oauth.error"),detail:this.$t("ui.oauth.https"),type:"https://tools.ietf.org/html/rfc6749#section-3.1.2.1",status:400})}},Xa=Ga,Qa=(0,D.A)(Xa,Ia,Ha,!1,null,null,null),Ya=Qa.exports,Ka=function(){var t=this,e=t._self._c;return e("main-layout",[e("rebuild-cache"),e("database-status"),e("maintenance-mode"),e("install-tool"),e("debug-mode"),e("dump-autoload"),e("composer-install"),e("composer-cache"),e("opcode-cache")],1)},Za=[],tn=function(){var t=this,e=t._self._c;return e("message-overlay",{attrs:{message:t.overlayMessage,active:t.safeMode||!1===t.supported}},[e("section",{staticClass:"maintenance"},[e("div",{staticClass:"maintenance__inside"},[e("figure",{staticClass:"maintenance__image"},[e("img",{attrs:{src:a(6894),alt:""}})]),e("div",{staticClass:"maintenance__about"},[e("h1",[t._v(" "+t._s(t.$t("ui.maintenance.database.title"))+" "),t.hasError?e("span",{staticClass:"maintenance__error"},[t._v(t._s(t.$t("ui.maintenance.database.error")))]):t._e(),t.hasWarning?e("span",{staticClass:"maintenance__warning"},[t._v(t._s(t.$t("ui.maintenance.database.warning")))]):t.totalMigrations?e("span",{staticClass:"maintenance__warning"},[t._v(t._s(t.$tc("ui.maintenance.database.migrations",t.totalMigrations)))]):t.totalSchemaUpdates?e("span",{staticClass:"maintenance__warning"},[t._v(t._s(t.$tc("ui.maintenance.database.schemaUpdates",t.totalSchemaUpdates)))]):t._e()]),e("p",[t._v(t._s(t.$t("ui.maintenance.database.description")))]),e("br"),t.supportsBackups||t.loadingBackups?t.supportsBackups&&t.backupFiles.length?e("p",[t._v(t._s(t.$tc("ui.maintenance.database.backupList",t.backupFiles.length,{date:t.datimFormat(t.backupFiles[0].createdAt)})))]):t.supportsBackups?e("p",[t._v(t._s(t.$t("ui.maintenance.database.backupEmpty")))]):t._e():e("p",[t._v(t._s(t.$t("ui.maintenance.database.backupUnsupported")))])]),e("fieldset",{staticClass:"maintenance__actions"},[t.loading?e("loading-spinner",{staticClass:"maintenance__loader"}):t.hasError&&!t.supported?e("a",{staticClass:"widget-button widget-button--alert",attrs:{href:"/contao/install"}},[t._v(t._s(t.$t("ui.maintenance.database.installTool")))]):t.hasError?e("button",{staticClass:"widget-button widget-button--alert",on:{click:t.checkMigrations}},[t._v(t._s(t.$t("ui.maintenance.database.button")))]):e("button-group",{attrs:{label:t.$t("ui.maintenance.database.button"),type:t.hasChanges||t.hasWarning?"warning":"primary",icon:"database"},on:{click:t.checkMigrations}},[e("link-menu",{attrs:{align:"right",items:t.advancedActions(),color:t.hasChanges?"warning":"primary"}})],1),e("loading-button",{staticClass:"widget-button",attrs:{disabled:!t.supportsBackups,loading:t.loadingBackups},on:{click:t.createBackup}},[t._v(t._s(t.$t("ui.maintenance.database.createBackup")))])],1)])])])},en=[],an=function(){var t=this,e=t._self._c;return e("div",{staticClass:"message-overlay"},[e("div",{class:{"message-overlay__blur":t.active}},[t._t("default")],2),t.active?e("div",{staticClass:"message-overlay__overlay"},[e("span",{staticClass:"message-overlay__message"},[t._v(t._s(t.message))])]):t._e()])},nn=[],sn={props:{message:{type:String,required:!0},active:{type:Boolean,required:!0}}},on=sn,rn=(0,D.A)(on,an,nn,!1,null,null,null),cn=rn.exports,un=a(58e3),ln={components:{MessageOverlay:cn,LoadingSpinner:un.A,ButtonGroup:ma,LinkMenu:Pa.A,LoadingButton:R.A},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)(["safeMode"])),(0,k.aH)("server/database",["loading","supported","status"])),(0,k.aH)("contao/backup",{supportsBackups:"supported",backupFiles:"files",loadingBackups:"loading"})),(0,k.L8)("server/database",["hasError","hasChanges","hasWarning","totalMigrations","totalSchemaUpdates"])),{},{overlayMessage:function(t){return t.safeMode?t.$t("ui.maintenance.safeMode"):t.$t("ui.maintenance.unsupported")}}),methods:{datimFormat:function(t){return(0,Pt.A)(t,"short","long")},checkMigrations:function(){this.$store.commit("checkMigrations")},advancedActions:function(){var t=this;return[{label:this.$t("ui.maintenance.database.migrationOnly"),action:function(){t.$store.commit("checkMigrations","migrations-only")}},{label:this.$t("ui.maintenance.database.schemaOnly"),action:function(){t.$store.commit("checkMigrations","schema-only")}}]},createBackup:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("tasks/execute",{name:"contao/backup-create"});case 2:return e.next=4,t.$store.dispatch("contao/backup/fetch",!1);case 4:case"end":return e.stop()}}),e)})))()}},mounted:function(){this.$store.dispatch("server/database/get"),this.$store.dispatch("contao/backup/fetch")}},dn=ln,pn=(0,D.A)(dn,tn,en,!1,null,null,null),hn=pn.exports,gn=function(){var t=this,e=t._self._c;return e("section",{staticClass:"maintenance"},[e("div",{staticClass:"maintenance__inside"},[t._m(0),e("div",{staticClass:"maintenance__about"},[e("h1",[t._v(t._s(t.$t("ui.maintenance.rebuildCache.title")))]),e("p",[t._v(t._s(t.$t("ui.maintenance.rebuildCache.description")))])]),e("fieldset",{staticClass:"maintenance__actions"},[e("button-group",{attrs:{label:t.$t("ui.maintenance.rebuildCache.rebuildProd"),type:"primary",icon:"update"},on:{click:t.rebuildProd}},[e("link-menu",{attrs:{align:"right",items:t.advancedActions(),color:"primary"}})],1)],1)])])},mn=[function(){var t=this,e=t._self._c;return e("figure",{staticClass:"maintenance__image"},[e("img",{staticClass:"color-scheme--light",attrs:{src:a(68966),alt:""}}),e("img",{staticClass:"color-scheme--dark",attrs:{src:a(64900),alt:""}})])}],fn={components:{ButtonGroup:ma,LinkMenu:Pa.A},methods:{advancedActions:function(){return[{label:this.$t("ui.maintenance.rebuildCache.rebuildDev"),action:this.rebuildDev},{label:this.$t("ui.maintenance.rebuildCache.clearProd"),action:this.clearProd},{label:this.$t("ui.maintenance.rebuildCache.clearDev"),action:this.clearDev}]},rebuildProd:function(){this.execute("prod",!0)},rebuildDev:function(){this.execute("dev",!0)},clearProd:function(){this.execute("prod",!1)},clearDev:function(){this.execute("dev",!1)},execute:function(t,e){var a={name:"contao/rebuild-cache",config:{environment:t,warmup:e}};this.$store.dispatch("tasks/execute",a)}}},_n=fn,vn=(0,D.A)(_n,gn,mn,!1,null,null,null),bn=vn.exports,kn=function(){var t=this,e=t._self._c;return e("message-overlay",{attrs:{message:t.overlayMessage,active:t.safeMode||!1===t.isSupported}},[e("section",{staticClass:"maintenance"},[e("div",{staticClass:"maintenance__inside"},[e("figure",{staticClass:"maintenance__image"},[e("img",{attrs:{src:a(6894),alt:""}})]),e("div",{staticClass:"maintenance__about"},[e("h1",[t._v(t._s(t.$t("ui.maintenance.installTool.title")))]),e("p",[t._v(t._s(t.$t("ui.maintenance.installTool.description")))])]),t.safeMode||!1===t.isSupported?t._e():e("fieldset",{staticClass:"maintenance__actions"},[null===t.isLocked?e("loading-spinner",{staticClass:"maintenance__loader"}):t.isLocked?e("loading-button",{staticClass:"widget-button widget-button--primary widget-button--unlock",attrs:{loading:t.loading,disabled:!t.isSupported},on:{click:t.unlock}},[t._v(t._s(t.$t("ui.maintenance.installTool.unlock")))]):e("loading-button",{staticClass:"widget-button widget-button--primary widget-button--lock",attrs:{loading:t.loading,disabled:!t.isSupported},on:{click:t.lock}},[t._v(t._s(t.$t("ui.maintenance.installTool.lock")))])],1)])])])},wn=[],Cn={components:{MessageOverlay:cn,LoadingSpinner:un.A,LoadingButton:R.A},data:function(){return{loading:!1}},computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)(["safeMode"])),(0,k.aH)("contao/install-tool",["isLocked","isSupported"])),{},{overlayMessage:function(t){return t.safeMode?t.$t("ui.maintenance.safeMode"):t.$t("ui.maintenance.unsupported")}}),methods:{unlock:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.loading=!0,e.next=3,t.$store.dispatch("contao/install-tool/unlock");case 3:t.loading=!1;case 4:case"end":return e.stop()}}),e)})))()},lock:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.loading=!0,e.next=3,t.$store.dispatch("contao/install-tool/lock");case 3:t.loading=!1;case 4:case"end":return e.stop()}}),e)})))()}},mounted:function(){this.$store.dispatch("contao/install-tool/fetch")}},yn=Cn,$n=(0,D.A)(yn,kn,wn,!1,null,null,null),An=$n.exports,xn=function(){var t=this,e=t._self._c;return e("message-overlay",{attrs:{message:t.overlayMessage,active:t.safeMode||!t.loading&&!t.supportsJwtCookie&&!t.supportsAccessKey}},[e("section",{staticClass:"maintenance"},[e("div",{staticClass:"maintenance__inside"},[e("figure",{staticClass:"maintenance__image"},[e("img",{attrs:{src:a(6894),alt:""}})]),e("div",{staticClass:"maintenance__about"},[e("h1",[t._v(t._s(t.$t("ui.maintenance.debugMode.title")))]),t.supportsJwtCookie?e("p",[t._v(t._s(t.$t("ui.maintenance.debugMode.descriptionJwt")))]):t.supportsAccessKey?e("i18n",{attrs:{tag:"p",path:"ui.maintenance.debugMode.description"},scopedSlots:t._u([{key:"appDevPhp",fn:function(){return[e("code",[t._v("app_dev.php")])]},proxy:!0}])}):t._e()],1),!t.loading||t.supportsJwtCookie||t.supportsAccessKey?t.supportsJwtCookie?e("fieldset",{staticClass:"maintenance__actions"},[t.hasJwtDebug?e("loading-button",{staticClass:"widget-button widget-button--alert widget-button--hide",attrs:{loading:t.loading},on:{click:t.removeJwtCookie}},[t._v(t._s(t.$t("ui.maintenance.debugMode.deactivate")))]):e("loading-button",{staticClass:"widget-button widget-button--primary widget-button--show",attrs:{loading:t.loading},on:{click:t.enableJwtDebugMode}},[t._v(t._s(t.$t("ui.maintenance.debugMode.activate")))])],1):t.supportsAccessKey?e("fieldset",{staticClass:"maintenance__actions"},[t.hasAccessKey?e("loading-button",{staticClass:"widget-button widget-button--alert widget-button--hide",attrs:{loading:t.loading},on:{click:t.removeAccessKey}},[t._v(t._s(t.$t("ui.maintenance.debugMode.deactivate")))]):e("loading-button",{staticClass:"widget-button widget-button--primary widget-button--show",attrs:{loading:t.loading},on:{click:t.setAccessKey}},[t._v(t._s(t.$t("ui.maintenance.debugMode.activate")))]),t.hasAccessKey?e("loading-button",{staticClass:"widget-button widget-button--edit",attrs:{loading:t.loading},on:{click:t.setAccessKey}},[t._v(t._s(t.$t("ui.maintenance.debugMode.credentials")))]):t._e()],1):t._e():e("fieldset",{staticClass:"maintenance__actions"},[e("loading-spinner",{staticClass:"maintenance__loader"})],1)])])])},Sn=[],Dn={components:{MessageOverlay:cn,LoadingSpinner:un.A,LoadingButton:R.A},data:function(){return{supportsJwtCookie:!1,supportsAccessKey:!1,loading:!0}},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)(["safeMode"])),(0,k.aH)("contao/access-key",{hasAccessKey:"isEnabled"})),(0,k.aH)("contao/jwt-cookie",{hasJwtDebug:"isDebugEnabled"})),{},{overlayMessage:function(t){return t.safeMode?t.$t("ui.maintenance.safeMode"):t.$t("ui.maintenance.unsupported")}}),methods:{enableJwtDebugMode:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.loading=!0,e.next=3,t.$store.dispatch("contao/jwt-cookie/enableDebug");case 3:t.loading=!1;case 4:case"end":return e.stop()}}),e)})))()},removeJwtCookie:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.loading=!0,e.next=3,t.$store.dispatch("contao/jwt-cookie/delete");case 3:t.loading=!1;case 4:case"end":return e.stop()}}),e)})))()},setAccessKey:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:if(a=prompt(t.$t("ui.maintenance.debugMode.user")),a){e.next=3;break}return e.abrupt("return");case 3:if(n=prompt(t.$t("ui.maintenance.debugMode.password")),n){e.next=6;break}return e.abrupt("return");case 6:return t.loading=!0,e.next=9,t.$store.dispatch("contao/access-key/set",{user:a,password:n});case 9:t.loading=!1;case 10:case"end":return e.stop()}}),e)})))()},removeAccessKey:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.loading=!0,e.next=3,t.$store.dispatch("contao/access-key/delete");case 3:t.loading=!1;case 4:case"end":return e.stop()}}),e)})))()}},mounted:function(){var t=this;this.$store.dispatch("contao/jwt-cookie/get").then((function(){t.supportsJwtCookie=!0,t.supportsAccessKey=!1,t.loading=!1}),(function(){return t.$store.dispatch("contao/access-key/get").then((function(){t.supportsJwtCookie=!1,t.supportsAccessKey=!0,t.loading=!1}),(function(){t.supportsJwtCookie=!1,t.supportsAccessKey=!1,t.loading=!1}))}))}},Mn=Dn,On=(0,D.A)(Mn,xn,Sn,!1,null,null,null),Tn=On.exports,jn=function(){var t=this,e=t._self._c;return e("section",{staticClass:"maintenance"},[e("div",{staticClass:"maintenance__inside"},[t._m(0),e("div",{staticClass:"maintenance__about"},[e("h1",[t._v(t._s(t.$t("ui.maintenance.dumpAutoload.title")))]),e("p",[t._v(t._s(t.$t("ui.maintenance.dumpAutoload.description")))])]),e("fieldset",{staticClass:"maintenance__actions"},[e("button",{staticClass:"widget-button widget-button--primary widget-button--update",on:{click:t.execute}},[t._v(t._s(t.$t("ui.maintenance.dumpAutoload.button")))])])])])},Ln=[function(){var t=this,e=t._self._c;return e("figure",{staticClass:"maintenance__image"},[e("img",{attrs:{src:a(16363),alt:""}})])}],Pn={methods:{execute:function(){this.$store.dispatch("tasks/execute",{name:"composer/dump-autoload"})}}},En=Pn,Bn=(0,D.A)(En,jn,Ln,!1,null,null,null),Un=Bn.exports,qn=function(){var t=this,e=t._self._c;return e("section",{staticClass:"maintenance"},[e("div",{staticClass:"maintenance__inside"},[t._m(0),e("div",{staticClass:"maintenance__about"},[e("h1",[t._v(t._s(t.$t("ui.maintenance.composerInstall.title")))]),e("i18n",{attrs:{tag:"p",path:"ui.maintenance.composerInstall.description"},scopedSlots:t._u([{key:"vendor",fn:function(){return[e("code",[t._v("/vendor")])]},proxy:!0},{key:"composerLock",fn:function(){return[e("code",[t._v("composer.lock")])]},proxy:!0}])})],1),e("fieldset",{staticClass:"maintenance__actions"},[e("button-group",{attrs:{label:t.$t("ui.maintenance.composerInstall.button"),type:"primary",icon:"run"},on:{click:t.composerInstall}},[e("link-menu",{attrs:{align:"right",items:t.advancedActions,color:"primary"}})],1)],1)])])},Rn=[function(){var t=this,e=t._self._c;return e("figure",{staticClass:"maintenance__image"},[e("img",{attrs:{src:a(16363),alt:""}})])}],In={components:{ButtonGroup:ma,LinkMenu:Pa.A},computed:{advancedActions:function(){return[{label:this.$t("ui.maintenance.composerInstall.update"),action:this.composerUpdate}]}},methods:{composerInstall:function(){this.$store.dispatch("tasks/execute",{name:"composer/install"})},composerUpdate:function(){this.$store.dispatch("tasks/execute",{name:"composer/update"})}}},Hn=In,Vn=(0,D.A)(Hn,qn,Rn,!1,null,null,null),Fn=Vn.exports,zn=function(){var t=this,e=t._self._c;return e("section",{staticClass:"maintenance"},[e("div",{staticClass:"maintenance__inside"},[t._m(0),e("div",{staticClass:"maintenance__about"},[e("h1",[t._v(t._s(t.$t("ui.maintenance.composerCache.title")))]),e("p",[t._v(t._s(t.$t("ui.maintenance.composerCache.description")))])]),e("fieldset",{staticClass:"maintenance__actions"},[e("button",{staticClass:"widget-button widget-button--primary widget-button--trash",on:{click:t.execute}},[t._v(t._s(t.$t("ui.maintenance.composerCache.button")))])])])])},Nn=[function(){var t=this,e=t._self._c;return e("figure",{staticClass:"maintenance__image"},[e("img",{attrs:{src:a(16363),alt:""}})])}],Jn={methods:{execute:function(){this.$store.dispatch("tasks/execute",{name:"composer/clear-cache"})}}},Wn=Jn,Gn=(0,D.A)(Wn,zn,Nn,!1,null,null,null),Xn=Gn.exports,Qn=function(){var t=this,e=t._self._c;return t.status.opcache_enabled?e("section",{staticClass:"maintenance"},[e("div",{staticClass:"maintenance__inside"},[t._m(0),e("div",{staticClass:"maintenance__about"},[e("h1",[t._v(t._s(t.$t("ui.maintenance.opcodeCache.title")))]),e("p",[t._v(t._s(t.$t("ui.maintenance.opcodeCache.description")))])]),e("fieldset",{staticClass:"maintenance__actions"},[t.loading?e("loading-spinner",{staticClass:"maintenance__loader"}):e("button",{staticClass:"widget-button widget-button--primary widget-button--trash",on:{click:t.execute}},[t._v(t._s(t.$t("ui.maintenance.opcodeCache.button")))])],1)])]):t._e()},Yn=[function(){var t=this,e=t._self._c;return e("figure",{staticClass:"maintenance__image"},[e("img",{attrs:{src:a(5579),alt:""}})])}],Kn={components:{LoadingSpinner:un.A},data:function(){return{opcodeEnabled:!1,loading:!1,status:{opcache_enabled:!1}}},methods:{execute:function(){var t=this;this.loading=!0,this.$store.dispatch("server/opcache/delete",this.status.reset_token).then((function(e){t.loading=!1,t.status=e}))}},mounted:function(){var t=this;this.$store.dispatch("server/opcache/get").then((function(e){t.status=e}),(function(){t.status={opcache_enabled:!1}}))}},Zn=Kn,ts=(0,D.A)(Zn,Qn,Yn,!1,null,null,null),es=ts.exports,as=function(){var t=this,e=t._self._c;return e("message-overlay",{attrs:{message:t.overlayMessage,active:t.safeMode||!t.loading&&!t.supported}},[e("section",{staticClass:"maintenance"},[e("div",{staticClass:"maintenance__inside"},[e("figure",{staticClass:"maintenance__image"},[e("img",{attrs:{src:a(6894),alt:""}})]),e("div",{staticClass:"maintenance__about"},[e("h1",[t._v(t._s(t.$t("ui.maintenance.maintenanceMode.title")))]),e("p",[t._v(t._s(t.$t("ui.maintenance.maintenanceMode.description")))])]),e("fieldset",{staticClass:"maintenance__actions"},[t.loading&&!t.supported?e("loading-spinner",{staticClass:"maintenance__loader"}):t.enabled?e("loading-button",{staticClass:"widget-button widget-button--alert widget-button--maintenance",attrs:{loading:t.loading,disabled:!t.supported},on:{click:t.disableMaintenanceMode}},[t._v(t._s(t.$t("ui.maintenance.maintenanceMode.disable")))]):e("loading-button",{staticClass:"widget-button widget-button--primary widget-button--maintenance",attrs:{loading:t.loading,disabled:!t.supported},on:{click:t.enableMaintenanceMode}},[t._v(t._s(t.$t("ui.maintenance.maintenanceMode.enable")))])],1)])])])},ns=[],ss={components:{MessageOverlay:cn,LoadingSpinner:un.A,LoadingButton:R.A},data:function(){return{loading:!0,supported:!1,enabled:!1}},computed:(0,b.A)((0,b.A)({},(0,k.aH)(["safeMode"])),{},{overlayMessage:function(t){return t.safeMode?t.$t("ui.maintenance.safeMode"):t.$t("ui.maintenance.unsupported")}}),methods:{enableMaintenanceMode:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.loading=!0,e.next=3,t.$store.dispatch("contao/maintenance-mode/enable");case 3:t.enabled=e.sent,t.loading=!1;case 5:case"end":return e.stop()}}),e)})))()},disableMaintenanceMode:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.loading=!0,e.next=3,t.$store.dispatch("contao/maintenance-mode/disable");case 3:t.enabled=e.sent,t.loading=!1;case 5:case"end":return e.stop()}}),e)})))()}},mounted:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n,s;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("server/contao/get");case 2:if(a=e.sent,200!==a.status){e.next=10;break}if(s=Object.keys(null===(n=a.body)||void 0===n||null===(n=n.cli)||void 0===n?void 0:n.commands),t.supported=s.includes("contao:maintenance-mode")||s.includes("lexik:maintenance:lock")&&s.includes("lexik:maintenance:unlock"),!t.supported){e.next=10;break}return e.next=9,t.$store.dispatch("contao/maintenance-mode/isEnabled");case 9:t.enabled=e.sent;case 10:t.loading=!1;case 11:case"end":return e.stop()}}),e)})))()}},is=ss,os=(0,D.A)(is,as,ns,!1,null,null,null),rs=os.exports,cs={components:{MainLayout:Xt,DatabaseStatus:hn,RebuildCache:bn,InstallTool:An,MaintenanceMode:rs,DebugMode:Tn,DumpAutoload:Un,ComposerInstall:Fn,ComposerCache:Xn,OpcodeCache:es}},us=cs,ls=(0,D.A)(us,Ka,Za,!1,null,null,null),ds=ls.exports,ps=function(){var t=this,e=t._self._c;return e("main-layout",[null===t.files?e("loading-spinner",{staticClass:"log-viewer__status log-viewer__status--loader"},[e("p",{staticClass:"log-viewer__title"},[t._v(t._s(t.$t("ui.log-viewer.loading")))])]):t.files&&0===t.files.length?e("div",{staticClass:"log-viewer__status log-viewer__status--empty"},[e("p",{staticClass:"log-viewer__title"},[t._v(t._s(t.$t("ui.log-viewer.empty")))]),e("button",{staticClass:"widget-button widget-button--inline widget-button--update",on:{click:t.load}},[t._v(t._s(t.$t("ui.log-viewer.reload")))])]):e("div",[e("div",{staticClass:"log-viewer__filters"},[e("div",[e("div",{staticClass:"log-viewer__file"},[e("select-menu",{attrs:{options:t.fileOptions,name:"file",label:t.$t("ui.log-viewer.file")},model:{value:t.file,callback:function(e){t.file=e},expression:"file"}}),e("button",{staticClass:"widget-button widget-button--inline widget-button--update",attrs:{title:t.$t("ui.log-viewer.reload")},on:{click:t.load}})],1),e("a",{staticClass:"widget-button widget-button--inline widget-button--download",class:{disabled:!t.file},attrs:{href:"api/logs/".concat(t.file),download:"".concat(t.file,".log"),target:"_blank",title:t.$t("ui.log-viewer.downloadTitle",{file:"".concat(t.file,".log")})}},[t._v(t._s(t.$t("ui.log-viewer.download")))])]),e("div",[e("select-menu",{attrs:{options:t.channelOptions,name:"channel",label:t.$t("ui.log-viewer.channel")},model:{value:t.channel,callback:function(e){t.channel=e},expression:"channel"}}),e("select-menu",{attrs:{options:t.levelOptions,name:"level",label:t.$t("ui.log-viewer.level")},model:{value:t.level,callback:function(e){t.level=e},expression:"level"}})],1)]),e("div",{ref:"list",staticClass:"log-viewer__list"},[e("div",{staticClass:"log-viewer__line log-viewer__line--header"},[e("div",{staticClass:"log-viewer__meta log-viewer__meta--header"},[t._v(t._s(t.$t("ui.log-viewer.timeHeader")))]),e("div",{staticClass:"log-viewer__content log-viewer__content--header"},[t._v(t._s(t.$t("ui.log-viewer.messageHeader")))])]),t.lines?[t._l(t.lines,(function(a,n){return["string"===typeof a?e("div",{key:n,staticClass:"log-viewer__line log-viewer__line--raw"},[t._v(" "+t._s(a)+" ")]):e("div",{key:n,class:"log-viewer__line log-viewer__line--".concat(a.level.toLowerCase())},[e("div",{staticClass:"log-viewer__meta"},[e("time",{staticClass:"log-viewer__datetime",attrs:{datetime:a.datetime}},[t._v(t._s(t._f("datimFormat")(a.datetime,"medium")))]),e("span",{class:"log-viewer__badge log-viewer__badge--desktop log-viewer__badge--level-".concat(a.level.toLowerCase()),attrs:{title:t.$t("ui.log-viewer.levelTitle")}},[t._v(t._s(a.level))]),e("span",{staticClass:"log-viewer__badge log-viewer__badge--desktop log-viewer__badge--channel",attrs:{title:t.$t("ui.log-viewer.channelTitle")}},[t._v(t._s(a.channel))])]),e("div",{staticClass:"log-viewer__content"},[e("div",{staticClass:"log-viewer__message"},t._l(t.pieces(a.message),(function(a,n){return e("span",{key:n},[t._v(t._s(a))])})),0),e("div",{staticClass:"log-viewer__details"},[e("span",{class:"log-viewer__badge log-viewer__badge--mobile log-viewer__badge--level-".concat(a.level.toLowerCase()),attrs:{title:t.$t("ui.log-viewer.levelTitle")}},[t._v(t._s(a.level))]),e("span",{staticClass:"log-viewer__badge log-viewer__badge--mobile log-viewer__badge--channel",attrs:{title:t.$t("ui.log-viewer.channelTitle")}},[t._v(t._s(a.channel))]),t.canShow(a.context)?e("button",{staticClass:"log-viewer__toggle",class:{"log-viewer__toggle--active":t.showContext[n]},on:{click:function(e){return t.toggleContext(n)}}},[t._v(t._s(t.$t("ui.log-viewer.".concat(t.showContext[n]?"hide":"show","Context"))))]):t._e(),t.canShow(a.extra)?e("button",{staticClass:"log-viewer__toggle",class:{"log-viewer__toggle--active":t.showExtra[n]},on:{click:function(e){return t.toggleExtra(n)}}},[t._v(t._s(t.$t("ui.log-viewer.".concat(t.showExtra[n]?"hide":"show","Extra"))))]):t._e()]),t.canShow(a.context)&&t.showContext[n]?e("vue-json-pretty",{staticClass:"log-viewer__json",attrs:{data:a.context,deep:1}}):t._e(),t.canShow(a.extra)&&t.showExtra[n]?e("vue-json-pretty",{staticClass:"log-viewer__json",attrs:{data:a.extra,deep:1}}):t._e()],1)])]}))]:t._e(),t.current&&0!==t.offset?e("div",{staticClass:"log-viewer__line log-viewer__more"},[e("button",{staticClass:"widget-button widget-button--inline widget-button--add",on:{click:t.next}},[t._v(t._s(t.$t("ui.log-viewer.more")))])]):t._e(),t.loading?e("div",{staticClass:"log-viewer__loading"},[e("loading-spinner")],1):t._e()],2)])],1)},hs=[],gs=a(16878),ms=(a(18107),a(67357),a(71761),function(t){var e=["KB","MB","GB"],a="Bytes";while(t>1024)t/=1024,a=e.shift();return"".concat(Math.round(100*t)/100," ").concat(a)}),fs=a(97551),_s=a.n(fs),vs=function(){var t=this,e=t._self._c;return e("div",{staticClass:"widget widget-select",class:{"widget--error":t.error,"widget--required":t.required}},[t.label?e("label",{attrs:{for:"ctrl_"+t.name}},[t._v(t._s(t.label))]):t._e(),e("select",{ref:"input",attrs:{id:t.label?"ctrl_"+t.name:"",name:t.name,disabled:t.disabled,required:t.required},on:{change:function(e){return t.input(e.target.value)}}},[t.includeBlank?e("option",{attrs:{value:""}},[t._v(t._s(t.$t("ui.widget.blankOption")))]):t._e(),t._l(t.options,(function(a,n){return[a.options?e("optgroup",{key:n,attrs:{label:a.label}},t._l(a.options,(function(a){return e("option",{key:a.value,attrs:{disabled:a.disabled},domProps:{value:a.value,selected:a.value===t.value}},[t._v(t._s(a.label))])})),0):e("option",{key:a.value,attrs:{disabled:a.disabled},domProps:{value:a.value,selected:a.value===t.value}},[t._v(t._s(a.label))])]}))],2),t.error?e("p",{staticClass:"widget__error"},[t._v(t._s(t.error))]):t._e()])},bs=[],ks={props:{name:{type:String,required:!0},options:{type:Array,required:!0},label:String,value:String,disabled:Boolean,required:Boolean,error:String,includeBlank:Boolean},methods:{input:function(t){this.$emit("input",t)}},mounted:function(){this.$emit("input",this.$refs.input.value)},updated:function(){this.$emit("input",this.$refs.input.value)}},ws=ks,Cs=(0,D.A)(ws,vs,bs,!1,null,null,null),ys=Cs.exports,$s={components:{MainLayout:Xt,LoadingSpinner:un.A,SelectMenu:ys,VueJsonPretty:_s()},data:function(){return{files:null,loading:!1,file:null,offset:0,limit:100,content:[],channel:"",level:"",showContext:{},showExtra:{}}},computed:{channelOptions:function(t){return t.countOptions("channel")},levelOptions:function(t){return t.countOptions("level",{emergency:0,alert:0,critical:0,error:0,warning:0,notice:0,info:0,debug:0})},fileOptions:function(){var t=this;if(!this.files)return[];var e={},a=[];return this.files.forEach((function(n){var s=n.name.match(/^([a-z]+)-(\d{4}-\d{2}-\d{2})$/i);s?(e[s[1]]||(e[s[1]]={label:t.$te("ui.log-viewer.".concat(s[1],"Environment"))?t.$t("ui.log-viewer.".concat(s[1],"Environment")):s[1],options:[]}),e[s[1]].options.push({value:n.name,label:"".concat((0,Pt.A)(s[2],null,"long")," (").concat(ms(n.size),")")})):a.push({value:n.name,label:"".concat(n.name," (").concat(ms(n.size),")")})})),[].concat((0,gs.A)(Object.values(e)),a)},current:function(t){var e;return null===(e=t.files)||void 0===e?void 0:e.find((function(e){return e.name===t.file}))},lines:function(t){var e;return null===(e=t.content)||void 0===e?void 0:e.filter((function(e){return"string"===typeof e||(!t.channel||e.channel===t.channel)&&(!t.level||e.level.toLowerCase()===t.level)})).reverse()}},methods:{canShow:function(t){return t&&(!Array.isArray(t)||t.length)},pieces:function(t){for(var e=[],a=t.split(' "'),n=a.length-1,s=0,i=0;i<=n;i++){var o=a[i];if(0!==s)while(s>0){while(!a[i].includes('"')&&i!==n)o="".concat(o,' "').concat(a[i+1]),s++,i++;if(s--,0===s){e[e.length-1]+=' "';var r=o.indexOf('" ')||o.lastIndexOf('"');e.push(o.slice(0,r)),e.push(o.slice(r)),s++;break}}else e.push(o),s++}return e},toggleContext:function(t){this.$set(this.showContext,t,!this.showContext[t])},toggleExtra:function(t){this.$set(this.showExtra,t,!this.showExtra[t])},countOptions:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return this.content.forEach((function(a){"string"!==typeof a&&(e[a[t].toLowerCase()]||(e[a[t].toLowerCase()]=0),e[a[t].toLowerCase()]+=1)})),[{label:"all",value:""}].concat(Object.keys(e).map((function(t){return{value:t,label:"".concat(t.at(0).toUpperCase()).concat(t.slice(1)," (").concat(e[t],")")}})))},next:function(){this.limit=Math.min(this.offset,100),this.offset=Math.max(this.offset-100,0)},load:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return n=t.file,t.files=null,t.file=null,e.next=5,t.$http.get("api/logs");case 5:t.files=e.sent.body,t.file=(null===(a=t.files.find((function(t){return t.name===n})))||void 0===a?void 0:a.name)||(t.files.length?t.files[0].name:null);case 7:case"end":return e.stop()}}),e)})))()},fetch:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:if(t.current){e.next=2;break}return e.abrupt("return");case 2:return t.loading=!0,e.next=5,t.$http.get("api/logs/".concat(t.current.name,"?offset=").concat(t.offset,"&limit=").concat(t.limit));case 5:a=e.sent.body,t.content=t.content.concat(Array.from(a.content.reverse())),t.loading=!1;case 8:case"end":return e.stop()}}),e)})))()}},watch:{file:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.content=[],t.channel="",t.level="",t.showContext={},t.showExtra={},t.limit=100,t.offset=t.current?Math.max(t.current.lines-100,0):0,e.next=9,t.fetch();case 9:case"end":return e.stop()}}),e)})))()},offset:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.fetch();case 2:case"end":return e.stop()}}),e)})))()}},created:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.load();case 2:case"end":return e.stop()}}),e)})))()}},As=$s,xs=(0,D.A)(As,ps,hs,!1,null,null,null),Ss=xs.exports;l.Ay.use(m.Ay);var Ds=new m.Ay({routes:[{name:f.discover.name,path:"/discover",component:me},{name:f.packages.name,path:"/packages",component:Ra},{name:f.oauth.name,path:"/oauth",component:Ya,props:!0},{name:f.maintenance.name,path:"/maintenance",component:ds},{name:f.logViewer.name,path:"/logs",component:Ss},{path:"*",redirect:"/discover"}]});Ds.afterEach((function(){document.body.classList.remove("nav-active")}));var Ms=Ds,Os=a(50266);l.Ay.filter("datimFormat",Pt.A),l.Ay.filter("numberFormat",Os.A),l.Ay.filter("filesize",ms);var Ts=function(){var t=this,e=t._self._c;return e("div",{attrs:{id:"app"}},[t.safeMode&&"ready"===t.view?e("div",{staticClass:"safe-mode"},[e("strong",{staticClass:"safe-mode__headline"},[t._v(t._s(t.$t("ui.app.safeModeHeadline")))]),t._v("  "),e("span",{staticClass:"safe-mode__description"},[t._v(t._s(t.$t("ui.app.safeModeDescription")))]),t._v("  "),e("a",{staticClass:"safe-mode__link",attrs:{href:"javascript:window.location.reload()"}},[t._v(t._s(t.$t("ui.app.safeModeExit")))])]):t.isInsecure?e("div",{staticClass:"https-warning"},[e("strong",{staticClass:"https-warning__headline"},[t._v(t._s(t.$t("ui.app.httpsHeadline")))]),t._v("  "),e("span",{staticClass:"https-warning__description"},[t._v(t._s(t.$t("ui.app.httpsDescription")))]),t._v("  "),e("a",{staticClass:"https-warning__link",attrs:{href:t.$t("ui.app.httpsHref"),target:"_blank"}},[t._v(t._s(t.$t("ui.app.httpsLink")))])]):t._e(),t.error?e("error-view"):t._e(),e("transition",{staticStyle:{height:"100%"},attrs:{name:"animate-fade",mode:"out-in"}},[t.isInitializing||t.isReady?e("div",{staticClass:"view-init"},[e("div",{staticClass:"view-init__cell animate-initializing"},[e("img",{attrs:{src:a(6894),width:"100",height:"100",alt:"Contao Logo"}}),e("p",{staticClass:"view-init__message"},[t._v(t._s(t.$t("ui.app.loading")))])])]):t.username&&t.taskStatus?e("task-view",{class:t.hasModal?"animate-blur-in":"animate-blur-out"}):t.currentView?e(t.currentView,{tag:"component",class:t.hasModal?"animate-blur-in":"animate-blur-out"}):e("div",[e("router-view",{class:t.hasModal?"animate-blur-in":"animate-blur-out"})],1)],1),t.hasModal?e(t.currentModal,{tag:"component"}):t._e()],1)},js=[],Ls=(a(25440),function(){var t=this,e=t._self._c;return e("package-details",{attrs:{local:t.data,dependents:t.dependents},scopedSlots:t._u([{key:"package-actions",fn:function(){return[t._t("package-actions",(function(){return[t.isInstalled?[!t.isFeature&&t.isVisible?e("package-constraint",{attrs:{data:t.data}}):t._e(),e("p",{staticClass:"package-popup__installed"},[e("strong",[t._v(t._s(t.$t("ui.package.installed")))]),t.installedTime?e("time",{attrs:{dateTime:t.installedTime,title:t._f("datimFormat")(t.installedTime)}},[t._v(t._s(t.$t("ui.package.version",{version:t.installedVersion})))]):[t._v(t._s(t.$t("ui.package.version",{version:t.installedVersion})))]],2)]:t.canBeInstalled||t.isRequired?[e("install-button",{attrs:{data:t.data}}),t.isAdded||t.isRequired?e("package-constraint",{attrs:{data:t.data}}):t._e()]:t.isPrivate?e("a",{staticClass:"widget-button widget-button--primary widget-button--link",attrs:{target:"_blank",href:t.metadata.homepage}},[t._v(t._s(t.$t("ui.package.homepage")))]):e("div")]}))]},proxy:!0},t.metadata.update&&t.metadata.update.valid&&!t.metadata.update.latest?{key:"package-update",fn:function(){return[e("p",{staticClass:"package-popup__update"},[e("strong",[t._v(t._s(t.$t("ui.package.update"))+":")]),t._v(" "+t._s(t.$t("ui.package.version",{version:t.metadata.update.version}))+" ("+t._s(t.$t("ui.package-details.released"))+" "+t._s(t._f("datimFormat")(t.metadata.update.time,"short","long"))+")")])]},proxy:!0}:t.isCompatible?null:{key:"package-update",fn:function(){return[e("p",{staticClass:"package-popup__incompatible"},[t._v(t._s(t.$t("ui.package.incompatible",{package:t.data.name,constraint:t.packageConstraint("contao/manager-bundle")})))])]},proxy:!0},{key:"suggest-actions",fn:function(a){var n=a.name;return[t.packageSuggested(n)?e("install-button",{attrs:{inline:"",small:"",data:{name:n}}}):t._e()]}},{key:"features-actions",fn:function(a){var n=a.name;return[!t.hasRoot||t.packageInstalled(n)||t.packageRoot(n)?t._e():e("install-button",{attrs:{inline:"",small:"",data:{name:n}}})]}}],null,!0)})}),Ps=[],Es=a(83),Bs={mixins:[te],components:{PackageConstraint:ua,PackageDetails:Es.A,InstallButton:de},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("packages",{allInstalled:"installed"})),(0,k.aH)("packages/details",["current"])),(0,k.L8)("packages",["packageConstraint"])),{},{data:function(t){return t.add[t.current]||t.allInstalled[t.current]||{name:t.current}},dependents:function(){var t,e=this;if(null===(t=this.allInstalled[this.data.name])||void 0===t||!t.dependents)return null;var a={},n=["requires","replaces","provides","conflicts"];return Object.values(this.allInstalled[this.data.name].dependents).forEach((function(t){if("__root__"!==t.source&&n.includes(t.description)&&(t.source!==e.data.name||"replaces"!==t.description)){var s=e.$t("ui.package-details.link".concat(t.description[0].toUpperCase()).concat(t.description.slice(1))),i=t.target;i===e.data.name&&e.metadata&&e.metadata.title&&(i=e.metadata.title),a[t.source]="".concat(s," ").concat(i," ").concat(t.constraint)}})),a}})},Us=Bs,qs=(0,D.A)(Us,Ls,Ps,!1,null,null,null),Rs=qs.exports,Is=function(){var t=this,e=t._self._c;return e("div",{staticClass:"view-error"},[e("div",{staticClass:"view-error__content"},[e("svg",{staticClass:"view-error__icon",attrs:{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 512 512"}},[e("path",{attrs:{d:"M473.7 73.8l-2.4-2.5c-46-47-118-51.7-169.6-14.8L336 159.9l-96 64 48 128-144-144 96-64-28.6-86.5C159.7 19.6 87 24 40.7 71.4l-2.4 2.4C-10.4 123.6-12.5 202.9 31 256l212.1 218.6c7.1 7.3 18.6 7.3 25.7 0L481 255.9c43.5-53 41.4-132.3-7.3-182.1z"}})]),e("div",{staticClass:"view-error__status"},[t._v("ERROR "),t.error.status?e("a",{attrs:{href:"https://httpstatuses.com/"+t.error.status,target:"_blank"}},[t._v(" "+t._s(t.error.status))]):t._e()]),e("h1",{staticClass:"view-error__headline"},[t._v(t._s(t.title))]),t.detail?e("div",{staticClass:"view-error__details"},[t._v(t._s(t.detail))]):t._e(),t.debug?e("div",{staticClass:"view-error__debug"},[t._v(t._s(t.debug))]):t._e(),e("div",{staticClass:"view-error__actions"},["about:blank"!==t.error.type?e("a",{staticClass:"view-error__link",attrs:{href:t.error.type,target:"_blank"}},[t._v(t._s(t.$t("ui.error.moreLink")))]):t._e(),e("a",{staticClass:"view-error__link view-error__link--support",attrs:{href:"https://to.contao.org/support?lang=".concat(t.$i18n.locale),target:"_blank"}},[t._v(t._s(t.$t("ui.error.support")))])])])])},Hs=[],Vs={computed:(0,b.A)((0,b.A)({},(0,k.aH)(["error"])),{},{request:function(t){return t.error.request},response:function(t){return t.error.response},title:function(){return this.error.title?this.error.title:this.request?this.$t("ui.error.title",{method:this.request.headers.get("X-HTTP-Method-Override")||this.request.method,url:this.request.url}):this.$t("ui.app.apiError")},detail:function(){return this.error.detail?this.error.detail:this.error.debug?"":500===this.error.status?this.$t("ui.error.server500"):this.response?this.$t("ui.error.response",this.error):""},debug:function(){return this.error.debug?this.error.debug:this.response&&this.response.body?this.response.body:""}})},Fs=Vs,zs=(0,D.A)(Fs,Is,Hs,!1,null,null,null),Ns=zs.exports,Js=function(){var t=this,e=t._self._c;return e("boxed-layout",{attrs:{wide:!0,slotClass:"view-account"}},[e("header",{staticClass:"view-account__header"},[e("img",{attrs:{src:a(6894),width:"100",height:"100",alt:"Contao Logo"}}),e("p",{staticClass:"view-account__product"},[e("strong",[t._v(t._s(t.$t("ui.account.welcome")))]),t._v(" Contao Manager 1.8.9 ")]),e("p",[e("i18n",{attrs:{tag:!1,path:"ui.account.intro1"},scopedSlots:t._u([{key:"readTheManualToGetStarted",fn:function(){return[e("i18n",{attrs:{tag:"strong",path:"ui.account.introGetStarted"},scopedSlots:t._u([{key:"readTheManual",fn:function(){return[e("a",{attrs:{href:"https://to.contao.org/docs/contao-manager?lang=".concat(t.$i18n.locale),target:"_blank"}},[t._v(t._s(t.$t("ui.account.introManual")))])]},proxy:!0}])})]},proxy:!0}])}),e("br"),e("br"),e("i18n",{attrs:{tag:!1,path:"ui.account.intro2"},scopedSlots:t._u([{key:"ourGithubIssues",fn:function(){return[e("a",{attrs:{href:"https://github.com/contao/contao-manager/issues",target:"_blank"}},[t._v(t._s(t.$t("ui.account.introIssues")))])]},proxy:!0}])})],1)]),e("main",{staticClass:"view-account__form"},[e("form",{on:{submit:function(e){return e.preventDefault(),t.createAccount.apply(null,arguments)}}},[e("h1",{staticClass:"view-account__headline"},[t._v(t._s(t.$t("ui.account.headline")))]),e("p",{staticClass:"view-account__description"},[t._v(t._s(t.$t("ui.account.description")))]),e("fieldset",{staticClass:"view-account__fields"},[e("text-field",{ref:"username",attrs:{name:"username",label:t.$t("ui.account.username"),disabled:t.installing,required:""},model:{value:t.username,callback:function(e){t.username=e},expression:"username"}}),e("text-field",{ref:"password",attrs:{name:"password",type:"password",label:t.$t("ui.account.password"),placeholder:t.$t("ui.account.passwordPlaceholder"),disabled:t.installing,required:"",pattern:".{8,}",error:t.errors.password},on:{blur:t.validatePassword},model:{value:t.password,callback:function(e){t.password=e},expression:"password"}}),e("loading-button",{attrs:{submit:"",color:"primary",disabled:!t.valid,loading:t.installing}},[t._v(t._s(t.$t("ui.account.submit")))])],1)])]),e("aside",{staticClass:"view-account__contribute"},[e("p",[t._v(" "+t._s(t.$t("ui.account.contribute1"))),e("br"),e("i18n",{attrs:{tag:!1,path:"ui.account.contribute2"},scopedSlots:t._u([{key:"donate",fn:function(){return[e("a",{attrs:{href:"https://to.contao.org/donate",target:"_blank"}},[t._v(t._s(t.$t("ui.account.contributeDonate")))])]},proxy:!0}])})],1)])])},Ws=[],Gs=function(){var t=this,e=t._self._c;return e("div",{staticClass:"widget widget-text",class:(0,ne.A)((0,ne.A)((0,ne.A)((0,ne.A)({},"widget-text--".concat(t.type),!!t.type),"widget--error",t.error),"widget--validate",t.validate&&!t.error),"widget--required",t.required)},[t.label?e("label",{attrs:{for:"ctrl_"+t.name}},[t._v(t._s(t.label))]):t._e(),e("input",{ref:"input",attrs:{type:t.inputType,id:t.label?"ctrl_"+t.name:"",name:t.name,placeholder:t.validate?t.placeholder||" ":t.placeholder,required:t.required,pattern:t.pattern,disabled:t.disabled,autocapitalize:t.autocapitalize||"none"},domProps:{value:t.value},on:{input:function(e){return t.input(e.target.value)},keyup:function(e){return t.$emit("keyup")},focus:function(e){return t.$emit("focus")},blur:function(e){return t.$emit("blur")}}}),"password"===t.type?e("button",{staticClass:"widget__password-toggle",class:{"widget__password-toggle--visible":t.showPassword,"widget__password-toggle--hidden":!t.showPassword},attrs:{type:"button",title:t.$t("ui.widget.".concat(t.showPassword?"hidePassword":"showPassword"))},on:{click:t.togglePassword}},[e("svg",{attrs:{height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"}},[e("path",{attrs:{d:"M0 0h24v24H0z",fill:"none"}}),e("path",{attrs:{d:"M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"}})])]):t._e(),t.error?e("p",{staticClass:"widget__error"},[t._v(t._s(t.error))]):t._e()])},Xs=[],Qs={props:{type:{type:String,validator:function(t){return["text","tel","email","url","password","search"].includes(t)}},name:{type:String,required:!0},label:String,value:String,pattern:String,placeholder:String,disabled:Boolean,required:Boolean,validate:Boolean,error:String,autocapitalize:String},data:function(){return{showPassword:!1}},computed:{inputType:function(){return"password"===this.type&&this.showPassword?"text":this.type?this.type:"text"}},methods:{input:function(t){this.$emit("input",t)},enter:function(){this.$emit("enter")},focus:function(){this.$refs.input.focus()},checkValidity:function(){return this.$refs.input.checkValidity()},togglePassword:function(){this.showPassword=!this.showPassword,this.focus()}},mounted:function(){this.$emit("input",this.$refs.input.value)}},Ys=Qs,Ks=(0,D.A)(Ys,Gs,Xs,!1,null,null,null),Zs=Ks.exports,ti={components:{BoxedLayout:Wa,TextField:Zs,LoadingButton:R.A},data:function(){return{username:"",password:"",errors:{password:""},installing:!1,valid:!1}},methods:{validate:function(){this.valid=this.$refs.username.checkValidity()&&this.$refs.password.checkValidity()},validatePassword:function(){this.errors.password=null,""!==this.password&&this.password.length<8&&(this.errors.password=this.$t("ui.account.passwordLength"))},createAccount:function(){var t=this;this.valid&&(this.installing=!0,this.$store.dispatch("auth/login",{username:this.username,password:this.password}).then((function(e){e?t.$store.commit("setView",A.BOOT):t.$store.commit("apiError")})))}},watch:{username:function(){this.validate()},password:function(){this.validate()}},mounted:function(){this.$refs.username&&this.$refs.username.focus()}},ei=ti,ai=(0,D.A)(ei,Js,Ws,!1,null,null,null),ni=ai.exports,si=function(){var t=this,e=t._self._c;return e("boxed-layout",{attrs:{slotClass:"view-login"}},[e("header",{staticClass:"view-login__header"},[e("img",{attrs:{src:a(6894),width:"80",height:"80",alt:"Contao Logo"}}),e("p",{staticClass:"view-login__product"},[t._v("Contao Manager")])]),t.locked?e("main",{staticClass:"view-login__locked"},[e("i18n",{attrs:{tag:"p",path:"ui.login.locked"},scopedSlots:t._u([{key:"lockFile",fn:function(){return[e("strong",[t._v("contao-manager/login.lock")]),e("br")]},proxy:!0}],null,!1,3190432954)})],1):e("main",{staticClass:"view-login__form"},[e("form",{on:{submit:function(e){return e.preventDefault(),t.login.apply(null,arguments)}}},[e("h1",{staticClass:"view-login__headline"},[t._v(t._s(t.$t("ui.login.headline")))]),e("p",{staticClass:"view-login__description"},[t._v(t._s(t.$t("ui.login.description")))]),e("text-field",{ref:"username",staticClass:"view-login__user",class:t.login_failed?"widget--error":"",attrs:{name:"username",label:t.$t("ui.login.username"),placeholder:t.$t("ui.login.username"),disabled:t.logging_in},on:{input:t.reset},model:{value:t.username,callback:function(e){t.username=e},expression:"username"}}),e("text-field",{staticClass:"view-login__password",class:t.login_failed?"widget--error":"",attrs:{type:"password",name:"password",label:t.$t("ui.login.password"),placeholder:t.$t("ui.login.password"),disabled:t.logging_in},on:{input:t.reset},model:{value:t.password,callback:function(e){t.password=e},expression:"password"}}),e("loading-button",{staticClass:"view-login__button",attrs:{submit:"",color:"primary",disabled:!t.inputValid||t.login_failed,loading:t.logging_in}},[t._v(" "+t._s(t.$t("ui.login.button"))+" ")]),e("a",{staticClass:"view-login__link",attrs:{href:"https://to.contao.org/docs/manager-password?lang=".concat(t.$i18n.locale),target:"_blank"}},[t._v(t._s(t.$t("ui.login.forgotPassword")))])],1)])])},ii=[],oi={components:{BoxedLayout:Wa,TextField:Zs,LoadingButton:R.A},data:function(){return{username:"",password:"",logging_in:!1,login_failed:!1}},computed:(0,b.A)((0,b.A)({},(0,k.aH)(["locked"])),{},{inputValid:function(){return""!==this.username&&""!==this.password&&this.password.length>=8}}),methods:{login:function(){var t=this;this.inputValid&&(this.logging_in=!0,this.$store.dispatch("auth/login",{username:this.username,password:this.password}).then((function(e){e?t.$store.commit("setView",A.BOOT):(t.logging_in=!1,t.login_failed=!0)})))},reset:function(){this.login_failed=!1}},mounted:function(){this.$store.commit("setError",null),this.$refs.username&&this.$refs.username.focus()}},ri=oi,ci=(0,D.A)(ri,si,ii,!1,null,null,null),ui=ci.exports,li=(a(50778),function(){var t=this,e=t._self._c;return e("boxed-layout",{attrs:{wide:!0,slotClass:"view-task"}},[e("header",{staticClass:"view-task__header"},[e("img",{staticClass:"view-task__icon",attrs:{src:a(52228),width:"80",height:"80",alt:""}}),e("h1",{staticClass:"view-task__headline"},[t._v(t._s(t.$t("ui.task.headline")))]),t.taskStatus?e("p",{staticClass:"view-task__description"},[t._v(t._s(t.$t("ui.task.".concat(t.taskStatus))))]):t._e(),t.isFailed&&!t.awaitTask?[e("p",{staticClass:"view-task__text"},[t._v(" "+t._s(t.$t("ui.task.failedDescription1"))),e("br"),t._v(" "+t._s(t.$t("ui.task.failedDescription2"))+" ")]),e("p",{staticClass:"view-task__text"},[e("br"),e("a",{attrs:{href:"https://github.com/contao/contao-manager/issues/new",target:"_blank"}},[t._v(t._s(t.$t("ui.task.reportProblem")))])]),e("div",{staticClass:"view-task__actions"},[e("loading-button",{staticClass:"view-task__action",attrs:{loading:t.deletingTask},on:{click:t.deleteTask}},[t._v(t._s(t.$t("ui.task.buttonClose")))])],1)]:t.hasTask&&!t.awaitTask?[e("div",{staticClass:"view-task__actions"},[t.allowCancel&&(t.isActive||t.isAborting)?e("loading-button",{staticClass:"view-task__action",attrs:{color:"alert",loading:t.isAborting},on:{click:t.cancelTask}},[t._v(t._s(t.$t("ui.task.buttonCancel")))]):t._e(),t.requiresAudit?e("loading-button",{staticClass:"view-task__action",attrs:{color:"primary",loading:t.loadingMigrations,disabled:t.supportsMigrations&&!t.hasDatabaseChanges||t.deletingTask},on:{click:t.updateDatabase}},[t._v(t._s(t.$t("ui.task.buttonAudit")))]):t._e(),t.isActive||t.isAborting?t._e():e("loading-button",{staticClass:"view-task__action",attrs:{loading:t.deletingTask},on:{click:t.deleteTask}},[t._v(t._s(t.$t("ui.task.buttonConfirm")))]),t.isActive&&t.allowAutoClose?e("check-box",{attrs:{name:"autoclose",label:t.$t("ui.task.autoclose")},model:{value:t.autoClose,callback:function(e){t.autoClose=e},expression:"autoClose"}}):t._e()],1)]:e("div",{staticClass:"view-task__loading"},[e("loading-spinner")],1)],2),t.hasTask?e("console-output",{staticClass:"view-task__main",attrs:{title:t.hasTask?t.currentTask.title:t.$t("ui.task.loading"),operations:t.currentTask.operations,"console-output":t.currentTask.console,"show-console":t.showConsole},on:{"update:showConsole":function(e){t.showConsole=e},"update:show-console":function(e){t.showConsole=e}}}):t._e(),t.currentTask.sponsor?e("div",{staticClass:"view-task__sponsor"},[e("i18n",{attrs:{path:"ui.task.sponsor",tag:!1},scopedSlots:t._u([{key:"sponsor",fn:function(){return[e("br"),e("a",{attrs:{href:t.currentTask.sponsor.link,target:"_blank",rel:"noreferrer noopener"}},[t._v(t._s(t.currentTask.sponsor.name))])]},proxy:!0}],null,!1,342915398)}),e("a",{staticClass:"view-task__donate",attrs:{href:"https://to.contao.org/donate",target:"_blank",rel:"noreferrer noopener"}},[e("img",{attrs:{src:a(13382),alt:"",width:"20",height:"20"}})])],1):t._e()],1)}),di=[],pi={computed:(0,b.A)((0,b.A)({},(0,k.aH)("tasks",{taskStatus:"status",currentTask:"current",deletingTask:"deleting",awaitTask:"await"})),{},{hasTask:function(t){return t.currentTask&&t.currentTask.status},isActive:function(t){return t.hasTask&&"active"===t.taskStatus},isComplete:function(t){return t.hasTask&&"complete"===t.taskStatus},isAborting:function(t){return t.hasTask&&"aborting"===t.taskStatus},isFailed:function(t){return"failed"===t.taskStatus},isError:function(t){return t.hasTask&&("error"===t.taskStatus||"stopped"===t.taskStatus||"failed"===t.taskStatus)},allowAutoClose:function(t){return t.hasTask&&t.currentTask.autoclose},allowCancel:function(t){return t.hasTask&&t.currentTask.cancellable},requiresAudit:function(t){return t.isComplete&&t.currentTask.audit}})},hi=function(){var t=this,e=t._self._c;return e("div",{staticClass:"console"},[e("section",{staticClass:"console__header"},[e("div",[e("h1",{staticClass:"console__headline"},[t._v(t._s(t.title))]),t.description?e("p",{staticClass:"console__description"},[t._v(t._s(t.description))]):t._e()]),e("div",{staticClass:"console__actions"},[t.forceConsole?t._e():e("button",{staticClass:"widget-button widget-button--transparent widget-button--console console__action",class:{"console__action--active":t.showConsole},attrs:{title:t.$t("ui.console.toggle")},on:{click:function(e){return t.$emit("update:showConsole",!t.showConsole)}}}),e("button-menu",{attrs:{transparent:"","button-class":"console__action"}},[e("button",{on:{click:t.showLog}},[t._v(t._s(t.$t("ui.console.showLog")))]),e("button",{directives:[{name:"clipboard",rawName:"v-clipboard",value:t.consoleOutput,expression:"consoleOutput"}]},[t._v(t._s(t.$t("ui.console.copyLog")))])])],1)]),e("div",{staticClass:"console__operations"},[t._l(t.operations,(function(a,n){return[e("console-operation",t._b({key:n,attrs:{"show-console":t.showConsole,"force-console":t.forceConsole}},"console-operation",a,!1))]}))],2)])},gi=[],mi=function(){var t=this,e=t._self._c;return e("div",{staticClass:"button-menu"},[e("button",{class:t.classes,on:{click:t.toggle}}),e("div",{directives:[{name:"show",rawName:"v-show",value:t.showMenu,expression:"showMenu"}],ref:"menu",staticClass:"button-menu__menu",attrs:{tabindex:"-1"},on:{blur:t.close,click:t.close}},[t._t("default")],2)])},fi=[],_i={name:"ButtonMenu",props:{buttonClass:String,type:String,icon:{type:String,default:"more"},transparent:Boolean,disabled:Boolean},data:function(){return{showMenu:!1}},computed:{classes:function(){var t="widget-button widget-button--".concat(this.icon," button-menu__button ").concat(this.buttonClass);return this.type&&(t+=" widget-button--".concat(this.type)),this.transparent&&(t+=" widget-button--transparent"),t}},methods:{open:function(){var t=this;this.showMenu=!0,this.$nextTick((function(){return t.$refs.menu.focus()}))},close:function(){var t=this;this.$refs.menu.blur(),setTimeout((function(){t.showMenu=!1}),300)},toggle:function(){this.showMenu?this.close():this.open()}}},vi=_i,bi=(0,D.A)(vi,mi,fi,!1,null,null,null),ki=bi.exports,wi=function(){var t=this,e=t._self._c;return e(t.console&&!t.forceConsole?"details":"div",{ref:"details",tag:"component",staticClass:"console-operation",on:{toggle:t.toggleConsole}},[e(t.console&&!t.forceConsole?"summary":"div",{tag:"component",staticClass:"console-operation__summary",class:{"console-operation__summary--console":!!t.console}},[e("div",{staticClass:"console-operation__status"},[t.isActive?e("svg",{staticClass:"console-operation__icon console-operation__icon--active",attrs:{width:"18",height:"18",fill:"none",xmlns:"http://www.w3.org/2000/svg",stroke:"#dbab0a"}},[e("g",{attrs:{fill:"none",fillrule:"evenodd"}},[e("g",{attrs:{transform:"translate(1 1)","stroke-width":"2"}},[e("circle",{attrs:{opacity:".5",cx:"8",cy:"8",r:"7"}}),e("path",{attrs:{d:" M 15 8 A 7 7 0 0 1 8 15"}})])]),e("path",{attrs:{"fill-rule":"evenodd",d:"M9 5a4 4 0 100 8 4 4 0 000-8z"}})]):t.isSuccess?e("svg",{staticClass:"console-operation__icon console-operation__icon--success",attrs:{viewBox:"0 0 16 16",width:"16",height:"16","aria-hidden":"true"}},[e("path",{attrs:{"fill-rule":"evenodd",d:"M13.78 4.22a.75.75 0 010 1.06l-7.25 7.25a.75.75 0 01-1.06 0L2.22 9.28a.75.75 0 011.06-1.06L6 10.94l6.72-6.72a.75.75 0 011.06 0z"}})]):t.isError||t.isStopped?e("svg",{staticClass:"console-operation__icon console-operation__icon--error",attrs:{viewBox:"0 0 16 16",width:"16",height:"16","aria-hidden":"true"}},[e("path",{attrs:{"fill-rule":"evenodd",d:"M3.72 3.72a.75.75 0 011.06 0L8 6.94l3.22-3.22a.75.75 0 111.06 1.06L9.06 8l3.22 3.22a.75.75 0 11-1.06 1.06L8 9.06l-3.22 3.22a.75.75 0 01-1.06-1.06L6.94 8 3.72 4.78a.75.75 0 010-1.06z"}})]):t.isSkipped?e("svg",{staticClass:"console-operation__icon console-operation__icon--skipped",attrs:{viewBox:"0 0 16 16",width:"16",height:"16","aria-hidden":"true"}},[e("path",{attrs:{"fill-rule":"evenodd",d:"M8 4a4 4 0 100 8 4 4 0 000-8z"}})]):e("svg",{staticClass:"console-operation__icon console-operation__icon--pending",attrs:{viewBox:"0 0 16 16",width:"16",height:"16","aria-hidden":"true"}},[e("path",{attrs:{"fill-rule":"evenodd",d:"M8 4a4 4 0 100 8 4 4 0 000-8z"}})])]),e("div",{staticClass:"console-operation__label"},[Array.isArray(t.summary)?[t._l(t.summary,(function(a,n){return[e("h2",{key:"".concat(n,"_title"),staticClass:"console-operation__title",class:{"console-operation__title--disabled":a.match(/^~.+~$/)}},[t._v(t._s(a.replace(/^~(.+)~$/,"$1")))]),t.details[n]?e("p",{key:"".concat(n,"_details"),staticClass:"console-operation__description"},[t._v(t._s(t.details[n]))]):t._e(),e("br",{key:"".concat(n,"_br")})]}))]:[e("h2",{staticClass:"console-operation__title",class:{"console-operation__title--disabled":t.summary.match(/^~.+~$/)}},[t._v(t._s(t.summary.replace(/^~(.+)~$/,"$1")))]),t.details?e("p",{staticClass:"console-operation__description"},[t._v(t._s(t.details))]):t._e()]],2)]),t.console?e("div",{staticClass:"console-operation__console"},[e("button",{directives:[{name:"show",rawName:"v-show",value:!t.isScrolledTop,expression:"!isScrolledTop"}],staticClass:"console-operation__scroll console-operation__scroll--top",on:{click:t.scrollToTop}},[e("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",height:"24",viewBox:"0 0 24 24",width:"24"}},[e("path",{attrs:{d:"M0 0h24v24H0z",fill:"none"}}),e("path",{attrs:{d:"M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"}})])]),e("div",{ref:"console",staticClass:"console-operation__lines",on:{scroll:t.scrolled}},[t._l(t.consoleLines,(function(a,n){return[e("div",{key:n,staticClass:"console-operation__line",attrs:{"data-index":n}},[e("span",{staticClass:"console-operation__line-number"},[t._v(t._s(n+1))]),e("span",{staticClass:"console-operation__line-content"},[t._v(t._s(a))])])]}))],2),e("button",{directives:[{name:"show",rawName:"v-show",value:!t.isScrolledBottom,expression:"!isScrolledBottom"}],staticClass:"console-operation__scroll console-operation__scroll--bottom",on:{click:t.scrollToBottom}},[e("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",height:"24",viewBox:"0 0 24 24",width:"24"}},[e("path",{attrs:{d:"M0 0h24v24H0z",fill:"none"}}),e("path",{attrs:{d:"M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"}})])])]):t._e()],1)},Ci=[],yi=(a(42762),a(69348),{name:"ConsoleOperation",props:{status:String,summary:[String,Array],details:[String,Array],console:String,showConsole:Boolean,forceConsole:Boolean},data:function(){return{openConsole:!0,isScrolledTop:!0,isScrolledBottom:!0,autoScroll:!0,swallowScroll:!0}},computed:{isPending:function(t){return"pending"===t.status},isActive:function(t){return"active"===t.status},isSuccess:function(t){return"complete"===t.status},isError:function(t){return"error"===t.status},isStopped:function(t){return"stopped"===t.status},isSkipped:function(t){return"skipped"===t.status},consoleLines:function(t){return t.console.trim().split("\n")}},methods:{toggleConsole:function(){var t=this.$refs.details.open;t&&this.$refs.console&&(this.autoScroll=!0,this.$refs.console.scrollTop=this.$refs.console.scrollHeight,this.updatePosition())},scrolled:function(){this.swallowScroll||this.updatePosition(),this.swallowScroll=!1},updatePosition:function(){var t=this.$refs.console,e=t.scrollTop+t.clientHeight;this.autoScroll=e===t.scrollHeight,this.isScrolledTop=t.clientHeight<=250||t.scrollHeight>250&&t.scrollTop<16,this.isScrolledBottom=t.clientHeight<=250||t.scrollHeight>250&&e>=t.scrollHeight-16},scrollToTop:function(){this.$refs.console.scrollTop=0},scrollToBottom:function(){this.$refs.console.scrollTop=this.$refs.console.scrollHeight},updateConsole:function(){var t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];this.isError&&(t=!0),this.$refs.details&&(this.$refs.details.open=t)}},watch:{console:function(t){var e=this;t&&(this.updateConsole(this.openConsole),this.autoScroll&&this.$nextTick((function(){e.swallowScroll=!0,e.$refs.console.scrollTop=e.$refs.console.scrollHeight})))},showConsole:function(t){this.openConsole=t,this.updateConsole(t)}},mounted:function(){this.openConsole=this.showConsole,this.updateConsole(this.openConsole)}}),$i=yi,Ai=(0,D.A)($i,wi,Ci,!1,null,null,null),xi=Ai.exports,Si={components:{ConsoleOperation:xi,ButtonMenu:ki},props:{title:{type:String,required:!0},description:String,operations:{type:Array,required:!0},showConsole:{type:Boolean,default:!1},forceConsole:{type:Boolean,default:!1},consoleOutput:String},methods:{showLog:function(){var t=window.open();t&&(t.document.open(),t.document.write("<pre>".concat(this.consoleOutput,"</pre>")),t.document.close())}}},Di=Si,Mi=(0,D.A)(Di,hi,gi,!1,null,null,null),Oi=Mi.exports,Ti=function(){var t=this,e=t._self._c;return e("div",[e("div",{staticClass:"widget widget-checkbox",class:{"widget--required":t.required}},[e("input",{ref:"input",attrs:{type:"checkbox",id:t.label?"ctrl_"+t.name:"",name:t.name,disabled:t.disabled,required:t.required},domProps:{checked:t.value},on:{change:function(e){return t.toggle(e.target.checked)}}}),t.label?e("label",{attrs:{for:"ctrl_"+t.name}},[t._v(t._s(t.label))]):t._e()]),t.description||t.$slots.description?e("div",{staticClass:"widget-checkbox__description",class:{"widget-checkbox__description--disabled":t.disabled}},[t._t("description",(function(){return[e("p",[t._v(t._s(t.description))])]}))],2):t._e()])},ji=[],Li={props:{name:{type:String,required:!0},label:{type:String,required:!0},description:String,value:Boolean,disabled:Boolean,required:Boolean},methods:{toggle:function(t){this.$emit("input",!!t)}}},Pi=Li,Ei=(0,D.A)(Pi,Ti,ji,!1,null,null,null),Bi=Ei.exports,Ui={name:"TaskView",mixins:[pi],components:{BoxedLayout:Wa,LoadingSpinner:un.A,LoadingButton:R.A,ConsoleOutput:Oi,CheckBox:Bi},data:function(){return{showConsole:!1,autoClose:!1,favicons:null,faviconInterval:null}},computed:(0,b.A)((0,b.A)({},(0,k.aH)("server/database",{supportsMigrations:"supported",loadingMigrations:"loading"})),(0,k.L8)("server/database",{hasDatabaseChanges:"hasChanges"})),methods:{cancelTask:function(){confirm(this.$t("ui.task.confirmCancel"))&&this.$store.dispatch("tasks/abort")},deleteTask:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return a=t.isError,e.next=3,t.$store.dispatch("tasks/deleteCurrent");case 3:a&&window.location.reload();case 4:case"end":return e.stop()}}),e)})))()},updateDatabase:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:if(!t.supportsMigrations){e.next=6;break}return e.next=3,t.$store.dispatch("tasks/deleteCurrent");case 3:t.$store.commit("checkMigrations"),e.next=7;break;case 6:window.open("/contao/install");case 7:case"end":return e.stop()}}),e)})))()},updateFavicon:function(){var t,e=this;this.faviconInterval&&clearInterval(this.faviconInterval);var a=function(t){e.favicons.forEach((function(e){e.href="".concat(t,"/").concat(e.href.split("/").pop())}))};switch(this.taskStatus){case"active":t="icons/task-active";break;case"complete":t="icons/task-success";break;case"error":case"failed":case"stopped":t="icons/task-error";break;default:return void setTimeout(a.bind(this,"icons"),2e3)}var n=!1;this.faviconInterval=setInterval((function(){n=!n,a(n?t:"icons")}),2e3)}},watch:{taskStatus:function(){this.updateFavicon()},showConsole:function(t){window.localStorage.setItem("contao_manager_console",t?"1":"0")},autoClose:function(t){window.localStorage.setItem("contao_manager_autoclose",t?"1":"0")},isComplete:function(){this.isComplete&&this.$store.dispatch("server/database/get",!1)}},mounted:function(){this.favicons=document.querySelectorAll('link[class="favicon"]'),this.updateFavicon(),this.showConsole="1"===window.localStorage.getItem("contao_manager_console"),this.autoClose="1"===window.localStorage.getItem("contao_manager_autoclose"),this.$store.dispatch("server/database/get")},beforeDestroy:function(){this.updateFavicon()}},qi=Ui,Ri=(0,D.A)(qi,li,di,!1,null,null,null),Ii=Ri.exports,Hi=function(){var t=this,e=t._self._c;return t.currentStep?e("div",{ref:"current"}):e("boxed-layout",{attrs:{wide:!0,slotClass:"view-boot"}},[e("header",{staticClass:"view-boot__header"},[e("img",{staticClass:"view-boot__icon",attrs:{src:a(54519),width:"80",height:"80",alt:"Contao Logo"}}),e("h1",{staticClass:"view-boot__headline"},[t._v(t._s(t.$t("ui.boot.headline")))]),e("p",{staticClass:"view-boot__description"},[t._v(t._s(t.$t("ui.boot.description")))])]),t.tasksInitialized?e("main",{staticClass:"view-boot__checks"},[e("div",{ref:"steps"}),e("div",{staticClass:"clearfix"}),t.hasError?e("div",{staticClass:"view-boot__summary view-boot__summary--error"},[e("svg",{attrs:{height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"}},[e("path",{attrs:{d:"M0 0h24v24H0z",fill:"none"}}),e("path",{attrs:{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"}})]),e("h1",{staticClass:"view-boot__issue"},[t._v(t._s(t.$t("ui.boot.issue1")))]),e("p",{staticClass:"view-boot__issue"},[t._v(t._s(t.$t("ui.boot.issue2")))]),t.safeMode?e("button",{staticClass:"widget-button widget-button--warning view-boot__safeMode",on:{click:t.runSafeMode}},[t._v(t._s(t.$t("ui.boot.safeMode")))]):t._e()]):t.safeMode?e("div",{staticClass:"view-boot__summary"},[e("button",{staticClass:"widget-button widget-button--warning view-boot__safeMode",on:{click:t.runSafeMode}},[t._v(t._s(t.$t("ui.boot.safeMode")))])]):t.autoContinue?t._e():e("div",{staticClass:"view-boot__summary"},[e("button",{staticClass:"widget-button widget-button--primary view-boot__continue",attrs:{disabled:!t.canContinue},on:{click:t.finish}},[t._v(t._s(t.$t("ui.boot.run")))])])]):e("main",{staticClass:"view-boot__loading"},[e("loading-spinner")],1)])},Vi=[],Fi=function(){var t=this,e=t._self._c;return e("boot-check",{attrs:{progress:t.bootState,title:t.$t("ui.server.selfUpdate.title"),description:t.bootDescription},scopedSlots:t._u([t.latestDownload?{key:"description",fn:function(){return[e("i18n",{attrs:{tag:!1,path:"ui.server.selfUpdate.manualUpdate"},scopedSlots:t._u([{key:"latest",fn:function(){return[t._v(t._s(t.latestDownload))]},proxy:!0},{key:"download",fn:function(){return[e("a",{attrs:{href:"https://to.contao.org/download?lang=${this.$i18n.locale}",target:"_blank",rel:"noreferrer noopener"}},[t._v("https://to.contao.org/download")])]},proxy:!0}],null,!1,460407800)})]},proxy:!0}:null],null,!0)},[t.isSupported||"action"!==t.bootState?t.hasUpdate?e("button",{staticClass:"widget-button widget-button--alert",on:{click:t.update}},[t._v(t._s(t.$t("ui.server.selfUpdate.button")))]):t._e():e("button",{staticClass:"widget-button widget-button--warning",on:{click:t.next}},[t._v(t._s(t.$t("ui.server.selfUpdate.continue")))])])},zi=[],Ni={data:function(){return{ready:!1,current:!1,booted:!1,bootState:"loading",bootDescription:""}},watch:{ready:function(t){t&&(this.booted=!0,this.boot())}},created:function(){this.bootDescription=this.$t("ui.server.pending"),this.ready&&(this.booted=!0,this.boot())}},Ji=function(){var t=this,e=t._self._c;return e("div",{staticClass:"boot-check"},["loading"===t.progress?e("loading-spinner",{staticClass:"boot-check__icon"}):"success"===t.progress?e("div",{staticClass:"boot-check__icon boot-check__icon--success"},[e("svg",{attrs:{height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"}},[e("circle",{attrs:{cx:"12",cy:"12",r:"8",fill:"#fff"}}),e("path",{attrs:{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"}})])]):"info"===t.progress||"action"===t.progress?e("div",{staticClass:"boot-check__icon boot-check__icon--info"},[e("svg",{attrs:{height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"}},[e("circle",{attrs:{cx:"12",cy:"12",r:"8",fill:"#fff"}}),e("path",{attrs:{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z"}})])]):"warning"===t.progress?e("div",{staticClass:"boot-check__icon boot-check__icon--warning"},[e("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M5 19h15L12 5",fill:"#fff"}}),e("path",{attrs:{d:"M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"}})])]):e("div",{staticClass:"boot-check__icon boot-check__icon--error"},[e("svg",{attrs:{height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"}},[e("circle",{attrs:{cx:"12",cy:"12",r:"8",fill:"#fff"}}),e("path",{attrs:{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"}})])]),e("div",{staticClass:"boot-check__label"},[e("h2",{staticClass:"boot-check__title"},[t._v(t._s(t.title))]),e("p",{staticClass:"boot-check__description"},[t._t("description",(function(){return[t._v(t._s(t.description))]}))],2),t.detail?e("p",{staticClass:"boot-check__detail"},[t._v(t._s(t.detail))]):t._e()]),e("div",{staticClass:"boot-check__action"},[t._t("default")],2)],1)},Wi=[],Gi={components:{LoadingSpinner:un.A},props:{title:String,description:String,detail:String,progress:{type:String,required:!0,validator:function(t){return-1!==["ready","loading","success","info","warning","error","action"].indexOf(t)}}}},Xi=Gi,Qi=(0,D.A)(Xi,Ji,Wi,!1,null,null,null),Yi=Qi.exports,Ki={mixins:[Ni],components:{BootCheck:Yi},data:function(){return{hasUpdate:!1,isSupported:!0,latestDownload:null}},methods:{boot:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n,s;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.bootDescription=t.$t("ui.server.running"),e.prev=1,e.next=4,t.$store.dispatch("server/self-update/get");case 4:a=e.sent,e.next=11;break;case 7:return e.prev=7,e.t0=e["catch"](1),t.emitState("error",t.$t("ui.server.error")),e.abrupt("return");case 11:if(n={current:a.current_version,latest:a.latest_version},null!==a.latest_version){e.next=15;break}return t.emitState("info",t.$t("ui.server.selfUpdate.dev")),e.abrupt("return");case 15:if(!a.error){e.next=30;break}if("dev"!==a.channel){e.next=19;break}return t.emitState("warning",a.error),e.abrupt("return");case 19:return e.prev=19,e.next=22,t.$store.dispatch("server/self-update/latest");case 22:s=e.sent,s===a.current_version?t.emitState("success",t.$t("ui.server.selfUpdate.latest",n)):(t.latestDownload=s,t.emitState("error",t.$t("ui.server.selfUpdate.manualUpdate",{latest:s,download:'<a href="https://to.contao.org/download?lang='.concat(t.$i18n.locale,'" target="_blank" rel="noreferrer noopener">https://to.contao.org/download</a>')}))),e.next=29;break;case 26:e.prev=26,e.t1=e["catch"](19),t.emitState("warning",a.error);case 29:return e.abrupt("return");case 30:if(a.current_version!==a.latest_version){e.next=33;break}return t.emitState("success",t.$t("ui.server.selfUpdate.latest",n)),e.abrupt("return");case 33:if(a.supported){e.next=37;break}return t.isSupported=!1,t.emitState("action",t.$t("ui.server.selfUpdate.unsupported",n)),e.abrupt("return");case 37:if("dev"!==a.channel){e.next=41;break}return t.hasUpdate=!0,t.emitState("warning",t.$t("ui.server.selfUpdate.update",n)),e.abrupt("return");case 41:t.hasUpdate=!0,t.emitState("error",t.$t("ui.server.selfUpdate.update",n));case 43:case"end":return e.stop()}}),e,null,[[1,7],[19,26]])})))()},update:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.prev=0,e.next=3,t.$store.dispatch("tasks/execute",{name:"manager/self-update",ignoreErrors:!0});case 3:e.next=7;break;case 5:e.prev=5,e.t0=e["catch"](0);case 7:setTimeout((function(){window.location.reload(!0)}),3e3);case 8:case"end":return e.stop()}}),e,null,[[0,5]])})))()},next:function(){this.bootState="info",this.$emit("result","SelfUpdate",this.bootState)},emitState:function(t,e){this.bootState=t,this.bootDescription=e,this.$emit("result","SelfUpdate",t)}}},Zi=Ki,to=(0,D.A)(Zi,Fi,zi,!1,null,null,null),eo=to.exports,ao=function(){var t=this,e=t._self._c;return t.current?e("boxed-layout",{attrs:{wide:!0,slotClass:"config-check"}},[e("header",{staticClass:"config-check__header"},[e("img",{staticClass:"config-check__icon",attrs:{src:a(17957),width:"80",height:"80",alt:""}}),e("h1",{staticClass:"config-check__headline"},[t._v(t._s(t.$t("ui.server.config.title")))]),e("p",{staticClass:"config-check__description"},[t._v(t._s(t.$t("ui.server.config.description")))])]),e("main",{staticClass:"config-check__form"},[e("form",{on:{submit:function(e){return e.preventDefault(),t.save.apply(null,arguments)}}},[e("fieldset",{staticClass:"config-check__fields"},[e("legend",{staticClass:"config-check__fieldtitle"},[t._v(t._s(t.$t("ui.server.config.formTitle")))]),e("p",{staticClass:"config-check__fielddesc"},[t._v(t._s(t.$t("ui.server.config.formText")))]),e("text-field",{attrs:{name:"php_cli",label:t.$t("ui.server.config.cli"),required:"",disabled:t.processing,error:t.error},model:{value:t.php_cli,callback:function(e){t.php_cli=e},expression:"php_cli"}})],1),e("fieldset",{staticClass:"config-check__fields"},[e("legend",{staticClass:"config-check__fieldtitle"},[t._v(t._s(t.$t("ui.server.config.cloudTitle")))]),e("p",{staticClass:"config-check__fielddesc"},[t._v(t._s(t.$t("ui.server.config.cloudText")))]),t.cloudIssues&&t.cloudIssues.length?e("div",{staticClass:"config-check__issues"},[e("p",[t._v(t._s(t.$t("ui.server.config.stateErrorCloud")))]),e("ul",t._l(t.cloudIssues,(function(a,n){return e("li",{key:n},[t._v(t._s(a))])})),0)]):t._e(),e("check-box",{attrs:{name:"cloud",label:t.$t("ui.server.config.cloud"),disabled:t.processing},model:{value:t.cloud,callback:function(e){t.cloud=e},expression:"cloud"}})],1),e("loading-button",{attrs:{submit:"",color:"primary",disabled:!t.php_cli,loading:t.processing}},[t._v(t._s(t.$t("ui.server.config.save")))]),e("button",{staticClass:"widget-button",attrs:{type:"button",disabled:t.processing},on:{click:t.cancel}},[t._v(t._s(t.$t("ui.server.config.cancel")))])],1)])]):e("boot-check",{attrs:{progress:t.bootState,title:t.$t("ui.server.config.title"),description:t.bootDescription}},["error"===t.bootState||"action"===t.bootState?e("button",{staticClass:"widget-button widget-button--alert",on:{click:t.showConfiguration}},[t._v(t._s(t.$t("ui.server.config.setup")))]):"loading"!==t.bootState?e("button",{staticClass:"widget-button widget-button--edit",on:{click:t.showConfiguration}},[t._v(t._s(t.$t("ui.server.config.change")))]):t._e()])},no=[],so={mixins:[Ni],components:{BootCheck:Yi,BoxedLayout:Wa,TextField:Zs,CheckBox:Bi,LoadingButton:R.A},data:function(){return{processing:!1,error:"",php_cli:"",cloud:!0,cloudIssues:[]}},methods:{boot:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:t.bootDescription=t.$t("ui.server.running"),t.$store.dispatch("server/config/get").then((function(e){t.php_cli=e.php_cli,t.cloud=e.cloud.enabled,t.cloudIssues=e.cloud.issues,e.php_cli?e.cloud.enabled&&e.cloud.issues.length>0?(t.bootState="error",t.bootDescription=t.$t("ui.server.config.stateErrorCloud")):(t.bootState="success",t.bootDescription=t.$t("ui.server.config.stateSuccess",{php_cli:e.php_cli})):(t.bootState="error",t.bootDescription=t.$t("ui.server.config.stateErrorCli"))})).catch((function(){t.bootState="error",t.bootDescription=t.$t("ui.server.error")})).then((function(){t.$emit("result","Config",t.bootState)}));case 2:case"end":return e.stop()}}),e)})))()},showConfiguration:function(){this.$emit("view","Config")},save:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.processing=!0,t.error="",a={php_cli:t.php_cli,cloud:t.cloud},e.prev=3,e.next=6,t.$store.dispatch("server/config/set",a);case 6:window.location.reload(!0),e.next=13;break;case 9:e.prev=9,e.t0=e["catch"](3),400===e.t0.body.status&&e.t0.body.detail&&(t.error=e.t0.body.detail),t.processing=!1;case 13:case"end":return e.stop()}}),e,null,[[3,9]])})))()},cancel:function(){this.$emit("view",null)}}},io=so,oo=(0,D.A)(io,ao,no,!1,null,null,null),ro=oo.exports,co=function(){var t=this,e=t._self._c;return e("boot-check",{attrs:{progress:t.bootState,title:t.$t("ui.server.php_web.title"),description:t.bootDescription,detail:t.problem&&t.problem.detail}},[t.problem&&t.problem.type?e("a",{attrs:{href:t.problem.type,target:"_blank"}},[t._v(t._s(t.$t("ui.server.details")))]):t._e()])},uo=[],lo={mixins:[Ni],components:{BootCheck:Yi},data:function(){return{problem:{}}},methods:{boot:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.bootDescription=t.$t("ui.server.running"),e.next=3,t.$store.dispatch("server/php-web/get");case 3:a=e.sent,200===a.status?a.body.problem?(t.problem=a.body.problem,t.bootState="error",t.bootDescription=a.body.problem.title):a.body.version_id<7e4?(t.bootState="info",t.bootDescription=t.$t("ui.server.php_web.below7",a.body)):(t.bootState="success",t.bootDescription=t.$t("ui.server.php_web.success",a.body)):(t.bootState="error",t.bootDescription=t.$t("ui.server.error")),t.$emit("result","PhpWeb",t.bootState);case 6:case"end":return e.stop()}}),e)})))()}}},po=lo,ho=(0,D.A)(po,co,uo,!1,null,null,null),go=ho.exports,mo=function(){var t=this,e=t._self._c;return e("boot-check",{attrs:{progress:t.bootState,title:t.$t("ui.server.php_cli.title"),description:t.bootDescription,detail:t.problem&&t.problem.detail}},[t.problem&&t.problem.type?e("a",{attrs:{href:t.problem.type,target:"_blank"}},[t._v(t._s(t.$t("ui.server.details")))]):t._e()])},fo=[],_o={mixins:[Ni],components:{BootCheck:Yi},data:function(){return{problem:{}}},methods:{boot:function(){var t=this;this.bootDescription=this.$t("ui.server.running"),this.$store.dispatch("server/php-cli/get").then((function(e){e.problem?(t.problem=e.problem,t.bootState="error",t.bootDescription=e.problem.title):(t.bootState="success",t.bootDescription=t.$t("ui.server.php_cli.success",{version:e.version}))})).catch((function(e){503===e.status?(t.bootState="error",t.bootDescription=t.$t("ui.server.prerequisite")):(t.bootState="error",t.bootDescription=t.$t("ui.server.error"))})).then((function(){t.$emit("result","PhpCli",t.bootState)}))}}},vo=_o,bo=(0,D.A)(vo,mo,fo,!1,null,null,null),ko=bo.exports,wo=function(){var t=this,e=t._self._c;return e("boot-check",{attrs:{progress:t.bootState,title:t.$t("ui.server.composer.title"),description:t.bootDescription}},["action"===t.bootState?e("button",{staticClass:"widget-button widget-button--primary widget-button--run",on:{click:t.install}},[t._v(t._s(t.$t("ui.server.composer.button")))]):t._e()])},Co=[],yo={mixins:[Ni],components:{BootCheck:Yi},computed:(0,b.A)({},(0,k.aH)("tasks",{taskStatus:"status"})),methods:{boot:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.bootState="loading",t.bootDescription=t.$t("ui.server.running"),e.prev=2,e.next=5,t.$store.dispatch("server/composer/get");case 5:return a=e.sent,a.json.found&&!a.json.valid?(t.bootState="error",t.bootDescription=a.json.error):a.json.found&&!a.vendor.found?(t.bootState="action",t.bootDescription=t.$t("ui.server.composer.install"),t.$store.commit("setSafeMode",!0)):(t.bootState="success",t.bootDescription=t.$t("ui.server.composer.success")),e.next=9,t.$store.dispatch("config/composer/get");case 9:if(n=e.sent,n&&0!==n.length){e.next=13;break}return e.next=13,t.$store.dispatch("config/composer/writeDefaults");case 13:e.next=18;break;case 15:e.prev=15,e.t0=e["catch"](2),503===e.t0.status?(t.bootState="error",t.bootDescription=t.$t("ui.server.prerequisite")):(t.bootState="error",t.bootDescription=t.$t("ui.server.error"));case 18:t.$emit("result","Composer",t.bootState);case 19:case"end":return e.stop()}}),e,null,[[2,15]])})))()},install:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("tasks/execute",{name:"composer/install"});case 2:if("complete"===t.taskStatus){e.next=4;break}return e.abrupt("return");case 4:return e.next=6,t.$store.dispatch("tasks/deleteCurrent");case 6:case"end":return e.stop()}}),e)})))()}}},$o=yo,Ao=(0,D.A)($o,wo,Co,!1,null,null,null),xo=Ao.exports,So=function(){var t=this,e=t._self._c;return e("boot-check",{attrs:{progress:t.bootState,title:t.$t("ui.server.contao.title"),description:t.bootDescription}},["action"===t.bootState?e("button",{staticClass:"widget-button widget-button--primary widget-button--run",on:{click:t.setup}},[t._v(t._s(t.$t("ui.server.contao.".concat(t.databaseProblem&&!t.databaseAccessProblem?"check":"setup"))))]):t._e(),"warning"===t.bootState?e("button",{staticClass:"widget-button widget-button--alert",on:{click:t.setup}},[t._v(t._s(t.$t("ui.server.contao.".concat(t.databaseProblem&&!t.databaseAccessProblem?"check":"setup"))))]):t._e(),"success"===t.bootState&&t.databaseSupported?e("button",{staticClass:"widget-button",on:{click:t.setup}},[t._v(t._s(t.$t("ui.server.contao.setup")))]):t._e()])},Do=[],Mo={mixins:[Ni],components:{BootCheck:Yi},data:function(){return{processing:!1}},computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("server/database",{databaseSupported:"supported",databaseStatus:"status"})),(0,k.aH)("server/adminUser",{userSupported:"supported",hasUser:"hasUser"})),(0,k.L8)("server/database",{databaseProblem:"hasError",databaseAccessProblem:"accessProblem"})),methods:{boot:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n,s,i,o;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.bootState="loading",t.bootDescription=t.$t("ui.server.running"),e.next=4,t.$store.dispatch("server/contao/get",!1);case 4:if(a=e.sent,n=a.body,s=t.bootState,i=t.bootDescription,200===a.status?n.version?n.supported?(s="success",i=t.$t("ui.server.contao.found",{version:n.version,api:n.api.version})):(s="error",i=t.$t("ui.server.contao.old",n)):(s="action",i=t.$t("ui.server.contao.empty")):503===a.status?(s="error",i=t.$t("ui.server.prerequisite")):502===a.status?(window.localStorage.removeItem("contao_manager_booted"),t.$store.commit("setView",A.RECOVERY)):(s="error",i=t.$t("ui.server.error")),"success"!==s){e.next=26;break}return e.next=12,Promise.all([t.$store.dispatch("contao/install-tool/fetch",!1),t.$store.dispatch("server/database/get",!1)]);case 12:if(!t.databaseSupported){e.next=26;break}if(!t.databaseAccessProblem){e.next=18;break}s="warning",i+=" ".concat(t.$t("ui.server.contao.connectionError")),e.next=26;break;case 18:if(!t.databaseProblem){e.next=23;break}s="warning",i+=" ".concat(t.$t("ui.server.contao.connectionProblem")),e.next=26;break;case 23:return e.next=25,t.$store.dispatch("server/adminUser/get",!1);case 25:t.userSupported&&!t.hasUser&&(s="warning",i+=" ".concat(t.$t("ui.server.contao.missingUser")));case 26:if("warning"!==s){e.next=30;break}t.$store.commit("setSafeMode",!0),e.next=35;break;case 30:if("action"!==s){e.next=35;break}return e.next=33,t.$store.dispatch("server/composer/get");case 33:o=e.sent,o.json.found&&o.json.valid&&t.$store.commit("setSafeMode",!0);case 35:t.bootState=s,t.bootDescription=i,t.$emit("result","Contao",t.bootState);case 38:case"end":return e.stop()}}),e)})))()},setup:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.$store.commit("setSafeMode",!1),e.next=3,t.$store.dispatch("server/composer/get");case 3:a=e.sent,a.json.found?t.databaseAccessProblem?t.$store.commit("setup",3):t.databaseProblem?t.$store.commit("setView",A.MIGRATION):t.hasUser?t.$store.commit("setup",0):t.$store.commit("setup",null===t.hasUser?3:4):t.$store.commit("setup",0);case 5:case"end":return e.stop()}}),e)})))()}}},Oo=Mo,To=(0,D.A)(Oo,So,Do,!1,null,null,null),jo=To.exports,Lo={components:{BoxedLayout:Wa,LoadingSpinner:un.A},data:function(){return{steps:[],currentStep:null,status:{}}},computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)(["safeMode"])),(0,k.aH)("tasks",{tasksInitialized:"initialized"})),{},{hasError:function(t){return-1!==Object.values(t.status).indexOf("error")},autoContinue:function(t){return"1"===window.localStorage.getItem("contao_manager_booted")&&-1===Object.values(t.status).indexOf("error")&&-1===Object.values(t.status).indexOf("action")&&-1===Object.values(t.status).indexOf("warning")||t.$route.name===f.oauth.name},canContinue:function(t){return-1===Object.values(t.status).indexOf(null)&&-1===Object.values(t.status).indexOf("error")&&-1===Object.values(t.status).indexOf("action")},shouldContinue:function(t){return-1===Object.values(t.status).indexOf(null)&&-1===Object.values(t.status).indexOf("error")&&-1===Object.values(t.status).indexOf("action")&&-1===Object.values(t.status).indexOf("warning")}}),methods:{setView:function(t){var e=this;return(0,P.A)((0,L.A)().mark((function a(){return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:if(t){a.next=4;break}return e.currentStep=null,e.$nextTick((function(){e.$refs.steps&&(e.$refs.steps.innerHTML="",Object.keys(e.steps).forEach((function(t){e.steps[t].current=!1,e.$refs.steps.append(e.steps[t].$el)})))})),a.abrupt("return");case 4:Object.keys(e.steps).forEach((function(t){e.steps[t].current=!1})),e.currentStep=t,e.$nextTick((function(){e.$refs.current.innerHTML="",e.$refs.current.append(e.steps[t].$el),e.steps[t].current=!0}));case 7:case"end":return a.stop()}}),a)})))()},runSafeMode:function(){this.$store.commit("setSafeMode",!0),this.$store.commit("setView",A.READY)},finish:function(){window.localStorage.setItem("contao_manager_booted","1"),this.$store.commit("setSafeMode",!1),this.$store.commit("setView",A.READY)},result:function(t,e){if(!this.currentStep){this.$set(this.status,t,e);for(var a=Object.keys(this.status),n=0;n<a.length;n+=1)if(null===this.status[a[n]])return this.steps[a[n]].ready=this.canShow(a[n]),void(this.currentStep=null)}},canShow:function(t){for(var e=Object.keys(this.status),a=0;a<e.length;a+=1){if(e[a]===t)return!0;if(null===this.status[e[a]]||"error"===this.status[e[a]]||"action"===this.status[e[a]])return!1}return!1},initViews:function(){var t=this;if(this.$refs.steps){this.$refs.steps.innerHTML="",this.steps={};var e={PhpWeb:go,Config:ro,PhpCli:ko,SelfUpdate:eo,Composer:xo,Contao:jo};this.$route.name===f.oauth.name&&(e={PhpWeb:go,Config:ro,PhpCli:ko,SelfUpdate:eo}),this.status=Object.keys(e).reduce((function(t,e){return Object.assign(t,(0,ne.A)({},e,null))}),{}),Object.keys(e).forEach((function(a){var n=new(l.Ay.extend(e[a]))({parent:t});n.$mount(),n.$on("result",t.result),n.$on("view",t.setView),n.ready=t.canShow(a),t.steps[a]=n,t.$refs.steps.append(n.$el)}))}}},watch:{$route:function(){this.initViews()},shouldContinue:function(t){t&&this.autoContinue&&this.finish()}},mounted:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("reset");case 2:return e.next=4,t.$store.dispatch("tasks/init");case 4:t.initViews();case 5:case"end":return e.stop()}}),e)})))()}},Po=Lo,Eo=(0,D.A)(Po,Hi,Vi,!1,null,null,null),Bo=Eo.exports,Uo=function(){var t=this,e=t._self._c;return e("boxed-layout",{attrs:{wide:!0,slotClass:"view-setup"}},[t.currentStep>0?e("section",{staticClass:"view-setup__steps"},[e("ul",[t._l(t.steps,(function(a,n){return e("li",{key:a.name,class:{active:t.currentStep>n}},[e("button",{attrs:{disabled:t.currentStep<=n+1},on:{click:function(e){t.currentStep=n+1}}},[e("img",{attrs:{src:a.icon,width:"24",height:"24",alt:""}})])])})),e("li",{class:{active:t.currentStep>t.steps.length}},[e("button",{attrs:{disabled:""}},[e("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",height:"24px",viewBox:"0 0 24 24",width:"24px"}},[e("path",{attrs:{d:"M0 0h24v24H0z",fill:"none"}}),e("path",{attrs:{d:"M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z"}})])])])],2)]):t._e(),t.currentStep>t.steps.length?e("main",{staticClass:"view-setup__main"},[e("span",{staticClass:"view-setup__party"},[t._v("🎉")]),e("h1",{staticClass:"view-setup__headline"},[t._v(t._s(t.$t("ui.setup.complete")))]),e("p",{staticClass:"view-setup__description"},[t._v(t._s(t.$t("ui.setup.complete1",{version:t.contaoVersion})))]),t.databaseSupported&&t.userSupported?[e("p",{staticClass:"view-setup__description"},[t._v(t._s(t.$t("ui.setup.complete3")))]),e("button",{staticClass:"widget-button view-setup__continue",on:{click:t.launch}},[t._v(t._s(t.$t("ui.setup.manager")))]),e("a",{staticClass:"widget-button widget-button--primary view-setup__continue",attrs:{href:"/contao"}},[t._v(t._s(t.$t("ui.setup.login")))])]:[e("p",{staticClass:"view-setup__description"},[t._v(t._s(t.$t("ui.setup.complete2")))]),e("button",{staticClass:"widget-button widget-button--inline",on:{click:t.launch}},[t._v(t._s(t.$t("ui.setup.manager")))]),e("a",{staticClass:"widget-button widget-button--primary view-setup__continue",attrs:{href:"/contao/install"}},[t._v(t._s(t.$t("ui.setup.installTool")))])],e("div",{staticClass:"view-setup__funding"},[e("figure",[e("img",{attrs:{src:a(13382),width:"80",height:"80",alt:""}})]),e("div",[t._l(t.$t("ui.setup.funding").split("\n"),(function(a,n){return e("p",{key:n},[t._v(t._s(a))])})),e("p",[e("a",{staticClass:"view-setup__funding-link widget-button widget-button--small widget-button--funding widget-button--link",attrs:{href:"https://to.contao.org/donate",target:"_blank"}},[t._v(t._s(t.$t("ui.setup.fundingLink")))])])],2)])],2):t.currentStep>0?e(t.steps[t.currentStep-1].component,{tag:"component",on:{continue:function(e){t.currentStep+=1}}}):e("main",{staticClass:"view-setup__main"},[e("img",{staticClass:"view-setup__icon",attrs:{src:a(6894),width:"100",height:"100",alt:"Contao Logo"}}),e("h1",{staticClass:"view-setup__headline"},[t._v(t._s(t.$t("ui.setup.welcome")))]),e("p",{staticClass:"view-setup__description"},[t._v(t._s(t.$t("ui.setup.welcome1")))]),e("i18n",{staticClass:"view-setup__description",attrs:{tag:"p",path:"ui.setup.welcome2"},scopedSlots:t._u([{key:"support",fn:function(){return[e("a",{attrs:{href:"https://to.contao.org/support",target:"_blank"}},[t._v(t._s(t.$t("ui.setup.support")))])]},proxy:!0}])}),e("button",{staticClass:"widget-button widget-button--inline widget-button--primary view-setup__start",on:{click:function(e){t.currentStep=1}}},[t._v(t._s(t.$t("ui.setup.start")))])],1)],1)},qo=[],Ro=function(){var t=this,e=t._self._c;return e("section",[e("header",{staticClass:"setup__header"},[e("img",{staticClass:"setup__icon",attrs:{src:a(71005),width:"80",height:"80",alt:""}}),e("h1",{staticClass:"setup__headline"},[t._v(t._s(t.$t("ui.setup.document-root.headline")))]),t.needsFix?e("p",{staticClass:"setup__warning"},[t._v(t._s(t.$t("ui.setup.document-root.warning")))]):t._e(),e("p",{staticClass:"setup__description"},[t._v(t._s(t.$t("ui.setup.document-root.description1")))]),e("p",{staticClass:"setup__description"},[t._v(t._s(t.$t("ui.setup.document-root.description2")))]),e("a",{staticClass:"widget-button widget-button--inline widget-button--info widget-button--link",attrs:{href:"https://to.contao.org/docs/webroot?lang=".concat(t.$i18n.locale),target:"_blank"}},[t._v(t._s(t.$t("ui.setup.document-root.documentation")))])]),null!==t.projectDir?e("transition",{attrs:{name:t.forceInstall?"none":"animate-flip",type:"transition",mode:"out-in"}},[t.needsFix||t.wantsFix?[t.directoryUpdated?e("main",{key:"updated",staticClass:"setup__form setup__form--center"},[e("div",{staticClass:"setup__fields"},[e("svg",{staticClass:"setup__check",attrs:{xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"}})]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.document-root.confirmation")))]),e("dl",{staticClass:"setup__directories"},[e("dt",[t._v(t._s(t.$t("ui.setup.document-root.currentRoot")))]),t.isWeb?e("dd",[t._v(t._s(t.projectDir)+"/web")]):t.isPublic?e("dd",[t._v(t._s(t.projectDir)+"/public")]):e("dd",[t._v(t._s(t.projectDir))]),e("dt",[t._v(t._s(t.$t("ui.setup.document-root.newRoot")))]),!t.isEmpty||t.wantsFix&&t.directory||!t.canUsePublicDir||!t.usePublicDir?!t.isEmpty||t.wantsFix&&t.directory?t.canUsePublicDir&&t.usePublicDir?e("dd",[t._v(t._s(t.projectDir)),e("span",[t._v("/"+t._s(t.directory)+"/public")])]):e("dd",[t._v(t._s(t.projectDir)),e("span",[t._v("/"+t._s(t.directory)+"/web")])]):e("dd",[t._v(t._s(t.projectDir)),e("span",[t._v("/web")])]):e("dd",[t._v(t._s(t.projectDir)),e("span",[t._v("/public")])])])]),e("div",{staticClass:"setup__actions setup__actions--center"},[e("loading-button",{attrs:{inline:"",loading:t.processing,color:"primary",icon:"update"},on:{click:t.reload}},[t._v(t._s(t.$t("ui.setup.document-root.reload")))])],1)]):t.conflicts.length?e("main",{key:"conflicts",staticClass:"setup__form"},[e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.document-root.conflictsTitle")))]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.document-root.conflictsDirectory",{count:t.conflicts.length})))]),e("ul",[t._l(t.conflicts.slice(0,5),(function(a){return e("li",{key:a},[t._v(t._s(a))])})),t.conflicts.length>5?e("li",[t._v("...")]):t._e()],2),t.isPublic||t.isWeb?e("check-box",{attrs:{name:"ignoreConflicts",label:t.$t("ui.setup.document-root.ignoreConflicts"),disabled:t.processing},model:{value:t.forceInstall,callback:function(e){t.forceInstall=e},expression:"forceInstall"}}):t._e()],1),e("div",{staticClass:"setup__actions setup__actions--center"},[t.forceInstall?e("button",{staticClass:"widget-button widget-button--alert widget-button--run",on:{click:function(e){return t.$emit("continue")}}},[t._v(t._s(t.$t("ui.server.contao.setup")))]):[e("loading-button",{attrs:{inline:"",icon:"update",loading:t.processing},on:{click:function(e){return t.init(!1)}}},[t._v(t._s(t.$t("ui.setup.document-root.check")))]),e("button",{staticClass:"widget-button widget-button--inline widget-button--primary widget-button--gear",attrs:{disabled:t.processing},on:{click:function(e){t.conflicts=[]}}},[t._v(t._s(t.$t("ui.setup.document-root.create")))])]],2)]):e("main",{key:"setup",staticClass:"setup__form"},[e("img",{staticClass:"invisible",attrs:{src:a(18519),alt:""}}),t._v(" "),e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.document-root.formTitle")))]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.document-root.formText1"))+" "),e("u",[t._v(t._s(t.$t("ui.setup.document-root.formText2")))])]),!t.isEmpty||t.wantsFix?e("text-field",{ref:"directory",attrs:{name:"directory",label:t.$t("ui.setup.document-root.directory"),error:t.directoryError,required:!t.isEmpty,pattern:"^[^/]+$",validate:""},model:{value:t.directory,callback:function(e){t.directory=e},expression:"directory"}}):t._e(),t.canUsePublicDir?e("radio-button",{attrs:{name:"usePublicDir",options:t.publicDirOptions,"allow-html":""},model:{value:t.usePublicDir,callback:function(e){t.usePublicDir=e},expression:"usePublicDir"}}):t._e(),e("dl",{staticClass:"setup__directories"},[e("dt",[t._v(t._s(t.$t("ui.setup.document-root.currentRoot")))]),t.isWeb?e("dd",[t._v(t._s(t.projectDir)+t._s(t.directorySeparator)+"web")]):t.isPublic?e("dd",[t._v(t._s(t.projectDir)+t._s(t.directorySeparator)+"public")]):e("dd",[t._v(t._s(t.projectDir))]),e("dt",[t._v(t._s(t.$t("ui.setup.document-root.newRoot")))]),!t.isEmpty||t.wantsFix&&t.directory||!t.canUsePublicDir||!t.usePublicDir?!t.isEmpty||t.wantsFix&&t.directory?t.canUsePublicDir&&t.usePublicDir?e("dd",[t._v(t._s(t.projectDir)),e("span",[t._v(t._s(t.directorySeparator)+t._s(t.directory)+t._s(t.directorySeparator)+"public")])]):e("dd",[t._v(t._s(t.projectDir)),e("span",[t._v(t._s(t.directorySeparator)+t._s(t.directory)+t._s(t.directorySeparator)+"web")])]):e("dd",[t._v(t._s(t.projectDir)),e("span",[t._v(t._s(t.directorySeparator)+"web")])]):e("dd",[t._v(t._s(t.projectDir)),e("span",[t._v(t._s(t.directorySeparator)+"public")])])]),e("check-box",{attrs:{name:"autoconfig",label:t.$t("ui.setup.document-root.autoconfig"),disabled:t.processing},model:{value:t.autoconfig,callback:function(e){t.autoconfig=e},expression:"autoconfig"}})],1),e("div",{staticClass:"setup__actions setup__actions--center"},[e("loading-button",{attrs:{color:"primary",icon:"run",loading:t.processing,disabled:!t.autoconfig||!!t.directoryError||t.wantsFix&&!t.directory&&(t.isPublic&&t.usePublicDir||t.isWeb&&!t.usePublicDir)},on:{click:t.setupDocroot}},[t._v(t._s(t.$t("ui.setup.document-root.finish")))]),t.wantsFix?e("button",{staticClass:"widget-button",attrs:{type:"button",disabled:t.processing},on:{click:t.init}},[t._v(t._s(t.$t("ui.setup.cancel")))]):t._e()],1)])]:[e("main",{key:"confirmation",staticClass:"setup__form"},[e("div",{staticClass:"setup__fields setup__fields--center"},[e("svg",{staticClass:"setup__check",attrs:{xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"}})]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.document-root.success")))]),e("i18n",{staticClass:"setup__fielddesc",attrs:{tag:"p",path:"ui.setup.document-root.".concat(t.contaoVersion?"installed":"installing","ProjectDir")},scopedSlots:t._u([{key:"dir",fn:function(){return[e("code",[t._v(t._s(t.projectDir))])]},proxy:!0}],null,!1,1937044063)}),e("i18n",{staticClass:"setup__fielddesc",attrs:{tag:"p",path:"ui.setup.document-root.".concat(t.contaoVersion?"installed":"installing","PublicDir")},scopedSlots:t._u([{key:"dir",fn:function(){return[e("code",[t._v(t._s(t.publicDir))])]},proxy:!0}],null,!1,1250366123)})],1),e("div",{staticClass:"setup__actions setup__actions--center"},[t.contaoVersion?t._e():e("button",{staticClass:"widget-button widget-button--inline widget-button--gear",on:{click:function(e){t.wantsFix=!0}}},[t._v(t._s(t.$t("ui.setup.document-root.change")))]),e("button",{staticClass:"widget-button widget-button--inline widget-button--primary",on:{click:function(e){return t.$emit("continue")}}},[t._v(t._s(t.$t("ui.setup.continue")))])])])]],2):t._e()],1)},Io=[],Ho=function(){var t=this,e=t._self._c;return e("fieldset",{staticClass:"widget widget-radio-button",class:{"widget--required":t.required}},[t.label||t.$slots.label?e("legend",[t._t("label",(function(){return[t._v(t._s(t.label))]}))],2):t._e(),t._l(t.options,(function(a,n){return e("div",{key:n},[e("input",{ref:"input",refInFor:!0,attrs:{type:"radio",id:"ctrl_".concat(t.name,"_").concat(a.value),name:t.name,disabled:a.disabled,required:t.required},domProps:{checked:t.value===a.value},on:{click:function(e){return t.$emit("input",a.value)}}}),t.allowHtml?e("label",{attrs:{for:"ctrl_".concat(t.name,"_").concat(a.value)},domProps:{innerHTML:t._s(a.label)}}):e("label",{attrs:{for:"ctrl_".concat(t.name,"_").concat(a.value)}},[t._v(t._s(a.label))])])}))],2)},Vo=[],Fo={props:{name:{type:String,required:!0},options:{type:Array,required:!0},label:String,value:{required:!0},disabled:Boolean,required:Boolean,allowHtml:{type:Boolean,default:!1}}},zo=Fo,No=(0,D.A)(zo,Ho,Vo,!1,null,null,null),Jo=No.exports,Wo={components:{TextField:Zs,RadioButton:Jo,CheckBox:Bi,LoadingButton:R.A},data:function(){return{processing:!1,usePublicDir:!1,wantsFix:!1,conflicts:[],isEmpty:!0,isWeb:!0,isPublic:!1,projectDir:null,autoconfig:!1,forceInstall:!1,directory:"",directoryExists:!1,directoryUpdated:!1,directorySeparator:"/"}},computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("server/php-web",["phpVersionId"])),(0,k.aH)("server/contao",["contaoVersion"])),{},{needsFix:function(t){return!t.isEmpty||!t.isWeb&&(!t.isPublic||!t.canUsePublicDir)},publicDirOptions:function(t){return[{label:t.$t("ui.setup.document-root.publicDir",{dir:"<code>web</code>",version:"4.9+"}),value:!1},{label:t.$t("ui.setup.document-root.publicDir",{dir:"<code>public</code>",version:"4.13+"}),value:!0}]},canUsePublicDir:function(t){return t.phpVersionId>=70400},publicDir:function(t){return t.isWeb?"".concat(t.projectDir).concat(t.directorySeparator,"web"):"".concat(t.projectDir).concat(t.directorySeparator,"public")},directoryError:function(){return this.directoryExists?this.$t("ui.setup.document-root.directoryExists"):this.directory&&!this.directory.match(/^[^/]+$/)?this.$t("ui.setup.document-root.directoryInvalid"):this.wantsFix||this.isEmpty||this.directory?"":this.$t("ui.setup.document-root.directoryInvalid")}}),methods:{reload:function(){this.processing=!0,window.location.reload()},setupDocroot:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.processing=!0,e.next=3,t.$store.dispatch("server/contao/documentRoot",{directory:!t.isEmpty||t.wantsFix?t.directory:null,usePublicDir:t.canUsePublicDir&&t.usePublicDir});case 3:if(a=e.sent,403!==a.status){e.next=9;break}return t.directoryExists=!0,t.processing=!1,t.$refs.directory.focus(),e.abrupt("return");case 9:t.processing=!1,t.directoryUpdated=!0,t.$store.commit("auth/resetCountdown");case 12:case"end":return e.stop()}}),e)})))()},init:function(){var t=arguments,e=this;return(0,P.A)((0,L.A)().mark((function a(){var n,s;return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:return n=!(t.length>0&&void 0!==t[0])||t[0],e.processing=!0,a.next=4,e.$store.dispatch("server/contao/get",n);case 4:s=a.sent,e.projectDir=s.body.project_dir,e.conflicts=s.body.conflicts,e.isEmpty=0===s.body.conflicts.length,e.isWeb="web"===s.body.public_dir,e.isPublic="public"===s.body.public_dir,e.usePublicDir="public"===s.body.public_dir,e.wantsFix=!1,e.directory=e.isEmpty?"":location.hostname,e.directorySeparator=s.body.directory_separator,e.processing=!1;case 15:case"end":return a.stop()}}),a)})))()}},watch:{directory:function(){this.directoryExists=!1}},mounted:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:t.init();case 1:case"end":return e.stop()}}),e)})))()}},Go=Wo,Xo=(0,D.A)(Go,Ro,Io,!1,null,null,null),Qo=Xo.exports,Yo=function(){var t=this,e=t._self._c;return e("div",[e("file-upload",{ref:"uploader",attrs:{name:"package","post-action":"api/packages/uploads",multiple:!0,drop:!0,"drop-directory":!1,"chunk-enabled":!0,chunk:{action:"api/packages/uploads"}},on:{"input-file":t.uploadTheme,"input-filter":t.filterTheme}}),t.theme?[e("header",{staticClass:"setup__header"},[t.themeImage?e("img",{staticClass:"setup__theme-image",attrs:{src:t.themeImage,alt:t.theme.composerJson.name}}):e("img",{staticClass:"setup__icon",attrs:{src:a(135),width:"80",height:"80",alt:""}}),e("h1",{staticClass:"setup__headline"},[t._v(t._s(t.$t("ui.setup.create-project.headline")))]),e("p",{staticClass:"setup__description"},[t._v(t._s(t.$t("ui.setup.create-project.theme.uploaded")))]),e("div",{staticClass:"setup__version"},[e("strong",[t._v(t._s(t.$t("ui.setup.create-project.theme.packageName"))+":")]),t._v(" "+t._s(t.theme.composerJson.name)+" ")]),e("div",{staticClass:"setup__version"},[e("strong",[t._v(t._s(t.$t("ui.setup.create-project.theme.version"))+":")]),t._v(" "+t._s(t.theme.composerJson.version)+" ")]),t.theme.composerJson.authors||t.theme.authors?e("div",{staticClass:"setup__version"},[e("strong",[t._v(t._s(t.$t("ui.setup.create-project.theme.authors"))+":")]),t.theme.composerJson.authors?[t._v(" "+t._s(t.theme.composerJson.authors.map((function(t){return t.name})).join(", ")))]:[t._v(" "+t._s(t.theme.authors))]],2):t._e(),t.theme.composerJson.license?e("div",{staticClass:"setup__version"},[e("strong",[t._v(t._s(t.$t("ui.package-details.license"))+":")]),t._v(" "+t._s(Array.isArray(t.theme.composerJson.license)?t.theme.composerJson.license.join(", "):t.theme.composerJson.license)+" ")]):t._e(),t.theme.composerJson.homepage?e("div",{staticClass:"setup__version"},[e("strong",[t._v(t._s(t.$t("ui.package.homepage"))+": ")]),e("a",{attrs:{href:t.theme.composerJson.homepage,target:"_blank"}},[t._v(t._s(t.theme.composerJson.homepage))])]):t._e(),e("button",{staticClass:"widget-button widget-button--info widget-button--details",on:{click:t.themeDetails}},[t._v(t._s(t.$t("ui.package.detailsButton")))])]),e("main",{staticClass:"setup__form"},[t.theme.files?e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.create-project.themeTitle")))]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.create-project.themeDetails")))]),e("div",{staticClass:"setup__tabs"},[e("div",{staticClass:"setup__tab-controls"},[e("button",{staticClass:"setup__tab-control",class:{"setup__tab-control--active":"require"===t.view},on:{click:function(e){t.view="require"}}},[t._v(t._s(t.$tc("ui.setup.create-project.themeRequire",Object.keys(t.theme.composerJson.require).length)))]),e("button",{staticClass:"setup__tab-control",class:{"setup__tab-control--active":"files"===t.view},on:{click:function(e){t.view="files"}}},[t._v(t._s(t.$tc("ui.setup.create-project.themeFiles",t.theme.files.length)))])]),"require"===t.view?e("div",{staticClass:"setup__tab"},[e("table",{staticClass:"setup__requires"},[e("tbody",[t._l(t.theme.composerJson.require,(function(a,n){return[e("tr",{key:n},[e("td",[t._v(t._s(n)+":")]),e("td",[t._v(t._s(a))])])]}))],2)])]):t._e(),"files"===t.view?e("div",{staticClass:"setup__tab setup__tab--files"},[e("file-tree",{attrs:{files:t.themeFiles}})],1):t._e()]),e("p",{staticClass:"setup__fielddesc setup__fielddesc--warning"},[t._v(t._s(t.$t("ui.setup.create-project.themeWarning")))])]):t._e(),e("div",{staticClass:"setup__actions"},[e("loading-button",{attrs:{color:"primary",icon:"run",loading:t.processing},on:{click:t.installTheme}},[t._v(t._s(t.$t("ui.setup.create-project.install")))]),e("button",{staticClass:"widget-button",attrs:{disabled:t.processing},on:{click:t.cancelTheme}},[t._v(t._s(t.$t("ui.setup.create-project.cancel")))])],1)])]:[e("header",{staticClass:"setup__header"},[e("img",{staticClass:"setup__icon",attrs:{src:a(135),width:"80",height:"80",alt:""}}),e("h1",{staticClass:"setup__headline"},[t._v(t._s(t.$t("ui.setup.create-project.headline")))]),e("i18n",{staticClass:"setup__description",attrs:{tag:"p",path:"ui.setup.create-project.description"},scopedSlots:t._u([{key:"semver",fn:function(){return[e("a",{attrs:{href:"https://semver.org",target:"_blank",rel:"noreferrer noopener"}},[t._v(t._s(t.$t("ui.setup.create-project.semver")))])]},proxy:!0}])}),e("ul",{staticClass:"setup__versions"},[t._l(t.versions,(function(a){return[a.description?[a.disabled?e("li",{key:a.value,staticClass:"setup__version"},[e("strong",[t._v(t._s(a.label))]),e("br"),e("span",{staticClass:"setup__version--warning"},[t._v(t._s(a.problem))])]):e("li",{key:a.value,staticClass:"setup__version"},[e("strong",[t._v(t._s(a.label))]),e("br"),t._v(" "+t._s(a.description)+" ")])]:t._e()]}))],2),e("i18n",{staticClass:"setup__releaseplan",attrs:{tag:"p",path:"ui.setup.create-project.releaseplan"},scopedSlots:t._u([{key:"contaoReleasePlan",fn:function(){return[e("a",{attrs:{href:"https://to.contao.org/release-plan?lang=".concat(t.$i18n.locale),target:"_blank",rel:"noreferrer noopener"}},[t._v(t._s(t.$t("ui.setup.create-project.releaseplanLink")))])]},proxy:!0}])})],1),t.contaoVersion?e("main",{staticClass:"setup__form"},[e("div",{staticClass:"setup__fields setup__fields--center"},[e("svg",{staticClass:"setup__check",attrs:{xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"}})]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.create-project.installed",{version:t.contaoVersion})))])]),e("div",{staticClass:"setup__actions setup__actions--center"},[e("button",{staticClass:"widget-button widget-button--inline",on:{click:t.launch}},[t._v(t._s(t.$t("ui.setup.manager")))]),e("button",{staticClass:"widget-button widget-button--inline widget-button--primary",on:{click:function(e){return t.$emit("continue")}}},[t._v(t._s(t.$t("ui.setup.continue")))])])]):e("main",{staticClass:"setup__form"},[e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.create-project.formTitle")))]),e("p",{staticClass:"setup__fielddesc setup__fielddesc--version"},[t._v(t._s(t.$t("ui.setup.create-project.formText")))]),e("radio-button",{attrs:{name:"version",options:t.versions,disabled:t.processing},model:{value:t.version,callback:function(e){t.version=e},expression:"version"}}),"theme"===t.version?e("div",{staticClass:"setup__theme"},[e("p",[t._v(t._s(t.$t("ui.setup.create-project.themeInstall")))]),e("i18n",{attrs:{path:"ui.setup.create-project.themeBuy",tag:"p"},scopedSlots:t._u([{key:"store",fn:function(){return[e("a",{attrs:{href:"https://themes.contao.org",target:"_blank"}},[t._v(t._s(t.$t("ui.setup.create-project.themeStore")))])]},proxy:!0}],null,!1,1998167673)}),e("div",{directives:[{name:"show",rawName:"v-show",value:t.$refs.uploader&&t.$refs.uploader.dropActive,expression:"$refs.uploader && $refs.uploader.dropActive"}],staticClass:"package-uploads__overlay"},[e("div",[e("img",{attrs:{src:a(77591),alt:"",width:"128",height:"128"}}),e("p",[t._v(t._s(t.$t("ui.packages.uploadOverlay")))])])])],1):[e("check-box",{attrs:{name:"demo",label:t.$t("ui.setup.create-project.demo"),disabled:t.processing},scopedSlots:t._u([{key:"description",fn:function(){return[e("i18n",{attrs:{tag:"p",path:"ui.setup.create-project.demoDescription"},scopedSlots:t._u([{key:"store",fn:function(){return[e("a",{attrs:{href:"https://themes.contao.org",target:"_blank"}},[t._v(t._s(t.$t("ui.setup.create-project.themeStore")))])]},proxy:!0}])})]},proxy:!0}]),model:{value:t.demo,callback:function(e){t.demo=e},expression:"demo"}})]],2),e("div",{staticClass:"setup__fields"},["theme"===t.version?[e("loading-button",{attrs:{color:"primary",icon:"upload",loading:t.processing},on:{click:t.openFileSelector}},[t._v(t._s(t.$t("ui.setup.create-project.themeUpload")))]),e("div",{staticClass:"setup__or"},[e("span",[t._v(t._s(t.$t("ui.setup.create-project.theme.or")))])]),e("search-input",{attrs:{placeholder:t.$t("ui.setup.create-project.theme.search"),disabled:t.processing}})]:e("button-group",{attrs:{color:"primary",icon:"run",disabled:!t.version,loading:t.processing,label:t.$t("ui.setup.create-project.install")},on:{click:function(){return t.install()}}},[t.demo?t._e():e("button",{staticClass:"widget-button",attrs:{disabled:!t.version||t.processing},on:{click:t.installCoreOnly}},[t._v(t._s(t.$t("ui.setup.create-project.coreOnly")))]),e("button",{staticClass:"widget-button",attrs:{disabled:!t.version||t.processing},on:{click:t.installNoUpdate}},[t._v(t._s(t.$t("ui.setup.create-project.noUpdate")))])])],2)]),e("div",{staticClass:"clearfix"}),t.searching||t.results||t.offline?e("div",{staticClass:"setup__themes"},[t.searching&&!t.results?e("loading-spinner",{staticClass:"setup__theme-search setup__theme-search--loader"},[e("p",[t._v(t._s(t.$t("ui.discover.loading")))])]):t.offline?e("div",{staticClass:"setup__theme-search setup__theme-search--offline"},[e("p",[t._v(t._s(t.$t("ui.discover.offline")))]),e("p",[t._v(t._s(t.$t("ui.discover.offlineExplain")))]),e("button",{staticClass:"widget-button widget-button--inline widget-button--update",on:{click:t.searchThemes}},[t._v(t._s(t.$t("ui.discover.offlineButton")))])]):t.isSearching&&t.results&&!Object.keys(t.results).length?e("div",{staticClass:"setup__theme-search setup__theme-search--empty"},[e("i18n",{attrs:{tag:"p",path:"ui.setup.create-project.theme.empty"},scopedSlots:t._u([{key:"query",fn:function(){return[e("i",[t._v(t._s(t.query))])]},proxy:!0}],null,!1,1926817678)})],1):t.isSearching&&t.results?[e("div",{staticClass:"setup__themes-results"},t._l(t.results,(function(t){return e("discover-package",{key:t.name,staticClass:"setup__themes-item",attrs:{data:t}})})),1),e("div",{staticClass:"setup__themes-more"},[t.hasMore?e("loading-button",{attrs:{inline:"",icon:"search",loading:t.searching},on:{click:t.loadMore}},[t._v(t._s(t.$t("ui.setup.create-project.theme.more")))]):t._e()],1)]:t._e()],2):t._e()]],2)},Ko=[],Zo=(a(99449),a(11392),a(54686)),tr=a.n(Zo),er=a(61881),ar=function(){var t=this,e=t._self._c;return e("package-details",{scopedSlots:t._u([{key:"package-actions",fn:function(){return[!t.isTheme||t.data.uploaded||t.isPrivate?t.data.homepage||t.metadata.homepage?e("a",{staticClass:"widget-button widget-button--primary widget-button--link",attrs:{target:"_blank",href:t.data.homepage||t.metadata.homepage}},[t._v(t._s(t.$t("ui.package.homepage")))]):t.isPrivate?e("div"):e("a",{staticClass:"widget-button widget-button--primary widget-button--link",attrs:{target:"_blank",href:"https://packagist.org/packages/".concat(t.data.name)}},[t._v(t._s(t.$t("ui.package-details.packagist")))]):[e("button",{staticClass:"widget-button widget-button--primary widget-button--run",on:{click:t.install}},[t._v(t._s(t.$t("ui.setup.create-project.install")))]),e("package-constraint",{staticClass:"theme-details__constraint",attrs:{emit:!0,data:t.data},model:{value:t.version,callback:function(e){t.version=e},expression:"version"}})]]},proxy:!0}])})},nr=[],sr={mixins:[Zt.A,te],components:{PackageConstraint:ua,PackageDetails:Rs},data:function(){return{version:""}},computed:(0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("packages",{allInstalled:"installed"})),(0,k.aH)("packages/details",["current"])),{},{data:function(t){return t.allInstalled[t.current]||{name:t.current}},isPrivate:function(t){return t.metadata&&!!t.metadata.private}}),methods:{install:function(){this.$store.commit("contao/installTheme",{package:this.data.name,version:this.version})}}},ir=sr,or=(0,D.A)(ir,ar,nr,!1,null,null,null),rr=or.exports,cr=a(46264),ur=a(17627),lr=function(){var t=this,e=t._self._c;return e("ul",{staticClass:"file-tree"},[t._l(t.files,(function(a,n){return[a.children.length?e("li",{key:n,class:"file-tree__folder".concat(t.isOpen(a)?" file-tree__folder--open":"")},[e("button",{on:{click:function(e){return t.toggle(a)}}},[t._v(t._s(t.name(a)))]),t.isOpen(a)?e("file-tree",{attrs:{files:a.children}}):t._e()],1):e("li",{key:n,staticClass:"file-tree__file"},[e("span",[t._v(t._s(t.name(a)))])])]}))],2)},dr=[],pr={name:"FileTree",props:{files:{type:Array,required:!0}},data:function(){return{open:[]}},computed:{name:function(){return function(t){return t.name?t.name:t.path.substring(t.path.lastIndexOf("/")+1)}},isOpen:function(t){return function(e){return t.open.includes(e)}}},methods:{toggle:function(t){this.open.includes(t)?this.open=this.open.filter((function(e){return e!==t})):this.open.push(t)}}},hr=pr,gr=(0,D.A)(hr,lr,dr,!1,null,null,null),mr=gr.exports,fr={mixins:[er.A],components:{ButtonGroup:ma,FileTree:mr,DiscoverPackage:ur.A,LoadingSpinner:un.A,SearchInput:cr.A,FileUpload:Se(),RadioButton:Jo,CheckBox:Bi,LoadingButton:R.A},data:function(){return{processing:!1,isWeb:!0,version:"5.4",demo:!1,view:"require",theme:null,themeImage:null,searching:!1,results:null,hasMore:!1,offline:!1}},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("tasks",{taskStatus:"status"})),(0,k.aH)("server/php-web",["phpVersionId","phpVersion"])),(0,k.aH)("server/contao",["contaoVersion"])),(0,k.aH)("contao",{themeName:"package",themeVersion:"version"})),{},{themeFiles:function(t){return tr()(t.theme.files,{directoriesFirst:!0}).children},versions:function(){var t=[];return t.push({value:"5.4",label:"Contao 5.4 (".concat(this.$t("ui.setup.create-project.latestTitle"),")"),disabled:this.phpVersionId<80100,description:this.$t("ui.setup.create-project.latestQ1",{year:"2025"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"8.1.0",current:this.phpVersion})}),t.push({value:"5.3",label:"Contao 5.3 (".concat(this.$t("ui.setup.create-project.ltsTitle"),")"),disabled:this.phpVersionId<80100,description:this.$t("ui.setup.create-project.ltsText",{year:"2027"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"8.1.0",current:this.phpVersion})}),t.push({value:"4.13",label:"Contao 4.13 (".concat(this.$t("ui.setup.create-project.ltsTitle"),")"),disabled:this.phpVersionId<70400,description:this.$t("ui.setup.create-project.pltsText",{year:"2025"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"7.4.0",current:this.phpVersion})}),this.phpVersionId<70400&&t.push({value:"4.9",label:"Contao 4.9",disabled:!this.isWeb,description:this.$t("ui.setup.create-project.pltsText",{year:"2023"}),problem:this.$t("ui.setup.create-project.requiresDocroot",{folder:"web"})}),t.push({value:"theme",label:this.$t("ui.setup.create-project.theme")}),t}}),watch:{version:function(){this.stopSearch(),this.searching=!1,this.results=null,this.hasMore=!1},sorting:function(){this.searchThemes()},query:function(){this.results=null,this.query?this.searchThemes():(this.searching=!1,this.hasMore=!1)},pages:function(){this.searchThemes()},themeName:function(){this.closePopup(),this.install({package:this.themeName,version:this.themeVersion})}},methods:(0,b.A)((0,b.A)({},(0,k.PY)("packages/details",{closePopup:"clearCurrent"})),{},{searchThemes:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n,s;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.searching=!0,t.offline=!1,e.prev=2,a={facetFilters:["type:contao-theme"],hitsPerPage:10*t.pages},t.query?a.query=t.query:t.sorting&&(a.sorting=t.sorting),e.next=7,t.$store.dispatch("algolia/findPackages",a);case 7:if(n=e.sent,t.hasMore=n.nbPages>1,0!==n.nbHits){e.next=12;break}return t.results={},e.abrupt("return");case 12:s={},n.hits.forEach((function(t){s[t.name]=t})),t.results=s,e.next=20;break;case 17:e.prev=17,e.t0=e["catch"](2),t.offline=!0;case 20:t.searching=!1;case 21:case"end":return e.stop()}}),e,null,[[2,17]])})))()},install:function(t){var e=arguments,a=this;return(0,P.A)((0,L.A)().mark((function n(){var s,i;return(0,L.A)().wrap((function(n){while(1)switch(n.prev=n.next){case 0:return s=e.length>1&&void 0!==e[1]?e[1]:null,a.processing=!0,i=t||(a.theme?{upload:a.theme.upload.id}:a.demo?{package:"contao/contao-demo",version:a.version,"no-update":"no-update"===s?"1":"0"}:{version:a.version,"core-only":"core-only"===s?"1":"0","no-update":"no-update"===s?"1":"0"}),n.next=5,a.$store.dispatch("contao/install",i);case 5:if("complete"===a.taskStatus){n.next=7;break}return n.abrupt("return");case 7:if(a.$store.commit("tasks/setDeleting",!0),"no-update"!==s){n.next=13;break}a.$store.commit("setSafeMode",!0),a.$store.commit("setView",A.READY),n.next=21;break;case 13:return n.next=15,a.$store.dispatch("server/contao/get",!1);case 15:return n.t0=n.sent.body.public_dir,a.isWeb="web"===n.t0,n.next=19,Promise.all([a.$store.dispatch("contao/install-tool/fetch",!1),a.$store.dispatch("server/database/get",!1),a.$store.dispatch("contao/backup/fetch",!1)]);case 19:a.$store.commit("contao/backup/setRestore",!0),a.$store.commit("setup",3);case 21:a.$store.dispatch("tasks/deleteCurrent");case 22:case"end":return n.stop()}}),n)})))()},installNoUpdate:function(){this.install(null,"no-update")},installCoreOnly:function(){this.install(null,"core-only")},launch:function(){this.$store.commit("setView",A.READY)},openFileSelector:function(){this.$refs.uploader&&this.$refs.uploader.$el.querySelector("input").click()},filterTheme:function(t,e,a){var n=this;return(0,P.A)((0,L.A)().mark((function s(){return(0,L.A)().wrap((function(s){while(1)switch(s.prev=s.next){case 0:if(!t||e){s.next=5;break}if(/(\.cto|\.zip)$/i.test(t.name)){s.next=5;break}return console&&console.debug("".concat(t.name," is not a .zip or .cto")),alert(n.$t("ui.setup.create-project.themeInvalid")),s.abrupt("return",a());case 5:case"end":return s.stop()}}),s)})))()},uploadTheme:function(t,e){var n=this;return(0,P.A)((0,L.A)().mark((function s(){var i,o,r,c,u,l,d,p,h,g,m,f,_,v;return(0,L.A)().wrap((function(s){while(1)switch(s.prev=s.next){case 0:if(t){s.next=2;break}return s.abrupt("return");case 2:if(n.processing=!0,!(n.$refs.uploader.uploaded&&t&&e&&!t.active&&e.active)){s.next=7;break}return n.theme.upload=t.response.data,t.success&&n.install(),s.abrupt("return");case 7:return t.url=URL.createObjectURL(t.file),s.prev=8,u=new File([t.file],t.name,{type:t.type}),s.next=12,a.e(710).then(a.t.bind(a,71710,23));case 12:return l=s.sent.default,s.next=15,l.loadAsync(u);case 15:return d=s.sent,p=d.filter((function(t){return!["composer.json","theme.xml"].includes(t)&&!t.startsWith("__MACOSX/")&&!t.includes(".DS_Store")&&!t.endsWith("/")})).map((function(t){return t.name})),h=p[0].substring(0,p[0].indexOf("/")+1),p.find((function(t){return t.substr(0,h.length)!==h}))&&(h=""),s.t0=JSON,s.next=22,d.file("".concat(h,"composer.json")).async("string");case 22:return s.t1=s.sent,g=s.t0.parse.call(s.t0,s.t1),s.next=26,d.file("".concat(h,"theme.xml")).async("string");case 26:if(m=s.sent,f=new DOMParser,_=f.parseFromString(m,"application/xml"),n.theme={tstamp:null===(i=_.querySelector('table[name="tl_theme"] field[name="tstamp"]'))||void 0===i?void 0:i.innerHTML,name:null===(o=_.querySelector('table[name="tl_theme"] field[name="name"]'))||void 0===o?void 0:o.innerHTML,author:null===(r=_.querySelector('table[name="tl_theme"] field[name="author"]'))||void 0===r?void 0:r.innerHTML,screenshot:null===(c=_.querySelector('table[name="tl_theme"] field[name="screenshot"]'))||void 0===c?void 0:c.innerHTML,composerJson:g,files:p},!n.theme.screenshot||"NULL"===n.theme.screenshot){s.next=49;break}return s.prev=31,s.next=34,d.file("".concat(h).concat(n.theme.screenshot));case 34:if(v=s.sent,!v){s.next=43;break}return s.t3=URL,s.next=39,v.async("blob");case 39:s.t4=s.sent,s.t2=s.t3.createObjectURL.call(s.t3,s.t4),s.next=44;break;case 43:s.t2=null;case 44:n.themeImage=s.t2,s.next=49;break;case 47:s.prev=47,s.t5=s["catch"](31);case 49:s.next=56;break;case 51:s.prev=51,s.t6=s["catch"](8),console&&console.debug(s.t6),alert(n.$t("ui.setup.create-project.themeInvalid")),n.cancelTheme();case 56:n.processing=!1;case 57:case"end":return s.stop()}}),s,null,[[8,51],[31,47]])})))()},cancelTheme:function(){this.theme=null,this.$refs.uploader.clear()},themeDetails:function(){this.$store.commit("packages/setInstalled",{local:(0,ne.A)({},this.theme.composerJson.name,Object.assign({},this.theme.composerJson,{uploaded:!0}))}),this.$store.commit("packages/details/setCurrent",this.theme.composerJson.name)},installTheme:function(){this.$refs.uploader.active||(this.processing=!0,this.$refs.uploader.active=!0)}}),mounted:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return Object.keys(t.$route.query).length&&t.$router.replace({query:null}),e.next=3,t.$store.dispatch("packages/details/init",{vue:t,component:rr});case 3:return t.$store.commit("packages/setInstalled",{}),e.next=6,t.$store.dispatch("server/contao/get");case 6:e.t0=e.sent.body.public_dir,t.isWeb="web"===e.t0;case 8:case"end":return e.stop()}}),e)})))()}},_r=fr,vr=(0,D.A)(_r,Yo,Ko,!1,null,null,null),br=vr.exports,kr=function(){var t=this,e=t._self._c;return e("section",[e("header",{staticClass:"setup__header"},[e("img",{staticClass:"setup__icon",attrs:{src:a(69472),width:"80",height:"80",alt:""}}),e("h1",{staticClass:"setup__headline"},[t._v(t._s(t.$t("ui.setup.database-connection.headline")))]),e("i18n",{staticClass:"setup__description",attrs:{tag:"p",path:"ui.setup.database-connection.description"},scopedSlots:t._u([{key:"env",fn:function(){return[e("code",[t._v(".env.local")])]},proxy:!0}])})],1),t.currentState?e("transition",{attrs:{name:"animate-flip",type:"transition",mode:"out-in"}},["error"===t.currentState||"edit"===t.currentState?e("main",{key:"setup",staticClass:"setup__form"},[e("form",{on:{submit:function(e){return e.preventDefault(),t.save.apply(null,arguments)}}},[e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.database-connection.formTitle")))]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.database-connection.formText")))]),"edit"!==t.currentState&&""!==t.currentUrl?e("p",{staticClass:"setup__warning"},[t._v(t._s(t.$t("ui.setup.database-connection.error")))]):t._e(),e("text-field",{ref:"url",attrs:{name:"url",type:"url",label:t.$t("ui.setup.database-connection.url"),placeholder:"mysql://user:password@server:port/database",required:"",pattern:t.urlPattern,validate:"",disabled:t.processing,error:t.validUrl?void 0:t.$t("ui.setup.database-connection.validUrl")},on:{keyup:function(e){t.validUrl=!0},blur:t.parseUrl},model:{value:t.url,callback:function(e){t.url=e},expression:"url"}}),e("div",{staticClass:"setup__or"},[e("span",[t._v(t._s(t.$t("ui.setup.database-connection.or")))])]),e("text-field",{attrs:{name:"user",label:t.$t("ui.setup.database-connection.user"),disabled:t.processing},model:{value:t.user,callback:function(e){t.user=e},expression:"user"}}),e("text-field",{attrs:{name:"password",type:"password",label:t.$t("ui.setup.database-connection.password"),disabled:t.processing},model:{value:t.password,callback:function(e){t.password=e},expression:"password"}}),e("text-field",{attrs:{name:"server",label:t.$t("ui.setup.database-connection.server"),disabled:t.processing,required:""},model:{value:t.server,callback:function(e){t.server=e},expression:"server"}}),e("text-field",{attrs:{name:"database",label:t.$t("ui.setup.database-connection.database"),disabled:t.processing,required:""},model:{value:t.database,callback:function(e){t.database=e},expression:"database"}})],1),e("div",{staticClass:"setup__actions"},[e("loading-button",{attrs:{submit:"",color:"primary",icon:"save",loading:t.processing,disabled:!t.valid}},[t._v(t._s(t.$t("ui.setup.database-connection.save")))]),"edit"===t.currentState?e("button",{staticClass:"widget-button",attrs:{type:"button",disabled:t.processing},on:{click:t.load}},[t._v(t._s(t.$t("ui.setup.cancel")))]):t._e()],1)])]):e("main",{key:"confirmation",staticClass:"setup__form"},[e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.database-connection.formTitle")))]),t.url?e("i18n",{staticClass:"setup__fielddesc",attrs:{tag:"p",path:"ui.setup.database-connection.connected"},scopedSlots:t._u([{key:"database",fn:function(){return[e("i",[t._v(t._s(t.database))])]},proxy:!0},{key:"server",fn:function(){return[e("i",[t._v(t._s(t.server))])]},proxy:!0}],null,!1,19071977)}):t._e(),e("button",{staticClass:"widget-button widget-button--edit widget-button--small",attrs:{type:"button"},on:{click:function(e){t.currentState="edit"}}},[t._v(t._s(t.$t("ui.setup.database-connection.change")))])],1),e("transition",{attrs:{name:"animate-flip",type:"transition",mode:"out-in"}},[!t.hasDatabaseError&&t.backupRestore&&t.hasBackups?t.backupRestored?e("div",{key:"restored"},[e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.database-connection.restoreTitle")))]),e("svg",{staticClass:"setup__check",attrs:{xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"}})]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.database-connection.restored")))])]),e("div",{staticClass:"setup__actions setup__actions--center"},[e("button",{staticClass:"widget-button widget-button--primary",attrs:{type:"button"},on:{click:function(e){return t.$store.commit("contao/backup/setRestore",!1)}}},[t._v(t._s(t.$t("ui.setup.continue")))])])]):e("div",{key:"backup"},[e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.database-connection.restoreTitle")))]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$tc("ui.setup.database-connection.restoreText",t.files.length)))]),t.files.length>1?e("radio-button",{attrs:{required:"","allow-html":"",options:t.fileOptions,name:"selection"},model:{value:t.selection,callback:function(e){t.selection=e},expression:"selection"}}):t._e(),e("p",{staticClass:"setup__fielddesc setup__warning"},[t._v(t._s(t.$t("ui.setup.database-connection.backupWarning")))])],1),e("div",{staticClass:"setup__actions"},[e("button",{staticClass:"widget-button widget-button--inline",attrs:{type:"button"},on:{click:function(e){return t.$store.commit("contao/backup/setRestore",!1)}}},[t._v(t._s(t.$t("ui.setup.database-connection.skip")))]),e("button",{staticClass:"widget-button widget-button--inline widget-button--primary",attrs:{type:"button",disabled:t.files.length>1&&!t.selection},on:{click:t.restore}},[t._v(t._s(t.$t("ui.setup.database-connection.restore")))])])]):e("div",{key:"migrate"},[e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.database-connection.schemaTitle")))]),t.status&&t.status.total>0?e("p",{staticClass:"setup__fielddesc setup__warning"},[t._v(t._s(t.$tc("ui.setup.database-connection.".concat(t.currentState),t.status.total)))]):e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.database-connection.noChanges")))])]),e("div",{staticClass:"setup__actions setup__actions--center"},[t.status&&t.status.total>0?[t.hasDatabaseError?t._e():e("button",{staticClass:"widget-button widget-button--inline",attrs:{type:"button"},on:{click:function(e){return t.$emit("continue")}}},[t._v(t._s(t.$t("ui.setup.database-connection.skip")))]),e("button",{staticClass:"widget-button widget-button--inline widget-button--primary",attrs:{type:"button"},on:{click:t.checkMigrations}},[t._v(t._s(t.$t("ui.setup.database-connection.check")))])]:e("button",{staticClass:"widget-button widget-button--primary",attrs:{type:"button"},on:{click:function(e){return t.$emit("continue")}}},[t._v(t._s(t.$t("ui.setup.continue")))])],2)])])],1)]):t._e()],1)},wr=[],Cr={components:{RadioButton:Jo,TextField:Zs,LoadingButton:R.A},data:function(){return{processing:!1,validUrl:!0,valid:!1,validating:!1,currentState:null,url:"",user:"",password:"",server:"localhost",database:"",backup:!0,selection:null}},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("tasks",{taskStatus:"status"})),(0,k.aH)("contao/backup",{backupRestored:"restored",backupRestore:"restore"})),(0,k.aH)("server/database",{currentUrl:"url",urlPattern:"pattern",status:"status"})),(0,k.aH)("contao/backup",["files"])),(0,k.L8)("server/database",{hasDatabaseError:"hasError"})),(0,k.L8)("contao/backup",["hasBackups"])),{},{fileOptions:function(){var t=this;return this.files.map((function(e){return{value:e.name,label:t.$t("ui.setup.database-connection.restoreOption",{date:(0,Pt.A)(e.createdAt),size:ms(e.size)})}}))}}),methods:{datimFormat:function(t){return(0,Pt.A)(t,"short","long")},checkMigrations:function(){this.$store.commit("checkMigrations")},parseUrl:function(){if(this.validateUrl()){this.validating=!0;var t=new RegExp(this.urlPattern,"i").exec(this.url);this.user=t[3]?decodeURIComponent(t[3]):"",this.password=t[5]?decodeURIComponent(t[5]):"",this.server=decodeURIComponent(t[6]),this.database=decodeURIComponent(t[8]),":3306"===this.server.substring(this.server.length-5)?this.server=this.server.substring(0,this.server.length-5):this.server.includes(":")||(this.server="".concat(this.server,":3306")),this.valid=this.validateUrl(),this.validating=!1}},updateUrl:function(){if(!this.validating&&(this.valid=!1,this.server)){var t=this.server.split(":",2),e="".concat(encodeURIComponent(t[0]),":").concat(t[1]||"3306"),a="mysql://";this.user&&(a+=encodeURIComponent(this.user),this.password&&(a+=":"+encodeURIComponent(this.password)),a+="@"),a+=e,this.database&&(a+="/"+encodeURIComponent(this.database)),this.url=a,this.valid=this.validateUrl()}},validateUrl:function(){return this.validUrl=!0,this.valid=!1,""!==this.url&&(this.validUrl=new RegExp(this.urlPattern,"i").test(this.url),this.validUrl)},load:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("server/database/get");case 2:t.url=e.sent.body.url,t.currentState=null===(a=t.status)||void 0===a?void 0:a.type,t.parseUrl(),"error"===t.currentState&&(t.validUrl=!1,t.valid=!1);case 6:case"end":return e.stop()}}),e)})))()},save:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.processing=!0,e.next=3,t.$store.dispatch("server/database/set",t.url);case 3:if(a=e.sent,"error"!==a.body.status.type){e.next=9;break}return t.processing=!1,t.validUrl=!1,t.valid=!1,e.abrupt("return");case 9:return e.next=11,t.$store.dispatch("server/adminUser/get",!1);case 11:t.processing=!1;case 12:case"end":return e.stop()}}),e)})))()},restore:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("tasks/execute",{name:"contao/backup-restore",config:{file:t.files.length>1?t.selection:t.files[0].name,backup:!1}});case 2:if("complete"===t.taskStatus){e.next=4;break}return e.abrupt("return");case 4:return t.$store.commit("contao/backup/setRestored"),e.next=7,t.$store.dispatch("tasks/deleteCurrent");case 7:case"end":return e.stop()}}),e)})))()}},watch:{user:function(){this.updateUrl()},password:function(){this.updateUrl()},server:function(){this.updateUrl()},database:function(){this.updateUrl()},status:function(){var t;this.currentState=null===(t=this.status)||void 0===t?void 0:t.type}},mounted:function(){this.load(),this.selection=null,this.backup=!0}},yr=Cr,$r=(0,D.A)(yr,kr,wr,!1,null,null,null),Ar=$r.exports,xr=function(){var t=this,e=t._self._c;return e("section",[e("header",{staticClass:"setup__header"},[e("img",{staticClass:"setup__icon",attrs:{src:a(9942),width:"80",height:"80",alt:""}}),e("h1",{staticClass:"setup__headline"},[t._v(t._s(t.$t("ui.setup.backend-user.headline")))]),e("p",{staticClass:"setup__description"},[t._v(t._s(t.$t("ui.setup.backend-user.description")))])]),null===t.hasUser?e("main",{staticClass:"setup__form"},[e("div",{staticClass:"setup__fields"},[e("p",{staticClass:"setup__warning"},[t._v(t._s(t.$t("ui.setup.backend-user.error")))]),502===t.response.status?e("console-output",{staticClass:"view-recovery__console",attrs:{title:t.$t("ui.recovery.console"),operations:[{status:"error",summary:"vendor/bin/contao-console contao:user:list",console:t.response.body.detail}],"console-output":t.response.body.detail,"show-console":"","force-console":""}}):t._e()],1)]):e("transition",{attrs:{name:"animate-flip",type:"transition",mode:"out-in"}},[t.hasUser?e("main",{key:"confirmation",staticClass:"setup__form setup__form--center"},[e("div",{staticClass:"setup__fields"},[e("svg",{staticClass:"setup__check",attrs:{xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"}})]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.backend-user.success")))])]),e("div",{staticClass:"setup__actions setup__actions--center"},[e("button",{staticClass:"widget-button widget-button--inline widget-button--primary",attrs:{type:"button"},on:{click:function(e){return t.$emit("continue")}}},[t._v(t._s(t.$t("ui.setup.continue")))])])]):e("main",{key:"setup",staticClass:"setup__form"},[e("form",{on:{submit:function(e){return e.preventDefault(),t.save.apply(null,arguments)}}},[e("div",{staticClass:"setup__fields"},[e("h2",{staticClass:"setup__fieldtitle"},[t._v(t._s(t.$t("ui.setup.backend-user.formTitle")))]),e("p",{staticClass:"setup__fielddesc"},[t._v(t._s(t.$t("ui.setup.backend-user.formText")))]),e("text-field",{ref:"username",attrs:{name:"username",label:t.$t("ui.setup.backend-user.username"),disabled:t.processing,required:"",validate:""},model:{value:t.username,callback:function(e){t.username=e},expression:"username"}}),e("text-field",{ref:"name",attrs:{name:"name",label:t.$t("ui.setup.backend-user.name"),disabled:t.processing,required:"",validate:""},model:{value:t.name,callback:function(e){t.name=e},expression:"name"}}),e("text-field",{ref:"email",attrs:{name:"email",type:"email",label:t.$t("ui.setup.backend-user.email"),disabled:t.processing,required:"",validate:"",error:t.errors.email},on:{focus:function(e){t.errors.email=""},blur:t.validateEmail},model:{value:t.email,callback:function(e){t.email=e},expression:"email"}}),e("text-field",{ref:"password",attrs:{name:"password",type:"password",label:t.$t("ui.setup.backend-user.password"),placeholder:t.$t("ui.setup.backend-user.passwordPlaceholder"),disabled:t.processing,required:"",pattern:".{8,}",validate:"",error:t.errors.password},on:{focus:function(e){t.errors.password=""},blur:t.validatePassword},model:{value:t.password,callback:function(e){t.password=e},expression:"password"}})],1),e("div",{staticClass:"setup__actions setup__actions--center"},[e("loading-button",{attrs:{submit:"",color:"primary",loading:t.processing,disabled:!t.valid}},[t._v(t._s(t.$t("ui.setup.backend-user.create")))])],1)])])])],1)},Sr=[],Dr={components:{TextField:Zs,LoadingButton:R.A,ConsoleOutput:Oi},data:function(){return{processing:!1,valid:!1,username:"",name:"",email:"",password:"",errors:{email:"",password:""}}},computed:(0,b.A)({},(0,k.aH)("server/adminUser",{hasUser:"hasUser",response:"cache"})),methods:{validate:function(){this.valid=this.$refs.username.checkValidity()&&this.$refs.name.checkValidity()&&this.$refs.email.checkValidity()&&this.$refs.password.checkValidity()},validateEmail:function(){this.errors.email=null,""!==this.email&&(this.$refs.email.checkValidity()||(this.errors.email=this.$t("ui.setup.backend-user.emailInvalid")))},validatePassword:function(){this.errors.password=null,""!==this.password&&this.password.length<8&&(this.errors.password=this.$t("ui.setup.backend-user.passwordLength"))},save:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.processing=!0,e.next=3,t.$store.dispatch("server/adminUser/set",{username:t.username,name:t.name,email:t.email,password:t.password});case 3:t.processing=!1,t.$store.commit("setup",5);case 5:case"end":return e.stop()}}),e)})))()}},watch:{username:function(){this.validate()},name:function(){this.validate()},email:function(){this.validate()},password:function(){this.validate()}}},Mr=Dr,Or=(0,D.A)(Mr,xr,Sr,!1,null,null,null),Tr=Or.exports,jr=a(71005),Lr=a(135),Pr=a(69472),Er=a(9942),Br={components:{BoxedLayout:Wa,DocumentRoot:Qo,CreateProject:br,DatabaseConnection:Ar,BackendUser:Tr},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)(["setupStep"])),(0,k.aH)("server/contao",["contaoVersion"])),(0,k.aH)("server/database",{databaseSupported:"supported"})),(0,k.aH)("server/adminUser",{userSupported:"supported"})),{},{currentStep:{get:function(){return this.setupStep},set:function(t){this.$store.commit("setup",t)}},steps:function(){var t=[];return t.push({name:"document-root",icon:jr,component:Qo}),t.push({name:"create-project",icon:Lr,component:br}),this.databaseSupported&&t.push({name:"database-connection",icon:Pr,component:Ar}),this.userSupported&&t.push({name:"backend-user",icon:Er,component:Tr}),t}}),methods:{launch:function(){this.$store.commit("setView",A.READY)}},mounted:function(){this.$store.dispatch("server/adminUser/get"),this.$store.dispatch("contao/backup/fetch")}},Ur=Br,qr=(0,D.A)(Ur,Uo,qo,!1,null,null,null),Rr=qr.exports,Ir=function(){var t=this,e=t._self._c;return e("boxed-layout",{attrs:{wide:!0,slotClass:"view-recovery"}},[e("header",{staticClass:"view-recovery__header"},[e("img",{staticClass:"view-recovery__icon",attrs:{src:a(76682),width:"80",height:"80",alt:""}}),e("h1",{staticClass:"view-recovery__headline"},[t._v(t._s(t.$t("ui.recovery.headline")))])]),e("main",{staticClass:"view-recovery__content"},[e("p",{staticClass:"view-recovery__description"},[t._v(t._s(t.$t("ui.recovery.description")))]),t.console?e("console-output",{staticClass:"view-recovery__console",attrs:{title:t.$t("ui.recovery.console"),operations:[{status:"error",summary:"vendor/bin/contao-console list",console:t.console}],"console-output":t.console,"show-console":"","force-console":""}}):t._e(),e("p",{staticClass:"view-recovery__description"},[t._v(t._s(t.$t("ui.recovery.repairOptions")))]),e("div",{staticClass:"view-recovery__option"},[e("h3",[t._v(t._s(t.$t("ui.recovery.repairHeadline")))]),e("p",[t._v(t._s(t.$t("ui.recovery.repairDescription")))]),e("p",[e("strong",[t._v(t._s(t.$t("ui.recovery.repairWarning")))])]),t.repairFailed?e("p",{staticClass:"view-recovery__failed"},[t._v(t._s(t.$t("ui.recovery.repairFailed")))]):t._e(),e("loading-button",{attrs:{inline:"",color:"alert",icon:"run",disabled:t.repairFailed,loading:t.repairStarted&&!t.repairFailed},on:{click:t.runRepair}},[t._v(t._s(t.$t("ui.recovery.repairButton")))])],1),e("div",{staticClass:"view-recovery__option"},[e("h3",[t._v(t._s(t.$t("ui.recovery.safeModeHeadline")))]),e("p",[t._v(t._s(t.$t("ui.recovery.safeModeDescription")))]),e("button",{staticClass:"widget-button widget-button--inline widget-button--primary",attrs:{disabled:t.repairStarted&&!t.repairFailed},on:{click:t.runSafeMode}},[t._v(t._s(t.$t("ui.recovery.safeModeButton")))])])],1)])},Hr=[],Vr={components:{BoxedLayout:Wa,LoadingButton:R.A,ConsoleOutput:Oi},data:function(){return{repairStarted:!1,repairFailed:!1,console:""}},computed:(0,b.A)({},(0,k.aH)("tasks",{taskStatus:"status"})),methods:{runRepair:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:t.repairStarted=!0,n=[{name:"contao/rebuild-cache"},{name:"composer/install"},{name:"composer/install",config:{"remove-vendor":!0}}];case 2:if(void 0===(a=n.shift())){e.next=22;break}return e.prev=3,e.next=6,t.$store.dispatch("tasks/execute",a);case 6:return e.next=8,t.$store.dispatch("tasks/deleteCurrent");case 8:return window.location.reload(!0),e.abrupt("return");case 12:if(e.prev=12,e.t0=e["catch"](3),"failed"!==t.taskStatus){e.next=18;break}return e.next=17,t.$store.dispatch("tasks/deleteCurrent");case 17:return e.abrupt("break",22);case 18:return e.next=20,t.$store.dispatch("tasks/deleteCurrent");case 20:e.next=2;break;case 22:t.repairFailed=!0;case 23:case"end":return e.stop()}}),e,null,[[3,12]])})))()},runSafeMode:function(){this.$store.commit("setSafeMode",!0),this.$store.commit("setView",A.READY)}},mounted:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch("server/contao/get");case 2:a=e.sent,502===a.status&&a.body.error&&(t.console=a.data.error);case 4:case"end":return e.stop()}}),e)})))()}},Fr=Vr,zr=(0,D.A)(Fr,Ir,Hr,!1,null,null,null),Nr=zr.exports,Jr=function(){var t=this,e=t._self._c;return e("boxed-layout",{attrs:{wide:!0,slotClass:"database-migration"}},[e("header",{staticClass:"database-migration__header"},[e("img",{staticClass:"database-migration__icon",attrs:{src:a(69472),width:"80",height:"80",alt:""}}),e("h1",{staticClass:"database-migration__headline"},[t._v(t._s(t.$t("ui.migrate.headline")))]),"migrations-only"===t.type?e("p",{staticClass:"database-migration__text"},[t._v(t._s(t.$t("ui.migrate.migrationsOnly")))]):t._e(),"schema-only"===t.type?e("p",{staticClass:"database-migration__text"},[t._v(t._s(t.$t("ui.migrate.schemaOnly")))]):t._e(),t.checking?[e("p",{staticClass:"database-migration__description"},[t._v(t._s(t.$t("ui.migrate.loading")))]),e("div",{staticClass:"database-migration__loading"},[e("loading-spinner")],1)]:t.isEmpty?["migrations-only"===t.type?e("p",{staticClass:"database-migration__description"},[t._v(t._s(t.$t("ui.migrate.emptyMigrations")))]):"schema-only"===t.type?e("p",{staticClass:"database-migration__description"},[t._v(t._s(t.$t("ui.migrate.emptySchema")))]):e("p",{staticClass:"database-migration__description"},[t._v(t._s(t.$t("ui.migrate.empty")))]),e("div",{staticClass:"database-migration__actions"},["migrations-only"===t.type||"schema-only"===t.type?e("button",{staticClass:"widget-button widget-button--primary",attrs:{disabled:t.closing},on:{click:function(e){return t.checkAll()}}},[t._v(t._s(t.$t("ui.migrate.retryAll")))]):t._e(),e("loading-button",{attrs:{loading:t.closing},on:{click:t.close}},[t._v(t._s(t.$t("ui.migrate.close")))])],1)]:!t.executing&&(t.isComplete||t.hasError||t.hasProblem)?[t._l(t.description.split("\n"),(function(a,n){return e("p",{key:n,staticClass:"database-migration__description"},[t._v(t._s(a))])})),e("div",{staticClass:"database-migration__actions"},["problem"===t.type?[e("loading-button",{attrs:{loading:t.closing},on:{click:t.close}},[t._v(t._s(t.$t("ui.migrate.cancel")))]),e("button",{staticClass:"widget-button",attrs:{disabled:t.closing},on:{click:t.setup}},[t._v(t._s(t.$t("ui.migrate.setup")))]),e("button",{staticClass:"widget-button widget-button--primary",attrs:{disabled:t.closing},on:{click:function(e){return t.checkAll()}}},[t._v(t._s(t.$t("ui.migrate.retry")))])]:"warning"===t.type?[e("loading-button",{attrs:{loading:t.closing},on:{click:t.close}},[t._v(t._s(t.$t("ui.migrate.cancel")))]),e("button",{staticClass:"widget-button widget-button",attrs:{disabled:t.closing},on:{click:function(e){return t.checkAll()}}},[t._v(t._s(t.$t("ui.migrate.retry")))]),e("button",{staticClass:"widget-button widget-button--primary",attrs:{disabled:t.closing},on:{click:function(e){return t.checkAll(!0)}}},[t._v(t._s(t.$t("ui.migrate.skip")))])]:t.hasChanges?[e("loading-button",{attrs:{loading:t.closing},on:{click:t.close}},[t._v(t._s(t.$t("ui.migrate.cancel")))]),e("button",{staticClass:"widget-button widget-button--primary",attrs:{disabled:t.closing},on:{click:function(e){return t.check()}}},[t._v(t._s(t.$t("ui.migrate.continue")))])]:[e("loading-button",{attrs:{loading:t.closing},on:{click:t.close}},[t._v(t._s(t.$t("ui.migrate.confirm")))])]],2)]:[e("p",{staticClass:"database-migration__description"},[t._v(t._s(t.$t("ui.migrate.pending")))]),e("div",{staticClass:"database-migration__actions"},[e("loading-button",{staticClass:"database-migration__action",attrs:{loading:t.closing,disabled:t.executing},on:{click:t.close}},[t._v(t._s(t.$t("ui.migrate.cancel")))]),e("loading-button",{staticClass:"database-migration__action",attrs:{color:"primary",loading:t.executing,disabled:t.closing},on:{click:t.execute}},[t._v(t._s(t.$t("ui.migrate.execute")))])],1),t.hasDeletes?e("div",{staticClass:"database-migration__actions"},[e("check-box",{attrs:{name:"withDeletes",label:t.$t("ui.migrate.withDeletes"),disabled:t.executing},model:{value:t.withDeletes,callback:function(e){t.withDeletes=e},expression:"withDeletes"}})],1):t._e()]],2),!t.checking&&t.operations&&t.operations.length?e("console-output",{staticClass:"database-migration__main",attrs:{title:t.consoleTitle,operations:t.operations,"console-output":t.console,"show-console":t.showConsole,"force-console":t.hasProblem},on:{"update:showConsole":function(e){t.showConsole=e},"update:show-console":function(e){t.showConsole=e}}}):t._e()],1)},Wr=[],Gr={components:{BoxedLayout:Wa,LoadingSpinner:un.A,LoadingButton:R.A,ConsoleOutput:Oi,CheckBox:Bi},data:function(){return{type:null,status:"",changes:null,hasDeletes:!1,operations:null,hash:null,withDeletes:!1,showConsole:!1,previousResult:!0,checking:!0,executing:!1,closing:!1}},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)("server/database",["supported"])),(0,k.aH)(["setupStep"])),(0,k.L8)("server/database",["hasChanges"])),{},{isEmpty:function(t){return"active"!==t.status&&t.operations&&!t.operations.length},isComplete:function(t){return"complete"===t.status},hasError:function(t){return"error"===t.status},hasProblem:function(t){return"problem"===t.type||"warning"===t.type},description:function(){var t;return"problem"===this.type?this.$tc("ui.migrate.problem",(null===(t=this.operations)||void 0===t?void 0:t.length)||0):"warning"===this.type?this.$t("ui.migrate.warning"):this.previousResult&&this.hasChanges?this.$t("ui.migrate.previousChanges"):this.previousResult?this.$t("ui.migrate.previousComplete"):this.isComplete&&this.hasChanges?this.$t("ui.migrate.appliedChanges"):this.isComplete?this.$t("ui.migrate.appliedComplete"):this.$t("ui.migrate.error")},consoleTitle:function(){switch(this.type){case"migrations":case"migrations-only":return this.$t("ui.migrate.migrationTitle");case"schema":case"schema-only":return this.$t("ui.migrate.schemaTitle");case"problem":return this.$t("ui.migrate.problemTitle");case"warning":return this.$t("ui.migrate.warningTitle")}return""},console:function(){if(!this.changes||!this.changes.length)return"";var t="";return this.changes.forEach((function(e){t+="".concat(e.name,"\n")})),t}}),methods:{poll:function(t){var e=this;return(0,P.A)((0,L.A)().mark((function a(){var n;return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:if(201!==t.status){a.next=2;break}return a.abrupt("return",new Promise((function(t){setTimeout((0,P.A)((0,L.A)().mark((function a(){return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:return a.t0=e,a.next=3,e.$http.get("api/contao/database-migration");case 3:return a.t1=a.sent,a.next=6,a.t0.poll.call(a.t0,a.t1);case 6:t();case 7:case"end":return a.stop()}}),a)}))),1e3)})));case 2:return a.next=4,t.json();case 4:if(n=a.sent,e.changes&&!n.status||(e.type=n.type,e.status=n.status,e.hash=n.hash,e.changes=n.operations),n.status&&"active"!==n.status){a.next=8;break}return a.abrupt("return",new Promise((function(t){setTimeout((0,P.A)((0,L.A)().mark((function a(){return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:return a.t0=e,a.next=3,e.$http.get("api/contao/database-migration");case 3:return a.t1=a.sent,a.next=6,a.t0.poll.call(a.t0,a.t1);case 6:t();case 7:case"end":return a.stop()}}),a)}))),1e3)})));case 8:case"end":return a.stop()}}),a)})))()},execute:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.executing=!0,e.next=3,t.$http.put("api/contao/database-migration",{type:t.type,hash:t.hash,withDeletes:t.withDeletes&&t.hasDeletes});case 3:setTimeout((0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return e.t0=t,e.next=3,t.$http.get("api/contao/database-migration");case 3:return e.t1=e.sent,e.next=6,e.t0.poll.call(e.t0,e.t1);case 6:return e.next=8,t.$store.dispatch("server/database/get",!1);case 8:t.executing=!1;case 9:case"end":return e.stop()}}),e)}))),1e3);case 4:case"end":return e.stop()}}),e)})))()},check:function(){var t=arguments,e=this;return(0,P.A)((0,L.A)().mark((function a(){var n,s,i;return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:if(n=t.length>0&&void 0!==t[0]&&t[0],e.checking=!0,s=e.type||e.$store.state.migrationsType,!e.status){a.next=10;break}return e.type=null,e.status="",e.changes=null,e.hash=null,a.next=10,e.$http.delete("api/contao/database-migration");case 10:return a.next=12,e.$http.get("api/contao/database-migration");case 12:if(i=a.sent,204!==i.status){a.next=18;break}return e.previousResult=!1,a.next=17,e.$http.put("api/contao/database-migration",{type:s,skipWarnings:n});case 17:i=a.sent;case 18:return a.next=20,e.poll(i);case 20:return a.next=22,e.$http.delete("api/contao/database-migration");case 22:e.checking=!1;case 23:case"end":return a.stop()}}),a)})))()},checkAll:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.type=null,this.check(t)},generateStatus:function(t,e){return e?"~".concat(t,"~"):t},close:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:return t.closing=!0,e.next=3,t.$http.delete("api/contao/database-migration");case 3:return e.next=5,t.$store.dispatch("server/database/get",!1);case 5:if(!(t.setupStep>0)){e.next=11;break}return e.next=8,t.$store.dispatch("server/adminUser/get",!1);case 8:t.$store.commit("setView",A.SETUP),e.next=12;break;case 11:t.$store.commit("setView",A.READY);case 12:t.closing=!1;case 13:case"end":return e.stop()}}),e)})))()},setup:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:t.$store.commit("setup",3);case 1:case"end":return e.stop()}}),e)})))()},updateOperations:function(){var t=this;if(this.hasDeletes=!1,this.operations=null,this.changes)if(this.hasProblem)this.operations=this.changes.map((function(t){return{status:t.status,summary:t.name,details:t.message,console:t.trace}}));else if("migrations"!==this.type&&"migrations-only"!==this.type){var e=[];this.changes.forEach((function(a){var n;if(n=new RegExp("^CREATE TABLE ([^ ]+) .+$").exec(a.name),n)e.push({status:a.status,summary:t.$t("ui.migrate.addTable",{table:n[1]}),details:a.message,console:a.name});else{if(n=new RegExp("^DROP TABLE (.+)$").exec(a.name),n)return e.push({status:t.withDeletes?a.status:"skipped",summary:t.generateStatus(t.$t("ui.migrate.dropTable",{table:n[1]}),!t.withDeletes),details:a.message,console:a.name}),void(t.hasDeletes=!0);if(n=new RegExp("^CREATE INDEX ([^ ]+) ON ([^ ]+) \\(([^)]+)\\)$").exec(a.name),n)e.push({status:a.status,summary:t.$t("ui.migrate.createIndex",{name:n[1],table:n[2]}),details:a.message||n[3],console:a.name});else{if(n=new RegExp("^DROP INDEX ([^ ]+) ON ([^ ]+)$").exec(a.name),n)return e.push({status:t.withDeletes?a.status:"skipped",summary:t.generateStatus(t.$t("ui.migrate.dropIndex",{name:n[1],table:n[2]}),!t.withDeletes),details:a.message,console:a.name}),void(t.hasDeletes=!0);if(n=new RegExp("^ALTER TABLE ([^ ]+) (.+)$").exec(a.name),n){var s=n[1],i={status:a.status,summary:[],details:[],console:a.name};a.message&&i.details.push(a.message);var o="";n[2].split("'").forEach((function(t,e){o=e%2?"".concat(o,"'").concat(t.replace(",","%comma%"),"'"):"".concat(o).concat(t)}));var r=o.split(",").map((function(t){return t.trim().replace("%comma%",",")})),c=0;return r.forEach((function(e){var n;return n=new RegExp("^ADD ([^ ]+) (.+)$").exec(e),n?(i.summary.push(t.$t("ui.migrate.addField",{table:s,field:n[1]})),void(a.message||i.details.push(n[2]))):(n=new RegExp("^CHANGE ([^ ]+) ([^ ]+) (.+)$").exec(e),n?(i.summary.push(t.$t("ui.migrate.changeField",{table:s,field:n[1]})),void(a.message||i.details.push(n[3]))):(n=new RegExp("^DROP (.+)$").exec(e),n?(i.summary.push(t.generateStatus(t.$t("ui.migrate.dropField",{table:s,field:n[1]}),!t.withDeletes)),i.details.push(""),t.hasDeletes=!0,void c++):(i.summary.push("ALTER TABLE ".concat(s," ").concat(e)),void i.details.push(""))))})),c===r.length&&(i.status=t.withDeletes?a.status:"skipped"),void e.push(i)}e.push({status:a.status,summary:a.name,details:a.message,console:a.name}),t.hasDeletes=!0}}})),this.operations=e}else this.operations=this.changes.map((function(t){return{status:t.status,summary:t.name,details:t.message}}))}},watch:{changes:function(){this.updateOperations()},withDeletes:function(){this.updateOperations()}},mounted:function(){this.check()}},Xr=Gr,Qr=(0,D.A)(Xr,Jr,Wr,!1,null,null,null),Yr=Qr.exports,Kr={components:{ErrorView:Ns,TaskView:Ii},data:function(){return{views:(0,ne.A)((0,ne.A)((0,ne.A)((0,ne.A)((0,ne.A)((0,ne.A)({},A.ACCOUNT,ni),A.LOGIN,ui),A.BOOT,Bo),A.SETUP,Rr),A.RECOVERY,Nr),A.MIGRATION,Yr),loaded:!1}},computed:(0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)((0,b.A)({},(0,k.aH)(["safeMode"])),(0,k.aH)(["view","error"])),(0,k.aH)("auth",["username"])),(0,k.aH)("tasks",{taskStatus:"status"})),(0,k.L8)("modals",["hasModal","currentModal"])),{},{isInitializing:function(t){return t.view===A.INIT},isReady:function(t){return!t.isInitializing&&!t.currentView&&!t.loaded},isInsecure:function(){return"https:"!==location.protocol&&"localhost"!==location.hostname},currentView:function(t){return t.views[t.view]||null}}),methods:{initColorMode:function(){var t=localStorage.getItem("contao--prefers-dark");null===t&&(t=String(window.matchMedia("(prefers-color-scheme: dark)").matches)),document.documentElement.dataset.colorScheme="true"===t?"dark":"light"}},watch:{isReady:function(t){var e=this;return(0,P.A)((0,L.A)().mark((function a(){return(0,L.A)().wrap((function(a){while(1)switch(a.prev=a.next){case 0:if(!t){a.next=14;break}return a.prev=1,a.next=4,e.$store.dispatch("packages/uploads/load");case 4:return a.next=6,e.$store.dispatch("packages/load");case 6:return a.next=8,e.$store.dispatch("algolia/discover");case 8:a.next=12;break;case 10:a.prev=10,a.t0=a["catch"](1);case 12:e.loaded=!0,e.$store.dispatch("packages/details/init",{vue:e,component:Rs});case 14:case"end":return a.stop()}}),a,null,[[1,10]])})))()},username:function(t){null===t&&(this.$store.commit("tasks/setCurrent",null),this.$store.commit("tasks/setInitialized",!1))}},mounted:function(){var t=this;return(0,P.A)((0,L.A)().mark((function e(){var a,n,s;return(0,L.A)().wrap((function(e){while(1)switch(e.prev=e.next){case 0:if(t.initColorMode(),!t.$route.query.token){e.next=10;break}return e.prev=2,e.next=5,l.Ay.http.post("api/session",{token:t.$route.query.token});case 5:e.next=9;break;case 7:e.prev=7,e.t0=e["catch"](2);case 9:t.$router.replace({name:t.$route.name,query:null});case 10:return e.next=12,t.$store.dispatch("auth/status");case 12:a=e.sent,n=location.pathname.split("/").filter((function(t){return""!==t})),n.unshift("");case 15:if(void 0===n.pop()||!n.length){e.next=30;break}return e.prev=16,e.next=19,t.$http.get("".concat(n.join("/"),"/contao-manager/users.json"),{responseType:"json"});case 19:if(s=e.sent.body,s.users||s.version){e.next=22;break}return e.abrupt("continue",15);case 22:return t.$store.commit("setError",{title:t.$t("ui.app.configSecurity1"),type:"about:blank",status:"500",detail:t.$t("ui.app.configSecurity2")}),e.abrupt("return");case 26:e.prev=26,e.t1=e["catch"](16);case 28:e.next=15;break;case 30:200===a?t.$store.commit("setView",A.BOOT):204===a?t.$store.commit("setView",A.ACCOUNT):401===a||403===a?t.$store.commit("setView",A.LOGIN):t.$store.commit("apiError",{status:a});case 31:case"end":return e.stop()}}),e,null,[[2,7],[16,26]])})))()},created:function(){document.title="Contao Manager | ".concat(location.hostname)}},Zr=Kr,tc=(0,D.A)(Zr,Ts,js,!1,null,null,null),ec=tc.exports;l.Ay.use(d.Ay),l.Ay.use(h()),l.Ay.http.options.emulateHTTP=!0,l.Ay.http.headers.common["Accept"]="application/json",l.Ay.http.interceptors.push((function(t,e){var a=t.url;"api/"===t.url.slice(0,4)&&t.headers.set("Accept-Language",Rt.plugin.locale),e((function(e){if(401===e.status&&"api/session"!==a)return Lt.commit("auth/reset"),void Lt.commit("setView",A.LOGIN);if("application/problem+json"===e.headers.get("Content-Type"))throw 500===e.status&&Lt.commit("setError",e.data),e;if("api/session"!==a||200===e.status){if("api/"===t.url.substring(0,4)&&"application/json"!==e.headers.get("Content-Type")&&e.status>=400&&e.status<=599)throw Lt.commit("setError",{type:"about:blank",status:e.status,request:t,response:e}),e;Lt.commit("auth/renewCountdown")}}))})),(0,g.A)(l.Ay,ec,Ms,Lt,Rt)},54519:function(t,e,a){"use strict";t.exports=a.p+"img/boot.c1251f6b.svg"},18519:function(t,e,a){"use strict";t.exports=a.p+"img/button-update.c63bd5a5.svg"},77591:function(t,e,a){"use strict";t.exports=a.p+"img/button-upload.b489ceec.svg"},135:function(t,e,a){"use strict";t.exports=a.p+"img/create-project.b22522ee.svg"},69472:function(t,e,a){"use strict";t.exports=a.p+"img/database.7f0a8c49.svg"},71005:function(t,e,a){"use strict";t.exports=a.p+"img/document-root.0e6dd2e4.svg"},6894:function(t,e,a){"use strict";t.exports=a.p+"img/logo.9c3b3279.svg"},5579:function(t,e,a){"use strict";t.exports=a.p+"img/php-logo.e15778f8.svg"},76682:function(t,e,a){"use strict";t.exports=a.p+"img/recovery.70ee118a.svg"},17957:function(t,e,a){"use strict";t.exports=a.p+"img/server-config.1a2d0888.svg"},64900:function(t,e,a){"use strict";t.exports=a.p+"img/symfony-logo--dark.36941dc4.svg"},68966:function(t,e,a){"use strict";t.exports=a.p+"img/symfony-logo.9bfb375e.svg"},52228:function(t,e,a){"use strict";t.exports=a.p+"img/task.30a3fdc0.svg"},9942:function(t,e,a){"use strict";t.exports=a.p+"img/user.129e863d.svg"},16363:function(t){"use strict";t.exports="data:image/png;base64,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"},92801:function(){}},e={};function a(n){var s=e[n];if(void 0!==s)return s.exports;var i=e[n]={exports:{}};return t[n].call(i.exports,i,i.exports,a),i.exports}a.m=t,function(){var t=[];a.O=function(e,n,s,i){if(!n){var o=1/0;for(l=0;l<t.length;l++){n=t[l][0],s=t[l][1],i=t[l][2];for(var r=!0,c=0;c<n.length;c++)(!1&i||o>=i)&&Object.keys(a.O).every((function(t){return a.O[t](n[c])}))?n.splice(c--,1):(r=!1,i<o&&(o=i));if(r){t.splice(l--,1);var u=s();void 0!==u&&(e=u)}}return e}i=i||0;for(var l=t.length;l>0&&t[l-1][2]>i;l--)t[l]=t[l-1];t[l]=[n,s,i]}}(),function(){a.n=function(t){var e=t&&t.__esModule?function(){return t["default"]}:function(){return t};return a.d(e,{a:e}),e}}(),function(){var t,e=Object.getPrototypeOf?function(t){return Object.getPrototypeOf(t)}:function(t){return t.__proto__};a.t=function(n,s){if(1&s&&(n=this(n)),8&s)return n;if("object"===typeof n&&n){if(4&s&&n.__esModule)return n;if(16&s&&"function"===typeof n.then)return n}var i=Object.create(null);a.r(i);var o={};t=t||[null,e({}),e([]),e(e)];for(var r=2&s&&n;"object"==typeof r&&!~t.indexOf(r);r=e(r))Object.getOwnPropertyNames(r).forEach((function(t){o[t]=function(){return n[t]}}));return o["default"]=function(){return n},a.d(i,o),i}}(),function(){a.d=function(t,e){for(var n in e)a.o(e,n)&&!a.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})}}(),function(){a.f={},a.e=function(t){return Promise.all(Object.keys(a.f).reduce((function(e,n){return a.f[n](t,e),e}),[]))}}(),function(){a.u=function(t){return"js/"+t+"-legacy."+{28:"da5bae92",44:"fcf9eee5",52:"966ba7cd",120:"4c99f92e",139:"894eff29",140:"e35b1166",164:"40a47c66",180:"1f370e2e",194:"ed831e27",219:"fc32cba9",367:"39f93e6e",477:"908e4c92",486:"6d5eb5d6",518:"5feef192",523:"b3e974f6",540:"b8533ccf",542:"0741319d",551:"3f3b1ac1",553:"24506bdb",554:"a1aaca80",557:"6741a1e6",560:"79a86693",581:"74bebd8c",606:"fd640ebc",638:"bc4501e3",643:"e8d2c597",669:"8a43d5bc",706:"08db35f2",710:"a4174541",715:"dd945745",716:"6667f3c2",721:"d6ed9613",769:"91268d26",851:"705ac32c",874:"7603d6d2",953:"61dcbdfd",958:"7876f68e"}[t]+".js"}}(),function(){a.miniCssF=function(t){}}(),function(){a.g=function(){if("object"===typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"===typeof window)return window}}()}(),function(){a.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)}}(),function(){var t={},e="contao-manager:";a.l=function(n,s,i,o){if(t[n])t[n].push(s);else{var r,c;if(void 0!==i)for(var u=document.getElementsByTagName("script"),l=0;l<u.length;l++){var d=u[l];if(d.getAttribute("src")==n||d.getAttribute("data-webpack")==e+i){r=d;break}}r||(c=!0,r=document.createElement("script"),r.charset="utf-8",r.timeout=120,a.nc&&r.setAttribute("nonce",a.nc),r.setAttribute("data-webpack",e+i),r.src=n,0!==r.src.indexOf(window.location.origin+"/")&&(r.crossOrigin="anonymous")),t[n]=[s];var p=function(e,a){r.onerror=r.onload=null,clearTimeout(h);var s=t[n];if(delete t[n],r.parentNode&&r.parentNode.removeChild(r),s&&s.forEach((function(t){return t(a)})),e)return e(a)},h=setTimeout(p.bind(null,void 0,{type:"timeout",target:r}),12e4);r.onerror=p.bind(null,r.onerror),r.onload=p.bind(null,r.onload),c&&document.head.appendChild(r)}}}(),function(){a.r=function(t){"undefined"!==typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})}}(),function(){a.p=""}(),function(){var t={524:0};a.f.j=function(e,n){var s=a.o(t,e)?t[e]:void 0;if(0!==s)if(s)n.push(s[2]);else{var i=new Promise((function(a,n){s=t[e]=[a,n]}));n.push(s[2]=i);var o=a.p+a.u(e),r=new Error,c=function(n){if(a.o(t,e)&&(s=t[e],0!==s&&(t[e]=void 0),s)){var i=n&&("load"===n.type?"missing":n.type),o=n&&n.target&&n.target.src;r.message="Loading chunk "+e+" failed.\n("+i+": "+o+")",r.name="ChunkLoadError",r.type=i,r.request=o,s[1](r)}};a.l(o,c,"chunk-"+e,e)}},a.O.j=function(e){return 0===t[e]};var e=function(e,n){var s,i,o=n[0],r=n[1],c=n[2],u=0;if(o.some((function(e){return 0!==t[e]}))){for(s in r)a.o(r,s)&&(a.m[s]=r[s]);if(c)var l=c(a)}for(e&&e(n);u<o.length;u++)i=o[u],a.o(t,i)&&t[i]&&t[i][0](),t[i]=0;return a.O(l)},n=self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[];n.forEach(e.bind(null,0)),n.push=e.bind(null,n.push.bind(n))}();var n=a.O(void 0,[504],(function(){return a(24395)}));n=a.O(n)})();"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[874],{62874:function(e){e.exports=JSON.parse('{"ui.app.title":"Rozšíření Contaa","ui.app.loading":"Načítání seznamu rozšíření...","ui.app.language":"Změnit jazyk Správce Contaa","ui.app.colorDark":"Tmavé zobrazení","ui.app.colorDarkTitle":"Změnit na tmavé prostředí","ui.app.colorLight":"Světlé zobrazení","ui.app.colorLightTitle":"Změnit na světlé prostředí","ui.discover.advertisement":"Reklama v seznamu rozšíření","ui.discover.loading":"Spouštění…","ui.discover.offline":"Nemůžu načíst žádné výsledky.","ui.discover.offlineExplain":"Zkontrolujte prosím Vaše internetové připojení a deaktivujte blokování JavaScriptu ve Vašem prohlížeči.","ui.discover.offlineButton":"Zkusit znovu","ui.discover.searchPlaceholder":"Prohledat {count} rozšíření...","ui.discover.empty":"Žádné výsledky pro {query}","ui.discover.more":"Více výsledků","ui.discover.sortBy":"Seřadit podle","ui.discover.sortReleased":"Zveřejněno","ui.discover.sortReleasedTitle":"Seřadit výsledky podle zveřejnění","ui.discover.sortLatest":"Zaktualizované","ui.discover.sortLatestTitle":"Seřadit výsledky podle naposledy zaktualizovaných","ui.discover.sortDownloads":"Stažení","ui.discover.sortDownloadsTitle":"Seřadit výsledky podle počtu stažení","ui.discover.sortFavers":"Hodnocení","ui.discover.sortFaversTitle":"Seřadit výsledky podle hodnocení","ui.discover.detailsButton":"Podrobnosti","ui.discover.latestPackages":"Poslední a naposledy zaktualizovaná rozšíření","ui.discover.faversPackages":"Nejlépe hodnocená rozšíření","ui.discover.downloadsPackages":"Nejvíce stahovaná rozšíření","ui.package.homepage":"Stránka projektu","ui.package.private":"Soukromý balíček","ui.package.privateTitle":"Soukromé balíčky jsou dostupné pouze z vendoru (např. jako soubor ZIP). Více informací získáte na následujícím webu. ","ui.package.abandoned":"nepřijatý","ui.package.abandonedText":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí.","ui.package.abandonedReplace":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí. Autor místo něho doporučuje použít {replacement}. ","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Předešlé podrobné informace k rozšíření","ui.package-details.close":"Zavřít podrobné informace k rozšíření","ui.package-details.loading":"Spouštění…","ui.package-details.tabDescription":"Popis","ui.package-details.tabRequire":"Požadavky","ui.package-details.tabFeatures":"Funkce","ui.package-details.tabSuggest":"Doporučení","ui.package-details.tabConflict":"Konflikty","ui.package-details.tabDependents":"Závislosti","ui.package-details.linkRequires":"vyžaduje","ui.package-details.linkReplaces":"nahrazuje","ui.package-details.linkProvides":"poskytuje","ui.package-details.linkConflicts":"konflikty","ui.package-details.funding":"Nalezen vyvíjený balíček!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Poslední verze","ui.package-details.released":"Zveřejněno","ui.package-details.license":"Licence","ui.package-details.authors":"od","ui.package-details.more":"Více","ui.package-details.packagist":"Podrobnosti k balíčku","ui.package-details.metadata":"Upravit meta informace","ui.package-details.support_docs":"Dokumentace","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Podpora ve fóru","ui.package-details.support_issues":"Chyby / nahlášení chyb","ui.package-details.support_source":"Zdrojový kód","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Mail podpory","ui.package-details.support_rss":"Kanál RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[44],{60044:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Bağlantı güvenli değil !!","ui.app.httpsDescription":"HTTPS olmadan verileriniz şifrelenmeden aktarılır ve başkaları tarafından görülebilir.","ui.app.httpsLink":"Ayrıntılı bilgi alın","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Güvenli kip etkin !!","ui.app.safeModeDescription":"Bazı Contao Manager özellikleri kullanılamaz.","ui.app.safeModeExit":"Güvenli kipten çık","ui.app.loading":"Contao Manager yükleniyor…","ui.app.apiError":"Beklenmeyen API durumu","ui.app.configSecurity1":"GÜVENLİK UYARISI !!! Yapılandırma klasörünün korunmadığı algılandı","ui.app.configSecurity2":"Contao Manager, yapılandırma dosyalarının herkese açık olduğunu algıladı. Klasörün güvenliği sağlanana kadar tüm işlemler etkisizleştirilecek. Yoksa bir saldırgan kurulumunuzun hassas verilerine erişebilir.\\n\\nBu sorunu gidermek için sunucunuzdaki \\"contao-manager\\" klasörüne erişimi engellediğinizden emin olun. Bunu nasıl yapacağınızı öğrenmek için site sunucunuzun belgelerine bakın veya barındırma hizmeti sağlayıcınızla görüşün.","ui.account.welcome":"Hoş geldiniz","ui.account.intro1":"Contao açık kaynaklı içerik yönetimi sistemini kurmak ve yönetmek için kullanılan Contao Manager uygulamasına hoş geldiniz. İlk kez kullanıyorsanız {readTheManualToGetStarted}.","ui.account.introGetStarted":"Başlamak için {readTheManualToGetStarted}.","ui.account.introManual":"rehberi okuyun","ui.account.intro2":"Herhangi bir sorunla karşılaşırsanız,  {ourGithubIssues} bakın ve henüz bildirilmemiş bir sorunu bildirmekten çekinmeyin.","ui.account.introIssues":"GitHub sorunlarımıza","ui.account.headline":"Kullanıcı hesabı","ui.account.description":"Kuurlumunuzu yönetmek için bir Contao Manager hesabı açın. Bu hesabın Contao ön yüzü ve yönetim bölümü ile ilgili olmadığını unutmayın. ","ui.account.username":"Kullanıcı adı","ui.account.password":"Parola","ui.account.passwordPlaceholder":"en az 8 karakter","ui.account.passwordLength":"Lütfen en az 8 karakter yazın.","ui.account.submit":"Hesap aç","ui.account.contribute1":"Contao ve Contao Manager kar amacı gütmeyen Contao Association tarafından desteklenmektedir.","ui.account.contribute2":"Lütfen {donate} açık kaynak dünyasına destek vermeyi değerlendirin.","ui.account.contributeDonate":"bir bağış yaparak","ui.login.headline":"Oturum aç","ui.login.description":"Kurulumunuzu yönetmek için oturum açın.","ui.login.username":"Kullanıcı adı","ui.login.password":"Parola","ui.login.forgotPassword":"Parolamı unuttum","ui.login.button":"Oturum aç","ui.login.locked":"Contao Manager kilitlenmiş olduğundan erişim reddedildi. Kilidi açmak için Contao kök klasöründeki {lockFile} dosyasını silin.","ui.logout.headline":"Oturum zaman aşımına uğradı","ui.logout.warning":"25 dakikadan uzun süredir işlem yapmadınız. Güvenlik nedeniyle oturumunuz kısa bir süre içinde sonlandırılacak.","ui.logout.expired":"30 dakikadan uzun süredir işlem yapmadığınız için oturumunuz otomatik olarak sonlandırıldı.","ui.logout.renew":"Oturumu açık tut","ui.logout.logout":"Oturumu kapat","ui.logout.login":"Oturum açmaya dön","ui.oauth.error":"OAuth girişimi geçersiz. İstek parametrelerini denetleyin.","ui.oauth.https":"Yönlendirme adresi, kimlik doğrulama belirtecinin düz metin olarak iletilmesini önlemek için güvenli bir iletişim kuralı (https:) kullanmalıdır.","ui.oauth.headline":"Uzaktan kimlik doğrulama","ui.oauth.description":"Şu uygulama ya da hizmet Contao Manager kopyanıza uzaktan erişmek istiyor.","ui.oauth.domain":"Erişim izni vermeden önce bu adresi bildiğinizden ve sahibine güvendiğinizden emin olun!","ui.oauth.allow":"Erişime izin ver","ui.oauth.deny":"Erişimi reddet","ui.boot.headline":"Sistem denetimi","ui.boot.description":"Lütfen sunucunuz incelenirken bekleyin…","ui.boot.issue1":"Kurulum sorunları algılandı","ui.boot.issue2":"Kurulumunuzda Contao Manager kullanabilmek için düzeltmeniz gereken sorunlar var.","ui.boot.run":"Contao Manager uygulamasını başlat","ui.boot.safeMode":"Güvenli kipte başlat","ui.recovery.headline":"Sistem kurtarma","ui.recovery.description":"Contao Manager, Contao kurulumuna benzeyen dosyalar algıladı, ancak komut satırı arabirimi beklendiği gibi çalışmıyor.","ui.recovery.console":"Konsol çıktısı","ui.recovery.repairOptions":"Lütfen kurulumunuzu onarmak için bir seçim yapın.","ui.recovery.repairHeadline":"Otomatik onarım","ui.recovery.repairDescription":"Uygulama ön belleğini yeniden oluşturup Composer paketlerini yeniden kurarak kurulumu otomatik olarak onarmayı dener.","ui.recovery.repairWarning":"İşlem sırasında üretici dosyalarında yapılmış herhangi bir değişiklik silinebilir!","ui.recovery.repairFailed":"Otomatik onarım başarılı olmadı. Kurulumu el ile onarmak için güvenli kipi deneyin.","ui.recovery.repairButton":"Sistem onarımını başlat","ui.recovery.safeModeHeadline":"Güvenli kip","ui.recovery.safeModeDescription":"Contao Manager güvenli kipte çalıştırıldığında, paketlerin yönetimine ve belirli bakım işlemlerine izin verir. Ancak çalışan bir Contao kurulumu ile ilgili özellikleri kullanılamaz.","ui.recovery.safeModeButton":"Güvenli kipte başlat","ui.server.pending":"Bekleniyor…","ui.server.running":"İnceleniyor…","ui.server.error":"Sunucudan alınan beklenmeyen bir yanıt nedeniyle denetim tamamlanamadı.","ui.server.details":"Ayrıntılar","ui.server.prerequisite":"Eksik bir ön koşul nedeniyle denetim iptal edildi.","ui.server.selfUpdate.title":"Contao Manager güncellemeleri","ui.server.selfUpdate.update":"Yeni Contao Manager {latest} sürümü yayınlanmış.","ui.server.selfUpdate.manualUpdate":"Yeni Contao Manager {latest} sürümü yayınlanmış. Sunucunuz otomatik güncellemeleri desteklemiyor. Lütfen {download} adresinden yeni sürümü indirin.","ui.server.selfUpdate.latest":"Güncel {current} sürümünü kullanıyorsunuz.","ui.server.selfUpdate.dev":"Geliştirme yapımları otomatik güncellemeleri desteklemez.","ui.server.selfUpdate.unsupported":"Yeni bir sürüm yayınlanmış ancak PHP sürümünüzü desteklemiyor.","ui.server.selfUpdate.button":"Otomatik güncelle","ui.server.selfUpdate.continue":"İlerle","ui.server.config.title":"Sunucu yapılandırması","ui.server.config.setup":"Yapılandır","ui.server.config.change":"Değiştir","ui.server.config.save":"Kaydet","ui.server.config.cancel":"İptal","ui.server.config.customOption":"Diğer…","ui.server.config.description":"Arka plan görevlerini doğru bir şekilde çalıştırmak için Contao Manager uygulamasının, PHP komut satırı binary dosyasını nerede bulacağını ve site sürecinden ayrı olarak komutları nasıl çalıştıracağını bilmesi gerekir.","ui.server.config.formTitle":"Sunucu yapılandırması","ui.server.config.formText":"Lütfen PHP binary dosyanızın yolunu yazın. Binary programın PHP sürümünün site işleminizle aynı olduğundan emin olun.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud, sunucunuz yeterli yerel bellek sunmasa bile Composer bağımlılıklarının kurulmasını sağlar. Paket bilgilerinizin Contao Association tarafından işletilen bir bulut sunucusuna aktarılacağını unutmayın.","ui.server.config.cloud":"Composer Resolver Cloud kullanılsın","ui.server.config.cli":"PHP binary dosyası","ui.server.config.stateErrorCli":"Sunucuda geçerli bir PHP binary dosyası bulunamadı.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud desteklenmiyor.","ui.server.config.stateSuccess":"PHP binary dosyası {php_cli} konumunda.","ui.server.php_web.title":"PHP site işlemi","ui.server.php_web.below7":"PHP {version} sürümü bulundu. Lütfen en kısa sürede PHP 7 sürümüne geçin!","ui.server.php_web.success":"PHP {version} sürümü bulundu. Bilinen bir sorun bulunamadı.","ui.server.php_cli.title":"PHP komut satırı arayüzü","ui.server.php_cli.success":"PHP {version} sürümü bulundu. Bilinen bir sorun bulunamadı.","ui.server.composer.title":"Composer ortamı","ui.server.composer.success":"Bilinen bir sorun bulunamadı.","ui.server.composer.install":"Composer bağımlılıkları kurulmamış.","ui.server.composer.button":"Kur","ui.server.contao.title":"Contao kurulumu","ui.server.contao.setup":"Kurulum","ui.server.contao.check":"Veri tabanını denetle","ui.server.contao.empty":"Herhangi bir Contao sürümünü bulunamadı.","ui.server.contao.old":"Contao {version} sürümü Contao Manager ile uyumlu değil. Lütfen kurulumunuzu el ile güncelleyin.","ui.server.contao.found":"Contao {version} sürümü bulundu (API sürümü {api}).","ui.server.contao.connectionError":"Veri tabanı sunucusu ile bağlantı kurulamadı.","ui.server.contao.connectionProblem":"Veri tabanı sorunuyla karşılaşıldı.","ui.server.contao.missingUser":"Yönetici hesabı bulunamadı.","ui.setup.continue":"İlerle","ui.setup.manager":"Contao Manager uygulamasını başlat","ui.setup.cancel":"İptal","ui.setup.welcome":"Hoş geldiniz","ui.setup.welcome1":"Bu yardımcı, açık kaynaklı Contao içerik yönetimi sistemi kurulumunu yapmanız için gerekli adımlarda size yol gösterecek.","ui.setup.welcome2":"Herhangi bir sorunuz varsa belgelere, forumlara, Slack kanalına ve {destek} sayfasına bakabilirsiniz.","ui.setup.support":"topluluk desteği","ui.setup.start":"Başlayalım","ui.setup.complete":"Tebrikler!","ui.setup.complete1":"Contao {version} kuruldu.","ui.setup.complete2":"Kurulum işlemini tamamlamak için gereken veri tabanı bağlantısını yapılandırmak ve yönetim bölümü kullanıcısı oluşturacak kurulum aracını açın.","ui.setup.complete3":"Artık Contao yönetim bölümüne giderek sitenizi oluşturmaya başlayabilirsiniz. Çeşitli eklentilere gerek duyuyorsanız Contao yöneticisi bölümüne gidin.","ui.setup.installTool":"Kurulum aracını açın","ui.setup.login":"Contao oturumu açın","ui.setup.funding":"Özgür yazılım, \\"konuşma özgürlüğü\\" ifadesindeki gibi \\"özgürdür\\". \\"Ücretsiz\\" olmasına rağmen o anlama gelmez. Contao gibi bir açık kaynaklı proje, tek bir kişi veya şirket tarafından toplanamayacak miktarda para gerektirir.\\nContao ile oluşturulmuş bir siteniz varsa veya böyle siteler satıyorsanız, işinizin destekleyen ürüne mali katkıda bulunduğunuzu görmek isteriz.","ui.setup.fundingLink":"Ayrıntılı bilgi alın","ui.setup.document-root.headline":"Site sunucusu kurulumu","ui.setup.document-root.warning":"Contao Manager ile Contao kurmak için site sunucusunun belge kök klasörünü düzeltmeniz gerekir.","ui.setup.document-root.description1":"Contao, herkese açık dosyalar için ayrı bir klasör kullanır. Uygulama dosyaları bu klasörün üst klasörüne kurulur. Klasör yapısı doğru değilse veya klasörler boş değilse Contao kurulamaz.","ui.setup.document-root.description2":"Belge kök klasörünüzü nasıl yapılandıracağınızı bilmiyorsanız, Contao belgelerini okuyun ya da barındırma hizmeti sağlayıcınızla görüşün.","ui.setup.document-root.documentation":"Belgeleri okuyun","ui.setup.document-root.conflictsTitle":"Kurulum klasörü boş değil","ui.setup.document-root.conflictsDirectory":"Gelecekteki Contao kurulumunuzun kök klasörü boş değil. Kurulum işlemi tarafından üzerine yazılabilecek {count} dosya bulundu. Contao için boş bir klasör yapısı oluşturmanız önerilir. Ancak kullanılmadıklarından eminseniz aşağıdaki dosyaları silerek yeniden denetleyebilirsiniz.","ui.setup.document-root.ignoreConflicts":"Boş olmayan bir klasöre Contao kurmak istiyorum. Bu işlemin site alanımdaki var olabilecek dosyaların üzerine yazabileceğini anlıyorum.","ui.setup.document-root.check":"Yeniden denetle","ui.setup.document-root.create":"Klasörleri oluştur","ui.setup.document-root.change":"Klasörleri değiştir","ui.setup.document-root.formTitle":"Klasör kurulumu","ui.setup.document-root.formText1":"Contao Manager, otomatik olarak sunucuda yeni bir klasör yapısı oluşturabilir.","ui.setup.document-root.formText2":"Yeni belge kök klasörünü el ile yapılandırmanız gerekir (örneğin, bir barındırma hizmeti yönetim panosu üzerinden).","ui.setup.document-root.autoconfig":"Sunucu yapılandırmamı değiştirmem gerektiğini anlıyorum. Belge kök klasörünü yapılandırmamak Contao Manager uygulamasını bozacak ve yapılandırma dosyalarını (hesap bilgileri ve parolalar ile birlikte) açığa çıkaracak!","ui.setup.document-root.directory":"Yeni klasör","ui.setup.document-root.currentRoot":"Geçerli belge kök klasörü","ui.setup.document-root.newRoot":"Yeni belge kök klasörü","ui.setup.document-root.finish":"Klasörleri kur","ui.setup.document-root.publicDir":"Herkese açık dosyalar için {dir} klasörünü kullanın (Contao {version} için)","ui.setup.document-root.directoryInvalid":"Lütfen geçerli bir klasör adı yazın.","ui.setup.document-root.directoryExists":"Hedef klasör zaten var. Lütfen farklı bir ad yazın.","ui.setup.document-root.confirmation":"Contao Manager, Contao kurulumunuz için gerekli klasörü oluşturdu. Şimdi site sunucunuzda belge kök klasörünü yapılandırmanız gerekiyor. Bu işlemi yapana kadar bu sayfayı yeniden yüklemeyin.","ui.setup.document-root.reload":"Sayfayı yeniden yükle","ui.setup.document-root.success":"Site sunucunuzdaki klasör yapısı doğru şekilde hazırlanmış!","ui.setup.document-root.installingProjectDir":"Uygulama dosyaları {dir} klasörüne kurulacak.","ui.setup.document-root.installingPublicDir":"Herkese açık dosyalar {dir} klasörüne kurulacak.","ui.setup.document-root.installedProjectDir":"Uygulama dosyaları {dir} klasörüne kuruldu.","ui.setup.document-root.installedPublicDir":"Herkese açık dosyalar {dir} klasörüne kuruldu.","ui.setup.create-project.headline":"Contao kurulumu","ui.setup.create-project.description":"Contao geliştirmesi {semver} ilkesini izler. Her altı ayda bir yeni bir küçük sürüm yayınlanır. Şu anda desteklenen sürümler şunlardır:","ui.setup.create-project.semver":"Anlamsal sürümleme","ui.setup.create-project.latestTitle":"Güncel","ui.setup.create-project.ltsTitle":"Uzun dönemli destek","ui.setup.create-project.latestQ1":"Güncel sürümümüz en fazla özelliği sunar ve {year} Şubat ayına kadar desteklenir.","ui.setup.create-project.latestQ3":"Güncel sürümümüz en fazla özelliği sunar ve {year} Ağustos ayına kadar desteklenir.","ui.setup.create-project.ltsText":"Güncel uzun dönem desteklenen sürümümümüz, kararlılık isteyenler içindir. {year} Şubat ayına kadar uzun dönem desteği sunar.","ui.setup.create-project.pltsText":"Önceki uzun dönem desteklenen sürümümüz. Hala {year} Şubat ayına kadar uzun dönem desteği sunuyor.","ui.setup.create-project.requiresPHP":"En az PHP {version} sürümü gereklidir. Sizin sürümünüz PHP {current}.","ui.setup.create-project.requiresDocroot":"Belge kök klasörü \\"{folder}\\" olmalıdır.","ui.setup.create-project.releaseplan":"Ayrıntılı bilgi almak için {contaoReleasePlan} bölümüne bakabilirsiniz.","ui.setup.create-project.releaseplanLink":"Contao yayınlanma planı","ui.setup.create-project.installed":"Contao {version} sunucuya kuruldu. Veri tabanınızı kurmaya geçin ya da farklı bir sürüm kurmak için Contao Manager uygulamasını başlatın.","ui.setup.create-project.formTitle":"Bir dağıtım seçin","ui.setup.create-project.formText":"Lütfen kurmak istediğiniz sürümü seçin.","ui.setup.create-project.version":"Sürüm","ui.setup.create-project.demo":"Contao tanıtım sitesini kur","ui.setup.create-project.demoDescription":"Tanıtım sitesi Contao ve onun tüm temel özelliklerini tanımanıza yardımcı olur. Daha fazla temayı {store} üzerinde bulabilirsiniz.","ui.setup.create-project.coreOnly":"En küçük kurulum (yalnızca çekirdek)","ui.setup.create-project.noUpdate":"Kurulumu atla (yalnızca uzmanlar)","ui.setup.create-project.theme":"Contao teması","ui.setup.create-project.themeInstall":"Bir Contao teması kurmak için arama girişini kullanın ya da Contao Manager ile kurulabilen bir tema dosyası (.cto/.zip) yükleyin.","ui.setup.create-project.themeBuy":"Resmi {store} adresini açtığınızdan emin olun.","ui.setup.create-project.themeStore":"Contao tema mağazası","ui.setup.create-project.themeUpload":"Tema dosyasını yükle (.cto/.zip)","ui.setup.create-project.themeInvalid":"Yüklenen dosya bir Contao teması değil ya da Contao Manager uygulamasını desteklemiyor.","ui.setup.create-project.themeWarning":"Contao Manager bu temanın sunucunuzla uyumlu olup olmadığını söyleyemez. Sorularınız varsa lütfen tema satıcısına sorun.","ui.setup.create-project.themeTitle":"Tema bilgilerini gözden geçir","ui.setup.create-project.themeDetails":"Bu temayla birlikte şu bağımlılıklar ve dosyalar yüklenecek.","ui.setup.create-project.themeRequire":"{count} bağımlılık | {count} bağımlılık","ui.setup.create-project.themeFiles":"{count} dosya | {count} dosya","ui.setup.create-project.theme.or":"ya da herkese açık temalar arayın","ui.setup.create-project.theme.search":"Tema ara","ui.setup.create-project.theme.more":"Diğer temalar","ui.setup.create-project.theme.empty":"{query} ile eşleşen bir tema yok","ui.setup.create-project.theme.uploaded":"Tema dosyası yüklendi.","ui.setup.create-project.theme.packageName":"Paket adı","ui.setup.create-project.theme.version":"Sürüm","ui.setup.create-project.theme.authors":"Geliştirici(ler)","ui.setup.create-project.install":"Kur","ui.setup.create-project.cancel":"İptal","ui.setup.database-connection.headline":"Veri tabanı bağlantısı","ui.setup.database-connection.description":"Contao, sayfaları, içerikleri, kullanıcıları ve diğer ilişkisel verileri depolamak için bir MySQL veri tabanı (ya da MariaDB gibi uyumlu bir dalı) kullanır. Bağlantı parametreleri, Contao kurulumunuzun proje kök klasöründeki {env} dosyasında bulunur.","ui.setup.database-connection.formTitle":"Bağlantı parametreleri","ui.setup.database-connection.formText":"Bir veri tabanı adresi yazın ya da tek tek kullanıcı adı, parola, sunucu ve veri tabanı alanlarını doldurun.","ui.setup.database-connection.url":"Veri tabanı adresi","ui.setup.database-connection.validUrl":"Veri tabanı adresi geçersiz ya da sunucu bağlantısı kurulamadı.","ui.setup.database-connection.or":"ya da","ui.setup.database-connection.user":"Kullanıcı adı","ui.setup.database-connection.password":"Parola","ui.setup.database-connection.server":"Sunucu (:bağlantı noktası)","ui.setup.database-connection.database":"Veri tabanı adı","ui.setup.database-connection.connected":"{server} üzerindeki {database} veri tabanı ile bağlantı kuruldu.","ui.setup.database-connection.error":"Veri tabanı bağlantısı kurulurken sorun çıktı.","ui.setup.database-connection.problem":"Contao veri tabanı sunucunuzda bir sorunla karşılaştı.","ui.setup.database-connection.schemaTitle":"Veri tabanı şeması","ui.setup.database-connection.migration":"Bekleyen bir aktarım var. | Bekleyen {count} aktarım var.","ui.setup.database-connection.schema":"Bekleyen bir şema güncellemesi var. | Bekleyen {count} şema güncellemesi var.","ui.setup.database-connection.noChanges":"Veri tabanı şemanız güncel","ui.setup.database-connection.check":"Veri tabanını denetle","ui.setup.database-connection.skip":"Atla","ui.setup.database-connection.save":"Kaydet","ui.setup.database-connection.change":"Kimlik doğrulama bilgilerini değiştir","ui.setup.database-connection.restoreTitle":"Veri tabanı içe aktarma","ui.setup.database-connection.restoreText":"Yeni kurduğunuz temada bir veri tabanı yedeği var. Tema verilerini içe aktarmak için veri tabanını geri yükleyin ya da boş bir Contao kurulumuyla başlamak için bu adımı atlayın. | Yeni kurduğunuz temada birkaç veri tabanı yedeği var. Tema verilerini içe aktarmak için bir yedekleme dosyası seçin ya da boş bir Contao kurulumuyla başlamak için bu adımı atlayın.","ui.setup.database-connection.backup":"İçe aktarma işleminden önce geçerli veri tabanının yedeğini alın","ui.setup.database-connection.backupWarning":"İçe aktarım işlemi sırasında veri tabanındaki tüm verilerin üzerine yazılır! Veri tabanı boş değilse öncelikle bir yedeğini alın.","ui.setup.database-connection.restore":"Tema veri tabanını içe aktar","ui.setup.database-connection.restoreOption":"{date} yedeği ({size})","ui.setup.database-connection.restored":"Tema veri tabanınız içe aktarıldı. Veri tabanı şemanızı doğrulamak için ilerleyin.","ui.setup.backend-user.success":"Veri tabanınızda Contao yönetim bölümü için bir yönetici hesabı bulundu. Daha fazla kullanıcı eklemek için Contao yönetim bölümünü kullanın.","ui.setup.backend-user.error":"Kullanıcı listesi alınamıyor. Ayrıntılar için konsol çıktısına bakın.","ui.setup.backend-user.headline":"Yönetim bölümü hesabı","ui.setup.backend-user.description":"Sitenizi yönetmek için Contao yönetim bölümüne erişebilecek en az bir yönetici hesabınızın olması gerekir. Bu hesabın Contao yöneticisi ile ilgili olmadığını unutmayın.","ui.setup.backend-user.formTitle":"Hesap aç","ui.setup.backend-user.formText":"Yeni yönetim bölümü hesabının ayrıntılarını yazın.","ui.setup.backend-user.username":"Kullanıcı adı","ui.setup.backend-user.name":"Ad","ui.setup.backend-user.email":"E-posta adresi","ui.setup.backend-user.emailInvalid":"Lütfen geçerli bir e-posta adresi yazın","ui.setup.backend-user.password":"Parola","ui.setup.backend-user.passwordPlaceholder":"en az 8 karakter","ui.setup.backend-user.passwordLength":"Lütfen en az 8 karakter yazın.","ui.setup.backend-user.create":"Hesap ekle","ui.task.headline":"Arka plan görevi","ui.task.loading":"Ayrıntılar yükleniyor…","ui.task.created":"Ayrıntılar yükleniyor…","ui.task.active":"Lütfen Contao Manager arka planda görev işlemlerini yürütürken bekleyin.","ui.task.complete":"Tüm işlemler tamamlandı. Ayrıntılı bilgi almak için konsol çıktısına bakın.","ui.task.aborting":"Lütfen arka plan işlemleri iptal edilirken bekleyin.","ui.task.stopped":"Bazı arka plan görevleri iptal edildi. Lütfen konsol çıktısını denetleyin.","ui.task.error":"Bir arka plan görevi beklenmedik şekilde durdu. Lütfen konsol çıktısını denetleyin.","ui.task.failed":"Contao Manager bir arka plan görevini başlatamadı!","ui.task.failedDescription1":"İşlemler arka planda yürütülmeye çalışılırken bir sorun çıktı.","ui.task.failedDescription2":"Bu sorun yeniden yaşanırsa sunucunuz desteklenmiyor olabilir.","ui.task.reportProblem":"Sorun bildir","ui.task.sponsor":"Composer Cloud {sponsor} tarafından destekleniyor","ui.task.buttonAudit":"Veri tabanını güncelle","ui.task.buttonClose":"Kapat","ui.task.buttonConfirm":"Onaylayıp kapat","ui.task.buttonCancel":"İptal","ui.task.confirmCancel":"Bu görevi iptal etmek istediğinize emin misiniz? Bu durum Contoa kurulumunuzu bozuk bir durumda bırakabilir!","ui.task.autoclose":"Başarılı işlemlerin görev ayrıntıları kapatılsın","ui.console.toggle":"Konsol çıktısını görüntüle/gizle","ui.console.showLog":"Tüm konsol günlüğünü görüntüle","ui.console.copyLog":"Günlüğü panoya kopyala","ui.migrate.headline":"Veri tabanı güncellemeleri","ui.migrate.migrationsOnly":"(yalnızca aktarımlar)","ui.migrate.schemaOnly":"(yalnızca şema)","ui.migrate.loading":"Lütfen veri tabanınız incelenirken bekleyin…","ui.migrate.empty":"Bekleyen bir aktarım ya da şema güncellemesi bulunamadı. Veri tabanınız güncel.","ui.migrate.emptyMigrations":"Bekleyen bir aktarım bulunamadı. Şema güncellemelerini de denetlediğinizden emin olun.","ui.migrate.emptySchema":"Bekleyen bir şema güncellemesi bulunamadı. Aktarımları da denetlediğinizden emin olun.","ui.migrate.pending":"Veri tabanınız güncel değil. Lütfen aşağıdaki konsol çıktısını denetleyip istenilen değişiklikleri yapın.","ui.migrate.previousChanges":"Daha önceki bir veri tabanı aktarma işlemi onaylanmamış.\\nLütfen aşağıdaki konsol çıktısını denetleyip sonraki değişiklikleri görmek için ilerleyin.","ui.migrate.previousComplete":"Daha önceki bir veri tabanı aktarma işlemi onaylanmamış. Lütfen aşağıdaki konsol çıktısını denetleyin. Bekleyen başka bir değişiklik yok.","ui.migrate.appliedChanges":"Veri tabanı güncellemeleri yapıldı.\\nLütfen aşağıdaki konsol çıktısını denetleyip sonraki değişiklikleri görmek için ilerleyin.","ui.migrate.appliedComplete":"Veri tabanı güncellemeleri yapıldı.\\nBekleyen başka bir aktarım ya da şema güncellemesi yok. Veri tabanınız güncel.","ui.migrate.problem":"Contao, veri tabanı sunucunuzda bazı sorunlarla karşılaştı.\\nNeyin düzeltilmesi gerektiğini öğrenmek için aşağıdaki konsol çıktısını inceleyin. | Contao, veri tabanı sunucunuzda bazı sorunlarla karşılaştı.\\nNeyin düzeltilmesi gerektiğini öğrenmek için aşağıdaki konsol çıktısını inceleyin.","ui.migrate.warning":"Contao, veri tabanı sunucunuzun yanlış yapılandırıldığını algıladı.\\nUyarıları geçici olarak atlayabilirsiniz. Ancak en iyi başarım ve veri bütünlüğü için bu sorunları düzeltmelisiniz.","ui.migrate.error":"Değişiklikler uygulanamadı. Veri tabanınız değişmiş olabilir. Lütfen yeniden denetleyin.","ui.migrate.execute":"Yürüt","ui.migrate.close":"Kapat","ui.migrate.confirm":"Onaylayıp kapat","ui.migrate.cancel":"İptal","ui.migrate.continue":"İlerle","ui.migrate.setup":"Kurulum","ui.migrate.skip":"Atla","ui.migrate.retry":"Yeniden denetle","ui.migrate.retryAll":"Tümünü denetle","ui.migrate.withDeletes":"DROP sorguları ile birlikte tüm veri tabanı değişikliklerini yürütür.","ui.migrate.migrationTitle":"Veri tabanı aktarımları","ui.migrate.schemaTitle":"Şema güncellemeleri","ui.migrate.problemTitle":"Veri tabanı sorunları","ui.migrate.warningTitle":"Veri tabanı uyarıları","ui.migrate.addTable":"{table} tablosunu ekle","ui.migrate.dropTable":"{table} tablosunu sil","ui.migrate.addField":"{table}.{field} alanını ekle","ui.migrate.changeField":"{table}.{field} alanını değiştir","ui.migrate.dropField":"{table}.{field} alanını sil","ui.migrate.createIndex":"{table} tablosuna \\"{name}\\" dizinini ekle ","ui.migrate.dropIndex":"{table} tablosundan \\"{name}\\" dizinini kaldır","ui.widget.mandatory":"Bu alan boş bırakılamaz.","ui.widget.blankOption":"Lütfen seçin…","ui.widget.showPassword":"Parolayı görüntüle","ui.widget.hidePassword":"Parolayı gizle","ui.error.title":"\\"{method} {url}\\" için HTTP isteği başarısız oldu.","ui.error.server500":"Sunucunuzda beklenmeyen bir sorun çıkmış gibi görünüyor. Lütfen site sunucunuzun (Apache/Nginx) günlük dosyalarını ve \\"contao-manager/logs\\" konumundaki Contao Manager günlüklerini denetleyin.","ui.error.response":"Sunucu, {status} durum koduyla bir yanıt verdi.","ui.error.moreLink":"Ayrıntılı bilgiler","ui.error.support":"Contao desteği","ui.footer.help":"Yardım","ui.footer.reportProblem":"Sorun bildir","ui.navigation.discover":"Keşfet","ui.navigation.packages":"Paketler","ui.navigation.tools":"Araçlar","ui.navigation.installTool":"Kurulum aracı","ui.navigation.backend":"Contao yönetim bölümü","ui.navigation.debug":"Contao hata ayıklama kipi","ui.navigation.logViewer":"Günlük görüntüleyici","ui.navigation.phpinfo":"PHP bilgileri","ui.navigation.phpinfoLoading":"PHP bilgileri yükleniyor…","ui.navigation.maintenance":"Bakım","ui.navigation.rebuildCache":"Ön belleği yeniden oluştur","ui.navigation.systemCheck":"Sistem denetimi","ui.navigation.advanced":"Gelişmiş","ui.navigation.logout":"Oturumu kapat","ui.maintenance.database.title":"Veri tabanı aktarımları ve yedekler","ui.maintenance.database.description":"Veri tabanı aktarımları verilerin ve tablo şemalarının tutarlı olduğundan emin olur.","ui.maintenance.database.migrations":"Bekleyen bir veri tabanı aktarımı var | Bekleyen {count} veri tabanı aktarımı var","ui.maintenance.database.schemaUpdates":"Bekleyen bir şema güncellemesi var. | Bekleyen {count} şema güncellemesi var","ui.maintenance.database.error":"Veri tabanı sorunu bulundu.","ui.maintenance.database.warning":"Veri tabanı uyarıları bulundu.","ui.maintenance.database.button":"Veri tabanını denetle","ui.maintenance.database.migrationOnly":"Yalnızca aktarımları denetle","ui.maintenance.database.schemaOnly":"Yalnızca şemayı denetle","ui.maintenance.database.installTool":"Kurulum aracını aç","ui.maintenance.database.createBackup":"Yedek oluştur","ui.maintenance.database.backupUnsupported":"Contao sürümünüzde veri tabanı yedekleri desteklenmiyor.","ui.maintenance.database.backupList":"{date} tarihinde oluşturulmuş bir veri tabanı yedeğiniz var. | {count} veri tabanı yedeğiniz var. En sonuncusu {date} tarihinde oluşturulmuş.","ui.maintenance.database.backupEmpty":"Şu anda herhangi bir veri tabanı yedeğiniz yok.","ui.maintenance.rebuildCache.title":"Uygulama ön belleği","ui.maintenance.rebuildCache.description":"Yapılandırma dosyalarında bir değişiklik yapıldığında uygulama ön belleğinin yeniden oluşturulması gerekir.","ui.maintenance.rebuildCache.rebuildProd":"Üretim ön belleğini yeniden oluştur","ui.maintenance.rebuildCache.rebuildDev":"Geliştirme ön belleğini yeniden oluştur","ui.maintenance.rebuildCache.clearProd":"Üretim ön belleğini temizle","ui.maintenance.rebuildCache.clearDev":"Geliştirme ön belleğini temizle","ui.maintenance.installTool.title":"Contao kurulum aracı","ui.maintenance.installTool.description":"Arka arkaya üç kez yanlış parola yazarsanız Contao kurulum aracı otomatik olarak kilitlenir.","ui.maintenance.installTool.unlock":"Kurulum aracının kilidini aç","ui.maintenance.installTool.lock":"Kurulum aracını kilitle","ui.maintenance.dumpAutoload.title":"Composer sınıf yükleyicisi","ui.maintenance.dumpAutoload.description":"Composer otomatik yükleyici, PHP sınıfının yüklenmesinden sorumludur. Kök klasördeki composer.json dıosyasına özel ad alanları eklendikten sonra otomatik yükleyici indirilmelidir.","ui.maintenance.dumpAutoload.button":"Otomatik yükleyiciyi indir","ui.maintenance.composerInstall.title":"Composer bağımlılıkları","ui.maintenance.composerInstall.description":"Composer bağımlılıkları uygulama kök klasörünüzün altındaki [vendor] klasöründe bulunur. [composerLock] dosyası değiştirildikten ya da el ile yüklendikten sonra bağımlılıkları yeniden kurmak gerekebilir.","ui.maintenance.composerInstall.button":"Kurucuyu başlat","ui.maintenance.composerInstall.update":"Composer güncellemesini başlat","ui.maintenance.composerCache.title":"Composer ön belleği","ui.maintenance.composerCache.description":"Composer, daha iyi başarım sağlamak için indirilen paketleri ön belleğe alır. Ön bellekte bozuk dosyalar gibi sorunlarınız varsa, paketlerin yeniden indirilmesini dayatmak için Composer ön belleğini silmeyi deneyin.","ui.maintenance.composerCache.button":"Ön belleği temizle","ui.maintenance.maintenanceMode.title":"Bakım kipi","ui.maintenance.maintenanceMode.description":"Contao bakım kipine geçirildiğinde, sitede \\"503 Hizmet Kullanılamıyor\\" kalıbı görüntülenir.","ui.maintenance.maintenanceMode.enable":"Etkinleştir","ui.maintenance.maintenanceMode.disable":"Etkisizleştir","ui.maintenance.debugMode.title":"Hata ayıklama kipi","ui.maintenance.debugMode.description":"[appDevPhp] giriş noktası için bir kullanıcı adı ve parola ayarlayarak hata ayıklama kipini etkinleştirin.","ui.maintenance.debugMode.descriptionJwt":"Geçerli etki alanı için hata ayıklama çerezini ayarlayarak hata ayıklama kipini etkinleştirin.","ui.maintenance.debugMode.activate":"Etkinleştir","ui.maintenance.debugMode.deactivate":"Etkisizleştir","ui.maintenance.debugMode.credentials":"Kimlik doğrulama bilgileri","ui.maintenance.debugMode.user":"Lütfen hata ayıklama kipi için bir kullanıcı adı yazın.","ui.maintenance.debugMode.password":"Lütfen hata ayıklama kipi için bir parola yazın.","ui.maintenance.opcodeCache.title":"Opcode ön belleği","ui.maintenance.opcodeCache.description":"Opcode, daha hızlı işlem yapmak için PHP dosyalarını site işleminde ön belleğe alır. Dosyaların değiştirildikten sonra tanınmaması gibi belirli durumlarda silinmelidir.","ui.maintenance.opcodeCache.button":"Ön belleği buda","ui.maintenance.safeMode":"Güvenli kipte kullanılamaz","ui.maintenance.unsupported":"Contao sürümünüz tarafından desteklenmiyor","ui.packages.updateButton":"Paketleri güncelle","ui.packages.searchButton":"Paket arama","ui.packages.searchPlaceholder":"Paketleri ara…","ui.packages.uploadOverlay":"Yüklemek için dosyaları sürükleyip buraya bırakın","ui.packages.uploadButton":"Paketleri yükle","ui.packages.uploadMessage":"Bir onaylanmamış yüklemeniz var. | {count} onaylanmamış yüklemeniz var.","ui.packages.uploadApply":"Yüklemeleri onayla","ui.packages.uploadReset":"Yüklemeleri sil","ui.packages.uploadIncomplete":"Bu dosya tam olarak yüklenmedi. Lütfen kaldırıp yeniden deneyin.","ui.packages.uploadDuplicate":"Bu dosya birden çok kez yüklenmiş gibi görünüyor. Lütfen kopyaları kaldırın.","ui.packages.uploadInstalled":"Bu dosya zaten kurulmuş. Lütfen kopyaları kaldırın.","ui.packages.uploadUnsupported":"Kurulumunuzda yükleme özelliği desteklenmiyor. Lütfen PHP ZIP eklentisinin kurulmuş olduğundan ve bağımlılıklarınızı güncellediğinizden emin olun.","ui.packages.changesMessage":"Bir onaylanmamış değişikliğiniz var. | {count} onaylanmamış değişikliğiniz var.","ui.packages.changesDryrun":"Değişiklik yapmadan dene","ui.packages.changesApply":"Değişiklikleri uygula","ui.packages.changesApplyAll":"Tüm paketleri güncelle","ui.packages.changesDryrunAll":"Tüm paketleri değişiklik yapmadan dene","ui.packages.changesReset":"Değişiklikleri sıfırla","ui.packages.changesReview":"Değişiklikleri gözden geçir","ui.packagelist.loading":"Yükleniyor…","ui.packagelist.uploads":"Yüklemeler","ui.packagelist.added":"Yeni paketler","ui.packagelist.installed":"Kurulmuş paketler","ui.package.hintRevert":"Değişiklikleri geri al","ui.package.hintNoupdate":"Güncelleme","ui.package.hintConstraint":"Değişiklikleri uyguladığınızda, bu paket {constraint} kısıtlaması ile kurulacak.","ui.package.hintConstraintBest":"Değişiklikleri uyguladığınızda, bu paket kullanılabilecek en iyi sürüm ile kurulacak.","ui.package.hintConstraintChange":"Değişiklikleri uyguladığınızda, bu paketin kısıtlamaları \\"{from}\\" yerine \\"{to}\\" olarak değiştirilecek.","ui.package.hintConstraintUpdate":"Değişiklikleri uyguladığınızda, bu paket güncellenecek.","ui.package.hintAdded":"Değişiklikleri uyguladığınızda, bu paket kurulacak.","ui.package.hintRemoved":"Değişiklikleri uyguladığınızda, bu paket kaldırılacak.","ui.package.requiredTitle":"el ile eklendi","ui.package.requiredText":"Bu paket composer.json dosyanızda gerekli olarak belirtilmiş ancak kurulmamış.","ui.package.removedTitle":"el ile kaldırıldı","ui.package.removedText":"Bu paket composer.json dosyanızdan kaldırılmış.","ui.package.installed":"Şu anda kurulu olan:","ui.package.version":"{version} sürümü","ui.package.additionalDownloads":"{count} indirme | {count} indirme","ui.package.additionalStars":"{count} yıldız | {count} yıldız","ui.package.editConstraint":"Düzenle","ui.package.uploadConstraint":"Bu kısıtlama yüklenen paket tarafından tanımlandı.","ui.package.updateButton":"Güncelle","ui.package.removeButton":"Kaldır","ui.package.installButton":"Paket ekle","ui.package.installButtonShort":"Ekle","ui.package.detailsButton":"Ayrıntılar","ui.package.latestConstraint":"güncel sürüm","ui.package.update":"Güncelleme yayınlanmış","ui.package.updateLatest":"güncel sürüm","ui.package.updateAvailable":"{version} yayınlanmış","ui.package.updateUnknown":"sürüm bilinmiyor","ui.package.updateConstraint":"Sürüm kısıtlamanızın dışında yeni bir sürüm yayınlanmış.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"{version} sürümü","ui.cloudStatus.waitingTime":"Bekleme zamanı","ui.cloudStatus.jobs":"Geçerli görevler","ui.cloudStatus.workers":"İşlemler","ui.cloudStatus.approx":"{minutes} dakika","ui.cloudStatus.none":"yok","ui.cloudStatus.short":"ca. {minutes} dakika","ui.cloudStatus.long":"ca. {minutes} dakika {seconds} saniye","ui.cloudStatus.error":"Composer Resolver Cloud durumu alınamıyor. Kaynak bakım yüzünden kapalı ya da sorunlar nedeniyle erişilemiyor olabilir.","ui.cloudStatus.button":"Cloud durumu","ui.cloudStatus.refresh":"Cloud durumunu yenile","ui.log-viewer.loading":"Yükleniyor…","ui.log-viewer.empty":"Sunucunuzda herhangi bir günlük dosyası yok.","ui.log-viewer.reload":"Yeniden yükle","ui.log-viewer.file":"Günlük dosyası","ui.log-viewer.channel":"Kanal","ui.log-viewer.channelTitle":"Bu iletinin günlüğe kaydedileceği kanal.","ui.log-viewer.level":"Düzey","ui.log-viewer.levelTitle":"Günlük iletisinin önem düzeyi.","ui.log-viewer.timeHeader":"Zaman","ui.log-viewer.messageHeader":"İleti","ui.log-viewer.showContext":"Bağlamı görüntüle","ui.log-viewer.hideContext":"Bağlamı gizle","ui.log-viewer.showExtra":"Ekleri görüntüle","ui.log-viewer.hideExtra":"Ekleri gizle","ui.log-viewer.more":"Sonrakileri yükle…","ui.log-viewer.download":"İndir","ui.log-viewer.downloadTitle":"\\"{file}\\" dosyasını indir","ui.log-viewer.prodEnvironment":"Üretim ortamı","ui.log-viewer.devEnvironment":"Geliştirme ortamı (hata ayıklama kipi)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[486],{48486:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao eklentileri","ui.app.loading":"Eklenti listesi yükleniyor…","ui.app.language":"Contao Manager dilini değiştir","ui.app.colorDark":"Koyu kip","ui.app.colorDarkTitle":"Renk temasını koyu olarak değiştir","ui.app.colorLight":"Açık kip","ui.app.colorLightTitle":"Renk temasını açık olarak değiştir","ui.discover.advertisement":"Eklenti listesinde duyuru","ui.discover.loading":"Yükleniyor…","ui.discover.offline":"Herhangi bir sonuç alınamadı.","ui.discover.offlineExplain":"İnternet bağlantınızı denetleyin ve tarayıcınızdaki JavaScript engelleyicileri etkisizleştirin.","ui.discover.offlineButton":"Yeniden dene","ui.discover.searchPlaceholder":"{count} eklentide ara…","ui.discover.empty":"{query} ile eşleşen bir sonuç bulunamadı","ui.discover.more":"Diğer sonuçlar","ui.discover.sortBy":"Sıralama","ui.discover.sortReleased":"Yayınlandı","ui.discover.sortReleasedTitle":"Sonuçlar yayınlanma tarihine göre sıralansın","ui.discover.sortLatest":"Güncellendi","ui.discover.sortLatestTitle":"Sonuçlar güncellenme tarihine göre sıralansın","ui.discover.sortDownloads":"İndirmeler","ui.discover.sortDownloadsTitle":"Sonuçlar indirme sayılarına göre sıralansın","ui.discover.sortFavers":"Değerlendirme","ui.discover.sortFaversTitle":"Sonuçlar değerlendirmeye göre sıralansın","ui.discover.detailsButton":"Ayrıntılar","ui.discover.latestPackages":"Yeni ve güncellenmiş eklentiler","ui.discover.faversPackages":"İyi değerlendirilmiş eklentiler","ui.discover.downloadsPackages":"En çok indirilen eklentiler","ui.package.homepage":"Proje sitesi","ui.package.private":"Özel paket","ui.package.privateTitle":"Özel paketler yalnızca üretici tarafından sağlanabilir (ZIP indirmesi gibi). Ayrıntılı bilgi almak için siteye bakabilirsiniz.","ui.package.abandoned":"kullanımdan kaldırıldı","ui.package.abandonedText":"Bu paket kullanımdan kaldırıldı ve artık geliştirilmiyor.","ui.package.abandonedReplace":"Bu paket kullanımdan kaldırıldı ve artık geliştirilmiyor. Geliştirici bunun yerine  {replacement} paketinin kullanılmasını öneriyor.","ui.package.contaoVersion":"Contao ile kullanılabilir","ui.package-details.previous":"Önceki eklenti bilgileri","ui.package-details.close":"Eklenti bilgilerini kapat","ui.package-details.loading":"Yükleniyor…","ui.package-details.tabDescription":"Açıklama","ui.package-details.tabRequire":"Gereksinimler","ui.package-details.tabFeatures":"Özellikler","ui.package-details.tabSuggest":"Öneriler","ui.package-details.tabConflict":"Çakışmalar","ui.package-details.tabDependents":"Bağımlılar","ui.package-details.linkRequires":"gereksinimi","ui.package-details.linkReplaces":"değişikliği","ui.package-details.linkProvides":"sundukları","ui.package-details.linkConflicts":"çakışması","ui.package-details.funding":"Paketin geliştirilmesine destek olun!","ui.package-details.contaoVersions":"Desteklenen Contao sürümleri","ui.package-details.latest":"Son sürüm","ui.package-details.released":"yayınlanma tarihi","ui.package-details.license":"Lisanslar","ui.package-details.authors":"geliştiren","ui.package-details.more":"Ayrıntılar","ui.package-details.packagist":"Paket bilgileri","ui.package-details.metadata":"Üst verileri düzenle","ui.package-details.support_docs":"Belgeler","ui.package-details.support_wiki":"Viki","ui.package-details.support_forum":"Destek forumu","ui.package-details.support_issues":"Sorunlar / Hata bildirimi","ui.package-details.support_source":"Kaynak kodu","ui.package-details.support_irc":"IRC / Sohbet","ui.package-details.support_email":"Destek e-postası","ui.package-details.support_rss":"RSS akışı"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[557],{51557:function(a){a.exports=JSON.parse('{"ui.app.title":"Расширения Contao","ui.app.loading":"Загрузка списка расширений...","ui.app.language":"Переключить язык Contao Manager","ui.app.colorDark":"Темный режим","ui.app.colorDarkTitle":"Переключить цветовую схему на темную","ui.app.colorLight":"Светлый режим","ui.app.colorLightTitle":"Переключить цветовую схему на светлую","ui.discover.advertisement":"Реклама в списке расширений","ui.discover.loading":"Загрузка...","ui.discover.offline":"Не удалось получить результаты.","ui.discover.offlineExplain":"Проверьте подключение к сети Интернет и отключите блокировку JavaScript в своем браузере.","ui.discover.offlineButton":"Попробовать еще раз","ui.discover.searchPlaceholder":"Поиск в {count} расширениях...","ui.discover.empty":"Нет результатов для {query}","ui.discover.more":"Другие результаты","ui.discover.sortBy":"Сортировать по","ui.discover.sortReleased":"Выпуск","ui.discover.sortReleasedTitle":"Сортировать результаты по дате выпуска","ui.discover.sortLatest":"Обновлено","ui.discover.sortLatestTitle":"Сортировать результаты по последнему обновлению","ui.discover.sortDownloads":"Загрузки","ui.discover.sortDownloadsTitle":"Сортировать результаты по количеству загрузок","ui.discover.sortFavers":"Рейтинг","ui.discover.sortFaversTitle":"Сортировать результаты по рейтингу","ui.discover.detailsButton":"Сведения","ui.discover.latestPackages":"Последние и обновленные расширения","ui.discover.faversPackages":"Расширения с высоким рейтингом","ui.discover.downloadsPackages":"Самые загружаемые расширения","ui.package.homepage":"Веб-сайт проекта","ui.package.private":"Частный пакет","ui.package.privateTitle":"Частные пакеты доступны только у поставщика (наприм., в виде загрузки ZIP-файла). Посетите веб-сайт для получения дополнительной информации.","ui.package.abandoned":"Заброшенный","ui.package.abandonedText":"Этот пакет отмечен как заброшенный и больше не поддерживается.","ui.package.abandonedReplace":"Этот пакет имеет статус заброшенного и больше не поддерживается. Автор предлагает вместо него использовать пакет {replacement}.","ui.package.contaoVersion":"Доступно для Contao","ui.package-details.previous":"Детали предыдущего расширения","ui.package-details.close":"Закрыть детали расширения","ui.package-details.loading":"Загрузка...","ui.package-details.tabDescription":"Описание","ui.package-details.tabRequire":"Требования","ui.package-details.tabFeatures":"Особенности","ui.package-details.tabSuggest":"Предложения","ui.package-details.tabConflict":"Конфликты","ui.package-details.tabDependents":"Зависимые","ui.package-details.linkRequires":"требует","ui.package-details.linkReplaces":"заменяет","ui.package-details.linkProvides":"обеспечивает","ui.package-details.linkConflicts":"конфликты","ui.package-details.funding":"Финансировать дальнейшее развитие!","ui.package-details.contaoVersions":"Поддерживаемые версии Contao","ui.package-details.latest":"Последняя версия","ui.package-details.released":"выпуск от","ui.package-details.license":"Лицензия(и)","ui.package-details.authors":"из","ui.package-details.more":"Еще","ui.package-details.packagist":"Сведения о пакете","ui.package-details.metadata":"Редактировать метаданные","ui.package-details.support_docs":"Документация","ui.package-details.support_wiki":"Вики","ui.package-details.support_forum":"Форум поддержки","ui.package-details.support_issues":"Проблемы / Отчет об ошибках","ui.package-details.support_source":"Исходный код","ui.package-details.support_irc":"IRC / Чат","ui.package-details.support_email":"E-Mail поддержки","ui.package-details.support_rss":"RSS-канал"}')}}]);(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[710],{1710:function(e,t,r){
/*!

JSZip v3.10.1 - A JavaScript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/main/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/main/LICENSE
*/
!function(t){e.exports=t()}((function(){return function e(t,r,n){function i(a,o){if(!r[a]){if(!t[a]){var h=void 0;if(!o&&h)return require(a,!0);if(s)return s(a,!0);var u=new Error("Cannot find module '"+a+"'");throw u.code="MODULE_NOT_FOUND",u}var l=r[a]={exports:{}};t[a][0].call(l.exports,(function(e){var r=t[a][1][e];return i(r||e)}),l,l.exports,e,t,r,n)}return r[a].exports}for(var s=void 0,a=0;a<n.length;a++)i(n[a]);return i}({1:[function(e,t,r){"use strict";var n=e("./utils"),i=e("./support"),s="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";r.encode=function(e){for(var t,r,i,a,o,h,u,l=[],f=0,c=e.length,d=c,p="string"!==n.getTypeOf(e);f<e.length;)d=c-f,i=p?(t=e[f++],r=f<c?e[f++]:0,f<c?e[f++]:0):(t=e.charCodeAt(f++),r=f<c?e.charCodeAt(f++):0,f<c?e.charCodeAt(f++):0),a=t>>2,o=(3&t)<<4|r>>4,h=1<d?(15&r)<<2|i>>6:64,u=2<d?63&i:64,l.push(s.charAt(a)+s.charAt(o)+s.charAt(h)+s.charAt(u));return l.join("")},r.decode=function(e){var t,r,n,a,o,h,u=0,l=0,f="data:";if(e.substr(0,f.length)===f)throw new Error("Invalid base64 input, it looks like a data url.");var c,d=3*(e=e.replace(/[^A-Za-z0-9+/=]/g,"")).length/4;if(e.charAt(e.length-1)===s.charAt(64)&&d--,e.charAt(e.length-2)===s.charAt(64)&&d--,d%1!=0)throw new Error("Invalid base64 input, bad content length.");for(c=i.uint8array?new Uint8Array(0|d):new Array(0|d);u<e.length;)t=s.indexOf(e.charAt(u++))<<2|(a=s.indexOf(e.charAt(u++)))>>4,r=(15&a)<<4|(o=s.indexOf(e.charAt(u++)))>>2,n=(3&o)<<6|(h=s.indexOf(e.charAt(u++))),c[l++]=t,64!==o&&(c[l++]=r),64!==h&&(c[l++]=n);return c}},{"./support":30,"./utils":32}],2:[function(e,t,r){"use strict";var n=e("./external"),i=e("./stream/DataWorker"),s=e("./stream/Crc32Probe"),a=e("./stream/DataLengthProbe");function o(e,t,r,n,i){this.compressedSize=e,this.uncompressedSize=t,this.crc32=r,this.compression=n,this.compressedContent=i}o.prototype={getContentWorker:function(){var e=new i(n.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new a("data_length")),t=this;return e.on("end",(function(){if(this.streamInfo.data_length!==t.uncompressedSize)throw new Error("Bug : uncompressed data size mismatch")})),e},getCompressedWorker:function(){return new i(n.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",this.crc32).withStreamInfo("compression",this.compression)}},o.createWorkerFrom=function(e,t,r){return e.pipe(new s).pipe(new a("uncompressedSize")).pipe(t.compressWorker(r)).pipe(new a("compressedSize")).withStreamInfo("compression",t)},t.exports=o},{"./external":6,"./stream/Crc32Probe":25,"./stream/DataLengthProbe":26,"./stream/DataWorker":27}],3:[function(e,t,r){"use strict";var n=e("./stream/GenericWorker");r.STORE={magic:"\0\0",compressWorker:function(){return new n("STORE compression")},uncompressWorker:function(){return new n("STORE decompression")}},r.DEFLATE=e("./flate")},{"./flate":7,"./stream/GenericWorker":28}],4:[function(e,t,r){"use strict";var n=e("./utils"),i=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e}return t}();t.exports=function(e,t){return void 0!==e&&e.length?"string"!==n.getTypeOf(e)?function(e,t,r,n){var s=i,a=n+r;e^=-1;for(var o=n;o<a;o++)e=e>>>8^s[255&(e^t[o])];return-1^e}(0|t,e,e.length,0):function(e,t,r,n){var s=i,a=n+r;e^=-1;for(var o=n;o<a;o++)e=e>>>8^s[255&(e^t.charCodeAt(o))];return-1^e}(0|t,e,e.length,0):0}},{"./utils":32}],5:[function(e,t,r){"use strict";r.base64=!1,r.binary=!1,r.dir=!1,r.createFolders=!0,r.date=null,r.compression=null,r.compressionOptions=null,r.comment=null,r.unixPermissions=null,r.dosPermissions=null},{}],6:[function(e,t,r){"use strict";var n=null;n="undefined"!=typeof Promise?Promise:e("lie"),t.exports={Promise:n}},{lie:37}],7:[function(e,t,r){"use strict";var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array,i=e("pako"),s=e("./utils"),a=e("./stream/GenericWorker"),o=n?"uint8array":"array";function h(e,t){a.call(this,"FlateWorker/"+e),this._pako=null,this._pakoAction=e,this._pakoOptions=t,this.meta={}}r.magic="\b\0",s.inherits(h,a),h.prototype.processChunk=function(e){this.meta=e.meta,null===this._pako&&this._createPako(),this._pako.push(s.transformTo(o,e.data),!1)},h.prototype.flush=function(){a.prototype.flush.call(this),null===this._pako&&this._createPako(),this._pako.push([],!0)},h.prototype.cleanUp=function(){a.prototype.cleanUp.call(this),this._pako=null},h.prototype._createPako=function(){this._pako=new i[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var e=this;this._pako.onData=function(t){e.push({data:t,meta:e.meta})}},r.compressWorker=function(e){return new h("Deflate",e)},r.uncompressWorker=function(){return new h("Inflate",{})}},{"./stream/GenericWorker":28,"./utils":32,pako:38}],8:[function(e,t,r){"use strict";function n(e,t){var r,n="";for(r=0;r<t;r++)n+=String.fromCharCode(255&e),e>>>=8;return n}function i(e,t,r,i,a,l){var f,c,d=e.file,p=e.compression,m=l!==o.utf8encode,_=s.transformTo("string",l(d.name)),g=s.transformTo("string",o.utf8encode(d.name)),b=d.comment,v=s.transformTo("string",l(b)),y=s.transformTo("string",o.utf8encode(b)),w=g.length!==d.name.length,k=y.length!==b.length,x="",S="",z="",C=d.dir,E=d.date,A={crc32:0,compressedSize:0,uncompressedSize:0};t&&!r||(A.crc32=e.crc32,A.compressedSize=e.compressedSize,A.uncompressedSize=e.uncompressedSize);var I=0;t&&(I|=8),m||!w&&!k||(I|=2048);var O=0,B=0;C&&(O|=16),"UNIX"===a?(B=798,O|=function(e,t){var r=e;return e||(r=t?16893:33204),(65535&r)<<16}(d.unixPermissions,C)):(B=20,O|=function(e){return 63&(e||0)}(d.dosPermissions)),f=E.getUTCHours(),f<<=6,f|=E.getUTCMinutes(),f<<=5,f|=E.getUTCSeconds()/2,c=E.getUTCFullYear()-1980,c<<=4,c|=E.getUTCMonth()+1,c<<=5,c|=E.getUTCDate(),w&&(S=n(1,1)+n(h(_),4)+g,x+="up"+n(S.length,2)+S),k&&(z=n(1,1)+n(h(v),4)+y,x+="uc"+n(z.length,2)+z);var R="";return R+="\n\0",R+=n(I,2),R+=p.magic,R+=n(f,2),R+=n(c,2),R+=n(A.crc32,4),R+=n(A.compressedSize,4),R+=n(A.uncompressedSize,4),R+=n(_.length,2),R+=n(x.length,2),{fileRecord:u.LOCAL_FILE_HEADER+R+_+x,dirRecord:u.CENTRAL_FILE_HEADER+n(B,2)+R+n(v.length,2)+"\0\0\0\0"+n(O,4)+n(i,4)+_+x+v}}var s=e("../utils"),a=e("../stream/GenericWorker"),o=e("../utf8"),h=e("../crc32"),u=e("../signature");function l(e,t,r,n){a.call(this,"ZipFileWorker"),this.bytesWritten=0,this.zipComment=t,this.zipPlatform=r,this.encodeFileName=n,this.streamFiles=e,this.accumulate=!1,this.contentBuffer=[],this.dirRecords=[],this.currentSourceOffset=0,this.entriesCount=0,this.currentFile=null,this._sources=[]}s.inherits(l,a),l.prototype.push=function(e){var t=e.meta.percent||0,r=this.entriesCount,n=this._sources.length;this.accumulate?this.contentBuffer.push(e):(this.bytesWritten+=e.data.length,a.prototype.push.call(this,{data:e.data,meta:{currentFile:this.currentFile,percent:r?(t+100*(r-n-1))/r:100}}))},l.prototype.openedSource=function(e){this.currentSourceOffset=this.bytesWritten,this.currentFile=e.file.name;var t=this.streamFiles&&!e.file.dir;if(t){var r=i(e,t,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.push({data:r.fileRecord,meta:{percent:0}})}else this.accumulate=!0},l.prototype.closedSource=function(e){this.accumulate=!1;var t=this.streamFiles&&!e.file.dir,r=i(e,t,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);if(this.dirRecords.push(r.dirRecord),t)this.push({data:function(e){return u.DATA_DESCRIPTOR+n(e.crc32,4)+n(e.compressedSize,4)+n(e.uncompressedSize,4)}(e),meta:{percent:100}});else for(this.push({data:r.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null},l.prototype.flush=function(){for(var e=this.bytesWritten,t=0;t<this.dirRecords.length;t++)this.push({data:this.dirRecords[t],meta:{percent:100}});var r=this.bytesWritten-e,i=function(e,t,r,i,a){var o=s.transformTo("string",a(i));return u.CENTRAL_DIRECTORY_END+"\0\0\0\0"+n(e,2)+n(e,2)+n(t,4)+n(r,4)+n(o.length,2)+o}(this.dirRecords.length,r,e,this.zipComment,this.encodeFileName);this.push({data:i,meta:{percent:100}})},l.prototype.prepareNextSource=function(){this.previous=this._sources.shift(),this.openedSource(this.previous.streamInfo),this.isPaused?this.previous.pause():this.previous.resume()},l.prototype.registerPrevious=function(e){this._sources.push(e);var t=this;return e.on("data",(function(e){t.processChunk(e)})),e.on("end",(function(){t.closedSource(t.previous.streamInfo),t._sources.length?t.prepareNextSource():t.end()})),e.on("error",(function(e){t.error(e)})),this},l.prototype.resume=function(){return!!a.prototype.resume.call(this)&&(!this.previous&&this._sources.length?(this.prepareNextSource(),!0):this.previous||this._sources.length||this.generatedError?void 0:(this.end(),!0))},l.prototype.error=function(e){var t=this._sources;if(!a.prototype.error.call(this,e))return!1;for(var r=0;r<t.length;r++)try{t[r].error(e)}catch(e){}return!0},l.prototype.lock=function(){a.prototype.lock.call(this);for(var e=this._sources,t=0;t<e.length;t++)e[t].lock()},t.exports=l},{"../crc32":4,"../signature":23,"../stream/GenericWorker":28,"../utf8":31,"../utils":32}],9:[function(e,t,r){"use strict";var n=e("../compressions"),i=e("./ZipFileWorker");r.generateWorker=function(e,t,r){var s=new i(t.streamFiles,r,t.platform,t.encodeFileName),a=0;try{e.forEach((function(e,r){a++;var i=function(e,t){var r=e||t,i=n[r];if(!i)throw new Error(r+" is not a valid compression method !");return i}(r.options.compression,t.compression),o=r.options.compressionOptions||t.compressionOptions||{},h=r.dir,u=r.date;r._compressWorker(i,o).withStreamInfo("file",{name:e,dir:h,date:u,comment:r.comment||"",unixPermissions:r.unixPermissions,dosPermissions:r.dosPermissions}).pipe(s)})),s.entriesCount=a}catch(e){s.error(e)}return s}},{"../compressions":3,"./ZipFileWorker":8}],10:[function(e,t,r){"use strict";function n(){if(!(this instanceof n))return new n;if(arguments.length)throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");this.files=Object.create(null),this.comment=null,this.root="",this.clone=function(){var e=new n;for(var t in this)"function"!=typeof this[t]&&(e[t]=this[t]);return e}}(n.prototype=e("./object")).loadAsync=e("./load"),n.support=e("./support"),n.defaults=e("./defaults"),n.version="3.10.1",n.loadAsync=function(e,t){return(new n).loadAsync(e,t)},n.external=e("./external"),t.exports=n},{"./defaults":5,"./external":6,"./load":11,"./object":15,"./support":30}],11:[function(e,t,r){"use strict";var n=e("./utils"),i=e("./external"),s=e("./utf8"),a=e("./zipEntries"),o=e("./stream/Crc32Probe"),h=e("./nodejsUtils");function u(e){return new i.Promise((function(t,r){var n=e.decompressed.getContentWorker().pipe(new o);n.on("error",(function(e){r(e)})).on("end",(function(){n.streamInfo.crc32!==e.decompressed.crc32?r(new Error("Corrupted zip : CRC32 mismatch")):t()})).resume()}))}t.exports=function(e,t){var r=this;return t=n.extend(t||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:s.utf8decode}),h.isNode&&h.isStream(e)?i.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")):n.prepareContent("the loaded zip file",e,!0,t.optimizedBinaryString,t.base64).then((function(e){var r=new a(t);return r.load(e),r})).then((function(e){var r=[i.Promise.resolve(e)],n=e.files;if(t.checkCRC32)for(var s=0;s<n.length;s++)r.push(u(n[s]));return i.Promise.all(r)})).then((function(e){for(var i=e.shift(),s=i.files,a=0;a<s.length;a++){var o=s[a],h=o.fileNameStr,u=n.resolve(o.fileNameStr);r.file(u,o.decompressed,{binary:!0,optimizedBinaryString:!0,date:o.date,dir:o.dir,comment:o.fileCommentStr.length?o.fileCommentStr:null,unixPermissions:o.unixPermissions,dosPermissions:o.dosPermissions,createFolders:t.createFolders}),o.dir||(r.file(u).unsafeOriginalName=h)}return i.zipComment.length&&(r.comment=i.zipComment),r}))}},{"./external":6,"./nodejsUtils":14,"./stream/Crc32Probe":25,"./utf8":31,"./utils":32,"./zipEntries":33}],12:[function(e,t,r){"use strict";var n=e("../utils"),i=e("../stream/GenericWorker");function s(e,t){i.call(this,"Nodejs stream input adapter for "+e),this._upstreamEnded=!1,this._bindStream(t)}n.inherits(s,i),s.prototype._bindStream=function(e){var t=this;(this._stream=e).pause(),e.on("data",(function(e){t.push({data:e,meta:{percent:0}})})).on("error",(function(e){t.isPaused?this.generatedError=e:t.error(e)})).on("end",(function(){t.isPaused?t._upstreamEnded=!0:t.end()}))},s.prototype.pause=function(){return!!i.prototype.pause.call(this)&&(this._stream.pause(),!0)},s.prototype.resume=function(){return!!i.prototype.resume.call(this)&&(this._upstreamEnded?this.end():this._stream.resume(),!0)},t.exports=s},{"../stream/GenericWorker":28,"../utils":32}],13:[function(e,t,r){"use strict";var n=e("readable-stream").Readable;function i(e,t,r){n.call(this,t),this._helper=e;var i=this;e.on("data",(function(e,t){i.push(e)||i._helper.pause(),r&&r(t)})).on("error",(function(e){i.emit("error",e)})).on("end",(function(){i.push(null)}))}e("../utils").inherits(i,n),i.prototype._read=function(){this._helper.resume()},t.exports=i},{"../utils":32,"readable-stream":16}],14:[function(e,t,r){"use strict";t.exports={isNode:"undefined"!=typeof Buffer,newBufferFrom:function(e,t){if(Buffer.from&&Buffer.from!==Uint8Array.from)return Buffer.from(e,t);if("number"==typeof e)throw new Error('The "data" argument must not be a number');return new Buffer(e,t)},allocBuffer:function(e){if(Buffer.alloc)return Buffer.alloc(e);var t=new Buffer(e);return t.fill(0),t},isBuffer:function(e){return Buffer.isBuffer(e)},isStream:function(e){return e&&"function"==typeof e.on&&"function"==typeof e.pause&&"function"==typeof e.resume}}},{}],15:[function(e,t,r){"use strict";function n(e,t,r){var n,i=s.getTypeOf(t),o=s.extend(r||{},h);o.date=o.date||new Date,null!==o.compression&&(o.compression=o.compression.toUpperCase()),"string"==typeof o.unixPermissions&&(o.unixPermissions=parseInt(o.unixPermissions,8)),o.unixPermissions&&16384&o.unixPermissions&&(o.dir=!0),o.dosPermissions&&16&o.dosPermissions&&(o.dir=!0),o.dir&&(e=m(e)),o.createFolders&&(n=p(e))&&_.call(this,n,!0);var f="string"===i&&!1===o.binary&&!1===o.base64;r&&void 0!==r.binary||(o.binary=!f),(t instanceof u&&0===t.uncompressedSize||o.dir||!t||0===t.length)&&(o.base64=!1,o.binary=!0,t="",o.compression="STORE",i="string");var g=null;g=t instanceof u||t instanceof a?t:c.isNode&&c.isStream(t)?new d(e,t):s.prepareContent(e,t,o.binary,o.optimizedBinaryString,o.base64);var b=new l(e,g,o);this.files[e]=b}var i=e("./utf8"),s=e("./utils"),a=e("./stream/GenericWorker"),o=e("./stream/StreamHelper"),h=e("./defaults"),u=e("./compressedObject"),l=e("./zipObject"),f=e("./generate"),c=e("./nodejsUtils"),d=e("./nodejs/NodejsStreamInputAdapter"),p=function(e){"/"===e.slice(-1)&&(e=e.substring(0,e.length-1));var t=e.lastIndexOf("/");return 0<t?e.substring(0,t):""},m=function(e){return"/"!==e.slice(-1)&&(e+="/"),e},_=function(e,t){return t=void 0!==t?t:h.createFolders,e=m(e),this.files[e]||n.call(this,e,null,{dir:!0,createFolders:t}),this.files[e]};function g(e){return"[object RegExp]"===Object.prototype.toString.call(e)}var b={load:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},forEach:function(e){var t,r,n;for(t in this.files)n=this.files[t],(r=t.slice(this.root.length,t.length))&&t.slice(0,this.root.length)===this.root&&e(r,n)},filter:function(e){var t=[];return this.forEach((function(r,n){e(r,n)&&t.push(n)})),t},file:function(e,t,r){if(1!==arguments.length)return e=this.root+e,n.call(this,e,t,r),this;if(g(e)){var i=e;return this.filter((function(e,t){return!t.dir&&i.test(e)}))}var s=this.files[this.root+e];return s&&!s.dir?s:null},folder:function(e){if(!e)return this;if(g(e))return this.filter((function(t,r){return r.dir&&e.test(t)}));var t=this.root+e,r=_.call(this,t),n=this.clone();return n.root=r.name,n},remove:function(e){e=this.root+e;var t=this.files[e];if(t||("/"!==e.slice(-1)&&(e+="/"),t=this.files[e]),t&&!t.dir)delete this.files[e];else for(var r=this.filter((function(t,r){return r.name.slice(0,e.length)===e})),n=0;n<r.length;n++)delete this.files[r[n].name];return this},generate:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},generateInternalStream:function(e){var t,r={};try{if((r=s.extend(e||{},{streamFiles:!1,compression:"STORE",compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:i.utf8encode})).type=r.type.toLowerCase(),r.compression=r.compression.toUpperCase(),"binarystring"===r.type&&(r.type="string"),!r.type)throw new Error("No output type specified.");s.checkSupport(r.type),"darwin"!==r.platform&&"freebsd"!==r.platform&&"linux"!==r.platform&&"sunos"!==r.platform||(r.platform="UNIX"),"win32"===r.platform&&(r.platform="DOS");var n=r.comment||this.comment||"";t=f.generateWorker(this,r,n)}catch(e){(t=new a("error")).error(e)}return new o(t,r.type||"string",r.mimeType)},generateAsync:function(e,t){return this.generateInternalStream(e).accumulate(t)},generateNodeStream:function(e,t){return(e=e||{}).type||(e.type="nodebuffer"),this.generateInternalStream(e).toNodejsStream(t)}};t.exports=b},{"./compressedObject":2,"./defaults":5,"./generate":9,"./nodejs/NodejsStreamInputAdapter":12,"./nodejsUtils":14,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31,"./utils":32,"./zipObject":35}],16:[function(e,t,r){"use strict";t.exports=e("stream")},{stream:void 0}],17:[function(e,t,r){"use strict";var n=e("./DataReader");function i(e){n.call(this,e);for(var t=0;t<this.data.length;t++)e[t]=255&e[t]}e("../utils").inherits(i,n),i.prototype.byteAt=function(e){return this.data[this.zero+e]},i.prototype.lastIndexOfSignature=function(e){for(var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),s=this.length-4;0<=s;--s)if(this.data[s]===t&&this.data[s+1]===r&&this.data[s+2]===n&&this.data[s+3]===i)return s-this.zero;return-1},i.prototype.readAndCheckSignature=function(e){var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),s=this.readData(4);return t===s[0]&&r===s[1]&&n===s[2]&&i===s[3]},i.prototype.readData=function(e){if(this.checkOffset(e),0===e)return[];var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./DataReader":18}],18:[function(e,t,r){"use strict";var n=e("../utils");function i(e){this.data=e,this.length=e.length,this.index=0,this.zero=0}i.prototype={checkOffset:function(e){this.checkIndex(this.index+e)},checkIndex:function(e){if(this.length<this.zero+e||e<0)throw new Error("End of data reached (data length = "+this.length+", asked index = "+e+"). Corrupted zip ?")},setIndex:function(e){this.checkIndex(e),this.index=e},skip:function(e){this.setIndex(this.index+e)},byteAt:function(){},readInt:function(e){var t,r=0;for(this.checkOffset(e),t=this.index+e-1;t>=this.index;t--)r=(r<<8)+this.byteAt(t);return this.index+=e,r},readString:function(e){return n.transformTo("string",this.readData(e))},readData:function(){},lastIndexOfSignature:function(){},readAndCheckSignature:function(){},readDate:function(){var e=this.readInt(4);return new Date(Date.UTC(1980+(e>>25&127),(e>>21&15)-1,e>>16&31,e>>11&31,e>>5&63,(31&e)<<1))}},t.exports=i},{"../utils":32}],19:[function(e,t,r){"use strict";var n=e("./Uint8ArrayReader");function i(e){n.call(this,e)}e("../utils").inherits(i,n),i.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./Uint8ArrayReader":21}],20:[function(e,t,r){"use strict";var n=e("./DataReader");function i(e){n.call(this,e)}e("../utils").inherits(i,n),i.prototype.byteAt=function(e){return this.data.charCodeAt(this.zero+e)},i.prototype.lastIndexOfSignature=function(e){return this.data.lastIndexOf(e)-this.zero},i.prototype.readAndCheckSignature=function(e){return e===this.readData(4)},i.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./DataReader":18}],21:[function(e,t,r){"use strict";var n=e("./ArrayReader");function i(e){n.call(this,e)}e("../utils").inherits(i,n),i.prototype.readData=function(e){if(this.checkOffset(e),0===e)return new Uint8Array(0);var t=this.data.subarray(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./ArrayReader":17}],22:[function(e,t,r){"use strict";var n=e("../utils"),i=e("../support"),s=e("./ArrayReader"),a=e("./StringReader"),o=e("./NodeBufferReader"),h=e("./Uint8ArrayReader");t.exports=function(e){var t=n.getTypeOf(e);return n.checkSupport(t),"string"!==t||i.uint8array?"nodebuffer"===t?new o(e):i.uint8array?new h(n.transformTo("uint8array",e)):new s(n.transformTo("array",e)):new a(e)}},{"../support":30,"../utils":32,"./ArrayReader":17,"./NodeBufferReader":19,"./StringReader":20,"./Uint8ArrayReader":21}],23:[function(e,t,r){"use strict";r.LOCAL_FILE_HEADER="PK",r.CENTRAL_FILE_HEADER="PK",r.CENTRAL_DIRECTORY_END="PK",r.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK",r.ZIP64_CENTRAL_DIRECTORY_END="PK",r.DATA_DESCRIPTOR="PK\b"},{}],24:[function(e,t,r){"use strict";var n=e("./GenericWorker"),i=e("../utils");function s(e){n.call(this,"ConvertWorker to "+e),this.destType=e}i.inherits(s,n),s.prototype.processChunk=function(e){this.push({data:i.transformTo(this.destType,e.data),meta:e.meta})},t.exports=s},{"../utils":32,"./GenericWorker":28}],25:[function(e,t,r){"use strict";var n=e("./GenericWorker"),i=e("../crc32");function s(){n.call(this,"Crc32Probe"),this.withStreamInfo("crc32",0)}e("../utils").inherits(s,n),s.prototype.processChunk=function(e){this.streamInfo.crc32=i(e.data,this.streamInfo.crc32||0),this.push(e)},t.exports=s},{"../crc32":4,"../utils":32,"./GenericWorker":28}],26:[function(e,t,r){"use strict";var n=e("../utils"),i=e("./GenericWorker");function s(e){i.call(this,"DataLengthProbe for "+e),this.propName=e,this.withStreamInfo(e,0)}n.inherits(s,i),s.prototype.processChunk=function(e){if(e){var t=this.streamInfo[this.propName]||0;this.streamInfo[this.propName]=t+e.data.length}i.prototype.processChunk.call(this,e)},t.exports=s},{"../utils":32,"./GenericWorker":28}],27:[function(e,t,r){"use strict";var n=e("../utils"),i=e("./GenericWorker");function s(e){i.call(this,"DataWorker");var t=this;this.dataIsReady=!1,this.index=0,this.max=0,this.data=null,this.type="",this._tickScheduled=!1,e.then((function(e){t.dataIsReady=!0,t.data=e,t.max=e&&e.length||0,t.type=n.getTypeOf(e),t.isPaused||t._tickAndRepeat()}),(function(e){t.error(e)}))}n.inherits(s,i),s.prototype.cleanUp=function(){i.prototype.cleanUp.call(this),this.data=null},s.prototype.resume=function(){return!!i.prototype.resume.call(this)&&(!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,n.delay(this._tickAndRepeat,[],this)),!0)},s.prototype._tickAndRepeat=function(){this._tickScheduled=!1,this.isPaused||this.isFinished||(this._tick(),this.isFinished||(n.delay(this._tickAndRepeat,[],this),this._tickScheduled=!0))},s.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var e=null,t=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case"string":e=this.data.substring(this.index,t);break;case"uint8array":e=this.data.subarray(this.index,t);break;case"array":case"nodebuffer":e=this.data.slice(this.index,t)}return this.index=t,this.push({data:e,meta:{percent:this.max?this.index/this.max*100:0}})},t.exports=s},{"../utils":32,"./GenericWorker":28}],28:[function(e,t,r){"use strict";function n(e){this.name=e||"default",this.streamInfo={},this.generatedError=null,this.extraStreamInfo={},this.isPaused=!0,this.isFinished=!1,this.isLocked=!1,this._listeners={data:[],end:[],error:[]},this.previous=null}n.prototype={push:function(e){this.emit("data",e)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0}catch(e){this.emit("error",e)}return!0},error:function(e){return!this.isFinished&&(this.isPaused?this.generatedError=e:(this.isFinished=!0,this.emit("error",e),this.previous&&this.previous.error(e),this.cleanUp()),!0)},on:function(e,t){return this._listeners[e].push(t),this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null,this._listeners=[]},emit:function(e,t){if(this._listeners[e])for(var r=0;r<this._listeners[e].length;r++)this._listeners[e][r].call(this,t)},pipe:function(e){return e.registerPrevious(this)},registerPrevious:function(e){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.streamInfo=e.streamInfo,this.mergeStreamInfo(),this.previous=e;var t=this;return e.on("data",(function(e){t.processChunk(e)})),e.on("end",(function(){t.end()})),e.on("error",(function(e){t.error(e)})),this},pause:function(){return!this.isPaused&&!this.isFinished&&(this.isPaused=!0,this.previous&&this.previous.pause(),!0)},resume:function(){if(!this.isPaused||this.isFinished)return!1;var e=this.isPaused=!1;return this.generatedError&&(this.error(this.generatedError),e=!0),this.previous&&this.previous.resume(),!e},flush:function(){},processChunk:function(e){this.push(e)},withStreamInfo:function(e,t){return this.extraStreamInfo[e]=t,this.mergeStreamInfo(),this},mergeStreamInfo:function(){for(var e in this.extraStreamInfo)Object.prototype.hasOwnProperty.call(this.extraStreamInfo,e)&&(this.streamInfo[e]=this.extraStreamInfo[e])},lock:function(){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.isLocked=!0,this.previous&&this.previous.lock()},toString:function(){var e="Worker "+this.name;return this.previous?this.previous+" -> "+e:e}},t.exports=n},{}],29:[function(e,t,r){"use strict";var n=e("../utils"),i=e("./ConvertWorker"),s=e("./GenericWorker"),a=e("../base64"),o=e("../support"),h=e("../external"),u=null;if(o.nodestream)try{u=e("../nodejs/NodejsStreamOutputAdapter")}catch(e){}function l(e,t){return new h.Promise((function(r,i){var s=[],o=e._internalType,h=e._outputType,u=e._mimeType;e.on("data",(function(e,r){s.push(e),t&&t(r)})).on("error",(function(e){s=[],i(e)})).on("end",(function(){try{var e=function(e,t,r){switch(e){case"blob":return n.newBlob(n.transformTo("arraybuffer",t),r);case"base64":return a.encode(t);default:return n.transformTo(e,t)}}(h,function(e,t){var r,n=0,i=null,s=0;for(r=0;r<t.length;r++)s+=t[r].length;switch(e){case"string":return t.join("");case"array":return Array.prototype.concat.apply([],t);case"uint8array":for(i=new Uint8Array(s),r=0;r<t.length;r++)i.set(t[r],n),n+=t[r].length;return i;case"nodebuffer":return Buffer.concat(t);default:throw new Error("concat : unsupported type '"+e+"'")}}(o,s),u);r(e)}catch(e){i(e)}s=[]})).resume()}))}function f(e,t,r){var a=t;switch(t){case"blob":case"arraybuffer":a="uint8array";break;case"base64":a="string"}try{this._internalType=a,this._outputType=t,this._mimeType=r,n.checkSupport(a),this._worker=e.pipe(new i(a)),e.lock()}catch(e){this._worker=new s("error"),this._worker.error(e)}}f.prototype={accumulate:function(e){return l(this,e)},on:function(e,t){var r=this;return"data"===e?this._worker.on(e,(function(e){t.call(r,e.data,e.meta)})):this._worker.on(e,(function(){n.delay(t,arguments,r)})),this},resume:function(){return n.delay(this._worker.resume,[],this._worker),this},pause:function(){return this._worker.pause(),this},toNodejsStream:function(e){if(n.checkSupport("nodestream"),"nodebuffer"!==this._outputType)throw new Error(this._outputType+" is not supported by this method");return new u(this,{objectMode:"nodebuffer"!==this._outputType},e)}},t.exports=f},{"../base64":1,"../external":6,"../nodejs/NodejsStreamOutputAdapter":13,"../support":30,"../utils":32,"./ConvertWorker":24,"./GenericWorker":28}],30:[function(e,t,r){"use strict";if(r.base64=!0,r.array=!0,r.string=!0,r.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,r.nodebuffer="undefined"!=typeof Buffer,r.uint8array="undefined"!=typeof Uint8Array,"undefined"==typeof ArrayBuffer)r.blob=!1;else{var n=new ArrayBuffer(0);try{r.blob=0===new Blob([n],{type:"application/zip"}).size}catch(e){try{var i=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);i.append(n),r.blob=0===i.getBlob("application/zip").size}catch(e){r.blob=!1}}}try{r.nodestream=!!e("readable-stream").Readable}catch(e){r.nodestream=!1}},{"readable-stream":16}],31:[function(e,t,r){"use strict";for(var n=e("./utils"),i=e("./support"),s=e("./nodejsUtils"),a=e("./stream/GenericWorker"),o=new Array(256),h=0;h<256;h++)o[h]=252<=h?6:248<=h?5:240<=h?4:224<=h?3:192<=h?2:1;function u(){a.call(this,"utf-8 decode"),this.leftOver=null}function l(){a.call(this,"utf-8 encode")}o[254]=o[254]=1,r.utf8encode=function(e){return i.nodebuffer?s.newBufferFrom(e,"utf-8"):function(e){var t,r,n,s,a,o=e.length,h=0;for(s=0;s<o;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(n=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(n-56320),s++),h+=r<128?1:r<2048?2:r<65536?3:4;for(t=i.uint8array?new Uint8Array(h):new Array(h),s=a=0;a<h;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(n=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(n-56320),s++),r<128?t[a++]=r:(r<2048?t[a++]=192|r>>>6:(r<65536?t[a++]=224|r>>>12:(t[a++]=240|r>>>18,t[a++]=128|r>>>12&63),t[a++]=128|r>>>6&63),t[a++]=128|63&r);return t}(e)},r.utf8decode=function(e){return i.nodebuffer?n.transformTo("nodebuffer",e).toString("utf-8"):function(e){var t,r,i,s,a=e.length,h=new Array(2*a);for(t=r=0;t<a;)if((i=e[t++])<128)h[r++]=i;else if(4<(s=o[i]))h[r++]=65533,t+=s-1;else{for(i&=2===s?31:3===s?15:7;1<s&&t<a;)i=i<<6|63&e[t++],s--;1<s?h[r++]=65533:i<65536?h[r++]=i:(i-=65536,h[r++]=55296|i>>10&1023,h[r++]=56320|1023&i)}return h.length!==r&&(h.subarray?h=h.subarray(0,r):h.length=r),n.applyFromCharCode(h)}(e=n.transformTo(i.uint8array?"uint8array":"array",e))},n.inherits(u,a),u.prototype.processChunk=function(e){var t=n.transformTo(i.uint8array?"uint8array":"array",e.data);if(this.leftOver&&this.leftOver.length){if(i.uint8array){var s=t;(t=new Uint8Array(s.length+this.leftOver.length)).set(this.leftOver,0),t.set(s,this.leftOver.length)}else t=this.leftOver.concat(t);this.leftOver=null}var a=function(e,t){var r;for((t=t||e.length)>e.length&&(t=e.length),r=t-1;0<=r&&128==(192&e[r]);)r--;return r<0||0===r?t:r+o[e[r]]>t?r:t}(t),h=t;a!==t.length&&(i.uint8array?(h=t.subarray(0,a),this.leftOver=t.subarray(a,t.length)):(h=t.slice(0,a),this.leftOver=t.slice(a,t.length))),this.push({data:r.utf8decode(h),meta:e.meta})},u.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:r.utf8decode(this.leftOver),meta:{}}),this.leftOver=null)},r.Utf8DecodeWorker=u,n.inherits(l,a),l.prototype.processChunk=function(e){this.push({data:r.utf8encode(e.data),meta:e.meta})},r.Utf8EncodeWorker=l},{"./nodejsUtils":14,"./stream/GenericWorker":28,"./support":30,"./utils":32}],32:[function(e,t,r){"use strict";var n=e("./support"),i=e("./base64"),s=e("./nodejsUtils"),a=e("./external");function o(e){return e}function h(e,t){for(var r=0;r<e.length;++r)t[r]=255&e.charCodeAt(r);return t}e("setimmediate"),r.newBlob=function(t,n){r.checkSupport("blob");try{return new Blob([t],{type:n})}catch(e){try{var i=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);return i.append(t),i.getBlob(n)}catch(e){throw new Error("Bug : can't construct the Blob.")}}};var u={stringifyByChunk:function(e,t,r){var n=[],i=0,s=e.length;if(s<=r)return String.fromCharCode.apply(null,e);for(;i<s;)"array"===t||"nodebuffer"===t?n.push(String.fromCharCode.apply(null,e.slice(i,Math.min(i+r,s)))):n.push(String.fromCharCode.apply(null,e.subarray(i,Math.min(i+r,s)))),i+=r;return n.join("")},stringifyByChar:function(e){for(var t="",r=0;r<e.length;r++)t+=String.fromCharCode(e[r]);return t},applyCanBeUsed:{uint8array:function(){try{return n.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(e){return!1}}(),nodebuffer:function(){try{return n.nodebuffer&&1===String.fromCharCode.apply(null,s.allocBuffer(1)).length}catch(e){return!1}}()}};function l(e){var t=65536,n=r.getTypeOf(e),i=!0;if("uint8array"===n?i=u.applyCanBeUsed.uint8array:"nodebuffer"===n&&(i=u.applyCanBeUsed.nodebuffer),i)for(;1<t;)try{return u.stringifyByChunk(e,n,t)}catch(e){t=Math.floor(t/2)}return u.stringifyByChar(e)}function f(e,t){for(var r=0;r<e.length;r++)t[r]=e[r];return t}r.applyFromCharCode=l;var c={};c.string={string:o,array:function(e){return h(e,new Array(e.length))},arraybuffer:function(e){return c.string.uint8array(e).buffer},uint8array:function(e){return h(e,new Uint8Array(e.length))},nodebuffer:function(e){return h(e,s.allocBuffer(e.length))}},c.array={string:l,array:o,arraybuffer:function(e){return new Uint8Array(e).buffer},uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return s.newBufferFrom(e)}},c.arraybuffer={string:function(e){return l(new Uint8Array(e))},array:function(e){return f(new Uint8Array(e),new Array(e.byteLength))},arraybuffer:o,uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return s.newBufferFrom(new Uint8Array(e))}},c.uint8array={string:l,array:function(e){return f(e,new Array(e.length))},arraybuffer:function(e){return e.buffer},uint8array:o,nodebuffer:function(e){return s.newBufferFrom(e)}},c.nodebuffer={string:l,array:function(e){return f(e,new Array(e.length))},arraybuffer:function(e){return c.nodebuffer.uint8array(e).buffer},uint8array:function(e){return f(e,new Uint8Array(e.length))},nodebuffer:o},r.transformTo=function(e,t){if(t=t||"",!e)return t;r.checkSupport(e);var n=r.getTypeOf(t);return c[n][e](t)},r.resolve=function(e){for(var t=e.split("/"),r=[],n=0;n<t.length;n++){var i=t[n];"."===i||""===i&&0!==n&&n!==t.length-1||(".."===i?r.pop():r.push(i))}return r.join("/")},r.getTypeOf=function(e){return"string"==typeof e?"string":"[object Array]"===Object.prototype.toString.call(e)?"array":n.nodebuffer&&s.isBuffer(e)?"nodebuffer":n.uint8array&&e instanceof Uint8Array?"uint8array":n.arraybuffer&&e instanceof ArrayBuffer?"arraybuffer":void 0},r.checkSupport=function(e){if(!n[e.toLowerCase()])throw new Error(e+" is not supported by this platform")},r.MAX_VALUE_16BITS=65535,r.MAX_VALUE_32BITS=-1,r.pretty=function(e){var t,r,n="";for(r=0;r<(e||"").length;r++)n+="\\x"+((t=e.charCodeAt(r))<16?"0":"")+t.toString(16).toUpperCase();return n},r.delay=function(e,t,r){setImmediate((function(){e.apply(r||null,t||[])}))},r.inherits=function(e,t){function r(){}r.prototype=t.prototype,e.prototype=new r},r.extend=function(){var e,t,r={};for(e=0;e<arguments.length;e++)for(t in arguments[e])Object.prototype.hasOwnProperty.call(arguments[e],t)&&void 0===r[t]&&(r[t]=arguments[e][t]);return r},r.prepareContent=function(e,t,s,o,u){return a.Promise.resolve(t).then((function(e){return n.blob&&(e instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(e)))&&"undefined"!=typeof FileReader?new a.Promise((function(t,r){var n=new FileReader;n.onload=function(e){t(e.target.result)},n.onerror=function(e){r(e.target.error)},n.readAsArrayBuffer(e)})):e})).then((function(t){var l=r.getTypeOf(t);return l?("arraybuffer"===l?t=r.transformTo("uint8array",t):"string"===l&&(u?t=i.decode(t):s&&!0!==o&&(t=function(e){return h(e,n.uint8array?new Uint8Array(e.length):new Array(e.length))}(t))),t):a.Promise.reject(new Error("Can't read the data of '"+e+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"))}))}},{"./base64":1,"./external":6,"./nodejsUtils":14,"./support":30,setimmediate:54}],33:[function(e,t,r){"use strict";var n=e("./reader/readerFor"),i=e("./utils"),s=e("./signature"),a=e("./zipEntry"),o=e("./support");function h(e){this.files=[],this.loadOptions=e}h.prototype={checkSignature:function(e){if(!this.reader.readAndCheckSignature(e)){this.reader.index-=4;var t=this.reader.readString(4);throw new Error("Corrupted zip or bug: unexpected signature ("+i.pretty(t)+", expected "+i.pretty(e)+")")}},isSignature:function(e,t){var r=this.reader.index;this.reader.setIndex(e);var n=this.reader.readString(4)===t;return this.reader.setIndex(r),n},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2);var e=this.reader.readData(this.zipCommentLength),t=o.uint8array?"uint8array":"array",r=i.transformTo(t,e);this.zipComment=this.loadOptions.decodeFileName(r)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.reader.skip(4),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var e,t,r,n=this.zip64EndOfCentralSize-44;0<n;)e=this.reader.readInt(2),t=this.reader.readInt(4),r=this.reader.readData(t),this.zip64ExtensibleData[e]={id:e,length:t,value:r}},readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),1<this.disksCount)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var e,t;for(e=0;e<this.files.length;e++)t=this.files[e],this.reader.setIndex(t.localHeaderOffset),this.checkSignature(s.LOCAL_FILE_HEADER),t.readLocalPart(this.reader),t.handleUTF8(),t.processAttributes()},readCentralDir:function(){var e;for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(s.CENTRAL_FILE_HEADER);)(e=new a({zip64:this.zip64},this.loadOptions)).readCentralPart(this.reader),this.files.push(e);if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw new Error("Corrupted zip or bug: expected "+this.centralDirRecords+" records in central dir, got "+this.files.length)},readEndOfCentral:function(){var e=this.reader.lastIndexOfSignature(s.CENTRAL_DIRECTORY_END);if(e<0)throw this.isSignature(0,s.LOCAL_FILE_HEADER)?new Error("Corrupted zip: can't find end of central directory"):new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");this.reader.setIndex(e);var t=e;if(this.checkSignature(s.CENTRAL_DIRECTORY_END),this.readBlockEndOfCentral(),this.diskNumber===i.MAX_VALUE_16BITS||this.diskWithCentralDirStart===i.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===i.MAX_VALUE_16BITS||this.centralDirRecords===i.MAX_VALUE_16BITS||this.centralDirSize===i.MAX_VALUE_32BITS||this.centralDirOffset===i.MAX_VALUE_32BITS){if(this.zip64=!0,(e=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR))<0)throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");if(this.reader.setIndex(e),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR),this.readBlockZip64EndOfCentralLocator(),!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,s.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.relativeOffsetEndOfZip64CentralDir<0))throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.readBlockZip64EndOfCentral()}var r=this.centralDirOffset+this.centralDirSize;this.zip64&&(r+=20,r+=12+this.zip64EndOfCentralSize);var n=t-r;if(0<n)this.isSignature(t,s.CENTRAL_FILE_HEADER)||(this.reader.zero=n);else if(n<0)throw new Error("Corrupted zip: missing "+Math.abs(n)+" bytes.")},prepareReader:function(e){this.reader=n(e)},load:function(e){this.prepareReader(e),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles()}},t.exports=h},{"./reader/readerFor":22,"./signature":23,"./support":30,"./utils":32,"./zipEntry":34}],34:[function(e,t,r){"use strict";var n=e("./reader/readerFor"),i=e("./utils"),s=e("./compressedObject"),a=e("./crc32"),o=e("./utf8"),h=e("./compressions"),u=e("./support");function l(e,t){this.options=e,this.loadOptions=t}l.prototype={isEncrypted:function(){return 1==(1&this.bitFlag)},useUTF8:function(){return 2048==(2048&this.bitFlag)},readLocalPart:function(e){var t,r;if(e.skip(22),this.fileNameLength=e.readInt(2),r=e.readInt(2),this.fileName=e.readData(this.fileNameLength),e.skip(r),-1===this.compressedSize||-1===this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough information from the central directory (compressedSize === -1 || uncompressedSize === -1)");if(null===(t=function(e){for(var t in h)if(Object.prototype.hasOwnProperty.call(h,t)&&h[t].magic===e)return h[t];return null}(this.compressionMethod)))throw new Error("Corrupted zip : compression "+i.pretty(this.compressionMethod)+" unknown (inner file : "+i.transformTo("string",this.fileName)+")");this.decompressed=new s(this.compressedSize,this.uncompressedSize,this.crc32,t,e.readData(this.compressedSize))},readCentralPart:function(e){this.versionMadeBy=e.readInt(2),e.skip(2),this.bitFlag=e.readInt(2),this.compressionMethod=e.readString(2),this.date=e.readDate(),this.crc32=e.readInt(4),this.compressedSize=e.readInt(4),this.uncompressedSize=e.readInt(4);var t=e.readInt(2);if(this.extraFieldsLength=e.readInt(2),this.fileCommentLength=e.readInt(2),this.diskNumberStart=e.readInt(2),this.internalFileAttributes=e.readInt(2),this.externalFileAttributes=e.readInt(4),this.localHeaderOffset=e.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");e.skip(t),this.readExtraFields(e),this.parseZIP64ExtraField(e),this.fileComment=e.readData(this.fileCommentLength)},processAttributes:function(){this.unixPermissions=null,this.dosPermissions=null;var e=this.versionMadeBy>>8;this.dir=!!(16&this.externalFileAttributes),0==e&&(this.dosPermissions=63&this.externalFileAttributes),3==e&&(this.unixPermissions=this.externalFileAttributes>>16&65535),this.dir||"/"!==this.fileNameStr.slice(-1)||(this.dir=!0)},parseZIP64ExtraField:function(){if(this.extraFields[1]){var e=n(this.extraFields[1].value);this.uncompressedSize===i.MAX_VALUE_32BITS&&(this.uncompressedSize=e.readInt(8)),this.compressedSize===i.MAX_VALUE_32BITS&&(this.compressedSize=e.readInt(8)),this.localHeaderOffset===i.MAX_VALUE_32BITS&&(this.localHeaderOffset=e.readInt(8)),this.diskNumberStart===i.MAX_VALUE_32BITS&&(this.diskNumberStart=e.readInt(4))}},readExtraFields:function(e){var t,r,n,i=e.index+this.extraFieldsLength;for(this.extraFields||(this.extraFields={});e.index+4<i;)t=e.readInt(2),r=e.readInt(2),n=e.readData(r),this.extraFields[t]={id:t,length:r,value:n};e.setIndex(i)},handleUTF8:function(){var e=u.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=o.utf8decode(this.fileName),this.fileCommentStr=o.utf8decode(this.fileComment);else{var t=this.findExtraFieldUnicodePath();if(null!==t)this.fileNameStr=t;else{var r=i.transformTo(e,this.fileName);this.fileNameStr=this.loadOptions.decodeFileName(r)}var n=this.findExtraFieldUnicodeComment();if(null!==n)this.fileCommentStr=n;else{var s=i.transformTo(e,this.fileComment);this.fileCommentStr=this.loadOptions.decodeFileName(s)}}},findExtraFieldUnicodePath:function(){var e=this.extraFields[28789];if(e){var t=n(e.value);return 1!==t.readInt(1)||a(this.fileName)!==t.readInt(4)?null:o.utf8decode(t.readData(e.length-5))}return null},findExtraFieldUnicodeComment:function(){var e=this.extraFields[25461];if(e){var t=n(e.value);return 1!==t.readInt(1)||a(this.fileComment)!==t.readInt(4)?null:o.utf8decode(t.readData(e.length-5))}return null}},t.exports=l},{"./compressedObject":2,"./compressions":3,"./crc32":4,"./reader/readerFor":22,"./support":30,"./utf8":31,"./utils":32}],35:[function(e,t,r){"use strict";function n(e,t,r){this.name=e,this.dir=r.dir,this.date=r.date,this.comment=r.comment,this.unixPermissions=r.unixPermissions,this.dosPermissions=r.dosPermissions,this._data=t,this._dataBinary=r.binary,this.options={compression:r.compression,compressionOptions:r.compressionOptions}}var i=e("./stream/StreamHelper"),s=e("./stream/DataWorker"),a=e("./utf8"),o=e("./compressedObject"),h=e("./stream/GenericWorker");n.prototype={internalStream:function(e){var t=null,r="string";try{if(!e)throw new Error("No output type specified.");var n="string"===(r=e.toLowerCase())||"text"===r;"binarystring"!==r&&"text"!==r||(r="string"),t=this._decompressWorker();var s=!this._dataBinary;s&&!n&&(t=t.pipe(new a.Utf8EncodeWorker)),!s&&n&&(t=t.pipe(new a.Utf8DecodeWorker))}catch(e){(t=new h("error")).error(e)}return new i(t,r,"")},async:function(e,t){return this.internalStream(e).accumulate(t)},nodeStream:function(e,t){return this.internalStream(e||"nodebuffer").toNodejsStream(t)},_compressWorker:function(e,t){if(this._data instanceof o&&this._data.compression.magic===e.magic)return this._data.getCompressedWorker();var r=this._decompressWorker();return this._dataBinary||(r=r.pipe(new a.Utf8EncodeWorker)),o.createWorkerFrom(r,e,t)},_decompressWorker:function(){return this._data instanceof o?this._data.getContentWorker():this._data instanceof h?this._data:new s(this._data)}};for(var u=["asText","asBinary","asNodeBuffer","asUint8Array","asArrayBuffer"],l=function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},f=0;f<u.length;f++)n.prototype[u[f]]=l;t.exports=n},{"./compressedObject":2,"./stream/DataWorker":27,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31}],36:[function(e,t,n){(function(e){"use strict";var r,n,i=e.MutationObserver||e.WebKitMutationObserver;if(i){var s=0,a=new i(l),o=e.document.createTextNode("");a.observe(o,{characterData:!0}),r=function(){o.data=s=++s%2}}else if(e.setImmediate||void 0===e.MessageChannel)r="document"in e&&"onreadystatechange"in e.document.createElement("script")?function(){var t=e.document.createElement("script");t.onreadystatechange=function(){l(),t.onreadystatechange=null,t.parentNode.removeChild(t),t=null},e.document.documentElement.appendChild(t)}:function(){setTimeout(l,0)};else{var h=new e.MessageChannel;h.port1.onmessage=l,r=function(){h.port2.postMessage(0)}}var u=[];function l(){var e,t;n=!0;for(var r=u.length;r;){for(t=u,u=[],e=-1;++e<r;)t[e]();r=u.length}n=!1}t.exports=function(e){1!==u.push(e)||n||r()}}).call(this,"undefined"!=typeof r.g?r.g:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}],37:[function(e,t,r){"use strict";var n=e("immediate");function i(){}var s={},a=["REJECTED"],o=["FULFILLED"],h=["PENDING"];function u(e){if("function"!=typeof e)throw new TypeError("resolver must be a function");this.state=h,this.queue=[],this.outcome=void 0,e!==i&&d(this,e)}function l(e,t,r){this.promise=e,"function"==typeof t&&(this.onFulfilled=t,this.callFulfilled=this.otherCallFulfilled),"function"==typeof r&&(this.onRejected=r,this.callRejected=this.otherCallRejected)}function f(e,t,r){n((function(){var n;try{n=t(r)}catch(n){return s.reject(e,n)}n===e?s.reject(e,new TypeError("Cannot resolve promise with itself")):s.resolve(e,n)}))}function c(e){var t=e&&e.then;if(e&&("object"==typeof e||"function"==typeof e)&&"function"==typeof t)return function(){t.apply(e,arguments)}}function d(e,t){var r=!1;function n(t){r||(r=!0,s.reject(e,t))}function i(t){r||(r=!0,s.resolve(e,t))}var a=p((function(){t(i,n)}));"error"===a.status&&n(a.value)}function p(e,t){var r={};try{r.value=e(t),r.status="success"}catch(e){r.status="error",r.value=e}return r}(t.exports=u).prototype.finally=function(e){if("function"!=typeof e)return this;var t=this.constructor;return this.then((function(r){return t.resolve(e()).then((function(){return r}))}),(function(r){return t.resolve(e()).then((function(){throw r}))}))},u.prototype.catch=function(e){return this.then(null,e)},u.prototype.then=function(e,t){if("function"!=typeof e&&this.state===o||"function"!=typeof t&&this.state===a)return this;var r=new this.constructor(i);return this.state!==h?f(r,this.state===o?e:t,this.outcome):this.queue.push(new l(r,e,t)),r},l.prototype.callFulfilled=function(e){s.resolve(this.promise,e)},l.prototype.otherCallFulfilled=function(e){f(this.promise,this.onFulfilled,e)},l.prototype.callRejected=function(e){s.reject(this.promise,e)},l.prototype.otherCallRejected=function(e){f(this.promise,this.onRejected,e)},s.resolve=function(e,t){var r=p(c,t);if("error"===r.status)return s.reject(e,r.value);var n=r.value;if(n)d(e,n);else{e.state=o,e.outcome=t;for(var i=-1,a=e.queue.length;++i<a;)e.queue[i].callFulfilled(t)}return e},s.reject=function(e,t){e.state=a,e.outcome=t;for(var r=-1,n=e.queue.length;++r<n;)e.queue[r].callRejected(t);return e},u.resolve=function(e){return e instanceof this?e:s.resolve(new this(i),e)},u.reject=function(e){var t=new this(i);return s.reject(t,e)},u.all=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var r=e.length,n=!1;if(!r)return this.resolve([]);for(var a=new Array(r),o=0,h=-1,u=new this(i);++h<r;)l(e[h],h);return u;function l(e,i){t.resolve(e).then((function(e){a[i]=e,++o!==r||n||(n=!0,s.resolve(u,a))}),(function(e){n||(n=!0,s.reject(u,e))}))}},u.race=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var r=e.length,n=!1;if(!r)return this.resolve([]);for(var a,o=-1,h=new this(i);++o<r;)a=e[o],t.resolve(a).then((function(e){n||(n=!0,s.resolve(h,e))}),(function(e){n||(n=!0,s.reject(h,e))}));return h}},{immediate:36}],38:[function(e,t,r){"use strict";var n={};(0,e("./lib/utils/common").assign)(n,e("./lib/deflate"),e("./lib/inflate"),e("./lib/zlib/constants")),t.exports=n},{"./lib/deflate":39,"./lib/inflate":40,"./lib/utils/common":41,"./lib/zlib/constants":44}],39:[function(e,t,r){"use strict";var n=e("./zlib/deflate"),i=e("./utils/common"),s=e("./utils/strings"),a=e("./zlib/messages"),o=e("./zlib/zstream"),h=Object.prototype.toString,u=0,l=-1,f=0,c=8;function d(e){if(!(this instanceof d))return new d(e);this.options=i.assign({level:l,method:c,chunkSize:16384,windowBits:15,memLevel:8,strategy:f,to:""},e||{});var t=this.options;t.raw&&0<t.windowBits?t.windowBits=-t.windowBits:t.gzip&&0<t.windowBits&&t.windowBits<16&&(t.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new o,this.strm.avail_out=0;var r=n.deflateInit2(this.strm,t.level,t.method,t.windowBits,t.memLevel,t.strategy);if(r!==u)throw new Error(a[r]);if(t.header&&n.deflateSetHeader(this.strm,t.header),t.dictionary){var p;if(p="string"==typeof t.dictionary?s.string2buf(t.dictionary):"[object ArrayBuffer]"===h.call(t.dictionary)?new Uint8Array(t.dictionary):t.dictionary,(r=n.deflateSetDictionary(this.strm,p))!==u)throw new Error(a[r]);this._dict_set=!0}}function p(e,t){var r=new d(t);if(r.push(e,!0),r.err)throw r.msg||a[r.err];return r.result}d.prototype.push=function(e,t){var r,a,o=this.strm,l=this.options.chunkSize;if(this.ended)return!1;a=t===~~t?t:!0===t?4:0,"string"==typeof e?o.input=s.string2buf(e):"[object ArrayBuffer]"===h.call(e)?o.input=new Uint8Array(e):o.input=e,o.next_in=0,o.avail_in=o.input.length;do{if(0===o.avail_out&&(o.output=new i.Buf8(l),o.next_out=0,o.avail_out=l),1!==(r=n.deflate(o,a))&&r!==u)return this.onEnd(r),!(this.ended=!0);0!==o.avail_out&&(0!==o.avail_in||4!==a&&2!==a)||("string"===this.options.to?this.onData(s.buf2binstring(i.shrinkBuf(o.output,o.next_out))):this.onData(i.shrinkBuf(o.output,o.next_out)))}while((0<o.avail_in||0===o.avail_out)&&1!==r);return 4===a?(r=n.deflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===u):2!==a||(this.onEnd(u),!(o.avail_out=0))},d.prototype.onData=function(e){this.chunks.push(e)},d.prototype.onEnd=function(e){e===u&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=i.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},r.Deflate=d,r.deflate=p,r.deflateRaw=function(e,t){return(t=t||{}).raw=!0,p(e,t)},r.gzip=function(e,t){return(t=t||{}).gzip=!0,p(e,t)}},{"./utils/common":41,"./utils/strings":42,"./zlib/deflate":46,"./zlib/messages":51,"./zlib/zstream":53}],40:[function(e,t,r){"use strict";var n=e("./zlib/inflate"),i=e("./utils/common"),s=e("./utils/strings"),a=e("./zlib/constants"),o=e("./zlib/messages"),h=e("./zlib/zstream"),u=e("./zlib/gzheader"),l=Object.prototype.toString;function f(e){if(!(this instanceof f))return new f(e);this.options=i.assign({chunkSize:16384,windowBits:0,to:""},e||{});var t=this.options;t.raw&&0<=t.windowBits&&t.windowBits<16&&(t.windowBits=-t.windowBits,0===t.windowBits&&(t.windowBits=-15)),!(0<=t.windowBits&&t.windowBits<16)||e&&e.windowBits||(t.windowBits+=32),15<t.windowBits&&t.windowBits<48&&0==(15&t.windowBits)&&(t.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new h,this.strm.avail_out=0;var r=n.inflateInit2(this.strm,t.windowBits);if(r!==a.Z_OK)throw new Error(o[r]);this.header=new u,n.inflateGetHeader(this.strm,this.header)}function c(e,t){var r=new f(t);if(r.push(e,!0),r.err)throw r.msg||o[r.err];return r.result}f.prototype.push=function(e,t){var r,o,h,u,f,c,d=this.strm,p=this.options.chunkSize,m=this.options.dictionary,_=!1;if(this.ended)return!1;o=t===~~t?t:!0===t?a.Z_FINISH:a.Z_NO_FLUSH,"string"==typeof e?d.input=s.binstring2buf(e):"[object ArrayBuffer]"===l.call(e)?d.input=new Uint8Array(e):d.input=e,d.next_in=0,d.avail_in=d.input.length;do{if(0===d.avail_out&&(d.output=new i.Buf8(p),d.next_out=0,d.avail_out=p),(r=n.inflate(d,a.Z_NO_FLUSH))===a.Z_NEED_DICT&&m&&(c="string"==typeof m?s.string2buf(m):"[object ArrayBuffer]"===l.call(m)?new Uint8Array(m):m,r=n.inflateSetDictionary(this.strm,c)),r===a.Z_BUF_ERROR&&!0===_&&(r=a.Z_OK,_=!1),r!==a.Z_STREAM_END&&r!==a.Z_OK)return this.onEnd(r),!(this.ended=!0);d.next_out&&(0!==d.avail_out&&r!==a.Z_STREAM_END&&(0!==d.avail_in||o!==a.Z_FINISH&&o!==a.Z_SYNC_FLUSH)||("string"===this.options.to?(h=s.utf8border(d.output,d.next_out),u=d.next_out-h,f=s.buf2string(d.output,h),d.next_out=u,d.avail_out=p-u,u&&i.arraySet(d.output,d.output,h,u,0),this.onData(f)):this.onData(i.shrinkBuf(d.output,d.next_out)))),0===d.avail_in&&0===d.avail_out&&(_=!0)}while((0<d.avail_in||0===d.avail_out)&&r!==a.Z_STREAM_END);return r===a.Z_STREAM_END&&(o=a.Z_FINISH),o===a.Z_FINISH?(r=n.inflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===a.Z_OK):o!==a.Z_SYNC_FLUSH||(this.onEnd(a.Z_OK),!(d.avail_out=0))},f.prototype.onData=function(e){this.chunks.push(e)},f.prototype.onEnd=function(e){e===a.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=i.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},r.Inflate=f,r.inflate=c,r.inflateRaw=function(e,t){return(t=t||{}).raw=!0,c(e,t)},r.ungzip=c},{"./utils/common":41,"./utils/strings":42,"./zlib/constants":44,"./zlib/gzheader":47,"./zlib/inflate":49,"./zlib/messages":51,"./zlib/zstream":53}],41:[function(e,t,r){"use strict";var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;r.assign=function(e){for(var t=Array.prototype.slice.call(arguments,1);t.length;){var r=t.shift();if(r){if("object"!=typeof r)throw new TypeError(r+"must be non-object");for(var n in r)r.hasOwnProperty(n)&&(e[n]=r[n])}}return e},r.shrinkBuf=function(e,t){return e.length===t?e:e.subarray?e.subarray(0,t):(e.length=t,e)};var i={arraySet:function(e,t,r,n,i){if(t.subarray&&e.subarray)e.set(t.subarray(r,r+n),i);else for(var s=0;s<n;s++)e[i+s]=t[r+s]},flattenChunks:function(e){var t,r,n,i,s,a;for(t=n=0,r=e.length;t<r;t++)n+=e[t].length;for(a=new Uint8Array(n),t=i=0,r=e.length;t<r;t++)s=e[t],a.set(s,i),i+=s.length;return a}},s={arraySet:function(e,t,r,n,i){for(var s=0;s<n;s++)e[i+s]=t[r+s]},flattenChunks:function(e){return[].concat.apply([],e)}};r.setTyped=function(e){e?(r.Buf8=Uint8Array,r.Buf16=Uint16Array,r.Buf32=Int32Array,r.assign(r,i)):(r.Buf8=Array,r.Buf16=Array,r.Buf32=Array,r.assign(r,s))},r.setTyped(n)},{}],42:[function(e,t,r){"use strict";var n=e("./common"),i=!0,s=!0;try{String.fromCharCode.apply(null,[0])}catch(e){i=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(e){s=!1}for(var a=new n.Buf8(256),o=0;o<256;o++)a[o]=252<=o?6:248<=o?5:240<=o?4:224<=o?3:192<=o?2:1;function h(e,t){if(t<65537&&(e.subarray&&s||!e.subarray&&i))return String.fromCharCode.apply(null,n.shrinkBuf(e,t));for(var r="",a=0;a<t;a++)r+=String.fromCharCode(e[a]);return r}a[254]=a[254]=1,r.string2buf=function(e){var t,r,i,s,a,o=e.length,h=0;for(s=0;s<o;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(i=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(i-56320),s++),h+=r<128?1:r<2048?2:r<65536?3:4;for(t=new n.Buf8(h),s=a=0;a<h;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(i=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(i-56320),s++),r<128?t[a++]=r:(r<2048?t[a++]=192|r>>>6:(r<65536?t[a++]=224|r>>>12:(t[a++]=240|r>>>18,t[a++]=128|r>>>12&63),t[a++]=128|r>>>6&63),t[a++]=128|63&r);return t},r.buf2binstring=function(e){return h(e,e.length)},r.binstring2buf=function(e){for(var t=new n.Buf8(e.length),r=0,i=t.length;r<i;r++)t[r]=e.charCodeAt(r);return t},r.buf2string=function(e,t){var r,n,i,s,o=t||e.length,u=new Array(2*o);for(r=n=0;r<o;)if((i=e[r++])<128)u[n++]=i;else if(4<(s=a[i]))u[n++]=65533,r+=s-1;else{for(i&=2===s?31:3===s?15:7;1<s&&r<o;)i=i<<6|63&e[r++],s--;1<s?u[n++]=65533:i<65536?u[n++]=i:(i-=65536,u[n++]=55296|i>>10&1023,u[n++]=56320|1023&i)}return h(u,n)},r.utf8border=function(e,t){var r;for((t=t||e.length)>e.length&&(t=e.length),r=t-1;0<=r&&128==(192&e[r]);)r--;return r<0||0===r?t:r+a[e[r]]>t?r:t}},{"./common":41}],43:[function(e,t,r){"use strict";t.exports=function(e,t,r,n){for(var i=65535&e|0,s=e>>>16&65535|0,a=0;0!==r;){for(r-=a=2e3<r?2e3:r;s=s+(i=i+t[n++]|0)|0,--a;);i%=65521,s%=65521}return i|s<<16|0}},{}],44:[function(e,t,r){"use strict";t.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],45:[function(e,t,r){"use strict";var n=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e}return t}();t.exports=function(e,t,r,i){var s=n,a=i+r;e^=-1;for(var o=i;o<a;o++)e=e>>>8^s[255&(e^t[o])];return-1^e}},{}],46:[function(e,t,r){"use strict";var n,i=e("../utils/common"),s=e("./trees"),a=e("./adler32"),o=e("./crc32"),h=e("./messages"),u=0,l=4,f=0,c=-2,d=-1,p=4,m=2,_=8,g=9,b=286,v=30,y=19,w=2*b+1,k=15,x=3,S=258,z=S+x+1,C=42,E=113,A=1,I=2,O=3,B=4;function R(e,t){return e.msg=h[t],t}function T(e){return(e<<1)-(4<e?9:0)}function D(e){for(var t=e.length;0<=--t;)e[t]=0}function F(e){var t=e.state,r=t.pending;r>e.avail_out&&(r=e.avail_out),0!==r&&(i.arraySet(e.output,t.pending_buf,t.pending_out,r,e.next_out),e.next_out+=r,t.pending_out+=r,e.total_out+=r,e.avail_out-=r,t.pending-=r,0===t.pending&&(t.pending_out=0))}function N(e,t){s._tr_flush_block(e,0<=e.block_start?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,F(e.strm)}function U(e,t){e.pending_buf[e.pending++]=t}function P(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=255&t}function L(e,t){var r,n,i=e.max_chain_length,s=e.strstart,a=e.prev_length,o=e.nice_match,h=e.strstart>e.w_size-z?e.strstart-(e.w_size-z):0,u=e.window,l=e.w_mask,f=e.prev,c=e.strstart+S,d=u[s+a-1],p=u[s+a];e.prev_length>=e.good_match&&(i>>=2),o>e.lookahead&&(o=e.lookahead);do{if(u[(r=t)+a]===p&&u[r+a-1]===d&&u[r]===u[s]&&u[++r]===u[s+1]){s+=2,r++;do{}while(u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&s<c);if(n=S-(c-s),s=c-S,a<n){if(e.match_start=t,o<=(a=n))break;d=u[s+a-1],p=u[s+a]}}}while((t=f[t&l])>h&&0!=--i);return a<=e.lookahead?a:e.lookahead}function j(e){var t,r,n,s,h,u,l,f,c,d,p=e.w_size;do{if(s=e.window_size-e.lookahead-e.strstart,e.strstart>=p+(p-z)){for(i.arraySet(e.window,e.window,p,p,0),e.match_start-=p,e.strstart-=p,e.block_start-=p,t=r=e.hash_size;n=e.head[--t],e.head[t]=p<=n?n-p:0,--r;);for(t=r=p;n=e.prev[--t],e.prev[t]=p<=n?n-p:0,--r;);s+=p}if(0===e.strm.avail_in)break;if(u=e.strm,l=e.window,f=e.strstart+e.lookahead,c=s,d=void 0,d=u.avail_in,c<d&&(d=c),r=0===d?0:(u.avail_in-=d,i.arraySet(l,u.input,u.next_in,d,f),1===u.state.wrap?u.adler=a(u.adler,l,d,f):2===u.state.wrap&&(u.adler=o(u.adler,l,d,f)),u.next_in+=d,u.total_in+=d,d),e.lookahead+=r,e.lookahead+e.insert>=x)for(h=e.strstart-e.insert,e.ins_h=e.window[h],e.ins_h=(e.ins_h<<e.hash_shift^e.window[h+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[h+x-1])&e.hash_mask,e.prev[h&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=h,h++,e.insert--,!(e.lookahead+e.insert<x)););}while(e.lookahead<z&&0!==e.strm.avail_in)}function Z(e,t){for(var r,n;;){if(e.lookahead<z){if(j(e),e.lookahead<z&&t===u)return A;if(0===e.lookahead)break}if(r=0,e.lookahead>=x&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!==r&&e.strstart-r<=e.w_size-z&&(e.match_length=L(e,r)),e.match_length>=x)if(n=s._tr_tally(e,e.strstart-e.match_start,e.match_length-x),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=x){for(e.match_length--;e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart,0!=--e.match_length;);e.strstart++}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else n=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(n&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=e.strstart<x-1?e.strstart:x-1,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}function W(e,t){for(var r,n,i;;){if(e.lookahead<z){if(j(e),e.lookahead<z&&t===u)return A;if(0===e.lookahead)break}if(r=0,e.lookahead>=x&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=x-1,0!==r&&e.prev_length<e.max_lazy_match&&e.strstart-r<=e.w_size-z&&(e.match_length=L(e,r),e.match_length<=5&&(1===e.strategy||e.match_length===x&&4096<e.strstart-e.match_start)&&(e.match_length=x-1)),e.prev_length>=x&&e.match_length<=e.prev_length){for(i=e.strstart+e.lookahead-x,n=s._tr_tally(e,e.strstart-1-e.prev_match,e.prev_length-x),e.lookahead-=e.prev_length-1,e.prev_length-=2;++e.strstart<=i&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!=--e.prev_length;);if(e.match_available=0,e.match_length=x-1,e.strstart++,n&&(N(e,!1),0===e.strm.avail_out))return A}else if(e.match_available){if((n=s._tr_tally(e,0,e.window[e.strstart-1]))&&N(e,!1),e.strstart++,e.lookahead--,0===e.strm.avail_out)return A}else e.match_available=1,e.strstart++,e.lookahead--}return e.match_available&&(n=s._tr_tally(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<x-1?e.strstart:x-1,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}function M(e,t,r,n,i){this.good_length=e,this.max_lazy=t,this.nice_length=r,this.max_chain=n,this.func=i}function H(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=_,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new i.Buf16(2*w),this.dyn_dtree=new i.Buf16(2*(2*v+1)),this.bl_tree=new i.Buf16(2*(2*y+1)),D(this.dyn_ltree),D(this.dyn_dtree),D(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new i.Buf16(k+1),this.heap=new i.Buf16(2*b+1),D(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new i.Buf16(2*b+1),D(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}function G(e){var t;return e&&e.state?(e.total_in=e.total_out=0,e.data_type=m,(t=e.state).pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?C:E,e.adler=2===t.wrap?0:1,t.last_flush=u,s._tr_init(t),f):R(e,c)}function K(e){var t=G(e);return t===f&&function(e){e.window_size=2*e.w_size,D(e.head),e.max_lazy_match=n[e.level].max_lazy,e.good_match=n[e.level].good_length,e.nice_match=n[e.level].nice_length,e.max_chain_length=n[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=x-1,e.match_available=0,e.ins_h=0}(e.state),t}function Y(e,t,r,n,s,a){if(!e)return c;var o=1;if(t===d&&(t=6),n<0?(o=0,n=-n):15<n&&(o=2,n-=16),s<1||g<s||r!==_||n<8||15<n||t<0||9<t||a<0||p<a)return R(e,c);8===n&&(n=9);var h=new H;return(e.state=h).strm=e,h.wrap=o,h.gzhead=null,h.w_bits=n,h.w_size=1<<h.w_bits,h.w_mask=h.w_size-1,h.hash_bits=s+7,h.hash_size=1<<h.hash_bits,h.hash_mask=h.hash_size-1,h.hash_shift=~~((h.hash_bits+x-1)/x),h.window=new i.Buf8(2*h.w_size),h.head=new i.Buf16(h.hash_size),h.prev=new i.Buf16(h.w_size),h.lit_bufsize=1<<s+6,h.pending_buf_size=4*h.lit_bufsize,h.pending_buf=new i.Buf8(h.pending_buf_size),h.d_buf=1*h.lit_bufsize,h.l_buf=3*h.lit_bufsize,h.level=t,h.strategy=a,h.method=r,K(e)}n=[new M(0,0,0,0,(function(e,t){var r=65535;for(r>e.pending_buf_size-5&&(r=e.pending_buf_size-5);;){if(e.lookahead<=1){if(j(e),0===e.lookahead&&t===u)return A;if(0===e.lookahead)break}e.strstart+=e.lookahead,e.lookahead=0;var n=e.block_start+r;if((0===e.strstart||e.strstart>=n)&&(e.lookahead=e.strstart-n,e.strstart=n,N(e,!1),0===e.strm.avail_out))return A;if(e.strstart-e.block_start>=e.w_size-z&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===l?(N(e,!0),0===e.strm.avail_out?O:B):(e.strstart>e.block_start&&(N(e,!1),e.strm.avail_out),A)})),new M(4,4,8,4,Z),new M(4,5,16,8,Z),new M(4,6,32,32,Z),new M(4,4,16,16,W),new M(8,16,32,32,W),new M(8,16,128,128,W),new M(8,32,128,256,W),new M(32,128,258,1024,W),new M(32,258,258,4096,W)],r.deflateInit=function(e,t){return Y(e,t,_,15,8,0)},r.deflateInit2=Y,r.deflateReset=K,r.deflateResetKeep=G,r.deflateSetHeader=function(e,t){return e&&e.state?2!==e.state.wrap?c:(e.state.gzhead=t,f):c},r.deflate=function(e,t){var r,i,a,h;if(!e||!e.state||5<t||t<0)return e?R(e,c):c;if(i=e.state,!e.output||!e.input&&0!==e.avail_in||666===i.status&&t!==l)return R(e,0===e.avail_out?-5:c);if(i.strm=e,r=i.last_flush,i.last_flush=t,i.status===C)if(2===i.wrap)e.adler=0,U(i,31),U(i,139),U(i,8),i.gzhead?(U(i,(i.gzhead.text?1:0)+(i.gzhead.hcrc?2:0)+(i.gzhead.extra?4:0)+(i.gzhead.name?8:0)+(i.gzhead.comment?16:0)),U(i,255&i.gzhead.time),U(i,i.gzhead.time>>8&255),U(i,i.gzhead.time>>16&255),U(i,i.gzhead.time>>24&255),U(i,9===i.level?2:2<=i.strategy||i.level<2?4:0),U(i,255&i.gzhead.os),i.gzhead.extra&&i.gzhead.extra.length&&(U(i,255&i.gzhead.extra.length),U(i,i.gzhead.extra.length>>8&255)),i.gzhead.hcrc&&(e.adler=o(e.adler,i.pending_buf,i.pending,0)),i.gzindex=0,i.status=69):(U(i,0),U(i,0),U(i,0),U(i,0),U(i,0),U(i,9===i.level?2:2<=i.strategy||i.level<2?4:0),U(i,3),i.status=E);else{var d=_+(i.w_bits-8<<4)<<8;d|=(2<=i.strategy||i.level<2?0:i.level<6?1:6===i.level?2:3)<<6,0!==i.strstart&&(d|=32),d+=31-d%31,i.status=E,P(i,d),0!==i.strstart&&(P(i,e.adler>>>16),P(i,65535&e.adler)),e.adler=1}if(69===i.status)if(i.gzhead.extra){for(a=i.pending;i.gzindex<(65535&i.gzhead.extra.length)&&(i.pending!==i.pending_buf_size||(i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),F(e),a=i.pending,i.pending!==i.pending_buf_size));)U(i,255&i.gzhead.extra[i.gzindex]),i.gzindex++;i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),i.gzindex===i.gzhead.extra.length&&(i.gzindex=0,i.status=73)}else i.status=73;if(73===i.status)if(i.gzhead.name){a=i.pending;do{if(i.pending===i.pending_buf_size&&(i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),F(e),a=i.pending,i.pending===i.pending_buf_size)){h=1;break}h=i.gzindex<i.gzhead.name.length?255&i.gzhead.name.charCodeAt(i.gzindex++):0,U(i,h)}while(0!==h);i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),0===h&&(i.gzindex=0,i.status=91)}else i.status=91;if(91===i.status)if(i.gzhead.comment){a=i.pending;do{if(i.pending===i.pending_buf_size&&(i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),F(e),a=i.pending,i.pending===i.pending_buf_size)){h=1;break}h=i.gzindex<i.gzhead.comment.length?255&i.gzhead.comment.charCodeAt(i.gzindex++):0,U(i,h)}while(0!==h);i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),0===h&&(i.status=103)}else i.status=103;if(103===i.status&&(i.gzhead.hcrc?(i.pending+2>i.pending_buf_size&&F(e),i.pending+2<=i.pending_buf_size&&(U(i,255&e.adler),U(i,e.adler>>8&255),e.adler=0,i.status=E)):i.status=E),0!==i.pending){if(F(e),0===e.avail_out)return i.last_flush=-1,f}else if(0===e.avail_in&&T(t)<=T(r)&&t!==l)return R(e,-5);if(666===i.status&&0!==e.avail_in)return R(e,-5);if(0!==e.avail_in||0!==i.lookahead||t!==u&&666!==i.status){var p=2===i.strategy?function(e,t){for(var r;;){if(0===e.lookahead&&(j(e),0===e.lookahead)){if(t===u)return A;break}if(e.match_length=0,r=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,r&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}(i,t):3===i.strategy?function(e,t){for(var r,n,i,a,o=e.window;;){if(e.lookahead<=S){if(j(e),e.lookahead<=S&&t===u)return A;if(0===e.lookahead)break}if(e.match_length=0,e.lookahead>=x&&0<e.strstart&&(n=o[i=e.strstart-1])===o[++i]&&n===o[++i]&&n===o[++i]){a=e.strstart+S;do{}while(n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&i<a);e.match_length=S-(a-i),e.match_length>e.lookahead&&(e.match_length=e.lookahead)}if(e.match_length>=x?(r=s._tr_tally(e,1,e.match_length-x),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(r=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),r&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}(i,t):n[i.level].func(i,t);if(p!==O&&p!==B||(i.status=666),p===A||p===O)return 0===e.avail_out&&(i.last_flush=-1),f;if(p===I&&(1===t?s._tr_align(i):5!==t&&(s._tr_stored_block(i,0,0,!1),3===t&&(D(i.head),0===i.lookahead&&(i.strstart=0,i.block_start=0,i.insert=0))),F(e),0===e.avail_out))return i.last_flush=-1,f}return t!==l?f:i.wrap<=0?1:(2===i.wrap?(U(i,255&e.adler),U(i,e.adler>>8&255),U(i,e.adler>>16&255),U(i,e.adler>>24&255),U(i,255&e.total_in),U(i,e.total_in>>8&255),U(i,e.total_in>>16&255),U(i,e.total_in>>24&255)):(P(i,e.adler>>>16),P(i,65535&e.adler)),F(e),0<i.wrap&&(i.wrap=-i.wrap),0!==i.pending?f:1)},r.deflateEnd=function(e){var t;return e&&e.state?(t=e.state.status)!==C&&69!==t&&73!==t&&91!==t&&103!==t&&t!==E&&666!==t?R(e,c):(e.state=null,t===E?R(e,-3):f):c},r.deflateSetDictionary=function(e,t){var r,n,s,o,h,u,l,d,p=t.length;if(!e||!e.state)return c;if(2===(o=(r=e.state).wrap)||1===o&&r.status!==C||r.lookahead)return c;for(1===o&&(e.adler=a(e.adler,t,p,0)),r.wrap=0,p>=r.w_size&&(0===o&&(D(r.head),r.strstart=0,r.block_start=0,r.insert=0),d=new i.Buf8(r.w_size),i.arraySet(d,t,p-r.w_size,r.w_size,0),t=d,p=r.w_size),h=e.avail_in,u=e.next_in,l=e.input,e.avail_in=p,e.next_in=0,e.input=t,j(r);r.lookahead>=x;){for(n=r.strstart,s=r.lookahead-(x-1);r.ins_h=(r.ins_h<<r.hash_shift^r.window[n+x-1])&r.hash_mask,r.prev[n&r.w_mask]=r.head[r.ins_h],r.head[r.ins_h]=n,n++,--s;);r.strstart=n,r.lookahead=x-1,j(r)}return r.strstart+=r.lookahead,r.block_start=r.strstart,r.insert=r.lookahead,r.lookahead=0,r.match_length=r.prev_length=x-1,r.match_available=0,e.next_in=u,e.input=l,e.avail_in=h,r.wrap=o,f},r.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./messages":51,"./trees":52}],47:[function(e,t,r){"use strict";t.exports=function(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}},{}],48:[function(e,t,r){"use strict";t.exports=function(e,t){var r,n,i,s,a,o,h,u,l,f,c,d,p,m,_,g,b,v,y,w,k,x,S,z,C;r=e.state,n=e.next_in,z=e.input,i=n+(e.avail_in-5),s=e.next_out,C=e.output,a=s-(t-e.avail_out),o=s+(e.avail_out-257),h=r.dmax,u=r.wsize,l=r.whave,f=r.wnext,c=r.window,d=r.hold,p=r.bits,m=r.lencode,_=r.distcode,g=(1<<r.lenbits)-1,b=(1<<r.distbits)-1;e:do{p<15&&(d+=z[n++]<<p,p+=8,d+=z[n++]<<p,p+=8),v=m[d&g];t:for(;;){if(d>>>=y=v>>>24,p-=y,0===(y=v>>>16&255))C[s++]=65535&v;else{if(!(16&y)){if(0==(64&y)){v=m[(65535&v)+(d&(1<<y)-1)];continue t}if(32&y){r.mode=12;break e}e.msg="invalid literal/length code",r.mode=30;break e}w=65535&v,(y&=15)&&(p<y&&(d+=z[n++]<<p,p+=8),w+=d&(1<<y)-1,d>>>=y,p-=y),p<15&&(d+=z[n++]<<p,p+=8,d+=z[n++]<<p,p+=8),v=_[d&b];r:for(;;){if(d>>>=y=v>>>24,p-=y,!(16&(y=v>>>16&255))){if(0==(64&y)){v=_[(65535&v)+(d&(1<<y)-1)];continue r}e.msg="invalid distance code",r.mode=30;break e}if(k=65535&v,p<(y&=15)&&(d+=z[n++]<<p,(p+=8)<y&&(d+=z[n++]<<p,p+=8)),h<(k+=d&(1<<y)-1)){e.msg="invalid distance too far back",r.mode=30;break e}if(d>>>=y,p-=y,(y=s-a)<k){if(l<(y=k-y)&&r.sane){e.msg="invalid distance too far back",r.mode=30;break e}if(S=c,(x=0)===f){if(x+=u-y,y<w){for(w-=y;C[s++]=c[x++],--y;);x=s-k,S=C}}else if(f<y){if(x+=u+f-y,(y-=f)<w){for(w-=y;C[s++]=c[x++],--y;);if(x=0,f<w){for(w-=y=f;C[s++]=c[x++],--y;);x=s-k,S=C}}}else if(x+=f-y,y<w){for(w-=y;C[s++]=c[x++],--y;);x=s-k,S=C}for(;2<w;)C[s++]=S[x++],C[s++]=S[x++],C[s++]=S[x++],w-=3;w&&(C[s++]=S[x++],1<w&&(C[s++]=S[x++]))}else{for(x=s-k;C[s++]=C[x++],C[s++]=C[x++],C[s++]=C[x++],2<(w-=3););w&&(C[s++]=C[x++],1<w&&(C[s++]=C[x++]))}break}}break}}while(n<i&&s<o);n-=w=p>>3,d&=(1<<(p-=w<<3))-1,e.next_in=n,e.next_out=s,e.avail_in=n<i?i-n+5:5-(n-i),e.avail_out=s<o?o-s+257:257-(s-o),r.hold=d,r.bits=p}},{}],49:[function(e,t,r){"use strict";var n=e("../utils/common"),i=e("./adler32"),s=e("./crc32"),a=e("./inffast"),o=e("./inftrees"),h=1,u=2,l=0,f=-2,c=1,d=852,p=592;function m(e){return(e>>>24&255)+(e>>>8&65280)+((65280&e)<<8)+((255&e)<<24)}function _(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new n.Buf16(320),this.work=new n.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function g(e){var t;return e&&e.state?(t=e.state,e.total_in=e.total_out=t.total=0,e.msg="",t.wrap&&(e.adler=1&t.wrap),t.mode=c,t.last=0,t.havedict=0,t.dmax=32768,t.head=null,t.hold=0,t.bits=0,t.lencode=t.lendyn=new n.Buf32(d),t.distcode=t.distdyn=new n.Buf32(p),t.sane=1,t.back=-1,l):f}function b(e){var t;return e&&e.state?((t=e.state).wsize=0,t.whave=0,t.wnext=0,g(e)):f}function v(e,t){var r,n;return e&&e.state?(n=e.state,t<0?(r=0,t=-t):(r=1+(t>>4),t<48&&(t&=15)),t&&(t<8||15<t)?f:(null!==n.window&&n.wbits!==t&&(n.window=null),n.wrap=r,n.wbits=t,b(e))):f}function y(e,t){var r,n;return e?(n=new _,(e.state=n).window=null,(r=v(e,t))!==l&&(e.state=null),r):f}var w,k,x=!0;function S(e){if(x){var t;for(w=new n.Buf32(512),k=new n.Buf32(32),t=0;t<144;)e.lens[t++]=8;for(;t<256;)e.lens[t++]=9;for(;t<280;)e.lens[t++]=7;for(;t<288;)e.lens[t++]=8;for(o(h,e.lens,0,288,w,0,e.work,{bits:9}),t=0;t<32;)e.lens[t++]=5;o(u,e.lens,0,32,k,0,e.work,{bits:5}),x=!1}e.lencode=w,e.lenbits=9,e.distcode=k,e.distbits=5}function z(e,t,r,i){var s,a=e.state;return null===a.window&&(a.wsize=1<<a.wbits,a.wnext=0,a.whave=0,a.window=new n.Buf8(a.wsize)),i>=a.wsize?(n.arraySet(a.window,t,r-a.wsize,a.wsize,0),a.wnext=0,a.whave=a.wsize):(i<(s=a.wsize-a.wnext)&&(s=i),n.arraySet(a.window,t,r-i,s,a.wnext),(i-=s)?(n.arraySet(a.window,t,r-i,i,0),a.wnext=i,a.whave=a.wsize):(a.wnext+=s,a.wnext===a.wsize&&(a.wnext=0),a.whave<a.wsize&&(a.whave+=s))),0}r.inflateReset=b,r.inflateReset2=v,r.inflateResetKeep=g,r.inflateInit=function(e){return y(e,15)},r.inflateInit2=y,r.inflate=function(e,t){var r,d,p,_,g,b,v,y,w,k,x,C,E,A,I,O,B,R,T,D,F,N,U,P,L=0,j=new n.Buf8(4),Z=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!e||!e.state||!e.output||!e.input&&0!==e.avail_in)return f;12===(r=e.state).mode&&(r.mode=13),g=e.next_out,p=e.output,v=e.avail_out,_=e.next_in,d=e.input,b=e.avail_in,y=r.hold,w=r.bits,k=b,x=v,N=l;e:for(;;)switch(r.mode){case c:if(0===r.wrap){r.mode=13;break}for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(2&r.wrap&&35615===y){j[r.check=0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0),w=y=0,r.mode=2;break}if(r.flags=0,r.head&&(r.head.done=!1),!(1&r.wrap)||(((255&y)<<8)+(y>>8))%31){e.msg="incorrect header check",r.mode=30;break}if(8!=(15&y)){e.msg="unknown compression method",r.mode=30;break}if(w-=4,F=8+(15&(y>>>=4)),0===r.wbits)r.wbits=F;else if(F>r.wbits){e.msg="invalid window size",r.mode=30;break}r.dmax=1<<F,e.adler=r.check=1,r.mode=512&y?10:12,w=y=0;break;case 2:for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(r.flags=y,8!=(255&r.flags)){e.msg="unknown compression method",r.mode=30;break}if(57344&r.flags){e.msg="unknown header flags set",r.mode=30;break}r.head&&(r.head.text=y>>8&1),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0)),w=y=0,r.mode=3;case 3:for(;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.head&&(r.head.time=y),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,j[2]=y>>>16&255,j[3]=y>>>24&255,r.check=s(r.check,j,4,0)),w=y=0,r.mode=4;case 4:for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.head&&(r.head.xflags=255&y,r.head.os=y>>8),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0)),w=y=0,r.mode=5;case 5:if(1024&r.flags){for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.length=y,r.head&&(r.head.extra_len=y),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0)),w=y=0}else r.head&&(r.head.extra=null);r.mode=6;case 6:if(1024&r.flags&&(b<(C=r.length)&&(C=b),C&&(r.head&&(F=r.head.extra_len-r.length,r.head.extra||(r.head.extra=new Array(r.head.extra_len)),n.arraySet(r.head.extra,d,_,C,F)),512&r.flags&&(r.check=s(r.check,d,C,_)),b-=C,_+=C,r.length-=C),r.length))break e;r.length=0,r.mode=7;case 7:if(2048&r.flags){if(0===b)break e;for(C=0;F=d[_+C++],r.head&&F&&r.length<65536&&(r.head.name+=String.fromCharCode(F)),F&&C<b;);if(512&r.flags&&(r.check=s(r.check,d,C,_)),b-=C,_+=C,F)break e}else r.head&&(r.head.name=null);r.length=0,r.mode=8;case 8:if(4096&r.flags){if(0===b)break e;for(C=0;F=d[_+C++],r.head&&F&&r.length<65536&&(r.head.comment+=String.fromCharCode(F)),F&&C<b;);if(512&r.flags&&(r.check=s(r.check,d,C,_)),b-=C,_+=C,F)break e}else r.head&&(r.head.comment=null);r.mode=9;case 9:if(512&r.flags){for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(y!==(65535&r.check)){e.msg="header crc mismatch",r.mode=30;break}w=y=0}r.head&&(r.head.hcrc=r.flags>>9&1,r.head.done=!0),e.adler=r.check=0,r.mode=12;break;case 10:for(;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}e.adler=r.check=m(y),w=y=0,r.mode=11;case 11:if(0===r.havedict)return e.next_out=g,e.avail_out=v,e.next_in=_,e.avail_in=b,r.hold=y,r.bits=w,2;e.adler=r.check=1,r.mode=12;case 12:if(5===t||6===t)break e;case 13:if(r.last){y>>>=7&w,w-=7&w,r.mode=27;break}for(;w<3;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}switch(r.last=1&y,w-=1,3&(y>>>=1)){case 0:r.mode=14;break;case 1:if(S(r),r.mode=20,6!==t)break;y>>>=2,w-=2;break e;case 2:r.mode=17;break;case 3:e.msg="invalid block type",r.mode=30}y>>>=2,w-=2;break;case 14:for(y>>>=7&w,w-=7&w;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if((65535&y)!=(y>>>16^65535)){e.msg="invalid stored block lengths",r.mode=30;break}if(r.length=65535&y,w=y=0,r.mode=15,6===t)break e;case 15:r.mode=16;case 16:if(C=r.length){if(b<C&&(C=b),v<C&&(C=v),0===C)break e;n.arraySet(p,d,_,C,g),b-=C,_+=C,v-=C,g+=C,r.length-=C;break}r.mode=12;break;case 17:for(;w<14;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(r.nlen=257+(31&y),y>>>=5,w-=5,r.ndist=1+(31&y),y>>>=5,w-=5,r.ncode=4+(15&y),y>>>=4,w-=4,286<r.nlen||30<r.ndist){e.msg="too many length or distance symbols",r.mode=30;break}r.have=0,r.mode=18;case 18:for(;r.have<r.ncode;){for(;w<3;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.lens[Z[r.have++]]=7&y,y>>>=3,w-=3}for(;r.have<19;)r.lens[Z[r.have++]]=0;if(r.lencode=r.lendyn,r.lenbits=7,U={bits:r.lenbits},N=o(0,r.lens,0,19,r.lencode,0,r.work,U),r.lenbits=U.bits,N){e.msg="invalid code lengths set",r.mode=30;break}r.have=0,r.mode=19;case 19:for(;r.have<r.nlen+r.ndist;){for(;O=(L=r.lencode[y&(1<<r.lenbits)-1])>>>16&255,B=65535&L,!((I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(B<16)y>>>=I,w-=I,r.lens[r.have++]=B;else{if(16===B){for(P=I+2;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(y>>>=I,w-=I,0===r.have){e.msg="invalid bit length repeat",r.mode=30;break}F=r.lens[r.have-1],C=3+(3&y),y>>>=2,w-=2}else if(17===B){for(P=I+3;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}w-=I,F=0,C=3+(7&(y>>>=I)),y>>>=3,w-=3}else{for(P=I+7;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}w-=I,F=0,C=11+(127&(y>>>=I)),y>>>=7,w-=7}if(r.have+C>r.nlen+r.ndist){e.msg="invalid bit length repeat",r.mode=30;break}for(;C--;)r.lens[r.have++]=F}}if(30===r.mode)break;if(0===r.lens[256]){e.msg="invalid code -- missing end-of-block",r.mode=30;break}if(r.lenbits=9,U={bits:r.lenbits},N=o(h,r.lens,0,r.nlen,r.lencode,0,r.work,U),r.lenbits=U.bits,N){e.msg="invalid literal/lengths set",r.mode=30;break}if(r.distbits=6,r.distcode=r.distdyn,U={bits:r.distbits},N=o(u,r.lens,r.nlen,r.ndist,r.distcode,0,r.work,U),r.distbits=U.bits,N){e.msg="invalid distances set",r.mode=30;break}if(r.mode=20,6===t)break e;case 20:r.mode=21;case 21:if(6<=b&&258<=v){e.next_out=g,e.avail_out=v,e.next_in=_,e.avail_in=b,r.hold=y,r.bits=w,a(e,x),g=e.next_out,p=e.output,v=e.avail_out,_=e.next_in,d=e.input,b=e.avail_in,y=r.hold,w=r.bits,12===r.mode&&(r.back=-1);break}for(r.back=0;O=(L=r.lencode[y&(1<<r.lenbits)-1])>>>16&255,B=65535&L,!((I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(O&&0==(240&O)){for(R=I,T=O,D=B;O=(L=r.lencode[D+((y&(1<<R+T)-1)>>R)])>>>16&255,B=65535&L,!(R+(I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}y>>>=R,w-=R,r.back+=R}if(y>>>=I,w-=I,r.back+=I,r.length=B,0===O){r.mode=26;break}if(32&O){r.back=-1,r.mode=12;break}if(64&O){e.msg="invalid literal/length code",r.mode=30;break}r.extra=15&O,r.mode=22;case 22:if(r.extra){for(P=r.extra;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.length+=y&(1<<r.extra)-1,y>>>=r.extra,w-=r.extra,r.back+=r.extra}r.was=r.length,r.mode=23;case 23:for(;O=(L=r.distcode[y&(1<<r.distbits)-1])>>>16&255,B=65535&L,!((I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(0==(240&O)){for(R=I,T=O,D=B;O=(L=r.distcode[D+((y&(1<<R+T)-1)>>R)])>>>16&255,B=65535&L,!(R+(I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}y>>>=R,w-=R,r.back+=R}if(y>>>=I,w-=I,r.back+=I,64&O){e.msg="invalid distance code",r.mode=30;break}r.offset=B,r.extra=15&O,r.mode=24;case 24:if(r.extra){for(P=r.extra;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.offset+=y&(1<<r.extra)-1,y>>>=r.extra,w-=r.extra,r.back+=r.extra}if(r.offset>r.dmax){e.msg="invalid distance too far back",r.mode=30;break}r.mode=25;case 25:if(0===v)break e;if(C=x-v,r.offset>C){if((C=r.offset-C)>r.whave&&r.sane){e.msg="invalid distance too far back",r.mode=30;break}E=C>r.wnext?(C-=r.wnext,r.wsize-C):r.wnext-C,C>r.length&&(C=r.length),A=r.window}else A=p,E=g-r.offset,C=r.length;for(v<C&&(C=v),v-=C,r.length-=C;p[g++]=A[E++],--C;);0===r.length&&(r.mode=21);break;case 26:if(0===v)break e;p[g++]=r.length,v--,r.mode=21;break;case 27:if(r.wrap){for(;w<32;){if(0===b)break e;b--,y|=d[_++]<<w,w+=8}if(x-=v,e.total_out+=x,r.total+=x,x&&(e.adler=r.check=r.flags?s(r.check,p,x,g-x):i(r.check,p,x,g-x)),x=v,(r.flags?y:m(y))!==r.check){e.msg="incorrect data check",r.mode=30;break}w=y=0}r.mode=28;case 28:if(r.wrap&&r.flags){for(;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(y!==(4294967295&r.total)){e.msg="incorrect length check",r.mode=30;break}w=y=0}r.mode=29;case 29:N=1;break e;case 30:N=-3;break e;case 31:return-4;case 32:default:return f}return e.next_out=g,e.avail_out=v,e.next_in=_,e.avail_in=b,r.hold=y,r.bits=w,(r.wsize||x!==e.avail_out&&r.mode<30&&(r.mode<27||4!==t))&&z(e,e.output,e.next_out,x-e.avail_out)?(r.mode=31,-4):(k-=e.avail_in,x-=e.avail_out,e.total_in+=k,e.total_out+=x,r.total+=x,r.wrap&&x&&(e.adler=r.check=r.flags?s(r.check,p,x,e.next_out-x):i(r.check,p,x,e.next_out-x)),e.data_type=r.bits+(r.last?64:0)+(12===r.mode?128:0)+(20===r.mode||15===r.mode?256:0),(0==k&&0===x||4===t)&&N===l&&(N=-5),N)},r.inflateEnd=function(e){if(!e||!e.state)return f;var t=e.state;return t.window&&(t.window=null),e.state=null,l},r.inflateGetHeader=function(e,t){var r;return e&&e.state?0==(2&(r=e.state).wrap)?f:((r.head=t).done=!1,l):f},r.inflateSetDictionary=function(e,t){var r,n=t.length;return e&&e.state?0!==(r=e.state).wrap&&11!==r.mode?f:11===r.mode&&i(1,t,n,0)!==r.check?-3:z(e,t,n,n)?(r.mode=31,-4):(r.havedict=1,l):f},r.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./inffast":48,"./inftrees":50}],50:[function(e,t,r){"use strict";var n=e("../utils/common"),i=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],s=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],a=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],o=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];t.exports=function(e,t,r,h,u,l,f,c){var d,p,m,_,g,b,v,y,w,k=c.bits,x=0,S=0,z=0,C=0,E=0,A=0,I=0,O=0,B=0,R=0,T=null,D=0,F=new n.Buf16(16),N=new n.Buf16(16),U=null,P=0;for(x=0;x<=15;x++)F[x]=0;for(S=0;S<h;S++)F[t[r+S]]++;for(E=k,C=15;1<=C&&0===F[C];C--);if(C<E&&(E=C),0===C)return u[l++]=20971520,u[l++]=20971520,c.bits=1,0;for(z=1;z<C&&0===F[z];z++);for(E<z&&(E=z),x=O=1;x<=15;x++)if(O<<=1,(O-=F[x])<0)return-1;if(0<O&&(0===e||1!==C))return-1;for(N[1]=0,x=1;x<15;x++)N[x+1]=N[x]+F[x];for(S=0;S<h;S++)0!==t[r+S]&&(f[N[t[r+S]]++]=S);if(b=0===e?(T=U=f,19):1===e?(T=i,D-=257,U=s,P-=257,256):(T=a,U=o,-1),x=z,g=l,I=S=R=0,m=-1,_=(B=1<<(A=E))-1,1===e&&852<B||2===e&&592<B)return 1;for(;;){for(v=x-I,w=f[S]<b?(y=0,f[S]):f[S]>b?(y=U[P+f[S]],T[D+f[S]]):(y=96,0),d=1<<x-I,z=p=1<<A;u[g+(R>>I)+(p-=d)]=v<<24|y<<16|w|0,0!==p;);for(d=1<<x-1;R&d;)d>>=1;if(0!==d?(R&=d-1,R+=d):R=0,S++,0==--F[x]){if(x===C)break;x=t[r+f[S]]}if(E<x&&(R&_)!==m){for(0===I&&(I=E),g+=z,O=1<<(A=x-I);A+I<C&&!((O-=F[A+I])<=0);)A++,O<<=1;if(B+=1<<A,1===e&&852<B||2===e&&592<B)return 1;u[m=R&_]=E<<24|A<<16|g-l|0}}return 0!==R&&(u[g+R]=x-I<<24|64<<16|0),c.bits=E,0}},{"../utils/common":41}],51:[function(e,t,r){"use strict";t.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],52:[function(e,t,r){"use strict";var n=e("../utils/common"),i=0,s=1;function a(e){for(var t=e.length;0<=--t;)e[t]=0}var o=0,h=29,u=256,l=u+1+h,f=30,c=19,d=2*l+1,p=15,m=16,_=7,g=256,b=16,v=17,y=18,w=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],k=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],x=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],S=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],z=new Array(2*(l+2));a(z);var C=new Array(2*f);a(C);var E=new Array(512);a(E);var A=new Array(256);a(A);var I=new Array(h);a(I);var O,B,R,T=new Array(f);function D(e,t,r,n,i){this.static_tree=e,this.extra_bits=t,this.extra_base=r,this.elems=n,this.max_length=i,this.has_stree=e&&e.length}function F(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t}function N(e){return e<256?E[e]:E[256+(e>>>7)]}function U(e,t){e.pending_buf[e.pending++]=255&t,e.pending_buf[e.pending++]=t>>>8&255}function P(e,t,r){e.bi_valid>m-r?(e.bi_buf|=t<<e.bi_valid&65535,U(e,e.bi_buf),e.bi_buf=t>>m-e.bi_valid,e.bi_valid+=r-m):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=r)}function L(e,t,r){P(e,r[2*t],r[2*t+1])}function j(e,t){for(var r=0;r|=1&e,e>>>=1,r<<=1,0<--t;);return r>>>1}function Z(e,t,r){var n,i,s=new Array(p+1),a=0;for(n=1;n<=p;n++)s[n]=a=a+r[n-1]<<1;for(i=0;i<=t;i++){var o=e[2*i+1];0!==o&&(e[2*i]=j(s[o]++,o))}}function W(e){var t;for(t=0;t<l;t++)e.dyn_ltree[2*t]=0;for(t=0;t<f;t++)e.dyn_dtree[2*t]=0;for(t=0;t<c;t++)e.bl_tree[2*t]=0;e.dyn_ltree[2*g]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0}function M(e){8<e.bi_valid?U(e,e.bi_buf):0<e.bi_valid&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0}function H(e,t,r,n){var i=2*t,s=2*r;return e[i]<e[s]||e[i]===e[s]&&n[t]<=n[r]}function G(e,t,r){for(var n=e.heap[r],i=r<<1;i<=e.heap_len&&(i<e.heap_len&&H(t,e.heap[i+1],e.heap[i],e.depth)&&i++,!H(t,n,e.heap[i],e.depth));)e.heap[r]=e.heap[i],r=i,i<<=1;e.heap[r]=n}function K(e,t,r){var n,i,s,a,o=0;if(0!==e.last_lit)for(;n=e.pending_buf[e.d_buf+2*o]<<8|e.pending_buf[e.d_buf+2*o+1],i=e.pending_buf[e.l_buf+o],o++,0===n?L(e,i,t):(L(e,(s=A[i])+u+1,t),0!==(a=w[s])&&P(e,i-=I[s],a),L(e,s=N(--n),r),0!==(a=k[s])&&P(e,n-=T[s],a)),o<e.last_lit;);L(e,g,t)}function Y(e,t){var r,n,i,s=t.dyn_tree,a=t.stat_desc.static_tree,o=t.stat_desc.has_stree,h=t.stat_desc.elems,u=-1;for(e.heap_len=0,e.heap_max=d,r=0;r<h;r++)0!==s[2*r]?(e.heap[++e.heap_len]=u=r,e.depth[r]=0):s[2*r+1]=0;for(;e.heap_len<2;)s[2*(i=e.heap[++e.heap_len]=u<2?++u:0)]=1,e.depth[i]=0,e.opt_len--,o&&(e.static_len-=a[2*i+1]);for(t.max_code=u,r=e.heap_len>>1;1<=r;r--)G(e,s,r);for(i=h;r=e.heap[1],e.heap[1]=e.heap[e.heap_len--],G(e,s,1),n=e.heap[1],e.heap[--e.heap_max]=r,e.heap[--e.heap_max]=n,s[2*i]=s[2*r]+s[2*n],e.depth[i]=(e.depth[r]>=e.depth[n]?e.depth[r]:e.depth[n])+1,s[2*r+1]=s[2*n+1]=i,e.heap[1]=i++,G(e,s,1),2<=e.heap_len;);e.heap[--e.heap_max]=e.heap[1],function(e,t){var r,n,i,s,a,o,h=t.dyn_tree,u=t.max_code,l=t.stat_desc.static_tree,f=t.stat_desc.has_stree,c=t.stat_desc.extra_bits,m=t.stat_desc.extra_base,_=t.stat_desc.max_length,g=0;for(s=0;s<=p;s++)e.bl_count[s]=0;for(h[2*e.heap[e.heap_max]+1]=0,r=e.heap_max+1;r<d;r++)_<(s=h[2*h[2*(n=e.heap[r])+1]+1]+1)&&(s=_,g++),h[2*n+1]=s,u<n||(e.bl_count[s]++,a=0,m<=n&&(a=c[n-m]),o=h[2*n],e.opt_len+=o*(s+a),f&&(e.static_len+=o*(l[2*n+1]+a)));if(0!==g){do{for(s=_-1;0===e.bl_count[s];)s--;e.bl_count[s]--,e.bl_count[s+1]+=2,e.bl_count[_]--,g-=2}while(0<g);for(s=_;0!==s;s--)for(n=e.bl_count[s];0!==n;)u<(i=e.heap[--r])||(h[2*i+1]!==s&&(e.opt_len+=(s-h[2*i+1])*h[2*i],h[2*i+1]=s),n--)}}(e,t),Z(s,u,e.bl_count)}function X(e,t,r){var n,i,s=-1,a=t[1],o=0,h=7,u=4;for(0===a&&(h=138,u=3),t[2*(r+1)+1]=65535,n=0;n<=r;n++)i=a,a=t[2*(n+1)+1],++o<h&&i===a||(o<u?e.bl_tree[2*i]+=o:0!==i?(i!==s&&e.bl_tree[2*i]++,e.bl_tree[2*b]++):o<=10?e.bl_tree[2*v]++:e.bl_tree[2*y]++,s=i,u=(o=0)===a?(h=138,3):i===a?(h=6,3):(h=7,4))}function V(e,t,r){var n,i,s=-1,a=t[1],o=0,h=7,u=4;for(0===a&&(h=138,u=3),n=0;n<=r;n++)if(i=a,a=t[2*(n+1)+1],!(++o<h&&i===a)){if(o<u)for(;L(e,i,e.bl_tree),0!=--o;);else 0!==i?(i!==s&&(L(e,i,e.bl_tree),o--),L(e,b,e.bl_tree),P(e,o-3,2)):o<=10?(L(e,v,e.bl_tree),P(e,o-3,3)):(L(e,y,e.bl_tree),P(e,o-11,7));s=i,u=(o=0)===a?(h=138,3):i===a?(h=6,3):(h=7,4)}}a(T);var q=!1;function J(e,t,r,i){P(e,(o<<1)+(i?1:0),3),function(e,t,r,i){M(e),i&&(U(e,r),U(e,~r)),n.arraySet(e.pending_buf,e.window,t,r,e.pending),e.pending+=r}(e,t,r,!0)}r._tr_init=function(e){q||(function(){var e,t,r,n,i,s=new Array(p+1);for(n=r=0;n<h-1;n++)for(I[n]=r,e=0;e<1<<w[n];e++)A[r++]=n;for(A[r-1]=n,n=i=0;n<16;n++)for(T[n]=i,e=0;e<1<<k[n];e++)E[i++]=n;for(i>>=7;n<f;n++)for(T[n]=i<<7,e=0;e<1<<k[n]-7;e++)E[256+i++]=n;for(t=0;t<=p;t++)s[t]=0;for(e=0;e<=143;)z[2*e+1]=8,e++,s[8]++;for(;e<=255;)z[2*e+1]=9,e++,s[9]++;for(;e<=279;)z[2*e+1]=7,e++,s[7]++;for(;e<=287;)z[2*e+1]=8,e++,s[8]++;for(Z(z,l+1,s),e=0;e<f;e++)C[2*e+1]=5,C[2*e]=j(e,5);O=new D(z,w,u+1,l,p),B=new D(C,k,0,f,p),R=new D(new Array(0),x,0,c,_)}(),q=!0),e.l_desc=new F(e.dyn_ltree,O),e.d_desc=new F(e.dyn_dtree,B),e.bl_desc=new F(e.bl_tree,R),e.bi_buf=0,e.bi_valid=0,W(e)},r._tr_stored_block=J,r._tr_flush_block=function(e,t,r,n){var a,o,h=0;0<e.level?(2===e.strm.data_type&&(e.strm.data_type=function(e){var t,r=4093624447;for(t=0;t<=31;t++,r>>>=1)if(1&r&&0!==e.dyn_ltree[2*t])return i;if(0!==e.dyn_ltree[18]||0!==e.dyn_ltree[20]||0!==e.dyn_ltree[26])return s;for(t=32;t<u;t++)if(0!==e.dyn_ltree[2*t])return s;return i}(e)),Y(e,e.l_desc),Y(e,e.d_desc),h=function(e){var t;for(X(e,e.dyn_ltree,e.l_desc.max_code),X(e,e.dyn_dtree,e.d_desc.max_code),Y(e,e.bl_desc),t=c-1;3<=t&&0===e.bl_tree[2*S[t]+1];t--);return e.opt_len+=3*(t+1)+5+5+4,t}(e),a=e.opt_len+3+7>>>3,(o=e.static_len+3+7>>>3)<=a&&(a=o)):a=o=r+5,r+4<=a&&-1!==t?J(e,t,r,n):4===e.strategy||o===a?(P(e,2+(n?1:0),3),K(e,z,C)):(P(e,4+(n?1:0),3),function(e,t,r,n){var i;for(P(e,t-257,5),P(e,r-1,5),P(e,n-4,4),i=0;i<n;i++)P(e,e.bl_tree[2*S[i]+1],3);V(e,e.dyn_ltree,t-1),V(e,e.dyn_dtree,r-1)}(e,e.l_desc.max_code+1,e.d_desc.max_code+1,h+1),K(e,e.dyn_ltree,e.dyn_dtree)),W(e),n&&M(e)},r._tr_tally=function(e,t,r){return e.pending_buf[e.d_buf+2*e.last_lit]=t>>>8&255,e.pending_buf[e.d_buf+2*e.last_lit+1]=255&