/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.BaseSession;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBLeasedSession;
import org.jetbrains.dekaf.core.DBLeasedSessionWrapper;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.InSession;
import org.jetbrains.dekaf.core.InSessionNoResult;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.exceptions.DBIsNotConnected;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;

public class BaseFacade
implements DBFacade {
    @NotNull
    private final IntegralIntermediateFacade myInterFacade;
    @Nullable
    private ConnectionInfo myConnectionInfo;

    public BaseFacade(@NotNull IntegralIntermediateFacade interFacade) {
        this.myInterFacade = interFacade;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return this.myInterFacade.rdbms();
    }

    @Override
    public synchronized void connect() {
        this.myInterFacade.connect();
        this.myConnectionInfo = null;
    }

    @Override
    public synchronized void reconnect() {
        this.myInterFacade.reconnect();
        this.myConnectionInfo = null;
    }

    @Override
    public synchronized void disconnect() {
        this.myInterFacade.disconnect();
        this.myConnectionInfo = null;
    }

    @Override
    public boolean isConnected() {
        return this.myInterFacade.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo ci = this.myConnectionInfo;
        if (ci == null) {
            BaseFacade baseFacade = this;
            synchronized (baseFacade) {
                ci = this.myConnectionInfo;
                if (ci == null) {
                    this.myConnectionInfo = ci = this.myInterFacade.getConnectionInfo();
                }
            }
        }
        return ci;
    }

    @Override
    public <R> R inTransaction(final InTransaction<R> operation) {
        return this.inSession(new InSession<R>(){

            @Override
            public R run(@NotNull DBSession session) {
                return session.inTransaction(operation);
            }
        });
    }

    @Override
    public void inTransaction(final InTransactionNoResult operation) {
        this.inSession(new InSessionNoResult(){

            @Override
            public void run(@NotNull DBSession session) {
                session.inTransaction(operation);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R inSession(InSession<R> operation) {
        R result;
        if (operation == null) {
            throw new IllegalArgumentException("The operation is null");
        }
        if (!this.isConnected()) {
            throw new DBIsNotConnected("Facade is not connected.");
        }
        IntegralIntermediateSession interSession = this.instantiateIntermediateSession();
        try {
            BaseSession session = new BaseSession(interSession);
            result = operation.run(session);
            session.closeRunners();
        }
        finally {
            interSession.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inSession(InSessionNoResult operation) {
        if (operation == null) {
            return;
        }
        if (!this.isConnected()) {
            throw new DBIsNotConnected("Facade is not connected.");
        }
        IntegralIntermediateSession interSession = this.instantiateIntermediateSession();
        try {
            BaseSession session = new BaseSession(interSession);
            operation.run(session);
            session.closeRunners();
        }
        finally {
            interSession.close();
        }
    }

    @Override
    public synchronized DBLeasedSession leaseSession() {
        IntegralIntermediateSession interSession = this.instantiateIntermediateSession();
        BaseSession baseSession = new BaseSession(interSession);
        return new DBLeasedSessionWrapper(baseSession);
    }

    @NotNull
    protected synchronized IntegralIntermediateSession instantiateIntermediateSession() {
        return this.myInterFacade.openSession();
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        return this.myInterFacade.getSpecificService(serviceClass, serviceName);
    }
}

