/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumbService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbService");
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract ModificationTracker getModificationTracker();

    public abstract boolean isDumb();

    public static boolean isDumb(@NotNull Project project) {
        if (project == null) {
            DumbService.$$$reportNull$$$0(0);
        }
        return DumbService.getInstance(project).isDumb();
    }

    public abstract void runWhenSmart(@NotNull Runnable var1);

    public abstract void waitForSmartMode();

    public <T> T runReadActionInSmartMode(@NotNull Computable<T> r) {
        if (r == null) {
            DumbService.$$$reportNull$$$0(1);
        }
        Ref result2 = new Ref();
        this.runReadActionInSmartMode(() -> {
            if (r == null) {
                DumbService.$$$reportNull$$$0(20);
            }
            result2.set(r.compute());
        });
        return (T)result2.get();
    }

    @Nullable
    public <T> T tryRunReadActionInSmartMode(@NotNull Computable<T> task, @Nullable String notification) {
        if (task == null) {
            DumbService.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                return (T)task.compute();
            }
            catch (IndexNotReadyException e) {
                if (notification != null) {
                    this.showDumbModeNotification(notification);
                }
                return null;
            }
        }
        return this.runReadActionInSmartMode(task);
    }

    public void runReadActionInSmartMode(@NotNull Runnable r) {
        boolean success;
        if (r == null) {
            DumbService.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            r.run();
            return;
        }
        do {
            this.waitForSmartMode();
        } while (!(success = ((Boolean)ReadAction.compute(() -> {
            if (r == null) {
                DumbService.$$$reportNull$$$0(19);
            }
            if (this.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (this.isDumb()) {
                return false;
            }
            r.run();
            return true;
        })).booleanValue()));
    }

    public void repeatUntilPassesInSmartMode(@NotNull Runnable r) {
        if (r == null) {
            DumbService.$$$reportNull$$$0(4);
        }
        while (true) {
            this.waitForSmartMode();
            try {
                r.run();
                return;
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
                continue;
            }
            break;
        }
    }

    public abstract void smartInvokeLater(@NotNull Runnable var1);

    public abstract void smartInvokeLater(@NotNull Runnable var1, @NotNull ModalityState var2);

    public static DumbService getInstance(@NotNull Project project) {
        if (project == null) {
            DumbService.$$$reportNull$$$0(5);
        }
        return (DumbService)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull T[] array) {
        if (array == null) {
            DumbService.$$$reportNull$$$0(6);
        }
        List<T> list = this.filterByDumbAwareness(Arrays.asList(array));
        if (list == null) {
            DumbService.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<T> collection) {
        if (collection == null) {
            DumbService.$$$reportNull$$$0(8);
        }
        if (this.isDumb()) {
            ArrayList<T> result2 = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result2.add(element);
            }
            ArrayList<T> arrayList = result2;
            if (arrayList == null) {
                DumbService.$$$reportNull$$$0(9);
            }
            return arrayList;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            if (list == null) {
                DumbService.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        if (arrayList == null) {
            DumbService.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public abstract void queueTask(@NotNull DumbModeTask var1);

    public abstract void cancelTask(@NotNull DumbModeTask var1);

    public abstract void completeJustSubmittedTasks();

    public abstract JComponent wrapGently(@NotNull JComponent var1, @NotNull Disposable var2);

    public void makeDumbAware(final @NotNull JComponent component, @NotNull Disposable disposable) {
        if (component == null) {
            DumbService.$$$reportNull$$$0(12);
        }
        if (disposable == null) {
            DumbService.$$$reportNull$$$0(13);
        }
        component.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(disposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                component.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                component.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(@NotNull String var1);

    public abstract Project getProject();

    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    public abstract void setAlternativeResolveEnabled(boolean var1);

    public void withAlternativeResolveEnabled(@NotNull Runnable runnable) {
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(14);
        }
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public <T, E extends Throwable> T computeWithAlternativeResolveEnabled(@NotNull ThrowableComputable<T, E> runnable) throws E {
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(15);
        }
        this.setAlternativeResolveEnabled(true);
        try {
            Object object = runnable.compute();
            return (T)object;
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public <E extends Throwable> void runWithAlternativeResolveEnabled(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(16);
        }
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public abstract boolean isAlternativeResolveEnabled();

    @Deprecated
    public static void allowStartingDumbModeInside(@NotNull DumbModePermission permission, @NotNull Runnable runnable) {
        if (permission == null) {
            DumbService.$$$reportNull$$$0(17);
        }
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(18);
        }
        runnable.run();
    }

    public abstract void suspendIndexingAndRun(@NotNull String var1, @NotNull Runnable var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permission";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByDumbAwareness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDumb";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runReadActionInSmartMode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryRunReadActionInSmartMode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "repeatUntilPassesInSmartMode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterByDumbAwareness";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "makeDumbAware";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withAlternativeResolveEnabled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeWithAlternativeResolveEnabled";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runWithAlternativeResolveEnabled";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "allowStartingDumbModeInside";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runReadActionInSmartMode$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runReadActionInSmartMode$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DumbModeListener {
        default public void enteredDumbMode() {
        }

        default public void exitDumbMode() {
        }
    }
}

