/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ConsoleMessage;
import com.intellij.javascript.debugger.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.ConsolePrinter;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.debugger.wip.WipConsoleAPICalled$WhenMappings;
import com.jetbrains.debugger.wip.WipConsoleAPICalledKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextBase;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/debugger/wip/WipConsoleAPICalled;", "Lcom/intellij/javascript/debugger/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/runtime/ConsoleAPICalledEventData;", "(Lorg/jetbrains/wip/protocol/runtime/ConsoleAPICalledEventData;)V", "print", "", "printer", "Lcom/intellij/javascript/debugger/ConsoleMessageBuilder;", "printParameters", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "isNotFirst", "", "intellij.javascript.chrome.connector"})
public final class WipConsoleAPICalled
implements ConsoleMessage {
    private final ConsoleAPICalledEventData message;

    public void print(@NotNull ConsoleMessageBuilder printer) {
        CharSequence charSequence;
        CallFrameValue callFrame;
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        StackTraceValue stackTraceValue = this.message.getStackTrace();
        List<CallFrameValue> stackTrace = stackTraceValue != null ? stackTraceValue.callFrames() : null;
        ConsoleViewContentType contentType = this.message.type() == ConsoleAPICalledEventData.EventType.ERROR ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
        switch (WipConsoleAPICalled$WhenMappings.$EnumSwitchMapping$0[this.message.type().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                if (this.message.type() == ConsoleAPICalledEventData.EventType.END_GROUP) {
                    printer.groupEnd();
                } else {
                    printer.groupStart();
                }
                ConsoleViewContentType consoleViewContentType = contentType;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                this.printParameters(printer, consoleViewContentType, false);
                break;
            }
            case 4: 
            case 5: {
                return;
            }
            case 6: {
                printer.clear();
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)ConsolePrinter.Companion.getCONSOLE_INFO_KEY());
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026Printer.CONSOLE_INFO_KEY)");
                printer.append("Console was cleared", consoleViewContentType);
                break;
            }
            default: {
                if (this.message.type() == ConsoleAPICalledEventData.EventType.ASSERT) {
                    ConsoleViewContentType consoleViewContentType = contentType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                    printer.append("Assertion failed:", consoleViewContentType);
                    this.printParameters(printer, contentType, true);
                    break;
                }
                ConsoleViewContentType consoleViewContentType = contentType;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                this.printParameters(printer, consoleViewContentType, false);
            }
        }
        boolean willPrintStackTrace = this.message.type() == ConsoleAPICalledEventData.EventType.ERROR || this.message.type() == ConsoleAPICalledEventData.EventType.TRACE;
        List<CallFrameValue> list = stackTrace;
        CallFrameValue callFrameValue = callFrame = list != null ? (CallFrameValue)CollectionsKt.firstOrNull(list) : null;
        if (!willPrintStackTrace && callFrame != null && !((charSequence = (CharSequence)callFrame.url()).length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
            ConsoleMessageBuilder.addFileLink$default((ConsoleMessageBuilder)printer, (String)callFrame.url(), (int)callFrame.getLineNumber(), (int)callFrame.getColumnNumber(), (String)callFrame.functionName(), (boolean)true, null, (int)32, null);
        }
        printer.newLine();
        if (willPrintStackTrace) {
            ConsoleViewContentType consoleViewContentType = contentType;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
            WipConsoleAPICalledKt.printStackTrace(printer, consoleViewContentType, stackTrace);
        }
    }

    private final void printParameters(ConsoleMessageBuilder printer, ConsoleViewContentType contentType, boolean isNotFirst) {
        boolean isNotFirst2 = isNotFirst;
        JavaScriptDebugProcess debugProcess = printer.getDebugProcess();
        Vm vm = debugProcess.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        EvaluateContext evaluateContext2 = vm.getEvaluateContext();
        if (evaluateContext2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
        }
        ValueManager valueManager = ((EvaluateContextBase)evaluateContext2).getValueManager();
        if (valueManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
        }
        WipValueManager valueManager2 = (WipValueManager)valueManager;
        for (RemoteObjectValue objectValue : this.message.args()) {
            if (isNotFirst2) {
                printer.append(" ", contentType);
            } else {
                isNotFirst2 = true;
            }
            CharSequence charSequence = objectValue.getObjectId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                Value value = valueManager2.createValue(objectValue);
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                printer.printAndStoreValueToInspect(value, null, contentType);
                continue;
            }
            if (objectValue.value() != null) {
                printer.append(String.valueOf(objectValue.value()), contentType);
                continue;
            }
            if (StringUtil.isEmpty((String)objectValue.getDescription())) continue;
            String string = objectValue.getDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.append(string, contentType);
        }
    }

    public WipConsoleAPICalled(@NotNull ConsoleAPICalledEventData message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
    }
}

