/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.settings;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeProfilingRuntimeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingRuntimeSettingsImpl;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="profiling")
public class NodeProfilingSettings {
    public static final String CPU_TOOL_WINDOW_TITLE = "V8 Profiling";
    public static final NotificationGroup CPU_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"V8 CPU Profiling Messages", (String)"V8 Profiling");
    public static final NotificationGroup HEAP_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"V8 Heap Snapshot Analysis Messages", (String)"V8 Heap");
    public static final String OPEN_TAKEN_SNAPSHOT = "Node.Profiling.Open.Snapshot.After.Save";
    public static final int DEFAULT_PORT = 43517;
    private boolean myProfile;
    private boolean myOpenViewer;
    @Nullable
    private String myLogFolder = ".";
    private boolean myOneLogFile;
    private boolean myAllowRuntimeHeapSnapshot;
    private String myV8ProfilerPackage;
    private int myInnerPort;

    public NodeProfilingSettings() {
        this.myProfile = false;
        this.myOpenViewer = true;
        this.myAllowRuntimeHeapSnapshot = false;
        this.myInnerPort = 43517;
    }

    public NodeProfilingSettings(NodeProfilingSettings settings) {
        this.myProfile = settings.myProfile;
        this.myOpenViewer = settings.myOpenViewer;
        this.myLogFolder = settings.myLogFolder;
        this.myOneLogFile = settings.myOneLogFile;
        this.myAllowRuntimeHeapSnapshot = settings.myAllowRuntimeHeapSnapshot;
        this.myV8ProfilerPackage = settings.myV8ProfilerPackage;
        this.myInnerPort = settings.myInnerPort;
    }

    public void check(@NotNull NodeJsInterpreter interpreter, @Nullable String pathToJsFile) throws RuntimeConfigurationWarning, RuntimeConfigurationError {
        if (interpreter == null) {
            NodeProfilingSettings.$$$reportNull$$$0(0);
        }
        if (this.myProfile) {
            if (StringUtil.isEmptyOrSpaces((String)this.myLogFolder)) {
                throw new RuntimeConfigurationError("V8 profiling: no log folder defined.");
            }
            File file = new File(this.myLogFolder);
            if (!file.isAbsolute() && file.exists() && !file.isDirectory()) {
                throw new RuntimeConfigurationError(NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.error.log.folder.isfile", new Object[0]));
            }
        }
        if (this.myAllowRuntimeHeapSnapshot && StringUtil.isEmptyOrSpaces((String)pathToJsFile)) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.v8profiler.error.no.app.file", new Object[0]));
        }
    }

    public void setProfile(boolean profile) {
        this.myProfile = profile;
    }

    public NodeProfilingRuntimeSettings createRuntimeSettings(@NotNull Project project, @NotNull String workingDirectory, @NotNull NodeFileTransfer fileTransfer) throws IOException, ExecutionException {
        if (project == null) {
            NodeProfilingSettings.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            NodeProfilingSettings.$$$reportNull$$$0(2);
        }
        if (fileTransfer == null) {
            NodeProfilingSettings.$$$reportNull$$$0(3);
        }
        if (!this.myProfile) {
            return null;
        }
        String suffix = NodeProfilingSettings.getDateTimeSuffix();
        File logFolder = this.getLocalLogFolder(project);
        NodeProfilingRuntimeSettingsImpl settings = new NodeProfilingRuntimeSettingsImpl(suffix, logFolder, workingDirectory, fileTransfer);
        settings.setNodeParameters(this.commandLineParameters(settings.getLogFileName()));
        return settings;
    }

    @NotNull
    private File getLocalLogFolder(@NotNull Project project) {
        String nonNullLogFolder;
        if (project == null) {
            NodeProfilingSettings.$$$reportNull$$$0(4);
        }
        if (".".equals(nonNullLogFolder = StringUtil.notNullize((String)this.myLogFolder)) && project.getBasePath() != null) {
            File file = new File(project.getBasePath());
            if (file == null) {
                NodeProfilingSettings.$$$reportNull$$$0(5);
            }
            return file;
        }
        File logFolder = new File(nonNullLogFolder);
        if (!logFolder.isAbsolute()) {
            logFolder = new File(project.getBasePath(), nonNullLogFolder);
        }
        File file = logFolder;
        if (file == null) {
            NodeProfilingSettings.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    private String commandLineParameters(String logFileName) throws ExecutionException {
        StringBuilder sb = new StringBuilder("--prof");
        if (StringUtil.isEmptyOrSpaces((String)this.myLogFolder)) {
            throw new ExecutionException("V8 profiling: no log folder defined.");
        }
        if (this.myOneLogFile) {
            sb.append(" --nologfile_per_isolate");
        }
        sb.append(" --logfile=\"").append(logFileName).append("\"");
        sb.append(" --log-timer-events");
        String string = sb.toString();
        if (string == null) {
            NodeProfilingSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getDateTimeSuffix() {
        Date time1 = new Date();
        String date = DateFormatUtil.formatDate((Date)time1);
        String time = DateFormatUtil.formatTimeWithSeconds((Date)time1);
        String string = NodeProfilingSettings.escapeForFileName(date, '-') + "_" + NodeProfilingSettings.escapeForFileName(time, '-') + "-";
        if (string == null) {
            NodeProfilingSettings.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static String escapeForFileName(String s, char symbol) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                result.append(c);
                continue;
            }
            result.append(symbol);
        }
        return result.toString();
    }

    public void setOpenViewer(boolean openViewer) {
        this.myOpenViewer = openViewer;
    }

    public void setLogFolder(@Nullable String logFolder) {
        this.myLogFolder = logFolder;
    }

    @Deprecated
    public void setInnerPort(int innerPort) {
        this.myInnerPort = innerPort;
    }

    public void setOneLogFile(boolean oneLogFile) {
        this.myOneLogFile = oneLogFile;
    }

    @Deprecated
    @Attribute(value="runtime-heap-snapshots-port")
    public int getInnerPort() {
        return this.myInnerPort;
    }

    @Attribute(value="do-profile")
    public boolean isProfile() {
        return this.myProfile;
    }

    @Attribute(value="open-viewer")
    public boolean isOpenViewer() {
        return this.myOpenViewer;
    }

    @Attribute(value="one-log-file")
    public boolean isOneLogFile() {
        return this.myOneLogFile;
    }

    @Attribute(value="log-folder")
    @Nullable
    public String getLogFolder() {
        return this.myLogFolder;
    }

    public void setAllowRuntimeHeapSnapshot(boolean allowRuntimeHeapSnapshot) {
        this.myAllowRuntimeHeapSnapshot = allowRuntimeHeapSnapshot;
    }

    @Attribute(value="allow-runtime-heap-snapshot")
    public boolean isAllowRuntimeHeapSnapshot() {
        return this.myAllowRuntimeHeapSnapshot;
    }

    public static NodeProfilingSettings readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            NodeProfilingSettings.$$$reportNull$$$0(9);
        }
        Element state = element.getChild("profiling");
        NodeProfilingSettings settings = new NodeProfilingSettings();
        if (state != null) {
            XmlSerializer.deserializeInto((Object)settings, (Element)state);
        }
        return settings;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        Element state;
        if (element == null) {
            NodeProfilingSettings.$$$reportNull$$$0(10);
        }
        if (!JDOMUtil.isEmpty((Element)(state = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters())))) {
            element.addContent(state);
        }
    }

    @Deprecated
    @Attribute(value="v8-profiler-path")
    @Nullable
    public String getV8ProfilerPackage() {
        return this.myV8ProfilerPackage;
    }

    @Deprecated
    public void setV8ProfilerPackage(@Nullable String v8ProfilerPackage) {
        this.myV8ProfilerPackage = StringUtil.nullize((String)v8ProfilerPackage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTransfer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalLogFolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "commandLineParameters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRuntimeSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalLogFolder";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

