/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.ComposerDataService;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerOptionsManager {
    @NonNls
    public static final String DEFAULT_COMMAND_LINE_OPTIONS = "--no-interaction --ansi";
    @NonNls
    public static final String DEFAULT_VERBOSE_COMMAND_LINE_OPTIONS = "--no-interaction --ansi --verbose";

    private ComposerOptionsManager() {
    }

    @NotNull
    public static String getCommandLineOptions(@Nullable Project project, @NotNull Command command, @Nullable VirtualFile composerJsonParent) {
        ComposerDataService dataService;
        String result;
        if (command == null) {
            ComposerOptionsManager.$$$reportNull$$$0(0);
        }
        ComposerOptionsManager.checkNecessaryDataProvided(command, composerJsonParent, project);
        if (command == Command.ADD_DEPENDENCY && (result = (dataService = ComposerDataService.getInstance(project)).getAddDependencyCommandLineOptions()) != null) {
            ComposerOptionsManager.setCommandLineOptions(project, Command.ADD_DEPENDENCY, composerJsonParent, result);
            dataService.setAddDependencyCommandLineOptions(null);
            String string = result;
            if (string == null) {
                ComposerOptionsManager.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = ComposerOptionsManager.getProperties(project).getValue(ComposerOptionsManager.getKey(command, composerJsonParent), command.getDefaultValue());
        if (string == null) {
            ComposerOptionsManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String getKey(@NotNull Command command, @Nullable VirtualFile composerJson) {
        if (command == null) {
            ComposerOptionsManager.$$$reportNull$$$0(3);
        }
        return command.getName() + (composerJson == null ? "" : " " + composerJson.getCanonicalPath());
    }

    private static void checkNecessaryDataProvided(@NotNull Command command, @Nullable VirtualFile composerJson, @Nullable Project project) {
        if (command == null) {
            ComposerOptionsManager.$$$reportNull$$$0(4);
        }
        assert (command.needsConfig() == (composerJson != null));
        assert (command.needsProject() == (project != null));
    }

    public static void setCommandLineOptions(@Nullable Project project, @NotNull Command command, @Nullable VirtualFile composerJsonParent, @Nullable String options) {
        if (command == null) {
            ComposerOptionsManager.$$$reportNull$$$0(5);
        }
        ComposerOptionsManager.checkNecessaryDataProvided(command, composerJsonParent, project);
        String resultToSave = command.getDefaultValue().equals(options) ? null : StringUtil.nullize((String)options);
        PropertiesComponent instance = ComposerOptionsManager.getProperties(project);
        instance.setValue(ComposerOptionsManager.getKey(command, composerJsonParent), resultToSave, command.myDefaultValue);
    }

    @NotNull
    private static PropertiesComponent getProperties(@Nullable Project project) {
        PropertiesComponent propertiesComponent = project == null ? PropertiesComponent.getInstance() : PropertiesComponent.getInstance((Project)project);
        if (propertiesComponent == null) {
            ComposerOptionsManager.$$$reportNull$$$0(6);
        }
        return propertiesComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerOptionsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerOptionsManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommandLineOptions";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkNecessaryDataProvided";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCommandLineOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Command {
        ADD_DEPENDENCY("addDependency", true, true, "--no-progress --no-interaction --ansi"),
        CREATE_PROJECT("install", false, false, "--no-progress --no-interaction --ansi"),
        DUMP_AUTOLOAD("dumpAutoload", true, true, "--no-progress --no-interaction --ansi --verbose"),
        VALIDATE("validate", true, true, "--no-interaction --ansi --verbose --no-check-publish --with-dependencies");

        private final String myName;
        private final boolean myNeedsConfig;
        private final boolean myNeedsProject;
        @NotNull
        private final String myDefaultValue;

        private Command(String name, @NotNull boolean needsConfig, boolean needsProject, String defaultValue) {
            if (defaultValue == null) {
                Command.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myNeedsConfig = needsConfig;
            this.myNeedsProject = needsProject;
            this.myDefaultValue = defaultValue;
        }

        public String getName() {
            return this.myName;
        }

        public boolean needsConfig() {
            return this.myNeedsConfig;
        }

        public boolean needsProject() {
            return this.myNeedsProject;
        }

        @NotNull
        public String getDefaultValue() {
            String string = this.myDefaultValue;
            if (string == null) {
                Command.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerOptionsManager$Command";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerOptionsManager$Command";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

