/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="interpreter")
public class PhpInterpreter
extends ProjectJdkImpl
implements Comparable<PhpInterpreter> {
    private String myId = PhpInterpreter.getNextId();
    private boolean myIsProjectLevel;

    public PhpInterpreter() {
        super("", (SdkTypeId)PhpSdkType.getInstance());
        this.getPhpSdkAdditionalData().setInterpreterId(this.myId);
    }

    @NotNull
    public static String getNextId() {
        String string = UUID.randomUUID().toString();
        if (string == null) {
            PhpInterpreter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Attribute(value="id")
    @NotNull
    public String getId() {
        if (this.myId == null) {
            this.setId(PhpInterpreter.getNextId());
        }
        String string = this.myId;
        if (string == null) {
            PhpInterpreter.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setId(String id) {
        this.myId = id;
        this.getPhpSdkAdditionalData().setInterpreterId(this.myId);
    }

    @Transient
    public boolean isProjectLevel() {
        return this.myIsProjectLevel;
    }

    public void setIsProjectLevel(boolean isProjectLevel) {
        this.myIsProjectLevel = isProjectLevel;
    }

    @Attribute(value="name")
    @NotNull
    public String getName() {
        String string = super.getName();
        if (string == null) {
            PhpInterpreter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Attribute(value="home")
    @Nullable
    public String getHomePath() {
        return super.getHomePath();
    }

    @Transient
    @Nullable
    public String getPathToPhpExecutable() {
        String homePath = this.getHomePath();
        String exe = this.getPhpSdkAdditionalData().getPathToExecutable(homePath);
        if (StringUtil.isNotEmpty((String)exe)) {
            return exe;
        }
        return homePath;
    }

    @Transient
    @Nullable
    public String getDebuggerId() {
        return this.getPhpSdkAdditionalData().getDebuggerId();
    }

    public void setDebuggerId(String debuggerId) {
        this.getPhpSdkAdditionalData().setDebuggerId(debuggerId);
    }

    @Transient
    @Nullable
    public String getDebuggerExtension() {
        return this.getPhpSdkAdditionalData().getDebuggerExtension();
    }

    public void setDebuggerExtension(@Nullable String debuggerExtension) {
        this.getPhpSdkAdditionalData().setDebuggerExtension(debuggerExtension);
    }

    public void setSdkAdditionalData(SdkAdditionalData data) {
        super.setSdkAdditionalData(data);
        this.getPhpSdkAdditionalData().setInterpreterId(this.getId());
    }

    @Transient
    @NotNull
    public List<PhpConfigurationOptionData> getConfigurationOptions() {
        List<PhpConfigurationOptionData> list = this.getPhpSdkAdditionalData().getConfigurationOptions();
        if (list == null) {
            PhpInterpreter.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setConfigurationOptions(@NotNull List<PhpConfigurationOptionData> configurationOptions) {
        if (configurationOptions == null) {
            PhpInterpreter.$$$reportNull$$$0(4);
        }
        this.getPhpSdkAdditionalData().setConfigurationOptions(configurationOptions);
    }

    @Transient
    public String getVersionString() {
        return super.getVersionString();
    }

    @NotNull
    public PhpSdkAdditionalData getPhpSdkAdditionalData() {
        SdkAdditionalData data = super.getSdkAdditionalData();
        if (data instanceof PhpSdkAdditionalData) {
            PhpSdkAdditionalData phpSdkAdditionalData = (PhpSdkAdditionalData)data;
            if (phpSdkAdditionalData == null) {
                PhpInterpreter.$$$reportNull$$$0(5);
            }
            return phpSdkAdditionalData;
        }
        PhpSdkAdditionalData phpData = new PhpSdkAdditionalData();
        this.setSdkAdditionalData(phpData);
        PhpSdkAdditionalData phpSdkAdditionalData = phpData;
        if (phpSdkAdditionalData == null) {
            PhpInterpreter.$$$reportNull$$$0(6);
        }
        return phpSdkAdditionalData;
    }

    public boolean isRemote() {
        return this.getPhpSdkAdditionalData() instanceof RemoteSdkAdditionalData;
    }

    @Transient
    public SdkAdditionalData getSdkAdditionalData() {
        return super.getSdkAdditionalData();
    }

    @NotNull
    public PhpInterpreter clone() {
        PhpInterpreter interpreter = new PhpInterpreter();
        interpreter.setId(this.getId());
        interpreter.setIsProjectLevel(this.isProjectLevel());
        interpreter.setName(this.getName());
        interpreter.setHomePath(this.getHomePath());
        interpreter.setSdkAdditionalData(this.getPhpSdkAdditionalData().copy());
        PhpInterpreter phpInterpreter = interpreter;
        if (phpInterpreter == null) {
            PhpInterpreter.$$$reportNull$$$0(7);
        }
        return phpInterpreter;
    }

    @Override
    public int compareTo(@NotNull PhpInterpreter o) {
        if (o == null) {
            PhpInterpreter.$$$reportNull$$$0(8);
        }
        return this.getName().compareTo(o.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpreter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationOptions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationOptions";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpreter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationOptions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

