/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMethodParametersCountMismatchInspection
extends PhpInspection {
    public boolean DISABLE_FOR__PARAMETER = true;
    public boolean DISABLE_FOR_FUNC_ARG = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMethodParametersCountMismatchInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference classReference;
                ClassReference classReference2 = classReference = expression != null ? expression.getClassReference() : null;
                if (classReference == null) {
                    PhpClass anonymousClass;
                    PhpClass phpClass = anonymousClass = expression != null ? (PhpClass)ObjectUtils.tryCast((Object)expression.getFirstPsiChild(), PhpClass.class) : null;
                    if (anonymousClass != null) {
                        this.inspect(expression.getParameterList(), (Function)anonymousClass.getConstructor(), PhpPsiUtil.getChildOfType((PsiElement)anonymousClass, PhpTokenTypes.kwCLASS));
                    }
                    return;
                }
                PsiElement resolvedElement = classReference.resolve();
                if (resolvedElement instanceof Method) {
                    this.inspect(expression.getParameterList(), (Function)((Method)resolvedElement), this.getNameIdentifier((PhpReference)classReference));
                } else if (resolvedElement instanceof PhpClass) {
                    Method constructor = ((PhpClass)resolvedElement).getConstructor();
                    this.inspect(expression.getParameterList(), (Function)constructor, this.getNameIdentifier((PhpReference)classReference));
                }
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                super.visitPhpFunctionCall(reference);
                this.inspect(reference);
            }

            private void inspect(FunctionReference reference) {
                PsiElement resolvedElement = reference.resolve();
                if (resolvedElement instanceof Function) {
                    this.inspect(reference.getParameterList(), (Function)resolvedElement, this.getNameIdentifier((PhpReference)reference));
                }
            }

            private void inspect(@Nullable ParameterList argumentsList, @Nullable Function function, @Nullable PsiElement target) {
                if (argumentsList != null) {
                    int numberOfParametersInCall = argumentsList.getParameters().length;
                    Parameter[] parameters = function != null ? function.getParameters() : Parameter.EMPTY_ARRAY;
                    int numberOfParametersInDeclaration = parameters.length;
                    if (PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR_FUNC_ARG && function != null && PhpFuncGetArgUsageProvider.containsGetArgFunctionUsage(function)) {
                        return;
                    }
                    if (numberOfParametersInDeclaration > 0) {
                        if (PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR__PARAMETER && parameters[numberOfParametersInDeclaration - 1].getName().equals("_")) {
                            return;
                        }
                        if (parameters[numberOfParametersInDeclaration - 1].isVariadic()) {
                            return;
                        }
                    }
                    if (numberOfParametersInCall > numberOfParametersInDeclaration && target != null) {
                        holder.registerProblem(target, PhpBundle.message("inspection.method.parameters.count.mismatch", numberOfParametersInCall, numberOfParametersInDeclaration), new LocalQuickFix[0]);
                    }
                }
            }

            @Nullable
            private PsiElement getNameIdentifier(@NotNull PhpReference reference) {
                ASTNode nameNode;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (nameNode = reference.getNameNode()) != null ? nameNode.getPsi() : PhpPsiUtil.getChildByCondition((PsiElement)reference, (Condition<? super PsiElement>)Variable.INSTANCEOF);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                super.visitPhpMethodReference(reference);
                this.inspect((FunctionReference)reference);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/PhpMethodParametersCountMismatchInspection$1", "getNameIdentifier"));
            }
        };
        if (phpElementVisitor == null) {
            PhpMethodParametersCountMismatchInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpMethodParametersCountMismatchInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpMethodParametersCountMismatchInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JBCheckBox myDisableForLastParameter;
        private JPanel myPanel;
        private JBCheckBox myDisableForForFunctionContainingFuncNumCall;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myDisableForForFunctionContainingFuncNumCall.setSelected(PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR_FUNC_ARG);
            this.myDisableForForFunctionContainingFuncNumCall.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR_FUNC_ARG = OptionsPanel.this.myDisableForForFunctionContainingFuncNumCall.isSelected();
                }
            });
            this.myDisableForLastParameter.setSelected(PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR__PARAMETER);
            this.myDisableForLastParameter.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR__PARAMETER = OptionsPanel.this.myDisableForLastParameter.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myDisableForLastParameter = jBCheckBox2 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.method.parameters.count.mismatch.option.ignore.underscore"));
            jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myDisableForForFunctionContainingFuncNumCall = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.method.parameters.count.mismatch.option.ignore.func.get.arg"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

