/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddMethodDeclarationQuickFix
extends PhpQuickFixBase {
    public static final PhpAddMethodDeclarationQuickFix INSTANCE = new PhpAddMethodDeclarationQuickFix();

    protected PhpAddMethodDeclarationQuickFix() {
    }

    @NotNull
    public String getName() {
        if ("Add method" == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(0);
        }
        return "Add method";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        MemberReference reference;
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(3);
        }
        if ((reference = (MemberReference)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor.getPsiElement()), MemberReference.class, (boolean)false)) == null) {
            return;
        }
        PhpClass klass = PhpAddMethodDeclarationQuickFix.findClass(project, element, reference);
        if (klass == null) {
            return;
        }
        WriteAction.run(() -> {
            if (project == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(15);
            }
            boolean staticRef = reference.getReferenceType().isStatic();
            PsiElement method = PhpAddMethodDeclarationQuickFix.buildMethod(project, element, PhpAddMethodDeclarationQuickFix.makeParameterList((PhpExpression)reference, (PsiElement)klass, false), element.getText(), staticRef, klass);
            PhpAddFieldDeclarationQuickFix.runTemplate(method, PhpAddFieldDeclarationQuickFix.createTemplate(method), (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template1, boolean brokenOff) {
                    if (template1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!brokenOff) {
                        PhpCodeEditUtil.setupMethodBody(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template1", "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodDeclarationQuickFix$1", "templateFinished"));
                }
            });
        });
    }

    @Nullable
    static PhpClass findClass(@NotNull Project project, @NotNull PsiElement element, @NotNull MemberReference reference) {
        PhpClass klass;
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(6);
        }
        if ((klass = PhpAddMethodDeclarationQuickFix.resolveClassWithErrorReporting(project, reference, false)) == null || !FileModificationService.getInstance().prepareFileForWrite(klass.getContainingFile())) {
            return null;
        }
        String error = PhpAddMethodDeclarationQuickFix.validateClass(project, klass);
        if (StringUtil.isNotEmpty((String)error)) {
            PhpAddMethodDeclarationQuickFix.showErrorMessage(project, error, element);
            return null;
        }
        return klass;
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected static PsiElement buildMethod(Project project, PsiElement element, String parameterList, String functionName, boolean staticRef, @NotNull PhpClass klass) {
        if (klass == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(7);
        }
        StringBuilder template = new StringBuilder();
        if (PhpCodeUtil.belongsTo(element, (PsiElement)klass)) {
            template.append("private");
        } else {
            template.append("public");
        }
        template.append(" ");
        template.append(staticRef ? "static " : "");
        template.append("function ");
        template.append(functionName);
        template.append(parameterList);
        if (klass.isInterface()) {
            template.append(";");
        } else {
            template.append("{\n}");
        }
        Method templateMethod = PhpCodeUtil.createMethodFromTemplate(klass, klass.getProject(), template.toString());
        assert (templateMethod != null);
        PsiElement inserted = PhpCodeEditUtil.insertClassMember(klass, (PsiElement)templateMethod);
        PhpCodeUtil.openRelatedFile(project, inserted);
        return inserted;
    }

    public static String makeParameterList(PhpExpression ref, @Nullable PsiElement context, boolean phpDocMethod) {
        StringBuilder paramBuf = new StringBuilder();
        paramBuf.append('(');
        List paramLists = PhpPsiUtil.getChildren((PsiElement)ref, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        THashSet parametersNames = new THashSet();
        if (!paramLists.isEmpty()) {
            ParameterList paramList = (ParameterList)paramLists.get(paramLists.size() - 1);
            PhpPsiElement scope = context != null ? PhpCodeInsightUtil.findScopeForUseOperator(context) : null;
            Project project = paramList.getProject();
            for (PhpPsiElement child = paramList.getFirstPsiChild(); child != null; child = child.getNextSibling()) {
                ASTNode childNode = child.getNode();
                if (childNode == null) continue;
                IElementType childType = childNode.getElementType();
                if (childType == PhpTokenTypes.opCOMMA) {
                    paramBuf.append(',');
                    continue;
                }
                if (child instanceof PsiWhiteSpace) continue;
                String parameterHintType = PhpAddMethodDeclarationQuickFix.createParameterTypeHint((PsiElement)child, scope, phpDocMethod);
                if (parameterHintType != null) {
                    paramBuf.append(parameterHintType).append(" ");
                }
                String parameterName = PhpAddMethodDeclarationQuickFix.suggestParameterName((Set<String>)parametersNames, (PsiElement)child);
                paramBuf.append('$');
                paramBuf.append(parameterName);
            }
        }
        paramBuf.append(')');
        return paramBuf.toString();
    }

    @Nullable
    public static String createParameterTypeHint(@NotNull PsiElement argument, @Nullable PhpPsiElement scope, boolean phpDocMethod) {
        String typeHint;
        if (argument == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(8);
        }
        Project project = argument.getProject();
        PhpLanguageLevel languageLevel = PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel();
        if (!(argument instanceof PhpTypedElement)) {
            return null;
        }
        PhpType type = PhpAddMethodDeclarationQuickFix.collectSuitableForParameterTypeHint(((PhpTypedElement)argument).getType().global(project), languageLevel);
        boolean nullable = type.getTypes().stream().anyMatch(PhpType::isNull);
        PhpType originalType = type.filterNull();
        if (originalType.size() == 1 && (!nullable || phpDocMethod || languageLevel.hasFeature(PhpLanguageFeature.NULLABLES)) && (typeHint = PhpAddMethodDeclarationQuickFix.getTypeHint(project, scope, originalType.toString())) != null) {
            String nullabilityPrefix = nullable ? (phpDocMethod ? "null|" : "?") : "";
            return nullabilityPrefix + typeHint;
        }
        return null;
    }

    @Nullable
    private static String getTypeHint(Project project, @Nullable PhpPsiElement scope, String typeString) {
        if (PhpType.isPrimitiveType((String)typeString)) {
            return PhpLangUtil.isParameterTypeHint(typeString, project) ? typeString : null;
        }
        return PhpAddMethodDeclarationQuickFix.createQualifiedName(scope, typeString);
    }

    private static String createQualifiedName(@Nullable PhpPsiElement scope, @Nullable String typeString) {
        return scope != null && typeString != null ? PhpCodeInsightUtil.createQualifiedName(scope, PhpLangUtil.toFQN(typeString)) : typeString;
    }

    @NotNull
    private static PhpType collectSuitableForParameterTypeHint(@NotNull PhpType type, @NotNull PhpLanguageLevel languageLevel) {
        String onlyType;
        if (type == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(9);
        }
        if (languageLevel == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(10);
        }
        if (type.getTypes().stream().anyMatch(PhpType::isPluralType)) {
            type = type.add(PhpType.ARRAY);
        }
        PhpType result = type.filterMixed().filterUnknown().filterPlurals();
        if (languageLevel.hasFeature(PhpLanguageFeature.OBJECT_TYPE_HINT) && (onlyType = (String)ContainerUtil.getOnlyItem((Collection)result.getTypes())) != null && PhpType.isAnonymousClass((String)onlyType)) {
            PhpType phpType = new PhpType().add(PhpType.OBJECT.toString());
            if (phpType == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        PhpType phpType = result.filterOut(PhpType::isAnonymousClass);
        if (phpType == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    public static String getParameterDoc(PhpExpression ref) {
        StringBuilder sb = new StringBuilder();
        THashSet parametersNames = new THashSet();
        List paramLists = PhpPsiUtil.getChildren((PsiElement)ref, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        if (!paramLists.isEmpty()) {
            ParameterList paramList = (ParameterList)paramLists.get(paramLists.size() - 1);
            PhpPsiElement child = paramList.getFirstPsiChild();
            while (child != null) {
                ASTNode childNode = child.getNode();
                if (childNode == null) continue;
                IElementType childType = childNode.getElementType();
                if (childType == PhpTokenTypes.opCOMMA) {
                    sb.append('\n');
                } else if (child instanceof PhpExpression) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append("* ").append("@param ");
                    String typeStr = PhpDocUtil.getTypePresentation(ref.getProject(), ((PhpExpression)child).getType(), PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)child));
                    if (!typeStr.isEmpty()) {
                        sb.append(typeStr).append(' ');
                    }
                    String parameterName = PhpAddMethodDeclarationQuickFix.suggestParameterName((Set<String>)parametersNames, (PsiElement)child);
                    sb.append('$').append(parameterName);
                }
                child = child.getNextSibling();
            }
        }
        return sb.toString();
    }

    private static String suggestParameterName(@NotNull Set<String> parametersNames, @NotNull PsiElement child) {
        String name;
        if (parametersNames == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(13);
        }
        if (child == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(14);
        }
        if (parametersNames.contains(name = PhpNameSuggestionUtil.parameterNameByElement(child))) {
            int index = 1;
            while (parametersNames.contains(name + index)) {
                ++index;
            }
            name = name + index;
        }
        parametersNames.add(name);
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodDeclarationQuickFix";
                break;
            }
            case 2: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersNames";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodDeclarationQuickFix";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSuitableForParameterTypeHint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createParameterTypeHint";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectSuitableForParameterTypeHint";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "suggestParameterName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

