/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.functions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.StatementList;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import com.jetbrains.php.lang.parser.parsing.functions.IsReference;
import com.jetbrains.php.lang.parser.parsing.functions.ParameterList;

public class Function {
    private static final ParserPart SOFT_VARIABLE_REFERENCE_PARSER_PART = new SoftVariableReferenceParserPart();

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker function = builder.mark();
        builder.compareAndEat(PhpTokenTypes.kwSTATIC);
        if (!builder.compare(PhpTokenTypes.kwFUNCTION)) {
            function.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.advanceLexer();
        IsReference.parse(builder);
        builder.compareAndEat(PhpTokenTypes.IDENTIFIER);
        if (builder.compareAndEat(PhpTokenTypes.chLPAREN)) {
            ParameterList.parse(builder, false);
            builder.match(PhpTokenTypes.chRPAREN);
        } else {
            builder.match(PhpTokenTypes.chLPAREN);
        }
        PsiBuilder.Marker use = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwUSE)) {
            if (builder.compareAndEat(PhpTokenTypes.chLPAREN)) {
                ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, SOFT_VARIABLE_REFERENCE_PARSER_PART, false);
                builder.match(PhpTokenTypes.chRPAREN);
            } else {
                builder.error(PhpParserErrors.expected(PhpTokenTypes.chLPAREN));
            }
            use.done(PhpElementTypes.USE_LIST);
        } else {
            use.drop();
        }
        Function.parseReturnType(builder);
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            StatementList.parseFast(builder);
        } else {
            builder.match(PhpTokenTypes.chLBRACE);
        }
        function.done(PhpStubElementTypes.FUNCTION);
        return PhpStubElementTypes.FUNCTION;
    }

    public static void parseReturnType(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.opCOLON)) {
            Function.parseReturnTypeElement(builder);
        }
    }

    public static IElementType parseReturnTypeElement(PhpPsiBuilder builder) {
        PsiBuilder.Marker returnType = builder.mark();
        builder.compareAndEat(PhpTokenTypes.opQUEST);
        if (builder.compare(PhpTokenTypes.kwARRAY) || builder.compare(PhpTokenTypes.kwCALLABLE)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done(PhpElementTypes.CLASS_REFERENCE);
            returnType.done(PhpElementTypes.RETURN_TYPE);
            return PhpElementTypes.CLASS_REFERENCE;
        }
        IElementType result = ClassReference.parse(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error("return type expected");
            returnType.drop();
            return result;
        }
        returnType.done(PhpElementTypes.RETURN_TYPE);
        return result;
    }

    private static class SoftVariableReferenceParserPart
    implements ParserPart {
        private SoftVariableReferenceParserPart() {
        }

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            builder.compareAndEat(PhpTokenTypes.opBIT_AND);
            PsiBuilder.Marker var = builder.mark();
            IElementType result = Variable.parse(builder);
            if (result == PhpStubElementTypes.VARIABLE) {
                var.done(result);
                return result;
            }
            var.rollbackTo();
            builder.error(PhpParserErrors.expected("variable"));
            PsiBuilder.Marker identifier = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
                identifier.done(PhpElementTypes.CONSTANT_REF);
                return PhpElementTypes.CONSTANT_REF;
            }
            identifier.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
    }
}

