/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonShortCircuitBooleanExpressionJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("non.short.circuit.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            NonShortCircuitBooleanExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            NonShortCircuitBooleanExpressionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("non.short.circuit.boolean.expression.error.string", new Object[0]);
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new NonShortCircuitBooleanFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonShortCircuitBooleanVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/bugs/NonShortCircuitBooleanExpressionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NonShortCircuitBooleanVisitor
    extends BaseInspectionVisitor {
        private NonShortCircuitBooleanVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                NonShortCircuitBooleanVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            IElementType sign = expression.getOperationSign();
            if (!JSTokenTypes.AND.equals(sign) && !JSTokenTypes.OR.equals(sign)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bugs/NonShortCircuitBooleanExpressionJSInspection$NonShortCircuitBooleanVisitor", "visitJSBinaryExpression"));
        }
    }

    private static class NonShortCircuitBooleanFix
    extends InspectionJSFix {
        private NonShortCircuitBooleanFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("replace.with.short.circuit.expression.fix.string", new Object[0]);
            if (string == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            JSBinaryExpression expression = (JSBinaryExpression)descriptor2.getPsiElement();
            JSExpression lhs = expression.getLOperand();
            JSExpression rhs = expression.getROperand();
            IElementType operationSign = expression.getOperationSign();
            assert (rhs != null);
            String newExpression = lhs.getText() + NonShortCircuitBooleanFix.getShortCircuitOperand(operationSign) + rhs.getText();
            NonShortCircuitBooleanFix.replaceExpression((JSExpression)expression, newExpression);
        }

        private static String getShortCircuitOperand(IElementType tokenType) {
            if (JSTokenTypes.AND.equals(tokenType)) {
                return "&&";
            }
            return "||";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/NonShortCircuitBooleanExpressionJSInspection$NonShortCircuitBooleanFix", "getFamilyName"));
        }
    }
}

