/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;

public class CustomFileTypeQuoteHandler
implements QuoteHandler {
    @Override
    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        IElementType tokenType = iterator.getTokenType();
        if (CustomFileTypeQuoteHandler.isQuotedToken(tokenType)) {
            int start2 = iterator.getStart();
            int end = iterator.getEnd();
            return end - start2 >= 1 && offset == end - 1;
        }
        return false;
    }

    static boolean isQuotedToken(IElementType tokenType) {
        return tokenType == CustomHighlighterTokenType.STRING || tokenType == CustomHighlighterTokenType.SINGLE_QUOTED_STRING || tokenType == CustomHighlighterTokenType.CHARACTER;
    }

    static char getLimitingQuote(IElementType quotedToken) {
        if (quotedToken == CustomHighlighterTokenType.STRING) {
            return '\"';
        }
        if (quotedToken == CustomHighlighterTokenType.SINGLE_QUOTED_STRING || quotedToken == CustomHighlighterTokenType.CHARACTER) {
            return '\'';
        }
        return '\u0000';
    }

    @Override
    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (CustomFileTypeQuoteHandler.isQuotedToken(iterator.getTokenType())) {
            int start2 = iterator.getStart();
            return offset == start2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        try {
            Document doc = editor.getDocument();
            CharSequence chars = doc.getCharsSequence();
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            while (!iterator.atEnd() && iterator.getStart() < lineEnd) {
                if (CustomFileTypeQuoteHandler.isQuotedToken(iterator.getTokenType()) && (iterator.getStart() >= iterator.getEnd() - 1 || chars.charAt(iterator.getEnd() - 1) != '\"' && chars.charAt(iterator.getEnd() - 1) != '\'')) {
                    boolean bl = true;
                    return bl;
                }
                iterator.advance();
            }
        }
        finally {
            while (!iterator.atEnd() && iterator.getStart() != offset) {
                iterator.retreat();
            }
        }
        return false;
    }

    @Override
    public boolean isInsideLiteral(HighlighterIterator iterator) {
        return CustomFileTypeQuoteHandler.isQuotedToken(iterator.getTokenType());
    }
}

