/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class TabbedConfigurable
extends CompositeConfigurable<Configurable>
implements Configurable.NoScroll,
Configurable.NoMargin {
    protected TabbedPaneWrapper myTabbedPane;
    private final Disposable myDisposable = Disposer.newDisposable();

    public JComponent createComponent() {
        this.myTabbedPane = new TabbedPaneWrapper(this.myDisposable);
        this.createConfigurableTabs();
        JComponent component = this.myTabbedPane.getComponent();
        component.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        component.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        return component;
    }

    protected void createConfigurableTabs() {
        for (Configurable configurable : this.getConfigurables()) {
            this.myTabbedPane.addTab(configurable.getDisplayName(), ConfigurableCardPanel.createConfigurableComponent(configurable));
        }
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this.myDisposable);
        this.myTabbedPane = null;
    }
}

