/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class CommonBinaryFilePatchInProgress<T extends FilePatch>
extends AbstractFilePatchInProgress<T> {
    protected CommonBinaryFilePatchInProgress(T patch, Collection<VirtualFile> autoBases, VirtualFile baseDir) {
        super(patch, autoBases, baseDir);
    }

    @Override
    public ContentRevision getNewContentRevision() {
        if (FilePatchStatus.DELETED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myNewContentRevision != null) {
            return this.myNewContentRevision;
        }
        if (this.myPatch.getAfterFileName() != null) {
            FilePath newFilePath = this.getFilePath();
            this.myNewContentRevision = this.createNewContentRevision(newFilePath);
        }
        return this.myNewContentRevision;
    }

    @NotNull
    protected abstract BinaryContentRevision createNewContentRevision(@NotNull FilePath var1);

    @NotNull
    protected abstract Change createChange(Project var1);

    @NotNull
    protected FilePath getFilePath() {
        FilePath filePath = FilePatchStatus.ADDED.equals((Object)this.myStatus) ? VcsUtil.getFilePath((File)this.myIoCurrentBase, (boolean)false) : this.detectNewFilePathForMovedOrModified();
        if (filePath == null) {
            CommonBinaryFilePatchInProgress.$$$reportNull$$$0(0);
        }
        return filePath;
    }

    @Override
    @NotNull
    public DiffRequestProducer getDiffRequestProducers(final Project project, PatchReader baseContents) {
        DiffRequestProducer diffRequestProducer = new DiffRequestProducer(){

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (indicator == null) {
                    1.$$$reportNull$$$0(1);
                }
                DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project, CommonBinaryFilePatchInProgress.this.createChange(project), this.getName(), context, indicator);
                if (diffRequest == null) {
                    1.$$$reportNull$$$0(2);
                }
                return diffRequest;
            }

            @NotNull
            public String getName() {
                File file1 = new File(VfsUtilCore.virtualToIoFile((VirtualFile)CommonBinaryFilePatchInProgress.this.getBase()), CommonBinaryFilePatchInProgress.this.myPatch.getAfterName() == null ? CommonBinaryFilePatchInProgress.this.myPatch.getBeforeName() : CommonBinaryFilePatchInProgress.this.myPatch.getAfterName());
                String string = FileUtil.toSystemDependentName((String)file1.getPath());
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "process";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (diffRequestProducer == null) {
            CommonBinaryFilePatchInProgress.$$$reportNull$$$0(1);
        }
        return diffRequestProducer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffRequestProducers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

