# Generated by Django 3.1.1 on 2020-09-30 10:14

from django.db import migrations

# import the real Collection model (as opposed to the frozen version we'd obtain with
# apps.get_model) so that we can use its fix_tree method. Importing real models in migrations is
# generally avoided since it's liable to generate SQL queries according to the final migrated
# database state which we haven't reached yet - however, in this case it should be safe because
# fix_tree only touches the Treebeard-specific fields via values_list and update, and shouldn't be
# sensitive to schema changes elsewhere.
from wagtail.models import Collection


def apply_collection_ordering(apps, schema_editor):
    Collection.fix_tree(fix_paths=True)


class Migration(migrations.Migration):

    dependencies = [
        ("wagtailcore", "0058_page_alias_of"),
    ]

    operations = [
        migrations.RunPython(apply_collection_ordering, migrations.RunPython.noop),
    ]
