/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ByteSerializer
implements TypeSerializer<Byte> {
    public static final ByteSerializer instance = new ByteSerializer();

    @Override
    public Byte deserialize(ByteBuffer bytes) {
        return bytes == null || bytes.remaining() == 0 ? null : Byte.valueOf(bytes.get(bytes.position()));
    }

    @Override
    public ByteBuffer serialize(Byte value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBuffer.allocate(1).put(0, value);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 1) {
            throw new MarshalException(String.format("Expected 1 byte for a tinyint (%d)", bytes.remaining()));
        }
    }

    @Override
    public String toString(Byte value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Byte> getType() {
        return Byte.class;
    }
}

