/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;

public class RegexBytesRefFilter
implements Predicate<BytesRef> {
    private final Pattern compiled;

    public RegexBytesRefFilter(String regex) {
        this.compiled = Pattern.compile(regex);
    }

    protected boolean includeString(String term) {
        Matcher m = this.compiled.matcher(term);
        return m.matches();
    }

    @Override
    public boolean test(BytesRef term) {
        return this.includeString(term.utf8ToString());
    }
}

