/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.datatype.xsd.Measure;
import com.thaiopensource.datatype.xsd.OrderRelation;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;
import org.relaxng.datatype.helpers.StreamingValidatorImpl;

abstract class DatatypeBase
implements Datatype2 {
    private final int whiteSpace;
    static final int WHITE_SPACE_PRESERVE = 0;
    static final int WHITE_SPACE_REPLACE = 1;
    static final int WHITE_SPACE_COLLAPSE = 2;

    abstract boolean lexicallyAllows(String var1);

    DatatypeBase() {
        this.whiteSpace = 2;
    }

    DatatypeBase(int whiteSpace) {
        this.whiteSpace = whiteSpace;
    }

    int getWhiteSpace() {
        return this.whiteSpace;
    }

    public boolean isValid(String str, ValidationContext vc) {
        return this.lexicallyAllows(str = this.normalizeWhiteSpace(str)) && this.allowsValue(str, vc);
    }

    public void checkValid(String str, ValidationContext vc) throws DatatypeException {
        if (!this.isValid(str, vc)) {
            throw new DatatypeException();
        }
    }

    public Object createValue(String str, ValidationContext vc) {
        if (!this.lexicallyAllows(str = this.normalizeWhiteSpace(str))) {
            return null;
        }
        return this.getValue(str, vc);
    }

    final String normalizeWhiteSpace(String str) {
        switch (this.whiteSpace) {
            case 2: {
                return DatatypeBase.collapseWhiteSpace(str);
            }
            case 1: {
                return DatatypeBase.replaceWhiteSpace(str);
            }
        }
        return str;
    }

    boolean allowsValue(String str, ValidationContext vc) {
        return true;
    }

    abstract Object getValue(String var1, ValidationContext var2);

    OrderRelation getOrderRelation() {
        return null;
    }

    Measure getMeasure() {
        return null;
    }

    private static final String collapseWhiteSpace(String s) {
        int i = DatatypeBase.collapseStart(s);
        if (i < 0) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s.substring(0, i));
        boolean collapsing = i == 0 || s.charAt(i - 1) == ' ';
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (collapsing) break;
                    buf.append(' ');
                    collapsing = true;
                    break;
                }
                default: {
                    collapsing = false;
                    buf.append(c);
                }
            }
            ++i;
        }
        if (buf.length() > 0 && buf.charAt(buf.length() - 1) == ' ') {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private static final int collapseStart(String s) {
        int len = s.length();
        block4: for (int i = 0; i < len; ++i) {
            switch (s.charAt(i)) {
                case ' ': {
                    if (i != 0 && s.charAt(i - 1) != ' ' && i != len - 1) continue block4;
                    return i;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    return i;
                }
            }
        }
        return -1;
    }

    private static final String replaceWhiteSpace(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            switch (s.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    char[] buf = s.toCharArray();
                    buf[i] = 32;
                    ++i;
                    while (i < len) {
                        switch (buf[i]) {
                            case '\t': 
                            case '\n': 
                            case '\r': {
                                buf[i] = 32;
                            }
                        }
                        ++i;
                    }
                    return new String(buf);
                }
            }
        }
        return s;
    }

    DatatypeBase getPrimitive() {
        return this;
    }

    public boolean isContextDependent() {
        return false;
    }

    public boolean alwaysValid() {
        return false;
    }

    public int getIdType() {
        return 0;
    }

    public int valueHashCode(Object value) {
        return value.hashCode();
    }

    public boolean sameValue(Object value1, Object value2) {
        return value1.equals(value2);
    }

    public DatatypeStreamingValidator createStreamingValidator(ValidationContext vc) {
        return new StreamingValidatorImpl(this, vc);
    }
}

