/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VirtualSpaceManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.CGlyph;

public abstract class Glyph
implements Cloneable {
    Long ID;
    Object owner;
    String type;
    public long vx;
    public long vy;
    protected int vz;
    public float size;
    public float orient = 0.0f;
    public boolean visible = true;
    public boolean sensit = true;
    public Color color;
    protected float[] HSV = new float[3];
    public Color fColor = Color.white;
    public Color mouseInsideColor;
    boolean selected = false;
    public static final float DEFAULT_STROKE_WIDTH = 1.0f;
    public BasicStroke stroke = null;
    boolean dashedContour = false;
    float strokeWidth = 1.0f;
    CGlyph cGlyph = null;
    Glyph[] stickedGlyphs;
    public Object stickedTo;
    public static final short ENTERED_GLYPH = 1;
    public static final short EXITED_GLYPH = -1;
    public static final short NO_CURSOR_EVENT = 0;
    public float coef = 1.0f;
    public VirtualSpaceManager vsm;

    public Long getID() {
        return this.ID;
    }

    public void setID(Long ident) {
        this.ID = ident;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object o) {
        this.owner = o;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String toString() {
        return new String(super.toString() + " Glyph ID " + this.ID + " pos (" + this.vx + "," + this.vy + "," + this.vz + ") type=" + this.type);
    }

    public void move(long x, long y) {
        this.vx += x;
        this.vy += y;
        this.propagateMove(x, y);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void moveTo(long x, long y) {
        this.propagateMove(x - this.vx, y - this.vy);
        this.vx = x;
        this.vy = y;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public LongPoint getLocation() {
        return new LongPoint(this.vx, this.vy);
    }

    public abstract float getSize();

    public abstract void sizeTo(float var1);

    public abstract void reSize(float var1);

    public abstract float getOrient();

    public abstract void orientTo(float var1);

    public int getZindex() {
        return this.vz;
    }

    public void setZindex(int z) {
        this.vz = z;
    }

    public void setSensitivity(boolean b) {
        this.sensit = b;
    }

    public boolean isSensitive() {
        return this.sensit;
    }

    public void setVisible(boolean b) {
        if (b != this.visible) {
            this.visible = b;
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isVisibleThroughLens() {
        return this.visible;
    }

    public boolean isFilled() {
        return true;
    }

    public boolean isBorderDrawn() {
        return true;
    }

    public void setMouseInsideHighlightColor(Color c) {
        this.mouseInsideColor = c;
    }

    public void setColor(Color c) {
        this.fColor = this.color = c;
        this.HSV = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        if (this.vsm != null) {
            this.vsm.repaintNow();
        }
    }

    public void setBorderColor(Color c) {
    }

    public void setHSVColor(float h, float s, float v) {
        this.HSV[0] = h;
        if (this.HSV[0] > 1.0f) {
            this.HSV[0] = 1.0f;
        } else if (this.HSV[0] < 0.0f) {
            this.HSV[0] = 0.0f;
        }
        this.HSV[1] = s;
        if (this.HSV[1] > 1.0f) {
            this.HSV[1] = 1.0f;
        } else if (this.HSV[1] < 0.0f) {
            this.HSV[1] = 0.0f;
        }
        this.HSV[2] = v;
        if (this.HSV[2] > 1.0f) {
            this.HSV[2] = 1.0f;
        } else if (this.HSV[2] < 0.0f) {
            this.HSV[2] = 0.0f;
        }
        this.fColor = this.color = Color.getHSBColor(this.HSV[0], this.HSV[1], this.HSV[2]);
        if (this.vsm != null) {
            this.vsm.repaintNow();
        }
    }

    public void addHSVColor(float h, float s, float v) {
        this.HSV[0] = this.HSV[0] + h;
        if (this.HSV[0] > 1.0f) {
            this.HSV[0] = 1.0f;
        } else if (this.HSV[0] < 0.0f) {
            this.HSV[0] = 0.0f;
        }
        this.HSV[1] = this.HSV[1] + s;
        if (this.HSV[1] > 1.0f) {
            this.HSV[1] = 1.0f;
        } else if (this.HSV[1] < 0.0f) {
            this.HSV[1] = 0.0f;
        }
        this.HSV[2] = this.HSV[2] + v;
        if (this.HSV[2] > 1.0f) {
            this.HSV[2] = 1.0f;
        } else if (this.HSV[2] < 0.0f) {
            this.HSV[2] = 0.0f;
        }
        this.fColor = this.color = Color.getHSBColor(this.HSV[0], this.HSV[1], this.HSV[2]);
        if (this.vsm != null) {
            this.vsm.repaintNow();
        }
    }

    public void setHSVbColor(float h, float s, float v) {
    }

    public void addHSVbColor(float h, float s, float v) {
    }

    public float[] getHSVColor() {
        return this.HSV;
    }

    public float[] getHSVbColor() {
        float[] res = new float[]{0.0f, 0.0f, 0.0f};
        return res;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getDefaultColor() {
        return this.fColor;
    }

    public Color getBorderColor() {
        return Color.BLACK;
    }

    public abstract void highlight(boolean var1, Color var2);

    public void select(boolean b) {
        this.selected = b;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDashed(boolean b) {
        float miterlimit;
        this.dashedContour = b;
        this.strokeWidth = this.stroke != null ? this.stroke.getLineWidth() : 1.0f;
        int cap = this.stroke != null ? this.stroke.getEndCap() : 0;
        int join = this.stroke != null ? this.stroke.getLineJoin() : 0;
        float f = miterlimit = this.stroke != null ? this.stroke.getMiterLimit() : 4.0f;
        if (this.dashedContour) {
            float[] dasharray = new float[]{10.0f};
            float dashphase = this.stroke != null ? this.stroke.getDashPhase() : 0.0f;
            this.stroke = new BasicStroke(this.strokeWidth, cap, join, miterlimit, dasharray, dashphase);
        } else {
            this.stroke = new BasicStroke(this.strokeWidth, cap, join, miterlimit);
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void setStrokeWidth(float w) {
        float miterlimit;
        this.strokeWidth = w;
        int cap = this.stroke != null ? this.stroke.getEndCap() : 0;
        int join = this.stroke != null ? this.stroke.getLineJoin() : 0;
        float f = miterlimit = this.stroke != null ? this.stroke.getMiterLimit() : 4.0f;
        if (this.dashedContour) {
            float[] dasharray = new float[]{10.0f};
            float dashphase = this.stroke != null ? this.stroke.getDashPhase() : 0.0f;
            this.stroke = new BasicStroke(this.strokeWidth, cap, join, miterlimit, dasharray, dashphase);
        } else {
            this.stroke = new BasicStroke(this.strokeWidth, cap, join, miterlimit);
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void setStroke(BasicStroke b) {
        if (b != null) {
            this.stroke = b;
            this.strokeWidth = this.stroke.getLineWidth();
        } else {
            this.stroke = null;
            this.strokeWidth = 1.0f;
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public float getStrokeWidth() {
        if (this.stroke != null) {
            return this.stroke.getLineWidth();
        }
        return this.strokeWidth;
    }

    public void setCGlyph(CGlyph c) {
        this.cGlyph = c;
    }

    public CGlyph getCGlyph() {
        return this.cGlyph;
    }

    public void propagateMove(long x, long y) {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                this.stickedGlyphs[i].move(x, y);
            }
        }
    }

    public void stick(Glyph g) {
        if (this.stickedGlyphs == null) {
            this.stickedGlyphs = new Glyph[1];
            this.stickedGlyphs[0] = g;
            g.stickedTo = this;
        } else {
            boolean alreadySticked = false;
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                if (this.stickedGlyphs[i] != g) continue;
                alreadySticked = true;
                break;
            }
            if (!alreadySticked) {
                Glyph[] newStickList = new Glyph[this.stickedGlyphs.length + 1];
                System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, this.stickedGlyphs.length);
                newStickList[this.stickedGlyphs.length] = g;
                this.stickedGlyphs = newStickList;
                g.stickedTo = this;
            } else {
                Glyph glyph = this;
                if (glyph.vsm.debugModeON()) {
                    System.err.println("Warning: trying to stick Glyph " + g + " to Glyph " + this + " while they are already sticked.");
                }
            }
        }
    }

    public void unstick(Glyph g) {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                if (this.stickedGlyphs[i] != g) continue;
                g.stickedTo = null;
                Glyph[] newStickList = new Glyph[this.stickedGlyphs.length - 1];
                System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, i);
                System.arraycopy(this.stickedGlyphs, i + 1, newStickList, i, this.stickedGlyphs.length - i - 1);
                this.stickedGlyphs = newStickList;
                break;
            }
            if (this.stickedGlyphs.length == 0) {
                this.stickedGlyphs = null;
            }
            g.stickedTo = null;
        }
    }

    public void unstickAllGlyphs() {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                this.stickedGlyphs[i].stickedTo = null;
                this.stickedGlyphs[i] = null;
            }
            this.stickedGlyphs = null;
        }
    }

    public Glyph[] getStickedGlyphArray() {
        return this.stickedGlyphs;
    }

    public abstract void project(Camera var1, Dimension var2);

    public abstract void projectForLens(Camera var1, int var2, int var3, float var4, long var5, long var7);

    public abstract void draw(Graphics2D var1, int var2, int var3, int var4, Stroke var5, AffineTransform var6, int var7, int var8);

    public abstract void drawForLens(Graphics2D var1, int var2, int var3, int var4, Stroke var5, AffineTransform var6, int var7, int var8);

    public abstract void initCams(int var1);

    public abstract void addCamera(int var1);

    public abstract void removeCamera(int var1);

    public abstract boolean coordInside(int var1, int var2, int var3, long var4, long var6);

    public abstract void resetMouseIn();

    public abstract void resetMouseIn(int var1);

    public abstract short mouseInOut(int var1, int var2, int var3, long var4, long var6);

    public boolean visibleInRegion(long wb, long nb, long eb, long sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return (float)this.vx - this.size <= (float)eb && (float)this.vx + this.size >= (float)wb && (float)this.vy - this.size <= (float)nb && (float)this.vy + this.size >= (float)sb;
    }

    public boolean containedInRegion(long wb, long nb, long eb, long sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return (float)this.vx + this.size <= (float)eb && (float)this.vx - this.size >= (float)wb && (float)this.vy + this.size <= (float)nb && (float)this.vy - this.size >= (float)sb;
        }
        return false;
    }

    public abstract boolean fillsView(long var1, long var3, int var5);

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return false;
    }

    public long[] getBounds() {
        long[] res = new long[]{this.vx - (long)Math.round(this.size), this.vy + (long)Math.round(this.size), this.vx + (long)Math.round(this.size), this.vy - (long)Math.round(this.size)};
        return res;
    }

    public void setVSM(VirtualSpaceManager v) {
        this.vsm = v;
    }

    public abstract Object clone();
}

