/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveEntry;

class ClientVector
extends ArrayDeque<KeepAliveEntry> {
    private static final long serialVersionUID = -8680532108106489459L;
    int nap;

    ClientVector(int n) {
        this.nap = n;
    }

    synchronized HttpClient get() {
        if (this.isEmpty()) {
            return null;
        }
        HttpClient httpClient = null;
        long l = System.currentTimeMillis();
        do {
            KeepAliveEntry keepAliveEntry = (KeepAliveEntry)this.pop();
            if (l - keepAliveEntry.idleStartTime > (long)this.nap) {
                keepAliveEntry.hc.closeServer();
                continue;
            }
            httpClient = keepAliveEntry.hc;
        } while (httpClient == null && !this.isEmpty());
        return httpClient;
    }

    synchronized void put(HttpClient httpClient) {
        if (this.size() >= KeepAliveCache.getMaxConnections()) {
            httpClient.closeServer();
        } else {
            this.push(new KeepAliveEntry(httpClient, System.currentTimeMillis()));
        }
    }

    synchronized boolean remove(HttpClient httpClient) {
        for (KeepAliveEntry keepAliveEntry : this) {
            if (keepAliveEntry.hc != httpClient) continue;
            return super.remove(keepAliveEntry);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

