<?php
/**
 * Unicode Normalizer
 *
 * PHP version 5
 *
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * + Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * + Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 * + The names of its contributors may not be used to endorse or
 * promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @category  Internationalization
 * @package   I18N_UnicodeNormalizer
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2007 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   SVN: $Id: CompilerTest.php 38 2007-07-23 11:42:30Z mcorne $
 * @link      http://pear.php.net/package/I18N_UnicodeNormalizer
 */
// Call tests_UnicodeNormalizer_CompilerTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "tests_UnicodeNormalizer_CompilerTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'I18N/UnicodeNormalizer/Compiler.php';

/**
 * Test class for I18N_UnicodeNormalizer_Compiler.
 * Generated by PHPUnit_Util_Skeleton on 2007-05-17 at 15:36:56.
 *
 * @category  Internationalization
 * @package   I18N_UnicodeNormalizer
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2007 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   Release: @package_version@
 * @link      http://pear.php.net/package/I18N_UnicodeNormalizer
 */
class tests_UnicodeNormalizer_CompilerTest extends PHPUnit_Framework_TestCase
{
    /**
     * The I18N_UnicodeNormalizer_Compiler class instance
     *
     * @var    object 
     * @access private
     */
    private $compile;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main()
    {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite = new PHPUnit_Framework_TestSuite("tests_UnicodeNormalizer_CompilerTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp()
    {
        $dir = dirname(dirname(__FILE__)) . '/data';
        $this->compile = new I18N_UnicodeNormalizer_Compiler($dir, 'ucn', true, true);
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown()
    {
    }

    /**
     * Tests implode()
     *
     * @access public
     */
    public function testImplode()
    {
        $test = array(// /
            "\u3036" => array("\u3012"),
            "\u3255" => array("\u0032", "\u0035"),
            "\uFD55" => array("\u062A", "\u0645", "\u062C"),
            );
        $expected = array(// /
            "\u3036" => "\u3012",
            "\u3255" => "\u0032\u0035",
            "\uFD55" => "\u062A\u0645\u062C",
            );
        $this->assertEquals($expected, $this->compile->implode($test));
    }

    /**
     * Tests convertCode()
     *
     * @access public
     */
    public function testConvertCode()
    {
        // format: <Unicode code point>, <expected Unicode character in UCN format>,
        $test = array(// /
            array(0x3012, "\u3012"),
            array("x0032", "\u0032"),
            array("062A0645", "\U062A0645"),
            );
        foreach($test as $idx => $values) {
            list($unicode, $expected) = $values;
            $this->assertEquals($expected, $this->compile->convertCode($unicode), 'Test #' . $idx);
        }
    }

    /**
     * Tests splitCodes()
     *
     * @access public
     */
    public function testSplitCodes()
    {
        // format: <Unicode code points>, <expected Unicode characters in UCN format>,
        $test = array(// /
            array("3012", array("\u3012")),
            array("x0032 35", array("\u0032", "\u0035")),
            array("062A 0645 062C", array("\u062A", "\u0645", "\u062C")),
            );
        foreach($test as $idx => $values) {
            list($unicode, $expected) = $values;
            $this->assertEquals($expected, $this->compile->splitCodes($unicode), 'Test #' . $idx);
        }
    }

    /**
     * Tests compileAll()
     */
    public function testCompileAll()
    {
        // compiles the Unicode data test files
        $this->compile->compileAll();
        // gets the compiled file path names
        $compiled = $this->compile->getFileNames();
        // sets the reference (compiled) file path names
        $reference = str_replace('compiled', 'reference', $compiled);

        foreach(array_keys($compiled) as $idx) {
            if (file_exists($reference[$idx])) {
                // the reference file exists
                $this->assertEquals(include($reference[$idx]), include($compiled[$idx]),
                    'Test file: ' . basename($compiled[$idx]));
            } else {
                // one or more reference files are missing, displays a warning
                $fileName = basename($reference[$idx]);
                $msg[] = 'The file: ' . basename($reference[$idx]);
                $msg[] = 'is missing in: ' . dirname($reference[$idx]);
                $msg[] = 'Validate this file in: ' . dirname($compiled[$idx]);
                $msg[] = 'against its corresponding file in: ".../data."';
                $msg[] = 'Then copy this file into: ' . dirname($reference[$idx]);
                $msg[] = 'Rerun the test."';

                $this->fail(implode("\n", $msg));
            }
        }
    }
}
// Call tests_UnicodeNormalizer_CompilerTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "tests_UnicodeNormalizer_CompilerTest::main") {
    tests_UnicodeNormalizer_CompilerTest::main();
}

?>
