/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.sablecc.sablecc.GenAlts;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.Grammar1;
import org.sablecc.sablecc.node.Prod1;
import org.sablecc.sablecc.node.Start1;

public class GenUtils
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    private String mainProduction;

    public GenUtils(ResolveIds resolveIds) {
        this.ids = resolveIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("utils.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open utils.txt.");
        }
        this.pkgDir = new File(resolveIds.pkgDir, "node");
        String string = this.pkgName = resolveIds.pkgName.equals("") ? "node" : String.valueOf(resolveIds.pkgName) + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    public void caseGrammar1(Grammar1 grammar1) {
        grammar1.getNode6().apply(this);
    }

    public void caseProd1(Prod1 prod1) {
        if (this.mainProduction == null) {
            this.mainProduction = (String)this.ids.names.get(prod1);
        }
    }

    public void create(String string) {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, String.valueOf(string) + ".java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, String.valueOf(string) + ".java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, string, new String[]{this.pkgName});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, String.valueOf(string) + ".java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void createEOF() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "EOF.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "EOF.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "EOF", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : String.valueOf(this.ids.pkgName) + ".analysis"});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "EOF.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void createNode() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Node.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Node.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "Node", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : String.valueOf(this.ids.pkgName) + ".analysis"});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Node.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void createNodeCast() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "NodeCast.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "NodeCast.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "NodeCast", new String[]{this.pkgName});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "NodeCast.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void createStart() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Start.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Start.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "Start", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : String.valueOf(this.ids.pkgName) + ".analysis", this.mainProduction, GenAlts.nodeName(this.mainProduction)});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Start.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void createToken() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Token.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Token.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "Token", new String[]{this.pkgName});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Token.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void outStart1(Start1 start1) {
        if (this.mainProduction != null) {
            this.createStart();
        }
        this.createEOF();
        this.createNode();
        this.createNodeCast();
        this.createToken();
        this.create("Switch");
        this.create("Switchable");
        this.create("TypedLinkedList");
        this.create("Cast");
        this.create("NoCast");
    }
}

