/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.shared;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.igoweb.igoweb.Config;

public class Locales {
    public static final String DEFAULT = Config.get("masterLocale");
    private static final HashMap<String, String> localeIdToCanon = new HashMap();
    private static HashMap<String, Locale> localeIdToLocale = new HashMap();

    private Locales() {
    }

    public static String getCanonLocaleId(String localeId) {
        return localeIdToCanon.get(localeId);
    }

    public static boolean isCanonId(String localeId) {
        return localeId != null && localeId.equals(localeIdToCanon.get(localeId));
    }

    public static Locale makeLocale(String id) {
        Locale l = localeIdToLocale.get(id);
        if (l != null) {
            return l;
        }
        String[] parts = id.split("_");
        return parts.length == 1 ? new Locale(parts[0]) : new Locale(parts[0], parts[1]);
    }

    public static Set<String> getCanonIds() {
        return new HashSet<String>(localeIdToCanon.values());
    }

    static {
        for (String group : Config.get("localeList").split(" +")) {
            if (group.charAt(0) == '!') continue;
            String[] langs = group.split("[/-]+");
            String primary = langs[0];
            localeIdToLocale.put(primary, Locales.makeLocale(primary));
            for (String lang : langs) {
                localeIdToCanon.put(lang, primary);
                localeIdToCanon.put(lang.toLowerCase(Locale.US), primary);
                localeIdToCanon.put(lang.toUpperCase(Locale.US), primary);
            }
        }
    }
}

