/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import com.google.protobuf.ByteString;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.campagnelab.goby.parsers.ReaderFastaParser;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;
import org.campagnelab.goby.reads.Reads;
import org.campagnelab.goby.reads.ReadsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomAccessSequenceCache
implements RandomAccessSequenceInterface {
    private ObjectArrayList<LongArrayBitVector> referenceIgnoreLists;
    private Object2IntMap<String> referenceNameMap;
    private Int2ObjectMap<String> indexToNameMap;
    private ObjectArrayList<byte[]> compressedData;
    private IntList sizes;
    private static final Logger LOG = LoggerFactory.getLogger(RandomAccessSequenceCache.class);
    private String basename;
    private int maxRefIndex;
    private int minRefIndex;
    final LongArrayBitVector bits = LongArrayBitVector.getInstance();

    public RandomAccessSequenceCache() {
        this.compressedData = new ObjectArrayList();
        this.referenceIgnoreLists = new ObjectArrayList();
        this.referenceNameMap = new Object2IntOpenHashMap();
        this.referenceNameMap.defaultReturnValue(-1);
        this.indexToNameMap = new Int2ObjectArrayMap();
        this.sizes = new IntArrayList();
    }

    public void loadFasta(Reader reader) throws IOException {
        ReaderFastaParser parser = new ReaderFastaParser(reader);
        MutableString description = new MutableString();
        int refIndex = 0;
        this.minRefIndex = Integer.MAX_VALUE;
        this.maxRefIndex = Integer.MIN_VALUE;
        while (parser.hasNextSequence()) {
            int c;
            int position = 0;
            parser.nextSequence(description);
            String referenceName = description.toString().split(" ")[0];
            int initialCapacity = 40000000;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(40000000);
            OutputBitStream compressed = new OutputBitStream((OutputStream)byteArrayOutputStream);
            LongArrayBitVector referenceIgnoreList = LongArrayBitVector.ofLength((long)0L);
            Reader baseReader = parser.getBaseReader();
            while ((c = baseReader.read()) != -1) {
                this.encode(c, compressed, (BitVector)referenceIgnoreList);
                ++position;
            }
            baseReader.close();
            compressed.flush();
            compressed.close();
            this.referenceIgnoreLists.add((Object)referenceIgnoreList);
            this.referenceNameMap.put((Object)referenceName, refIndex);
            this.indexToNameMap.put(refIndex, (Object)referenceName);
            this.updateSliceIndices(refIndex);
            ++refIndex;
            byte[] bytes = byteArrayOutputStream.toByteArray();
            LOG.debug("size of last sequence " + description + ", in bytes: " + bytes.length);
            this.compressedData.add((Object)bytes);
            this.sizes.add(position);
        }
    }

    private void updateSliceIndices(int refIndex) {
        this.minRefIndex = Math.min(refIndex, this.minRefIndex);
        this.maxRefIndex = Math.max(refIndex, this.maxRefIndex);
    }

    public void loadCompact(InputStream compactInput) throws IOException {
        ReadsReader parser = new ReadsReader(compactInput);
        MutableString description = new MutableString();
        int refIndex = 0;
        this.minRefIndex = Integer.MAX_VALUE;
        this.maxRefIndex = Integer.MIN_VALUE;
        while (parser.hasNext()) {
            Reads.ReadEntry entry = parser.next();
            String referenceName = entry.getReadIdentifier();
            int initialCapacity = 40000000;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(40000000);
            OutputBitStream compressed = new OutputBitStream((OutputStream)byteArrayOutputStream);
            LongArrayBitVector referenceIgnoreList = LongArrayBitVector.ofLength((long)0L);
            ByteString seq = entry.getSequence();
            for (int position = 0; position < seq.size(); ++position) {
                char c = (char)seq.byteAt(position);
                this.encode(c, compressed, (BitVector)referenceIgnoreList);
            }
            compressed.flush();
            compressed.close();
            this.referenceIgnoreLists.add((Object)referenceIgnoreList);
            this.referenceNameMap.put((Object)referenceName, refIndex);
            this.indexToNameMap.put(refIndex, (Object)referenceName);
            this.updateSliceIndices(refIndex);
            ++refIndex;
            byte[] bytes = byteArrayOutputStream.toByteArray();
            LOG.debug("size of last sequence " + description + ", in bytes: " + bytes.length);
            this.compressedData.add((Object)bytes);
            this.sizes.add(seq.size());
        }
    }

    public void save(String basename) throws IOException {
        BinIO.storeObject((Object)this.sizes, (CharSequence)(basename + ".sizes"));
        BinIO.storeObject(this.compressedData, (CharSequence)(basename + ".bases"));
        BinIO.storeObject(this.referenceIgnoreLists, (CharSequence)(basename + ".ignore"));
        BinIO.storeObject(this.referenceNameMap, (CharSequence)(basename + ".names"));
    }

    public void load(String basename) throws IOException, ClassNotFoundException {
        this.sizes = (IntList)BinIO.loadObject((CharSequence)(basename + ".sizes"));
        this.compressedData = (ObjectArrayList)BinIO.loadObject((CharSequence)(basename + ".bases"));
        this.referenceIgnoreLists = (ObjectArrayList)BinIO.loadObject((CharSequence)(basename + ".ignore"));
        this.referenceNameMap = (Object2IntMap)BinIO.loadObject((CharSequence)(basename + ".names"));
        for (String name : this.referenceNameMap.keySet()) {
            this.indexToNameMap.put(this.referenceNameMap.get((Object)name), (Object)name);
            this.updateSliceIndices((Integer)this.referenceNameMap.get((Object)name));
        }
    }

    public void load(String basename, String minRefId, String maxRefId) throws IOException, ClassNotFoundException {
        this.load(basename);
    }

    public boolean canLoad(String basename) {
        String[] extensions;
        for (String extension : extensions = new String[]{".sizes", ".bases", ".ignore", ".names"}) {
            File part = new File(basename + extension);
            if (part.exists()) continue;
            return false;
        }
        return true;
    }

    public final char get(String referenceName, int position) {
        int referenceIndex = this.getReferenceIndex(referenceName);
        return this.get(referenceIndex, position);
    }

    public final int getRange(String referenceName, int position, int length) {
        int referenceIndex = this.getReferenceIndex(referenceName);
        return this.getRange(referenceIndex, position, length, referenceName);
    }

    @Override
    public void getRange(int referenceIndex, int position, int length, MutableString bases) {
        bases.setLength(0);
        for (int i = position; i < position + length; ++i) {
            bases.append(this.get(referenceIndex, i));
        }
    }

    public int getRange(int referenceIndex, int position, int length, String referenceName) {
        assert (referenceIndex >= this.minRefIndex && referenceIndex <= this.maxRefIndex) : String.format("referenceindex %d obtained from referenceName " + referenceName + " , is out of genome slice [%d-%d].", referenceIndex, referenceName, this.minRefIndex, this.maxRefIndex);
        int maxSize = this.sizes.getInt(referenceIndex);
        assert (position + length < maxSize) : "position must be less than size of the reference sequence (" + maxSize + ")";
        assert (length < 15) : "length must be less than 15";
        this.bits.clear();
        byte[] bytes = (byte[])this.compressedData.get(referenceIndex);
        LongArrayBitVector ignoreList = (LongArrayBitVector)this.referenceIgnoreLists.get(referenceIndex);
        block6: for (int i = 0; i < length; ++i) {
            int offset = (position + i) * 2;
            byte b = bytes[offset / 8];
            if (ignoreList.get((long)position).booleanValue()) {
                return -1;
            }
            int c = b >> 6 - offset % 8 & 3;
            switch (c) {
                case 3: {
                    this.bits.add(0);
                    this.bits.add(0);
                    continue block6;
                }
                case 1: {
                    this.bits.add(1);
                    this.bits.add(0);
                    continue block6;
                }
                case 2: {
                    this.bits.add(0);
                    this.bits.add(1);
                    continue block6;
                }
                case 0: {
                    this.bits.add(1);
                    this.bits.add(1);
                    continue block6;
                }
                default: {
                    throw new InternalError("Should never happen");
                }
            }
        }
        return (int)this.bits.bits()[0];
    }

    @Override
    public final int getReferenceIndex(String referenceName) {
        return this.referenceNameMap.getInt((Object)referenceName);
    }

    @Override
    public final String getReferenceName(int index) {
        return (String)this.indexToNameMap.get(index);
    }

    @Override
    public int size() {
        return this.referenceNameMap.size();
    }

    @Override
    public final char get(int referenceIndex, int position) {
        assert (referenceIndex >= this.minRefIndex && referenceIndex <= this.maxRefIndex) : String.format("referenceindex %d out of genome slice [%d-%d].", referenceIndex, this.minRefIndex, this.maxRefIndex);
        int maxSize = this.sizes.getInt(referenceIndex);
        LongArrayBitVector ignoreList = (LongArrayBitVector)this.referenceIgnoreLists.get(referenceIndex);
        if (position >= maxSize) {
            return 'N';
        }
        assert (position < maxSize) : "position must be less than size of the reference sequence (" + maxSize + ") chr=" + this.getReferenceName(referenceIndex);
        if (position >= ignoreList.size() || !ignoreList.get((long)position).booleanValue()) {
            return this.decode((byte[])this.compressedData.get(referenceIndex), position, maxSize);
        }
        return 'N';
    }

    @Override
    public int getLength(int targetIndex) {
        return this.sizes.getInt(targetIndex);
    }

    private char decode(byte[] bytes, int position, int maxSize) {
        assert (position < maxSize) : "position must be less than size of the reference sequence (" + maxSize + ")";
        int offset = position * 2;
        int index = offset / 8;
        if (index >= bytes.length) {
            return 'N';
        }
        byte b = bytes[index];
        int c = b >> 6 - offset % 8 & 3;
        switch (c) {
            case 3: {
                return 'A';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'T';
            }
            case 0: {
                return 'G';
            }
        }
        throw new InternalError("This should never happen");
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        RandomAccessSequenceCache cache = new RandomAccessSequenceCache();
        String basename = "compressed-genome-cache";
        if (cache.canLoad("compressed-genome-cache")) {
            cache.load("compressed-genome-cache");
        } else {
            System.out.println("Loading");
            cache.loadFasta(new InputStreamReader(new GZIPInputStream(new FileInputStream("/Users/fac2003/IdeaProjects/data/Homo_sapiens.NCBI36.54.dna.toplevel.fa.gz"))));
        }
        System.out.println("Done loading.");
        if (!cache.canLoad("compressed-genome-cache")) {
            cache.save("compressed-genome-cache");
            System.out.println("Sequence cache written to disk with basename compressed-genome-cache");
        }
        System.out.println("Searching..");
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 10000; ++j) {
                int referenceIndex = random.nextInt(cache.numberOfSequences() - 1);
                int position = random.nextInt(cache.size(referenceIndex) - 1);
                cache.get(referenceIndex, position);
            }
        }
        System.out.println("Done searching");
    }

    private int size(int referenceIndex) {
        LongArrayBitVector ignoreList = (LongArrayBitVector)this.referenceIgnoreLists.get(referenceIndex);
        return Math.min(ignoreList.size(), (Integer)this.sizes.get(referenceIndex));
    }

    public int numberOfSequences() {
        return this.sizes.size();
    }

    private void encode(int base, OutputBitStream compressed, BitVector ignoreList) throws IOException {
        switch (Character.toUpperCase(base)) {
            case 65: {
                compressed.writeBit(1);
                compressed.writeBit(1);
                ignoreList.add(false);
                break;
            }
            case 67: {
                compressed.writeBit(0);
                compressed.writeBit(1);
                ignoreList.add(false);
                break;
            }
            case 84: {
                compressed.writeBit(1);
                compressed.writeBit(0);
                ignoreList.add(false);
                break;
            }
            case 71: {
                compressed.writeBit(0);
                compressed.writeBit(0);
                ignoreList.add(false);
                break;
            }
            default: {
                compressed.writeBit(0);
                compressed.writeBit(0);
                ignoreList.add(true);
            }
        }
    }

    public int getSequenceSize(int referenceIndex) {
        return this.size(referenceIndex);
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }
}

