/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IvyRepResolver
extends URLResolver {
    public static final String DEFAULT_IVYPATTERN = "[organisation]/[module]/ivy-[revision].xml";
    public static final String DEFAULT_IVYROOT = "http://ivyrep.jayasoft.org/";
    private String ivyroot = null;
    private String ivypattern = null;
    private String artroot = null;
    private String artpattern = null;

    private void ensureArtifactConfigured(ResolverSettings resolverSettings) {
        if (resolverSettings != null && (this.artroot == null || this.artpattern == null)) {
            String string;
            if (this.artroot == null) {
                string = resolverSettings.getVariable("ivy.ivyrep.default.artifact.root");
                if (string != null) {
                    this.artroot = string;
                } else {
                    resolverSettings.configureRepositories(true);
                    this.artroot = resolverSettings.getVariable("ivy.ivyrep.default.artifact.root");
                }
            }
            if (this.artpattern == null) {
                string = resolverSettings.getVariable("ivy.ivyrep.default.artifact.pattern");
                if (string != null) {
                    this.artpattern = string;
                } else {
                    resolverSettings.configureRepositories(false);
                    this.artpattern = resolverSettings.getVariable("ivy.ivyrep.default.artifact.pattern");
                }
            }
            this.updateWholeArtPattern();
        }
    }

    private void ensureIvyConfigured(ResolverSettings resolverSettings) {
        if (resolverSettings != null && (this.ivyroot == null || this.ivypattern == null)) {
            String string;
            if (this.ivyroot == null) {
                string = resolverSettings.getVariable("ivy.ivyrep.default.ivy.root");
                if (string != null) {
                    this.ivyroot = string;
                } else {
                    throw new IllegalStateException("ivyroot is mandatory on IvyRepResolver. Make sure to set it in your settings, before setting ivypattern if you wish to set ivypattern too.");
                }
            }
            if (this.ivypattern == null) {
                string = resolverSettings.getVariable("ivy.ivyrep.default.ivy.pattern");
                if (string != null) {
                    this.ivypattern = string;
                } else {
                    resolverSettings.configureRepositories(false);
                    this.ivypattern = resolverSettings.getVariable("ivy.ivyrep.default.ivy.pattern");
                }
            }
            this.updateWholeIvyPattern();
        }
    }

    private String getWholeIvyPattern() {
        if (this.ivyroot == null || this.ivypattern == null) {
            return null;
        }
        return this.ivyroot + this.ivypattern;
    }

    private String getWholeArtPattern() {
        return this.artroot + this.artpattern;
    }

    public String getIvypattern() {
        return this.ivypattern;
    }

    public void setIvypattern(String string) {
        if (string == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this.ivypattern = string;
        this.ensureIvyConfigured(this.getSettings());
        this.updateWholeIvyPattern();
    }

    public String getIvyroot() {
        return this.ivyroot;
    }

    public void setIvyroot(String string) {
        if (string == null) {
            throw new NullPointerException("root must not be null");
        }
        this.ivyroot = !string.endsWith("/") ? string + "/" : string;
        this.ensureIvyConfigured(this.getSettings());
        this.updateWholeIvyPattern();
    }

    @Override
    public void setM2compatible(boolean bl) {
        if (bl) {
            throw new IllegalArgumentException("ivyrep does not support maven2 compatibility. Please use ibiblio resolver instead, or even url or filesystem resolvers for more specific needs.");
        }
    }

    private void updateWholeIvyPattern() {
        this.setIvyPatterns(Collections.singletonList(this.getWholeIvyPattern()));
    }

    private void updateWholeArtPattern() {
        this.setArtifactPatterns(Collections.singletonList(this.getWholeArtPattern()));
    }

    public void publish(Artifact artifact, File file) {
        throw new UnsupportedOperationException("publish not supported by IBiblioResolver");
    }

    public String getArtroot() {
        return this.artroot;
    }

    public String getArtpattern() {
        return this.artpattern;
    }

    public void setArtpattern(String string) {
        if (string == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this.artpattern = string;
        this.ensureArtifactConfigured(this.getSettings());
        this.updateWholeArtPattern();
    }

    public void setArtroot(String string) {
        if (string == null) {
            throw new NullPointerException("root must not be null");
        }
        this.artroot = !string.endsWith("/") ? string + "/" : string;
        this.ensureArtifactConfigured(this.getSettings());
        this.updateWholeArtPattern();
    }

    @Override
    public OrganisationEntry[] listOrganisations() {
        this.ensureIvyConfigured(this.getSettings());
        try {
            URL uRL = new URL(this.ivyroot + "content.xml");
            final ArrayList arrayList = new ArrayList();
            XMLHelper.parse(uRL, null, new DefaultHandler(){

                @Override
                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    String string4;
                    if ("organisation".equals(string3) && (string4 = attributes.getValue("name")) != null) {
                        arrayList.add(new OrganisationEntry(IvyRepResolver.this, string4));
                    }
                }
            });
            return arrayList.toArray(new OrganisationEntry[arrayList.size()]);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (Exception exception) {
            Message.warn("unable to parse content.xml file on ivyrep: " + exception.getMessage());
        }
        return super.listOrganisations();
    }

    @Override
    public ModuleEntry[] listModules(OrganisationEntry organisationEntry) {
        this.ensureIvyConfigured(this.getSettings());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("organisation", organisationEntry.getOrganisation());
        Collection collection = this.findIvyNames(hashMap, "module");
        ModuleEntry[] moduleEntryArray = new ModuleEntry[collection.size()];
        int n = 0;
        for (String string : collection) {
            moduleEntryArray[n] = new ModuleEntry(organisationEntry, string);
            ++n;
        }
        return moduleEntryArray;
    }

    @Override
    public RevisionEntry[] listRevisions(ModuleEntry moduleEntry) {
        this.ensureIvyConfigured(this.getSettings());
        this.ensureArtifactConfigured(this.getSettings());
        return super.listRevisions(moduleEntry);
    }

    @Override
    public String getTypeName() {
        return "ivyrep";
    }

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        this.ensureIvyConfigured(resolveData.getSettings());
        return super.getDependency(dependencyDescriptor, resolveData);
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        this.ensureArtifactConfigured(this.getSettings());
        return super.findArtifactRef(artifact, date);
    }

    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        this.ensureArtifactConfigured(this.getSettings());
        return super.download(artifactArray, downloadOptions);
    }

    @Override
    public boolean exists(Artifact artifact) {
        this.ensureArtifactConfigured(this.getSettings());
        return super.exists(artifact);
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        this.ensureArtifactConfigured(this.getSettings());
        return super.locate(artifact);
    }

    @Override
    public List getIvyPatterns() {
        this.ensureIvyConfigured(this.getSettings());
        return super.getIvyPatterns();
    }

    @Override
    public List getArtifactPatterns() {
        this.ensureArtifactConfigured(this.getSettings());
        return super.getArtifactPatterns();
    }
}

