/*
 * Decompiled with CFR 0.152.
 */
package xsbti;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Function;
import java.util.logging.Level;
import xsbti.Position;

public final class ReporterConfig
implements Serializable {
    private String loggerName;
    private int maximumErrors;
    private boolean useColor;
    private Function<String, Boolean>[] msgFilters;
    private Function<Path, Boolean>[] fileFilters;
    private Level logLevel;
    private Function<Position, Position> positionMapper;

    public static ReporterConfig create(String string, int n, boolean bl, Function<String, Boolean>[] functionArray, Function<Path, Boolean>[] functionArray2, Level level, Function<Position, Position> function) {
        return new ReporterConfig(string, n, bl, functionArray, functionArray2, level, function);
    }

    public static ReporterConfig of(String string, int n, boolean bl, Function<String, Boolean>[] functionArray, Function<Path, Boolean>[] functionArray2, Level level, Function<Position, Position> function) {
        return new ReporterConfig(string, n, bl, functionArray, functionArray2, level, function);
    }

    protected ReporterConfig(String string, int n, boolean bl, Function<String, Boolean>[] functionArray, Function<Path, Boolean>[] functionArray2, Level level, Function<Position, Position> function) {
        this.loggerName = string;
        this.maximumErrors = n;
        this.useColor = bl;
        this.msgFilters = functionArray;
        this.fileFilters = functionArray2;
        this.logLevel = level;
        this.positionMapper = function;
    }

    public String loggerName() {
        return this.loggerName;
    }

    public int maximumErrors() {
        return this.maximumErrors;
    }

    public boolean useColor() {
        return this.useColor;
    }

    public Function<String, Boolean>[] msgFilters() {
        return this.msgFilters;
    }

    public Function<Path, Boolean>[] fileFilters() {
        return this.fileFilters;
    }

    public Level logLevel() {
        return this.logLevel;
    }

    public Function<Position, Position> positionMapper() {
        return this.positionMapper;
    }

    public ReporterConfig withLoggerName(String string) {
        return new ReporterConfig(string, this.maximumErrors, this.useColor, this.msgFilters, this.fileFilters, this.logLevel, this.positionMapper);
    }

    public ReporterConfig withMaximumErrors(int n) {
        return new ReporterConfig(this.loggerName, n, this.useColor, this.msgFilters, this.fileFilters, this.logLevel, this.positionMapper);
    }

    public ReporterConfig withUseColor(boolean bl) {
        return new ReporterConfig(this.loggerName, this.maximumErrors, bl, this.msgFilters, this.fileFilters, this.logLevel, this.positionMapper);
    }

    public ReporterConfig withMsgFilters(Function<String, Boolean>[] functionArray) {
        return new ReporterConfig(this.loggerName, this.maximumErrors, this.useColor, functionArray, this.fileFilters, this.logLevel, this.positionMapper);
    }

    public ReporterConfig withFileFilters(Function<Path, Boolean>[] functionArray) {
        return new ReporterConfig(this.loggerName, this.maximumErrors, this.useColor, this.msgFilters, functionArray, this.logLevel, this.positionMapper);
    }

    public ReporterConfig withLogLevel(Level level) {
        return new ReporterConfig(this.loggerName, this.maximumErrors, this.useColor, this.msgFilters, this.fileFilters, level, this.positionMapper);
    }

    public ReporterConfig withPositionMapper(Function<Position, Position> function) {
        return new ReporterConfig(this.loggerName, this.maximumErrors, this.useColor, this.msgFilters, this.fileFilters, this.logLevel, function);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReporterConfig)) {
            return false;
        }
        ReporterConfig reporterConfig = (ReporterConfig)object;
        return this.loggerName().equals(reporterConfig.loggerName()) && this.maximumErrors() == reporterConfig.maximumErrors() && this.useColor() == reporterConfig.useColor() && Arrays.deepEquals(this.msgFilters(), reporterConfig.msgFilters()) && Arrays.deepEquals(this.fileFilters(), reporterConfig.fileFilters()) && this.logLevel().equals(reporterConfig.logLevel()) && this.positionMapper().equals(reporterConfig.positionMapper());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.ReporterConfig".hashCode()) + this.loggerName().hashCode()) + new Integer(this.maximumErrors()).hashCode()) + new Boolean(this.useColor()).hashCode()) + Arrays.deepHashCode(this.msgFilters())) + Arrays.deepHashCode(this.fileFilters())) + this.logLevel().hashCode()) + this.positionMapper().hashCode());
    }

    public String toString() {
        return "ReporterConfig(loggerName: " + this.loggerName() + ", maximumErrors: " + this.maximumErrors() + ", useColor: " + this.useColor() + ", msgFilters: " + this.msgFilters() + ", fileFilters: " + this.fileFilters() + ", logLevel: " + this.logLevel() + ", positionMapper: " + this.positionMapper() + ")";
    }
}

