/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import edu.emory.mathcs.utils.IOUtils;

public class BenchmarkDoubleDST {
    private static int nthread = 2;
    private static int nsize = 6;
    private static int niter = 200;
    private static boolean doWarmup = true;
    private static int initialExponent1D = 17;
    private static int initialExponent2D = 7;
    private static int initialExponent3D = 2;
    private static boolean doScaling = false;

    private BenchmarkDoubleDST() {
    }

    public static void parseArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("args[" + i + "]:" + stringArray[i]);
        }
        if (stringArray == null || stringArray.length != 10) {
            System.out.println("Parameters: <number of threads> <THREADS_BEGIN_N_2D> <THREADS_BEGIN_N_3D> <number of iterations> <perform warm-up> <perform scaling> <number of sizes> <initial exponent for 1D transforms> <initial exponent for 2D transforms> <initial exponent for 3D transforms>");
            System.exit(-1);
        }
        nthread = Integer.parseInt(stringArray[0]);
        ConcurrencyUtils.setThreadsBeginN_2D(Integer.parseInt(stringArray[1]));
        ConcurrencyUtils.setThreadsBeginN_3D(Integer.parseInt(stringArray[2]));
        niter = Integer.parseInt(stringArray[3]);
        doWarmup = Boolean.parseBoolean(stringArray[4]);
        doScaling = Boolean.parseBoolean(stringArray[5]);
        nsize = Integer.parseInt(stringArray[6]);
        initialExponent1D = Integer.parseInt(stringArray[7]);
        initialExponent2D = Integer.parseInt(stringArray[8]);
        initialExponent3D = Integer.parseInt(stringArray[9]);
        ConcurrencyUtils.setNumberOfProcessors(nthread);
    }

    public static void benchmarkForward_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DST 1D of size 2^" + n3);
            DoubleDST_1D doubleDST_1D = new DoubleDST_1D(n2);
            double[] dArray2 = new double[n2];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(n2, dArray2);
                doubleDST_1D.forward(dArray2, false);
                IOUtils.fillMatrix_1D(n2, dArray2);
                doubleDST_1D.forward(dArray2, false);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(n2, dArray2);
                l = System.nanoTime();
                doubleDST_1D.forward(dArray2, false);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDST_1D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDST_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_2D_input_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DST 2D (input 1D) of size 2^" + n3 + " x 2^" + n3);
            DoubleDST_2D doubleDST_2D = new DoubleDST_2D(n2, n2);
            double[] dArray2 = new double[n2 * n2];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                doubleDST_2D.forward(dArray2, false);
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                doubleDST_2D.forward(dArray2, false);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                l = System.nanoTime();
                doubleDST_2D.forward(dArray2, false);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDST_2D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDST_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_2D_input_2D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DST 2D (input 2D) of size 2^" + n3 + " x 2^" + n3);
            DoubleDST_2D doubleDST_2D = new DoubleDST_2D(n2, n2);
            double[][] dArray2 = new double[n2][n2];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                doubleDST_2D.forward(dArray2, false);
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                doubleDST_2D.forward(dArray2, false);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(n2, n2, dArray2);
                l = System.nanoTime();
                doubleDST_2D.forward(dArray2, false);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDST_2D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDST_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_3D_input_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DST 3D (input 1D) of size 2^" + n3 + " x 2^" + n3 + " x 2^" + n3);
            DoubleDST_3D doubleDST_3D = new DoubleDST_3D(n2, n2, n2);
            double[] dArray2 = new double[n2 * n2 * n2];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                doubleDST_3D.forward(dArray2, false);
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                doubleDST_3D.forward(dArray2, false);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                l = System.nanoTime();
                doubleDST_3D.forward(dArray2, false);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDST_3D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDST_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_3D_input_3D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DST 3D (input 3D) of size 2^" + n3 + " x 2^" + n3 + " x 2^" + n3);
            DoubleDST_3D doubleDST_3D = new DoubleDST_3D(n2, n2, n2);
            double[][][] dArray2 = new double[n2][n2][n2];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                doubleDST_3D.forward(dArray2, false);
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                doubleDST_3D.forward(dArray2, false);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(n2, n2, n2, dArray2);
                l = System.nanoTime();
                doubleDST_3D.forward(dArray2, false);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleDST_3D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDST_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void main(String[] stringArray) {
        BenchmarkDoubleDST.parseArguments(stringArray);
        BenchmarkDoubleDST.benchmarkForward_1D(initialExponent1D);
        BenchmarkDoubleDST.benchmarkForward_2D_input_1D(initialExponent2D);
        BenchmarkDoubleDST.benchmarkForward_2D_input_2D(initialExponent2D);
        BenchmarkDoubleDST.benchmarkForward_3D_input_1D(initialExponent3D);
        BenchmarkDoubleDST.benchmarkForward_3D_input_3D(initialExponent3D);
        System.exit(0);
    }
}

