package TDS::Navigator::Monthly;
# $Id: Monthly.pm,v 1.8 2000/12/08 02:02:32 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $Template $HrefTemplateDynamic $HrefTemplateStatic);

use DateTime::Date;

use TDS::Navigator::Base;
use TDS::DirInfo;

@ISA = qw(TDS::Navigator::Base);

attributes qw();

{
    $HrefTemplateDynamic = "./?%year%0m%part";
    $HrefTemplateStatic = "d%year%0m%part.%suffix";
}

################################################################
sub AsPrev ($$)
{
    my ($self, $label) = @_;

    my $d = new DateTime::Date(year=>$self->year,
			       month=>$self->month,
			       day=>28);
    $d -= '1M';
    my $non_exist;
    if ($d->year < $TDS::Status->start_year){
	$non_exist = 1;
    }
    return $self->AsHTML($label, $d->GetParams, $non_exist);
}
sub AsThis ($$)
{
    my ($self, $label) = @_;

    my $d = new DateTime::Date(year=>$self->year,
			       month=>$self->month,
			       day=>1);
    return $self->AsHTML($label, $d->GetParams);
}
sub AsNext ($$)
{
    my ($self, $label) = @_;

    my $d = new DateTime::Date(year=>$self->year,
			       month=>$self->month,
			       day=>1);
    $d += '1M';
#    my $dir = sprintf("%s/%04d/%02d",
#		      GetDiaryDir(),
#		      $d->year, $d->month);

    # check if future
    my $is_future;
#    die $TDS::Status->start_time->day;
    if ($d > $TDS::Status->start_time){
	$is_future = 1;
    }
    return $self->AsHTML($label, $d->GetParams, $is_future); #, !-d $dir);
}
sub AsHTML($$$)
{
    my ($self, $label, $params,  $nohref) = @_;

    $params->{part} = undef
	if $TDS::Collection::AllowAllMonthly;

    $self->SUPER::AsHTML($label, $params, $nohref);
}

1;
