/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import java.util.Collections;
import org.apache.cassandra.db.partitions.BasePartitionIterator;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.transform.BaseIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.Throwables;

public abstract class BasePartitions<R extends BaseRowIterator<?>, I extends BasePartitionIterator<? extends BaseRowIterator<?>>>
extends BaseIterator<BaseRowIterator<?>, I, R>
implements BasePartitionIterator<R> {
    public BasePartitions(I input) {
        super(input);
    }

    BasePartitions(BasePartitions<?, ? extends I> copyFrom) {
        super(copyFrom);
    }

    @Override
    protected BaseRowIterator<?> applyOne(BaseRowIterator<?> value, Transformation transformation) {
        return value == null ? null : transformation.applyToPartition(value);
    }

    @Override
    void add(Transformation transformation) {
        transformation.attachTo(this);
        super.add(transformation);
        this.next = this.applyOne((BaseRowIterator)this.next, transformation);
    }

    @Override
    protected Throwable runOnClose(int length) {
        Throwable fail = null;
        Transformation[] fs = this.stack;
        for (int i = 0; i < length; ++i) {
            try {
                fs[i].onClose();
                continue;
            }
            catch (Throwable t) {
                fail = Throwables.merge(fail, t);
            }
        }
        return fail;
    }

    @Override
    public final boolean hasNext() {
        BaseRowIterator next = null;
        try {
            BaseIterator.Stop stop = this.stop;
            while (this.next == null) {
                Transformation[] fs = this.stack;
                int len = this.length;
                while (!stop.isSignalled && ((BasePartitionIterator)this.input).hasNext()) {
                    next = (BaseRowIterator)((BasePartitionIterator)this.input).next();
                    int i = 0;
                    while (next != null & i < len) {
                        next = fs[i].applyToPartition(next);
                        ++i;
                    }
                    if (next == null) continue;
                    this.next = next;
                    return true;
                }
                if (!stop.isSignalled && !this.stopChild.isSignalled && this.hasMoreContents()) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            if (next != null) {
                Throwables.close(t, Collections.singleton(next));
            }
            throw t;
        }
    }
}

