/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.analyzer;

import java.util.Map;

public class NonTokenizingOptions {
    public static final String NORMALIZE_LOWERCASE = "normalize_lowercase";
    public static final String NORMALIZE_UPPERCASE = "normalize_uppercase";
    public static final String CASE_SENSITIVE = "case_sensitive";
    private boolean caseSensitive;
    private boolean upperCaseOutput;
    private boolean lowerCaseOutput;

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean shouldUpperCaseOutput() {
        return this.upperCaseOutput;
    }

    public void setUpperCaseOutput(boolean upperCaseOutput) {
        this.upperCaseOutput = upperCaseOutput;
    }

    public boolean shouldLowerCaseOutput() {
        return this.lowerCaseOutput;
    }

    public void setLowerCaseOutput(boolean lowerCaseOutput) {
        this.lowerCaseOutput = lowerCaseOutput;
    }

    public static NonTokenizingOptions buildFromMap(Map<String, String> optionsMap) {
        OptionsBuilder optionsBuilder = new OptionsBuilder();
        if (optionsMap.containsKey(CASE_SENSITIVE) && (optionsMap.containsKey(NORMALIZE_LOWERCASE) || optionsMap.containsKey(NORMALIZE_UPPERCASE))) {
            throw new IllegalArgumentException("case_sensitive option cannot be specified together with either normalize_lowercase or normalize_uppercase");
        }
        for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
            switch (entry.getKey()) {
                case "normalize_lowercase": {
                    boolean bool = Boolean.parseBoolean(entry.getValue());
                    optionsBuilder = optionsBuilder.lowerCaseOutput(bool);
                    break;
                }
                case "normalize_uppercase": {
                    boolean bool = Boolean.parseBoolean(entry.getValue());
                    optionsBuilder = optionsBuilder.upperCaseOutput(bool);
                    break;
                }
                case "case_sensitive": {
                    boolean bool = Boolean.parseBoolean(entry.getValue());
                    optionsBuilder = optionsBuilder.caseSensitive(bool);
                    break;
                }
            }
        }
        return optionsBuilder.build();
    }

    public static NonTokenizingOptions getDefaultOptions() {
        return new OptionsBuilder().caseSensitive(true).lowerCaseOutput(false).upperCaseOutput(false).build();
    }

    public static class OptionsBuilder {
        private boolean caseSensitive = true;
        private boolean upperCaseOutput = false;
        private boolean lowerCaseOutput = false;

        public OptionsBuilder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public OptionsBuilder upperCaseOutput(boolean upperCaseOutput) {
            this.upperCaseOutput = upperCaseOutput;
            return this;
        }

        public OptionsBuilder lowerCaseOutput(boolean lowerCaseOutput) {
            this.lowerCaseOutput = lowerCaseOutput;
            return this;
        }

        public NonTokenizingOptions build() {
            if (this.lowerCaseOutput && this.upperCaseOutput) {
                throw new IllegalArgumentException("Options to normalize terms cannot be both uppercase and lowercase at the same time");
            }
            NonTokenizingOptions options = new NonTokenizingOptions();
            options.setCaseSensitive(this.caseSensitive);
            options.setUpperCaseOutput(this.upperCaseOutput);
            options.setLowerCaseOutput(this.lowerCaseOutput);
            return options;
        }
    }
}

