/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.dockbar.event.ResizeListener;
import org.flexdock.docking.Dockable;
import org.flexdock.plaf.common.border.SlideoutBorder;

public class ViewPane
extends JPanel {
    private static final Dimension RESIZE_DIMS = new Dimension(3, 3);
    private static final MouseInputAdapter EMPTY_MOUSE_LISTENER = new MouseInputAdapter(){};
    public static final int UNSPECIFIED_PREFERRED_SIZE = -1;
    private DockbarManager manager;
    private JPanel dragEdge;
    private int prefSize;
    private boolean locked;

    public ViewPane(DockbarManager mgr) {
        super(new BorderLayout(0, 0));
        this.setBorder(new SlideoutBorder());
        this.manager = mgr;
        this.prefSize = -1;
        this.dragEdge = new JPanel();
        this.dragEdge.setPreferredSize(RESIZE_DIMS);
        ResizeListener listener = new ResizeListener(mgr);
        this.dragEdge.addMouseListener(listener);
        this.dragEdge.addMouseMotionListener(listener);
        this.updateOrientation();
        this.addMouseListener(EMPTY_MOUSE_LISTENER);
        this.addMouseMotionListener(EMPTY_MOUSE_LISTENER);
    }

    public void updateContents() {
        Component c;
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == this.dragEdge) continue;
            this.remove(children[i]);
        }
        Dockable d = this.manager.getActiveDockable();
        Component component = c = d == null ? null : d.getComponent();
        if (c != null) {
            this.add(c, "Center");
        }
    }

    public void updateOrientation() {
        Border border = this.getBorder();
        if (border instanceof SlideoutBorder) {
            ((SlideoutBorder)border).setOrientation(this.manager.getActiveEdge());
        }
        this.remove(this.dragEdge);
        this.add((Component)this.dragEdge, this.getEdgeRegion());
        this.dragEdge.setCursor(this.getResizeCursor());
        this.revalidate();
    }

    private String getEdgeRegion() {
        int orientation = this.manager.getActiveEdge();
        switch (orientation) {
            case 1: {
                return "South";
            }
            case 3: {
                return "North";
            }
            case 4: {
                return "West";
            }
        }
        return "East";
    }

    public Cursor getResizeCursor() {
        int orientation = this.manager.getActiveEdge();
        return orientation == 2 || orientation == 4 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(8);
    }

    public int getPrefSize() {
        return this.prefSize;
    }

    public void setPrefSize(int prefSize) {
        this.prefSize = prefSize;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }
}

