/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.floating.policy;

import java.util.Set;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.floating.frames.FloatingDockingPort;
import org.flexdock.docking.floating.policy.FloatPolicy;
import org.flexdock.docking.floating.policy.FloatPolicyManager;

public class DefaultFloatPolicy
extends FloatPolicy.NullFloatPolicy {
    private static final DefaultFloatPolicy SINGLETON = new DefaultFloatPolicy();

    public static DefaultFloatPolicy getInstance() {
        return SINGLETON;
    }

    public boolean isFloatDropAllowed(DockingEvent evt) {
        FloatingDockingPort dockingPort;
        DockingPort oldPort = evt.getOldDockingPort();
        if (oldPort instanceof FloatingDockingPort && (dockingPort = (FloatingDockingPort)oldPort).getDockableCount() < 2) {
            evt.consume();
            return false;
        }
        return super.isFloatDropAllowed(evt);
    }

    public boolean isFloatingAllowed(Dockable dockable) {
        if (dockable == null || !FloatPolicyManager.isGlobalFloatingEnabled()) {
            return false;
        }
        Set frameDragSources = dockable.getFrameDragSources();
        if (frameDragSources == null || frameDragSources.size() == 0) {
            return false;
        }
        return super.isFloatingAllowed(dockable);
    }
}

