require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_CPU_H_)) {
    eval 'sub _CPU_H_ () {1;}' unless defined(&_CPU_H_);
    eval 'sub CPU_BOOTED_KERNEL () {1;}' unless defined(&CPU_BOOTED_KERNEL);
    eval 'sub CPU_BOOTED_DEVICE () {2;}' unless defined(&CPU_BOOTED_DEVICE);
    eval 'sub CPU_BOOT_ARGS () {3;}' unless defined(&CPU_BOOT_ARGS);
    eval 'sub CPU_ARCH () {4;}' unless defined(&CPU_ARCH);
    eval("sub VAC_UNKNOWN () { 0; }") unless defined(&VAC_UNKNOWN);
    eval("sub VAC_NONE () { 1; }") unless defined(&VAC_NONE);
    eval("sub VAC_WRITETHROUGH () { 2; }") unless defined(&VAC_WRITETHROUGH);
    eval("sub VAC_WRITEBACK () { 3; }") unless defined(&VAC_WRITEBACK);
    eval 'sub CACHE_PAGETABLES () {0x1;}' unless defined(&CACHE_PAGETABLES);
    eval 'sub CACHE_TRAPPAGEBUG () {0x2;}' unless defined(&CACHE_TRAPPAGEBUG);
    eval 'sub CACHE_MANDATORY () {0x4;}' unless defined(&CACHE_MANDATORY);
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	if(defined(&_KERNEL_OPT)) {
	    require './sparc/opt_gprof.ph';
	    require './sparc/opt_multiprocessor.ph';
	    require './sparc/opt_lockdebug.ph';
	    require './sparc/opt_sparc_arch.ph';
	}
	require 'sys/cpu_data.ph';
	require 'sys/evcnt.ph';
	require 'machine/intr.ph';
	require 'machine/psl.ph';
	if(defined(&_KERNEL)) {
	    require 'sparc/sparc/cpuvar.ph';
	    require 'sparc/sparc/intreg.ph';
	}
	eval 'sub XPMSG15_PAUSECPU () {1;}' unless defined(&XPMSG15_PAUSECPU);
	eval 'sub XPMSG_FUNC () {4;}' unless defined(&XPMSG_FUNC);
	eval 'sub XPMSG_FTRP () {5;}' unless defined(&XPMSG_FTRP);
	eval 'sub raise_ipi {
	    my($cpi,$lvl) = @_;
    	    eval q( &do {  &volatile \'int\'  &x; ($cpi)-> ($intreg_4m->{pi_set}) =  &PINTR_SINTRLEV($lvl);  &x = ($cpi)-> ($intreg_4m->{pi_pend});  &__USE( &x); }  &while (0));
	}' unless defined(&raise_ipi);
	if(defined(&SUN4_MMU3L)) {
	    eval 'sub HASSUN4_MMU3L () {( ($cpuinfo->{sun4_mmu3l}));}' unless defined(&HASSUN4_MMU3L);
	} else {
	    eval 'sub HASSUN4_MMU3L () {(0);}' unless defined(&HASSUN4_MMU3L);
	}
	eval 'sub INT_STACK_SIZE () {(128* 128);}' unless defined(&INT_STACK_SIZE);
	eval 'sub REDSIZE () {(8*96);}' unless defined(&REDSIZE);
	if(0) {
	}
	if(defined(&GPROF)  && defined(&MULTIPROCESSOR)) {
	}
    }
    if(defined(&_KERNEL)) {
	require 'sys/mutex.ph';
	eval 'sub cpuinfo () {(* &CPUINFO_VA);}' unless defined(&cpuinfo);
	eval 'sub curcpu () {
	    eval q(( ($cpuinfo->{ci_self})));
	}' unless defined(&curcpu);
	eval 'sub curlwp () {( ($cpuinfo->{ci_curlwp}));}' unless defined(&curlwp);
	eval 'sub CPU_IS_PRIMARY {
	    my($ci) = @_;
    	    eval q((($ci)-> &master));
	}' unless defined(&CPU_IS_PRIMARY);
	eval 'sub cpu_number () {
	    eval q(( ($cpuinfo->{ci_cpuid})));
	}' unless defined(&cpu_number);
	if(defined(&MULTIPROCESSOR)) {
	}
	eval 'sub CLKF_USERMODE {
	    my($framep) = @_;
    	    eval q(((($framep)-> &psr &  &PSR_PS) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_LOPRI {
	    my($framep,$n) = @_;
    	    eval q(((($framep)-> &psr &  &PSR_PIL) < ($n) << 8));
	}' unless defined(&CLKF_LOPRI);
	eval 'sub CLKF_PC {
	    my($framep) = @_;
    	    eval q((($framep)-> &pc));
	}' unless defined(&CLKF_PC);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub CLKF_INTR {
	        my($framep) = @_;
    		eval q((-> &fp >  ($cpuinfo->{eintstack}) -  &INT_STACK_SIZE  && -> &fp <  ($cpuinfo->{eintstack})));
	    }' unless defined(&CLKF_INTR);
	} else {
	    eval 'sub CLKF_INTR {
	        my($framep) = @_;
    		eval q((-> &fp <  &eintstack));
	    }' unless defined(&CLKF_INTR);
	}
	eval 'sub cpu_need_resched {
	    my($ci, $l, $flags) = @_;
    	    eval q( &do {  &__USE($flags); ($ci)-> &ci_want_ast = 1;  &if (($flags &  &RESCHED_REMOTE) != 0)  &XCALL0( &sparc_noop, 1 << ($ci)-> &ci_cpuid); }  &while ( 0));
	}' unless defined(&cpu_need_resched);
	eval 'sub cpu_need_proftick {
	    my($l) = @_;
    	    eval q((($l)-> &l_pflag |=  &LP_OWEUPC,  ($cpuinfo->{ci_want_ast}) = 1));
	}' unless defined(&cpu_need_proftick);
	eval 'sub cpu_signotify {
	    my($l) = @_;
    	    eval q( &do { ($l)-> ($l_cpu->{ci_want_ast}) = 1;  &if (($l)-> ($l_cpu->{ci_cpuid}) !=  &cpu_number())  &XCALL0( &sparc_noop, 1 << ($l)-> ($l_cpu->{ci_cpuid})); }  &while ( 0));
	}' unless defined(&cpu_signotify);
	eval 'sub LWP_PC {
	    my($l) = @_;
    	    eval q((($l)-> ($l_md->{md_tf}->{tf_pc})));
	}' unless defined(&LWP_PC);
	if(defined(&KGDB)) {
	}
	if(defined(&KGDB)) {
	}
	if(defined(&DDB)) {
	}
    }
}
1;
