<?php
// Connection Component Binding
Doctrine_Manager::getInstance()->bindComponent('EmailTemplate', 'doctrine');

/**
 * BaseEmailTemplate
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int            $id                           Type: integer(4), primary key
 * @property int            $email_id                     Type: integer(4)
 * @property string         $locale                       Type: string(20)
 * @property string         $performer_role               Type: string(50)
 * @property string         $recipient_role               Type: string(50)
 * @property string         $subject                      Type: string(255)
 * @property string         $body                         Type: string
 * @property Email          $Email                        
 *  
 * @method int              getId()                       Type: integer(4), primary key
 * @method int              getEmailId()                  Type: integer(4)
 * @method string           getLocale()                   Type: string(20)
 * @method string           getPerformerRole()            Type: string(50)
 * @method string           getRecipientRole()            Type: string(50)
 * @method string           getSubject()                  Type: string(255)
 * @method string           getBody()                     Type: string
 * @method Email            getEmail()                    
 *  
 * @method EmailTemplate    setId(int $val)               Type: integer(4), primary key
 * @method EmailTemplate    setEmailId(int $val)          Type: integer(4)
 * @method EmailTemplate    setLocale(string $val)        Type: string(20)
 * @method EmailTemplate    setPerformerRole(string $val) Type: string(50)
 * @method EmailTemplate    setRecipientRole(string $val) Type: string(50)
 * @method EmailTemplate    setSubject(string $val)       Type: string(255)
 * @method EmailTemplate    setBody(string $val)          Type: string
 * @method EmailTemplate    setEmail(Email $val)          
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmailTemplate extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_email_template');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('email_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('locale', 'string', 20, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 20,
             ));
        $this->hasColumn('performer_role', 'string', 50, array(
             'type' => 'string',
             'notnull' => false,
             'length' => 50,
             ));
        $this->hasColumn('recipient_role', 'string', 50, array(
             'type' => 'string',
             'notnull' => false,
             'length' => 50,
             ));
        $this->hasColumn('subject', 'string', 255, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 255,
             ));
        $this->hasColumn('body', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Email', array(
             'local' => 'email_id',
             'foreign' => 'id'));
    }
}