require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&VMPARAM_H)) {
    eval 'sub VMPARAM_H () {1;}' unless defined(&VMPARAM_H);
    eval 'sub __USE_TOPDOWN_VM () {1;}' unless defined(&__USE_TOPDOWN_VM);
    eval 'sub PAGE_SHIFT () {13;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub PAGER_MAP_DEFAULT_SIZE () {(512* 1024* 1024);}' unless defined(&PAGER_MAP_DEFAULT_SIZE);
    eval 'sub PAGE_SHIFT_4M () {22;}' unless defined(&PAGE_SHIFT_4M);
    eval 'sub PAGE_SIZE_4M () {(1<< &PAGE_SHIFT_4M);}' unless defined(&PAGE_SIZE_4M);
    eval 'sub PAGE_MASK_4M () {( &PAGE_SIZE_4M-1);}' unless defined(&PAGE_MASK_4M);
    eval 'sub USRSTACK32 () {0xffffe000;}' unless defined(&USRSTACK32);
    if(defined(&__arch64__)) {
	eval 'sub USRSTACK () {0xffffffffffffe000;}' unless defined(&USRSTACK);
    } else {
	eval 'sub USRSTACK () { &USRSTACK32;}' unless defined(&USRSTACK);
    }
    if((defined(&__arch64__) ? &__arch64__ : undef)) {
	unless(defined(&MAXTSIZ)) {
	    eval 'sub MAXTSIZ () {(4*1024*1024*1024);}' unless defined(&MAXTSIZ);
	}
	unless(defined(&DFLDSIZ)) {
	    eval 'sub DFLDSIZ () {(128*1024*1024);}' unless defined(&DFLDSIZ);
	}
	unless(defined(&MAXDSIZ)) {
	    eval 'sub MAXDSIZ () {(1<<39);}' unless defined(&MAXDSIZ);
	    eval 'sub VM_DEFAULT_ADDRESS_BOTTOMUP {
	        my($da, $sz) = @_;
    		eval q( &round_page(( &vaddr_t)($da) + ( &vsize_t) &uimax( &maxdmap,1*1024*1024*1024)));
	    }' unless defined(&VM_DEFAULT_ADDRESS_BOTTOMUP);
	}
	unless(defined(&DFLSSIZ)) {
	    eval 'sub DFLSSIZ () {(2*1024*1024);}' unless defined(&DFLSSIZ);
	}
	unless(defined(&MAXSSIZ)) {
	    eval 'sub MAXSSIZ () {(128*1024*1024);}' unless defined(&MAXSSIZ);
	}
    } else {
	unless(defined(&MAXTSIZ)) {
	    eval 'sub MAXTSIZ () {(2*1024*1024*1024);}' unless defined(&MAXTSIZ);
	}
	unless(defined(&DFLDSIZ)) {
	    eval 'sub DFLDSIZ () {(128*1024*1024);}' unless defined(&DFLDSIZ);
	}
	unless(defined(&MAXDSIZ)) {
	    eval 'sub MAXDSIZ () {(2*1024*1024*1024);}' unless defined(&MAXDSIZ);
	}
	unless(defined(&DFLSSIZ)) {
	    eval 'sub DFLSSIZ () {(2*1024*1024);}' unless defined(&DFLSSIZ);
	}
	unless(defined(&MAXSSIZ)) {
	    eval 'sub MAXSSIZ () {(64*1024*1024);}' unless defined(&MAXSSIZ);
	}
    }
    unless(defined(&MAXTSIZ32)) {
	eval 'sub MAXTSIZ32 () {(64*1024*1024);}' unless defined(&MAXTSIZ32);
    }
    unless(defined(&DFLDSIZ32)) {
	eval 'sub DFLDSIZ32 () {(64*1024*1024);}' unless defined(&DFLDSIZ32);
    }
    unless(defined(&MAXDSIZ32)) {
	eval 'sub MAXDSIZ32 () {(512*1024*1024);}' unless defined(&MAXDSIZ32);
    }
    unless(defined(&DFLSSIZ32)) {
	eval 'sub DFLSSIZ32 () {(2*1024*1024);}' unless defined(&DFLSSIZ32);
    }
    unless(defined(&MAXSSIZ32)) {
	eval 'sub MAXSSIZ32 () {(32*1024*1024);}' unless defined(&MAXSSIZ32);
    }
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)0);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAX_ADDRESS () {((( &vaddr_t)(-1))&~ &PGOFSET);}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () { &VM_MAX_ADDRESS;}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS32 () {(( &vaddr_t)(0xffffffff&~ &PGOFSET));}' unless defined(&VM_MAXUSER_ADDRESS32);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t) &KERNBASE);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    if(defined(&__arch64__)) {
	eval 'sub VM_KERNEL_MEM_VA_START () {(( &vaddr_t)0x100000000);}' unless defined(&VM_KERNEL_MEM_VA_START);
	eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)0x7ffffffffff);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    } else {
	eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t) &KERNEND);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    }
    eval 'sub VM_PHYSSEG_MAX () {32;}' unless defined(&VM_PHYSSEG_MAX);
    eval 'sub VM_PHYSSEG_STRAT () { &VM_PSTRAT_BSEARCH;}' unless defined(&VM_PHYSSEG_STRAT);
    eval 'sub VM_NFREELIST () {1;}' unless defined(&VM_NFREELIST);
    eval 'sub VM_FREELIST_DEFAULT () {0;}' unless defined(&VM_FREELIST_DEFAULT);
}
1;
