/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class DirectColorModel
extends PackedColorModel {
    public final int getRedMask() {
        return this.getMask(0);
    }

    public final int getGreenMask() {
        return this.getMask(1);
    }

    public final int getBlueMask() {
        return this.getMask(2);
    }

    public final int getAlphaMask() {
        int n = 0;
        if (this.hasAlpha()) {
            n = this.getMask(3);
        }
        return n;
    }

    public final int getRed(int pixel) {
        return this.extractAndNormalizeSample(pixel, 0);
    }

    public final int getGreen(int pixel) {
        return this.extractAndNormalizeSample(pixel, 1);
    }

    public final int getBlue(int pixel) {
        return this.extractAndNormalizeSample(pixel, 2);
    }

    public final int getAlpha(int pixel) {
        if (!this.hasAlpha()) {
            return 255;
        }
        return this.extractAndScaleSample(pixel, 3);
    }

    private final int extractAndNormalizeSample(int pixel, int component) {
        int value = this.extractAndScaleSample(pixel, component);
        if (this.hasAlpha() && this.isAlphaPremultiplied()) {
            value = value * 255 / this.getAlpha(pixel);
        }
        return value;
    }

    private final int extractAndScaleSample(int pixel, int component) {
        int field = pixel & this.getMask(component);
        int to8BitShift = 8 - this.shifts[component] - this.getComponentSize(component);
        return to8BitShift > 0 ? field << to8BitShift : field >>> -to8BitShift;
    }

    public final int getRGB(int pixel) {
        return super.getRGB(pixel);
    }

    public int getRed(Object inData) {
        return this.getRed(this.getPixelFromArray(inData));
    }

    public int getGreen(Object inData) {
        return this.getGreen(this.getPixelFromArray(inData));
    }

    public int getBlue(Object inData) {
        return this.getBlue(this.getPixelFromArray(inData));
    }

    public int getAlpha(Object inData) {
        return this.getAlpha(this.getPixelFromArray(inData));
    }

    public int getRGB(Object inData) {
        return this.getRGB(this.getPixelFromArray(inData));
    }

    public Object getDataElements(int rgb, Object pixel) {
        int r;
        int pixelValue = 0;
        int a = 0;
        if (this.hasAlpha()) {
            a = rgb >>> 24 & 0xFF;
            pixelValue = this.valueToField(a, 3, 8);
        }
        if (this.hasAlpha() && this.isAlphaPremultiplied()) {
            r = (rgb >>> 8 & 0xFF00) * a / 255;
            int g = (rgb & 0xFF00) * a / 255;
            int b = (rgb << 8 & 0xFF00) * a / 255;
            pixelValue |= this.valueToField(r, 0, 16) | this.valueToField(g, 1, 16) | this.valueToField(b, 2, 16);
        } else {
            r = rgb >>> 16 & 0xFF;
            int g = rgb >>> 8 & 0xFF;
            int b = rgb & 0xFF;
            pixelValue |= this.valueToField(r, 0, 8) | this.valueToField(g, 1, 8) | this.valueToField(b, 2, 8);
        }
        DataBuffer buffer = Buffers.createBuffer(this.transferType, pixel, 1);
        buffer.setElem(0, pixelValue);
        return Buffers.getData(buffer);
    }

    private final int valueToField(int val, int component, int highBit) {
        int toFieldShift = this.getComponentSize(component) + this.shifts[component] - highBit;
        int ret = toFieldShift > 0 ? val << toFieldShift : val >>> -toFieldShift;
        return ret & this.getMask(component);
    }

    private final int value16ToField(int val, int component) {
        int toFieldShift = this.getComponentSize(component) + this.shifts[component] - 16;
        return toFieldShift > 0 ? val << toFieldShift : val >>> -toFieldShift;
    }

    public final int[] getComponents(int pixel, int[] components, int offset) {
        int numComponents = this.getNumComponents();
        if (components == null) {
            components = new int[offset + numComponents];
        }
        int b = 0;
        while (b < numComponents) {
            components[offset++] = (pixel & this.getMask(b)) >>> this.shifts[b];
            ++b;
        }
        return components;
    }

    public final int[] getComponents(Object pixel, int[] components, int offset) {
        return this.getComponents(this.getPixelFromArray(pixel), components, offset);
    }

    public final WritableRaster createCompatibleWritableRaster(int w, int h) {
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width (=" + w + ") and height (=" + h + ") must be > 0");
        }
        SampleModel sm = this.createCompatibleSampleModel(w, h);
        Point origin = new Point(0, 0);
        return Raster.createWritableRaster(sm, origin);
    }

    public int getDataElement(int[] components, int offset) {
        int numComponents = this.getNumComponents();
        int pixelValue = 0;
        int c = 0;
        while (c < numComponents) {
            pixelValue |= components[offset++] << this.shifts[c] & this.getMask(c);
            ++c;
        }
        return pixelValue;
    }

    public Object getDataElements(int[] components, int offset, Object obj) {
        int pixelValue = this.getDataElement(components, offset);
        DataBuffer buffer = Buffers.createBuffer(this.transferType, obj, 1);
        buffer.setElem(0, pixelValue);
        return Buffers.getData(buffer);
    }

    public final ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
        if (this.isAlphaPremultiplied == isAlphaPremultiplied) {
            return this;
        }
        super.coerceData(raster, isAlphaPremultiplied);
        return new ComponentColorModel(this.cspace, this.bits, this.hasAlpha(), isAlphaPremultiplied, this.transparency, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        return super.isCompatibleRaster(raster);
    }

    String stringParam() {
        return super.stringParam() + ", redMask=" + Integer.toHexString(this.getRedMask()) + ", greenMask=" + Integer.toHexString(this.getGreenMask()) + ", blueMask=" + Integer.toHexString(this.getBlueMask()) + ", alphaMask=" + Integer.toHexString(this.getAlphaMask());
    }

    public String toString() {
        return super.toString();
    }

    public DirectColorModel(int pixelBits, int rmask, int gmask, int bmask) {
        this(ColorSpace.getInstance(1000), pixelBits, rmask, gmask, bmask, 0, false, Buffers.smallestAppropriateTransferType(pixelBits));
    }

    public DirectColorModel(int pixelBits, int rmask, int gmask, int bmask, int amask) {
        this(ColorSpace.getInstance(1000), pixelBits, rmask, gmask, bmask, amask, false, Buffers.smallestAppropriateTransferType(pixelBits));
    }

    public DirectColorModel(ColorSpace cspace, int pixelBits, int rmask, int gmask, int bmask, int amask, boolean isAlphaPremultiplied, int transferType) {
        super(cspace, pixelBits, rmask, gmask, bmask, amask, isAlphaPremultiplied, amask == 0 ? 1 : 3, transferType);
    }
}

