/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ShortLookupTable
extends LookupTable {
    private short[][] data;

    public final short[][] getTable() {
        return this.data;
    }

    public int[] lookupPixel(int[] src, int[] dst) throws ArrayIndexOutOfBoundsException {
        if (dst == null) {
            dst = new int[src.length];
        }
        if (this.data.length == 1) {
            int i = 0;
            while (i < src.length) {
                dst[i] = this.data[0][src[i] - this.offset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < src.length) {
                dst[i] = this.data[i][src[i] - this.offset];
                ++i;
            }
        }
        return dst;
    }

    public short[] lookupPixel(short[] src, short[] dst) throws ArrayIndexOutOfBoundsException {
        if (dst == null) {
            dst = new short[src.length];
        }
        if (this.data.length == 1) {
            int i = 0;
            while (i < src.length) {
                dst[i] = this.data[0][src[i] - this.offset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < src.length) {
                dst[i] = this.data[i][src[i] - this.offset];
                ++i;
            }
        }
        return dst;
    }

    public ShortLookupTable(int offset, short[][] data) throws IllegalArgumentException {
        super(offset, data.length);
        this.data = data;
    }

    public ShortLookupTable(int offset, short[] data) throws IllegalArgumentException {
        super(offset, 1);
        this.data = new short[][]{data};
    }
}

