/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GapContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = -6226052713477823730L;
    static final int DEFAULT_BUFSIZE = 10;
    char[] buffer;
    int gapStart;
    int gapEnd;
    ArrayList positions;
    private static final /* synthetic */ boolean assert;

    protected Object allocateArray(int size) {
        return new char[size];
    }

    protected int getArrayLength() {
        return this.buffer.length;
    }

    public int length() {
        return this.buffer.length - (this.gapEnd - this.gapStart);
    }

    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        int length = this.length();
        int strLen = str.length();
        if (where >= length) {
            throw new BadLocationException("the where argument cannot be greater than the content length", where);
        }
        this.replace(where, 0, str.toCharArray(), strLen);
        return new UndoInsertString(where, strLen);
    }

    public UndoableEdit remove(int where, int nitems) throws BadLocationException {
        int length = this.length();
        if (where >= length) {
            throw new BadLocationException("the where argument cannot be greater than the content length", where);
        }
        if (where + nitems > length) {
            throw new BadLocationException("where + nitems cannot be greater than the content length", where + nitems);
        }
        String removedText = this.getString(where, nitems);
        this.replace(where, nitems, null, 0);
        return new UndoRemove(where, removedText);
    }

    public String getString(int where, int len) throws BadLocationException {
        Segment seg = new Segment();
        try {
            this.getChars(where, len, seg);
            return new String(seg.array, seg.offset, seg.count);
        }
        catch (StringIndexOutOfBoundsException ex) {
            int invalid = 0;
            invalid = seg.offset < 0 || seg.offset >= seg.array.length ? seg.offset : seg.offset + seg.count;
            throw new BadLocationException("Illegal location: array.length = " + seg.array.length + ", offset = " + seg.offset + ", count = " + seg.count, invalid);
        }
    }

    public void getChars(int where, int len, Segment txt) throws BadLocationException {
        int length = this.length();
        if (where >= length) {
            throw new BadLocationException("the where argument cannot be greater than the content length", where);
        }
        if (where + len > length) {
            throw new BadLocationException("len plus where cannot be greater than the content length", len + where);
        }
        if (where < this.gapStart && this.gapStart - where < len) {
            char[] copy = new char[len];
            int lenFirst = this.gapStart - where;
            System.arraycopy(this.buffer, where, copy, 0, lenFirst);
            System.arraycopy(this.buffer, this.gapEnd, copy, lenFirst, len - lenFirst);
            txt.array = copy;
            txt.offset = 0;
            txt.count = len;
        } else {
            txt.array = this.buffer;
            txt.offset = where < this.gapStart ? where : where + (this.gapEnd - this.gapStart);
            txt.count = len;
        }
    }

    public Position createPosition(int offset) throws BadLocationException {
        GapContentPosition pos;
        int index;
        if (offset < 0 || offset > this.length()) {
            throw new BadLocationException("The offset was out of the bounds of this buffer", offset);
        }
        int mark = offset;
        if (offset > this.gapStart) {
            mark += this.gapEnd - this.gapStart;
        }
        if ((index = Collections.binarySearch(this.positions, pos = new GapContentPosition(mark))) < 0) {
            index = -(index + 1);
        }
        this.positions.add(index, pos);
        return pos;
    }

    protected void shiftEnd(int newSize) {
        if (!assert && newSize <= this.gapEnd - this.gapStart) {
            throw new AssertionError((Object)"The new gap size must be greater than the old gap size");
        }
        int delta = newSize - this.gapEnd + this.gapStart;
        this.adjustPositionsInRange(this.gapEnd, this.buffer.length - this.gapEnd, delta);
        char[] newBuf = (char[])this.allocateArray(this.length() + newSize);
        System.arraycopy(this.buffer, 0, newBuf, 0, this.gapStart);
        System.arraycopy(this.buffer, this.gapEnd, newBuf, this.gapStart + newSize, this.buffer.length - this.gapEnd);
        this.gapEnd = this.gapStart + newSize;
        this.buffer = newBuf;
    }

    protected void shiftGap(int newGapStart) {
        if (newGapStart == this.gapStart) {
            return;
        }
        int newGapEnd = newGapStart + this.gapEnd - this.gapStart;
        if (newGapStart < this.gapStart) {
            this.adjustPositionsInRange(newGapStart, this.gapStart - newGapStart, this.gapEnd - this.gapStart);
            System.arraycopy(this.buffer, newGapStart, this.buffer, newGapEnd, this.gapStart - newGapStart);
            this.gapStart = newGapStart;
            this.gapEnd = newGapEnd;
        } else {
            this.adjustPositionsInRange(this.gapEnd, newGapEnd - this.gapEnd, -(this.gapEnd - this.gapStart));
            System.arraycopy(this.buffer, this.gapEnd, this.buffer, this.gapStart, newGapStart - this.gapStart);
            this.gapStart = newGapStart;
            this.gapEnd = newGapEnd;
        }
        if (this.gapStart == 0) {
            this.resetMarksAtZero();
        }
    }

    protected void shiftGapStartDown(int newGapStart) {
        if (newGapStart == this.gapStart) {
            return;
        }
        if (!assert && newGapStart >= this.gapStart) {
            throw new AssertionError((Object)"The new gap start must be less than the old gap start.");
        }
        this.setPositionsInRange(newGapStart, this.gapStart - newGapStart, this.gapStart);
        this.gapStart = newGapStart;
    }

    protected void shiftGapEndUp(int newGapEnd) {
        if (newGapEnd == this.gapEnd) {
            return;
        }
        if (!assert && newGapEnd <= this.gapEnd) {
            throw new AssertionError((Object)"The new gap end must be greater than the old gap end.");
        }
        this.setPositionsInRange(this.gapEnd, newGapEnd - this.gapEnd, newGapEnd + 1);
        this.gapEnd = newGapEnd;
    }

    protected Object getArray() {
        return this.buffer;
    }

    protected void replace(int position, int rmSize, Object addItems, int addSize) {
        if (this.gapStart != position) {
            this.shiftGap(position);
        }
        if (rmSize > 0) {
            this.shiftGapEndUp(this.gapEnd + rmSize);
        }
        if (this.gapEnd - this.gapStart <= addSize) {
            this.shiftEnd((addSize - this.gapEnd + this.gapStart + 1) * 2 + this.gapEnd + 10);
        }
        if (addItems != null) {
            System.arraycopy(addItems, 0, this.buffer, this.gapStart, addSize);
            this.gapStart += addSize;
        }
    }

    protected final int getGapStart() {
        return this.gapStart;
    }

    protected final int getGapEnd() {
        return this.gapEnd;
    }

    protected Vector getPositionsInRange(Vector v, int offset, int length) {
        Vector res = v;
        if (res == null) {
            res = new Vector();
        } else {
            res.clear();
        }
        int endOffset = offset + length;
        int index1 = Collections.binarySearch(this.positions, new GapContentPosition(offset));
        if (index1 < 0) {
            index1 = -(index1 + 1);
        }
        ListIterator i = this.positions.listIterator(index1);
        while (i.hasNext()) {
            GapContentPosition p = (GapContentPosition)i.next();
            if (p.mark > endOffset) break;
            if (p.mark < offset || p.mark > endOffset) continue;
            res.add(p);
        }
        return res;
    }

    void setPositionsInRange(int offset, int length, int value) {
        int endOffset = offset + length;
        int index1 = Collections.binarySearch(this.positions, new GapContentPosition(offset));
        if (index1 < 0) {
            index1 = -(index1 + 1);
        }
        ListIterator i = this.positions.listIterator(index1);
        while (i.hasNext()) {
            GapContentPosition p = (GapContentPosition)i.next();
            if (p.mark > endOffset) break;
            if (p.mark < offset || p.mark > endOffset) continue;
            p.mark = value;
        }
    }

    void adjustPositionsInRange(int offset, int length, int incr) {
        int endOffset = offset + length;
        int index1 = Collections.binarySearch(this.positions, new GapContentPosition(offset));
        if (index1 < 0) {
            index1 = -(index1 + 1);
        }
        ListIterator i = this.positions.listIterator(index1);
        while (i.hasNext()) {
            GapContentPosition p = (GapContentPosition)i.next();
            if (p.mark > endOffset) break;
            if (p.mark < offset || p.mark > endOffset) continue;
            p.mark += incr;
        }
    }

    protected void resetMarksAtZero() {
        if (this.gapStart != 0) {
            return;
        }
        this.setPositionsInRange(this.gapEnd, 0, 0);
    }

    private final void dump() {
        System.err.println("GapContent debug information");
        System.err.println("buffer length: " + this.buffer.length);
        System.err.println("gap start: " + this.gapStart);
        System.err.println("gap end: " + this.gapEnd);
        int i = 0;
        while (i < this.buffer.length) {
            if (i == this.gapStart) {
                System.err.print('<');
            }
            if (i == this.gapEnd) {
                System.err.print('>');
            }
            if (!Character.isISOControl(this.buffer[i])) {
                System.err.print(this.buffer[i]);
            } else {
                System.err.print('.');
            }
            ++i;
        }
        System.err.println();
    }

    private final void dumpPositions() {
        Iterator i = this.positions.iterator();
        while (i.hasNext()) {
            GapContentPosition pos = (GapContentPosition)i.next();
            System.err.println("position at: " + pos.mark);
        }
    }

    public GapContent() {
        this(10);
    }

    public GapContent(int size) {
        this.buffer = (char[])this.allocateArray(size);
        this.gapStart = 1;
        this.gapEnd = size;
        this.buffer[0] = 10;
        this.positions = new ArrayList();
    }

    static {
        assert = Class.forName("[Ljavax.swing.text.GapContent;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UndoInsertString
    extends AbstractUndoableEdit {
        public int where;
        public int length;
        String text;

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.text = GapContent.this.getString(this.where, this.length);
                GapContent.this.remove(this.where, this.length);
            }
            catch (BadLocationException ble) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                GapContent.this.insertString(this.where, this.text);
            }
            catch (BadLocationException ble) {
                throw new CannotRedoException();
            }
        }

        public UndoInsertString(int start, int len) {
            this.where = start;
            this.length = len;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UndoRemove
    extends AbstractUndoableEdit {
        public int where;
        String text;

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                GapContent.this.insertString(this.where, this.text);
            }
            catch (BadLocationException ble) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                GapContent.this.remove(this.where, this.text.length());
            }
            catch (BadLocationException ble) {
                throw new CannotRedoException();
            }
        }

        public UndoRemove(int start, String removedText) {
            this.where = start;
            this.text = removedText;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GapContentPosition
    implements Position,
    Comparable {
        int mark;
        private static final /* synthetic */ boolean assert;

        public int compareTo(Object o) {
            if (o instanceof Integer) {
                int otherMark = (Integer)o;
                return this.mark - otherMark;
            }
            GapContentPosition other = (GapContentPosition)o;
            return this.mark - other.mark;
        }

        public int getOffset() {
            if (!assert && this.mark > GapContent.this.gapStart && this.mark < GapContent.this.gapEnd) {
                throw new AssertionError((Object)("mark: " + this.mark + ", gapStart: " + GapContent.this.gapStart + ", gapEnd: " + GapContent.this.gapEnd));
            }
            if (this.mark <= GapContent.this.gapStart) {
                return this.mark;
            }
            return this.mark - (GapContent.this.gapEnd - GapContent.this.gapStart);
        }

        GapContentPosition(int mark) {
            this.mark = mark;
        }

        static {
            assert = Class.forName("[Ljavax.swing.text.GapContent;").getComponentType().desiredAssertionStatus() ^ true;
        }
    }
}

