/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts.compound;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.counts.compound.CompoundDataOutput;
import org.campagnelab.goby.counts.compound.CompoundDirectoryEntry;
import org.campagnelab.goby.counts.compound.CompoundFileReader;

public class CompoundFileWriter
implements Closeable {
    private static final Log LOG = LogFactory.getLog(CompoundFileWriter.class);
    private RandomAccessFile stream;
    private long totalNumberOfFiles;
    public static final int FILE_STATE_NORMAL = 0;
    public static final int FILE_STATE_DELETED = 1;
    private final CompoundFileReader compoundFileReader;
    private final String filename;
    private CompoundDirectoryEntry entryBeingAdded = null;

    public CompoundFileWriter(String physicalFilename) throws IOException {
        this.filename = physicalFilename;
        this.stream = new RandomAccessFile(new File(physicalFilename), "rw");
        this.compoundFileReader = new CompoundFileReader(physicalFilename);
        this.stream.seek(0L);
        if (this.stream.length() == 0L) {
            this.stream.writeLong(0L);
            this.totalNumberOfFiles = 0L;
        } else {
            this.totalNumberOfFiles = this.stream.readLong();
        }
    }

    public CompoundFileReader getCompoundFileReader() {
        return this.compoundFileReader;
    }

    public CompoundDataOutput addFile(String name) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("CompoundFileWriter is not open.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("The name specified was null or empty.");
        }
        if (this.entryBeingAdded != null) {
            throw new IllegalStateException("addFile() called during before close() called on current addFile()");
        }
        if (this.compoundFileReader.containsFile(name)) {
            throw new IOException("The compound file " + this.filename + " already contains a file named " + name);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding a new file named " + name));
        }
        ++this.totalNumberOfFiles;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Seeking to 0 to write new totalNumberOfFiles " + this.totalNumberOfFiles));
        }
        this.stream.seek(0L);
        this.stream.writeLong(this.totalNumberOfFiles);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Seeking to " + this.stream.length()));
        }
        long fileStartPosition = this.stream.length();
        this.stream.seek(fileStartPosition);
        this.stream.writeInt(0);
        this.stream.writeUTF(name);
        this.stream.writeLong(0L);
        long dataStartPosition = this.stream.length();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Data starting at " + this.stream.length()));
        }
        this.entryBeingAdded = new CompoundDirectoryEntry(name, fileStartPosition, dataStartPosition);
        return new CompoundDataOutput(this.stream, this);
    }

    public void deleteFile(String name) throws IOException {
        if (this.entryBeingAdded != null) {
            throw new IllegalStateException("deleteFile() called during before close() called on current addFile()");
        }
        CompoundDirectoryEntry entry = this.compoundFileReader.getDirectoryEntry(name);
        if (entry != null) {
            long position = entry.getStartPosition();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Marking file deleted at position " + position));
            }
            this.stream.seek(position);
            this.stream.writeInt(1);
            this.compoundFileReader.removeFromDirectory(name);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Not deleting, not in compound file");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.finishAddFile();
            this.stream.close();
            this.stream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishAddFile() throws IOException {
        if (this.entryBeingAdded == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"skipping finish add...");
            }
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"running finish add...");
            }
            long dataSize = this.stream.length() - this.entryBeingAdded.getDataPosition();
            this.entryBeingAdded.setFileSize(dataSize);
            if (dataSize > 0L) {
                long dataSizePosition = this.entryBeingAdded.getDataPosition() - 8L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("++ data size was " + dataSize + " writing at position " + dataSizePosition));
                }
                this.stream.seek(dataSizePosition);
                this.stream.writeLong(dataSize);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"++ ZERO data size.");
            }
            this.compoundFileReader.addToDirectory(this.entryBeingAdded);
        }
        finally {
            this.entryBeingAdded = null;
        }
    }
}

